<?php $this->view("includes/Inc_pagehead"); ?>
<!-- Page Styles Goes Here-->

<?php $this->view("includes/Inc_navigation"); ?>
<div class="m-grid__item m-grid__item--fluid m-wrapper">
  <!-- BEGIN: Subheader -->
  <div class="m-subheader ">
    <div class="d-flex align-items-center">
      <div class="mr-auto">
        <h3 class="m-subheader__title m-subheader__title--separator">
          Work Orders
        </h3>
        <ul class="m-subheader__breadcrumbs m-nav m-nav--inline">
          <li class="m-nav__item m-nav__item--home">
            <a href="#" class="m-nav__link m-nav__link--icon">
              <i class="m-nav__link-icon la la-home"></i>
            </a>
          </li>
          <li class="m-nav__separator">
            -
          </li>
          <li class="m-nav__item">
            <a href="<?php echo $this->session->userdata("dashboard_link") ?>" class="m-nav__link">
              <span class="m-nav__link-text">
                Home
              </span>
            </a>
          </li>
          <li class="m-nav__separator">
            -
          </li>
          <li class="m-nav__item">
            <a href="<?php echo base_url() . 'work_order' ?>" class="m-nav__link">
              <span class="m-nav__link-text">
                Work Orders
              </span>
            </a>
          </li>


        </ul>
      </div>
      <div>

      </div>
    </div>
  </div>
  <!-- END: Subheader -->
  <div class="m-content">
    <div class="m-portlet m-portlet--mobile m-portlet--info m-portlet--head-solid-bg m-portlet--bordered m-portlet--rounded">
      <div class="m-portlet__head">
        <div class="m-portlet__head-caption">
          <div class="m-portlet__head-title">
            <h3 class="m-portlet__head-text">
              List of Work Orders
            </h3>
          </div>
        </div>
        <div class="m-portlet__head-tools">

          <?php if ($this->session->userdata('user_role') != 'auditor') { ?>
            <a href="<?php echo base_url() ?>work_order/add" class="btn btn-focus m-btn m-btn--custom m-btn--icon m-btn--air m-btn--pill">
              <span>
                <i class="la la-plus"></i>
                <span>
                  Create New Work Order
                </span>
              </span>
            </a>
          <?php } ?>

        </div>
      </div>
      <div class="m-portlet__body">

        <?php if (!empty($this->config->item('company_branches'))) { ?>
          <div class="m-form m-form--label-align-right m--margin-bottom-10">
            <div class="row">
              <div class="col-xl-12 order-2 order-xl-1">
                <div class="form-group m-form__group row ">
                  <div class="col-lg-3">
                    <div class="form-group m-form__group">
                      <label>
                        Company Branch
                      </label>
                      <div class="m-select2 m-select2--air m-select2--pill">
                        <select width="100%" required class="form-control m-select2 table_filter company-branch-select2" id="company_branch">
                          <option selected value="all"> All Branches</option>
                          <option value="0">NO BRANCH</option>
                          <?php foreach ($this->config->item('company_branches') as $key => $value) { ?>
                            <option value="<?php echo $value->branch_id ?>"><?php echo $value->branch_name ?></option>
                          <?php } ?>
                        </select>
                      </div>
                      <span class="m-form__help"></span>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        <?php } ?>

        <table width="100%" class="table m-table nowrap table-header-fixed table-striped table-bordered table-hover table-header-fixed" id="work_order_view_table">
          <thead>
            <tr class="">
              <th>Sl No</th>
              <th>Branch</th>
              <th>ID</th>
              <th>Work Order No</th>
              <th>Quotation No</th>
              <th>Project Name</th>
              <th>Customer Name</th>
              <th>Address</th>
              <th>Wok Order Date</th>
              <th>Project Start Date</th>
              <th>Quoted Price</th>
              <th><?php if ($this->config->item('Work_order_template') == 1) { ?>Prepared By<?php } ?><?php if ($this->config->item('Work_order_template') == 2) { ?>Site Coordinator<?php } ?></th>
              <th>Creation</th>
              <th>Actions</th>
            </tr>
          </thead>
          <tbody>
          </tbody>
        </table>
        <div class="modal fade" tabindex="-1" id="order_approve_modal" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
          <div class="modal-dialog " role="document">
            <form autocomplete="off" method="post" data-modal-id="order_approve_modal" id="form_order_approve" action="<?php echo base_url() . 'work_order/approve' ?>" class="form-horizontal">
              <div class="modal-content">
                <div class="alert alert-info" role="alert" style="margin-bottom: 0px">
                  <button type="button" class="close" data-dismiss="modal"></button>
                  <br />
                  <h4 class="alert-heading">Warning! Please Confirm Your Action</h4>
                  <br />
                  <div class="alert m-alert--default" role="alert" style="margin-bottom: 10px">
                    <div class="form-group m-form__group">
                      <label for="user_name" style="color: black">Approval Status</label>
                      <div class="m-radio-inline" style="padding-top: 10px;">
                        <label class="m-radio m-radio--solid m-radio--state-success">
                          <input required type="radio" class="form_fields_radio" name="order_approval_status" value="1"> Approved
                          <span></span>
                        </label>
                        <label class="m-radio m-radio--solid m-radio--state-danger">
                          <input type="radio" class="form_fields_radio" name="order_approval_status" value="2"> Rejected
                          <span></span>
                        </label>
                      </div>
                      <span class="m-form__help"></span>
                    </div>
                    <div class="form-group m-form__group">
                      <label for="user_name">
                        Remarks
                      </label>
                      <div class="input-group m-input-group m-input-group--pill m-input-group--air">
                        <textarea type="text" rows="3" name="remarks" id="order_approval_remarks" class="form-control m-input form_order_approve_fields" placeholder="Remarks " aria-describedby="basic-addon1"></textarea>
                      </div>
                      <span class="m-form__help"></span>
                    </div>
                  </div>
                  <p>
                    <button class="btn btn-danger form_submit_btn" type="submit" name="submit">Confirm & Proceed</button>
                    <button type="button" class="btn btn-primary modal-dismiss" data-dismiss="modal">Cancel</button>
                  </p>
                  <input type="hidden" name="order_id" id="order_id_appoval">
                </div>
              </div>
            </form>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>
</div>
<!-- end:: Body -->
<!-- begin::Footer -->

<?php $this->view("includes/Inc_footer"); ?>
<!-- end::Footer -->
</div>
<!-- end:: Page -->

<?php $this->view("includes/Inc_sidebar"); ?>
<?php $this->view("includes/Inc_scripts"); ?>
<!--begin::Page Snippets -->

<script>
  $("#work_order_menu").addClass('m-menu__item--active m-menu__item--open');
  $("#work_order_menu_2").addClass('m-menu__item--active');
</script>
<script>
  $('body').on('click', '#btn_approve_quotation', function() {
    var no = $(this).closest('tr').children('td');
    $('#order_id_appoval').val(no.eq(1).text());
    var approval_status = no.eq(12).text();
    $("input[name=order_approval_status][value=" + approval_status + "]").prop('checked', true);
    $('#order_approval_remarks').val(no.eq(13).text());
  })
  var Datatable_work_order_view_table = function() {

      function get_branch_id() {
        return $('#company_branch :selected').val();
      }

      var t = function() {
        var work_order_view_table = $('#work_order_view_table').DataTable({
          "ajax": {
            url: "<?php echo base_url() . 'work_order/select_work_order' ?>", // json datasource
            type: "post", // type of method  , by default would be get
            data: function(d) {
              <?php if (!empty($this->config->item('company_branches'))) { ?>
                d.branch_id = get_branch_id();
              <?php } ?>
            }
          },
          "bProcessing": true,
          "deferRender": true,
          "bDeferRender": true,
          "scrollX": true,
          buttons: [{
              extend: 'print',
              className: 'btn dark btn-outline',
              title: 'Work Orders'
            },
            {
              extend: 'csv',
              className: 'btn purple btn-outline '
            },
            {
              extend: 'colvis',
              className: 'btn dark btn-outline',
              text: 'Columns'
            }
          ],
          dom: "<'row'<'col-sm-6 text-left'B><'col-sm-6 text-right'f>>\n\t\t\t<'row'<'col-sm-12'tr>>\n\t\t\t<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 dataTables_pager'lp>>", // horizobtal scrollable datatable
          "lengthMenu": [
            [25, 50, 100, -1],
            [25, 50, 100, "All"] // change per page values here
          ],
          "columnDefs": [{
              "targets": [2 <?php if ($this->config->item('Work_order_template') == 1) {
                              echo ",9";
                            } ?> <?php if (empty($this->config->item('company_branches'))) { echo ",1"; }?> ],
              className: "hidden"
            },
            {
              // render: function (data, type, full, meta) {
              //   return "<div class='text-wrap width-300'>" + data + "</div>";
              // },
              // targets: 5
            }
          ],
          'order': false
        });
        $(".table_filter").on("change", function() {
          work_order_view_table.ajax.reload();
        });

      };
      return {
        init: function() {
          t()
        }
      }
    }
    ();
  jQuery(document).ready(function() {
    Datatable_work_order_view_table.init();
    $(".form_submit_btn").click(function(e) {

      e.preventDefault();
      var a = $(this),
        l = $(this).closest("form"),
        action = l.attr('action');
      var form_id = l.attr('id');
      l.validate({
        rules: {
          "amount": {
            required: !0,
            number: !0
          }
        },
        invalidHandler: function(e, r) {
          var i = $("#" + form_id + "_msg");
          i.removeClass("m--hide").show(), mUtil.scrollTo(i, -200)
        },
        submitHandler: function(e) {}
      }), l.valid() && (a.addClass("m-loader m-loader--right m-loader--light").attr("disabled", !0),
        l.ajaxSubmit({
          url: action,
          success: function(e, t, r, s) {
            var modal_id = l.attr('data-modal-id');
            var form_type = l.attr('data-form-type');
            $("#" + form_id + "_msg").addClass("m--hide");
            // Block UI
            mApp.blockPage({
              overlayColor: "#000000",
              type: "loader",
              state: "success",
              message: "Please wait..."
            }), setTimeout(function() {
              mApp.unblockPage()
            }, 2e3);
            var obj = $.parseJSON(e);
            if (obj.status == 1) {
              a.removeClass("m-loader m-loader--right m-loader--light").attr("disabled", !1);
              toastr[obj.flashdata_type](obj.flashdata_msg, obj.flashdata_title);
              $("#" + modal_id).modal('toggle');
              $("." + form_id + "_fields").val('');
              $('#work_order_view_table').dataTable().fnDestroy();
              Datatable_work_order_view_table.init();
            } else {
              a.removeClass("m-loader m-loader--right m-loader--light").attr("disabled", !1);
              toastr[obj.flashdata_type](obj.flashdata_msg, obj.flashdata_title);
            }
            if (obj == null) {
              setTimeout(function() {
                a.removeClass("m-loader m-loader--right m-loader--light").attr("disabled", !1);
                toastr["warning"]("Your Attempt is Timed Out. Please Try Again.", "Timed Out");
              }, 2e4)
            }
          },
          error: function() {
            a.removeClass("m-loader m-loader--right m-loader--light").attr("disabled", !1);
            toastr["error"]("Sorry. There Has Been Some Error Occurred. Please Try Again.", "Error");
          }
        })
      )
    });
  });
</script>
