<?php $this->view("includes/Inc_pagehead"); ?>
<!-- Page Styles Goes Here-->
<style>
.item_table td {
  padding: .75rem !important;
}

.item_table th {
  white-space: nowrap;
  padding: .75rem !important;
}

.table thead th {
  border-top: 2px solid #f4f5f8 !important;
}

.payment-table tbody td {
  border-top: 2px solid #f4f5f8 !important;
}

.m-invoice-2 .m-invoice__wrapper .m-invoice__head .m-invoice__container.m-invoice__container--centered {
  width: 90% !important;
}

.m-invoice-2 .m-invoice__wrapper .m-invoice__body.m-invoice__body--centered {
  width: 90% !important;
}

.holder {
  height: 100px;
  width: 100px;
  border: 2px solid black;
}

.holder img {
  max-width: 100px;
  max-height: 100px;
  min-width: 100px;
  min-height: 100px;
}
</style>
<?php $this->view("includes/Inc_navigation"); ?>
<div class="m-grid__item m-grid__item--fluid m-wrapper">
  <!-- BEGIN: Subheader -->
  <div class="m-subheader ">
    <div class="d-flex align-items-center">
      <div class="mr-auto">
        <h3 class="m-subheader__title m-subheader__title--separator">
          Work Order
        </h3>
        <ul class="m-subheader__breadcrumbs m-nav m-nav--inline">
          <li class="m-nav__item m-nav__item--home">
            <a href="#" class="m-nav__link m-nav__link--icon">
              <i class="m-nav__link-icon la la-home"></i>
            </a>
          </li>
          <li class="m-nav__separator">
            -
          </li>
          <li class="m-nav__item">
            <a href="<?php echo base_url() . 'dashboard' ?>" class="m-nav__link">
              <span class="m-nav__link-text">
                Home
              </span>
            </a>
          </li>
          <li class="m-nav__separator">
            -
          </li>
          <li class="m-nav__item">
            <a href="<?php echo base_url() . 'work_order' ?>" class="m-nav__link">
              <span class="m-nav__link-text">
                Work Order
              </span>
            </a>
          </li>
        </ul>
      </div>
      <div></div>
    </div>
  </div>
  <!-- END: Subheader -->
  <div class="m-content">

    <form autocomplete="off" id="form_work_order_add" data-form-type="work_order_create" method="post" action="<?php echo base_url() ?>work_order/update_2" enctype="multipart/form-data" class="m-form m-form--fit m-form--state m-form--label-align-right ">
      <div class="m-portlet m-portlet--full-height">
        <div class="m-portlet__head">
          <div class="m-portlet__head-caption">
            <div class="m-portlet__head-title">
              <h3 class="m-portlet__head-text">
                Add/Edit Work Order - Step 2/2 <?php if(!empty($quotation_data)){ echo " [ Created From Quotation #".$quotation_data->quotation_id." ]";}?>
              </h3>
            </div>
          </div>
        </div>
        <div class="m-portlet__body m-portlet__body--no-padding">
          <div class="m-wizard m-wizard--1 m-wizard--success" id="m_wizard">
          <div class="m-wizard__head m-portlet__padding-x">

            <!--begin: Form Wizard Progress -->
            <div class="m-wizard__progress">
              <div class="progress">
                <div class="progress-bar" style="width:100%" role="progressbar" aria-valuenow="100" aria-valuemin="0" aria-valuemax="100"></div>
              </div>
            </div>

            <!--end: Form Wizard Progress -->

            <!--begin: Form Wizard Nav -->
            <div class="m-wizard__nav">
              <div class="m-wizard__steps">
                <div class="m-wizard__step " m-wizard-target="m_wizard_form_step_1">
                  <div class="m-wizard__step-info">
                    <a href="#" class="m-wizard__step-number">
                      <span><span>1</span></span>
                    </a>
                    <div class="m-wizard__step-line">
                      <span></span>
                    </div>
                    <div class="m-wizard__step-label">
                      Customer & Work Order Information
                    </div>
                  </div>
                </div>
                <div class="m-wizard__step m-wizard__step--current" m-wizard-target="m_wizard_form_step_2">
                  <div class="m-wizard__step-info">
                    <a href="#" class="m-wizard__step-number">
                      <span><span>2</span></span>
                    </a>
                    <div class="m-wizard__step-line">
                      <span></span>
                    </div>
                    <div class="m-wizard__step-label">
                      Items & Order Value
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
          </div>
          <div class="" style="padding: 30px">
            <div class="m-invoice__wrapper">
              <div class="m-invoice__head">
                <div class="m-invoice__container m-invoice__container--centered">
                  <div class="m-invoice__logo" style="padding-top: 0rem;">
                    <a href="#">
                    </a>
                  </div>
                </div>
              </div>
              <div class="m-invoice__body m-invoice__body--centered" style="min-height: 200px">
                <div style="text-align:right;margin-bottom:20px">
                  <a style="margin-left: 5px;margin-right: 5px"  href="#add_work_cat_modal" data-toggle="modal" class="btn btn-info m-btn m-btn--icon  m-btn--pill m-btn--air">
                    <i class="fa fa-plus-circle"></i> Add Work Type
                  </a>
                  <a style="margin-left: 5px;margin-right: 5px"  id="btn_add_item" href="#item_add_modal" data-toggle="modal" class="btn btn-focus m-btn m-btn--icon  m-btn--pill m-btn--air">
                    <i class="fa fa-plus-circle"></i> Add Item
                  </a>
                </div>
                <div style="background: white;border: 4px solid #f7f7fa;padding: 15px;margin: 5px;padding-bottom: 0px">
                  <div class="m-section" style="margin-bottom: 10px">
                    <h3 class="m-section__heading">Items</h3>
                    <div class="">
                      <table class="table m-table nowrap table-header-fixed table-striped table-bordered table-hover table-header-fixed" id="table_items_list">
                        <thead>
                          <tr>
                            <th>Sl No</th>
                            <th>Description</th>
                            <th><?php echo $this->config->item('Client_Payment_invoice_item_code_title')?></th>
                            <th>Qty</th>
                            <th>Unit</th>
                            <th>Unit Rate<?php if($this->config->item('Quotation_rate_type')=='supply_installation'){ echo '<br/>Supply';}?></th>
                            <th>Unit Rate<?php if($this->config->item('Quotation_rate_type')=='supply_installation'){ echo '<br/>Installation';}?></th>
                            <th>Total</th>
                            <th>Actions</th>
                            <th>Total</th>
                            <th>Unit</th>
                            <th>Work Type ID</th>
                            <th>Description</th>
                            <th>Item type</th>
                          </tr>
                        </thead>
                        <tbody id="item_table_body">

                        </tbody>
                      </table>
                    </div>
                  </div>
                </div>
                <div style="background: white;border: 4px solid #f7f7fa;padding: 15px;margin: 5px;padding-bottom: 0px">
                  <div class="m-section" style="margin-bottom: 10px">
                    <h3 class="m-section__heading">Item Summary</h3>
                    <div class="">
                      <table class="table m-table table-bordered item_table">
                        <thead>
                          <tr>
                            <th style="width: 16%;text-align:left">Total Amount</th>
                            <th style="width: 16%;text-align:left">Discount Amount</th>
                            <th style="width: 16%;text-align:left">Taxable Amount</th>
                            <th style="width: 16%;text-align:left"><?php echo $this->config->item('Tax_tax_name')?> %</th>
                            <th style="width: 16%;text-align:left">Tax Amount</th>
                            <th style="width: 16%;text-align: left">
                              NET Total Amount
                            </th>
                          </tr>
                        </thead>
                        <tbody>
                          <tr>
                            <td>
                              <input required type="text" required readonly name="grand_total_amount" id="grand_total_amount" class="form-control m-input m-input--air m-input--pill" value="0" placeholder="" >
                            </td>
                            <td>
                              <input required type="text" required name="discount_amount" id="discount_amount" class="form-control m-input m-input--air m-input--pill" value="0" placeholder="" >
                            </td>
                            <td>
                              <input required type="text" required readonly name="total_taxable_amount" id="total_taxable_amount" class="form-control m-input m-input--air m-input--pill" value="0" placeholder="" >
                            </td>
                            <td><select required id="tax_percent" name="tax_percent" style="width: 100%" class="form-control m-bootstrap-select m-bootstrap-select--air m-bootstrap-select--pill m_selectpicker item_tax_percent">
                              <?php
                              $tax_percent = $this->config->item('Tax_tax_percent');
                              foreach($tax_percent as $row){
                                $selected_tax='';
                                if($row->tax_percentage==0){
                                  $selected_tax='selected';
                                }
                                ?>
                                <option <?php echo $selected_tax?> data-tax-percent="<?php echo $row->tax_percentage?>" value="<?php echo $row->tax_id?>"><?php echo $row->tax_name?></option>
                                <?php
                              }
                              ?>
                            </select>
                          </td>
                          <td>
                            <input required type="text" required readonly name="total_tax_amount" id="total_tax_amount" class="form-control m-input m-input--air m-input--pill" value="0" placeholder="" >
                          </td>
                          <td>
                            <input required type="text" required readonly name="net_total_amount" id="net_total_amount" class="form-control m-input m-input--air m-input--pill" value="0" placeholder="" >
                          </td>
                        </tr>
                      </tbody>
                    </table>
                  </div>
                  <input type="hidden" name="current_row_count" id="current_row_count" value="0">
                  <input type="hidden" name="work_order_id" value="<?= $work_order_data->order_id ?>">
                  <input type="hidden" name="redirect_url" value="<?php echo base_url(uri_string())?>" >
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
      <div class="m-portlet__foot m-portlet__foot--fit">
        <div class="m-form__actions m-form__actions">
          <div class="row">
            <div class="col-lg-3 ml-lg-auto" style="border-right: 1px solid #ebedf2;">
              <button type="submit" class="btn btn-primary form_submit_btn_3">
                Save & Update Work Order
              </button>
            </div>
          </div>
        </div>
      </div>
    </div>
  </form>

</div>

<div class="modal fade modals_reset"  id="add_work_cat_modal" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog " role="document" style="max-width: 800px">
    <div class="modal-content">
      <div class="modal-header" style="background-color: #36a3f7;border-radius: 4px">
        <h5 class="modal-title" id="exampleModalLabel" style="color: #ffffff" >
          Add New Work Type
        </h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">
            &times;
          </span>
        </button>
      </div>
      <form autocomplete="off" id="form_work_cat_add" data-modal-id="add_work_cat_modal" method="post"  action="<?= base_url()?>work_order/create_work_type" enctype="multipart/form-data" id="form_add_cat" class="form_post m-form m-form--fit m-form--state m-form--label-align-right " >
        <div class="modal-body">
          <div class="m-form__content">
            <div class="m-alert m-alert--icon alert alert-warning m--hide" role="alert" id="form_work_cat_add_msg">
              <div class="m-alert__icon">
                <i class="la la-warning"></i>
              </div>
              <div class="m-alert__text">
                Oh snap! Change a few things up and try submitting again.
              </div>
              <div class="m-alert__close">
                <button type="button" class="close" data-close="alert" aria-label="Close"></button>
              </div>
            </div>
          </div>
          <div class="row">
            <div class="col-lg-12" >
              <div class="form-group m-form__group">
                <label for="user_name">
                  Work Type
                </label>
                <div class="input-group m-input-group m-input-group--pill">
                  <div class="input-group-prepend">
                    <a href="#work_type_add_modal"   data-toggle="modal" data-target="#work_type_add_modal" class="btn btn-focus">
                      <i class="fa fa-plus-circle"></i>
                    </a>
                  </div>
                  <select required id="work_order_work_type_add" name="work_type" style="width: 90%" class="form-control m-select2 form_work_cat_add_select" data-placeholder="Select Work">
                  </select>
                </div>
                <span class="m-form__help"></span>
              </div>
            </div>
            <input type="hidden" name="work_order_id" value="<?= $work_order_data->order_id ?>">
            <input type="hidden" name="redirect_url" value="<?php echo base_url(uri_string())?>" >
          </div>
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-secondary" data-dismiss="modal">
            Close
          </button>
          <button type="submit" class="btn btn-primary">
            Add
          </button>
        </div>
      </form>
    </div>
  </div>
</div>

<div class="modal fade" tabindex="-1" id="item_add_modal" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog " role="document" style="max-width: 850px">
    <div class="modal-content">
      <div class="modal-header" style="background-color: #36a3f7;border-radius: 4px">
        <h5 class="modal-title" id="exampleModalLabel" style="color: #ffffff" >
          Add New Item
        </h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">
            &times;
          </span>
        </button>
      </div>
      <form autocomplete="off"  id="form_item_add" data-form-type="item_add" data-modal-id="item_add_modal" method="post" action="<?php echo base_url().'work_order/create_item'?>" enctype="multipart/form-data" class="form_post m-form m-form--fit m-form--state m-form--label-align-right " >
        <div class="modal-body">
          <div class="m-form__content">
            <div class="m-alert m-alert--icon alert alert-warning m--hide" role="alert" id="form_item_add_msg">
              <div class="m-alert__icon">
                <i class="la la-warning"></i>
              </div>
              <div class="m-alert__text">
                Oh snap! Change a few things up and try submitting again.
              </div>
              <div class="m-alert__close">
                <button type="button" class="close" data-close="alert" aria-label="Close"></button>
              </div>
            </div>
          </div>
          <div class="row">
            <div class="col-md-9">
              <div class="form-group m-form__group">
                <label for="user_name">
                  Work Type
                </label>
                <div class="m-select2 m-select2--air m-select2--pill">
                  <select style="width:100%"  class="form-control form_quotation_task_add_select m-input select2" id="item_work_type_add" name="work_type_id" aria-required="true" tabindex="-1"   aria-describedby="work_id-error">

                  </select>
                </div>
                <span class="m-form__help"></span>
              </div>
            </div>
            <div class="col-lg-3">
              <div class="form-group m-form__group">
                <label for="user_name">
                  <?php echo $this->config->item('Client_Payment_invoice_item_code_title')?>
                </label>
                <input  type="text" name="item_code" class="form_quotation_task_add_fields form-control m-input m-input--air m-input--pill" id="item_code_add" placeholder="<?php echo $this->config->item('Client_Payment_invoice_item_code_title')?>" >
              </div>
            </div>
            <div class="col-lg-12">
              <div class="form-group m-form__group">
                <label>
                  Item Type
                </label>
                <div class="m-radio-inline" style="padding-top: 10px;">
                  <label class="m-radio m-radio--solid m-radio--state-info">
                    <input required type="radio" class="form_fields_radio" checked name="item_type" value="task"> Work Item
                    <span></span>
                  </label>
                  <label class="m-radio m-radio--solid m-radio--state-success">
                    <input type="radio" class="form_fields_radio" name="item_type"  value="description"> Work Description
                    <span></span>
                  </label>
                </div>
                <span class="m-form__help"></span>
              </div>
            </div>
            <div class="col-lg-12">
              <div class="form-group m-form__group">
                <label for="user_name" id="description_title_add">
                  Item Description
                </label>
                <div class="input-group m-input-group m-input-group--pill m-input-group--air">
                  <textarea rows="5" required name="item_description"  id="item_description_add" class="form-control m-input m-input--air m-input--pill" placeholder="Description" ></textarea>
                </div>
                <span class="m-form__help"></span>
              </div>
            </div>
          </div>
          <div class="row task_fields_div_add">
            <div class="col-lg-3 ">
              <div class="form-group m-form__group">
                <label for="user_name">
                  Measure Unit
                </label>
                <div class="m-select2 m-select2--air m-select2--pill">
                  <select style="width:100%"  required="" class="task_fields_add form-control form_quotation_task_add_select m-input" id="item_unit_add" name="item_unit" aria-required="true" tabindex="-1"   aria-describedby="">

                  </select>
                </div>
                <span class="m-form__help"></span>
              </div>
            </div>
            <div class="col-lg-3">
              <div class="form-group m-form__group">
                <label for="user_name">
                  Unit Rate <?php if($this->config->item('Quotation_rate_type')=='supply_installation'){ echo "(Supply)";}?>
                </label>
                <input  type="text" required name="item_unit_price" class="task_fields_add form-control item_rate_fields_add m-input m-input--air m-input--pill numeric_fields" id="item_unit_price_add" placeholder="Unit Price" >
              </div>
            </div>
            <?php if($this->config->item('Quotation_rate_type')=='supply_installation'){?>
              <div class="col-lg-3">
                <div class="form-group m-form__group">
                  <label for="user_name">
                    Unit Rate (Installation)
                  </label>
                  <input  type="text" required name="item_unit_price_2" class="task_fields_add form-control item_rate_fields_add m-input m-input--air m-input--pill numeric_fields" id="item_unit_price_2_add" placeholder="Unit Price" >
                </div>
              </div>
            <?php } ?>
            <div class="col-lg-3">
              <div class="form-group m-form__group">
                <label for="user_name">
                  Quantity
                </label>
                <input  type="text" required name="item_qty" class="task_fields_add form-control item_rate_fields_add m-input m-input--air m-input--pill numeric_fields" id="item_qty_add" placeholder="Quantity" >
              </div>
            </div>
            <?php if($this->config->item('Quotation_rate_type')=='supply_installation'){?>
            </div>
            <div class="row task_fields_div_add">
              <div class="col-md-9"></div>
            <?php } ?>
            <div class="col-lg-3">
              <div class="form-group m-form__group">
                <label for="user_name">
                  Total Amount
                </label>
                <input  type="text" required name="item_total" readonly id="item_total_add" class="task_fields_add form-control item_amount_field m-input m-input--air m-input--pill"  placeholder="Total Amount" >
              </div>
            </div>
          </div>
            <input type="hidden" name="work_order_id" value="<?= $work_order_data->order_id ?>">
          <input type="hidden" name="redirect_url" value="<?php echo base_url(uri_string())?>" >
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-secondary" data-dismiss="modal">
            Close
          </button>
          <button type="submit" class="btn btn-primary">
            Save
          </button>
        </div>
      </form>
    </div>
  </div>
</div>
<div class="modal fade" tabindex="-1" id="item_edit_modal" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog " role="document" style="max-width: 850px">
    <div class="modal-content">
      <div class="modal-header" style="background-color: #36a3f7;border-radius: 4px">
        <h5 class="modal-title" id="exampleModalLabel" style="color: #ffffff" >
          Edit Item
        </h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">
            &times;
          </span>
        </button>
      </div>
      <form autocomplete="off"  id="form_item_edit" data-form-type="item_edit" data-modal-id="item_edit_modal" method="post" action="<?php echo base_url().'work_order/update_item'?>" enctype="multipart/form-data" class="form_post m-form m-form--fit m-form--state m-form--label-align-right " >
        <div class="modal-body">
          <div class="m-form__content">
            <div class="m-alert m-alert--icon alert alert-warning m--hide" role="alert" id="form_item_edit_msg">
              <div class="m-alert__icon">
                <i class="la la-warning"></i>
              </div>
              <div class="m-alert__text">
                Oh snap! Change a few things up and try submitting again.
              </div>
              <div class="m-alert__close">
                <button type="button" class="close" data-close="alert" aria-label="Close"></button>
              </div>
            </div>
          </div>
          <div class="row">
            <div class="col-md-9">
              <div class="form-group m-form__group">
                <label for="user_name">
                  Work Type
                </label>
                <div class="m-select2 m-select2--air m-select2--pill">
                  <select style="width:100%"  class="form-control form_quotation_task_edit_select m-input select2" id="item_work_type_edit" name="work_type_id" aria-required="true" tabindex="-1"   aria-describedby="work_id-error">

                  </select>
                </div>
                <span class="m-form__help"></span>
              </div>
            </div>
            <div class="col-lg-3">
              <div class="form-group m-form__group">
                <label for="user_name">
                  <?php echo $this->config->item('Client_Payment_invoice_item_code_title')?>
                </label>
                <input  type="text" name="item_code" class="form_quotation_task_edit_fields form-control m-input m-input--air m-input--pill" id="item_code_edit" placeholder="<?php echo $this->config->item('Client_Payment_invoice_item_code_title')?>" >
              </div>
            </div>
            <div class="col-lg-12">
              <div class="form-group m-form__group">
                <label>
                  Item Type
                </label>
                <div class="m-radio-inline" style="padding-top: 10px;">
                  <label class="m-radio m-radio--solid m-radio--state-info">
                    <input required type="radio" class="form_fields_radio" name="item_type_edit" value="task"> Work Item
                    <span></span>
                  </label>
                  <label class="m-radio m-radio--solid m-radio--state-success">
                    <input type="radio" class="form_fields_radio" name="item_type_edit"  value="description"> Work Description
                    <span></span>
                  </label>
                </div>
                <span class="m-form__help"></span>
              </div>
            </div>
            <div class="col-lg-12">
              <div class="form-group m-form__group">
                <label for="user_name" id="description_title_edit">
                  Item Description
                </label>
                <div class="input-group m-input-group m-input-group--pill m-input-group--air">
                  <textarea rows="5" required name="item_description"  id="item_description_edit" class="form-control m-input m-input--air m-input--pill" placeholder="Description" ></textarea>
                </div>
                <span class="m-form__help"></span>
              </div>
            </div>
          </div>
          <div class="row task_fields_div_edit">
            <div class="col-lg-3">
              <div class="form-group m-form__group">
                <label for="user_name">
                  Measure Unit
                </label>
                <div class="m-select2 m-select2--air m-select2--pill">
                  <select style="width:100%"  required="" class="task_fields_edit form-control form_quotation_task_edit_select m-input" id="item_unit_edit" name="item_unit" aria-required="true" tabindex="-1"   aria-describedby="">

                  </select>
                </div>
                <span class="m-form__help"></span>
              </div>
            </div>
            <div class="col-lg-3">
              <div class="form-group m-form__group">
                <label for="user_name">
                  Unit Rate <?php if($this->config->item('Quotation_rate_type')=='supply_installation'){ echo "(Supply)";}?>
                </label>
                <input  type="text" required name="item_unit_price" class="task_fields_edit form-control item_rate_fields_edit m-input m-input--air m-input--pill numeric_fields" id="item_unit_price_edit" placeholder="Unit Price" >
              </div>
            </div>
            <?php if($this->config->item('Quotation_rate_type')=='supply_installation'){?>
              <div class="col-lg-3">
                <div class="form-group m-form__group">
                  <label for="user_name">
                    Unit Rate (Installation)
                  </label>
                  <input  type="text" required name="item_unit_price_2" class="task_fields_edit form-control item_rate_fields_edit m-input m-input--air m-input--pill numeric_fields" id="item_unit_price_2_edit" placeholder="Unit Price" >
                </div>
              </div>
            <?php } ?>
            <div class="col-lg-3">
              <div class="form-group m-form__group">
                <label for="user_name">
                  Quantity
                </label>
                <input  type="text" required name="item_qty" class="task_fields_edit form-control item_rate_fields_edit m-input m-input--air m-input--pill numeric_fields" id="item_qty_edit" placeholder="Quantity" >
              </div>
            </div>
            <?php if($this->config->item('Quotation_rate_type')=='supply_installation'){?>
            </div>
            <div class="row task_fields_div_edit">
              <div class="col-md-9"></div>
            <?php } ?>
            <div class="col-lg-3">
              <div class="form-group m-form__group">
                <label for="user_name">
                  Total Amount
                </label>
                <input  type="text" required name="item_total" readonly id="item_total_edit" class="task_fields_edit form-control item_amount_field m-input m-input--air m-input--pill"  placeholder="Total Amount" >
              </div>
            </div>
          </div>
            <input type="hidden" name="work_order_id" value="<?= $work_order_data->order_id ?>">
          <input type="hidden" name="item_id" id="item_id_edit">
          <input type="hidden" name="redirect_url" value="<?php echo base_url(uri_string())?>" >
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-secondary" data-dismiss="modal">
            Close
          </button>
          <button type="submit" class="btn btn-primary">
            Save
          </button>
        </div>
      </form>
    </div>
  </div>
</div>
<div class="modal fade modals_reset" tabindex="-1" id="work_order_item_delete_modal" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog " role="document">
    <form autocomplete="off" id="form_work_order_item_delete" data-modal-id="work_order_item_delete_modal" method="post" action="<?= base_url()?>work_order/delete_work_order_item" class="form-horizontal">
      <div class="modal-content">
        <div class="alert alert-danger" role="alert" style="margin-bottom: 0px">
          <button type="button" class="close" data-dismiss="modal"></button>
          <br>
          <h4 class="alert-heading">Warning !</h4>
          <br>
          <p> Are you sure to delete this Item <strong id=""></strong> ? All the data associate with this will Lost. </p>
          <p>
            <button class="btn btn-danger" id="" type="submit" name="submit">Confirm &amp; Delete</button>
            <button type="button" class="btn btn-primary modal-dismiss" data-dismiss="modal">Cancel</button>
          </p>
          <div class="message_log"></div>
          <input type="hidden" name="item_id" id="work_order_item_id_delete">
          <input type="hidden" name="work_order_id" value="<?= $work_order_data->order_id ?>">
          <input type="hidden" name="redirect_url" value="<?php echo base_url(uri_string())?>" >
        </div>
      </div>
    </form>
  </div>
</div>
<div class="modal fade modals_reset" tabindex="-1" id="work_order_work_type_delete_modal" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog " role="document">
    <form autocomplete="off" id="form_work_order_work_type_delete" data-modal-id="work_order_work_type_delete_modal" method="post" action="<?= base_url()?>work_order/delete_work_type" class="form-horizontal">
      <div class="modal-content">
        <div class="alert alert-danger" role="alert" style="margin-bottom: 0px">
          <button type="button" class="close" data-dismiss="modal"></button>
          <br>
          <h4 class="alert-heading">Warning !</h4>
          <br>
          <p> Are you sure to delete this Work Type <strong id=""></strong> ?. </p>
          <p>
            <button class="btn btn-danger" id="" type="submit" name="submit">Confirm &amp; Delete</button>
            <button type="button" class="btn btn-primary modal-dismiss" data-dismiss="modal">Cancel</button>
          </p>
          <input type="hidden" name="work_type_id" id="work_order_work_type_delete">
          <input type="hidden" name="work_order_id" value="<?= $work_order_data->order_id ?>">
          <input type="hidden" name="redirect_url" value="<?php echo base_url(uri_string())?>" >
        </div>
      </div>
    </form>
  </div>
</div>
<?php $this->view("modules/include_modals/modal_work_type_add");?>

</div>
</div>


<!-- end:: Body -->
<!-- begin::Footer -->

<?php $this->view("includes/Inc_footer"); ?>
<!-- end::Footer -->

<!-- end:: Page -->

<?php $this->view("includes/Inc_sidebar"); ?>
<?php $this->view("includes/Inc_scripts"); ?>

<!--begin::Page Snippets -->
<?php //$this->view("modules/include_scripts/bill_scripts");
?>
<script>
//    Toggle Sidebar
$("#m_aside_left_minimize_toggle").addClass("m-brand__toggler--active");
$("#body").addClass("m-brand--minimize m-aside-left--minimize");

$("#work_order_menu").addClass('m-menu__item--active m-menu__item--open');
$("#work_order_menu_1").addClass('m-menu__item--active');

$('#work_order_work_type_add').select2({
  dropdownParent: $("#form_work_cat_add")
});
$('body').on('change', '#item_work_type_add', function() {
  var item_code = $('#item_work_type_add :selected').data('item-code');
  $("#item_code_add").val(item_code);
})
$('body').on('change', '#item_work_type_edit', function() {
  var item_code = $('#item_work_type_edit :selected').data('item-code');
  $("#item_code_edit").val(item_code);
})
$('input[type=radio][name=item_type]').change(function() {
  if (this.value == 'task') {
    $("#description_title_add").text('Item Description');
    $(".task_fields_div_add").show();
    $(".task_fields_add").attr('required',true);
  }else{
    $("#description_title_add").text('Work Description');
    $(".task_fields_div_add").hide();
    $(".task_fields_add").removeAttr('required',true);
  }
})
$('input[type=radio][name=item_type_edit]').change(function() {
  if (this.value == 'task') {
    $("#description_title_edit").text('Item Description');
    $(".task_fields_div_edit").show();
    $(".task_fields_edit").attr('required',true);
  }else{
    $("#description_title_edit").text('Work Description');
    $(".task_fields_div_edit").hide();
    $(".task_fields_edit").removeAttr('required',true);
  }
})
function select_work_type(select_id,selected_option=''){
  $("#"+select_id).html('');
  $("#"+select_id).append("<option disabled selected >Select Work Type</option>");
  $.post("<?php echo base_url() ?>work_types/select",{},function(data) {
    var obj = $.parseJSON(data);
    var i=0;
    if(obj.count>0) {
      while (i < obj.id.length) {
        $("#"+select_id).append("<option value=" + obj.id[i] + ">" + obj.name[i] + "</option>");
        i++;
      }
    }
    if(selected_option!=''){
      $("#"+select_id).val(selected_option).trigger('change');
    }
  })
}
select_work_type('work_order_work_type_add');

function select_work_order_work_types(select_id,selected_option=''){
  var work_order_id = "<?php echo $work_order_data->order_id ?>";
  $("#"+select_id).html('');
  $("#"+select_id).append("<option disabled selected value='0' >Select Work Type</option>");
  $.post("<?php echo base_url() ?>work_order/select_work_order_work_types",{work_order_id:work_order_id},function(data) {
    var obj = $.parseJSON(data);
    var i=0;
    if(obj.count>0) {
      while (i < obj.id.length) {
        $("#"+select_id).append("<option data-item-code="+ obj.item_code[i] +" value=" + obj.id[i] + ">" + obj.name[i] + "</option>");
        i++;
      }
    }
    if(selected_option!=''){
      $("#"+select_id).val(selected_option).trigger('change');
    }
  })
}
select_work_order_work_types('item_work_type_add');
select_work_order_work_types('item_work_type_edit');
$("#item_work_type_add").select2({
  placeholder: "Select Work Type",
  dropdownParent: $("#form_item_add")
})
$("#item_work_type_edit").select2({
  placeholder: "Select Work Type",
  dropdownParent: $("#form_item_edit")
})

function get_items() {
  var work_order_id = "<?php echo $work_order_data->order_id ?>";
  $.post("<?php echo base_url() ?>work_order/select_work_order_items",{work_order_id:work_order_id},function (data) {
    var obj=$.parseJSON(data);
    $("#item_table_body").html('');

    if(parseInt(obj.items_count)>0){
      var content=obj.content;
      $("#item_table_body").html(content);
    }
    init_item_table();
  })
}
get_items();

function init_item_table() {
  $('#table_items_list').dataTable().fnDestroy();
  var table = $('#table_items_list').dataTable({
    fixedHeader: true,
    "scrollX" : true,
    scrollX:!0, scrollCollapse:!0,
    buttons: [
      { extend: 'print', className: 'btn dark btn-outline',exportOptions: {columns: ':visible'},title: 'BOQ List' },
      { extend: 'csv', className: 'btn purple btn-outline ' },
      { extend: 'colvis', className: 'btn dark btn-outline', text: 'Columns'}
    ],
    dom:"<'row'<'col-sm-6 text-left'B><'col-sm-6 text-right'f>>\n\t\t\t<'row'<'col-sm-12'tr>>\n\t\t\t<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 dataTables_pager'lp>>", // horizobtal scrollable datatable
    "lengthMenu": [
      [100, 250, 500, -1],
      [100, 250, 500, "All"] // change per page values here
    ],
    "columnDefs": [
      {
        "targets": [9,10,11,12,13<?php if($this->config->item('Quotation_rate_type')=='default'){ echo ',6';}?>],
        className: "hidden"
      },
      {
        render: function (data, type, full, meta) {
          return "<div class='text-wrap width-500'>" + data + "</div>";
        },
        targets: [ 1 ],
      },
    ],
    "initComplete": function(settings, json) {
      calculate_total_amount();
    },
    'order': false,
    'ordering':false,
    "pageLength":100
  });
}

function select_units(select_id,selected_value=''){
  $('#'+select_id).html('');
  $("#"+select_id).append("<option disabled selected >Select Unit</option>");
  $.post("<?php echo base_url() ?>units/select",{},function(data) {
    var obj = $.parseJSON(data);
    var i=0;
    if(obj.count>0) {
      while (i < obj.id.length) {
        $('#'+select_id).append("<option value=" + obj.id[i] + ">" + obj.name[i] + "</option>");
        i++;
      }
      if(selected_value!=''){
        $('#'+select_id).val(selected_value).trigger('change');
      }
    }
  })
}
$('#item_add_modal').on('shown.bs.modal', function (e) {
  $("#item_description_add").summernote({
    height: 200,
    width: '100%',
    toolbar: [
      // [groupName, [list of button]]
      ['style', ['bold', 'italic','underline']],
      ['fontsize', ['fontsize']],
      ['color', ['color']],
      ['para', ['ul', 'ol', 'paragraph']],
      ['height', ['height']]
    ]
  });
  $('#item_description_add').summernote('lineHeight', 1);
})
$('#item_edit_modal').on('shown.bs.modal', function (e) {
  $("#item_description_edit").summernote({
    height: 200,
    width: '100%',
    toolbar: [
      // [groupName, [list of button]]
      ['style', ['bold', 'italic','underline']],
      ['fontsize', ['fontsize']],
      ['color', ['color']],
      ['para', ['ul', 'ol', 'paragraph']],
      ['height', ['height']]
    ]
  });
  $('#item_description_edit').summernote('lineHeight', 1);
})

$("#item_unit_add").select2({
  placeholder: "Select Unit",
  dropdownParent: $("#form_item_add")
})
$("#item_unit_edit").select2({
  placeholder: "Select Unit",
  dropdownParent: $("#form_item_edit")
})
select_units('item_unit_add');
select_units('item_unit_edit');
$(".m_selectpicker").selectpicker();
$('.m_selectpicker').selectpicker('refresh');

<?php if(isset($work_order_data) && !empty($work_order_data)){ ?>
  $("#tax_percent").val("<?php echo $work_order_data->tax_percent ?>").trigger('change');
  $("#discount_amount").val("<?php echo $work_order_data->discount_amount ?>");
  <?php } ?>
  function calculate_total_amount() {
    var total_amount = 0;
    $(".item_total_amount").each(function(){
      if($(this).val()!='' && $(this).val()!=null){
        total_amount += parseFloat($(this).val());
      }
    });
    var discount_amount = parseFloat($("#discount_amount").val());
    if(isNaN(discount_amount)){
      discount_amount=0;
    }
    var taxable_amount = total_amount-discount_amount;
    var tax_percent = parseFloat($("#tax_percent :selected").data('tax-percent'));
    var tax_amount = taxable_amount*tax_percent/100;
    var net_total = taxable_amount+tax_amount;
    $("#grand_total_amount").val((total_amount).toFixed(<?php echo $this->config->item('Currency_amount_decimals_2')?>));
    $("#total_taxable_amount").val((taxable_amount).toFixed(<?php echo $this->config->item('Currency_amount_decimals_2')?>));
    $("#total_tax_amount").val((tax_amount).toFixed(<?php echo $this->config->item('Currency_amount_decimals_2')?>));
    $("#net_total_amount").val((net_total).toFixed(<?php echo $this->config->item('Currency_amount_decimals_2')?>));

  }
  $('body').on('change keyup', '#discount_amount,#tax_percent', function() {
    calculate_total_amount();
  })
  $('body').on('change keyup', '.item_rate_fields_add', function() {
    calculate_item_total('add');
  })
  $('body').on('change keyup', '.item_rate_fields_edit', function() {
    calculate_item_total('edit');
  })
  function calculate_item_total(type='add'){
    var qty = parseFloat($("#item_qty_"+type).val());
    var price = parseFloat($("#item_unit_price_"+type).val());
    var price2 = 0;
    <?php if($this->config->item('Quotation_rate_type')=='supply_installation'){?>
    price2 = parseFloat($("#item_unit_price_2_"+type).val());
    <?php } ?>
    var total_amount = 0;
    if(isNaN(qty)){
      qty=0;
    }
    if(isNaN(price)){
      price=0;
    }
    if(isNaN(price2)){
      price2=0;
    }
    total_amount = (qty*price) + (qty*price2);
    $("#item_total_"+type).val(total_amount.toFixed(<?php echo $this->config->item('Currency_amount_decimals_2')?>));
    calculate_total_amount();
  }
  $('body').on('click', '#btn_work_type_delete', function() {
    $('#quotation_work_type_delete').val($(this).data('work-type-id'));
  })
  $('body').on('click', '#btn_work_order_item_delete', function() {
    $('#quotation_item_id_delete').val($(this).data('item-id'));
  })
  $('body').on('click', '#btn_work_order_item_edit', function() {
    $('#item_id_edit').val($(this).data('item-id'));
    var no = $(this).closest('tr').children('td');
    $('#item_work_type_edit').val(no.eq(11).text()).trigger('change');
    $('#item_unit_edit').val(no.eq(10).text()).trigger('change');
    $('#item_unit_price_edit').val(no.eq(5).text());
    $('#item_unit_price_2_edit').val(no.eq(6).text());
    $('#item_qty_edit').val(no.eq(3).text());
    $('#item_code_edit').val(no.eq(2).text());
    $('#item_total_edit').val(no.eq(7).text());
    $("#item_description_edit").summernote('code', no.eq(12).html());
    $("input[name=item_type_edit][value='"+no.eq(13).text()+"']").prop('checked', true).trigger('change');
  })

  $(".form_post").each(function(){
    var form_id = $(this).attr('id');
    $("#"+form_id).validate({
      rules: {
        quantity: {
          required: !0,
          number: !0
        },
        client_unit_price: {
          required: !0,
          number: !0
        },
      },
      invalidHandler: function(e, r) {
        var i = $("#" + form_id + "_msg");
        i.removeClass("m--hide").show(), mUtil.scrollTo(i, -200)
      },
      submitHandler: function(e) {
        this.submit();
      }
    })
  });

$(".form_submit_btn_3").click(function(e) {
  e.preventDefault();
  var a = $(this),
  l = $(this).closest("form"),
  action = l.attr('action');
  var form_id = l.attr('id');
  l.validate({
    rules: {
      "quantity": {
        required: !0,
        number: !0
      },
      "amount": {
        required: !0,
        number: !0
      }
    },
    invalidHandler: function(e, r) {
      var i = $("#" + form_id + "_msg");
      i.removeClass("m--hide").show(), mUtil.scrollTo(i, -200)
    },
    submitHandler: function(e) {}
  }), l.valid() && (a.addClass("m-loader m-loader--right m-loader--light").attr("disabled", !0),
  l.ajaxSubmit({
    url: action,
    success: function(e, t, r, s) {
      var modal_id = l.attr('data-modal-id');
      var form_type = l.attr('data-form-type');
      $("#" + form_id + "_msg").addClass("m--hide");
      // Block UI
      mApp.blockPage({
        overlayColor: "#000000",
        type: "loader",
        state: "success",
        message: "Please wait..."
      }), setTimeout(function() {
        mApp.unblockPage()
      }, 2e3);
      var obj = $.parseJSON(e);
      if (obj.status == 1) {
        a.removeClass("m-loader m-loader--right m-loader--light").attr("disabled", !1);
        // toastr[obj.flashdata_type](obj.flashdata_msg, obj.flashdata_title);
        // $("#"+modal_id).modal('toggle');
        // $("."+form_id+"_fields").val("");
        // location.reload();
        swal({
          width: 500,
          title: obj.flashdata_title,
          text: obj.flashdata_msg,
          type: obj.flashdata_type,
          showCancelButton: !0,
          confirmButtonText: "Go to Work Order Details",
          cancelButtonText: "Add New Work Order",
          confirmButtonColor: '#3085d6',
          cancelButtonColor: '#d33',
          reverseButtons: !0,
          closeOnClickOutside: false,
          allowOutsideClick: false,
        }).then(function(e) {
          e.value ? window.location.replace("<?php echo base_url() ?>work_order/profile/view/" + obj.work_order_id) : "cancel" === e.dismiss && window.location.replace("<?php echo base_url() ?>work_order/add");
        })
      } else {
        a.removeClass("m-loader m-loader--right m-loader--light").attr("disabled", !1);
        toastr[obj.flashdata_type](obj.flashdata_msg, obj.flashdata_title);
      }

      if (obj == null) {
        setTimeout(function() {
          a.removeClass("m-loader m-loader--right m-loader--light").attr("disabled", !1);
          toastr["warning"]("Your Attempt is Timed Out. Please Try Again.", "Timed Out");
        }, 2e4)
      }
    },
    error: function() {
      a.removeClass("m-loader m-loader--right m-loader--light").attr("disabled", !1);
      toastr["error"]("Sorry. There Has Been Some Error Occurred. Please Try Again.", "Error");
    }
  })
)
});
$(".form_submit_btn").click(function (e) {
  e.preventDefault();
  var a = $(this),
  l = $(this).closest("form"),
  action = l.attr('action');
  var form_id = l.attr('id');
  l.validate({
    rules: {
      quantity: {
        required: !0,
        number: !0
      },
      client_unit_price: {
        required: !0,
        number: !0
      },
    },
    messages: {
      end_date: "End Date Should Be Greater than or Equal to Start Date",
    }, invalidHandler: function (e, r) {
      var i = $("#" + form_id + "_msg");
      i.removeClass("m--hide").show(), mUtil.scrollTo(i, -200)
    }, submitHandler: function (e) {
    }
  }), l.valid() && (a.addClass("m-loader m-loader--right m-loader--light").attr("disabled", !0),
  l.ajaxSubmit({
    url: action,
    success: function (e, t, r, s) {

      var modal_id = l.attr('data-modal-id');
      var form_type = l.attr('data-form-type');
      $("#" + form_id + "_msg").addClass("m--hide");
      // Block UI
      mApp.blockPage({
        overlayColor: "#000000",
        type: "loader",
        state: "success",
        message: "Please wait..."
      }), setTimeout(function () {
        mApp.unblockPage()
      }, 2e3);
      var obj = $.parseJSON(e);
      if (obj.status == 1) {
        a.removeClass("m-loader m-loader--right m-loader--light").attr("disabled", !1);
        toastr[obj.flashdata_type](obj.flashdata_msg, obj.flashdata_title);
        $("#"+modal_id).modal('toggle');
        $("."+form_id+"_fields").val('');
        $("."+form_id+"_select").val('').trigger("change");

        select_work_type('work_order_work_type_add');
      } else {
        a.removeClass("m-loader m-loader--right m-loader--light").attr("disabled", !1);
        toastr[obj.flashdata_type](obj.flashdata_msg, obj.flashdata_title);
      }
      if (obj == null) {
        setTimeout(function () {
          a.removeClass("m-loader m-loader--right m-loader--light").attr("disabled", !1);
          toastr["warning"]("Your Attempt is Timed Out. Please Try Again.", "Timed Out");
        }, 2e4)
      }
    },error: function() {
      a.removeClass("m-loader m-loader--right m-loader--light").attr("disabled", !1);
      toastr["error"]("Sorry. There Has Been Some Error Occurred. Please Try Again.", "Error");
    }
  })
)
});
</script>
