<html>
<head>
  <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
  <title>Project Summary - #<?php echo $work_data->work_id." - ".$work_data->work_name?></title>
  <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/v/bs4/jszip-2.5.0/dt-1.10.20/b-1.6.1/b-colvis-1.6.1/b-flash-1.6.1/b-html5-1.6.1/b-print-1.6.1/fc-3.3.0/fh-3.1.6/kt-2.5.1/r-2.2.3/rg-1.1.1/sc-2.0.1/sp-1.0.1/datatables.min.css"/>

</head>
<style type="text/css">

h3{
  font-size: 1rem !important;
font-weight: bold !important;
}
body { font-family:Tahoma, Geneva, sans-serif;
  font-style:normal;
  font-weight:normal;
  font-variant:normal;
  font-size:12px;
  padding:0px;
  margin:0px;
  line-height:18px;
}
.item_table td{
  padding: .75rem !important;
}
.item_table th{
  white-space: nowrap;
  padding: .75rem !important;
}
.table thead th {
  border-top: 2px solid #f4f5f8 !important;
}
@media print
{
  #print, .print_hide_div, .dt-buttons
  {
    display: none !important;
  }
  .m-portlet.m-portlet--bordered {
    border: none;
  }
}
@media print {
  html, body, div, span, applet, object, iframe, td, tr, blockquote, pre, a, abbr, acronym, address, big, cite, code, del, dfn, em, font, ins, kbd, q, s, samp, small, strike, strong, sub, sup, tt, var, dl, dt, dd, ol, ul, li, fieldset, form, label, legend, table, caption, tbody, tfoot, thead, tr, th, td {
    font-size: 15pt !important;
  }
  h1.entry-title {
    font-size: 15pt !important;
  }
}
@page {
  size: auto !important;
}
</style>
<body>
  <div class="m-grid__item m-grid__item--fluid m-wrapper" id="content">
    <div class="m-content">
      <div class="row">
        <div style="width:1000px; height:auto;">
          <img style="max-width: 1000px" src="<?php echo base_url().'uploads/company/'.$this->config->item('company_letter_head')?>" />
          <div class="m-portlet">
            <div class="m-portlet__body m-portlet__body--no-padding">
              <!-- client Details -->
              <div class="m-portlet  m-portlet--rounded m-portlet--bordered " >
                <a href="javascript:;" style="float: right;margin-top: 20px;margin-bottom: 20px;margin-right: 20px"  id="print"   class="print_hide_div btn btn-primary m-btn m-btn--custom m-btn--icon m-btn--air m-btn--pill">
                  <span>
                    <i class="la la-print"></i>
                    <span>
                      Print
                    </span>
                  </span>
                </a>
                <div class="m-portlet__body">
                  <h3 class="m-portlet__head-text" style="text-align: center;text-decoration: underline">
                    Summary Of Work " <?php echo $work_data->work_name?> <?php if($work_data->reference_no!=''){ echo " [".$work_data->reference_no."]";} ?> "
                  </h3>
                </div>
              </div>
              <div class="m-portlet  m-portlet--rounded m-portlet--bordered print_hide_div" >
                <div class="m-portlet__body">
                  <div class="m-form__group form-group">
                    <label for="">Select Datas to Display</label>
                    <div class="m-checkbox-inline" style="border-bottom:1px dashed black;padding-bottom:10px">
                      <label class="m-checkbox m-checkbox--bold m-checkbox--state-success">
                        <input type="checkbox" value="check_all" class="data_display_check_all" checked> Check All
                        <span></span>
                      </label>
                      <label class="m-checkbox m-checkbox--bold m-checkbox--state-danger">
                        <input type="checkbox" value="uncheck_all" class="data_display_check_all"> UnCheck All
                        <span></span>
                      </label>
                    </div>
                    <div class="m-checkbox-inline" style="padding-top:10px">
                      <label class="m-checkbox m-checkbox--bold m-checkbox--state-brand">
                        <input type="checkbox" value="work_info" class="data_display_option" checked> Work Info
                        <span></span>
                      </label>

                      <?php if($this->session->userdata('user_role')=='admin' || $this->session->userdata('user_role')=='general_manager' || $this->session->userdata('user_role')=='accounts_manager' || $this->session->userdata('user_role')=='auditor'){?>
                        <?php if($this->config->item('Client_Payment_client_payment_invoice')==1) { ?>
                          <label class="m-checkbox m-checkbox--bold m-checkbox--state-brand">
                            <input type="checkbox" value="client_invoices" class="data_display_option" checked> Client Invoices
                            <span></span>
                          </label>
                        <?php } ?>
                        <?php if ($this->config->item('app_module_client_payments') == 1 ){?>
                          <label class="m-checkbox m-checkbox--bold m-checkbox--state-brand">
                            <input type="checkbox" value="client_payments" class="data_display_option" checked> Client Payments
                            <span></span>
                          </label>
                        <?php } ?>
                        <?php if ($this->config->item('app_module_assets_management') == 1){?>
                          <label class="m-checkbox m-checkbox--bold m-checkbox--state-brand">
                            <input type="checkbox" value="security_deposits" class="data_display_option" checked> Security Deposits
                            <span></span>
                          </label>
                        <?php } ?>
                      <?php } ?>
                      <?php if($this->config->item('app_module_purchase_order')==1){?>
                        <label class="m-checkbox m-checkbox--bold m-checkbox--state-brand">
                          <input type="checkbox" value="purchase_orders" class="data_display_option" checked> Purchase Order & Payments
                          <span></span>
                        </label>
                      <?php } ?>
                      <label class="m-checkbox m-checkbox--bold m-checkbox--state-brand">
                        <input type="checkbox" value="purchase_bills" class="data_display_option" checked> Purchase Bill & Payments
                        <span></span>
                      </label>
                      <label class="m-checkbox m-checkbox--bold m-checkbox--state-brand">
                        <input type="checkbox" value="purchased_materials" class="data_display_option" checked> Purchased Materials
                        <span></span>
                      </label>
                      <label class="m-checkbox m-checkbox--bold m-checkbox--state-brand">
                        <input type="checkbox" value="stock_transfers" class="data_display_option" checked> Stock Transfers
                        <span></span>
                      </label>
                      <?php if($this->session->userdata('user_role')!='purchase_manager'){?>
                        <label class="m-checkbox m-checkbox--bold m-checkbox--state-brand">
                          <input type="checkbox" value="expenses" class="data_display_option" checked> Expense Bills & Payments
                          <span></span>
                        </label>
                        <label class="m-checkbox m-checkbox--bold m-checkbox--state-brand">
                          <input type="checkbox" value="expense_summary" class="data_display_option" checked> Expense Summary (Head Wise)
                          <span></span>
                        </label>
                      <?php } ?>
                      <?php if($this->session->userdata('user_role')!='purchase_manager'){?>
                        <?php if ($this->config->item('app_module_labours') == 1){?>
                          <label class="m-checkbox m-checkbox--bold m-checkbox--state-brand">
                            <input type="checkbox" value="labour_wages" class="data_display_option" checked> Labour Wage Slip
                            <span></span>
                          </label>
                        <?php } ?>
                      <?php } ?>
                      <?php if($this->session->userdata('user_role')!='purchase_manager'){?>
                        <label class="m-checkbox m-checkbox--bold m-checkbox--state-brand">
                          <input type="checkbox" value="salary_payments" class="data_display_option" checked> Salary Slip & Payments
                          <span></span>
                        </label>
                      <?php } ?>
                      <?php if($this->session->userdata('user_role')!='purchase_manager'){?>
                        <label class="m-checkbox m-checkbox--bold m-checkbox--state-brand date_filter_hide_fields">
                          <input type="checkbox" value="subcontracts" class="data_display_option" checked> Subcontract Works, Bills & Payments
                          <span></span>
                        </label>
                      <?php } ?>
                      <?php if($this->session->userdata('user_role')!='purchase_manager'){?>
                        <?php if ($this->config->item('app_module_tools_management') == 1) { ?>
                          <label class="m-checkbox m-checkbox--bold m-checkbox--state-brand">
                            <input type="checkbox" value="tool_payments" class="data_display_option" checked> Tool Payments
                            <span></span>
                          </label>
                        <?php } ?>
                      <?php } ?>

                      <?php if($this->session->userdata('user_role')!='purchase_manager'){?>
                        <?php if ($this->config->item('app_module_vehicle') == 1){?>
                          <label class="m-checkbox m-checkbox--bold m-checkbox--state-brand">
                            <input type="checkbox" value="vehicle_work_slip" class="data_display_option" checked> Vehicle Work SLip
                            <span></span>
                          </label>
                          <label class="m-checkbox m-checkbox--bold m-checkbox--state-brand">
                            <input type="checkbox" value="vehicle_payments" class="data_display_option" checked> Vehicle Payments
                            <span></span>
                          </label>
                        <?php } ?>
                      <?php } ?>
                      <label class="m-checkbox m-checkbox--bold m-checkbox--state-brand">
                        <input type="checkbox" value="work_summary" class="data_display_option" checked> Work Summary
                        <span></span>
                      </label>
                    </div>
                  </div>
                  <div class="m-form__group form-group">
                    <label for="">Filters</label>
                    <div class="row">
                      <div class="col-md-3">
                        <div class="input-group m-input-group--air m-input-group--pill  date">
                          <input data-date-format="dd-mm-yyyy" autocomplete="off" id="table_filter_start_date"  type="text"  class="form-control  m-input table_filter" placeholder="Start Date" >
                        </div>
                      </div>
                      <div class="col-md-3">
                        <div class="input-group m-input-group--air m-input-group--pill  date">
                          <input  data-date-format="dd-mm-yyyy" autocomplete="off" id="table_filter_end_date"  type="text"  class="form-control  m-input table_filter" placeholder="End Date" >
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
              <div class="m-portlet  m-portlet--rounded m-portlet--bordered div_work_info">
                <div class="m-portlet__body">
                  <h3 class="m-portlet__head-text" style="text-align: center">
                    Work Info
                  </h3>
                  <table width="100%" class="table m-table nowrap table-header-fixed table-striped table-bordered table-hover table-header-fixed" id="work_info_table">
                    <thead>
                      <tr class="">
                        <th><strong>Info</strong></th>
                        <th><strong>Description</strong></th>
                      </tr>
                    </thead>
                    <tbody>
                      <tr class="">
                        <th><strong>Work Name</strong></th>
                        <td><?php echo $work_data->work_name?></td>
                      </tr>
                      <tr class="">
                        <th><strong><?php echo $this->config->item('Project_reference_no_title') ?></strong></th>
                        <td><?php echo $work_data->reference_no?></td>
                      </tr>
                      <tr class="">
                        <th><strong>Work Type</strong></th>
                        <td>
                          <span><i class="fa fa-briefcase"></i>    <?php echo $work_data->wcat_name?></span><br/><br/>
                          <?php if($work_data->work_type==1){?>
                            <?php if($this->session->userdata('user_role')=='admin'){?>
                              <span><strong>Commission  :<?php echo $work_data->project_management_commission?>%</strong></span><br/><br/>
                            <?php } ?>
                          <?php } ?>
                        </td>
                      </tr>
                      <tr class="">
                        <th><strong>Work Status</strong></th>
                        <td>
                          <?php if($work_data->work_status==1){?>
                            <span class='m-badge m-badge--success m-badge--wide'><i class="fa fa-check"></i> Completed</span>
                          <?php }else{ ?>
                            <span class='m-badge m-badge--info m-badge--wide'><i class="fa fa-ellipsis-h"></i>In Progress</span>
                          <?php } ?>
                        </td>
                      </tr>
                      <tr class="">
                        <th><strong>Location</strong></th>
                        <td>
                          <?php echo $work_data->work_location?>
                        </td>
                      </tr>
                      <?php if($this->session->userdata('user_role')=='admin' || $this->session->userdata('user_role')=='auditor'){?>
                        <tr class="">
                          <th><strong>Estimated Budget</strong></th>
                          <td>
                            <?php echo $this->config->item('currency_format')->formatCurrency($work_data->est_budget_amt,$this->config->item('Currency_currency_shortname'))?>
                          </td>
                        </tr>
                        <tr class="">
                          <th><strong><?php echo $this->config->item('Tax_tax_name')?> %</strong></th>
                          <td>
                            <?php echo $work_data->project_tax_percent?>%
                          </td>
                        </tr>
                        <tr class="">
                          <th><strong><?php echo $this->config->item('Tax_tax_name')?> Amount</strong></th>
                          <td>
                            <?php echo $this->config->item('currency_format')->formatCurrency($work_data->project_tax_amount,$this->config->item('Currency_currency_shortname'))?>
                          </td>
                        </tr>
                        <tr class="">
                          <th><strong>Total Budget</strong></th>
                          <td>
                            <?php echo $this->config->item('currency_format')->formatCurrency($work_data->total_budget_amount,$this->config->item('Currency_currency_shortname'))?>
                          </td>
                        </tr>
                      <?php } ?>
                      <tr class="">
                        <th><strong>Work Description</strong></th>
                        <td>
                          <?php echo $work_data->work_description?>
                        </td>
                      </tr>
                      <tr class="">
                        <th><strong>Client Name</strong></th>
                        <td>
                          <?php echo $work_data->client_name?>
                        </td>
                      </tr>
                    </tbody>
                  </table>
                </div>
              </div>
              <?php if($this->session->userdata('user_role')=='admin' || $this->session->userdata('user_role')=='general_manager' || $this->session->userdata('user_role')=='accounts_manager' || $this->session->userdata('user_role')=='auditor'){?>
                <?php if ($this->config->item('Client_Payment_client_payment_invoice') == 1 ){?>
                  <div class="m-portlet  m-portlet--rounded m-portlet--bordered div_client_invoices">
                    <div class="m-portlet__body">
                      <h3 class="m-portlet__head-text" style="text-align: center">
                        Client Invoices
                      </h3>
                      <?php $this->view("modules/include_tables/table_invoices");?>
                    </div>
                  </div>
                <?php } ?>
                <?php if ($this->config->item('app_module_client_payments') == 1 ){?>
                  <div class="m-portlet  m-portlet--rounded m-portlet--bordered div_client_payments">
                    <div class="m-portlet__body">
                      <h3 class="m-portlet__head-text" style="text-align: center">
                        Client Payments Received
                      </h3>
                      <?php $this->view("modules/include_tables/table_client_payments");?>
                    </div>
                  </div>
                <?php } ?>
                <?php if ($this->config->item('app_module_assets_management') == 1 ){?>
                  <div class="m-portlet  m-portlet--rounded m-portlet--bordered div_security_deposits">
                    <div class="m-portlet__body">
                      <h3 class="m-portlet__head-text" style="text-align: center">
                        EMD
                      </h3>
                      <?php $this->view("modules/include_tables/table_emd");?>
                    </div>
                  </div>
                  <div class="m-portlet  m-portlet--rounded m-portlet--bordered div_security_deposits">
                    <div class="m-portlet__body">
                      <h3 class="m-portlet__head-text" style="text-align: center">
                        Security Desposits
                      </h3>
                      <?php $this->view("modules/include_tables/table_security_deposits");?>
                    </div>
                  </div>
                <?php } ?>
              <?php } ?>
              <!-- Purchase Payments -->
              <?php if($this->config->item('app_module_purchase_order')==1){?>
                <div class="m-portlet  m-portlet--rounded m-portlet--bordered div_purchase_orders">
                  <div class="m-portlet__body">
                    <h3 class="m-portlet__head-text" style="text-align: center">
                      Purchase Orders
                    </h3>
                    <?php $this->view("modules/include_tables/table_purchase_order");?>
                  </div>
                </div>
                <div class="m-portlet  m-portlet--rounded m-portlet--bordered div_purchase_orders">
                  <div class="m-portlet__body">
                    <h3 class="m-portlet__head-text" style="text-align: center">
                      Purchase Orders Payments (Orders Those Haven't Purchase Bill Created)
                    </h3>
                    <?php $this->view("modules/include_tables/table_purchase_order_payments");?>
                  </div>
                </div>
              <?php } ?>
              <div class="m-portlet  m-portlet--rounded m-portlet--bordered div_purchase_bills">
                <div class="m-portlet__body">
                  <h3 class="m-portlet__head-text" style="text-align: center">
                    Purchase Bills
                  </h3>
                  <?php $this->view("modules/include_tables/table_purchase_bills");?>
                </div>
              </div>
              <div class="m-portlet  m-portlet--rounded m-portlet--bordered div_purchase_bills">
                <div class="m-portlet__body">
                  <h3 class="m-portlet__head-text" style="text-align: center">
                    Purchase Bill Payments
                  </h3>
                  <?php $this->view("modules/include_tables/table_purchase_bill_payments");?>
                </div>
              </div>
              <div class="m-portlet  m-portlet--rounded m-portlet--bordered div_purchased_materials">
                <div class="m-portlet__body">
                  <h3 class="m-portlet__head-text" style="text-align: center">
                    Material Purchased
                  </h3>
                  <?php $this->view("modules/include_tables/table_materials_purchased");?>
                </div>
              </div>
              <div class="m-portlet  m-portlet--rounded m-portlet--bordered div_stock_transfers">
                <div class="m-portlet__body">
                  <h3 class="m-portlet__head-text" style="text-align: center">
                    Stock Transfers
                  </h3>
                  <?php $this->view("modules/include_tables/table_stock_transfers");?>
                </div>
              </div>
              <?php if($this->session->userdata('user_role')!='purchase_manager'){?>
                <div class="m-portlet  m-portlet--rounded m-portlet--bordered div_expenses">
                  <div class="m-portlet__body">
                    <h3 class="m-portlet__head-text" style="text-align: center">
                      Other Expense Bills
                    </h3>
                    <?php $this->view("modules/include_tables/table_expense_bills");?>
                  </div>
                </div>
                <div class="m-portlet  m-portlet--rounded m-portlet--bordered div_expenses">
                  <div class="m-portlet__body">
                    <h3 class="m-portlet__head-text" style="text-align: center">
                      Other Expense Bill Payments
                    </h3>
                    <?php $this->view("modules/include_tables/table_expense_bill_payments");?>
                  </div>
                </div>
                <div class="m-portlet  m-portlet--rounded m-portlet--bordered div_expense_summary">
                  <div class="m-portlet__body">
                    <h3 class="m-portlet__head-text" style="text-align: center">
                      Other Expenses (Head Wise)
                    </h3>
                    <?php $this->view("modules/include_tables/table_expense_bills_headwise");?>
                  </div>
                </div>
              <?php } ?>
              <?php if($this->session->userdata('user_role')!='purchase_manager'){?>
                <?php if ($this->config->item('app_module_labours') == 1){?>
                  <div class="m-portlet  m-portlet--rounded m-portlet--bordered div_labour_wages">
                    <div class="m-portlet__body">
                      <h3 class="m-portlet__head-text" style="text-align: center">
                        Labour Wage Slips
                      </h3>
                      <?php $this->view("modules/include_tables/table_labour_wage_slips");?>
                    </table>
                  </div>
                </div>
              <?php } ?>
            <?php } ?>
            <?php if($this->session->userdata('user_role')!='purchase_manager'){?>
              <div class="m-portlet  m-portlet--rounded m-portlet--bordered div_salary_payments">
                <div class="m-portlet__body">
                  <h3 class="m-portlet__head-text" style="text-align: center">
                    Salary Slips
                  </h3>
                  <?php $this->view("modules/include_tables/table_salary_slips");?>
                </table>
              </div>
            </div>
            <div class="m-portlet  m-portlet--rounded m-portlet--bordered div_salary_payments">
              <div class="m-portlet__body">
                <h3 class="m-portlet__head-text" style="text-align: center">
                  Salary Payments
                </h3>
                <?php $this->view("modules/include_tables/table_salary_slip_transaction");?>
              </table>
            </div>
          </div>
        <?php } ?>
        <?php if($this->session->userdata('user_role')!='purchase_manager'){?>
          <div class="m-portlet  m-portlet--rounded m-portlet--bordered div_subcontracts">
            <div class="m-portlet__body">
              <h3 class="m-portlet__head-text" style="text-align: center">
                Subcontract Works
              </h3>
              <?php $this->view("modules/include_tables/table_subcontracts");?>
            </div>
          </div>
          <div class="m-portlet  m-portlet--rounded m-portlet--bordered div_subcontracts">
            <div class="m-portlet__body">
              <h3 class="m-portlet__head-text" style="text-align: center">
                Subcontract Bills
              </h3>
              <?php $this->view("modules/include_tables/table_subcontract_bills");?>
            </div>
          </div>
          <div class="m-portlet  m-portlet--rounded m-portlet--bordered div_subcontracts">
            <div class="m-portlet__body">
              <h3 class="m-portlet__head-text" style="text-align: center">
                Subcontract Payments
              </h3>
              <?php $this->view("modules/include_tables/table_subcontract_payments");?>
            </div>
          </div>
        <?php } ?>
        <?php if($this->session->userdata('user_role')!='purchase_manager'){?>
          <?php if ($this->config->item('app_module_tools_management') == 1) { ?>
            <div class="m-portlet  m-portlet--rounded m-portlet--bordered div_tool_payments">
              <div class="m-portlet__body">
                <h3 class="m-portlet__head-text" style="text-align: center">
                  Tool Payments
                </h3>
                <?php $this->view("modules/include_tables/table_tool_payments_transactions");?>
              </div>
            </div>
          <?php } ?>
        <?php } ?>
        <?php if($this->session->userdata('user_role')!='purchase_manager'){?>
          <?php if ($this->config->item('app_module_vehicle') == 1){?>
            <div class="m-portlet  m-portlet--rounded m-portlet--bordered div_vehicle_work_slip date_filter_hide_fields">
              <div class="m-portlet__body">
                <h3 class="m-portlet__head-text" style="text-align: center">
                  Vehicle Work Slips
                </h3>
                <?php $this->view("modules/include_tables/table_vehicle_work_slips");?>
              </div>
            </div>
            <div class="m-portlet  m-portlet--rounded m-portlet--bordered div_vehicle_payments date_filter_hide_fields">
              <div class="m-portlet__body">
                <h3 class="m-portlet__head-text" style="text-align: center">
                  Vehicle Payments
                </h3>
                <?php $this->view("modules/include_tables/table_vehicle_work_slip_transaction");?>
              </div>
            </div>
          <?php } ?>
        <?php } ?>
        <div class="m-portlet  m-portlet--rounded m-portlet--bordered div_work_summary">
          <div class="m-portlet__body">
            <h3 class="m-portlet__head-text" style="text-align: center">
              Project Overall Summary
            </h3>
            <table width="100%" class="table m-table nowrap table-header-fixed table-striped table-bordered table-hover table-header-fixed" id="all_payments">
              <thead>
                <tr class="">
                  <th>Heads</th>
                  <th>Amount</th>
                </tr>
              </thead>
              <tbody>

                <?php if($this->session->userdata('user_role')=='admin' || $this->session->userdata('user_role')=='auditor'){?>
                  <?php if($this->config->item('Project_multiple_budget')==1){
                    $budget_details = unserialize($work_data->project_budget_details);
                    foreach ($budget_details as $key => $value) { ?>
                      <tr>
                        <td>Project Budget - <?php echo $value['section']?>
                          <?php if($value['tax_percent']!=0){ echo "[".$value['tax_percent']."% ".$this->config->item('Tax_tax_name')."]";}?></td>
                          <td><?php echo $this->config->item('Currency_currency_format')." ".$this->config->item('currency_format')->formatCurrency($value['total'],$this->config->item('Currency_currency_shortname'))?></td>
                        </tr>
                      <?php }
                      ?>
                    <?php }else{ ?>
                      <tr>
                        <td>Project Budget Estimated</td>
                        <strong><td class="project_budget_info"></td></strong>
                      </tr>
                    <?php } ?>
                    <tr>
                      <td>Custom Requirement Budget Estimated</td>
                      <strong><td class="total_custom_requirement_amount_info"></td></strong>
                    </tr>
                    <tr>
                      <td>Total Project Budget</td>
                      <strong><td class="total_project_budget_info"></td></strong>
                    </tr>
                    <?php if($work_data->project_management_commission>0){ ?>
                      <tr>
                        <td>Total Project Management Commission Amount (Exclude Tax)</td>
                        <strong><td class="total_pm_commission_exclude_tax_info"></td></strong>
                      </tr>
                      <tr>
                        <td>Total Project Management Commission Amount (Include Tax)</td>
                        <strong><td class="total_pm_commission_include_tax_info"></td></strong>
                      </tr>
                    <?php } ?>
                    <?php if($work_data->profit_margin_percent>0){ ?>
                      <tr>
                        <td>Profit Margin %</td>
                        <strong><td class="total_profit_margin_percent_info"></td></strong>
                      </tr>
                      <tr>
                        <td>Total Project Margin Amount</td>
                        <strong><td class="total_profit_margin_amt_info"></td></strong>
                      </tr>
                    <?php } ?>
                  <?php } ?>
                  <?php if($this->session->userdata('user_role')!='supervisor'){?>
                    <tr>
                      <td></td>
                      <td></td>
                    </tr>
                    <?php if($this->session->userdata('user_role')!='purchase_manager' && $this->session->userdata('user_role')!='boq_manager'){?>
                      <?php if ($this->config->item('app_module_client_payments') == 1 ){?>
                        <tr>
                          <td>Total Client Invoice Receivable</td>
                          <strong><td class="total_client_invoice_receivable_info"></td></strong>
                        </tr>
                        <tr>
                          <td>Total Received on Invoice</td>
                          <strong><td class="total_client_invoice_received_info"></td></strong>
                        </tr>
                        <tr>
                          <td>Balance to Receive on Invoice</td>
                          <strong><td class="total_client_invoice_balance_info"></td></strong>
                        </tr>
                        <tr>
                          <td>Total Client Payment Received (Invoice + Advance)</td>
                          <strong><td class="total_received_from_client_info"></td></strong>
                        </tr>
                      <?php } ?>
                    <?php } ?>
                    <tr>
                      <td>Total Purchase Bill Commissions Received</td>
                      <strong><td class="purchase_bill_commission_info"></td></strong>
                    </tr>
                    <tr>
                      <td></td>
                      <td></td>
                    </tr>
                  <?php } ?>
                  <?php if ($this->config->item('app_module_purchase_order') == 1){?>
                    <tr>
                      <td>Total Purchase Order Amount (Not Included in Project Cost)</td>
                      <strong><td class="total_purchases_order_info"></td></strong>
                    </tr>
                  <?php } ?>
                  <tr>
                    <td>Total Purchase Bill Amount</td>
                    <strong><td class="total_purchases_bill_info"></td></strong>
                  </tr>
                  <?php if($this->config->item('app_module_purchase_order')==1){?>
                    <tr>
                      <td>Purchase Order Payments Made (Advances)</td>
                      <strong><td class="total_purchase_order_payments_info"></td></strong>
                    </tr>
                  <?php } ?>
                  <tr>
                    <td>Purchase Bill Payments Made</td>
                    <strong><td class="total_purchases_bill_payment_info"></td></strong>
                  </tr>
                  <?php if($this->config->item('app_module_purchase_order')==1){?>
                    <tr>
                      <td>Total Purchase Payments Made (Purchase Bill + Purchase Order)</td>
                      <strong><td class="total_purchase_payment_info"></td></strong>
                    </tr>
                  <?php } ?>
                  <tr>
                    <td>Pending Purchase Bill Payments</td>
                    <strong><td class="total_purchases_bill_pending_info"></td></strong>
                  </tr>
                  <tr>
                    <td>Total Purchase Return Amount</td>
                    <strong><td class="total_purchases_return_info"></td></strong>
                  </tr>
                  <tr>
                    <td></td>
                    <td></td>
                  </tr>
                  <?php if($this->config->item('app_module_stock_management')==1){?>
                    <tr>
                      <td>Total Stock Purchased Amount</td>
                      <strong><td class="total_purchases_bill_info"></td></strong>
                    </tr>
                    <tr>
                      <td>Total Stock Transfer In Amount</td>
                      <strong><td class="total_stock_transfer_in_info"></td></strong>
                    </tr>
                    <tr>
                      <td>Total Stock Transfer Out Amount</td>
                      <strong><td class="total_stock_transfer_out_info"></td></strong>
                    </tr>
                    <tr>
                      <td>Total Stock Consumed Amount</td>
                      <strong><td class="total_stock_consumed_info"></td></strong>
                    </tr>
                    <!-- <tr>
                    <td>Total Stock Returned Amount</td>
                    <strong><td class="total_stock_returned_info"></td></strong>
                  </tr> -->
                  <tr>
                    <td>Total Stock Balance Amount</td>
                    <strong><td class="total_stock_balance_info"></td></strong>
                  </tr>
                  <tr>
                    <td></td>
                    <td></td>
                  </tr>
                <?php } ?>
                <?php if($this->session->userdata('user_role')!='purchase_manager'){?>
                  <?php if ($this->config->item('app_module_vehicle') == 1){?>
                    <tr>
                      <td>Total Vehicle Work Slip Amount</td>
                      <strong><td class="total_vehicle_work_slip_amount"></td></strong>
                    </tr>
                    <tr>
                      <td>Total Vehicle Work Slip Payment</td>
                      <strong><td class="total_vehicle_payments_info"></td></strong>
                    </tr>
                  <?php } ?>
                  <tr>
                    <td>Total Subcontract Budget</td>
                    <strong><td class="total_subcontract_budget_info"></td></strong>
                  </tr>
                  <tr>
                    <td>Total Subcontract Bill Amount</td>
                    <strong><td class="total_subcontract_bill_info"></td></strong>
                  </tr>
                  <tr>
                    <td>Total Subcontract Payments (Bill+Advance)</td>
                    <strong><td class="total_subcontract_payment_info"></td></strong>
                  </tr>
                <?php } ?>
                <?php if($this->session->userdata('user_role')!='purchase_manager'){?>
                  <?php if ($this->config->item('app_module_labours') == 1){?>
                    <tr>
                      <td>Total Labour Wages</td>
                      <strong><td class="total_labour_wages_info"></td></strong>
                    </tr>
                  <?php } ?>
                <?php } ?>
                <?php if($this->session->userdata('user_role')!='purchase_manager'){?>
                  <tr>
                    <td>Total Salary Slip Amount</td>
                    <strong><td class="total_salary_slip_amount_info"></td></strong>
                  </tr>
                  <tr>
                    <td>Total Salary Payments</td>
                    <strong><td class="total_salary_payment_info"></td></strong>
                  </tr>
                <?php } ?>
                <?php if($this->session->userdata('user_role')!='purchase_manager'){?>
                  <tr>
                    <td>Total Other Expense Bill Amount</td>
                    <strong><td class="total_other_expense_bill_info"></td></strong>
                  </tr>
                <?php }?>
                <?php if($this->session->userdata('user_role')!='purchase_manager'){?>
                  <tr>
                    <td>Total Other Expense Payments</td>
                    <strong><td class="total_other_expense_payments_info"></td></strong>
                  </tr>
                <?php }?>
                <?php if($this->session->userdata('user_role')!='purchase_manager'){?>
                  <?php if($this->config->item('User_project_commission_payment')==1){ ?>
                    <tr>
                      <td>Total User Commission Payments</td>
                      <strong><td class="total_user_commission_payment_info"></td></strong>
                    </tr>
                  <?php } ?>
                <?php } ?>
                <?php if($this->session->userdata('user_role')!='purchase_manager'){?>
                  <?php if ($this->config->item('app_module_tools_management') == 1) { ?>
                    <tr>
                      <td>Total Tool Rent/Transfer Payments</td>
                      <strong><td class="total_tool_payments_info"></td></strong>
                    </tr>
                  <?php } ?>
                <?php } ?>
                <tr>
                  <td>Project Management Fees</td>
                  <strong><td class="total_project_management_fees_info"></td></strong>
                </tr>
                <tr>
                  <td>Project Supervision Charge</td>
                  <strong><td class="total_project_supervision_charge_info"></td></strong>
                </tr>
                <tr>
                  <td></td>
                  <td></td>
                </tr>
                <?php if($this->session->userdata('user_role')!='purchase_manager'){?>
                  <tr>
                    <td>Total Expense Payments</td>
                    <strong><td class="total_expense_payments_info"></td></strong>
                  </tr>
                  <tr>
                    <td>Total Project Cost (Including Stock Transfer)</td>
                    <strong><td class="total_project_cost_info"></td></strong>
                  </tr>
                  <?php  if($this->config->item('Project_commited_amount_show')==1){ ?>
                    <tr>
                      <td>Total Committed Amount (PO+Subcontract+Project Cost-Purchase Bill)</td>
                      <strong><td class="total_committed_amount_info"></td></strong>
                    </tr>
                  <?php } ?>
                  <tr>
                    <td>Total Payable Credit Balance (Exclude Labour)</td>
                    <strong><td class="total_payable_credit_info"></td></strong>
                  </tr>
                <?php } ?>
                <?php if($this->session->userdata('user_role')=='admin'){?>
                  <?php if($work_data->work_type==1){ ?>
                    <tr>
                      <td>Total Project Management Commission</td>
                      <strong><td class="total_commission_info"></td></strong>
                    </tr>
                  <?php } ?>
                  <?php if ($this->config->item('app_module_client_payments') == 1 ){?>
                    <tr>
                      <td>Total Amount to Receive From Client</td>
                      <strong><td class="total_amount_to_receive_info"></td></strong>
                    </tr>
                    <tr>
                      <td>Actual Received</td>
                      <strong><td class="total_received_from_client_info"></td></strong>
                    </tr>
                    <tr>
                      <td>Balance to Receive on Budget</td>
                      <strong><td class="total_balance_info"></td></strong>
                    </tr>
                    <tr>
                      <td>Total Project Profit (Actual Received - Actual Expense)</td>
                      <strong><td class="total_profit_info"></td></strong>
                    </tr>
                  <?php } ?>
                <?php } ?>
              </tbody>
            </table>
          </div>
        </div>
        <div class="m-portlet  m-portlet--rounded m-portlet--bordered">
          <div class="m-portlet__body">
            <h3 class="m-portlet__head-text" style="text-align: center">
              Project Cost Summary
            </h3>
            <table width="100%" class="table m-table nowrap table-header-fixed table-striped table-bordered table-hover table-header-fixed" id="table_summary">
              <thead>
                <tr class="">
                  <th>Heads</th>
                  <th>Amount</th>
                </tr>
              </thead>
              <tbody>
                  <tr>
                    <td>Total Purchase Bill Amount (+)</td>
                    <strong><td class="total_purchases_bill_info"></td></strong>
                  </tr>
                  <tr>
                    <td>Total Stock Transfer In Amount (+)</td>
                    <strong><td class="total_stock_transfer_in_info"></td></strong>
                  </tr>

                <?php if($this->session->userdata('user_role')!='purchase_manager'){?>
                  <?php if ($this->config->item('app_module_vehicle') == 1){?>
                    <tr>
                      <td>Total Vehicle Work Slip Amount (+)</td>
                      <strong><td class="total_vehicle_work_slip_amount"></td></strong>
                    </tr>
                  <?php } ?>
                  <tr>
                    <td>Total Subcontract Payments (Bill+Advance) (+)</td>
                    <strong><td class="total_subcontract_payment_info"></td></strong>
                  </tr>
                <?php } ?>
                <?php if($this->session->userdata('user_role')!='purchase_manager'){?>
                  <?php if ($this->config->item('app_module_labours') == 1){?>
                    <tr>
                      <td>Total Labour Wages (+)</td>
                      <strong><td class="total_labour_wages_info"></td></strong>
                    </tr>
                  <?php } ?>
                <?php } ?>
                <?php if($this->session->userdata('user_role')!='purchase_manager'){?>
                  <tr>
                    <td>Total Salary Slip Amount (+)</td>
                    <strong><td class="total_salary_slip_amount_info"></td></strong>
                  </tr>
                <?php } ?>
                <?php if($this->session->userdata('user_role')!='purchase_manager'){?>
                  <tr>
                    <td>Total Other Expense Bill Amount (+)</td>
                    <strong><td class="total_other_expense_bill_info"></td></strong>
                  </tr>
                <?php }?>
                <?php if($this->session->userdata('user_role')!='purchase_manager'){?>
                  <?php if($this->config->item('User_project_commission_payment')==1){ ?>
                    <tr>
                      <td>Total User Commission Payments (+)</td>
                      <strong><td class="total_user_commission_payment_info"></td></strong>
                    </tr>
                  <?php } ?>
                <?php } ?>
                <?php if($this->session->userdata('user_role')!='purchase_manager'){?>
                  <?php if ($this->config->item('app_module_tools_management') == 1) { ?>
                    <tr>
                      <td>Total Tool Rent/Transfer Payments (+)</td>
                      <strong><td class="total_tool_payments_info"></td></strong>
                    </tr>
                  <?php } ?>
                <?php } ?>
                <tr>
                  <td></td>
                  <td></td>
                </tr>
                <tr>
                  <td>Total Purchase Return Amount (-)</td>
                  <strong><td class="total_purchases_return_info"></td></strong>
                </tr>
                <tr>
                  <td>Total Stock Transfer Out Amount (-)</td>
                  <strong><td class="total_stock_transfer_out_info"></td></strong>
                </tr>
                <tr>
                  <td></td>
                  <td></td>
                </tr>
                <?php if($this->session->userdata('user_role')!='purchase_manager'){?>
                  <tr>
                    <td>Total Project Cost</td>
                    <strong><td class="total_project_cost_info"></td></strong>
                  </tr>
                <?php } ?>
              </tbody>
            </table>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>
<?php $this->view("includes/Inc_scripts");?>
<!--end::Base Scripts -->
<script>
$("#page_title").text("Project summary - #<?php echo $work_data->work_id.' - '.$work_data->work_name?>");
$(".data_display_option").change(function(event) {
  var data = $(this).val();
  if($(this).is(":checked")) {
    $(".div_"+data).removeClass('print_hide_div');
    $(".div_"+data).show();
  }else{
    $(".div_"+data).addClass('print_hide_div');
    $(".div_"+data).hide();
  }
});
$(".data_display_check_all").change(function(event) {
  var data = $(this).val();
  if($(this).is(":checked")) {
    if(data=='check_all'){
      $(".data_display_option").prop('checked',true).trigger('change');
      $("input[type=checkbox][value='uncheck_all']").prop("checked",false);
    }else{
      $(".data_display_option").prop('checked',false).trigger('change');
      $("input[type=checkbox][value='check_all']").prop("checked",false);
    }
  }
});
$("#table_filter_start_date,#table_filter_end_date").datepicker( {
  todayHighlight:!0, orientation:"bottom left", templates: {
    leftArrow: '<i class="la la-angle-left"></i>', rightArrow: '<i class="la la-angle-right"></i>'
  }
})
function GetStartDate(){
  return $('#table_filter_start_date').val();
}
function GetEndDate(){
  return $('#table_filter_end_date').val();
}
$(".table_filter").on("change", function() {
  var start_date=GetStartDate();
  var end_date=GetEndDate();
  if(start_date!=''||end_date!=''){
    $(".date_filter_hide_fields").hide();
  }else{
    $(".date_filter_hide_fields").show();
  }
  select_summary();
});
var work_info_table = $('#work_info_table').DataTable({
  "bProcessing": true,
  "deferRender": true,
  "bDeferRender": true,
  "scrollX": false,
  bFilter: false,
  "bLengthChange": false,
  "bPaginate": false,
  "bInfo": false,
  "dom": "<'row' <'col-md-12'>><'row'<'col-md-6 col-sm-12'l><'col-md-6 col-sm-12'f>r><'table-scrollable't><'row'<'col-md-5 col-sm-12'i><'col-md-7 col-sm-12'p>>", // horizobtal scrollable datatable
  "columnDefs": [
    {
      "targets": [],
      className: "hidden"
    }
  ],
  'ordering': false
});

select_summary();
function select_summary(){
  var work_id = "<?php echo $work_data->work_id?>";
  $.post("<?php echo base_url().'work/select_summary/count' ?>",{
    work_id:work_id,start_date:GetStartDate(),end_date:GetEndDate()
  },function(data){
    var obj= $.parseJSON(data);
    $(".project_budget_info").html(obj.project_budget);
    $(".total_custom_requirement_amount_info").html(obj.total_custom_requirement_amount);
    $(".total_project_budget_info").html(obj.total_project_budget);
    $(".total_pm_commission_exclude_tax_info").html(obj.total_pm_commission_exclude_tax);
    $(".total_pm_commission_include_tax_info").html(obj.total_pm_commission_include_tax);
    $(".total_profit_margin_percent_info").html(obj.total_profit_margin_percent);
    $(".total_profit_margin_amt_info").html(obj.total_profit_margin_amt);
    $(".total_client_invoice_receivable_info").html(obj.total_client_invoice_receivable);
    $(".total_client_invoice_received_info").html(obj.total_client_invoice_received);
    $(".total_client_invoice_balance_info").html(obj.total_client_invoice_balance);
    $(".total_received_from_client_info").html(obj.total_client_payments_received);
    $(".purchase_bill_commission_info").html(obj.total_purchase_bill_commission);
    $(".total_purchases_bill_info").html(obj.total_purchase_bill_amount);
    $(".total_purchases_order_info").html(obj.total_purchase_order_amount);
    $(".total_purchase_order_payments_info").html(obj.total_purchase_order_payment);
    $(".total_purchases_bill_payment_info").html(obj.total_purchase_bill_payment);
    $(".total_purchase_payment_info").html(obj.total_purchase_payment);
    $(".total_purchases_bill_pending_info").html(obj.total_purchase_bill_balance_amount);
    $(".total_purchases_return_info").html(obj.total_purchase_retrun_amount);
    $(".total_subcontract_payment_info").html(obj.total_subcontract_payment);
    $(".total_subcontract_budget_info").html(obj.total_subcontract_amount);
    $(".total_subcontract_bill_info").html(obj.total_subcontract_bill_amount);
    $(".total_vehicle_payments_info").html(obj.total_vehicle_payments);
    $(".total_vehicle_work_slip_amount").html(obj.total_vehicle_work_slip_amount);
    $(".total_labour_wages_info").html(obj.total_labour_wages);
    $(".total_tool_payments_info").html(obj.total_tool_payments);
    $(".total_salary_slip_amount_info").html(obj.total_salary_slip_amount);
    $(".total_salary_payment_info").html(obj.total_salary_payments);

    $(".total_project_management_fees_info").html(obj.total_project_management_fees);
    $(".total_project_supervision_charge_info").html(obj.total_project_supervision_charge);
    $(".total_other_expense_payments_info").html(obj.total_other_expense);
    $(".total_other_expense_bill_info").html(obj.total_expense_bill_amount);
    $(".total_user_commission_payment_info").html(obj.total_user_commission_payments);
    $(".total_expense_payments_info").html(obj.total_expense_amount);
    $(".total_project_cost_info").html(obj.total_project_cost);
    $(".total_committed_amount_info").html(obj.total_committed_amount);
    $(".total_payable_credit_info").html(obj.total_credit_bill_amount);
    $(".total_commission_info").html(obj.total_project_commission_amount);
    $(".total_amount_to_receive_info").html(obj.total_amount_to_receive);
    $(".total_balance_info").html(obj.balance_to_receive);
    $(".total_profit_info").html(obj.total_profit);

    $(".total_labours_worked_info").html(obj.total_labours_worked);
    $(".total_labours_days_info").html(obj.total_labour_days);
    $(".total_labours_wage_info").html(obj.total_labour_wages);

    $(".total_stock_transfer_in_info").html(obj.total_stock_transfer_in_amount);
    $(".total_stock_transfer_out_info").html(obj.total_stock_transfer_out_amount);
    $(".total_stock_consumed_info").html(obj.total_stock_consumption_amount);
    $(".total_stock_balance_info").html(obj.total_stock_balance_amount);
  })
}
</script>
<!-- Client Payment Scripts -->
<?php $this->view("modules/include_scripts/invoices_scripts");?>
<?php $this->view("modules/include_scripts/client_payments_scripts");?>
<?php $this->view("modules/include_scripts/emd_scripts");?>
<?php $this->view("modules/include_scripts/security_deposit_scripts");?>
<!-- Purchase Order Payments Scripts -->
<?php $this->view("modules/include_scripts/purchase_order_view_scripts");?>
<?php $this->view("modules/include_scripts/purchase_order_payments_view_scripts");?>

<!-- Purchase Bill Payments Scripts -->
<?php $this->view("modules/include_scripts/purchase_bill_view_scripts");?>
<?php $this->view("modules/include_scripts/purchase_bill_payments_view_scripts");?>
<?php $this->view("modules/include_scripts/materials_purchased_view_scripts");?>
<?php $this->view("modules/include_scripts/stock_transfer_view_scripts");?>
<!-- Subcontract Scripts -->
<?php $this->view("modules/include_scripts/subcontracts_view_scripts");?>

<!-- Subcontract Payments Scripts -->
<?php $this->view("modules/include_scripts/subcontracts_view_scripts");?>

<!-- Subcontract Payments Scripts -->
<?php $this->view("modules/include_scripts/subcontract_bill_scripts");?>
<?php $this->view("modules/include_scripts/subcontract_payments_view_scripts");?>

<!-- Expense Scripts -->
<?php $this->view("modules/include_scripts/expense_bill_scripts");?>

<!-- Labour Wage Scripts -->
<?php $this->view("modules/include_scripts/labour_wage_scripts");?>

<!-- Salary Slip Scripts -->
<?php $this->view("modules/include_scripts/salary_slips_scripts");?>

<!-- Tool Payment Scripts -->
<?php $this->view("modules/include_scripts/tool_consumption_payment_script");?>
<?php if($this->session->userdata('user_role')!='purchase_manager'){?>
  <!-- Vehicle Work SLip -->
  <?php $this->view("modules/include_scripts/vehicle_work_scripts");?>
<?php } ?>

<script>
jQuery(document).ready(function() {
  $($.fn.dataTable.tables(true)).DataTable()
  .columns.adjust()
  .responsive.recalc();
  $('#print').click(function(e) {
    window.print();
  })
});
</script>
<style>
.hidden{
  display: none;
}
</style>
</body>
</html>
