<?php $this->view("includes/Inc_pagehead");?>
<!-- Page Styles Goes Here-->
<style>
.m-form .m-form__group {
  padding-top: 0px;
  padding-bottom: 0px;
}
</style>
<?php $this->view("includes/Inc_navigation");?>
<div class="m-grid__item m-grid__item--fluid m-wrapper">
  <!-- BEGIN: Subheader -->
  <div class="m-subheader ">
    <div class="d-flex align-items-center">
      <div class="mr-auto">
        <h3 class="m-subheader__title m-subheader__title--separator">
          Edit Project Details
        </h3>
        <ul class="m-subheader__breadcrumbs m-nav m-nav--inline">
          <li class="m-nav__item m-nav__item--home">
            <a href="#" class="m-nav__link m-nav__link--icon">
              <i class="m-nav__link-icon la la-home"></i>
            </a>
          </li>
          <li class="m-nav__separator">
            -
          </li>
          <li class="m-nav__item">
            <a href="<?php echo $this->session->userdata("dashboard_link")?>" class="m-nav__link">
              <span class="m-nav__link-text">
                Home
              </span>
            </a>
          </li>
          <li class="m-nav__separator">
            -
          </li>
          <li class="m-nav__item">
            <a href="<?php echo base_url().'project/add' ?>" class="m-nav__link">
              <span class="m-nav__link-text">
                Edit Project Details
              </span>
            </a>
          </li>


        </ul>
      </div>
      <div>

      </div>
    </div>
  </div>
  <!-- END: Subheader -->
  <div class="m-content">
    <!--begin::Portlet-->
    <div class="row">
      <div class="col-lg-1"></div>
      <div class="col-lg-10">
        <div class="m-portlet">
          <div class="m-portlet__head">
            <div class="m-portlet__head-caption">
              <div class="m-portlet__head-title">
                <h3 class="m-portlet__head-text">
                  Edit Project Details
                </h3>
              </div>
            </div>
          </div>
          <!--begin::Form-->
          <form autocomplete="off"  data-form-type="project_edit" id="form_project_edit" method="post" action="<?php echo base_url().'work/update'?>" enctype="multipart/form-data" class="m-form m-form--fit m-form--state m-form--label-align-right ">
            <div class="m-portlet__body" >
              <div class="m-form__content">
                <div class="m-alert m-alert--icon alert alert-warning m--hide" role="alert" id="form_project_edit_msg">
                  <div class="m-alert__icon">
                    <i class="la la-warning"></i>
                  </div>
                  <div class="m-alert__text">
                    Oh snap! Change a few things up and try submitting again.
                  </div>
                  <div class="m-alert__close">
                    <button type="button" class="close" data-close="alert" aria-label="Close"></button>
                  </div>
                </div>
                <input type="hidden" name="work_id" value="<?php echo $project_data->work_id?>"  />
                <div class="row">
                  <?php if ($this->config->item('Project_parent_child_enable') == 1) { ?>
                    <div class="col-lg-4">
                      <div class="form-group m-form__group">
                        <label>
                          Project Type
                        </label>
                        <div class="m-radio-inline" style="padding-top: 10px;">
                          <label class="m-radio m-radio--solid m-radio--state-danger">
                            <input required type="radio" class="form_fields_radio"  name="project_master_type" value="0"> Master/Main Project
                            <span></span>
                          </label>
                          <label class="m-radio m-radio--solid m-radio--state-warning">
                            <input type="radio" class="form_fields_radio" name="project_master_type"  value="1"> Child/Sub Project
                            <span></span>
                          </label>
                        </div>
                        <span class="m-form__help"></span>
                      </div>
                    </div>
                    <div class="col-lg-4">
                      <div class="form-group m-form__group" style="display:none" id="parent_project_div">
                        <label>
                          Main Project
                        </label>
                        <div class="m-select2 m-select2--air m-select2--pill">
                          <select width="100%"   class="form-control m-select2" id="parent_project" name="parent_project"  >
                            <option selected disabled> Select Main Project</option>
                            <?php foreach ($master_projects as $key => $value) {?>
                              <option value="<?php echo $value->work_id?>">#<?php echo $value->work_id.' - '.$value->work_name.' ['.$value->client_name.']'?></option>
                            <?php } ?>
                          </select>
                        </div>
                        <span class="m-form__help"></span>
                      </div>
                    </div>
                  <?php } ?>
                  <?php if ($this->config->item('multi_company') == 1) { ?>
                    <div class="col-lg-4">
                      <div class="form-group m-form__group main_project_fields_div">
                        <label>
                          Company
                        </label>
                        <div class="m-select2 m-select2--air m-select2--pill">
                          <select width="100%" required  class="form-control m-select2 main_project_fields" id="company" name="company"  >
                            <option selected disabled> Select Company</option>
                            <?php foreach ($companies as $key => $value) {?>
                              <option value="<?php echo $value->company_id?>"><?php echo $value->company_name?></option>
                            <?php } ?>
                          </select>
                        </div>
                        <span class="m-form__help"></span>
                      </div>
                    </div>
                  <?php } ?>
                  <div class="col-lg-4">
                    <div class="form-group m-form__group">
                      <label>
                        Project Status
                      </label>
                      <div class="m-radio-inline" style="padding-top: 10px;">
                        <label class="m-radio m-radio--solid m-radio--state-info">
                          <input required type="radio" class="form_fields_radio" name="project_op_status" value="New"> New Project
                          <span></span>
                        </label>
                        <label class="m-radio m-radio--solid m-radio--state-focus">
                          <input type="radio" class="form_fields_radio" name="project_op_status"  value="Ongoing"> Ongoing Project
                          <span></span>
                        </label>
                      </div>
                      <span class="m-form__help"></span>
                    </div>
                  </div>
                </div>
                <div class="row">
                  <div class="col-lg-4">
                    <div class="form-group m-form__group">
                      <label>
                        Project Section
                      </label>
                      <div class="m-select2 m-select2--air m-select2--pill">
                        <select width="100%" required  class="form-control m-select2" id="project_section" name="project_section"  >
                          <option selected disabled> Select Project Section</option>
                          <?php foreach ($this->config->item('project_sections') as $key => $value) {?>
                            <option value="<?php echo $value->section_name?>"><?php echo $value->section_name?></option>
                          <?php } ?>
                        </select>
                      </div>
                      <span class="m-form__help"></span>
                    </div>
                  </div>
                  <div class="col-lg-4">
                    <div class="form-group m-form__group">
                      <label>
                        Project Category
                      </label>
                      <div class="m-select2 m-select2--air m-select2--pill">
                        <select width="100%" required  class="form-control m-select2" id="project_type" name="project_type"  >
                          <option selected disabled> Select Project Category</option>
                          <?php foreach ($work_category as $key => $value) {?>
                            <option value="<?php echo $value->wcat_id?>"><?php echo $value->wcat_name?></option>
                          <?php } ?>
                        </select>
                      </div>
                      <span class="m-form__help"></span>
                    </div>
                  </div>
                  <div class="col-lg-4">
                    <div class="form-group m-form__group">
                      <label>
                        <?php echo $this->config->item('Project_reference_no_title') ?>
                      </label>
                      <div class="m-input-icon m-input-icon--right">
                        <input type="text" style="text-transform:uppercase" value="<?php echo $project_data->reference_no?>" name="reference_no" class="form-control m-input m-input--pill m-input--air" placeholder="<?php echo $this->config->item('Project_reference_no_title') ?>"  aria-describedby="basic-addon1">
                        <span class="m-input-icon__icon m-input-icon__icon--right"><span><i class="la la-tag"></i></span></span>
                      </div>
                      <span class="m-form__help"></span>
                    </div>
                  </div>
                </div>
                <div class="form-group m-form__group">
                  <label>
                    Project Name
                  </label>
                  <div class="m-input-icon m-input-icon--right">
                    <input value="<?php echo $project_data->work_name?>" required type="text" name="name" class="form-control m-input m-input--pill m-input--air" placeholder="Project Name"  aria-describedby="basic-addon1">
                    <span class="m-input-icon__icon m-input-icon__icon--right"><span><i class="la la-tag"></i></span></span>
                  </div>
                  <span class="m-form__help"></span>
                </div>
                <div class="row">
                  <div class="col-lg-8">
                    <div class="form-group m-form__group">
                      <label>
                        Location
                      </label>
                      <div class="m-input-icon m-input-icon--right">
                        <input value="<?php echo $project_data->work_location?>" required type="text" name="location" class="form-control m-input m-input--pill m-input--air" placeholder="Project Location"  aria-describedby="basic-addon1">
                        <span class="m-input-icon__icon m-input-icon__icon--right"><span><i class="fa fa-map-marked"></i></span></span>
                      </div>
                      <span class="m-form__help"></span>
                    </div>
                  </div>
                  <div class="col-lg-4">
                    <div class="form-group m-form__group">
                      <label>
                        Location Area
                      </label>
                      <div class="input-group m-input-group  m-input-group--pill  m-input-group--air">
                        <div class="input-group-prepend">
                          <a href="#area_location_add_modal"   data-toggle="modal" data-target="#area_location_add_modal" class="btn btn-focus">
                            <i class="fa fa-plus-circle"></i>
                          </a>
                        </div>
                        <select width="90%" class="form-control m-select2" id="location_area" name="location_area"  >

                        </select>
                      </div>
                      <span class="m-form__help"></span>
                    </div>
                  </div>
                </div>
                <div class="row">
                  <div class="col-lg-7">
                    <div class="row">
                      <div class="col-lg-6">
                        <div class="form-group m-form__group">
                          <label>
                            Starting Date
                          </label>
                          <div class="m-input-icon m-input-icon--right">
                            <input  value="<?php if($project_data->planned_date_of_start!='0000-00-00'){echo date('d-m-Y',strtotime($project_data->planned_date_of_start));}?>" data-date-format="dd-mm-yyyy" type="text" name="start_date" id="start_date" class="form-control m-input m-input--pill m-input--air" placeholder="Planned Date of Start"  aria-describedby="basic-addon1">
                            <span class="m-input-icon__icon m-input-icon__icon--right"><span><i class="fa fa-calendar"></i></span></span>
                          </div>
                          <span class="m-form__help"></span>
                        </div>
                      </div>
                      <div class="col-lg-6">
                        <div class="form-group m-form__group">
                          <label>
                            Completion Date
                          </label>
                          <div class="m-input-icon m-input-icon--right">
                            <input  value="<?php if($project_data->planned_date_of_completion!='0000-00-00'){echo date('d-m-Y',strtotime($project_data->planned_date_of_completion));}?>" data-date-format="dd-mm-yyyy" type="text" name="completion_date" id="completion_date" class="form-control m-input m-input--pill m-input--air" placeholder="Planned Date of Completion"  aria-describedby="basic-addon1">
                            <span class="m-input-icon__icon m-input-icon__icon--right"><span><i class="fa fa-calendar"></i></span></span>
                          </div>
                          <span class="m-form__help"></span>
                        </div>
                      </div>
                    </div>
                  </div>
                  <div class="col-lg-5">
                    <div class="form-group m-form__group">
                      <label>
                        Priority
                      </label>
                      <div class="m-radio-inline" style="padding-top: 10px;">
                        <label class="m-radio m-radio--solid m-radio--state-danger">
                          <input required type="radio" class="form_fields_radio"  name="priority" value="1"> High
                          <span></span>
                        </label>
                        <label class="m-radio m-radio--solid m-radio--state-warning">
                          <input type="radio" class="form_fields_radio" name="priority"  value="2"> Med
                          <span></span>
                        </label>
                        <label class="m-radio m-radio--solid m-radio--state-info">
                          <input type="radio" class="form_fields_radio" name="priority"  value="0"> Low
                          <span></span>
                        </label>
                      </div>
                      <span class="m-form__help"></span>
                    </div>
                  </div>
                </div>
                <?php if(!empty($enquiry_data)){ ?>
                  <input type="hidden" name="customer" value="<?php echo $enquiry_data->customer_id?>">
                  <input type="hidden" name="enquiry_id" value="<?php echo $enquiry_data->enquiry_id?>">
                  <div class="row">
                    <div class="col-lg-2">
                      <div class="form-group m-form__group">
                        <label>Customer ID</label>
                        <input disabled type="text" value="<?php echo $enquiry_data->customer_id?>" class="form-control m-input m-input--air m-input--pill">
                        <span class="m-form__help"></span>
                      </div>
                    </div>
                    <div class="col-lg-6">
                      <div class="form-group m-form__group">
                        <label>Customer/Company Name</label>
                        <input disabled type="text" value="<?php echo $enquiry_data->customer_name?>" class="form-control m-input m-input--air m-input--pill">
                        <span class="m-form__help"></span>
                      </div>
                    </div>
                    <div class="col-lg-4">
                      <div class="form-group m-form__group">
                        <label>Contact Person</label>
                        <input disabled type="text" value="<?php echo $enquiry_data->enq_contact_person?>" class="form-control m-input m-input--air m-input--pill">
                        <span class="m-form__help"></span>
                      </div>
                    </div>
                    <div class="col-lg-4">
                      <div class="form-group m-form__group">
                        <label>Location</label>
                        <input disabled type="text" value="<?php echo $enquiry_data->customer_location?>" class="form-control m-input m-input--air m-input--pill">
                        <span class="m-form__help"></span>
                      </div>
                    </div>
                    <div class="col-lg-4">
                      <div class="form-group m-form__group">
                        <label>Phone</label>
                        <input disabled type="text" value="<?php echo $enquiry_data->enq_contact_person_mobile?>" class="form-control m-input m-input--air m-input--pill">
                        <span class="m-form__help"></span>
                      </div>
                    </div>
                    <div class="col-lg-4">
                      <div class="form-group m-form__group">
                        <label>Email</label>
                        <input disabled type="text" value="<?php echo $enquiry_data->customer_email?>" class="form-control m-input m-input--air m-input--pill">
                        <span class="m-form__help"></span>
                      </div>
                    </div>
                  </div>
                <?php }else{ ?>
                  <div class="row">
                    <div class="col-lg-12">
                      <div class="form-group m-form__group main_project_fields_div">
                        <label>
                          Client
                        </label>
                        <div class="input-group m-input-group  m-input-group--pill  m-input-group--air">
                          <div class="input-group-prepend">
                            <a href="#client_add_modal"   data-toggle="modal" data-target="#client_add_modal" class="btn btn-focus">
                              <i class="fa fa-plus-circle"></i>
                            </a>
                          </div>
                          <select width="90%" class="form-control m-select2 m-select2-general main_project_fields" required id="client" name="client">

                          </select>
                        </div>
                        <span class="m-form__help"></span>
                      </div>
                    </div>
                  </div>
                <?php } ?>
                <div style="background: white;border: 4px solid #f7f7fa;padding: 15px;margin: 5px;padding-bottom: 0px">
                  <div class="m-section" style="margin-bottom: 10px">
                    <h3 class="m-section__heading">Project Budget</h3>
                    <div class="row">
                      <div class="col-lg-12">
                        <table style="width: 100%;max-width: 100%" id="table_budget" class="table m-table table-bordered item_table m-table--head-bg-success">
                          <thead>
                            <tr>
                              <?php if($this->config->item('Project_multiple_budget')==1){  ?>
                                <th style="width:6%;text-align:left;color:white">Sl No</th>
                                <th style="width:25%;text-align:left;color:white">Section Name</th>
                              <?php } ?>
                              <th style="width:20%;text-align:left;color:white">Estimated Budget Amt</th>
                              <th style="width:15%;text-align:left;color:white"><?php echo $this->config->item('Tax_tax_name')?> %</th>
                              <?php if($this->config->item('Project_multiple_budget')==0){  ?>
                                <th style="width:15%;text-align:left;color:white;display:none" class="taxable_field">Taxable Amt</th>
                              <?php } ?>
                              <th style="width:15%;text-align:left;color:white"><?php echo $this->config->item('Tax_tax_name')?> Amount</th>
                              <th style="width:30%;text-align:left;color:white">Total Amt</th>
                              <?php if($this->config->item('Project_multiple_budget')==1){  ?>
                                <th style="width:6%;text-align:left;color:white">&nbsp;</th>
                              <?php } ?>
                            </tr>
                          </thead>
                          <tbody id="table_body_budget">
                            <?php if($this->config->item('Project_multiple_budget')==1){
                              $budget_details = unserialize($project_data->project_budget_details);
                              foreach ($budget_details as $key => $value) { ?>
                                <tr class="row_<?php echo $key+1?>">
                                  <td>
                                    <div class="form-group m-form__group" style="padding: 0px !important;margin: 0px !important;">
                                      <div class="input-group m-input-group m-input-group--pill m-input-group--air"><input style="padding: 10px" readonly type="text" class="form-control m-input item_slno" data-sl-no="<?php echo $key+1?>" name="budget[sl_no][<?php echo $key?>]" value="<?php echo $key+1?>" /></div>
                                    </div>
                                  </td>
                                  <td>
                                    <div class="form-group m-form__group" style="padding: 0px !important;margin: 0px !important;">
                                      <input required type="text" name="budget[section][<?php echo $key?>]" data-slno="<?php echo $key+1?>" id="budget_section_<?php echo $key+1?>" value="<?php echo $value['section']?>" class="form-control m-input m-input--pill m-input--air tax_fields" placeholder="Section Name"  aria-describedby="basic-addon1">
                                    </div>
                                  </td>
                                  <td>
                                    <div class="form-group m-form__group" style="padding: 0px !important;margin: 0px !important;">
                                      <input type="text" name="budget[amount][<?php echo $key?>]" data-slno="<?php echo $key+1?>" required id="budget_amount_<?php echo $key+1?>" value="<?php echo $value['amount']?>" class="form-control m-input m-input--pill m-input--air tax_fields" placeholder="Estimated Budget"  aria-describedby="basic-addon1">
                                    </div>
                                  </td>
                                  <td>
                                    <div class="form-group m-form__group" style="padding: 0px !important;margin: 0px !important;">
                                      <div class="m-select2 m-select2--air m-select2--pill ">
                                        <select required id="tax_percent_<?php echo $key+1?>" data-slno="<?php echo $key+1?>" name="budget[tax_percent][<?php echo $key?>]" style="width: 100%" class="form-control m-input tax_fields" aria-describedby="basic-addon1" data-placeholder="Select Tax Percentage">
                                          <?php
                                          $tax_percent = $this->config->item('Tax_tax_percent_old');
                                          foreach($tax_percent as $row):
                                            $selected_tax='';
                                            if($row==0){
                                              $selected_tax='selected';
                                            }
                                            ?>
                                            <option <?php echo $selected_tax?> value="<?php echo $row?>"><?php echo $row?>%</option>
                                            <?php
                                          endforeach;
                                          ?>
                                        </select>
                                      </div>
                                    </div>
                                  </td>
                                  <td>
                                    <div class="form-group m-form__group" style="padding: 0px !important;margin: 0px !important;">
                                      <input readonly  type="text" data-slno="<?php echo $key+1?>" id="tax_amount_<?php echo $key+1?>" name="budget[tax_amount][<?php echo $key?>]" value="<?php echo $value['tax_amount']?>" class="form-control m-input m-input--pill m-input--air" placeholder="<?php echo $this->config->item('Tax_tax_name')?> Amount"  aria-describedby="basic-addon1">
                                    </div>
                                  </td>
                                  <td>
                                    <div class="form-group m-form__group" style="padding: 0px !important;margin: 0px !important;">
                                      <input readonly class="form-control m-input m-input--pill m-input--air total_budget_fields" type="text" name="budget[total][<?php echo $key ?>]" id="total_budget_<?php echo $key+1?>" value="<?php echo $value['total']?>">
                                    </div>
                                  </td>
                                  <td>
                                    <a href="javascript:" data-row-sl-no="<?php echo $key+1?>" class="ibtnDel_budget btn btn-danger m-btn--icon btn-sm  m-btn--icon-only m-btn--pill m-btn--air">
                                      <i class="fa fa-trash"></i>
                                    </td>
                                  </tr>
                                <?php }
                              }else{ ?>
                                <tr class="row_1">
                                  <td>
                                    <div class="form-group m-form__group" style="padding: 0px !important;margin: 0px !important;">
                                      <input type="text" name="budget[amount][0]" data-slno="1" required id="budget_amount_1" value="<?php echo $project_data->est_budget_amt?>" class="form-control m-input m-input--pill m-input--air tax_fields" placeholder="Estimated Budget"  aria-describedby="basic-addon1">
                                    </div>
                                  </td>
                                  <td>
                                    <div class="form-group m-form__group" style="padding: 0px !important;margin: 0px !important;">
                                      <div class="m-select2 m-select2--air m-select2--pill ">
                                        <select required id="tax_percent_1" data-slno="1" name="budget[tax_percent][0]" style="width: 100%" class="form-control m-input tax_fields" aria-describedby="basic-addon1" data-placeholder="Select Tax Percentage">
                                          <?php
                                          $tax_percent = $this->config->item('Tax_tax_percent_old');
                                          foreach($tax_percent as $row):
                                            $selected_tax='';
                                            if($row==0){
                                              $selected_tax='selected';
                                            }
                                            ?>
                                            <option <?php echo $selected_tax?> value="<?php echo $row?>"><?php echo $row?>%</option>
                                            <?php
                                          endforeach;
                                          ?>
                                        </select>
                                      </div>
                                    </div>
                                    <?php if($this->config->item('Project_multiple_budget')==0){  ?>
                                      <div class="form-group m-form__group">
                                        <div class="m-radio-inline" style="padding-top: 10px;">
                                          <label class="m-radio m-radio--solid m-radio--state-danger">
                                            <input required type="radio" class="form_fields_radio tax_fields" data-slno="1"   name="budget[tax_type][0]" <?php if($project_data->project_tax_included==1){ echo "checked";} ?> value="1"> Included
                                            <span></span>
                                          </label>
                                          <label class="m-radio m-radio--solid m-radio--state-warning">
                                            <input type="radio" class="form_fields_radio tax_fields" data-slno="1"  name="budget[tax_type][0]" <?php if($project_data->project_tax_included==0){ echo "checked";} ?> value="0"> Excluded
                                            <span></span>
                                          </label>
                                        </div>
                                        <span class="m-form__help"></span>
                                      </div>
                                    <?php } ?>
                                  </td>
                                  <?php if($this->config->item('Project_multiple_budget')==0){  ?>
                                    <td style="display:none" class="taxable_field">
                                      <div class="form-group m-form__group" style="padding: 0px !important;margin: 0px !important;">
                                        <input readonly value="0" type="text" data-slno="1" id="taxable_amount_1" name="budget[taxable_amount][0]" class="form-control m-input m-input--pill m-input--air" placeholder="Taxable Amount"  aria-describedby="basic-addon1">
                                      </div>
                                    </td>
                                  <?php } ?>
                                  <td>
                                    <div class="form-group m-form__group" style="padding: 0px !important;margin: 0px !important;">
                                      <input readonly  type="text" data-slno="1" id="tax_amount_1" name="budget[tax_amount][0]" value="<?php echo $project_data->project_tax_amount?>" class="form-control m-input m-input--pill m-input--air" placeholder="<?php echo $this->config->item('Tax_tax_name')?> Amount"  aria-describedby="basic-addon1">
                                    </div>
                                  </td>
                                  <td>
                                    <div class="form-group m-form__group" style="padding: 0px !important;margin: 0px !important;">
                                      <input readonly class="form-control m-input m-input--pill m-input--air total_budget_fields" type="text" name="budget[total][0]" id="total_budget_1" value="<?php echo $project_data->total_budget_amount?>">
                                    </div>
                                  </td>
                                </tr>
                              <?php } ?>
                            </tbody>
                            <tfoot>
                              <?php if($this->config->item('Project_multiple_budget')==1){  ?>
                                <tr>
                                  <td colspan="10" style="text-align: left;border-bottom: 1px solid #e7ecf1;">
                                    <button type="button" class="btn btn-block " id="addrow_budget"><i class="fa fa-plus-square"></i> Add New Budget Section</button>
                                  </td>
                                </tr>
                              <?php } ?>
                            </tfoot>
                          </table>
                          <input type="hidden" value="<?php if($this->config->item('Project_multiple_budget')==1){ echo sizeof($budget_details);}else{ echo 1;}?>" id="current_row_count_budget_and_conditions" name="current_row_count_budget">
                          <input type="hidden" value="<?php if($this->config->item('Project_multiple_budget')==1){ echo sizeof($budget_details);}else{ echo 1;}?>" id="actual_row_count_budget_and_conditions" name="actual_row_count_budget">
                        </div>
                      </div>
                      <div class="row">
                        <div class="col-lg-8"></div>
                        <div class="col-lg-4" style="<?php if($this->config->item('Project_multiple_budget')==0){ echo 'display:none';}?>">
                          <div class="form-group m-form__group" >
                            <label for="user_name">
                              Total Project Budget
                            </label>
                            <input value="<?php echo $project_data->total_budget_amount ?>" style="font-weight:700;border: 3px solid #b3b3b3 !important;" readonly type="text" id="grand_total_budget_amount" name="grand_total_budget_amount" class="form-control m-input m-input--pill m-input--air"  aria-describedby="basic-addon1">
                          </div>
                          <span class="m-form__help"></span>
                        </div>
                        <div class="col-lg-2" style="display:none">
                          <div class="form-group m-form__group" >
                            <label for="user_name">
                              Profit Margin %
                            </label>
                            <input value="0" type="text" value="<?php echo $project_data->profit_margin_percent?>" id="profit_margin_percent" name="profit_margin_percent" class="form-control m-input m-input--pill m-input--air" placeholder="Profit Margin %"  aria-describedby="basic-addon1">
                          </div>
                          <span class="m-form__help"></span>
                        </div>
                      </div>
                    </div>
                  </div>

                  <br/>
                  <div class="row" style="display:none">
                    <div class="col-lg-4">
                      <div class="form-group m-form__group">
                        <label></label>
                        <div class="m-checkbox-list">
                          <label class="m-checkbox m-checkbox--bold m-checkbox--state-brand">
                            <input type="checkbox" name="project_management" id="project_management" value="1"> Have Project Management Commission
                            <span></span>
                          </label>
                        </div>
                        <span class="m-form__help"></span>
                      </div>
                    </div>
                    <div class="col-lg-4">
                      <div class="form-group m-form__group commission_div" style="display:none">
                        <label>
                          Commission %
                        </label>
                        <div class="m-input-icon m-input-icon--right">
                          <input type="text" value="<?php echo $project_data->project_management_commission ?>" name="commission_percent" id="commission_percent" class="commission_fields form-control m-input m-input--pill m-input--air" placeholder="Commission %"  aria-describedby="basic-addon1">
                          <span class="m-input-icon__icon m-input-icon__icon--right"><span><i class="fa fa-percent"></i></span></span>
                        </div>
                        <span class="m-form__help"></span>
                      </div>
                    </div>
                    <div class="col-lg-4">
                      <div class="form-group m-form__group commission_div" style="display:none">
                        <label>
                          Commission Amount (Excl. Tax)
                        </label>
                        <div class="m-input-icon m-input-icon--right">
                          <input readonly value="0" type="text" id="commission_amount" name="commission_amount" class="commission_fields form-control m-input m-input--pill m-input--air" placeholder="Commission Amount"  aria-describedby="basic-addon1">
                          <span class="m-input-icon__icon m-input-icon__icon--right"><span><?php echo $this->config->item('Currency_currency_format'); ?></span></span>
                        </div>
                        <span class="m-form__help"></span>
                      </div>
                    </div>
                  </div>
                  <div class="row" style="display:none">
                    <div class="col-lg-4">
                      <div class="form-group m-form__group">
                        <label>
                          Initial Security Deposit
                        </label>
                        <div class="m-input-icon m-input-icon--right">
                          <input type="text" value="<?php echo $project_data->initial_security_deposit ?>" name="initial_security_deposit" class="form-control m-input m-input--pill m-input--air" placeholder="Initial Security Deposit"  aria-describedby="basic-addon1">
                          <span class="m-input-icon__icon m-input-icon__icon--right"><span><?php echo $this->config->item('Currency_currency_format'); ?></span></span>
                        </div>
                        <span class="m-form__help"></span>
                      </div>
                    </div>
                    <div class="col-lg-8">
                      <div class="form-group m-form__group">
                        <label>
                          Security Deposit Details
                        </label>
                        <div class="m-input-icon m-input-icon--right">
                          <input type="text" value="<?php echo $project_data->security_deposit_details ?>" name="security_deposit_details" class="form-control m-input m-input--pill m-input--air" placeholder="Security Deposit Details"  aria-describedby="basic-addon1">
                          <span class="m-input-icon__icon m-input-icon__icon--right"><span><i class="fa fa-edit"></i></span></span>
                        </div>
                        <span class="m-form__help"></span>
                      </div>
                    </div>
                  </div>
                  <div class="row">
                    <div class="col-lg-8">
                      <div class="form-group m-form__group">
                        <label>
                          Project Description
                        </label>
                        <textarea rows="6" placeholder="Description About Project"  name="description" class="form-control  m-input  m-input--air m-input--pill" ><?php echo $project_data->work_description?></textarea>
                        <span class="m-form__help"></span>
                      </div>
                    </div>
                    <div class="col-lg-4">
                      <div class="form-group m-form__group">
                        <label>
                          Thumbnail
                        </label>
                        <br/>
                        <div style="margin-bottom:10px">
                          <?php if ($project_data->photo!='') { ?>
                            <img style="max-width:125px" src="<?php echo base_url()?>uploads/projects/<?= $project_data->photo ?>" alt=""/>
                          <?php }else{ ?>
                            <img style="max-width:125px" src="<?php echo base_url()?>uploads/projects/default.png" alt=""/>
                          <?php } ?>
                        </div>
                        <div class="custom-file">
                          <input type="file" class="custom-file-input" name="uploaded_file" id="customFile">
                          <label class="custom-file-label" for="customFile">Change Image</label>
                        </div>
                      </div>
                    </div>
                  </div>
                  <div class="row">
                    <div class="col-lg-3">
                      <div class="form-group m-form__group">
                        <label>
                          LPO No
                        </label>
                        <div class="m-input-icon m-input-icon--right">
                          <input type="text" style="text-transform:uppercase" name="lpo_no" value="<?php echo $project_data->lpo_no?>" class="form-control m-input m-input--pill m-input--air" placeholder="LPO No"  aria-describedby="basic-addon1">
                          <span class="m-input-icon__icon m-input-icon__icon--right"><span><i class="la la-tag"></i></span></span>
                        </div>
                        <span class="m-form__help"></span>
                      </div>
                    </div>
                    <div class="col-lg-3">
                      <div class="form-group m-form__group">
                        <label>
                          <?php echo $this->config->item('Project_reference_no_2_title') ?>
                        </label>
                        <div class="m-input-icon m-input-icon--right">
                          <input type="text" style="text-transform:uppercase" value="<?php echo $project_data->reference_no_2?>" name="reference_no_2" class="form-control m-input m-input--pill m-input--air" placeholder="<?php echo $this->config->item('Project_reference_no_2_title') ?>"  aria-describedby="basic-addon1">
                          <span class="m-input-icon__icon m-input-icon__icon--right"><span><i class="la la-tag"></i></span></span>
                        </div>
                        <span class="m-form__help"></span>
                      </div>
                    </div>
                    <div class="col-lg-3">
                      <div class="form-group m-form__group">
                        <label>
                          LPO Value
                        </label>
                        <div class="m-input-icon m-input-icon--right">
                          <input type="text" name="lpo_value" value="<?php echo $project_data->lpo_value?>" class="form-control m-input m-input--pill m-input--air" placeholder="LPO Amount"  aria-describedby="basic-addon1">
                          <span class="m-input-icon__icon m-input-icon__icon--right"><span><i class="la la-edit"></i></span></span>
                        </div>
                        <span class="m-form__help"></span>
                      </div>
                    </div>
                    <div class="col-lg-3">
                      <div class="form-group m-form__group">
                        <label>
                          LPO Status
                        </label>
                        <div class="m-select2 m-select2--air m-select2--pill">
                          <select style="width:100%"  class="form-control m-select2" id="lpo_status" name="lpo_status"  >
                            <option selected disabled>Select Status</option>
                            <option value="Pending">Pending</option>
                            <option value="Received">Received</option>
                          </select>
                        </div>
                        <span class="m-form__help"></span>
                      </div>
                    </div>
                    <div class="col-lg-3">
                      <div class="form-group m-form__group">
                        <label>
                          LPO Date
                        </label>
                        <div class="m-input-icon m-input-icon--right">
                          <input data-date-format="dd-mm-yyyy" value="<?php if($project_data->lpo_date!='0000-00-00'){echo date('d-m-Y',strtotime($project_data->lpo_date));}?>" type="text" name="lpo_date" id="lpo_date" class="form-control m-input m-input--pill m-input--air" placeholder="LPO Date"  aria-describedby="basic-addon1">
                          <span class="m-input-icon__icon m-input-icon__icon--right"><span><i class="fa fa-calendar"></i></span></span>
                        </div>
                        <span class="m-form__help"></span>
                      </div>
                    </div>
                  </div>
                  <div style="background: white;border: 4px solid #f7f7fa;padding: 15px;margin: 5px;padding-bottom: 0px;display:none" id="project_op_div">
                    <div class="m-section" style="margin-bottom: 10px">
                      <h3 class="m-section__heading">Current Status (For Ongoing Projects)</h3>
                      <div class="row">
                        <div class="col-lg-4">
                          <div class="form-group m-form__group" >
                            <label for="user_name">
                              Expense Amount Spent
                            </label>
                            <div class="m-input-icon m-input-icon--right">
                              <input required  type="text" name="expense_spent" value="<?php echo $project_data->op_expense_amount?>" id="expense_spent"  class="form-control m-input m-input--pill m-input--air" placeholder="" aria-describedby="basic-addon1">
                              <span class="m-input-icon__icon m-input-icon__icon--right"><span><i class="la la-money"></i></span></span>
                            </div>
                            <span class="m-form__help"></span>
                          </div>
                        </div>
                        <div class="col-lg-4">
                          <div class="form-group m-form__group" >
                            <label for="user_name">
                              Income Amount Received (From Client)
                            </label>
                            <div class="m-input-icon m-input-icon--right">
                              <input required type="text" name="income_received" value="<?php echo $project_data->op_income_amount?>" id="income_received"  class="form-control m-input m-input--pill m-input--air" placeholder="" aria-describedby="basic-addon1">
                              <span class="m-input-icon__icon m-input-icon__icon--right"><span><i class="la la-money"></i></span></span>
                            </div>
                            <span class="m-form__help"></span>
                          </div>
                        </div>
                        <div class="col-lg-4">
                          <div class="form-group m-form__group">
                            <label>
                              Upto Date
                            </label>
                            <div class="m-input-icon m-input-icon--right">
                              <input data-date-format="dd-mm-yyyy" type="text" value="<?php if($project_data->op_upto_date!='0000-00-00'){echo date('d-m-Y',strtotime($project_data->op_upto_date));}?>" name="opening_date" id="opening_date" class="form-control m-input m-input--pill m-input--air" placeholder="Opening Date"  aria-describedby="basic-addon1">
                              <span class="m-input-icon__icon m-input-icon__icon--right"><span><i class="fa fa-calendar"></i></span></span>
                            </div>
                            <span class="m-form__help"></span>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
              <div class="m-portlet__foot m-portlet__foot--fit">
                <div class="m-form__actions m-form__actions">
                  <div class="row">
                    <div class="col-lg-9 ml-lg-auto">
                      <button type="submit" class="btn btn-brand form_submit_btn">
                        Submit
                      </button>
                      <button type="reset" class="btn btn-secondary">
                        Cancel
                      </button>
                    </div>
                  </div>
                </div>
              </div>
            </form>
            <!--end::Form-->
            <?php $this->view("modules/include_modals/modal_client_add");?>
            <?php $this->view("modules/include_modals/modal_project_area_location");?>
          </div>
        </div>
        <div class="col-lg-1"></div>
      </div>
    </div>
  </div>
</div>
<!-- end:: Body -->
<!-- begin::Footer -->

<?php $this->view("includes/Inc_footer");?>
<!-- end::Footer -->
</div>
<!-- end:: Page -->

<?php $this->view("includes/Inc_sidebar");?>
<?php $this->view("includes/Inc_scripts");?>
<!--begin::Page Snippets -->

<script>
$("#works_menu").addClass('m-menu__item--active m-menu__item--open');
$("#works_menu_2").addClass('m-menu__item--active');
$('input[type=radio][name=project_op_status]').change(function() {
  if (this.value == 'Ongoing') {
    $("#project_op_div").show();
  }else{
    $("#project_op_div").hide();
  }
})
$("input[name=project_op_status][value='<?php echo $project_data->project_op_type?>']").prop('checked', true).trigger('change');
$('input[type=radio][name=project_master_type]').change(function() {
  if (this.value == '1') {
    $("#parent_project_div").show();
    $("#parent_project").attr('required',true);
    $(".main_project_fields_div").hide();
    $(".main_project_fields").removeAttr('required',true);
    $("#parent_project").select2({
      placeholder: "Select Project",
      dropdownParent: $("#form_project_edit")
    })
  }else{
    $("#parent_project_div").hide();
    $("#parent_project").removeAttr('required',true);
    $(".main_project_fields_div").show();
    $(".main_project_fields").attr('required',true);

    // $('#project_section').val('').trigger('change');
    // $('#project_type').val('').trigger('change');
    // $('#location').val('');
    // $('#location').val('');
    // $('#location_area').val('').trigger('change');
    // $('#reference_no').val('');
  }
})
$('body').on('change', '#parent_project', function() {
  var parent_project=$('#parent_project :selected').val();
  $.post("<?php echo base_url() ?>work/select_details", {
    work_id: parent_project
  }, function(data) {
    var obj = $.parseJSON(data);
    if (obj.count == 1) {
      $('#project_section').val(obj.data['project_section']).trigger('change');
      $('#project_type').val(obj.data['work_type']).trigger('change');
      $('#location').val(obj.data['work_location']);
      $('#location').val(obj.data['work_location']);
      $('#location_area').val(obj.data['location_area']).trigger('change');
      $('#reference_no').val(obj.data['reference_no']);
      $('input[type=radio][name=priority][value='+obj.data['project_priority']+']').prop('checked',true);
    }
  })
})
<?php
if ($this->config->item('Project_parent_child_enable') == 1) {
  if($project_data->parent_project_id!=0){?>
    $("input[name=project_master_type][value=1]").prop('checked', true).trigger('change');
    $('#parent_project').val(<?php echo $project_data->parent_project_id?>).trigger('change');
    <?php }else{?>
      $("input[name=project_master_type][value=0]").prop('checked', true).trigger('change');
      <?php }
    }?>


    $("#lpo_status").select2({
      placeholder: "Select Status",
      dropdownParent: $("#form_project_edit")
    })
    $("#lpo_status").val('<?php echo $project_data->lpo_status?>').trigger('change');
    $("#state_id_add").select2({
      placeholder: "Select State Code",
      dropdownParent: $("#form_client_add")
    })
    $("#start_date,#completion_date,#tax_date_add,#opening_date,#lpo_date").datepicker( {
      todayHighlight:!0, orientation:"bottom right", templates: {
        leftArrow: '<i class="la la-angle-left"></i>', rightArrow: '<i class="la la-angle-right"></i>'
      }
    })
    $("#company").select2({
      placeholder: "Select Company",
      dropdownParent: $("#form_project_edit")
    })
    $("#project_section").select2({
      placeholder: "Select Project Section",
      dropdownParent: $("#form_project_edit")
    })
    $("#project_type").select2({
      placeholder: "Select Project Type",
      dropdownParent: $("#form_project_edit")
    })
    $("#location_area").select2({
      placeholder: "Select Area",
      dropdownParent: $("#form_project_edit")
    })

    $("#client").select2({
      placeholder: "Select Client",
      dropdownParent: $("#form_project_edit")
    })
    <?php if($this->config->item('Project_multiple_budget')==1){
      $budget_details = unserialize($project_data->project_budget_details);
      foreach ($budget_details as $key => $value) { ?>
        $("#tax_percent_<?php echo $key+1?>").select2({
          placeholder: "Select Tax %",
          dropdownParent: $("#form_project_edit")
        })
        $("#tax_percent_<?php echo $key+1?>").val(<?php echo $value['tax_percent']?>).trigger('change');
        <?php }
      }else{ ?>
        $("#tax_percent_1").select2({
          placeholder: "Select Tax %",
          dropdownParent: $("#form_project_edit")
        })
        $("#tax_percent_1").val(<?php echo $project_data->project_tax_percent?>).trigger('change');
        <?php }
        ?>
        $("#addrow_budget").on("click", function() {
          var i = parseInt($('#current_row_count_budget_and_conditions').val());
          var new_i = i + 1;

          var new_row = '<tr class="row_'+i+'">';
          new_row += '<td><div class="form-group m-form__group" style="padding: 0px !important;margin: 0px !important;">';
          new_row += '<div class="input-group m-input-group m-input-group--pill m-input-group--air"><input style="padding: 10px" readonly type="text" class="form-control m-input item_slno" data-sl-no="'+new_i+'" name="budget[sl_no]['+i+']" value="'+new_i+'" /></div></div></td>';
          <?php if($this->config->item('Project_multiple_budget')==1){  ?>
            new_row += '<td><div class="form-group m-form__group" style="padding: 0px !important;margin: 0px !important;">';
            new_row += '<input required type="text" name="budget[section]['+i+']" data-slno="'+new_i+'" id="budget_section_'+new_i+'" class="form-control m-input m-input--pill m-input--air" placeholder="Section Name"  aria-describedby="basic-addon1"></div></td>';
            <?php } ?>
            new_row += '<td><div class="form-group m-form__group" style="padding: 0px !important;margin: 0px !important;">';
            new_row += '<input type="text" name="budget[amount]['+i+']" data-slno="'+new_i+'" id="budget_amount_'+new_i+'" class="form-control m-input m-input--pill m-input--air tax_fields" placeholder="Estimated Budget"  aria-describedby="basic-addon1"></div></td>';
            new_row += '<td><div class="form-group m-form__group" style="padding: 0px !important;margin: 0px !important;"><div class="m-select2 m-select2--air m-select2--pill ">';
            new_row += '<select required id="tax_percent_'+new_i+'" data-slno="'+new_i+'" name="budget[tax_percent]['+i+']" style="width: 100%" class="form-control m-input tax_fields" aria-describedby="basic-addon1" data-placeholder="Select Tax Percentage">';
            <?php
            $tax_percent = $this->config->item('Tax_tax_percent_old');
            foreach($tax_percent as $row):
              $selected_tax="";
              if($row==0){
                $selected_tax="selected";
              }
              ?>
              new_row += '<option <?php echo $selected_tax?> value="<?php echo $row?>"><?php echo $row?>%</option>';
              <?php
            endforeach;
            ?>
            new_row += '</select></div></div></td>';
            new_row += '<td><div class="form-group m-form__group" style="padding: 0px !important;margin: 0px !important;">';
            new_row += '<input readonly value="0" type="text" data-slno="'+i+'" id="tax_amount_'+new_i+'" name="budget[tax_amount]['+i+']" class="form-control m-input m-input--pill m-input--air" placeholder="<?php echo $this->config->item('Tax_tax_name')?> Amount"  aria-describedby="basic-addon1"></div></td>';
            new_row += '<td><div class="form-group m-form__group" style="padding: 0px !important;margin: 0px !important;">';
            new_row += '<input readonly class="form-control m-input m-input--pill m-input--air total_budget_fields" value="0" type="text" name="budget[total]['+i+']" id="total_budget_'+new_i+'"></div></td>';
            new_row += '<td><a href="javascript:" data-row-sl-no="' + i + '" class="ibtnDel_budget btn btn-danger m-btn--icon btn-sm  m-btn--icon-only m-btn--pill m-btn--air" ><i class="fa fa-trash"></i></td></tr>';

            $('#table_body_budget').append(new_row);
            $('#current_row_count_budget_and_conditions').val(new_i);
            $("#tax_percent_"+new_i).select2({
              placeholder: "Select Tax %",
              dropdownParent: $("#form_project_edit")
            })
            $('.tax_fields').on("keyup change", function(e) {
              var slno = $(this).data('slno');
              calculate_item_total(slno);
            })
          });

          $("#table_body_budget").on("click", ".ibtnDel_budget", function(event) {
            var sl_no = $(this).attr("data-sl-no");

            var counter = parseInt($("#current_row_count_budget_and_conditions").val());
            $(this).closest("tr").remove();
            counter -= 1;
            $("#current_row_count_budget_and_conditions").val(counter);
            calculate_total_budget();
          });

          $('.tax_fields').on("keyup change", function(e) {
            var slno = $(this).data('slno');
            calculate_item_total(slno);
          })
          <?php if($this->config->item('Project_multiple_budget')==0 && $project_data->project_tax_included==1){ ?>
            $(".taxable_field").show();
            calculate_item_total(1);
            <?php } ?>
            function calculate_item_total(slno){
              var tax_type = $('input[type=radio][name="budget[tax_type]['+(slno-1)+']"]:checked').val();
              if(tax_type==1){
                $(".taxable_field").show();
              }else{
                $(".taxable_field").hide();
              }
              var tax_percent = parseFloat($('#tax_percent_'+slno+' :selected').val());
              var budget = parseFloat($('#budget_amount_'+slno).val());
              if(isNaN(budget)) {
                var budget = 0;
              }
              if(tax_type==1){
                var taxable_amount = budget* 100 / (tax_percent + 100);
                var tax_amount = taxable_amount*tax_percent/100;
                var total_budget = taxable_amount+tax_amount;
                $('#taxable_amount_'+slno).val(taxable_amount.toFixed(<?php echo $this->config->item('Currency_amount_decimals_2')?>));
              }else{
                var tax_amount = budget*tax_percent/100;
                var total_budget = budget+tax_amount;
              }
              $('#tax_amount_'+slno).val(tax_amount.toFixed(<?php echo $this->config->item('Currency_amount_decimals_2')?>));
              $('#total_budget_'+slno).val(total_budget);
              calculate_total_budget();
            }

            function calculate_total_budget(){
              var grand_total_budget = 0;
              $(".total_budget_fields").each(function() {
                if(parseFloat($(this).val())>0){
                  grand_total_budget+=parseFloat($(this).val());
                }
              });
              $("#grand_total_budget_amount").val(grand_total_budget.toFixed(<?php echo $this->config->item('Currency_amount_decimals_2')?>));
            }

            $('#commission_percent,.tax_fields').on("keyup change", function(e) {
              var commission_percent = parseFloat($('#commission_percent').val());
              var budget = parseFloat($('#budget_amount').val());
              if(isNaN(budget)) {
                var budget = 0;
              }
              var commission_amount = budget*commission_percent/100;
              $('#commission_amount').val(commission_amount.toFixed(<?php echo $this->config->item('Currency_amount_decimals_2')?>));
            })

            $('#project_management').change(function() {
              if(this.checked) {
                $(".commission_div").show();
                $(".commission_fields").attr('required',true);
              }else{
                $("#commission_percent").val(0);
                $("#commission_amount").val(0);
                $(".commission_div").hide();
                $(".commission_fields").removeAttr('required',true);
              }
            });
            select_area_locations();
            function select_area_locations(){
              $('#location_area').html('');
              $("#location_area").append("<option disabled selected >Select Area</option>");
              $.post("<?php echo base_url() ?>work/select_area_locations_list",{},function(data) {
                var obj = $.parseJSON(data);
                var i=0;
                if(obj.count>0) {
                  while (i < obj.data.length) {
                    $("#location_area").append("<option value=" + obj.data[i]['area_id'] + ">" + obj.data[i]['area_name'] + "</option>");
                    i++;
                  }
                  var location_area = "<?php echo $project_data->location_area?>";
                  $("#location_area").val(location_area).trigger('change');
                }
              })
            }
            <?php if($project_data->project_management_commission!=0){?>
              $('#project_management').prop('checked', true).trigger('change');
              <?php } ?>


              function select_client(selected_value){
                $('#client').html('');
                $("#client").append("<option disabled selected >Select Client</option>");
                $.post("<?php echo base_url() ?>clients/select",{},function(data) {
                  var obj = $.parseJSON(data);
                  var i=0;
                  if(obj.count>0) {
                    while (i < obj.id.length) {
                      $("#client").append("<option value=" + obj.id[i] + ">" + obj.name[i] + "</option>");
                      i++;
                    }
                    if(selected_value!=''){
                      $("#client").val(selected_value).trigger('change');
                    }
                  }
                })
              }
              </script>
              <script>
              var client_id = "<?php echo $project_data->client_id?>";
              var project_category = "<?php echo $project_data->work_type?>";
              var project_section = "<?php echo $project_data->project_section?>";
              var priority = "<?php echo $project_data->project_priority?>";
              var company = "<?php echo $project_data->company_id?>";

              var tax_percent = "<?php echo $project_data->project_tax_percent?>";
              var start_date = "<?php if($project_data->planned_date_of_start!='0000-00-00'){ echo date('d-m-Y',strtotime($project_data->planned_date_of_start));}else{ echo "";}?>";
              var end_date = "<?php if($project_data->planned_date_of_completion!='0000-00-00'){ echo date('d-m-Y',strtotime($project_data->planned_date_of_completion));}else{ echo "";}?>";
              $("#start_date").datepicker("setDate", start_date);
              $("#completion_date").datepicker("setDate", end_date);
              select_client(client_id);
              $("#project_type").val(project_category).trigger('change');
              $("#project_section").val(project_section).trigger('change');
              $("#company").val(company).trigger('change');

              $("#tax_percent").val(tax_percent).trigger('change');
              $("input[name=priority][value=" + priority + "]").prop('checked', true);
              </script>
              <script>

              jQuery(document).ready(function() {

                $(".form_submit_btn").click(function (e) {

                  e.preventDefault();
                  var a = $(this),
                  l = $(this).closest("form"),
                  action = l.attr('action');
                  var form_id = l.attr('id');
                  l.validate({
                    rules: {
                      "paid_amount": {
                        required: !0,
                        min: 1,
                        number: !0
                      },
                      "budget": {
                        number: !0,
                        required: !0
                      },
                      "profit_margin_percent": {
                        number: !0
                      }
                    }, invalidHandler: function (e, r) {
                      var i = $("#" + form_id + "_msg");
                      i.removeClass("m--hide").show(), mUtil.scrollTo(i, -200)
                    }, submitHandler: function (e) {
                    }
                  }), l.valid() && (a.addClass("m-loader m-loader--right m-loader--light").attr("disabled", !0),
                  l.ajaxSubmit({
                    url: action,
                    success: function (e, t, r, s) {
                      var modal_id = l.attr('data-modal-id');
                      var form_type = l.attr('data-form-type');
                      $("#" + form_id + "_msg").addClass("m--hide");
                      // Block UI
                      mApp.blockPage({
                        overlayColor: "#000000",
                        type: "loader",
                        state: "success",
                        message: "Please wait..."
                      }), setTimeout(function () {
                        mApp.unblockPage()
                      }, 2e3);
                      var obj = $.parseJSON(e);
                      if (obj.status == 1) {
                        a.removeClass("m-loader m-loader--right m-loader--light").attr("disabled", !1);
                        toastr[obj.flashdata_type](obj.flashdata_msg, obj.flashdata_title);
                        if(form_type=='project_edit'){
                          swal({
                            width: 500,
                            title: obj.flashdata_title,
                            text: obj.flashdata_msg,
                            type: obj.flashdata_type,
                            confirmButtonText: "View All Projects",
                            <?php if ($this->config->item('Project_disable_add_button') == 0){ ?>
                              showCancelButton: !0,
                              cancelButtonText: "Add New Project",
                              <?php }else{ ?>
                                showCancelButton: 0,
                                <?php } ?>
                                confirmButtonColor: '#3085d6',
                                cancelButtonColor: '#d33',
                                reverseButtons: !0,
                                closeOnClickOutside: false,
                                allowOutsideClick: false,
                                html: "<br>" +
                                '<a href="<?php echo base_url()?>work/profile/'+obj.work_id+'"  class="SwalBtn1  btn btn-primary m-btn m-btn--custom customSwalBtn">' + 'View Project Profile' + '</button>'
                              }).then(function(e) {
                                e.value ? window.location.replace("<?php echo base_url()?>work") : "cancel" === e.dismiss && window.location.replace("<?php echo base_url()?>work/add/");
                              })
                            }else if(form_type=='client_add'){
                              $("#"+modal_id).modal('toggle');
                              select_client();
                              $("#client").trigger("change");
                            }else if(form_type=='area_add'){
                              $("#"+modal_id).modal('toggle');
                              select_area_locations();
                              $("#location_area").trigger("change");
                            }
                          } else {
                            a.removeClass("m-loader m-loader--right m-loader--light").attr("disabled", !1);
                            toastr[obj.flashdata_type](obj.flashdata_msg, obj.flashdata_title);
                          }
                          if (obj == null) {
                            setTimeout(function () {
                              a.removeClass("m-loader m-loader--right m-loader--light").attr("disabled", !1);
                              toastr["warning"]("Your Attempt is Timed Out. Please Try Again.", "Timed Out");
                            }, 2e4)
                          }
                        },error: function() {
                          a.removeClass("m-loader m-loader--right m-loader--light").attr("disabled", !1);
                          toastr["error"]("Sorry. There Has Been Some Error Occurred. Please Try Again.", "Error");
                        }
                      })
                    )
                  });
                });

                </script>
