<html>
<head>
  <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
  <title><?= $this->config->item('company_name')?></title>
  <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/v/bs4/jszip-2.5.0/dt-1.10.20/b-1.6.1/b-colvis-1.6.1/b-flash-1.6.1/b-html5-1.6.1/b-print-1.6.1/fc-3.3.0/fh-3.1.6/kt-2.5.1/r-2.2.3/rg-1.1.1/sc-2.0.1/sp-1.0.1/datatables.min.css"/>

</head>
<style type="text/css">

  body { font-family:Tahoma, Geneva, sans-serif;
    font-style:normal;
    font-weight:normal;
    font-variant:normal;
    font-size:12px;
    padding:0px;
    margin:0px;
    line-height:18px;
  }
  .item_table td{
    padding: .75rem !important;
  }
  .item_table th{
    white-space: nowrap;
    padding: .75rem !important;
  }
  .table thead th {
    border-top: 2px solid #f4f5f8 !important;
  }
  @media print
  {
    #print, .print_hide_div
    {
      display: none !important;
    }
  }
  @media print {
    html, body, div, span, applet, object, iframe, td, tr, blockquote, pre, a, abbr, acronym, address, big, cite, code, del, dfn, em, font, ins, kbd, q, s, samp, small, strike, strong, sub, sup, tt, var, dl, dt, dd, ol, ul, li, fieldset, form, label, legend, table, caption, tbody, tfoot, thead, tr, th, td {
      font-size: 15pt !important;
    }
    h1.entry-title {
      font-size: 15pt !important;
    }
  }

  @media print {
    html, body, div, span, applet, object, iframe, td, tr, blockquote, pre, a, abbr, acronym, address, big, cite, code, del, dfn, em, font, ins, kbd, q, s, samp, small, strike, strong, sub, sup, tt, var, dl, dt, dd, ol, ul, li, fieldset, form, label, legend, table, caption, tbody, tfoot, thead, tr, th, td {
      font-size: 15pt !important;
    }
    h1.entry-title {
      font-size: 15pt !important;
    }
  }
</style>
<body>
  <div class="m-grid__item m-grid__item--fluid m-wrapper" id="content">


    <div class="m-content">
      <div class="row">
        <div style="width:1000px; height:auto;">
          <img style="max-width: 1000px" src="<?php echo base_url().'uploads/company/'.$this->config->item('company_letter_head')?>" />
          <div class="m-portlet">
            <div class="m-portlet__body m-portlet__body--no-padding">
              <!-- client Details -->
              <div class="m-portlet  m-portlet--rounded m-portlet--bordered " >
                <a href="javascript:;" style="float: right;margin-top: 20px;margin-bottom: 20px;margin-right: 20px"  id="print"   class="print_hide_div btn btn-primary m-btn m-btn--custom m-btn--icon m-btn--air m-btn--pill">
                  <span>
                    <i class="la la-print"></i>
                    <span>
                      Print
                    </span>
                  </span>
                </a>
                <div class="m-portlet__body">
                  <h3 class="m-portlet__head-text" style="text-align: center;text-decoration: underline">
                    Summary Of Stage " <?php echo $stage_data->stage_name?> " Of Work " <?php echo $work_data->work_name?> "
                  </h3>
                </div>
              </div>
              <div class="m-portlet  m-portlet--rounded m-portlet--bordered print_hide_div" >
                <div class="m-portlet__body">
                  <div class="m-form__group form-group">
                    <label for="">Select Datas to Display</label>
                    <div class="m-checkbox-inline">
                      <label class="m-checkbox m-checkbox--bold m-checkbox--state-brand">
                        <input type="checkbox" value="stage_info" class="data_display_option" checked> Stage Info
                        <span></span>
                      </label>
                      <?php if($this->session->userdata('user_role')=='admin'){?>
                        <label class="m-checkbox m-checkbox--bold m-checkbox--state-brand">
                          <input type="checkbox" value="client_payments" class="data_display_option" checked> Client Payments
                          <span></span>
                        </label>
                      <?php } ?>
                      <?php if($this->config->item('app_module_purchase_order')==1){?>
                        <label class="m-checkbox m-checkbox--bold m-checkbox--state-brand">
                          <input type="checkbox" value="purchase_order_payments" class="data_display_option" checked> Purchase Order Payments
                          <span></span>
                        </label>
                      <?php } ?>
                      <label class="m-checkbox m-checkbox--bold m-checkbox--state-brand">
                        <input type="checkbox" value="purchase_bill_payments" class="data_display_option" checked> Purchase Bill Payments
                        <span></span>
                      </label>
                      <?php if($this->session->userdata('user_role')!='purchase_manager'){?>
                        <label class="m-checkbox m-checkbox--bold m-checkbox--state-brand">
                          <input type="checkbox" value="expenses" class="data_display_option" checked> Expenses
                          <span></span>
                        </label>
                      <?php } ?>
                      <?php if($this->session->userdata('user_role')!='purchase_manager'){?>
                        <label class="m-checkbox m-checkbox--bold m-checkbox--state-brand">
                          <input type="checkbox" value="labour_wages" class="data_display_option" checked> Labour Wage Slip
                          <span></span>
                        </label>
                      <?php } ?>
                      <?php if($this->session->userdata('user_role')!='purchase_manager'){?>
                        <label class="m-checkbox m-checkbox--bold m-checkbox--state-brand">
                          <input type="checkbox" value="salary_payments" class="data_display_option" checked> Salary Payments
                          <span></span>
                        </label>
                      <?php } ?>
                      <?php if($this->session->userdata('user_role')!='purchase_manager'){?>
                        <label class="m-checkbox m-checkbox--bold m-checkbox--state-brand">
                          <input type="checkbox" value="subcontract_payments" class="data_display_option" checked> Subcontract Payments
                          <span></span>
                        </label>
                      <?php } ?>
                      <?php if($this->session->userdata('user_role')!='purchase_manager'){?>
                        <label class="m-checkbox m-checkbox--bold m-checkbox--state-brand">
                          <input type="checkbox" value="subcontract_summary" class="data_display_option" checked> Subcontract Summary
                          <span></span>
                        </label>
                      <?php } ?>
                      <label class="m-checkbox m-checkbox--bold m-checkbox--state-brand">
                        <input type="checkbox" value="work_summary" class="data_display_option" checked> Work Summary
                        <span></span>
                      </label>
                    </div>
                  </div>
                </div>
              </div>
              <div class="m-portlet  m-portlet--rounded m-portlet--bordered div_stage_info">
                <div class="m-portlet__body">
                  <h3 class="m-portlet__head-text" style="text-align: center">
                    Stage Info
                  </h3>
                  <table width="100%" class="table m-table nowrap table-header-fixed table-striped table-bordered table-hover table-header-fixed" id="stage_info_table">
                    <thead>
                      <tr class="">
                        <th><strong>Info</strong></th>
                        <th><strong>Description</strong></th>
                      </tr>

                    </thead>
                    <tbody>
                      <tr class="">
                        <th><strong>Stage Name</strong></th>
                        <td><?php echo $stage_data->stage_name?></td>
                      </tr>
                      <tr class="">
                        <th><strong>Stage Status</strong></th>
                        <td>
                          <?php if($work_data->work_status==1){?>
                            <span class='m-badge m-badge--success m-badge--wide'><i class="fa fa-check"></i> Completed</span>
                          <?php }else{ ?>
                            <span class='m-badge m-badge--info m-badge--wide'><i class="fa fa-ellipsis-h"></i>In Progress</span>
                          <?php } ?>
                        </td>
                      </tr>

                      <?php if($this->session->userdata('user_role')!='purchase_manager'){?>
                        <tr class="">
                          <th><strong>Stage Budget Amount</strong></th>
                          <td>
                            <?php echo $stage_data->stage_budget?>
                          </td>
                        </tr>
                      <?php } ?>
                      <tr class="">
                        <th><strong>Date of Completion</strong></th>
                        <td>
                          <?php if($stage_data->stage_end_date!='0000-00-00'){ echo date('d-m-Y',strtotime($work_data->planned_date_of_completion));} ?>
                        </td>
                      </tr>
                      <tr class="">
                        <th><strong>Stage Description</strong></th>
                        <td>
                          <?php echo $stage_data->stage_description?>
                        </td>
                      </tr>
                    </tbody>
                  </table>
                </div>
              </div>
              <?php if($this->session->userdata('user_role')=='admin'){?>
                <div class="m-portlet  m-portlet--rounded m-portlet--bordered div_client_payments">
                  <div class="m-portlet__body">
                    <h3 class="m-portlet__head-text" style="text-align: center">
                      Client Payments Received
                    </h3>
                    <?php $this->view("modules/include_tables/table_client_payments");?>
                  </div>
                </div>
              <?php } ?>
              <!-- Purchase Payments -->
              <?php if($this->config->item('app_module_purchase_order')==1){?>
                <div class="m-portlet  m-portlet--rounded m-portlet--bordered div_purchase_order_payments">
                  <div class="m-portlet__body">
                    <h3 class="m-portlet__head-text" style="text-align: center">
                      Purchase Order Payments (Orders Those Haven't Purchase Bill Created)
                    </h3>
                    <?php $this->view("modules/include_tables/table_purchase_order_payments");?>
                  </div>
                </div>
              <?php } ?>
              <div class="m-portlet  m-portlet--rounded m-portlet--bordered div_purchase_bill_payments">
                <div class="m-portlet__body">
                  <h3 class="m-portlet__head-text" style="text-align: center">
                    Purchase Bill Payments
                  </h3>
                  <?php $this->view("modules/include_tables/table_purchase_bill_payments");?>
                </div>
              </div>
              <?php if($this->session->userdata('user_role')!='purchase_manager'){?>
                <div class="m-portlet  m-portlet--rounded m-portlet--bordered div_expenses">
                  <div class="m-portlet__body">
                    <h3 class="m-portlet__head-text" style="text-align: center">
                      Other Expenses
                    </h3>
                    <?php $this->view("modules/include_tables/table_expense_bills");?>
                  </div>
                </div>
              <?php } ?>
              <?php if($this->session->userdata('user_role')!='purchase_manager'){?>
                <div class="m-portlet  m-portlet--rounded m-portlet--bordered div_labour_wages">
                  <div class="m-portlet__body">
                    <h3 class="m-portlet__head-text" style="text-align: center">
                      Labour Wage Slips
                    </h3>
                    <?php $this->view("modules/include_tables/table_labour_wage_slips");?>
                  </table>
                </div>
              </div>
            <?php } ?>
            <?php if($this->session->userdata('user_role')!='purchase_manager'){?>
              <div class="m-portlet  m-portlet--rounded m-portlet--bordered div_salary_payments">
                <div class="m-portlet__body">
                  <h3 class="m-portlet__head-text" style="text-align: center">
                    Salary Payments
                  </h3>
                  <?php $this->view("modules/include_tables/table_salary_slip_transaction");?>
                </table>
              </div>
            </div>
          <?php } ?>
          <?php if($this->session->userdata('user_role')!='purchase_manager'){?>
            <div class="m-portlet  m-portlet--rounded m-portlet--bordered div_subcontract_payments">
              <div class="m-portlet__body">
                <h3 class="m-portlet__head-text" style="text-align: center">
                  Subcontract Payments
                </h3>
                <?php $this->view("modules/include_tables/table_subcontract_payments");?>
              </div>
            </div>
          <?php } ?>
          <?php if($this->session->userdata('user_role')!='purchase_manager'){?>
            <div class="m-portlet  m-portlet--rounded m-portlet--bordered div_subcontract_summary">
              <div class="m-portlet__body">
                <h3 class="m-portlet__head-text" style="text-align: center">
                  Subcontract Summary
                </h3>
                <?php $this->view("modules/include_tables/table_subcontracts");?>
              </div>
            </div>
          <?php } ?>
          <div class="m-portlet  m-portlet--rounded m-portlet--bordered div_work_summary">
            <div class="m-portlet__body">
              <h3 class="m-portlet__head-text" style="text-align: center">
                Stage Summary
              </h3>
              <table width="100%" class="table m-table nowrap table-header-fixed table-striped table-bordered table-hover table-header-fixed" id="all_payments">
                <thead>
                  <tr class="">
                    <th>Heads</th>
                    <th>Amount</th>
                  </tr>
                </thead>
                <tbody>

                  <?php if($this->session->userdata('user_role')=='admin'){?>
                    <tr>
                      <td>Total Project Budget Estimated</td>
                      <strong><td class="total_project_budget_info"></td></strong>
                    </tr>
                  <?php } ?>
                  <?php if($this->session->userdata('user_role')!='supervisor'){?>
                    <tr>
                      <td></td>
                      <td></td>
                    </tr>
                    <?php if($this->session->userdata('user_role')!='purchase_manager' && $this->session->userdata('user_role')!='boq_manager'){?>
                      <tr>
                        <td>Client Payment Received</td>
                        <strong><td class="total_received_from_client_info"></td></strong>
                      </tr>
                    <?php } ?>
                    <tr>
                      <td>Total Purchase Bill Commissions Received</td>
                      <strong><td class="purchase_bill_commission_info"></td></strong>
                    </tr>
                    <tr>
                      <td></td>
                      <td></td>
                    </tr>
                  <?php } ?>
                  <tr>
                    <td>Total Purchase Bill Amount</td>
                    <strong><td class="total_purchases_bill_info"></td></strong>
                  </tr>
                  <?php if($this->config->item('app_module_purchase_order')==1){?>
                    <tr>
                      <td>Purchase Order Payments Made (Advances)</td>
                      <strong><td class="total_purchase_order_payments_info"></td></strong>
                    </tr>
                  <?php } ?>
                  <tr>
                    <td>Purchase Bill Payments Made</td>
                    <strong><td class="total_purchases_bill_payment_info"></td></strong>
                  </tr>
                  <?php if($this->config->item('app_module_purchase_order')==1){?>
                    <tr>
                      <td>Total Purchase Payments Made (Purchase Bill + Purchase Order)</td>
                      <strong><td class="total_purchase_payment_info"></td></strong>
                    </tr>
                  <?php } ?>
                  <tr>
                    <td>Pending Purchase Bill Payments</td>
                    <strong><td class="total_purchases_bill_pending_info"></td></strong>
                  </tr>
                  <tr>
                    <td></td>
                    <td></td>
                  </tr>
                  <?php if($this->config->item('app_module_stock_management')==1){?>
                    <tr>
                      <td>Total Stock Purchased Amount</td>
                      <strong><td class="total_purchases_bill_info"></td></strong>
                    </tr>
                    <tr>
                      <td>Total Stock Transfer In Amount</td>
                      <strong><td class="total_stock_transfer_in_info"></td></strong>
                    </tr>
                    <tr>
                      <td>Total Stock Transfer Out Amount</td>
                      <strong><td class="total_stock_transfer_out_info"></td></strong>
                    </tr>
                    <tr>
                      <td>Total Stock Consumed Amount</td>
                      <strong><td class="total_stock_consumed_info"></td></strong>
                    </tr>
                    <tr>
                      <td>Total Stock Balance Amount</td>
                      <strong><td class="total_stock_balance_info"></td></strong>
                    </tr>
                    <tr>
                      <td></td>
                      <td></td>
                    </tr>
                  <?php } ?>
                  <?php if($this->session->userdata('user_role')!='purchase_manager'){?>
                    <tr>
                      <td>Total Subcontract Payments</td>
                      <strong><td class="total_subcontract_payment_info"></td></strong>
                    </tr>
                  <?php } ?>
                  <?php if($this->session->userdata('user_role')!='purchase_manager'){?>
                    <tr>
                      <td>Total Labour Wages</td>
                      <strong><td class="total_labour_wages_info"></td></strong>
                    </tr>
                  <?php } ?>
                  <?php if($this->session->userdata('user_role')!='purchase_manager'){?>
                    <tr>
                      <td>Total Salary Payments</td>
                      <strong><td class="total_salary_payment_info"></td></strong>
                    </tr>
                  <?php } ?>
                  <?php if($this->session->userdata('user_role')!='purchase_manager'){?>
                    <tr>
                      <td>Total Other Expense Payments</td>
                      <strong><td class="total_other_expense_payments_info"></td></strong>
                    </tr>
                  <?php }?>
                  <tr>
                    <td></td>
                    <td></td>
                  </tr>
                  <?php if($this->session->userdata('user_role')!='purchase_manager'){?>
                    <tr>
                      <td>Total Expense Payments</td>
                      <strong><td class="total_expense_payments_info"></td></strong>
                    </tr>
                  <?php } ?>
                  <?php if($this->session->userdata('user_role')=='admin'){?>
                    <?php if($work_data->work_type==1){ ?>
                      <tr>
                        <td>Total Project Management Commission</td>
                        <strong><td class="total_commission_info"></td></strong>
                      </tr>
                    <?php } ?>
                    <tr>
                      <td>Total Amount to Receive From Client</td>
                      <strong><td class="total_amount_to_receive_info"></td></strong>
                    </tr>
                    <tr>
                      <td>Actual Received</td>
                      <strong><td class="total_received_from_client_info"></td></strong>
                    </tr>
                    <tr>
                      <td>Balance to Receive</td>
                      <strong><td class="total_balance_info"></td></strong>
                    </tr>
                    <tr>
                      <td>Total Work Profit (Actual Received - Actual Expense)</td>
                      <strong><td class="total_profit_info"></td></strong>
                    </tr>
                  <?php } ?>
                </tbody>
              </table>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
  <script src="<?php echo base_url()?>template/assets/vendors/base/vendors.bundle.js" type="text/javascript"></script>
  <script src="<?php echo base_url()?>template/assets/demo/default/base/scripts.bundle.js" type="text/javascript"></script>
  <script type="text/javascript" src="https://cdn.datatables.net/v/bs4/jszip-2.5.0/dt-1.10.20/b-1.6.1/b-colvis-1.6.1/b-flash-1.6.1/b-html5-1.6.1/b-print-1.6.1/fc-3.3.0/fh-3.1.6/kt-2.5.1/r-2.2.3/rg-1.1.1/sc-2.0.1/sp-1.0.1/datatables.min.js"></script>

  <!--end::Base Scripts -->
  <script>
    $(".data_display_option").change(function(event) {
      var data = $(this).val();
      if($(this).is(":checked")) {
        $(".div_"+data).removeClass('print_hide_div');
        $(".div_"+data).show();
      }else{
        $(".div_"+data).addClass('print_hide_div');
        $(".div_"+data).hide();
      }
    });
    var stage_info_table = $('#stage_info_table').DataTable({
      "bProcessing": true,
      "deferRender": true,
      "bDeferRender": true,
      "scrollX": false,
      bFilter: false,
      "bLengthChange": false,
      "bPaginate": false,
      "bInfo": false,
      "dom": "<'row' <'col-md-12'>><'row'<'col-md-6 col-sm-12'l><'col-md-6 col-sm-12'f>r><'table-scrollable't><'row'<'col-md-5 col-sm-12'i><'col-md-7 col-sm-12'p>>", // horizobtal scrollable datatable

      "columnDefs": [
      {
        "targets": [],
        className: "hidden"
      }
      ],
      'ordering': false
    });

    var table6 = $('#client_payments_view_table_1').DataTable({
      "ajax": {
        url: "<?php echo base_url()  . 'client_payments/select_client_payments/3' ?>", // json datasource
        type: "post", // type of method  , by default would be get
        data: function (d) {
          d.work = GetSearchWork();
        }
      },
      "bProcessing": true,
      "deferRender": true,
      "bDeferRender": true,
      "scrollX": false,
      bFilter: false,
      "bLengthChange": false,
      "bPaginate": false,
      "bInfo": false,
      "dom": "<'row' <'col-md-12'>><'row'<'col-md-6 col-sm-12'l><'col-md-6 col-sm-12'f>r><'table-scrollable't><'row'<'col-md-5 col-sm-12'i><'col-md-7 col-sm-12'p>>", // horizobtal scrollable datatable

      "columnDefs": [
      {
        "targets": [1,2,4,5],
        className: "hidden"
      }
      ],
      'ordering': false
    });

    select_summary();
    function select_summary(){
      var work_id = "<?php echo $work_data->work_id?>";
      var stage_id = "<?php echo $stage_data->stage_id?>";
      $.post("<?php echo base_url().'work/select_stage_summary/count' ?>",{
        work_id:work_id,stage_id:stage_id
      },function(data){
        var obj= $.parseJSON(data);
        $(".total_project_budget_info").html(obj.total_project_budget);
        $(".total_received_from_client_info").html(obj.total_client_payments_received);
        $(".purchase_bill_commission_info").html(obj.total_purchase_bill_commission);
        $(".total_purchases_bill_info").html(obj.total_purchase_bill_amount);
        $(".total_purchase_order_payments_info").html(obj.total_purchase_order_payment);
        $(".total_purchases_bill_payment_info").html(obj.total_purchase_bill_payment);
        $(".total_purchase_payment_info").html(obj.total_purchase_payment);
        $(".total_purchases_bill_pending_info").html(obj.total_purchase_bill_balance_amount);
        $(".total_subcontract_payment_info").html(obj.total_subcontract_payment);
        $(".total_labour_wages_info").html(obj.total_labour_wages);
        $(".total_salary_payment_info").html(obj.total_salary_payments);
        $(".total_vehicle_payments_info").html(obj.total_vehicle_payments);
        $(".total_other_expense_payments_info").html(obj.total_other_expense);
        $(".total_expense_payments_info").html(obj.total_expense_amount);
        $(".total_commission_info").html(obj.total_project_commission_amount);
        $(".total_amount_to_receive_info").html(obj.total_amount_to_receive);
        $(".total_balance_info").html(obj.balance_to_receive);
        $(".total_profit_info").html(obj.total_profit);

        $(".total_labours_worked_info").html(obj.total_labours_worked);
        $(".total_labours_days_info").html(obj.total_labour_days);
        $(".total_labours_wage_info").html(obj.total_labour_wages);

        $(".total_stock_transfer_in_info").html(obj.total_stock_transfer_in_amount);
        $(".total_stock_transfer_out_info").html(obj.total_stock_transfer_out_amount);
        $(".total_stock_consumed_info").html(obj.total_stock_consumption_amount);
        $(".total_stock_balance_info").html(obj.total_stock_balance_amount);


      })
    }
  </script>
  <!-- Client Payment Scripts -->
  <?php $this->view("modules/include_scripts/client_payments_scripts");?>

  <!-- Purchase Order Payments Scripts -->
  <?php $this->view("modules/include_scripts/purchase_order_payments_view_scripts");?>

  <!-- Purchase Bill Payments Scripts -->
  <?php $this->view("modules/include_scripts/purchase_bill_payments_view_scripts");?>

  <!-- Subcontract Scripts -->
  <?php $this->view("modules/include_scripts/subcontracts_view_scripts");?>

  <!-- Subcontract Payments Scripts -->
  <?php $this->view("modules/include_scripts/subcontract_payments_view_scripts");?>

  <!-- Expense Scripts -->
  <?php $this->view("modules/include_scripts/expense_bill_scripts");?>

  <!-- Labour Wage Scripts -->
  <?php $this->view("modules/include_scripts/labour_wage_scripts");?>

  <!-- Salary Slip Scripts -->
  <?php $this->view("modules/include_scripts/salary_slips_scripts");?>

  <script>
    jQuery(document).ready(function() {
      $($.fn.dataTable.tables(true)).DataTable()
      .columns.adjust()
      .responsive.recalc();
      $('#print').click(function(e) {
        window.print();
      })
    });
  </script>
  <style>
    .hidden{
      display: none;
    }
  </style>

</body>
</html>
