<?php $this->view("includes/Inc_pagehead"); ?>
<!-- Page Styles Goes Here-->

<?php $this->view("includes/Inc_navigation"); ?>
<div class="m-grid__item m-grid__item--fluid m-wrapper">
  <!-- BEGIN: Subheader -->
  <div class="m-subheader ">
    <div class="d-flex align-items-center">
      <div class="mr-auto">
        <h3 class="m-subheader__title m-subheader__title--separator">
          List Of <?php if ($this->session->userdata('user_role') == 'supervisor') {
            echo "Assigned";
          } ?> Ongoing Projects
        </h3>
        <ul class="m-subheader__breadcrumbs m-nav m-nav--inline">
          <li class="m-nav__item m-nav__item--home">
            <a href="#" class="m-nav__link m-nav__link--icon">
              <i class="m-nav__link-icon la la-home"></i>
            </a>
          </li>
          <li class="m-nav__separator">
            -
          </li>
          <li class="m-nav__item">
            <a href="<?php echo base_url() . 'dashboard' ?>" class="m-nav__link">
              <span class="m-nav__link-text">
                Home
              </span>
            </a>
          </li>
          <li class="m-nav__separator">
            -
          </li>
          <li class="m-nav__item">
            <a href="<?php echo base_url() . 'work' ?>" class="m-nav__link">
              <span class="m-nav__link-text">
                List Of <?php if ($this->session->userdata('user_role') == 'supervisor') {
                  echo "Assigned";
                } ?> Ongoing Projects
              </span>
            </a>
          </li>


        </ul>
      </div>
      <div>
        <?php if ($this->session->flashdata('flashdata_msg') != "") { ?>
          <div class="alert alert-<?php echo $this->session->flashdata('alert_type') ?> alert-dismissible fade show   m-alert m-alert--air m-alert--outline m-alert--outline-2x" role="alert">
            <button type="button" class="close" data-dismiss="alert" aria-label="Close"></button>
            <strong>
              <?php echo $this->session->flashdata('flashdata_title') ?>
            </strong>
            <?php echo $this->session->flashdata('flashdata_msg') ?>
          </div>
        <?php } ?>
      </div>
    </div>
  </div>
  <!-- END: Subheader -->
  <div class="m-content">
    <div class="m-portlet m-portlet--mobile m-portlet--info m-portlet--head-solid-bg m-portlet--bordered m-portlet--rounded">
      <div class="m-portlet__head">
        <div class="m-portlet__head-caption">
          <div class="m-portlet__head-title">
            <h3 class="m-portlet__head-text">
              List of <?php if ($this->session->userdata('user_role') == 'supervisor') {
                echo "Assigned";
              } ?> Ongoing Projects
            </h3>
          </div>
        </div>
        <div class="m-portlet__head-tools">
          <?php if ($this->session->userdata('user_role') == 'admin') { ?>
            <?php if ($this->config->item('Project_disable_add_button') == 0){ ?>
              <a href="<?php echo base_url() . 'work/add' ?>" class="btn btn-focus m-btn m-btn--custom m-btn--icon m-btn--air m-btn--pill">
                <span>
                  <i class="la la-plus"></i>
                  <span>
                    Add New Project
                  </span>
                </span>
              </a>
            <?php } ?>
          <?php } ?>
        </div>
      </div>
      <div class="m-portlet__body">
        <!--begin: Search Form -->
        <div class="m-form m-form--label-align-right m--margin-bottom-10">
          <div class="row">
            <div class="col-xl-12 order-2 order-xl-1">
              <div class="form-group m-form__group row ">
                <div class="col-lg-3">
                  <div class="form-group m-form__group">
                    <label>
                      Project Section
                    </label>
                    <div class="m-select2 m-select2--air m-select2--pill">
                      <select width="100%" required class="form-control m-select2 table_filter" id="project_section">
                        <option selected value="all"> All Project Section</option>
                        <?php foreach ($this->config->item('project_sections') as $key => $value) { ?>
                          <option value="<?php echo $value->section_name ?>"><?php echo $value->section_name ?></option>
                        <?php } ?>
                      </select>
                    </div>
                    <span class="m-form__help"></span>
                  </div>
                </div>
                <div class="col-lg-3">
                  <div class="form-group m-form__group">
                    <label>
                      Project Category
                    </label>
                    <div class="m-select2 m-select2--air m-select2--pill">
                      <select width="100%" required class="form-control m-select2 table_filter" id="project_type">
                        <option selected value="all"> All Project Category</option>
                        <?php foreach ($project_categories as $key => $value) { ?>
                          <option value="<?php echo $value->wcat_id ?>"><?php echo $value->wcat_name ?></option>
                        <?php } ?>
                      </select>
                    </div>
                    <span class="m-form__help"></span>
                  </div>
                </div>
                <div class="col-lg-3">
                  <div class="form-group m-form__group">
                    <label>
                      Client
                    </label>
                    <div class="m-select2 m-select2--air m-select2--pill">
                      <select width="100%" required class="form-control m-select2 table_filter" id="client">

                      </select>
                    </div>
                    <span class="m-form__help"></span>
                  </div>
                </div>
                <div class="col-lg-3">
                  <div class="form-group m-form__group">
                    <label>
                      Assigned User
                    </label>
                    <div class="m-select2 m-select2--air m-select2--pill">
                      <select width="100%" required class="form-control m-select2 table_filter" id="assigned_user">
                        <option selected value="all"> All Supervisors</option>
                        <?php foreach ($assign_users as $user) { ?>
                          <option value="<?php echo $user->user_id ?>"><?php echo $user->user_alias ?></option>
                        <?php } ?>
                      </select>
                    </div>
                    <span class="m-form__help"></span>
                  </div>
                </div>

                <?php if (!empty($this->config->item('company_branches'))) { ?>

                  <div class="col-lg-3">
                    <div class="form-group m-form__group">
                      <label>
                        Company Branch
                      </label>
                      <div class="m-select2 m-select2--air m-select2--pill">
                        <select width="100%" required class="form-control m-select2 table_filter company-branch-select2" id="company_branch">
                          <option selected value="all"> All Branches</option>
                          <option value="0">NO BRANCH</option>
                          <?php foreach ($this->config->item('company_branches') as $key => $value) { ?>
                            <option value="<?php echo $value->branch_id ?>"><?php echo $value->branch_name ?></option>
                          <?php } ?>
                        </select>
                      </div>
                      <span class="m-form__help"></span>
                    </div>
                  </div>

                <?php } ?>
                <?php if ($this->config->item('multi_company') == 1) { ?>
                  <div class="col-lg-3">
                    <div class="form-group m-form__group">
                      <label>
                        Company
                      </label>
                      <div class="m-select2 m-select2--air m-select2--pill">
                        <select width="100%" required  class="form-control m-select2 table_filter" id="company_filter" >
                          <option selected value="all"> All Companies</option>
                          <?php foreach ($companies as $key => $value) {?>
                            <option value="<?php echo $value->company_id?>"><?php echo $value->company_name?></option>
                          <?php } ?>
                        </select>
                      </div>
                      <span class="m-form__help"></span>
                    </div>
                  </div>
                <?php } ?>
                <?php if ($this->config->item('Project_parent_child_enable') == 1) { ?>
                  <div class="col-lg-3">
                    <div class="form-group m-form__group">
                      <label>
                        Main Project
                      </label>
                      <div class="m-select2 m-select2--air m-select2--pill">
                        <select width="100%"   class="form-control m-select2 table_filter" id="parent_project" name="parent_project"  >
                          <option selected disabled> Select Main Project</option>
                          <?php foreach ($master_projects as $key => $value) {?>
                            <option value="<?php echo $value->work_id?>">#<?php echo $value->work_id.' - '.$value->work_name.' ['.$value->client_name.']'?></option>
                          <?php } ?>
                        </select>
                      </div>
                      <span class="m-form__help"></span>
                    </div>
                  </div>
                <?php } ?>
              </div>
            </div>
          </div>
        </div>
        <!--end: Search Form -->
        <!--begin: Datatable -->
        <table width="100%" class="table m-table nowrap table-header-fixed table-striped table-bordered table-hover table-header-fixed" id="projects_list_table">
          <thead>
            <tr class="">
              <th>Project ID</th>
              <th>Sl No</th>
              <th>Company</th>
              <th>Branch</th>
              <th>Project ID & Name</th>
              <th><?php echo $this->config->item('Project_reference_no_title') ?></th>
              <?php if ($this->session->userdata('user_role') == 'supervisor') { ?>
                <th>Role</th>
              <?php } else { ?>
                <th>Assigned Supervisors</th>
              <?php } ?>
              <th>Client Name</th>
              <th>Client Contacts</th>
              <th>Location</th>
              <th>Area</th>
              <th>Section</th>
              <th>Project Category</th>
              <?php if ($this->session->userdata('user_role') == 'admin') { ?>
                <th>Total Budget Amount</th>
              <?php } ?>
              <th>Project Status</th>
              <th>Other Details</th>
              <th>Creation</th>
              <th></th>
              <th></th>
              <th>Last Update</th>
              <th>Profile</th>
              <th>Actions</th>
            </tr>
          </thead>
          <tbody>
          </tbody>
        </table>
        <!--end: Datatable -->
        <div class="modal fade" tabindex="-1" id="work_delete_modal" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
          <div class="modal-dialog " role="document">
            <form autocomplete="off" method="post" action="<?php echo base_url() . 'work/delete' ?>" class="form-horizontal">
              <div class="modal-content">
                <div class="alert alert-danger" role="alert" style="margin-bottom: 0px">
                  <button type="button" class="close" data-dismiss="modal"></button>
                  <br />
                  <h4 class="alert-heading">Warning! Please Confirm Your Action</h4>
                  <br />
                  <p> Are You Sure to Delete this Data ?. All the Associated Data will Lost. </p>
                  <p>
                    <button class="btn btn-danger " type="submit" name="submit">Confirm & Delete</button>
                    <button type="button" class="btn btn-primary modal-dismiss" data-dismiss="modal">Cancel</button>
                  </p>
                  <input type="hidden" name="work_id" id="work_delete_id">
                </div>
              </div>
            </form>
          </div>
        </div>

      </div>
    </div>
  </div>
</div>
</div>
<!-- end:: Body -->
<!-- begin::Footer -->

<?php $this->view("includes/Inc_footer"); ?>
<!-- end::Footer -->
</div>
<!-- end:: Page -->

<?php $this->view("includes/Inc_sidebar"); ?>
<?php $this->view("includes/Inc_scripts"); ?>
<!--begin::Page Snippets -->


<script>
$("#table_filter_status").selectpicker();
$("[data-switch=true]").bootstrapSwitch()
</script>
<!--end::Page Snippets -->
<script>
$("#works_menu").addClass('m-menu__item--active m-menu__item--open');
$("#works_menu_2").addClass('m-menu__item--active');

$('body').on('click', '#work_delete_btn', function() {
  var no = $(this).closest('tr').children('td');
  $('#work_delete_id').val(no.eq(0).text());

})
$("#parent_project").select2({
  placeholder: "Select Project",
})
$("#project_section").select2({
  placeholder: "Select Project Section"
})
$("#project_type").select2({
  placeholder: "Select Project Type"
})
$("#assigned_user").select2({
  placeholder: "Select Assigned User"
})
$("#client").select2({
  placeholder: "Select Client"
})
$("#company_filter").select2({
  placeholder: "Select Company"
})
select_client();

function select_client() {
  $('#client').html('');
  $("#client").append("<option value='all' selected >All Clients</option>");
  $.post("<?php echo base_url() ?>clients/select", {}, function(data) {
    var obj = $.parseJSON(data);
    var i = 0;
    if (obj.count > 0) {
      while (i < obj.id.length) {
        $("#client").append("<option value=" + obj.id[i] + ">" + obj.name[i] + "</option>");
        i++;
      }
    }
  })
}
</script>
<style>
/*    Datatable Hide Columns*/
.hide_column {
  display: none;
}
</style>
<script>
//  User List Data Table
var Datatable = function() {
  var t = function() {
    function GetSearchSection() {
      return $('#project_section').val();
    }

    function GetSearchType() {
      return $('#project_type').val();
    }

    function GetSearchClient() {
      return $('#client').val();
    }

    function GetSearchUser() {
      return $('#assigned_user').val();
    }
    function GetSearchCompany() {
      return $('#company_filter').val();
    }
    function GetSearchParentProject() {
      return $('#parent_project').val();
    }

    function get_branch_id() {
      return $('#company_branch :selected').val();
    }

    var table = $('#projects_list_table').DataTable({
      "ajax": {
        url: "<?php echo base_url() . 'work/select_work' ?>", // json datasource
        type: "post", // type of method  , by default would be get
        data: function(d) {
          d.project_section = GetSearchSection();
          d.project_type = GetSearchType();
          d.client = GetSearchClient();
          d.assigned_user = GetSearchUser();
          d.work_status = 0;
          <?php if (!empty($this->config->item('company_branches'))) { ?>
            d.branch_id = get_branch_id();
            <?php } ?>
            <?php if ($this->config->item('multi_company') == 1) { ?>
              d.company_id = GetSearchCompany();
              <?php } ?>
              <?php if ($this->config->item('Project_parent_child_enable') == 1) { ?>
                d.parent_project = GetSearchParentProject();
                <?php } ?>
            }
          },
          "bProcessing": true,
          "deferRender": true,
          "bDeferRender": true,
          "scrollX": true,
          buttons: [{
            extend: 'print',
            className: 'btn dark btn-outline',
            exportOptions: {
              columns: ':visible'
            },
            title: 'Ongoing Projects'
          },
          {
            extend: 'csv',
            className: 'btn purple btn-outline '
          },
          {
            extend: 'colvis',
            className: 'btn dark btn-outline',
            text: 'Columns'
          }
        ],
        dom: "<'row'<'col-sm-6 text-left'B><'col-sm-6 text-right'f>>\n\t\t\t<'row'<'col-sm-12'tr>>\n\t\t\t<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 dataTables_pager'lp>>", // horizobtal scrollable datatable
        "lengthMenu": [
          [25, 50, 100, -1],
          [25, 50, 100, "All"] // change per page values here
        ],
        // set the initial value
        "pageLength": 25,
        "columnDefs": [{
          "targets": [0, 16, 17 <?php if ($this->session->userdata('user_role') != 'admin' && $this->session->userdata('user_role') != 'madmin') {
            echo ",12,7,6";
          } ?> <?php if (empty($this->config->item('company_branches'))) { echo ",3"; }?><?php if ($this->config->item('multi_company')==0) { echo ",2"; }?> ],
          className: "hidden"
        }],
        'order': [
          [0, 'desc']
        ]
      });
      $(".table_filter").on("change", function() {
        table.ajax.reload();
      });
      $(".hide_column").hide();
    };
    return {
      init: function() {
        t()
      }
    }
  }

  ();
  jQuery(document).ready(function() {
    Datatable.init();
    $(".hidden").hide();
    //            $('#service_view_table').wrap("");
  }

);
</script>
