<?php $this->view("includes/Inc_pagehead"); ?>
<!-- Page Styles Goes Here-->

<?php $this->view("includes/Inc_navigation"); ?>
<div class="m-grid__item m-grid__item--fluid m-wrapper">
  <!-- BEGIN: Subheader -->
  <div class="m-subheader ">
    <div class="d-flex align-items-center">
      <div class="mr-auto">
        <h3 class="m-subheader__title m-subheader__title--separator">
          Project - Enquiry Report
        </h3>
        <ul class="m-subheader__breadcrumbs m-nav m-nav--inline">
          <li class="m-nav__item m-nav__item--home">
            <a href="#" class="m-nav__link m-nav__link--icon">
              <i class="m-nav__link-icon la la-home"></i>
            </a>
          </li>
          <li class="m-nav__separator">
            -
          </li>
          <li class="m-nav__item">
            <a href="<?php echo base_url() . 'dashboard' ?>" class="m-nav__link">
              <span class="m-nav__link-text">
                Home
              </span>
            </a>
          </li>
          <li class="m-nav__separator">
            -
          </li>
          <li class="m-nav__item">
            <a href="<?php echo base_url() . 'work' ?>" class="m-nav__link">
              <span class="m-nav__link-text">
                  Project - Enquiry Report
              </span>
            </a>
          </li>


        </ul>
      </div>
      <div>
        <?php if ($this->session->flashdata('flashdata_msg') != "") { ?>
          <div class="alert alert-<?php echo $this->session->flashdata('alert_type') ?> alert-dismissible fade show   m-alert m-alert--air m-alert--outline m-alert--outline-2x" role="alert">
            <button type="button" class="close" data-dismiss="alert" aria-label="Close"></button>
            <strong>
              <?php echo $this->session->flashdata('flashdata_title') ?>
            </strong>
            <?php echo $this->session->flashdata('flashdata_msg') ?>
          </div>
        <?php } ?>
      </div>
    </div>
  </div>
  <!-- END: Subheader -->
  <div class="m-content">
    <div class="m-portlet m-portlet--mobile m-portlet--info m-portlet--head-solid-bg m-portlet--bordered m-portlet--rounded">
      <div class="m-portlet__head">
        <div class="m-portlet__head-caption">
          <div class="m-portlet__head-title">
            <h3 class="m-portlet__head-text">
              List of Projects
            </h3>
          </div>
        </div>
        <div class="m-portlet__head-tools">

        </div>
      </div>
      <div class="m-portlet__body">
        <!--begin: Search Form -->
        <div class="m-form m-form--label-align-right m--margin-bottom-10">
          <div class="row">
            <div class="col-xl-12 order-2 order-xl-1">
              <div class="form-group m-form__group row ">
                <div class="col-lg-3">
                  <div class="form-group m-form__group">
                    <label>
                      Project Section
                    </label>
                    <div class="m-select2 m-select2--air m-select2--pill">
                      <select width="100%" required class="form-control m-select2 table_filter" id="project_section">
                        <option selected value="all"> All Project Section</option>
                        <?php foreach ($this->config->item('project_sections') as $key => $value) { ?>
                          <option value="<?php echo $value->section_name ?>"><?php echo $value->section_name ?></option>
                        <?php } ?>
                      </select>
                    </div>
                    <span class="m-form__help"></span>
                  </div>
                </div>
                <div class="col-lg-3">
                  <div class="form-group m-form__group">
                    <label>
                      Project Category
                    </label>
                    <div class="m-select2 m-select2--air m-select2--pill">
                      <select width="100%" required class="form-control m-select2 table_filter" id="project_type">
                        <option selected value="all"> All Project Category</option>
                        <?php foreach ($project_categories as $key => $value) { ?>
                          <option value="<?php echo $value->wcat_id ?>"><?php echo $value->wcat_name ?></option>
                        <?php } ?>
                      </select>
                    </div>
                    <span class="m-form__help"></span>
                  </div>
                </div>
                <div class="col-lg-3">
                  <div class="form-group m-form__group">
                    <label>
                      Client
                    </label>
                    <div class="m-select2 m-select2--air m-select2--pill">
                      <select width="100%" required class="form-control m-select2 table_filter" id="client">

                      </select>
                    </div>
                    <span class="m-form__help"></span>
                  </div>
                </div>
                <div class="col-lg-3">
                  <div class="form-group m-form__group">
                    <label>
                      Assigned User
                    </label>
                    <div class="m-select2 m-select2--air m-select2--pill">
                      <select width="100%" required class="form-control m-select2 table_filter" id="assigned_user">
                        <option selected value="all"> All Supervisors</option>
                        <?php foreach ($assign_users as $user) { ?>
                          <option value="<?php echo $user->user_id ?>"><?php echo $user->user_alias ?></option>
                        <?php } ?>
                      </select>
                    </div>
                    <span class="m-form__help"></span>
                  </div>
                </div>

                <?php if (!empty($this->config->item('company_branches'))) { ?>

                  <div class="col-lg-3">
                    <div class="form-group m-form__group">
                      <label>
                        Company Branch
                      </label>
                      <div class="m-select2 m-select2--air m-select2--pill">
                        <select width="100%" required class="form-control m-select2 table_filter company-branch-select2" id="company_branch">
                          <option selected value="all"> All Branches</option>
                          <option value="0">NO BRANCH</option>
                          <?php foreach ($this->config->item('company_branches') as $key => $value) { ?>
                            <option value="<?php echo $value->branch_id ?>"><?php echo $value->branch_name ?></option>
                          <?php } ?>
                        </select>
                      </div>
                      <span class="m-form__help"></span>
                    </div>
                  </div>

                <?php } ?>

              </div>
            </div>
          </div>
        </div>
        <!--end: Search Form -->
        <!--begin: Datatable -->
        <table width="100%" class="table m-table nowrap table-header-fixed table-striped table-bordered table-hover table-header-fixed" id="projects_list_table">
          <thead>
            <tr class="">
              <th>Sl No</th>
              <th>Branch</th>
              <th>Project ID</th>
              <th>Enquiry ID/<br/>Reference No</th>
              <th>Project Name</th>
              <th>Created<br/>Date</th>
              <th>Client</th>
              <th>Address</th>
              <th>Contact Person</th>
              <th>Phone No</th>
              <th>Enquiry Mode</th>
              <th>Priority</th>
              <th>Service</th>
              <th>Service Details</th>
              <th>Service Type</th>
              <th>Work Place</th>
              <th>Nature of Enquiry</th>
              <th>Observations</th>
              <th>Actions Taken</th>
              <th>Allocated Tech.</th>
              <th>Enquiry Closed By</th>
              <th>Enquiry Closed Date</th>
              <th>Enquiry Ageing</th>
              <th>Enquiry Status</th>
              <th><?php echo $this->config->item('Project_reference_no_2_title') ?></th>
              <th>Quote Value/<br/>Project Budget</th>
              <th>LPO Status</th>
              <th>LPO No</th>
              <th>LPO Value</th>
              <th>Client Invoices</th>
              <th>Total<br/>Invoice Value</th>
              <th>Total<br/>Subcontract Value</th>
              <th>Project Notes</th>
              <th>Planned<br/> Start Date</th>
              <th>Planned<br/>Date of Completion</th>
              <th>Assigned Supervisors</th>
              <th>Section</th>
              <th>Project Category</th>
              <th>Project Status</th>
              <th>Other Details</th>
              <th>Creation</th>
            </tr>
          </thead>
          <tbody>
          </tbody>
        </table>
      </div>
    </div>
  </div>
</div>
</div>
<!-- end:: Body -->
<!-- begin::Footer -->

<?php $this->view("includes/Inc_footer"); ?>
<!-- end::Footer -->
</div>
<!-- end:: Page -->

<?php $this->view("includes/Inc_sidebar"); ?>
<?php $this->view("includes/Inc_scripts"); ?>
<!--begin::Page Snippets -->


<script>
$("#table_filter_status").selectpicker();
$("[data-switch=true]").bootstrapSwitch()
</script>
<!--end::Page Snippets -->
<script>
$("#works_menu").addClass('m-menu__item--active m-menu__item--open');
$("#works_menu_6").addClass('m-menu__item--active');

$('body').on('click', '#work_delete_btn', function() {
  var no = $(this).closest('tr').children('td');
  $('#work_delete_id').val(no.eq(0).text());

})

$("#project_section").select2({
  placeholder: "Select Project Section"
})
$("#project_type").select2({
  placeholder: "Select Project Type"
})
$("#assigned_user").select2({
  placeholder: "Select Assigned User"
})
$("#client").select2({
  placeholder: "Select Client"
})
select_client();

function select_client() {
  $('#client').html('');
  $("#client").append("<option value='all' selected >All Clients</option>");
  $.post("<?php echo base_url() ?>clients/select", {}, function(data) {
    var obj = $.parseJSON(data);
    var i = 0;
    if (obj.count > 0) {
      while (i < obj.id.length) {
        $("#client").append("<option value=" + obj.id[i] + ">" + obj.name[i] + "</option>");
        i++;
      }
    }
  })
}
</script>
<style>
/*    Datatable Hide Columns*/
.hide_column {
  display: none;
}
</style>
<script>
//  User List Data Table
var Datatable = function() {
  var t = function() {
    function GetSearchSection() {
      return $('#project_section').val();
    }

    function GetSearchType() {
      return $('#project_type').val();
    }

    function GetSearchClient() {
      return $('#client').val();
    }

    function GetSearchUser() {
      return $('#assigned_user').val();
    }

    function get_branch_id() {
      return $('#company_branch :selected').val();
    }

    var table = $('#projects_list_table').DataTable({
      "ajax": {
        url: "<?php echo base_url() . 'work/select_project_enquiry_report' ?>", // json datasource
        type: "post", // type of method  , by default would be get
        data: function(d) {
          d.project_section = GetSearchSection();
          d.project_type = GetSearchType();
          d.client = GetSearchClient();
          d.assigned_user = GetSearchUser();
          d.work_status = 0;
          <?php if (!empty($this->config->item('company_branches'))) { ?>
            d.branch_id = get_branch_id();
            <?php } ?>
          }
        },
        "bProcessing": true,
        "deferRender": true,
        "bDeferRender": true,
        "scrollX": true,
        buttons: [{
          extend: 'print',
          className: 'btn dark btn-outline',
          exportOptions: {
            columns: ':visible'
          },
          title: 'Ongoing Projects'
        },
        {
          extend: 'csv',
          className: 'btn purple btn-outline '
        },
        {
          extend: 'colvis',
          className: 'btn dark btn-outline',
          text: 'Columns'
        }
      ],
      dom: "<'row'<'col-sm-6 text-left'B><'col-sm-6 text-right'f>>\n\t\t\t<'row'<'col-sm-12'tr>>\n\t\t\t<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 dataTables_pager'lp>>", // horizobtal scrollable datatable
      "lengthMenu": [
        [25, 50, 100, -1],
        [25, 50, 100, "All"] // change per page values here
      ],
      // set the initial value
      "pageLength": 25,
      "columnDefs": [{
        "targets": [<?php if (empty($this->config->item('company_branches'))) { echo ",1"; }?> ],
        className: "hidden"
      },
      {
        render: function (data, type, full, meta) {
          return "<div class='text-wrap width-300'>" + data + "</div>";
        },
        targets: [ 7,32 ],
      }],
      'order': [
        [0, 'asc']
      ]
    });
    $(".table_filter").on("change", function() {
      table.ajax.reload();
    });
    $(".hide_column").hide();
  };
  return {
    init: function() {
      t()
    }
  }
}

();
jQuery(document).ready(function() {
  Datatable.init();
  $(".hidden").hide();
  //            $('#service_view_table').wrap("");
}

);
</script>
