<?php $this->view("includes/Inc_pagehead"); ?>
<!-- Page Styles Goes Here-->

<?php $this->view("includes/Inc_navigation"); ?>
<div class="m-grid__item m-grid__item--fluid m-wrapper">
  <!-- BEGIN: Subheader -->
  <div class="m-subheader ">
    <div class="d-flex align-items-center">
      <div class="mr-auto">
        <h3 class="m-subheader__title m-subheader__title--separator">
          All Project Summary
        </h3>
        <ul class="m-subheader__breadcrumbs m-nav m-nav--inline">
          <li class="m-nav__item m-nav__item--home">
            <a href="#" class="m-nav__link m-nav__link--icon">
              <i class="m-nav__link-icon la la-home"></i>
            </a>
          </li>
          <li class="m-nav__separator">
            -
          </li>
          <li class="m-nav__item">
            <a href="<?php echo base_url() . 'dashboard' ?>" class="m-nav__link">
              <span class="m-nav__link-text">
                Home
              </span>
            </a>
          </li>
          <li class="m-nav__separator">
            -
          </li>
          <li class="m-nav__item">
            <a href="<?php echo base_url() . 'work/all_summary' ?>" class="m-nav__link">
              <span class="m-nav__link-text">
                All Project Summary
              </span>
            </a>
          </li>


        </ul>
      </div>
      <div>
        <?php if ($this->session->flashdata('flashdata_msg') != "") { ?>
          <div class="alert alert-<?php echo $this->session->flashdata('alert_type') ?> alert-dismissible fade show   m-alert m-alert--air m-alert--outline m-alert--outline-2x" role="alert">
            <button type="button" class="close" data-dismiss="alert" aria-label="Close"></button>
            <strong>
              <?php echo $this->session->flashdata('flashdata_title') ?>
            </strong>
            <?php echo $this->session->flashdata('flashdata_msg') ?>
          </div>
        <?php } ?>
      </div>
    </div>
  </div>
  <!-- END: Subheader -->
  <div class="m-content">
    <div class="m-portlet m-portlet--mobile m-portlet--info m-portlet--head-solid-bg m-portlet--bordered m-portlet--rounded">
      <div class="m-portlet__body">
        <!--begin: Search Form -->
        <div class="m-form m-form--label-align-right m--margin-bottom-10">
          <div class="row">
            <div class="col-xl-12 order-2 order-xl-1">
              <div class="form-group m-form__group row ">
                <div class="col-lg-3">
                  <div class="form-group m-form__group">
                    <label>
                      Project Section
                    </label>
                    <div class="m-select2 m-select2--air m-select2--pill">
                      <select width="100%" required class="form-control m-select2 table_filter" id="project_section">
                        <option selected value="all"> All Project Section</option>
                        <?php foreach ($this->config->item('project_sections') as $key => $value) { ?>
                          <option value="<?php echo $value->section_name ?>"><?php echo $value->section_name ?></option>
                        <?php } ?>
                      </select>
                    </div>
                    <span class="m-form__help"></span>
                  </div>
                </div>
                <div class="col-lg-3">
                  <div class="form-group m-form__group">
                    <label>
                      Project Category
                    </label>
                    <div class="m-select2 m-select2--air m-select2--pill">
                      <select width="100%" required class="form-control m-select2 table_filter" id="project_type">
                        <option selected value="all"> All Project Category</option>
                        <?php foreach ($project_categories as $key => $value) { ?>
                          <option value="<?php echo $value->wcat_id ?>"><?php echo $value->wcat_name ?></option>
                        <?php } ?>
                      </select>
                    </div>
                    <span class="m-form__help"></span>
                  </div>
                </div>
                <div class="col-lg-3">
                  <div class="form-group m-form__group">
                    <label>
                      Client
                    </label>
                    <div class="m-select2 m-select2--air m-select2--pill">
                      <select width="100%" required class="form-control m-select2 table_filter" id="client">

                      </select>
                    </div>
                    <span class="m-form__help"></span>
                  </div>
                </div>
                <div class="col-lg-3">
                  <div class="form-group m-form__group">
                    <label>
                      Work Status:
                    </label>
                    <div class="m-select2 m-select2--air m-select2--pill">
                      <select style="width: 100%" class="form-control m-select2 table_filter" id="work_status" name="work_status" data-placeholder="Select Work">
                        <option value="all">All Status</option>
                        <option value="2">Pending</option>
                        <option value="1">Completed</option>
                        <option value="3">Freeze</option>
                      </select>
                    </div>
                    <span class="m-form__help"></span>
                  </div>
                </div>

                <?php if (!empty($this->config->item('company_branches'))) { ?>

                  <div class="col-lg-3">
                    <div class="form-group m-form__group">
                      <label>
                        Company Branch
                      </label>
                      <div class="m-select2 m-select2--air m-select2--pill">
                        <select width="100%" required class="form-control m-select2 table_filter company-branch-select2" id="company_branch">
                          <option selected value="all"> All Branches</option>
                          <option value="0">NO BRANCH</option>
                          <?php foreach ($this->config->item('company_branches') as $key => $value) { ?>
                            <option value="<?php echo $value->branch_id ?>"><?php echo $value->branch_name ?></option>
                          <?php } ?>
                        </select>
                      </div>
                      <span class="m-form__help"></span>
                    </div>
                  </div>

                <?php } ?>
                <?php if ($this->config->item('multi_company') == 1) { ?>
                  <div class="col-lg-3">
                    <div class="form-group m-form__group">
                      <label>
                        Company
                      </label>
                      <div class="m-select2 m-select2--air m-select2--pill">
                        <select width="100%" required  class="form-control m-select2 table_filter" id="company_filter" >
                          <option selected value="all"> All Companies</option>
                          <?php foreach ($companies as $key => $value) {?>
                            <option value="<?php echo $value->company_id?>"><?php echo $value->company_name?></option>
                          <?php } ?>
                        </select>
                      </div>
                      <span class="m-form__help"></span>
                    </div>
                  </div>
                  <?php } ?>
                <div class="col-md-2">
                  <br />
                  <button style="margin-top: 7px" id="btn_go" class="btn btn-focus m-btn m-btn--custom m-btn--icon m-btn--air m-btn--pill">
                    <span>
                      <i class="la la-search"></i>
                      <span>
                        Go
                      </span>
                    </span>
                  </button>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
    <div class="m-portlet m-portlet--mobile m-portlet--info m-portlet--head-solid-bg m-portlet--bordered m-portlet--rounded" id="income_expense_report_div" style="display:none">
      <div class="m-portlet__head">
        <div class="m-portlet__head-caption">
          <div class="m-portlet__head-title">
            <h3 class="m-portlet__head-text">
              All Project Summary
            </h3>
          </div>
        </div>
        <div class="m-portlet__head-tools">

        </div>
      </div>
      <div class="m-portlet__body">
        <!--end: Search Form -->
        <!--begin: Datatable -->
        <table width="100%" class="table m-table nowrap table-header-fixed table-striped table-bordered table-hover table-header-fixed" id="projectwise_report_view_table">
          <thead>
            <tr class="">
              <th>ID</th>
              <th>Project</th>
              <th>Client</th>
              <th>Status</th>
              <th>Est. Project Budget</th>
              <th>Rcvd Client Payments</th>
              <th>Purchase Bill</th>
              <th>Labour Wage Slip</th>
              <th>Salary Slip</th>
              <th>Expense Bills</th>
              <th>Subcontract Bills</th>
              <th>Purchase Order Payments</th>
              <th>Purchase Bill Payments</th>
              <th>Salary Slip Payments</th>
              <th>Expense Bill Payments</th>
              <th>Subcontract Payments</th>
              <th>User Commission Payments</th>
              <th>Stock Transfer In</th>
              <th>Stock Transfer Out</th>
              <th>Total Project Expense</th>
              <th>Total Project Cost<br />(Include Stock Transfers)</th>
              <th>Total Project Income</th>
              <th>Balance to Receive From Client</th>
              <th>Project Profit</th>
              <!-- <th>Other Expense Amt</th>
              <th>Actual Profit</th> -->
              <th>Income Tax Amt</th>
              <th>Expense Tax Amt</th>
            </tr>
          </thead>
          <tbody>
          </tbody>
        </table>
        <!--end: Datatable -->

      </div>
    </div>
  </div>
</div>
</div>
<!-- end:: Body -->
<!-- begin::Footer -->

<?php $this->view("includes/Inc_footer"); ?>
<!-- end::Footer -->
</div>
<!-- end:: Page -->

<?php $this->view("includes/Inc_sidebar"); ?>
<?php $this->view("includes/Inc_scripts"); ?>
<!--begin::Page Snippets -->


<script>
$("#table_filter_status").selectpicker();
$("[data-switch=true]").bootstrapSwitch()
</script>
<!--end::Page Snippets -->
<script>
$("#works_menu").addClass('m-menu__item--active m-menu__item--open');
$("#works_menu_5").addClass('m-menu__item--active');

$("#company_filter").select2({
  placeholder: "Select Company"
})
$("#project_section").select2({
  placeholder: "Select Project Section"
})
$("#project_type").select2({
  placeholder: "Select Project Type"
})
$("#client").select2({
  placeholder: "Select Client"
})
$("#work_status").select2({
  placeholder: "Select Status"
})
select_client();

function select_client() {
  $('#client').html('');
  $("#client").append("<option value='all' selected >All Clients</option>");
  $.post("<?php echo base_url() ?>clients/select", {}, function(data) {
    var obj = $.parseJSON(data);
    var i = 0;
    if (obj.count > 0) {
      while (i < obj.id.length) {
        $("#client").append("<option value=" + obj.id[i] + ">" + obj.name[i] + "</option>");
        i++;
      }
    }
  })
}
</script>
<style>
/*    Datatable Hide Columns*/
.hide_column {
  display: none;
}
</style>
<script>
//  User List Data Table
var Datatable = function() {
  var t = function() {
    function GetSearchSection() {
      return $('#project_section').val();
    }
    function GetSearchType() {
      return $('#project_type').val();
    }
    function GetSearchClient() {
      return $('#client').val();
    }
    function GetSearchStatus() {
      return $('#work_status').val();
    }
    function GetSearchCompany() {
      return $('#company_filter').val();
    }
    function get_branch_id() {
      return $('#company_branch :selected').val();
    }

    $('#projectwise_report_view_table').dataTable().fnDestroy();
    var projectwise_report_view_table = $('#projectwise_report_view_table').DataTable({
      "ajax": {
        url: "<?php echo base_url() . 'reports/select_projectwise_profit' ?>", // json datasource
        type: "post", // type of method  , by default would be get
        data: function(d) {
          d.project_section = GetSearchSection();
          d.project_type = GetSearchType();
          d.client = GetSearchClient();
          d.status = GetSearchStatus();
          <?php if (!empty($this->config->item('company_branches'))) { ?>
            d.branch_id = get_branch_id();
            <?php } ?>
            <?php if ($this->config->item('multi_company') == 1) { ?>
              d.company_id = GetSearchCompany();
              <?php } ?>
          }
        },
        "bProcessing": true,
        "deferRender": true,
        "bDeferRender": true,

        "scrollX": true,
        buttons: [{
          extend: 'print',
          className: 'btn dark btn-outline',
          exportOptions: {
            columns: ':visible'
          },
          title: 'All Project Summary'
        },
        {
          extend: 'csv',
          className: 'btn purple btn-outline '
        },
        {
          extend: 'colvis',
          className: 'btn dark btn-outline',
          text: 'Columns'
        }
      ],
      dom: "<'row'<'col-sm-6 text-left'B><'col-sm-6 text-right'f>>\n\t\t\t<'row'<'col-sm-12'tr>>\n\t\t\t<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 dataTables_pager'lp>>", // horizobtal scrollable datatable
      "lengthMenu": [
        [25, 50, 100, -1],
        [25, 50, 100, "All"] // change per page values here
      ],

      'order': false,
      "columnDefs": [{
        "targets": [<?php if ($this->config->item('User_project_commission_payment') == 0) { ?>16<?php } ?>],
        className: "hidden"
      }, ],
      fixedColumns: true,
      fixedColumns: {
        leftColumns: 3
      }
    });
  };
  return {
    init: function() {
      t()
    }
  }
}

();
jQuery(document).ready(function() {
  $('body').on('click', '#btn_go', function() {
    $("#income_expense_report_div").show();
    Datatable.init();
    $(".hidden").hide();
  })
}

);
</script>
