<?php $this->view("includes/Inc_pagehead");?>
<!-- Page Styles Goes Here-->

<?php $this->view("includes/Inc_navigation");?>
<div class="m-grid__item m-grid__item--fluid m-wrapper">
  <!-- BEGIN: Subheader -->
  <div class="m-subheader ">
    <div class="d-flex align-items-center">
      <div class="mr-auto">
        <h3 class="m-subheader__title m-subheader__title--separator">
          Manage Vehicle Profiles
        </h3>
        <ul class="m-subheader__breadcrumbs m-nav m-nav--inline">
          <li class="m-nav__item m-nav__item--home">
            <a href="#" class="m-nav__link m-nav__link--icon">
              <i class="m-nav__link-icon la la-home"></i>
            </a>
          </li>
          <li class="m-nav__separator">
            -
          </li>
          <li class="m-nav__item">
            <a href="<?php echo base_url().'dashboard'?>" class="m-nav__link">
              <span class="m-nav__link-text">
                Home
              </span>
            </a>
          </li>
          <li class="m-nav__separator">
            -
          </li>
          <li class="m-nav__item">
            <a href="<?php echo base_url().'vehicles' ?>" class="m-nav__link">
              <span class="m-nav__link-text">
                Vehicles
              </span>
            </a>
          </li>
        </ul>
      </div>
      <div>

      </div>
    </div>
  </div>
  <!-- END: Subheader -->
  <div class="m-content">
    <?php if($this->config->item('app_module_vehicle_management')==1){ ?>
      <div class="m-portlet m-portlet--mobile m-portlet--focus m-portlet--head-solid-bg m-portlet--bordered m-portlet--rounded">
        <div class="m-portlet__head">
          <div class="m-portlet__head-caption">
            <div class="m-portlet__head-title">
              <h3 class="m-portlet__head-text">
                List of Owned Vehicles
              </h3>
            </div>
          </div>
          <div class="m-portlet__head-tools">
            <?php if($this->session->userdata('user_role')!='auditor' || $this->session->userdata('user_data_permission')['adding']==1) { ?>
              <a href="<?php echo base_url()?>vehicles/add"  style="margin-left:5px;margin-right:5px" class="btn btn-info m-btn m-btn--custom m-btn--icon m-btn--air m-btn--pill">
                <span>
                  <i class="la la-plus"></i>
                  <span>
                    Add New Vehicle (Own)
                  </span>
                </span>
              </a>
            <?php } ?>
          </div>
        </div>
        <div class="m-portlet__body">
          <!--begin: Datatable -->
          <table width="100%" class="table m-table nowrap table-header-fixed table-striped table-bordered table-hover table-header-fixed" id="vehicles_owned_view_table">
            <thead>
              <tr class="">
                <th>ID</th>
                <th>Sl No</th>
                <th>Vehicle Number</th>
                <th>Manufacturer</th>
                <th>Category</th>
                <th>Model</th>
                <th>Type</th>
                <th>Consignee</th>
                <th>Basic Charge</th>
                <th>Duration Type</th>
                <th>EMI Status</th>
                <th>EMI Amount</th>
                <th>EMI Date</th>
                <th>Next EMI Renewal</th>
                <th>TAX Date</th>
                <th>Insurance</th>
                <th>Permit</th>
                <th>CF Date</th>
                <th>Break Date</th>
                <th>Pollution Date</th>
                <th>GPS Date</th>
                <th>Speed Gvernor Date</th>
                <th>Welfare Date</th>
                <th>Load Cap (CFT)</th>
                <th>Load Cap (TON)</th>
                <th>Engine No</th>
                <th>Chasis No</th>
                <th>Dealer</th>
                <th>Date of Delivery</th>
                <th>Total Loan Amt</th>
                <th>Loan No</th>
                <th>Financier</th>
                <th>No of Installments</th>
                <th>Purchase Month</th>
                <th>Closing Month</th>
                <th>EMI Bank A/c</th>
                <th>Installments Left</th>
                <th>EMI Payable Amount<br/>(On Vehicle Creation)</th>
                <th>Vehicle Status</th>
                <th>OP Balance <br/>Payable</th>
                <th>Creation</th>
                <th>Actions</th>
              </tr>
            </thead>
            <tbody>
            </tbody>
          </table>
        </div>
      </div>
    <?php } ?>
    <div class="m-portlet m-portlet--mobile m-portlet--info m-portlet--head-solid-bg m-portlet--bordered m-portlet--rounded">
      <div class="m-portlet__head">
        <div class="m-portlet__head-caption">
          <div class="m-portlet__head-title">
            <h3 class="m-portlet__head-text">
              List of <?php if($this->config->item('app_module_vehicle_management')==1){ ?> Rent <?php } ?> Vehicles
            </h3>
          </div>
        </div>
        <div class="m-portlet__head-tools">
          <?php if($this->session->userdata('user_role')!='auditor' || $this->session->userdata('user_data_permission')['adding']==1) { ?>
            <?php if($this->config->item('app_module_vehicle_management')==1){ ?>
              <a href="#" style="margin-left:5px;margin-right:5px" data-toggle="modal" data-target="#vehicle_add_modal" class="btn btn-brand m-btn m-btn--custom m-btn--icon m-btn--air m-btn--pill">
                <span>
                  <i class="la la-plus"></i>
                  <span>
                    Add New Vehicle (Rent)
                  </span>
                </span>
              </a>
            <?php }else{ ?>
              <a href="#" data-toggle="modal" data-target="#vehicle_add_modal" class="btn btn-focus m-btn m-btn--custom m-btn--icon m-btn--air m-btn--pill">
                <span>
                  <i class="la la-plus"></i>
                  <span>
                    Add New Vehicle
                  </span>
                </span>
              </a>
            <?php } ?>
          <?php } ?>
        </div>
      </div>
      <div class="m-portlet__body">
        <!--begin: Datatable -->
        <?php $this->view("modules/include_tables/table_vehicles");?>

      </div>
    </div>

    <!--end: Datatable -->

    <div class="modal fade" tabindex="-1" id="vehicles_edit_modal" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
      <div class="modal-dialog " role="document" style="max-width: 800px">
        <div class="modal-content">
          <div class="modal-header" style="background-color: #00c5dc;border-radius: 4px">
            <h5 class="modal-title" id="exampleModalLabel" style="color: #ffffff" >
              Edit Vehicle Details
            </h5>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
              <span aria-hidden="true">
                &times;
              </span>
            </button>
          </div>
          <form autocomplete="off" data-form-type="vehicle_update" id="form_vehicle_edit" data-modal-id="vehicles_edit_modal" method="post" action="<?php echo base_url().'vehicles/update'?>" enctype="multipart/form-data" class="m-form m-form--fit m-form--state m-form--label-align-right " >
            <div class="modal-body">
              <div class="m-form__content">
                <div class="m-alert m-alert--icon alert alert-warning m--hide" role="alert" id="form_vehicle_edit_msg">
                  <div class="m-alert__icon">
                    <i class="la la-warning"></i>
                  </div>
                  <div class="m-alert__text">
                    Oh snap! Change a few things up and try submitting again.
                  </div>
                  <div class="m-alert__close">
                    <button type="button" class="close" data-close="alert" aria-label="Close"></button>
                  </div>
                </div>
              </div>
              <div class="row">
                <div class="col-lg-6">
                  <div class="form-group m-form__group">
                    <label for="user_name">
                      Vehicle Name
                    </label>
                    <div class="input-group m-input-group m-input-group--pill m-input-group--air">
                      <div class="input-group-prepend">
                        <span class="input-group-text" id="basic-addon1">
                          <i class="fa fa-truck"></i>
                        </span>
                      </div>
                      <input required style="text-transform: uppercase;" type="text" id="vehicle_name_edit" name="vehicle_name"  class="form-control form_vehicle_edit_fields m-input" placeholder="Vehicle Name" aria-describedby="basic-addon1">
                    </div>
                    <span class="m-form__help"></span>
                  </div>
                </div>
                <div class="col-lg-6">
                  <div class="form-group m-form__group">
                    <label for="user_name">
                      Vehicle Number
                    </label>
                    <div class="input-group m-input-group m-input-group--pill m-input-group--air">
                      <div class="input-group-prepend">
                        <span class="input-group-text" id="basic-addon1">
                          <i class="fa fa-address-card"></i>
                        </span>
                      </div>
                      <input required style="text-transform: uppercase;" type="text" id="vehicle_no_edit" name="vehicle_number"  class="form_vehicle_edit_fields form-control m-input" placeholder="Vehicle Number" aria-describedby="basic-addon1">
                    </div>
                    <span class="m-form__help"></span>
                  </div>
                </div>
              </div>
              <div class="row">
                <div class="col-lg-6">
                  <div class="form-group m-form__group">
                    <label for="user_name">
                      Consignee Name
                    </label>
                    <div class="input-group m-input-group m-input-group--pill">
                      <div class="input-group-prepend">
                        <a href="#consignee_add_modal"   data-toggle="modal" data-target="#consignee_add_modal" class="btn btn-focus">
                          <i class="fa fa-plus-circle"></i>
                        </a>
                      </div>
                      <select style="width: 80%"  class="form-control m-select2 m-select2-general form_vehicle_edit_select" required id="consignee_edit" name="consignee">

                      </select>
                    </div>
                    <span class="m-form__help"></span>
                  </div>
                </div>
                <div class="col-lg-6">
                  <div class="form-group m-form__group m-select2--pill">
                    <label for="user_name">
                      Vehicle Type
                    </label>
                    <div class="m-select2 m-select2--air m-select2--pill">
                      <select style="width: 100%" class="form-control m-select2 m-select2-general" required id="vehicle_type_edit" name="vehicle_type_edit" data-placeholder="Select Vehicle Type">
                        <option disabled="" selected="">Select the Vehicle type</option>
                        <option value="rent">Rent/Hired</option>
                        <?php if($this->config->item('app_module_vehicle_management')!=1){ ?>
                          <option value="own">Own</option>
                        <?php } ?>
                      </select>
                    </div>
                    <span class="m-form__help"></span>
                  </div>
                </div>
              </div>
              <div class="row">
                <div class="col-lg-6">
                  <div class="form-group m-form__group">
                    <label for="user_name">
                      Basic Charge
                    </label>
                    <div class="input-group m-input-group m-input-group--pill m-input-group--air">
                      <div class="input-group-prepend">
                        <span class="input-group-text" id="basic-addon1">
                          <i class="fa fa-users"></i>
                        </span>
                      </div>
                      <input required type="text" id="basic_charge_edit" name="basic_charge"  class="form_vehicle_edit_fields form-control m-input" placeholder="Basic Charge" aria-describedby="basic-addon1">
                    </div>
                    <span class="m-form__help"></span>
                  </div>
                </div>
                <div class="col-lg-6">
                  <div class="form-group m-form__group m-select2--pill">
                    <label for="user_name">
                      Work Duration Type
                    </label>
                    <div class="m-select2 m-select2--air m-select2--pill">
                      <select style="width: 100%" class="form-control m-select2 m-select2-general" required id="work_duration_type_edit" name="work_duration_type_edit" data-placeholder="Select Vehicle Type">
                        <option disabled="" selected="">Select the Duration type</option>
                        <option value="Hour">Hour</option>
                        <option value="Trip">Trip</option>
                        <option value="Kilometer">Kilometer</option>
                        <option value="Day">Day</option>
                        <option value="Month">Month</option>
                      </select>
                    </div>
                    <span class="m-form__help"></span>
                  </div>
                </div>
                <div class="col-xl-4">
                  <div class="form-group m-form__group">
                    <label>Loading Capacity (CFT):</label>
                    <input type="text"  name="loading_capacity_cft" id="loading_capacity_cft_edit" class="form-control m-input m-input--air m-input--pill" placeholder="Loading Capacity (CFT)" >
                    <span class="m-form__help"></span>
                  </div>
                </div>
                <div class="col-xl-4">
                  <div class="form-group m-form__group">
                    <label>Loading Capacity (TON):</label>
                    <input type="text"  name="loading_capacity_ton" id="loading_capacity_ton_edit" class="form-control m-input m-input--air m-input--pill" placeholder="Loading Capacity (TON)" >
                    <span class="m-form__help"></span>
                  </div>
                </div>
                <div class="col-xl-4">
                  <div class="form-group m-form__group">
                    <label>Opening Balance Payable:</label>
                    <input type="text" required name="op_balance" id="op_balance_edit" class="form-control m-input m-input--air m-input--pill" placeholder="OP Balance" >
                    <span class="m-form__help">Outstanding Balance At the time of Creation</span>
                  </div>
                </div>
              </div>
              <input type="hidden" name="vehicle_id" id="vehicle_id_edit">
            </div>
            <div class="modal-footer">
              <button type="button" class="btn btn-secondary" data-dismiss="modal">
                Close
              </button>
              <button type="submit" class="btn btn-primary form_submit_btn">
                Submit
              </button>
            </div>
          </form>


        </div>
      </div>
    </div>
    <div class="modal fade" tabindex="-1" id="vehicles_delete_modal" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
      <div class="modal-dialog " role="document" >
        <form id="form_employee_delete" data-modal-id="vehicles_delete_modal" autocomplete="off" method="post" action="<?php echo base_url().'vehicles/delete'?>" class="form-horizontal">
          <div class="modal-content">
            <div class="alert alert-danger" role="alert" style="margin-bottom: 0px">
              <button type="button" class="close" data-dismiss="modal"></button>
              <br/>
              <h4 class="alert-heading">Warning! Please Confirm Your Action</h4>
              <br/>
              <p> Are You Sure to Delete this Data ?. All the Associated Data will Lost. </p>
              <p>
                <button class="btn btn-danger form_submit_btn" type="submit" name="submit">Confirm & Delete</button>
                <button type="button" class="btn btn-primary modal-dismiss" data-dismiss="modal">Cancel</button>
              </p>
              <input type="hidden" name="vehicle_id" id="vehicle_id_delete">
            </div>
          </div>
        </form>
      </div>
    </div>

  </div>
</div>
</div>
<!-- end:: Body -->
<!-- begin::Footer -->

<?php $this->view("includes/Inc_footer");?>
<?php $this->view("modules/include_modals/modal_vehicle_add");?>
<?php $this->view("modules/include_modals/modal_vehicle_consignee_add");?>

<!-- end::Footer -->
</div>
<!-- end:: Page -->

<?php $this->view("includes/Inc_sidebar");?>
<?php $this->view("includes/Inc_scripts");?>
<?php $this->view("modules/include_scripts/vehicles_scripts");?>

<script type="text/javascript">
$("#vehicle_type_edit").select2({
  placeholder: "Select vehicle type",
  dropdownParent: $("#form_vehicle_edit")
})
$("#work_duration_type_edit").select2({
  placeholder: "Select vehicle type",
  dropdownParent: $("#form_vehicle_edit")
})
$("#consignee_edit").select2({
  placeholder: "Select Consignee",
  dropdownParent: $("#form_vehicle_edit")
})
</script>

<!--begin::Page Snippets -->
<script>
$("#vehicle_menu").addClass('m-menu__item--active m-menu__item--open');
$("#vehicle_menu_1").addClass('m-menu__item--active');

$('body').on('click', '#btn_qr_code', function() {
  var no = $(this).closest('tr').children('td');
  var vehicle_id = no.eq(0).text();
  window.open('<?php echo base_url().'vehicles/print_qrcode/'?>'+vehicle_id,'newwindow','width=1200,height=700'); return false
})
$('body').on('click', '#vehicles_edit_btn', function() {
  var no = $(this).closest('tr').children('td');
  $('#vehicle_id_edit').val(no.eq(0).text());
  // $('#salary_slip_month_edit').datepicker("setDate", no.eq(25).text());
  $('#vehicle_name_edit').val(no.eq(2).text());
  $('#vehicle_no_edit').val(no.eq(3).text());
  $('#consignee_name_edit').val(no.eq(4).text());
  $('#basic_charge_edit').val(no.eq(8).text());
  $('#consignee_name_edit').val(no.eq(4).text());
  $('#vehicle_type_edit').val(no.eq(6).text()).trigger('change');
  $('#work_duration_type_edit').val(no.eq(9).text()).trigger('change');
  $('#loading_capacity_cft_edit').val(no.eq(10).text());
  $('#loading_capacity_ton_edit').val(no.eq(11).text());
  $('#op_balance_edit').val(no.eq(12).text());
  select_consignee('consignee_edit',no.eq(15).text());
})
$('body').on('click', '#vehicles_delete_btn', function() {
  var no = $(this).closest('tr').children('td');
  $('#vehicle_id_delete').val(no.eq(0).text());
})


  <?php if($this->config->item('app_module_vehicle_management')==1){ ?>
    var table_2 = $('#vehicles_owned_view_table').DataTable({
      "ajax":{
        url :"<?php echo base_url().'vehicles/select_vehicle_owned' ?>", // json datasource
        type: "post", // type of method  , by default would be get
        data: function(d){
          d.vehicle_type = 'own';
        }
      },
      "bProcessing": true,
      "deferRender": true,
      "bDeferRender": true,
      "scrollX" : true,
      buttons: [
        { extend: 'print', className: 'btn dark btn-outline',exportOptions: {columns: ':visible'},title: 'List of Owned Vehicles' },
        { extend: 'csv', className: 'btn purple btn-outline ' },
        { extend: 'colvis', className: 'btn dark btn-outline', text: 'Columns'}
      ],
      dom:"<'row'<'col-sm-6 text-left'B><'col-sm-6 text-right'f>>\n\t\t\t<'row'<'col-sm-12'tr>>\n\t\t\t<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 dataTables_pager'lp>>", // horizobtal scrollable datatable
      "lengthMenu": [
        [25, 50, 100, -1],
        [25, 50, 100, "All"] // change per page values here
      ],
      // set the initial value
      "pageLength": 25,
      "columnDefs": [
        {
          "targets": [ 0],
          className: "hidden"
        }
      ],
      fixedColumns:   true,
      fixedColumns:   {
        leftColumns: 4
      },
      'order': [[0, 'desc']]
    });
    <?php } ?>
    $(".hide_column").hide();

    $(".form_submit_btn").click(function (e) {
      e.preventDefault();
      var a = $(this),
      l = $(this).closest("form"),
      action = l.attr('action');
      var form_id = l.attr('id');
      l.validate({
        rules: {
          op_balance: {
            number: !0
          },
          basic_wage: {
            number: !0
          },
          contact_no: {
            number: !0
          }
        }, invalidHandler: function (e, r) {
          var i = $("#" + form_id + "_msg");
          i.removeClass("m--hide").show(), mUtil.scrollTo(i, -200)
        }, submitHandler: function (e) {
        }
      }), l.valid() && (a.addClass("m-loader m-loader--right m-loader--light").attr("disabled", !0),
      l.ajaxSubmit({
        url: action,
        success: function (e, t, r, s) {
          var modal_id = l.attr('data-modal-id');
          var form_type = l.attr('data-form-type');
          $("#" + form_id + "_msg").addClass("m--hide");
          // Block UI
          mApp.blockPage({
            overlayColor: "#000000",
            type: "loader",
            state: "success",
            message: "Please wait..."
          }), setTimeout(function () {
            mApp.unblockPage()
          }, 2e3);
          var obj = $.parseJSON(e);
          if (obj.status == 1) {
            a.removeClass("m-loader m-loader--right m-loader--light").attr("disabled", !1);
            $("#"+modal_id).modal('toggle');
            $("."+form_id+"_fields").val('');
            $("."+form_id+"_select").val('').trigger("change");
            toastr[obj.flashdata_type](obj.flashdata_msg, obj.flashdata_title);
            vehicles_view_table.ajax.reload();
            <?php if($this->config->item('app_module_vehicle_management')==1){ ?>
            table_2.ajax.reload();
              <?php } ?>
            $('input[name=basic_wage_type]').prop('checked', false);
            select_consignee('consignee_add');
            select_consignee('consignee_edit');
          } else {
            a.removeClass("m-loader m-loader--right m-loader--light").attr("disabled", !1);
            toastr[obj.flashdata_type](obj.flashdata_msg, obj.flashdata_title);
          }
          if (obj == null) {
            setTimeout(function () {
              a.removeClass("m-loader m-loader--right m-loader--light").attr("disabled", !1);
              toastr["warning"]("Your Attempt is Timed Out. Please Try Again.", "Timed Out");
            }, 2e4)
          }
        },error: function() {
          a.removeClass("m-loader m-loader--right m-loader--light").attr("disabled", !1);
          toastr["error"]("Sorry. There Has Been Some Error Occurred. Please Try Again.", "Error");
        }
      })
    )
  });
</script>
