<?php $this->view("includes/Inc_pagehead");?>
<!-- Page Styles Goes Here-->

<?php $this->view("includes/Inc_navigation");?>
<div class="m-grid__item m-grid__item--fluid m-wrapper">
  <!-- BEGIN: Subheader -->
  <div class="m-subheader ">
    <div class="d-flex align-items-center">
      <div class="mr-auto">
        <h3 class="m-subheader__title m-subheader__title--separator">
          Vehicle Material Consumption
        </h3>
        <ul class="m-subheader__breadcrumbs m-nav m-nav--inline">
          <li class="m-nav__item m-nav__item--home">
            <a href="#" class="m-nav__link m-nav__link--icon">
              <i class="m-nav__link-icon la la-home"></i>
            </a>
          </li>
          <li class="m-nav__separator">
            -
          </li>
          <li class="m-nav__item">
            <a href="<?php echo base_url().'dashboard'?>" class="m-nav__link">
              <span class="m-nav__link-text">
                Home
              </span>
            </a>
          </li>
          <li class="m-nav__separator">
            -
          </li>
          <li class="m-nav__item">
            <a href="<?php echo base_url().'vehicles/material_consumption' ?>" class="m-nav__link">
              <span class="m-nav__link-text">
                Vehicle Material Consumption
              </span>
            </a>
          </li>
        </ul>
      </div>
      <div>

      </div>
    </div>
  </div>
  <!-- END: Subheader -->
  <div class="m-content">
    <div class="m-portlet m-portlet--mobile m-portlet--info m-portlet--head-solid-bg m-portlet--bordered m-portlet--rounded">
      <div class="m-portlet__head">
        <div class="m-portlet__head-caption">
          <div class="m-portlet__head-title">
            <h3 class="m-portlet__head-text">
              Vehicle Material
            </h3>
          </div>
        </div>
        <div class="m-portlet__head-tools">
          <?php if($this->session->userdata('user_role')!='auditor' || $this->session->userdata('user_data_permission')['adding']==1) { ?>
            <a href="#" data-toggle="modal" data-target="#consumption_add_modal" class="btn btn-focus m-btn m-btn--custom m-btn--icon m-btn--air m-btn--pill">
              <span>
                <i class="la la-plus"></i>
                <span>
                  Add Material Consumption
                </span>
              </span>
            </a>
          <?php } ?>
        </div>
      </div>
      <div class="m-portlet__body">
        <div class="m-form m-form--label-align-right m--margin-bottom-10">
          <div class="row">
            <div class="col-xl-12 order-2 order-xl-1">
              <div class="form-group m-form__group row ">
                <div class="col-md-3">
                  <div class="form-group m-form__group">
                    <label> Date:</label>
                    <input  id="table_filter_date_range"   type="text" class="form-control m-input m-input--air m-input--pill"  >
                  </div>
                </div>
                <div class="col-md-3">
                  <div class="form-group m-form__group">
                    <label>
                      Vehicle:
                    </label>
                    <div class="m-select2 m-select2--air m-select2--pill">
                      <select style="width: 100%" class="form-control m-select2 table_filter" id="table_filter_vehicle" >
                        <option value="all">All Vehicles</option>
                        <?php
                        foreach($owned_vehicles as $row): ?>
                        <option value="<?php echo $row->id?>"><?php echo $row->consignee_name." [ ".$row->vehicle_name ." : ".$row->vehicle_no." ]"?></option>
                        <?php
                      endforeach;
                      ?>
                    </select>
                  </div>
                  <span class="m-form__help"></span>
                </div>
              </div>
              <div class="col-md-3">
                <div class="form-group m-form__group">
                  <label>
                    Material Category
                  </label>
                  <div class="m-select2 m-select2--air m-select2--pill">
                    <select style="width: 100%" class="form-control m-select2 table_filter" id="table_filter_material_category"  name="material_category" >
                      <option value="all">All Categories</option>
                      <?php
                      foreach($material_categories as $row): ?>
                      <option value="<?php echo $row->cat_id?>"><?php echo $row->cat_name;?></option>
                      <?php
                    endforeach;
                    ?>
                  </select>
                </div>
                <span class="m-form__help"></span>
              </div>
            </div>
            <div class="col-md-3">
              <div class="form-group m-form__group">
                <label>
                  Material:
                </label>
                <div class="m-select2 m-select2--air m-select2--pill">
                  <select style="width: 100%" class="form-control m-select2 table_filter" id="table_filter_material"  name="table_filter_material" >
                    <option value="all">All Materials</option>

                  </select>
                </div>
                <span class="m-form__help"></span>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>

    <?php $this->view("modules/include_tables/table_vehicle_material_consumptions");?>

    <div class="modal fade" tabindex="-1" id="consumption_add_modal" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
      <div class="modal-dialog " role="document" style="max-width: 75%">
        <div class="modal-content">
          <div class="modal-header" style="background-color: #36a3f7;border-radius: 4px">
            <h5 class="modal-title" id="exampleModalLabel" style="color: #ffffff" >
              Add Vehicle Material Consumption
            </h5>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
              <span aria-hidden="true">
                &times;
              </span>
            </button>
          </div>
          <form data-form-type='consumption' class="m-form m-form--fit m-form--state m-form--label-align-right "  data-modal-id="consumption_add_modal" autocomplete="off" id="form_consumption_add" method="post" action="<?php echo base_url().'stock/create_consumption/vehicle'?>" enctype="multipart/form-data" class="m-form m-form--fit m-form--state m-form--label-align-right " >
            <div class="modal-body">
              <div class="m-form__content">
                <div class="m-alert m-alert--icon alert alert-warning m--hide" role="alert" id="form_consumption_add_msg">
                  <div class="m-alert__icon">
                    <i class="la la-warning"></i>
                  </div>
                  <div class="m-alert__text">
                    Oh snap! Change a few things up and try submitting again.
                  </div>
                  <div class="m-alert__close">
                    <button type="button" class="close" data-close="alert" aria-label="Close"></button>
                  </div>
                </div>
              </div>
              <div class="row">
                <div class="col-lg-4">
                  <div class="form-group m-form__group">
                    <label for="user_name">
                      Stock Location
                    </label>
                    <div class="m-select2 m-select2--air m-select2--pill">
                      <select required style="width: 100%" class="form-control m-select2 m-select2--solid m-input--solid m-input " id="consumption_location_add" name="location" data-placeholder="Select Location">
                        <option selected disabled>Select Location</option>
                        <?php
                        foreach($stock_locations_warehouse as $row): ?>
                        <option  value="<?php echo $row->location_id?>"><?php echo $row->location_name?></option>
                        <?php
                      endforeach;
                      ?>
                    </select>
                  </div>
                  <span class="m-form__help"></span>
                </div>
              </div>
              <div class="col-lg-4">
                <div class="form-group m-form__group">
                  <label  for="user_name">
                    Consumed Date
                  </label>
                  <div class="input-group m-input-group--air m-input-group--pill date">
                    <input required data-date-format="dd-mm-yyyy" autocomplete="off" id="consumed_date" name="date"  type="text" class="form-control  m-input " placeholder="Consumed Date" >
                  </div>
                  <span class="m-form__help"></span>
                </div>
              </div>
              <div class="col-lg-4">
                <div class="form-group m-form__group">
                  <label  for="user_name"> Vehicle
                  </label>
                  <div class="m-select2 m-select2--air m-select2--pill">
                    <select required style="width: 100%" class="form-control m-select2" id="vehicle_consumption_add" name="vehicle_id" >
                      <option selected disabled>Select Vehicles</option>
                      <?php
                      foreach($owned_vehicles as $row): ?>
                      <option value="<?php echo $row->id?>"><?php echo $row->consignee_name." [ ".$row->vehicle_name ." : ".$row->vehicle_no." ]"?></option>
                      <?php
                    endforeach;
                    ?>
                  </select>
                </div>
                <span class="m-form__help"></span>
              </div>
            </div>
            <input type="hidden" name="redirect_url" value="<?php echo base_url(uri_string())?>" >
            <input type="hidden" name="count" value="0" id="stock_transfer_count" >
          </div>
          <div class="row">
            <div class="col-lg-12" id="stock_view_div" style="display:none;margin-top: 20px;">
              <table width="100%" class="table m-table   table-header-fixed table-striped- table-bordered table-striped table-hover table-header-fixed" id="stock_list_table">
                <caption id="stock_list_table_caption" style="caption-side: top;text-align: center;font-weight: 700;"></caption>
                <thead>
                  <tr class="">
                    <th rowspan="2">Sl No</th>
                    <th rowspan="2">Stock ID</th>
                    <th rowspan="2">Material ID</th>
                    <th rowspan="2">Unit ID</th>
                    <th rowspan="2">Location ID</th>
                    <th rowspan="2">Material Name</th>
                    <th rowspan="2">Unit</th>
                    <th rowspan="2">Unit Price</th>
                    <th rowspan="2">Supplier</th>
                    <th colspan="2">Currently Available Stock</th>
                    <th rowspan="2">Location</th>
                    <th rowspan="2">Location Type</th>
                    <th colspan="2" style="display: none">Total Purchased Stock</th>
                    <th colspan="2" style="display: none">Total Transferred In Stock</th>
                    <th colspan="2" style="display: none">Total Transferred Out Stock</th>
                    <th colspan="2" style="display: none">Total Consumed Stock</th>
                    <th rowspan="2">Supplier ID</th>
                    <th rowspan="2">Consumed Qty</th>
                  </tr>
                  <tr>
                    <th><span class="hidden">Currently Available Stock</span> Qty</th>
                    <th>Amount</th>
                    <th><span class="hidden">Total Purchased Stock</span> Qty</th>
                    <th>Amount</th>
                    <th><span class="hidden">Total Transferred In Stock</span>Qty</th>
                    <th>Amount</th>
                    <th><span class="hidden">Total Transferred Out Stock</span>Qty</th>
                    <th>Amount</th>
                    <th><span class="hidden">Total Consumed Stock</span>Qty</th>
                    <th>Amount</th>
                  </tr>
                </thead>
                <tbody>
                </tbody>
              </table>
            </div>
          </div>
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-secondary " data-dismiss="modal">
            Close
          </button>
          <button type="submit" class="btn btn-primary form_submit_btn">
            Save & Submit
          </button>
        </div>
      </form>
    </div>
  </div>
</div>
<div class="modal fade" tabindex="-1" id="consumption_delete_modal" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog " role="document" >
    <form autocomplete="off" id="form_consumpton_delete" data-modal-id="consumption_delete_modal"  method="post" action="<?php echo base_url().'stock/delete_consumption'?>" class="form-horizontal">
      <div class="modal-content">
        <div class="alert alert-danger" role="alert" style="margin-bottom: 0px">
          <button type="button" class="close" data-dismiss="modal"></button>
          <br/>
          <h4 class="alert-heading">Warning! Please Confirm Your Action</h4>
          <br/>
          <p> Are You Sure to Delete this Data ?. All the Associated Data will Lost. </p>
          <p>
            <button class="btn btn-danger form_submit_btn" type="submit" name="submit">Confirm & Delete</button>
            <button type="button" class="btn btn-primary modal-dismiss" data-dismiss="modal">Cancel</button>
          </p>
          <input type="hidden"  name="cons_ids" id="consumption_delete_ids">
          <input type="hidden"  value="0" class="numeric_fields">
          <input type="hidden" name="redirect_url" value="<?php echo base_url(uri_string())?>" >
        </div>
      </div>
    </form>
  </div>
</div>

</div>
</div>
</div>


</div>
</div>
<!-- end:: Body -->
<!-- begin::Footer -->

<?php $this->view("includes/Inc_footer");?>
<!-- end::Footer -->
</div>
<!-- end:: Page -->

<?php $this->view("includes/Inc_sidebar");?>
<?php $this->view("includes/Inc_scripts");?>
<script type="text/javascript">

$('body').on('change keyup', '.consumed_qty', function() {
  var count = 0;
  $(".consumed_qty").each(function() {
    if(parseFloat($(this).val())>0){
      count++;
    }
    $("#stock_transfer_count").val(count);
  });
});


var stock_list_table=function(location_id='',work_name='') {
  $('#stock_list_table_caption').text("List of Materials Available in "+work_name);
  $('#stock_list_table').dataTable().fnDestroy();
  function GetSearchLocation(){
    return $('#location_from').val();
  }
  function GetSearchMaterial(){
    return $('#material_filter').val();
  }
  var loc_name = $("#location_from option:selected").text();
  $("#stock_list_div_title").text('List of Available Stock in '+loc_name);

  var table = $('#stock_list_table').DataTable({
    "ajax":{
      url :"<?php echo base_url().'stock/select_stock_register_2/consumption' ?>", // json datasource
      type: "post", // type of method  , by default would be get
      data: function(d){
        d.location_id = GetSearchLocation();
        d.material_id = GetSearchMaterial();
        d.quantity = 'available';
        d.location_id = location_id;
        d.material_type = 'vehicle';
      }
    },
    "bProcessing": true,
    "deferRender": true,
    "bDeferRender": true,
    buttons: [
      { extend: 'print', className: 'btn dark btn-outline',exportOptions: {columns: ':visible'},title: 'Stock consumptions' },
      { extend: 'csv', className: 'btn purple btn-outline ' },
      { extend: 'colvis', className: 'btn dark btn-outline', text: 'Columns'}
    ],
    dom:"<'row'<'col-sm-6 text-left'B><'col-sm-6 text-right'f>>\n\t\t\t<'row'<'col-sm-12'tr>>\n\t\t\t<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 dataTables_pager'lp>>", // horizobtal scrollable datatable
    "lengthMenu": [
      [25, 50, 100, -1],
      [25, 50, 100, "All"] // change per page values here
    ],
    "columnDefs": [
      {
        "targets": [ 1,2,3,4,11,12,13,14,15,16,17,18,19,20,21 ],
        className: "hidden"
      }
    ],
    'paging': false,
    'order': false,
  });
  $(".hide_column").hide();
  $(".hidden").hide();
  $('<div class="form-group m-form__group row" >'+
  '<div class="col-lg-6"><div class="m-select2 m-select2--air m-select2--pill">'+
  '<select style="width: 100%" class="form-control m-select2 table_filter" id="material_filter"  name="material_filter" >'+
  '<option value="all">All Materials</option>'+
  <?php
  foreach($materials as $row): ?>
  '<option value="<?php echo $row->material_id?>"><?php echo $row->material_name.' [ in '.$row->unit_name.']';?></option>'+
  <?php
endforeach;
?>
'</select></div></div></div>').appendTo("#stock_list_table_wrapper .material_filter");
$("#material_filter").select2({
  // dropdownParent: $("#form_purchase_add"),
  placeholder: "Select Material"
})
$(".table_filter").on("change", function() {
  table.ajax.reload();
});
}

$('body').on('change', '#consumption_location_add', function() {
  var location_id = $(this).val();
  if(location_id!='' && location_id!=null && location_id!='Select Location'){
    var location_name = $('#consumption_location_add option:selected').text();
    stock_list_table(location_id,location_name);
    $("#stock_view_div").show();
  }
})

$("#consumption_location_add").select2({
  placeholder: "Select  Location",
  dropdownParent: $("#form_consumption_add")
})
$("#vehicle_consumption_add").select2({
  placeholder: "Select  Vehicle",
  dropdownParent: $("#form_consumption_add")
})

</script>




<script>

<?php if($page_name!='work_profile'){?>
  $(".form_submit_btn").click(function (e) {
    e.preventDefault();
    var a = $(this),
    l = $(this).closest("form"),
    action = l.attr('action');
    var form_id = l.attr('id');

    l.validate({
      rules: {
        quantity: {
          number: !0
        }
      }, invalidHandler: function (e, r) {
        var i = $("#" + form_id + "_msg");
        i.removeClass("m--hide").show(), mUtil.scrollTo(i, -200)
      }, submitHandler: function (e) {
      }
    }),
    $(".numeric_fields").each(function () {
      // $(this).rules('add', {
      //   number: !0
      // });
    }), l.valid() && (a.addClass("m-loader m-loader--right m-loader--light").attr("disabled", !0),
    l.ajaxSubmit({
      url: action,
      success: function (e, t, r, s) {
        var modal_id = l.attr('data-modal-id');
        var form_type = l.attr('data-form-type');
        $("#" + form_id + "_msg").addClass("m--hide");
        // Block UI
        mApp.blockPage({
          overlayColor: "#000000",
          type: "loader",
          state: "success",
          message: "Please wait..."
        }), setTimeout(function () {
          mApp.unblockPage()
        }, 2e3);
        var obj = $.parseJSON(e);
        if (obj.status == 1) {
          a.removeClass("m-loader m-loader--right m-loader--light").attr("disabled", !1);
          $("#"+modal_id).modal('toggle');
          $("."+form_id+"_fields").val('');
          $("."+form_id+"_select").val('').trigger("change");
          toastr[obj.flashdata_type](obj.flashdata_msg, obj.flashdata_title);
          swal({
            width: 500,
            title: obj.flashdata_title,
            text: obj.flashdata_msg,
            type: obj.flashdata_type,
            // showCancelButton: !0,
            confirmButtonText: "Ok",
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            reverseButtons: !0,
            closeOnClickOutside: false,
            allowOutsideClick: false
          }).then(function(e) {
            stock_consumption_view_table.ajax.reload();
          })
        } else {
          a.removeClass("m-loader m-loader--right m-loader--light").attr("disabled", !1);
          toastr[obj.flashdata_type](obj.flashdata_msg, obj.flashdata_title);
        }
        if (obj == null) {
          setTimeout(function () {
            a.removeClass("m-loader m-loader--right m-loader--light").attr("disabled", !1);
            toastr["warning"]("Your Attempt is Timed Out. Please Try Again.", "Timed Out");
          }, 2e4)
        }
      },error: function() {
        a.removeClass("m-loader m-loader--right m-loader--light").attr("disabled", !1);
        toastr["error"]("Sorry. There Has Been Some Error Occurred. Please Try Again.", "Error");
      }
    })
  )
});
<?php } ?>
$("#consumed_date").datepicker( {
  todayHighlight:!0, orientation:"bottom left", templates: {
    leftArrow: '<i class="la la-angle-left"></i>', rightArrow: '<i class="la la-angle-right"></i>'
  },
  endDate: '+0d',
  <?php if($this->session->userdata('user_role')!='admin' && $this->config->item('User_calendar_date_restriction_enabled')==1){ ?>
    startDate: '<?php echo $this->config->item('User_calendar_date_restriction_start_days');?>d'
    <?php } ?>
  })

  </script>


  <!--begin::Page Snippets -->
  <script>

  </script>
  <script>
  $("#vehicle_menu").addClass('m-menu__item--active m-menu__item--open');
  $("#vehicle_menu_10").addClass('m-menu__item--active');

</script>
<?php $this->view("modules/include_scripts/vehicle_material_consumption_view_scripts");?>
