<?php $this->view("includes/Inc_pagehead");?>
<!-- Page Styles Goes Here-->

<?php $this->view("includes/Inc_navigation");?>
<div class="m-grid__item m-grid__item--fluid m-wrapper">
  <!-- BEGIN: Subheader -->
  <div class="m-subheader">
    <div class="d-flex align-items-center">
      <div class="mr-auto">
        <h3 class="m-subheader__title m-subheader__title--separator">
          Vehicle Expenses
        </h3>
        <ul class="m-subheader__breadcrumbs m-nav m-nav--inline">
          <li class="m-nav__item m-nav__item--home">
            <a href="#" class="m-nav__link m-nav__link--icon">
              <i class="m-nav__link-icon la la-home"></i>
            </a>
          </li>
          <li class="m-nav__separator">
            -
          </li>
          <li class="m-nav__item">
            <a href="<?php echo base_url().'dashboard'?>" class="m-nav__link">
              <span class="m-nav__link-text">
                Home
              </span>
            </a>
          </li>
          <li class="m-nav__separator">
            -
          </li>
          <li class="m-nav__item">
            <a href="<?php echo base_url().'vehicles/expenses' ?>" class="m-nav__link">
              <span class="m-nav__link-text">
                Vehicle Expenses
              </span>
            </a>
          </li>
        </ul>
      </div>
      <div>

      </div>
    </div>
  </div>
  <!-- END: Subheader -->
  <div class="m-content">
    <div class="m-portlet m-portlet--mobile m-portlet--info m-portlet--head-solid-bg m-portlet--bordered m-portlet--rounded">
      <div class="m-portlet__head">
        <div class="m-portlet__head-caption">
          <div class="m-portlet__head-title">
            <h3 class="m-portlet__head-text">
              List of Vehicle Expenses
            </h3>
          </div>
        </div>
        <div class="m-portlet__head-tools">
          <?php if($this->session->userdata('user_role')!='auditor' || $this->session->userdata('user_data_permission')['adding']==1) { ?>
            <a href="#" data-toggle="modal" data-target="#vehicle_expense_add_modal" class="btn btn-focus m-btn m-btn--custom m-btn--icon m-btn--air m-btn--pill">
              <span>
                <i class="la la-plus"></i>
                <span>
                  Add New Expense
                </span>
              </span>
            </a>
          <?php } ?>
        </div>
      </div>
      <div class="m-portlet__body">
        <div class="m-form m-form--label-align-right m--margin-bottom-10">
          <div class="">
            <div class="col-xl-12 " >
              <div class="form-group m-form__group row ">
                <div class="col-md-4">
                  <div class="form-group m-form__group">
                    <label >
                      Date:
                    </label>
                    <input  id="table_filter_date_range"   type="text" class="form-control m-input m-input--air m-input--pill"  >
                  </div>
                </div>
                <div class="col-md-4">
                  <div class="form-group m-form__group">
                    <label>
                      Expense Head:
                    </label>
                    <div class="m-select2 m-select2--air m-select2--pill">
                      <select style="width: 100%" class="form-control m-select2 table_filter" id="table_filter_expense_head"  name="expense" data-placeholder="Select Expenses">

                      </select>
                    </div>
                    <span class="m-form__help"></span>
                  </div>
                </div>
                <div class="col-md-4">
                  <div class="form-group m-form__group">
                    <label>
                      Vehicle:
                    </label>
                    <div class="m-select2 m-select2--air m-select2--pill">
                      <select style="width: 100%" class="form-control m-select2 table_filter" id="table_filter_vehicle"  >
                        <option value="all">All Vehicles</option>
                        <?php
                        foreach($owned_vehicles as $row): ?>
                        <option value="<?php echo $row->id?>"><?php echo $row->consignee_name." [ ".$row->vehicle_name ." : ".$row->vehicle_no." ]"?></option>
                        <?php
                      endforeach;
                      ?>
                    </select>
                  </div>
                  <span class="m-form__help"></span>
                </div>
                </div>

              </div>
            </div>
          </div>
        </div>
        <!--begin: Datatable -->
        <?php $this->view("modules/include_tables/table_vehicle_expenses");?>
        <!--end: Datatable -->
      </div>
    </div>
  </div>
  <?php $this->view("modules/include_modals/modal_bills");?>
  <?php $this->view("modules/include_modals/modal_expense_head_add");?>
  <?php $this->view("modules/include_modals/modal_transaction_delete");?>
</div>
</div>
<!-- end:: Body -->
<!-- begin::Footer -->
<?php $this->view("includes/Inc_footer");?>
<!-- end::Footer -->
</div>
<!-- end:: Page -->

<?php $this->view("includes/Inc_sidebar");?>
<?php $this->view("includes/Inc_scripts");?>

<!--begin::Page Snippets -->
<script>
$("#vehicle_menu").addClass('m-menu__item--active m-menu__item--open');
$("#vehicle_menu_5").addClass('m-menu__item--active');
</script>
<?php $this->view("modules/include_scripts/bill_scripts");?>
<?php $this->view("modules/include_scripts/transaction_scripts");?>
<?php $this->view("modules/include_scripts/vehicle_expense_scripts");?>
