<?php $this->view("includes/Inc_pagehead");?>
<!-- Page Styles Goes Here-->

<?php $this->view("includes/Inc_navigation");?>
<div class="m-grid__item m-grid__item--fluid m-wrapper">
  <!-- BEGIN: Subheader -->
  <div class="m-subheader ">
    <div class="d-flex align-items-center">
      <div class="mr-auto">
        <h3 class="m-subheader__title m-subheader__title--separator">
          Manage Vehicle Drivers
        </h3>
        <ul class="m-subheader__breadcrumbs m-nav m-nav--inline">
          <li class="m-nav__item m-nav__item--home">
            <a href="#" class="m-nav__link m-nav__link--icon">
              <i class="m-nav__link-icon la la-home"></i>
            </a>
          </li>
          <li class="m-nav__separator">
            -
          </li>
          <li class="m-nav__item">
            <a href="<?php echo base_url().'dashboard'?>" class="m-nav__link">
              <span class="m-nav__link-text">
                Home
              </span>
            </a>
          </li>
          <li class="m-nav__separator">
            -
          </li>
          <li class="m-nav__item">
            <a href="<?php echo base_url().'vehicles/drivers' ?>" class="m-nav__link">
              <span class="m-nav__link-text">
                Vehicle Drivers
              </span>
            </a>
          </li>


        </ul>
      </div>
      <div>

      </div>
    </div>
  </div>
  <!-- END: Subheader -->
  <div class="m-content">
    <div class="m-portlet m-portlet--mobile m-portlet--info m-portlet--head-solid-bg m-portlet--bordered m-portlet--rounded">
      <div class="m-portlet__head">
        <div class="m-portlet__head-caption">
          <div class="m-portlet__head-title">
            <h3 class="m-portlet__head-text">
              List of Vehicle Drivers
            </h3>
          </div>
        </div>
        <div class="m-portlet__head-tools">
          <?php if($this->session->userdata('user_role')!='auditor' || $this->session->userdata('user_data_permission')['adding']==1) { ?>
            <a href="#" style="margin-left:5px;margin-right:5px" data-toggle="modal" data-target="#driver_add_modal" class="btn btn-brand m-btn m-btn--custom m-btn--icon m-btn--air m-btn--pill">
              <span>
                <i class="la la-plus"></i>
                <span>
                  Add New Driver
                </span>
              </span>
            </a>
          <?php } ?>
        </div>
      </div>
      <div class="m-portlet__body">
        <!--begin: Datatable -->
        <table width="100%" class="table m-table nowrap table-header-fixed table-striped table-bordered table-hover table-header-fixed" id="driver_view_table">
          <thead>
            <tr class="">
              <th>id</th>
              <th>Sl No</th>
              <th>Driver Name</th>
              <th>Place</th>
              <th>Mobile</th>
              <th>Assigned Vehicle</th>
              <th>Creation</th>
              <th>Actions</th>
              <th>Assigned Vehicle</th>
            </tr>
          </thead>
          <tbody>
          </tbody>
        </table>
      </div>
    </div>

    <!--end: Datatable -->
    <div class="modal fade" tabindex="-1" id="driver_add_modal" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
      <div class="modal-dialog " role="document" style="max-width: 800px">
        <div class="modal-content">
          <div class="modal-header" style="background-color: #36a3f7;border-radius: 4px">
            <h5 class="modal-title" id="exampleModalLabel" style="color: #ffffff" >
              Create New Driver
            </h5>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
              <span aria-hidden="true">
                &times;
              </span>
            </button>
          </div>
          <form autocomplete="off" data-form-type="driver_create" id="form_driver_add" data-modal-id="driver_add_modal" method="post" action="<?php echo base_url().'vehicles/create_driver'?>" enctype="multipart/form-data" class="m-form m-form--fit m-form--state m-form--label-align-right " >
            <div class="modal-body">
              <div class="m-form__content">
                <div class="m-alert m-alert--icon alert alert-warning m--hide" role="alert" id="form_driver_add_msg">
                  <div class="m-alert__icon">
                    <i class="la la-warning"></i>
                  </div>
                  <div class="m-alert__text">
                    Oh snap! Change a few things up and try submitting again.
                  </div>
                  <div class="m-alert__close">
                    <button type="button" class="close" data-close="alert" aria-label="Close"></button>
                  </div>
                </div>
              </div>
              <div class="row">
                <div class="col-lg-6">
                  <div class="form-group m-form__group">
                    <label for="user_name">
                      Driver Name
                    </label>
                    <div class="input-group m-input-group m-input-group--pill m-input-group--air">
                      <div class="input-group-prepend">
                        <span class="input-group-text" id="basic-addon1">
                          <i class="fa fa-user"></i>
                        </span>
                      </div>
                      <input  required  type="text" name="driver_name"  class="form-control form_driver_add_fields m-input"  aria-describedby="basic-addon1">
                    </div>
                    <span class="m-form__help"></span>
                  </div>
                </div>
                <div class="col-lg-6">
                  <div class="form-group m-form__group">
                    <label for="user_name">
                      Place
                    </label>
                    <div class="input-group m-input-group m-input-group--pill m-input-group--air">
                      <div class="input-group-prepend">
                        <span class="input-group-text" id="basic-addon1">
                          <i class="fa fa-map-marker"></i>
                        </span>
                      </div>
                      <input  required type="text" name="place"  class="form_driver_add_fields form-control m-input"  aria-describedby="basic-addon1">
                    </div>
                    <span class="m-form__help"></span>
                  </div>
                </div>
              </div>
              <div class="row">
                <div class="col-lg-6">
                  <div class="form-group m-form__group">
                    <label for="user_name">
                      Mobile
                    </label>
                    <div class="input-group m-input-group m-input-group--pill m-input-group--air">
                      <div class="input-group-prepend">
                        <span class="input-group-text" id="basic-addon1">
                          <i class="fa fa-phone"></i>
                        </span>
                      </div>
                      <input  type="text" name="mobile"  class="form_driver_add_fields form-control m-input"  aria-describedby="basic-addon1">
                    </div>
                    <span class="m-form__help"></span>
                  </div>
                </div>
                <div class="col-lg-6">
                  <div class="form-group m-form__group m-select2--pill">
                    <label for="user_name">
                      Assigned Vehicles
                    </label>
                    <div class="m-select2 m-select2--air m-select2--pill">
                      <select multiple="multiple" style="width: 100%" class="form-control m-select2 m-select2-multiple form_driver_add_select" required id="assigned_vehicles" name="assigned_vehicles[]" data-placeholder="Select Vehicles">
                        <?php foreach ($owned_vehicles as $key => $value) { ?>
                        <option value="<?php echo $value->id?>"><?php echo $value->vehicle_name." [".$value->vehicle_no."]" ?></option>
                        <?php } ?>
                      </select>
                    </div>
                    <span class="m-form__help"></span>
                  </div>
                </div>
              </div>
            </div>
            <div class="modal-footer">
              <button type="button" class="btn btn-secondary" data-dismiss="modal">
                Close
              </button>
              <button type="submit" class="btn btn-primary form_submit_btn">
                Submit
              </button>
            </div>
          </form>
        </div>
      </div>
    </div>

    <div class="modal fade" tabindex="-1" id="driver_edit_modal" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
      <div class="modal-dialog " role="document" style="max-width: 800px">
        <div class="modal-content">
          <div class="modal-header" style="background-color: #36a3f7;border-radius: 4px">
            <h5 class="modal-title" id="exampleModalLabel" style="color: #ffffff" >
              Create New Driver
            </h5>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
              <span aria-hidden="true">
                &times;
              </span>
            </button>
          </div>
          <form autocomplete="off" data-form-type="driver_create" id="form_driver_edit" data-modal-id="driver_edit_modal" method="post" action="<?php echo base_url().'vehicles/update_driver'?>" enctype="multipart/form-data" class="m-form m-form--fit m-form--state m-form--label-align-right " >
            <div class="modal-body">
              <div class="m-form__content">
                <div class="m-alert m-alert--icon alert alert-warning m--hide" role="alert" id="form_driver_edit_msg">
                  <div class="m-alert__icon">
                    <i class="la la-warning"></i>
                  </div>
                  <div class="m-alert__text">
                    Oh snap! Change a few things up and try submitting again.
                  </div>
                  <div class="m-alert__close">
                    <button type="button" class="close" data-close="alert" aria-label="Close"></button>
                  </div>
                </div>
              </div>
              <div class="row">
                <div class="col-lg-6">
                  <div class="form-group m-form__group">
                    <label for="user_name">
                      Driver Name
                    </label>
                    <div class="input-group m-input-group m-input-group--pill m-input-group--air">
                      <div class="input-group-prepend">
                        <span class="input-group-text" id="basic-addon1">
                          <i class="fa fa-user"></i>
                        </span>
                      </div>
                      <input  required  type="text" name="driver_name" id="driver_name_edit" class="form-control form_driver_edit_fields m-input"  aria-describedby="basic-addon1">
                    </div>
                    <span class="m-form__help"></span>
                  </div>
                </div>
                <div class="col-lg-6">
                  <div class="form-group m-form__group">
                    <label for="user_name">
                      Place
                    </label>
                    <div class="input-group m-input-group m-input-group--pill m-input-group--air">
                      <div class="input-group-prepend">
                        <span class="input-group-text" id="basic-addon1">
                          <i class="fa fa-map-marker"></i>
                        </span>
                      </div>
                      <input  required type="text" name="place" id="driver_place_edit"  class="form_driver_edit_fields form-control m-input"  aria-describedby="basic-addon1">
                    </div>
                    <span class="m-form__help"></span>
                  </div>
                </div>
              </div>
              <div class="row">
                <div class="col-lg-6">
                  <div class="form-group m-form__group">
                    <label for="user_name">
                      Mobile
                    </label>
                    <div class="input-group m-input-group m-input-group--pill m-input-group--air">
                      <div class="input-group-prepend">
                        <span class="input-group-text" id="basic-addon1">
                          <i class="fa fa-phone"></i>
                        </span>
                      </div>
                      <input  type="text" name="mobile" id="driver_mobile_edit"  class="form_driver_edit_fields form-control m-input"  aria-describedby="basic-addon1">
                    </div>
                    <span class="m-form__help"></span>
                  </div>
                </div>
                <div class="col-lg-6">
                  <div class="form-group m-form__group m-select2--pill">
                    <label for="user_name">
                      Assigned Vehicles
                    </label>
                    <div class="m-select2 m-select2--air m-select2--pill">
                      <select multiple="multiple" style="width: 100%" class="form-control m-select2 m-select2-multiple form_driver_edit_select" required id="assigned_vehicles_edit" name="assigned_vehicles[]" data-placeholder="Select Vehicles">
                        <?php foreach ($owned_vehicles as $key => $value) { ?>
                        <option value="<?php echo $value->id?>"><?php echo $value->vehicle_name." [".$value->vehicle_no."]" ?></option>
                        <?php } ?>
                      </select>
                    </div>
                    <span class="m-form__help"></span>
                  </div>
                </div>
              </div>
              <input type="hidden" name="driver_id" id="driver_id_edit" />
            </div>
            <div class="modal-footer">
              <button type="button" class="btn btn-secondary" data-dismiss="modal">
                Close
              </button>
              <button type="submit" class="btn btn-primary form_submit_btn">
                Submit
              </button>
            </div>
          </form>
        </div>
      </div>
    </div>
    <div class="modal fade" tabindex="-1" id="driver_delete_modal" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
      <div class="modal-dialog " role="document" >
        <form id="form_driver_delete" data-modal-id="driver_delete_modal" autocomplete="off" method="post" action="<?php echo base_url().'vehicles/delete_driver'?>" class="form-horizontal">
          <div class="modal-content">
            <div class="alert alert-danger" role="alert" style="margin-bottom: 0px">
              <button type="button" class="close" data-dismiss="modal"></button>
              <br/>
              <h4 class="alert-heading">Warning! Please Confirm Your Action</h4>
              <br/>
              <p> Are You Sure to Delete this Data ?. All the Associated Data will Lost. </p>
              <p>
                <button class="btn btn-danger form_submit_btn" type="submit" name="submit">Confirm & Delete</button>
                <button type="button" class="btn btn-primary modal-dismiss" data-dismiss="modal">Cancel</button>
              </p>
              <input type="hidden" name="driver_id" id="driver_id_delete">
            </div>
          </div>
        </form>
      </div>
    </div>

  </div>
</div>
</div>
<!-- end:: Body -->
<!-- begin::Footer -->

<?php $this->view("includes/Inc_footer");?>

<!-- end::Footer -->
</div>
<!-- end:: Page -->

<?php $this->view("includes/Inc_sidebar");?>
<?php $this->view("includes/Inc_scripts");?>

<script type="text/javascript">
$("#assigned_vehicles").select2({
  placeholder: "Select Vehicles",
  dropdownParent: $("#form_driver_add")
})
$("#assigned_vehicles_edit").select2({
  placeholder: "Select Vehicles",
  dropdownParent: $("#form_driver_edit")
})
</script>

<!--begin::Page Snippets -->
<script>
$("#vehicle_menu").addClass('m-menu__item--active m-menu__item--open');
$("#vehicle_menu_3").addClass('m-menu__item--active');

$('body').on('click', '#driver_edit_btn', function() {
  var no = $(this).closest('tr').children('td');
  $('#driver_id_edit').val(no.eq(0).text());
  $('#driver_name_edit').val(no.eq(2).text());
  $('#driver_place_edit').val(no.eq(3).text());
  $('#driver_mobile_edit').val(no.eq(4).text());
  var assigned_vehicles = (no.eq(8).text()).split(',');
  $('#assigned_vehicles_edit').val(assigned_vehicles).trigger('change');
})
$('body').on('click', '#driver_delete_btn', function() {
  var no = $(this).closest('tr').children('td');
  $('#driver_id_delete').val(no.eq(0).text());
})

var table = $('#driver_view_table').DataTable({
  "ajax":{
    url :"<?php echo base_url().'vehicles/select_drivers' ?>", // json datasource
    type: "post", // type of method  , by default would be get
    data: function(d){

      }
    },
    "bProcessing": true,
    "deferRender": true,
    "bDeferRender": true,
    "scrollX" : true,
    buttons: [
      { extend: 'print', className: 'btn dark btn-outline',exportOptions: {columns: ':visible'},title: 'Vehicle Drivers' },
      { extend: 'csv', className: 'btn purple btn-outline ' },
      { extend: 'colvis', className: 'btn dark btn-outline', text: 'Columns'}
    ],
    dom:"<'row'<'col-sm-6 text-left'B><'col-sm-6 text-right'f>>\n\t\t\t<'row'<'col-sm-12'tr>>\n\t\t\t<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 dataTables_pager'lp>>", // horizobtal scrollable datatable
    "lengthMenu": [
      [25, 50, 100, -1],
      [25, 50, 100, "All"] // change per page values here
    ],
    // set the initial value
    "pageLength": 25,
    "columnDefs": [
      {
        "targets": [ 0,8],
        className: "hidden"
      }
    ],
    'order': [[0, 'asc']]
  });

    $(".hide_column").hide();

    $(".form_submit_btn").click(function (e) {
      e.preventDefault();
      var a = $(this),
      l = $(this).closest("form"),
      action = l.attr('action');
      var form_id = l.attr('id');
      l.validate({
        rules: {
          op_balance: {
            number: !0
          },
          basic_wage: {
            number: !0
          },
          contact_no: {
            number: !0
          }
        }, invalidHandler: function (e, r) {
          var i = $("#" + form_id + "_msg");
          i.removeClass("m--hide").show(), mUtil.scrollTo(i, -200)
        }, submitHandler: function (e) {
        }
      }), l.valid() && (a.addClass("m-loader m-loader--right m-loader--light").attr("disabled", !0),
      l.ajaxSubmit({
        url: action,
        success: function (e, t, r, s) {
          var modal_id = l.attr('data-modal-id');
          var form_type = l.attr('data-form-type');
          $("#" + form_id + "_msg").addClass("m--hide");
          // Block UI
          mApp.blockPage({
            overlayColor: "#000000",
            type: "loader",
            state: "success",
            message: "Please wait..."
          }), setTimeout(function () {
            mApp.unblockPage()
          }, 2e3);
          var obj = $.parseJSON(e);
          if (obj.status == 1) {
            a.removeClass("m-loader m-loader--right m-loader--light").attr("disabled", !1);
            $("#"+modal_id).modal('toggle');
            $("."+form_id+"_fields").val('');
            $("."+form_id+"_select").val('').trigger("change");
            toastr[obj.flashdata_type](obj.flashdata_msg, obj.flashdata_title);
            table.ajax.reload();
            $('input[name=basic_wage_type]').prop('checked', false);
          } else {
            a.removeClass("m-loader m-loader--right m-loader--light").attr("disabled", !1);
            toastr[obj.flashdata_type](obj.flashdata_msg, obj.flashdata_title);
          }
          if (obj == null) {
            setTimeout(function () {
              a.removeClass("m-loader m-loader--right m-loader--light").attr("disabled", !1);
              toastr["warning"]("Your Attempt is Timed Out. Please Try Again.", "Timed Out");
            }, 2e4)
          }
        },error: function() {
          a.removeClass("m-loader m-loader--right m-loader--light").attr("disabled", !1);
          toastr["error"]("Sorry. There Has Been Some Error Occurred. Please Try Again.", "Error");
        }
      })
    )
  });
</script>
