<?php $this->view("includes/Inc_pagehead");?>
<!-- Page Styles Goes Here-->

<?php $this->view("includes/Inc_navigation");?>
<div class="m-grid__item m-grid__item--fluid m-wrapper">
  <!-- BEGIN: Subheader -->
  <div class="m-subheader ">
    <div class="d-flex align-items-center">
      <div class="mr-auto">
        <h3 class="m-subheader__title m-subheader__title--separator">
          Driver Bata Report
        </h3>
        <ul class="m-subheader__breadcrumbs m-nav m-nav--inline">
          <li class="m-nav__item m-nav__item--home">
            <a href="#" class="m-nav__link m-nav__link--icon">
              <i class="m-nav__link-icon la la-home"></i>
            </a>
          </li>
          <li class="m-nav__separator">
            -
          </li>
          <li class="m-nav__item">
            <a href="<?php echo base_url().'dashboard'?>" class="m-nav__link">
              <span class="m-nav__link-text">
                Home
              </span>
            </a>
          </li>
          <li class="m-nav__separator">
            -
          </li>
          <li class="m-nav__item">
            <a href="<?php echo base_url().'vehicles/bata_report' ?>" class="m-nav__link">
              <span class="m-nav__link-text">
                Driver Bata Report
              </span>
            </a>
          </li>


        </ul>
      </div>
      <div>

      </div>
    </div>
  </div>
  <!-- END: Subheader -->
  <div class="m-content">
    <div class="m-portlet  m-portlet--rounded m-portlet--bordered">
      <div class="m-portlet__body" style="padding: 1rem 2.2rem;">
        <div class="m-form m-form--label-align-right m--margin-bottom-10">
          <div class="row ">
            <div class="col-xl-12 order-2 order-xl-1">
              <div class="form-group m-form__group row" style="padding-bottom: 0px">
                <div class="col-md-4">
                  <div class="form-group m-form__group" >
                    <label> Date:</label>
                    <input  id="table_filter_date"  type="text" class="form-control  m-input  m-input--air m-input--pill"  >
                  </div>
                </div>
                <div class="col-md-4">
                  <div class="form-group m-form__group">
                    <label>
                      Work:
                    </label>
                    <div class="m-select2 m-select2--air m-select2--pill">
                      <select style="width: 100%" class="form-control m-select2 table_filter" id="table_filter_work" >
                        <option value="all">All Works</option>
                        <?php
                        foreach($work_contracts as $row): ?>
                        <option data-work-status="<?php echo $row->work_status?>" value="<?php echo $row->work_id?>"><?php echo $row->work_name?></option>
                        <?php
                      endforeach;
                      ?>
                    </select>
                  </div>
                  <span class="m-form__help"></span>
                </div>
              </div>
              <div class="col-md-4">
                <div class="form-group m-form__group">
                  <label>
                    Vehicle:
                  </label>
                  <div class="m-select2 m-select2--air m-select2--pill">
                    <select style="width: 100%" class="form-control m-select2 table_filter" id="table_filter_vehicle"  >
                      <option value="all">All Vehicles</option>
                      <?php
                      foreach($vehicles as $row): ?>
                      <option value="<?php echo $row->id?>"><?php echo $row->consignee_name." [ ".$row->vehicle_name ." : ".$row->vehicle_no." ]"?></option>
                      <?php
                    endforeach;
                    ?>
                  </select>
                </div>
                <span class="m-form__help"></span>
              </div>
            </div>
            <div class="col-md-4">
              <div class="form-group m-form__group">
                <label>
                  Driver:
                </label>
                <div class="m-select2 m-select2--air m-select2--pill">
                  <select style="width: 100%" class="form-control m-select2 table_filter" id="table_filter_driver"  >
                    <option value="all">All Drivers</option>
                    <?php
                    foreach($driver_employees as $row): ?>
                      <option value="<?php echo $row->employee_id?>"><?php echo $row->employee_name?></option>
                      <?php
                    endforeach;
                    ?>
                  </select>
                </div>
                <span class="m-form__help"></span>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>
<div class="m-portlet m-portlet--mobile m-portlet--info m-portlet--head-solid-bg m-portlet--bordered m-portlet--rounded">
  <div class="m-portlet__head">
    <div class="m-portlet__head-caption">
      <div class="m-portlet__head-title">
        <h3 class="m-portlet__head-text">
          Driver Bata Report
        </h3>
      </div>
    </div>
    <div class="m-portlet__head-tools">

    </div>
  </div>
  <div class="m-portlet__body">
    <table width="100%" class="table m-table nowrap table-header-fixed table-striped table-bordered table-hover table-header-fixed" id="driver_bata_report_view_table">
      <thead>
        <tr class="">
          <th>Sl No</th>
          <th>Slip ID</th>
          <th>Work Date</th>
          <th>Vehicle</th>
          <th>Project</th>
          <th>Duration</th>
          <th>Driver</th>
          <th>Driver Bata Amt</th>
          <th>Driver Bata Includable</th>
          <th>Start Time</th>
          <th>End time</th>
          <th>Start KM</th>
          <th>End KM</th>
          <th>Creation</th>
        </tr>
      </thead>
      <tbody>
      </tbody>
    </table>
  </div>
</div>

</div>
</div>
</div>
<!-- end:: Body -->
<!-- begin::Footer -->

<?php $this->view("includes/Inc_footer");?>
<!-- end::Footer -->
</div>
<!-- end:: Page -->

<?php $this->view("includes/Inc_sidebar");?>
<?php $this->view("includes/Inc_scripts");?>

<!--begin::Page Snippets -->
<?php $this->view("modules/include_scripts/bill_scripts");?>
<?php $this->view("modules/include_scripts/transaction_scripts");?>
<?php $this->view("modules/include_scripts/vehicles_scripts");?>

<script>
$("#vehicle_menu").addClass('m-menu__item--active m-menu__item--open');
$("#vehicle_menu_9").addClass('m-menu__item--active');
</script>
<script>
$("#table_filter_work").select2({
  placeholder: "Select Work",
  templateResult: format_project_dropdown
})
$("#table_filter_work_type").select2({
  placeholder: "Select Work Type"
})
$("#table_filter_vehicle").select2({
  placeholder: "Select Vehicle"
})
$("#table_filter_driver").select2({
  placeholder: "Select Vehicle"
})



function GetSearchWork(){
  return $('#table_filter_work').val();
}
function GetSearchVehicle(){
  return $('#table_filter_vehicle').val();
}
function GetSearchDate(){
  return $('#table_filter_date').val();
}
function GetSearchDriver(){
  return $('#table_filter_driver').val();
}
var driver_bata_report_view_table = $('#driver_bata_report_view_table').DataTable({
  "ajax":{
    url :"<?php echo base_url().'vehicle_work_slips/select_driver_bata_report/' ?>", // json datasource
    type: "post", // type of method  , by default would be get
    data: function(d){
      d.work = GetSearchWork();
      d.vehicle_id = GetSearchVehicle();
      d.date = GetSearchDate();
      d.driver = GetSearchDriver();
    }
  },
  "bProcessing": true,
  "deferRender": true,
  "bDeferRender": true,

  "scrollX" : true,
  buttons: [
    { extend: 'print', className: 'btn dark btn-outline',exportOptions: {columns: ':visible'} ,title: 'Vehicle Fuel Report'},
    { extend: 'csv', className: 'btn purple btn-outline ' },
    { extend: 'colvis', className: 'btn dark btn-outline', text: 'Columns'}
  ],
  dom:"<'row'<'col-sm-6 text-left'B><'col-sm-6 text-right'f>>\n\t\t\t<'row'<'col-sm-12'tr>>\n\t\t\t<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 dataTables_pager'lp>>", // horizobtal scrollable datatable
  "lengthMenu": [
    [25, 50, 100, -1],
    [25, 50, 100, "All"] // change per page values here
  ],
  'ordering': false,
  "columnDefs": [
    {
      "targets": [1 ],
      className: "hidden"
    }
  ]
});

$(".table_filter").on("change", function() {
  driver_bata_report_view_table.ajax.reload();
});
$(".hide_column").hide();


// Date Range Picker
var start = moment();
var end = moment();

function cb(start, end) {
  $('#table_filter_date').val(start.format('MMMM D, YYYY') + ' - ' + end.format('MMMM D, YYYY'));
  driver_bata_report_view_table.ajax.reload();
}

$('#table_filter_date').daterangepicker({
  buttonClasses: "m-btn btn",
  applyClass: "btn-primary",
  cancelClass: "btn-secondary",
  startDate: start,
  endDate: end,
  locale: {
    format: 'MMMM D, YYYY'
  },
  ranges: {
    'Today': [moment(), moment()],
    'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
    'Last 7 Days': [moment().subtract(6, 'days'), moment()],
    'Last 30 Days': [moment().subtract(29, 'days'), moment()],
    'This Month': [moment().startOf('month'), moment().endOf('month')],
    'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')],
    'All time': [moment('1970-01-01'), moment().add(9999, 'days')],
  }
}, cb);

cb(start, end);
</script>
