<?php $this->view("includes/Inc_pagehead"); ?>
<!-- Page Styles Goes Here-->
<style>
.m-widget24 .m-widget24__item .m-widget24__stats {
  float: right;
  margin-right: 1.8rem;
  margin-top: -2.43rem;
  font-size: 2.75rem;
  font-weight: 600;
}
</style>
<?php $this->view("includes/Inc_navigation"); ?>
<div class="m-grid__item m-grid__item--fluid m-wrapper">
  <!-- BEGIN: Subheader -->
  <div class="m-subheader ">
    <div class="d-flex align-items-center">
      <div class="mr-auto">
        <h3 class="m-subheader__title m-subheader__title--separator">
          Manage User Accounts
        </h3>
        <ul class="m-subheader__breadcrumbs m-nav m-nav--inline">
          <li class="m-nav__item m-nav__item--home">
            <a href="#" class="m-nav__link m-nav__link--icon">
              <i class="m-nav__link-icon la la-home"></i>
            </a>
          </li>
          <li class="m-nav__separator">
            -
          </li>
          <li class="m-nav__item">
            <a href="<?php echo $this->session->userdata("dashboard_link") ?>" class="m-nav__link">
              <span class="m-nav__link-text">
                Users
              </span>
            </a>
          </li>
          <li class="m-nav__separator">
            -
          </li>
          <li class="m-nav__item">
            <a href="<?php echo base_url() . 'users/accounts' ?>" class="m-nav__link">
              <span class="m-nav__link-text">
                User Accounts
              </span>
            </a>
          </li>


        </ul>
      </div>
      <div>

      </div>
    </div>
  </div>
  <!-- END: Subheader -->
  <div class="m-content">
    <?php if($this->session->userdata('branch_id')==0){?>
      <div class="m-portlet ">
        <div class="m-portlet__body  m-portlet__body--no-padding">
          <div class="row m-row--no-padding m-row--col-separator-xl">
            <div class="col-md-6 col-lg-6 col-xl-6">
              <!--begin::Total Profit-->
              <div class="m-widget24">
                <div class="m-widget24__item">
                  <h4 class="m-widget24__title">
                    Allowed Active Users (Web)
                  </h4><br>
                  <span class="m-widget24__desc">
                    Total Allowed Active User Accounts in Web App
                  </span>
                  <span class="m-widget24__stats m--font-brand web_user_count"></span>
                </div>
              </div>
              <div class="m--space-40"></div>
              <!--end::Total Profit-->
            </div>
            <div class="col-md-6 col-lg-6 col-xl-6" >
              <!--begin::New Feedbacks-->
              <div class="m-widget24" >
                <div class="m-widget24__item">
                  <h4 class="m-widget24__title">
                    Allowed Active Users (Mobile)
                  </h4><br>
                  <span class="m-widget24__desc">
                    Total Allowed Active User Accounts in Mobile App
                  </span>
                  <span class="m-widget24__stats m--font-info mobile_user_count"></span>
                </div>
              </div>
              <div class="m--space-40"></div>
            </div>
          </div>
        </div>
      </div>
    <?php } ?>
    <div class="m-portlet m-portlet--mobile m-portlet--info m-portlet--head-solid-bg m-portlet--bordered m-portlet--rounded">
      <div class="m-portlet__head">
        <div class="m-portlet__head-caption">
          <div class="m-portlet__head-title">
            <h3 class="m-portlet__head-text">
              List of User Accounts
            </h3>
          </div>
        </div>
        <div class="m-portlet__head-tools">
          <?php if ($this->session->userdata('user_role') != 'auditor') { ?>
            <a href="#" data-toggle="modal" data-target="#user_add_modal" class="btn btn-focus m-btn m-btn--custom m-btn--icon m-btn--air m-btn--pill">
              <span>
                <i class="la la-plus"></i>
                <span>
                  Create New User Account
                </span>
              </span>
            </a>
          <?php } ?>
        </div>
      </div>
      <div class="m-portlet__body">
        <?php if (!empty($this->config->item('company_branches'))) { ?>
          <!--begin: Search Form -->
          <div class="m-form m-form--label-align-right m--margin-bottom-10">
            <div class="row">
              <div class="col-xl-12 order-2 order-xl-1">
                <div class="form-group m-form__group row ">
                  <div class="col-lg-4">
                    <div class="form-group m-form__group">
                      <label>
                        Company Branch
                      </label>
                      <div class="m-select2 m-select2--air m-select2--pill">
                        <select width="100%" required class="form-control m-select2 table_filter company-branch-select2" id="company_branch">
                          <option selected value="all"> All Branches</option>
                          <option value="0">NO BRANCH</option>
                          <?php foreach ($this->config->item('company_branches') as $key => $value) { ?>
                            <option value="<?php echo $value->branch_id ?>"><?php echo $value->branch_name ?></option>
                          <?php } ?>
                        </select>
                      </div>
                      <span class="m-form__help"></span>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        <?php } ?>


        <!--begin: Datatable -->
        <table width="100%" class="table m-table nowrap table-header-fixed table-striped table-bordered table-hover table-header-fixed" id="user_view_table">
          <thead>
            <tr class="">
              <th>ID</th>
              <th>Sl No</th>
              <th>Branch Name</th>
              <th>Name</th>
              <th>Employee Code</th>
              <th>Email</th>
              <th>Phone Number</th>
              <th>Password</th>
              <th>Designation</th>
              <th>Account Type</th>
              <th>Duty Start Time</th>
              <th>Duty End Time</th>
              <th>Joined Date</th>
              <th>Date of Birth</th>
              <th>Address</th>
              <th>Status</th>
              <th>Created On</th>
              <th style="display: none">status</th>
              <th>Actions</th>
              <th style="display: none">User Role</th>
              <th style="display: none">Duty Start Time</th>
              <th style="display: none">Duty End Time</th>
              <th style="display: none">Project Area</th>
            </tr>
          </thead>
          <tbody>
          </tbody>
        </table>
        <!--end: Datatable -->
        <?php if ($this->session->userdata('user_role') == 'admin'  && $this->session->userdata('branch_id') == 0){ ?>
          <table class="table table-bordered m-table m-table--border-success m-table--head-bg-success" style="margin-top:30px">
            <thead>
              <tr>
                <th>#</th>
                <th>User Role</th>
                <th>Web App Access</th>
                <th>Mobile App Access</th>
                <th>Total No of Accounts</th>
                <th>Active No of Accounts</th>
              </tr>
            </thead>
            <tbody>
              <?php foreach ($user_roles_all as $key => $value) { ?>
                <tr>
                  <th scope="row"><?php echo $key+1 ?></th>
                  <td><strong><?php echo $value->role_title ?></strong></td>
                  <td><?php
                  if($value->web_app_access==1){ ?>
                    <span style="margin-top: 5px" class="m-badge m-badge--success m-badge--wide"><i class="fa fa-check-circle"></i> Yes</span>
                  <?php }else{ ?>
                    <span style="margin-top: 5px" class="m-badge m-badge--danger m-badge--wide"><i class="fa fa-times-circle"></i> No</span>
                  <?php }
                  ?></td>
                  <td><?php
                  if($value->mobile_app_access==1){ ?>
                    <span style="margin-top: 5px" class="m-badge m-badge--success m-badge--wide"><i class="fa fa-check-circle"></i> Yes</span>
                  <?php }else{ ?>
                    <span style="margin-top: 5px" class="m-badge m-badge--danger m-badge--wide"><i class="fa fa-times-circle"></i> No</span>
                  <?php }
                  ?></td>
                  <td><?php echo $value->user_account_count_total ?></td>
                  <td><strong><?php echo $value->user_account_count_active ?></strong></td>
                </tr>
              <?php } ?>
            </tbody>
          </table>
        <?php } ?>

        <div class="modal fade" tabindex="-1" id="user_add_modal" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
          <div class="modal-dialog " role="document" style="max-width: 800px">
            <div class="modal-content">
              <div class="modal-header" style="background-color: #36a3f7;border-radius: 4px">
                <h5 class="modal-title" id="exampleModalLabel" style="color: #ffffff" >
                  Create New User Account
                </h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                  <span aria-hidden="true">
                    &times;
                  </span>
                </button>
              </div>
              <form autocomplete="off" data-modal-id="user_add_modal" id="form_user_add" method="post" action="<?php echo base_url().'user/create'?>" enctype="multipart/form-data" class="form m-form m-form--fit m-form--state m-form--label-align-right " >
                <div class="modal-body">
                  <div class="m-form__content">
                    <div class="m-alert m-alert--icon alert alert-warning m--hide" role="alert" id="form_user_add_msg">
                      <div class="m-alert__icon">
                        <i class="la la-warning"></i>
                      </div>
                      <div class="m-alert__text">
                        Oh snap! Change a few things up and try submitting again.
                      </div>
                      <div class="m-alert__close">
                        <button type="button" class="close" data-close="alert" aria-label="Close"></button>
                      </div>
                    </div>
                  </div>
                  <div class="row">
                    <div class="col-lg-6">
                      <div class="form-group m-form__group" >
                        <label for="user_name">
                          User Account Role
                        </label>
                        <div class="m-select2 m-select2--air m-select2--pill ">
                          <select required style="width: 100%" class="form-control m-select2 form_user_add_select" id="user_role_add"  name="user_role" data-placeholder="Select User Type">
                            <option selected disabled>Select User Role</option>
                            <?php
                            foreach($user_roles as $row): ?>
                            <option value="<?php echo $row->role_id?>"><?php echo $row->role_title?></option>
                            <?php
                          endforeach;
                          ?>
                        </select>
                      </div>
                      <span class="m-form__help"></span>
                    </div>
                  </div>
                  <div class="col-lg-6">
                    <div class="form-group m-form__group" >
                      <label for="user_name">
                        Name of User
                      </label>
                      <div class="input-group m-input-group m-input-group--pill m-input-group--air">
                        <div class="input-group-prepend">
                          <span class="input-group-text" id="basic-addon1">
                            <i class="la la-user"></i>
                          </span>
                        </div>
                        <input required type="text" name="user_name" id="user_name" class="form-control m-input form_user_add_fields" placeholder="Name of User" aria-describedby="basic-addon1">
                      </div>
                      <span class="m-form__help"></span>
                    </div>
                  </div>
                </div>
                <div class="row">
                  <div class="col-lg-6">
                    <div class="form-group m-form__group" >
                      <label for="user_name">
                        Phone Number
                      </label>
                      <div class="input-group m-input-group m-input-group--pill m-input-group--air">
                        <div class="input-group-prepend">
                          <span class="input-group-text" id="basic-addon1">
                            <i class="la la-phone"></i>
                          </span>
                        </div>
                        <input type="text" name="mobile_number_1" id="mobile_number" class="form-control m-input form_user_add_fields" placeholder="Phone Number" aria-describedby="basic-addon1">
                      </div>
                      <span class="m-form__help"></span>
                    </div>
                  </div>
                  <div class="col-lg-6">
                    <div class="form-group m-form__group" >
                      <label for="user_name">
                        Email ID
                      </label>
                      <div class="input-group m-input-group m-input-group--pill m-input-group--air">
                        <div class="input-group-prepend">
                          <span class="input-group-text" id="basic-addon1">
                            <i class="la la-envelope"></i>
                          </span>
                        </div>
                        <input required type="text" name="email" id="email" class="form-control m-input form_user_add_fields" placeholder="Email ID" aria-describedby="basic-addon1">
                      </div>
                      <span class="m-form__help"></span>
                    </div>
                  </div>
                </div>

                <div class="row">
                  <div class="col-lg-6" style="display:none" id="project_area_div_add">
                    <div class="form-group m-form__group" >
                      <label for="user_name">
                        Project Area
                      </label>
                      <div class="m-select2 m-select2--air m-select2--pill ">
                        <select style="width: 100%" multiple class="form-control m-select2 form_user_add_select" id="project_area_add"  name="project_area_location[]" data-placeholder="Select Area">
                          <!-- <option value="0" selected disabled>Select Area</option> -->
                          <?php
                          foreach($project_area_locations as $row): ?>
                          <option value="<?php echo $row->area_id?>"><?php echo $row->area_name?></option>
                          <?php
                        endforeach;
                        ?>
                      </select>
                    </div>
                    <span class="m-form__help">Select Area</span>
                  </div>
                </div>
              </div>
              <div class="row">
                <div class="col-lg-4">
                  <div class="form-group m-form__group" >
                    <label for="user_name">
                      Account Status
                    </label>
                    <div >
                      <span style="width: 400px" class="m-bootstrap-switch m-bootstrap-switch--pill m-bootstrap-switch--air">
                        <input id="acc_status_add" style="width: 400px" name="acc_status" data-switch="true" type="checkbox" data-on-color="success" data-off-color="danger" data-on-text="Active" data-off-text="Suspended" checked="checked">
                      </span>
                    </div>
                  </div>
                </div>
                <div class="col-lg-4">
                  <div class="form-group m-form__group" >
                    <label for="user_name">
                      Op Balance (Petty Cash A/C)
                    </label>
                    <div class="m-input-icon m-input-icon--right ">
                      <input required type="text" name="opening_balance_user_acc" class="form-control m-input m-input--pill m-input--air form_user_add_fields" placeholder="Opening Balance (Petty Cash A/C)">
                      <span class="m-input-icon__icon m-input-icon__icon--right"><span><?php echo $this->config->item('Currency_currency_format'); ?></span></span>
                    </div>
                    <span class="m-form__help">(Current Petty Cash Balance On Account Creation)</span>
                  </div>
                </div>
              </div>
              <div style="background: white;border: 4px solid #f7f7fa;padding: 15px;margin: 5px;padding-bottom: 0px;margin-top:20px">
                <div class="m-section" style="margin-bottom: 10px">
                  <h3 class="m-section__heading">Employee Details</h3>
                  <!-- advance details -->
                  <div class="row">
                    <div class="col-lg-4">
                      <div class="form-group m-form__group" >
                        <label for="user_name">Date of Birth</label>
                        <input data-date-format="dd-mm-yyyy" class="form-control m-input m-input--air m-input--pill form_user_add_fields" name="dob" id="dob_add" placeholder="Date of Birth" type="text" />
                        <span class="m-form__help"></span>
                      </div>
                    </div>
                    <div class="col-lg-8">
                      <div class="form-group m-form__group" >
                        <label for="user_name">
                          Address
                        </label>
                        <div class="input-group m-input-group m-input-group--pill m-input-group--air">
                          <textarea required type="text" name="address" id="address" class="form-control m-input form_user_add_fields" placeholder="Address" aria-describedby="basic-addon1"></textarea>
                        </div>
                        <span class="m-form__help"></span>
                      </div>
                    </div>
                  </div>
                  <div class="row">
                    <div class="col-lg-4">
                      <div class="form-group m-form__group" >
                        <label for="user_name">
                          Employee Code
                        </label>
                        <div class="input-group m-input-group m-input-group--pill m-input-group--air">
                          <input type="text" name="employee_code" id="employee_code" class="form-control m-input form_user_add_fields" placeholder="Employee Code" aria-describedby="basic-addon1">
                        </div>
                        <span class="m-form__help"></span>
                      </div>
                    </div>
                    <div class="col-lg-4">
                      <div class="form-group m-form__group" >
                        <label for="user_name">
                          Designation
                        </label>
                        <div class="input-group m-input-group m-input-group--pill m-input-group--air">
                          <input required type="text" name="designation" class="form-control m-input form_user_add_fields" placeholder="Designation" aria-describedby="basic-addon1">
                        </div>
                        <span class="m-form__help"></span>
                      </div>
                    </div>
                    <div class="col-lg-4">
                      <div class="form-group m-form__group" >
                        <label for="user_name">Joined Date</label>
                        <input data-date-format="dd-mm-yyyy" class="form-control m-input m-input--air m-input--pill form_user_add_fields" name="joined_date" id="joined_date_add" placeholder="Joined Date" type="text" />
                        <span class="m-form__help"></span>
                      </div>
                    </div>
                  </div>
                  <div class="row" style="margin-top: 10px">
                    <div class="col-lg-4">
                      <div class="form-group m-form__group" >
                        <label for="user_name">
                          <?php echo $this->config->item('Employee_civil_id_name'); ?>
                        </label>
                        <div class="m-input-icon m-input-icon--right">
                          <input type="text" name="civil_id" class="form-control m-input m-input--pill m-input--air form_user_add_fields" placeholder="<?php echo $this->config->item('Employee_civil_id_name'); ?>">
                          <span class="m-input-icon__icon m-input-icon__icon--right"><span><i class="fa fa-user"></i></span></span>
                        </div>
                        <span class="m-form__help"></span>
                      </div>
                    </div>
                    <div class="col-lg-4">
                      <div class="form-group m-form__group" >
                        <label for="user_name">Duty Start Time</label>
                        <input class="form-control m-input m-input--air m-input--pill" name="duty_start_time" id="duty_start_time_add" readonly placeholder="Select time" type="text" />
                      </div>
                    </div>
                    <div class="col-lg-4">
                      <div class="form-group m-form__group" >
                        <label for="user_name">Duty End Time</label>
                        <input class="form-control m-input m-input--air m-input--pill" name="duty_end_time" id="duty_end_time_add" readonly placeholder="Select time" type="text" />
                      </div>
                    </div>
                  </div>
                  <div class="row">
                    <div class="col-lg-5 ">
                      <div class="m-form__group form-group" >
                        <label class="col-form-label">Basic Wage Type</label>
                        <div class="m-radio-inline">
                          <label class="m-radio m-radio--solid m-radio--state-info">
                            <input required type="radio" name="basic_wage_type" class="" value="Hourly"> Hourly
                            <span></span>
                          </label>
                          <label class="m-radio m-radio--solid m-radio--state-brand">
                            <input required type="radio" name="basic_wage_type" class="" value="Daily"> Daily
                            <span></span>
                          </label>
                          <label class="m-radio m-radio--solid m-radio--state-success">
                            <input type="radio" name="basic_wage_type" class="" value="Monthly"> Monthly
                            <span></span>
                          </label>
                        </div>
                        <span class="m-form__help"></span>
                      </div>
                    </div>
                    <div class="col-lg-4 ">
                      <div class="form-group m-form__group" >
                        <label for="user_name">
                          Basic Wage
                        </label>
                        <div class="m-input-icon m-input-icon--right ">
                          <input required type="text" name="basic_wage" class="form-control m-input m-input--pill m-input--air form_user_add_fields" placeholder="Basic Wage">
                          <span class="m-input-icon__icon m-input-icon__icon--right"><span><?php echo $this->config->item('Currency_currency_format'); ?></span></span>
                        </div>
                        <span class="m-form__help"></span>
                      </div>
                    </div>
                    <div class="col-lg-3 ">
                      <div class="m-form__group form-group">
                        <label class="col-form-label">Fixed Basic Wage</label>
                        <div class="m-radio-inline">
                          <label class="m-radio m-radio--solid m-radio--state-warning">
                            <input type="radio" name="fixed_basic_wage" class="" checked value="1"> Yes
                            <span></span>
                          </label>
                          <label class="m-radio m-radio--solid m-radio--state-danger">
                            <input type="radio" id="fixed_basic_wage_add_no" disabled name="fixed_basic_wage" class="" value="0"> No
                            <span></span>
                          </label>
                        </div>
                        <span class="m-form__help" id="fixed_basic_wage_add_info">*Yes = Worked Days Not Dependable</span>
                      </div>
                    </div>
                  </div>
                  <div class="row">
                    <div class="col-lg-4">
                      <div class="form-group m-form__group">
                        <label for="user_name">
                          Op Balance (Salary A/C)
                        </label>
                        <div class="m-input-icon m-input-icon--right ">
                          <input required type="text" name="opening_balance_salary" class="form-control m-input m-input--pill m-input--air form_user_add_fields" placeholder="Opening Balance">
                          <span class="m-input-icon__icon m-input-icon__icon--right"><span><?php echo $this->config->item('Currency_currency_format'); ?></span></span>
                        </div>
                        <span class="m-form__help">(Current Payable Balance of Employee Salary A/C)</span>
                      </div>
                    </div>
                    <div class="col-lg-4 padding-0">
                      <div class="form-group m-form__group">
                        <label for="user_name">
                          Department
                        </label>
                        <div class="input-group m-input-group m-input-group--pill">
                          <div class="input-group-prepend">
                            <a href="#hr_department_add_modal"   data-toggle="modal" data-target="#hr_department_add_modal" class="btn btn-focus">
                              <i class="fa fa-plus-circle"></i>
                            </a>
                          </div>
                          <select style="width: 80%" class="form-control m-select2 m-select2-general form_employee_add_select" required id="hr_department_add" name="department">

                          </select>
                        </div>
                        <span class="m-form__help"></span>
                      </div>
                    </div>
                    <?php if($this->config->item('app_module_vehicle_management')==1){ ?>
                      <div class="col-lg-4" id="assigned_vehicle_add_div" style="display:none">
                        <div class="form-group m-form__group m-select2--pill">
                          <label for="user_name">
                            Assigned Vehicles
                          </label>
                          <div class="m-select2 m-select2--air m-select2--pill">
                            <select multiple="multiple" style="width: 100%" class="form-control m-select2 m-select2-multiple form_employee_add_select"  id="assigned_vehicles_add" name="assigned_vehicles[]" data-placeholder="Select Vehicles">
                              <?php foreach ($owned_vehicles as $key => $value) { ?>
                                <option value="<?php echo $value->id?>"><?php echo $value->vehicle_name." [".$value->vehicle_no."]" ?></option>
                              <?php } ?>
                            </select>
                          </div>
                          <span class="m-form__help"></span>
                        </div>
                      </div>
                    <?php } ?>
                  </div>
                </div>
              </div>
            </div>
            <div class="modal-footer">
              <button type="button" class="btn btn-secondary " data-dismiss="modal">
                Close
              </button>
              <button type="submit" class="btn btn-primary form_submit_btn">
                Submit
              </button>
            </div>
          </form>
        </div>
      </div>
    </div>
    <div class="modal fade" tabindex="-1" id="user_edit_modal" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
      <div class="modal-dialog " role="document" style="max-width: 800px">
        <div class="modal-content">
          <div class="modal-header" style="background-color: #36a3f7;border-radius: 4px">
            <h5 class="modal-title" id="exampleModalLabel" style="color: #ffffff">
              Update User Account
            </h5>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
              <span aria-hidden="true">
                &times;
              </span>
            </button>
          </div>
          <form autocomplete="off" data-modal-id="user_edit_modal" id="form_user_edit" method="post" action="<?php echo base_url() . 'user/update' ?>" enctype="multipart/form-data" class="form m-form m-form--fit m-form--state m-form--label-align-right ">
            <div class="modal-body">
              <div class="m-form__content">
                <div class="m-alert m-alert--icon alert alert-warning m--hide" role="alert" id="form_user_edit_msg">
                  <div class="m-alert__icon">
                    <i class="la la-warning"></i>
                  </div>
                  <div class="m-alert__text">
                    Oh snap! Change a few things up and try submitting again.
                  </div>
                  <div class="m-alert__close">
                    <button type="button" class="close" data-close="alert" aria-label="Close"></button>
                  </div>
                </div>
              </div>
              <div class="row">
                <div class="col-lg-6">
                  <div class="form-group m-form__group">
                    <label for="user_name">
                      User Account Role
                    </label>
                    <div class="m-select2 m-select2--air m-select2--pill ">
                      <select required style="width: 100%" class="form-control m-select2 form_user_edit_select" id="user_role_edit" name="user_role" data-placeholder="Select User Type">
                        <option selected disabled>Select User Role</option>
                        <?php
                        foreach ($user_roles as $row) : ?>
                        <option value="<?php echo $row->role_id ?>"><?php echo $row->role_title ?></option>
                        <?php
                      endforeach;
                      ?>
                    </select>
                  </div>
                  <span class="m-form__help">Select User Role</span>
                </div>
              </div>
              <div class="col-lg-6">
                <div class="form-group m-form__group">
                  <label for="user_name">
                    Name of User
                  </label>
                  <div class="input-group m-input-group m-input-group--pill m-input-group--air">
                    <div class="input-group-prepend">
                      <span class="input-group-text" id="basic-addon1">
                        <i class="la la-user"></i>
                      </span>
                    </div>
                    <input required type="text" name="user_name" id="update_user_name" class="form-control m-input form_user_edit_fields" placeholder="Name of User" aria-describedby="basic-addon1">
                  </div>
                  <span class="m-form__help"></span>
                </div>
              </div>
            </div>
            <div class="row">
              <div class="col-lg-6">
                <div class="form-group m-form__group">
                  <label for="user_name">
                    Phone Number
                  </label>
                  <div class="input-group m-input-group m-input-group--pill m-input-group--air">
                    <div class="input-group-prepend">
                      <span class="input-group-text" id="basic-addon1">
                        <i class="la la-phone"></i>
                      </span>
                    </div>
                    <input type="text" name="mobile_number_1" id="update_mobile_number" class="form-control m-input form_user_edit_fields" placeholder="Phone Number" aria-describedby="basic-addon1">
                  </div>
                  <span class="m-form__help"></span>
                </div>
              </div>
              <div class="col-lg-6">
                <div class="form-group m-form__group">
                  <label for="user_name">
                    Email ID
                  </label>
                  <div class="input-group m-input-group m-input-group--pill m-input-group--air">
                    <div class="input-group-prepend">
                      <span class="input-group-text" id="basic-addon1">
                        <i class="la la-envelope"></i>
                      </span>
                    </div>
                    <input required type="text" name="email" id="update_email" class="form-control m-input form_user_edit_fields" placeholder="Email ID" aria-describedby="basic-addon1">
                  </div>
                  <span class="m-form__help"></span>
                </div>
              </div>
            </div>

            <div class="row">
              <div class="col-lg-4">
                <div class="form-group m-form__group">
                  <label for="user_name">Date of Birth</label>
                  <input data-date-format="dd-mm-yyyy" class="form-control m-input m-input--air m-input--pill form_user_edit_fields" name="dob" id="dob_edit" placeholder="Date of Birth" type="text" />
                  <span class="m-form__help"></span>
                </div>
              </div>
              <div class="col-lg-8">
                <div class="form-group m-form__group">
                  <label for="user_name">
                    Address
                  </label>
                  <div class="input-group m-input-group m-input-group--pill m-input-group--air">
                    <div class="input-group-prepend">
                      <span class="input-group-text" id="basic-addon1">
                        <i class="la la-map-marker"></i>
                      </span>
                    </div>
                    <textarea required type="text" name="address" id="address_edit" class="form-control m-input form_user_edit_fields" placeholder="Address" aria-describedby="basic-addon1"></textarea>
                  </div>
                  <span class="m-form__help"></span>
                </div>
              </div>
            </div>

            <input type="hidden" name="user_id" id="update_user_id">
            <div class="row">
              <div class="col-lg-4">
                <div class="form-group m-form__group">
                  <label for="user_name">
                    Account Status
                  </label>
                  <div>
                    <span style="width: 400px" class="m-bootstrap-switch m-bootstrap-switch--pill m-bootstrap-switch--air">
                      <input style="width: 400px" id="acc_status_edit" name="acc_status" data-switch="true" type="checkbox" data-on-color="success" data-off-color="danger" data-on-text="Active" data-off-text="Suspended" checked="checked">
                    </span>
                  </div>
                </div>
              </div>
              <div class="col-lg-4">
                <div class="form-group m-form__group">
                  <label for="user_name">
                    Employee Code
                  </label>
                  <div class="input-group m-input-group m-input-group--pill m-input-group--air">
                    <div class="input-group-prepend">
                      <span class="input-group-text" id="basic-addon1">
                        <i class="la la-tag"></i>
                      </span>
                    </div>
                    <input type="text" name="employee_code" id="update_employee_code" class="form-control m-input form_user_edit_fields" placeholder="Employee Code" aria-describedby="basic-addon1">
                  </div>
                  <span class="m-form__help"></span>
                </div>
              </div>
              <div class="col-lg-4">
                <div class="form-group m-form__group">
                  <label for="user_name">
                    Designation
                  </label>
                  <div class="input-group m-input-group m-input-group--pill m-input-group--air">
                    <div class="input-group-prepend">
                      <span class="input-group-text" id="basic-addon1">
                        <i class="la la-tag"></i>
                      </span>
                    </div>
                    <input type="text" name="designation" id="designation_edit" class="form-control m-input form_user_edit_fields" placeholder="Designation" aria-describedby="basic-addon1">
                  </div>
                  <span class="m-form__help"></span>
                </div>
              </div>
            </div>
            <div class="row" style="margin-top: 10px">
              <div class="col-lg-4">
                <div class="form-group m-form__group">
                  <label for="user_name">Duty Start Time</label>
                  <input class="form-control m-input m-input--air m-input--pill " name="duty_start_time" id="duty_start_time_edit" readonly placeholder="Select time" type="text" />
                </div>
              </div>
              <div class="col-lg-4">
                <div class="form-group m-form__group">
                  <label for="user_name">Duty End Time</label>
                  <input class="form-control m-input m-input--air m-input--pill " name="duty_end_time" id="duty_end_time_edit" readonly placeholder="Select time" type="text" />
                </div>
              </div>
              <div class="col-lg-4">
                <div class="form-group m-form__group">
                  <label for="user_name">Joined Date</label>
                  <input data-date-format="dd-mm-yyyy" class="form-control m-input m-input--air m-input--pill form_user_edit_fields" name="joined_date" id="joined_date_edit" placeholder="Joined Date" type="text" />
                  <span class="m-form__help"></span>
                </div>
              </div>
            </div>
            <div class="row">
              <div class="col-lg-6" style="display:none" id="project_area_div_edit">
                <div class="form-group m-form__group">
                  <label for="user_name">
                    Project Area
                  </label>
                  <div class="m-select2 m-select2--air m-select2--pill ">
                    <select multiple style="width: 100%" class="form-control m-select2 form_user_add_select" id="project_area_edit" name="project_area_location[]" data-placeholder="Select Area">
                      <!-- <option value="0" selected disabled>Select Area</option> -->
                      <?php
                      foreach ($project_area_locations as $row) : ?>
                      <option value="<?php echo $row->area_id ?>"><?php echo $row->area_name ?></option>
                      <?php
                    endforeach;
                    ?>
                  </select>
                </div>
                <span class="m-form__help">Select Area</span>
              </div>
            </div>
          </div>
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-secondary " data-dismiss="modal">
            Close
          </button>
          <button type="submit" class="btn btn-primary form_submit_btn">
            Submit
          </button>
        </div>
      </form>
    </div>
  </div>
</div>
<div class="modal fade" tabindex="-1" id="user_delete_modal" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog " role="document">
    <form autocomplete="off" data-modal-id="user_delete_modal" method="post" action="<?php echo base_url() . 'user/delete' ?>" class="form-horizontal">
      <div class="modal-content">
        <div class="alert alert-danger" role="alert" style="margin-bottom: 0px">
          <button type="button" class="close" data-dismiss="modal"></button>
          <br />
          <h4 class="alert-heading">Warning! Please Confirm Your Action</h4>
          <br />
          <p> Are You Sure to Delete this Data ?. All the Associated Data will Lost. </p>
          <p>
            <button class="btn btn-danger form_submit_btn" type="submit" name="submit">Confirm & Delete</button>
            <button type="button" class="btn btn-primary modal-dismiss" data-dismiss="modal">Cancel</button>
          </p>
          <input type="hidden" name="user_id" id="user_delete_id">
        </div>
      </div>
    </form>
  </div>
</div>
<div class="modal fade" tabindex="-1" id="resend_email_modal" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog " role="document">
    <form autocomplete="off" data-modal-id="resend_email_modal" method="post" action="<?php echo base_url() . 'user/resend_email' ?>" class="form-horizontal">
      <div class="modal-content">
        <div class="alert alert-info" role="alert" style="margin-bottom: 0px">
          <button type="button" class="close" data-dismiss="modal"></button>
          <br />
          <h4 class="alert-heading">Warning! Please Confirm Your Action</h4>
          <br />
          <p> Are You Sure to Resend Login Credentials To Below Email. </p>
          <div class="row">
            <div class="col-lg-12">
              <div class="form-group m-form__group">
                <label for="user_name">
                  User Name
                </label>
                <div class="input-group m-input-group m-input-group--pill m-input-group--air">
                  <div class="input-group-prepend">
                    <span class="input-group-text" id="basic-addon1">
                      <i class="la la-user"></i>
                    </span>
                  </div>
                  <input disabled type="text" id="resend_name" class="form-control m-input" aria-describedby="basic-addon1">
                </div>
              </div>
            </div>
          </div>
          <div class="row">
            <div class="col-lg-12">
              <div class="form-group m-form__group">
                <label for="user_name">
                  User Email
                </label>
                <div class="input-group m-input-group m-input-group--pill m-input-group--air">
                  <div class="input-group-prepend">
                    <span class="input-group-text" id="basic-addon1">
                      <i class="la la-user"></i>
                    </span>
                  </div>
                  <input disabled type="text" id="resend_email" class="form-control m-input" aria-describedby="basic-addon1">
                </div>
              </div>
            </div>
          </div>
          <br />
          <input type="hidden" name="redirect_url" value="<?php echo base_url(uri_string()) ?>">
          <input type="hidden" name="user_id" id="user_resend_id">
          <div class="modal-footer">
            <button type="button" class="btn btn-secondary" data-dismiss="modal">
              Close
            </button>
            <button class="btn btn-focus form_submit_btn" type="submit" name="submit">Confirm & Send</button>
          </div>
        </div>
      </div>
    </form>
  </div>
</div>
</div>
</div>





</div>
</div>
</div>
<!-- end:: Body -->
<!-- begin::Footer -->
<?php $this->view("modules/include_modals/modal_hr_department_add");?>
<?php $this->view("includes/Inc_footer"); ?>
<!-- end::Footer -->
</div>
<!-- end:: Page -->

<?php $this->view("includes/Inc_sidebar"); ?>
<?php $this->view("includes/Inc_scripts"); ?>
<!--begin::Page Snippets -->

<script>
$("#table_filter_status").selectpicker();
$("[data-switch=true]").bootstrapSwitch()
</script>

<script>
$("#user_menu").addClass('m-menu__item--active');

$("#duty_start_time_add").timepicker({
  defaultTime: "<?php echo date("h:i A", strtotime($this->config->item('HR_duty_start_time'))) ?>",
  minuteStep: 1,
})
$("#duty_end_time_add").timepicker({
  defaultTime: "<?php echo date("h:i A", strtotime($this->config->item('HR_duty_end_time'))) ?>",
  minuteStep: 1,
})

$("#user_role_add").select2({
  placeholder: "Select  Account Type",
  dropdownParent: $("#form_user_add")
})
$("#user_role_edit").select2({
  placeholder: "Select  Account Type",
  dropdownParent: $("#form_user_edit")
})

$("#project_area_add").select2({
  placeholder: "Select Area"
})
$("#project_area_edit").select2({
  placeholder: "Select Area"
})
$("#hr_department_add").select2({
  placeholder: "Select Department",
  dropdownParent: $("#form_user_add")
})
$("#hr_department_edit").select2({
  placeholder: "Select Department",
  dropdownParent: $("#form_user_edit")
})
$("#assigned_vehicles_add").select2({
  placeholder: "Select Vehicles",
  dropdownParent: $("#form_user_add")
})
$("#assigned_vehicles_edit").select2({
  placeholder: "Select Vehicles",
  dropdownParent: $("#form_user_edit")
})
function select_hr_department(select_id,selected_value='',department_id=''){
  $('#'+select_id).html('');
  $('#'+select_id).append("<option disabled selected >Select Department</option>");
  $.post("<?php echo base_url() ?>employees/select_departments_list",{id:department_id},function(data) {
    var obj = $.parseJSON(data);
    var i=0;
    if(obj.count>0) {
      while (i < obj.data.length) {
        $('#'+select_id).append("<option value=" + obj.data[i]['department_id'] + ">" + obj.data[i]['department_name'] + "</option>");
        i++;
      }
      if(selected_value!=''){
        $('#'+select_id).val(selected_value).trigger("change");
      }
    }
  })
}
select_hr_department('hr_department_add');
$('#hr_department_add').on("change", function(e) {
  var department = $('#hr_department_add :selected').val();
  if(department==1){
    $("#assigned_vehicle_add_div").show();
  }else{
    $("#assigned_vehicle_add_div").hide();
  }
});
$('#hr_department_edit').on("change", function(e) {
  var department = $('#hr_department_edit :selected').val();
  if(department==1){
    $("#assigned_vehicle_edit_div").show();
  }else{
    $("#assigned_vehicle_edit_div").hide();
  }
});
$('body').on('change', 'input[type=radio][name=basic_wage_type]', function() {
  var basic_wage_type = $("input[name='basic_wage_type']:checked").val();
  if(basic_wage_type=='Monthly'){
    $("#fixed_basic_wage_add_no").attr('disabled',false);
  }else{
    $("#fixed_basic_wage_add_no").attr('disabled',true);
  }
})
$('body').on('change', 'input[type=radio][name=fixed_basic_wage]', function() {
  var fixed_basic_wage = $("input[name='fixed_basic_wage']:checked").val();
  if(fixed_basic_wage==1){
    $("#fixed_basic_wage_add_info").text("*Yes = Worked Days Not Dependable");
  }else{
    $("#fixed_basic_wage_add_info").text("*No = Worked Days Dependable");
  }
})

$('body').on('change', 'input[type=radio][name=basic_wage_type_edit]', function() {
  var basic_wage_type = $("input[name='basic_wage_type_edit']:checked").val();
  if(basic_wage_type=='Monthly'){
    $("#fixed_basic_wage_edit_no").attr('disabled',false);
  }else{
    $("#fixed_basic_wage_edit_no").attr('disabled',true);
  }
})
$('body').on('change', 'input[type=radio][name=fixed_basic_wage_edit]', function() {
  var fixed_basic_wage = $("input[name='fixed_basic_wage_edit']:checked").val();
  if(fixed_basic_wage==1){
    $("#fixed_basic_wage_edit_info").text("*Yes = Worked Days Not Dependable");
  }else{
    $("#fixed_basic_wage_edit_info").text("*No = Worked Days Dependable");
  }
})
</script>
<script>
$('body').on('change', '#user_role_add', function() {
  var role = $('#user_role_add').val();
  if (role == '9') { //area Manager
    $("#project_area_div_add").show();
  } else {
    $("#project_area_div_add").hide();
  }
  if (role == '26') { //Driver
    select_hr_department('hr_department_add',1,1);
  }else{
    select_hr_department('hr_department_add');
  }

})
$('body').on('change', '#user_role_edit', function() {
  var role = $('#user_role_edit').val();
  if (role == '9') { //area Manager
    $("#project_area_div_edit").show();
  } else {
    $("#project_area_div_edit").hide();
  }
})

$('body').on('click', '#user_edit_btn', function() {
  var no = $(this).closest('tr').children('td');
  $('#user_role_edit').val(no.eq(19).text()).trigger('change');
  $('#update_user_name').val(no.eq(3).text());
  $('#update_mobile_number').val(no.eq(6).text());
  $('#update_employee_code').val(no.eq(4).text());
  $('#update_email').val(no.eq(5).text());

  $('#dob_edit').datepicker("setDate", no.eq(13).text());
  $('#address_edit').val(no.eq(14).text());

  $('#update_user_id').val(no.eq(0).text());
  $('#designation_edit').val(no.eq(8).text());
  $('#joined_date_edit').datepicker("setDate", no.eq(12).text());
  var duty_start_time = no.eq(20).text();
  if (duty_start_time == '' || duty_start_time == '00:00:00') {
    duty_start_time = "<?php echo date("h:i A", strtotime($this->config->item('HR_duty_start_time'))) ?>";
  }
  var duty_end_time = no.eq(21).text();
  if (duty_end_time == '' || duty_end_time == '00:00:00') {
    duty_end_time = "<?php echo date("h:i A", strtotime($this->config->item('HR_duty_end_time'))) ?>";
  }
  $("#duty_start_time_edit").val(duty_start_time);
  $("#duty_end_time_edit").val(duty_end_time);
  $("#duty_start_time_edit").timepicker({
    defaultTime: duty_start_time,
    minuteStep: 1,
  })
  $("#duty_end_time_edit").timepicker({
    defaultTime: duty_end_time,
    minuteStep: 1,
  })
  var status = no.eq(17).text();
  if (status == 1) {
    $('#acc_status_edit').bootstrapSwitch('state', true)
  } else {
    $('#acc_status_edit').bootstrapSwitch('state', false)
  }
  var role = no.eq(19).text();
  if (role == '9') { //area Manager
    $("#project_area_div_edit").show();
    var area_ids = (no.eq(22).text()).split(',');
    $('#project_area_edit').val(area_ids).trigger('change');
  } else {
    $("#project_area_div_edit").hide();
  }
})
$('body').on('click', '#user_delete_btn', function() {
  var no = $(this).closest('tr').children('td');
  $('#user_delete_id').val(no.eq(0).text());
})
$("#joined_date_add,#joined_date_edit,#dob_add,#dob_edit").datepicker({
  todayHighlight: !0,
  orientation: "bottom left",
  templates: {
    leftArrow: '<i class="la la-angle-left"></i>',
    rightArrow: '<i class="la la-angle-right"></i>'
  }
})
$("#joined_date_add,#joined_date_edit,#dob_add,#dob_edit").inputmask("dd-mm-yyyy");
select_user_account_counts();

function select_user_account_counts() {
  $.post("<?php echo base_url() . 'user/select_user_account_counts' ?>", {}, function(data) {
    var obj = $.parseJSON(data);
    $(".web_user_count").html(obj.created_user_count_webapp + "/" + obj.allowed_user_count_webapp);
    $(".mobile_user_count").html(obj.created_user_count_mobileapp + "/" + obj.allowed_user_count_mobileapp);
  })
}
</script>
<script>
function get_branch_id() {
  return $('#company_branch :selected').val();
}

var user_view_table = $('#user_view_table').DataTable({
  "ajax": {
    url: "<?php echo base_url() . 'user/select' ?>", // json datasource
    type: "post", // type of method  , by default would be get
    data: function(d) {
      <?php if (!empty($this->config->item('company_branches'))) { ?>
        d.branch_id = get_branch_id();
        <?php } ?>
      }
    },
    "bProcessing": true,
    "deferRender": true,
    "bDeferRender": true,
    "scrollX": true,
    buttons: [{
      extend: 'print',
      className: 'btn dark btn-outline',
      exportOptions: {
        columns: ':visible'
      },
      title: 'User Accounts'
    },
    {
      extend: 'csv',
      className: 'btn purple btn-outline '
    },
    {
      extend: 'colvis',
      className: 'btn dark btn-outline',
      text: 'Columns'
    }
  ],
  dom: "<'row'<'col-sm-6 text-left'B><'col-sm-6 text-right'f>>\n\t\t\t<'row'<'col-sm-12'tr>>\n\t\t\t<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 dataTables_pager'lp>>", // horizobtal scrollable datatable
  "lengthMenu": [
    [25, 50, 100, -1],
    [25, 50, 100, "All"] // change per page values here
  ],
  "columnDefs": [{
    "targets": [0, 17, 19, 20, 21, 22 <?php if ($this->session->userdata('user_role') == 'auditor') {
      echo ",18";
    } ?> <?php if (empty($this->config->item('company_branches'))) { echo ",2"; }?>
  ],
  className: "hidden"
}],
'order': false
});
$(".table_filter").on("change", function() {
  user_view_table.ajax.reload();
});
$(".hide_column").hide();
// Date Range Picker
var start = moment();
var end = moment();

function cb(start, end) {
  $('#table_filter_date_range').val(start.format('MMMM D, YYYY') + ' - ' + end.format('MMMM D, YYYY'));
  table.ajax.reload();
}
</script>
<script>
$('body').on('click', '#resend_email_btn', function() {
  var no = $(this).closest('tr').children('td');

  $('#user_resend_id').val(no.eq(0).text());
  $('#resend_name').val(no.eq(3).text());
  $('#resend_email').val(no.eq(5).text());
})
</script>
<script>
$(".form_submit_btn").click(function(e) {
  e.preventDefault();
  var a = $(this),
  l = $(this).closest("form"),
  action = l.attr('action');
  var form_id = l.attr('id');
  l.validate({
    rules: {
      email: {
        email: !0,
        required: !0
      }
    },
    invalidHandler: function(e, r) {
      var i = $("#" + form_id + "_msg");
      i.removeClass("m--hide").show(), mUtil.scrollTo(i, -200)
    },
    submitHandler: function(e) {}
  }), l.valid() && (a.addClass("m-loader m-loader--right m-loader--light").attr("disabled", !0),
  l.ajaxSubmit({
    url: action,
    beforeSend: function() {
      // Handle the beforeSend event
      // Block UI
      mApp.blockPage({
        overlayColor: "#000000",
        type: "loader",
        state: "success",
        message: "Please wait..."
      });

      mApp.block(".modal-content", {
        overlayColor: "#000000",
        type: "loader",
        state: "success",
        message: "Please wait..."
      });
    },

    success: function(e, t, r, s) {
      // UnBlock UI

      var modal_id = l.attr('data-modal-id');
      var form_type = l.attr('data-form-type');
      $("#" + form_id + "_msg").addClass("m--hide");


      var obj = $.parseJSON(e);
      if (obj.status == 1) {
        a.removeClass("m-loader m-loader--right m-loader--light").attr("disabled", !1);
        $("#" + modal_id).modal('toggle');
        $("." + form_id + "_fields").val('');
        $("." + form_id + "_select").val('').trigger("change");
        $("#duty_start_time_add").timepicker({
          defaultTime: "<?php echo date("H:i:s A", strtotime($this->config->item('HR_duty_start_time'))) ?>",
          minuteStep: 1,
        })
        $("#duty_end_time_add").timepicker({
          defaultTime: "<?php echo date("H:i:s A", strtotime($this->config->item('HR_duty_end_time'))) ?>",
          minuteStep: 1,
        })
        $('#acc_status_add').bootstrapSwitch('state', true)
        select_user_account_counts();
        user_view_table.ajax.reload();
        toastr[obj.flashdata_type](obj.flashdata_msg, obj.flashdata_title);
        var role = $('#user_role_add').val();
        if (role == '26') { //Driver
          select_hr_department('hr_department_add',1,1);
        }else{
          select_hr_department('hr_department_add');
        }
      } else {
        a.removeClass("m-loader m-loader--right m-loader--light").attr("disabled", !1);
        toastr[obj.flashdata_type](obj.flashdata_msg, obj.flashdata_title);
      }
      if (obj == null) {
        setTimeout(function() {
          a.removeClass("m-loader m-loader--right m-loader--light").attr("disabled", !1);
          toastr["warning"]("Your Attempt is Timed Out. Please Try Again.", "Timed Out");
        }, 2e4)
      }
    },
    error: function() {
      a.removeClass("m-loader m-loader--right m-loader--light").attr("disabled", !1);
      toastr["error"]("Sorry. There Has Been Some Error Occurred. Please Try Again.", "Error");
    },
    ajaxComplete: function() {
      mApp.unblockPage();
      mApp.unblock(".modal-content");
    },
    complete: function() {
      mApp.unblockPage();
      mApp.unblock(".modal-content");
    },
  })
)
});
</script>
