<?php $this->view("includes/Inc_pagehead"); ?>
<!-- Page Styles Goes Here-->

<?php $this->view("includes/Inc_navigation"); ?>
<div class="m-grid__item m-grid__item--fluid m-wrapper">
  <!-- BEGIN: Subheader -->
  <div class="m-subheader ">
    <div class="d-flex align-items-center">
      <div class="mr-auto">
        <h3 class="m-subheader__title m-subheader__title--separator">
          Salary Dates
        </h3>
        <ul class="m-subheader__breadcrumbs m-nav m-nav--inline">
          <li class="m-nav__item m-nav__item--home">
            <a href="#" class="m-nav__link m-nav__link--icon">
              <i class="m-nav__link-icon la la-home"></i>
            </a>
          </li>
          <li class="m-nav__separator">
            -
          </li>
          <li class="m-nav__item">
            <a href="<?php echo $this->session->userdata("dashboard_link") ?>" class="m-nav__link">
              <span class="m-nav__link-text">
                Home
              </span>
            </a>
          </li>
          <li class="m-nav__separator">
            -
          </li>
          <li class="m-nav__item">
            <a href="<?php echo base_url() . 'today_salary' ?>" class="m-nav__link">
              <span class="m-nav__link-text">
                Salary Dates
              </span>
            </a>
          </li>
        </ul>
      </div>
      <div>

      </div>
    </div>
  </div>
  <!-- END: Subheader -->
  <div class="m-content">
    <div class="m-portlet m-portlet--mobile m-portlet--info m-portlet--head-solid-bg m-portlet--bordered m-portlet--rounded">
      <div class="m-portlet__head">
        <div class="m-portlet__head-caption">
          <div class="m-portlet__head-title">
            <h3 class="m-portlet__head-text">
              List of Salary Dates of Users
            </h3>
          </div>
        </div>
        <div class="m-portlet__head-tools">

        </div>
      </div>
      <div class="m-portlet__body">
        <div class="m-form m-form--label-align-right m--margin-bottom-10">
          <div class="row align-items-center">
            <div class="col-xl-12 order-2 order-xl-1">
              <div class="form-group m-form__group row ">
                <div class="col-md-4">
                  <div class="m-form__group ">
                    <label>
                      Date:
                    </label>
                    <input id="table_filter_date_range" type="text" class="form-control m-input m-input--air m-input--pill">
                  </div>
                </div>

                <?php if (!empty($this->config->item('company_branches'))) { ?>

                  <div class="col-lg-4">
                    <div class="form-group m-form__group">
                      <label>
                        Company Branch
                      </label>
                      <div class="m-select2 m-select2--air m-select2--pill">
                        <select width="100%" required class="form-control m-select2 table_filter company-branch-select2" id="company_branch">
                          <option selected value="all"> All Branches</option>
                          <option value="0">NO BRANCH</option>
                          <?php foreach ($this->config->item('company_branches') as $key => $value) { ?>
                            <option value="<?php echo $value->branch_id ?>"><?php echo $value->branch_name ?></option>
                          <?php } ?>
                        </select>
                      </div>
                      <span class="m-form__help"></span>
                    </div>
                  </div>

                <?php } ?>

              </div>
            </div>

          </div>
        </div>



        <!--begin: Datatable -->
        <table width="100%" class="table m-table nowrap table-header-fixed table-striped table-bordered table-hover table-header-fixed" id="today_salary_view_table">
          <thead>
            <tr class="">
              <th>Sl No</th>
              <th>Branch Name</th>
              <th>User</th>
              <th>Joined Date</th>
              <th>Salary Day</th>
              <th>Actions</th>
            </tr>
          </thead>
          <tbody>
          </tbody>
        </table>
        <!--end: Datatable -->
      </div>
    </div>
  </div>

</div>
</div>
<!-- end:: Body -->
<!-- begin::Footer -->

<?php $this->view("includes/Inc_footer"); ?>
<!-- end::Footer -->
</div>
<!-- end:: Page -->

<?php $this->view("includes/Inc_sidebar"); ?>
<?php $this->view("includes/Inc_scripts"); ?>

<script>
  $("#user_today_salary_menu").addClass('m-menu__item--active');
</script>
<script>
  function GetSearchDate() {
    return $('#table_filter_date_range').val();
  }

  function GetSearchWork() {
    return $('#table_filter_work').val();
  }

  function get_branch_id() {
    return $('#company_branch :selected').val();
  }
  var today_salary_view_table = $('#today_salary_view_table').DataTable({
    "ajax": {
      url: "<?php echo base_url() . 'user/select_today_salary' ?>", // json datasource
      type: "post", // type of method  , by default would be get
      data: function(d) {
        d.date = GetSearchDate();
        <?php if (!empty($this->config->item('company_branches'))) { ?>
          d.branch_id = get_branch_id();
        <?php } ?>
      }
    },
    "bProcessing": true,
    "deferRender": true,
    "bDeferRender": true,
    "scrollX": true,
    buttons: [{
        extend: 'print',
        className: 'btn dark btn-outline',
        exportOptions: {
          columns: ':visible'
        },
        title: 'Today Salary'
      },
      {
        extend: 'csv',
        className: 'btn purple btn-outline '
      },
      {
        extend: 'colvis',
        className: 'btn dark btn-outline',
        text: 'Columns'
      }
    ],
    dom: "<'row'<'col-sm-6 text-left'B><'col-sm-6 text-right'f>>\n\t\t\t<'row'<'col-sm-12'tr>>\n\t\t\t<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 dataTables_pager'lp>>", // horizobtal scrollable datatable
    "lengthMenu": [
      [25, 50, 100, -1],
      [25, 50, 100, "All"] // change per page values here
    ],
    'order': false,
    "columnDefs": [{
      "targets": [<?php if (empty($this->config->item('company_branches'))) {
                    echo ",1";
                  } ?>],
      className: "hidden"
    }]
  });
  $(".table_filter").on("change", function() {
    today_salary_view_table.ajax.reload();
  });
  $(".hide_column").hide();


  var start = moment();
  var end = moment();

  function cb(start, end) {
    $('#table_filter_date_range').val(start.format('MMMM D, YYYY') + ' - ' + end.format('MMMM D, YYYY'));
    today_salary_view_table.ajax.reload();
  }

  $('#table_filter_date_range').daterangepicker({
    buttonClasses: "m-btn btn",
    applyClass: "btn-primary",
    cancelClass: "btn-secondary",
    startDate: start,
    endDate: end,
    locale: {
      format: 'MMMM D, YYYY'
    },
    ranges: {
      'Today': [moment(), moment()],
      'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
      'Last 7 Days': [moment().subtract(6, 'days'), moment()],
      'Last 30 Days': [moment().subtract(29, 'days'), moment()],
      'This Month': [moment().startOf('month'), moment().endOf('month')],
      'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')],
      'All time': [moment('1970-01-01'), moment().add(9999, 'days')],
    }
  }, cb);

  cb(start, end);
</script>
