<?php $this->view("includes/Inc_pagehead"); ?>
<!-- Page Styles Goes Here-->

<?php $this->view("includes/Inc_navigation"); ?>
<div class="m-grid__item m-grid__item--fluid m-wrapper">
  <!-- BEGIN: Subheader -->
  <div class="m-subheader ">
    <div class="d-flex align-items-center">
      <div class="mr-auto">
        <h3 class="m-subheader__title m-subheader__title--separator">
          Manage User Leave Applications
        </h3>
        <ul class="m-subheader__breadcrumbs m-nav m-nav--inline">
          <li class="m-nav__item m-nav__item--home">
            <a href="#" class="m-nav__link m-nav__link--icon">
              <i class="m-nav__link-icon la la-home"></i>
            </a>
          </li>
          <li class="m-nav__separator">
            -
          </li>
          <li class="m-nav__item">
            <a href="<?php echo $this->session->userdata("dashboard_link") ?>" class="m-nav__link">
              <span class="m-nav__link-text">
                Users
              </span>
            </a>
          </li>
          <li class="m-nav__separator">
            -
          </li>
          <li class="m-nav__item">
            <a href="<?php echo base_url() . 'users/levae_applications' ?>" class="m-nav__link">
              <span class="m-nav__link-text">
                User Leave Applications
              </span>
            </a>
          </li>


        </ul>
      </div>
      <div>

      </div>
    </div>
  </div>
  <!-- END: Subheader -->
  <div class="m-content">
    <div class="m-portlet m-portlet--mobile m-portlet--info m-portlet--head-solid-bg m-portlet--bordered m-portlet--rounded">
      <div class="m-portlet__head">
        <div class="m-portlet__head-caption">
          <div class="m-portlet__head-title">
            <h3 class="m-portlet__head-text">
              List of User Leave Applications
            </h3>
          </div>
        </div>
        <div class="m-portlet__head-tools">
          <a href="#" data-toggle="modal" data-target="#leave_application_add_modal" class="btn btn-focus m-btn m-btn--custom m-btn--icon m-btn--air m-btn--pill">
            <span>
              <i class="la la-plus"></i>
              <span>
                Create New Leave Application
              </span>
            </span>
          </a>
        </div>
      </div>
      <div class="m-portlet__body">
        <div class="m-form m-form--label-align-right m--margin-bottom-10">
          <div class="row align-items-center">
            <div class="col-xl-12 order-2 order-xl-1">
              <div class="form-group m-form__group row align-items-center">
              </div>
            </div>
          </div>
        </div>
        <?php if (!empty($this->config->item('company_branches'))) { ?>
          <div class="col-lg-4">
            <div class="form-group m-form__group">
              <label>
                Company Branch
              </label>
              <div class="m-select2 m-select2--air m-select2--pill">
                <select width="100%" required class="form-control m-select2 table_filter company-branch-select2" id="company_branch">
                  <option selected value="all"> All Branches</option>
                  <option value="0">NO BRANCH</option>
                  <?php foreach ($this->config->item('company_branches') as $key => $value) { ?>
                    <option value="<?php echo $value->branch_id ?>"><?php echo $value->branch_name ?></option>
                  <?php } ?>
                </select>
              </div>
              <span class="m-form__help"></span>
            </div>
          </div>
        <?php } ?>

        <!--begin: Datatable -->
        <table width="100%" class="table m-table nowrap table-header-fixed table-striped table-bordered table-hover table-header-fixed" id="leave_applications_view_table">
          <thead>
            <tr class="">
              <th>ID</th>
              <th>Sl No</th>
              <th>Branch Name</th>
              <th>User Name</th>
              <th>Role</th>
              <th>Leave Date</th>
              <th>Leave Type</th>
              <th>Reason</th>
              <th>Approval Status</th>
              <th>Approval Remarks</th>
              <th>Created On</th>
              <th>Actions</th>
              <th style="display: none">status</th>
              <th>Leave Type</th>
            </tr>
          </thead>
          <tbody>
          </tbody>
        </table>
        <!--end: Datatable -->
        <div class="modal fade" tabindex="-1" id="leave_application_add_modal" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
          <div class="modal-dialog " role="document" style="max-width: 800px">
            <div class="modal-content">
              <div class="modal-header" style="background-color: #36a3f7;border-radius: 4px">
                <h5 class="modal-title" id="exampleModalLabel" style="color: #ffffff">
                  Add Leave Application
                </h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                  <span aria-hidden="true">
                    &times;
                  </span>
                </button>
              </div>
              <form autocomplete="off" data-modal-id="leave_application_add_modal" id="form_leave_application_add" method="post" action="<?php echo base_url() . 'user/update_leave_application' ?>" enctype="multipart/form-data" class="form m-form m-form--fit m-form--state m-form--label-align-right ">
                <div class="modal-body">
                  <div class="m-form__content">
                    <div class="m-alert m-alert--icon alert alert-warning m--hide" role="alert" id="form_leave_application_add_msg">
                      <div class="m-alert__icon">
                        <i class="la la-warning"></i>
                      </div>
                      <div class="m-alert__text">
                        Oh snap! Change a few things up and try submitting again.
                      </div>
                      <div class="m-alert__close">
                        <button type="button" class="close" data-close="alert" aria-label="Close"></button>
                      </div>
                    </div>
                  </div>
                  <div class="row">
                    <div class="col-lg-6">
                      <div class="form-group m-form__group">
                        <label for="leave_application_name">
                          Name of User
                        </label>
                        <div class="input-group m-input-group m-input-group--pill m-input-group--air">
                          <div class="input-group-prepend">
                            <span class="input-group-text" id="basic-addon1">
                              <i class="la la-user"></i>
                            </span>
                          </div>
                          <input readonly type="text" id="user_name_add" class="form-control m-input form_leave_application_add_fields" placeholder="Name of User" aria-describedby="basic-addon1">
                        </div>
                        <span class="m-form__help"></span>
                      </div>
                    </div>
                    <div class="col-lg-6">
                      <div class="form-group m-form__group">
                        <label for="leave_application_name">
                          Role
                        </label>
                        <div class="input-group m-input-group m-input-group--pill m-input-group--air">
                          <div class="input-group-prepend">
                            <span class="input-group-text" id="basic-addon1">
                              <i class="la la-user"></i>
                            </span>
                          </div>
                          <input readonly type="text" id="user_role_add" class="form-control m-input form_leave_application_add_fields" placeholder="Name of User" aria-describedby="basic-addon1">
                        </div>
                        <span class="m-form__help"></span>
                      </div>
                    </div>
                  </div>
                  <div class="row">
                    <div class="col-lg-6">
                      <div class="form-group m-form__group">
                        <label for="leave_application_name">
                          Leave Date
                        </label>
                        <div class="input-group m-input-group m-input-group--pill m-input-group--air">
                          <div class="input-group-prepend">
                            <span class="input-group-text" id="basic-addon1">
                              <i class="la la-edit"></i>
                            </span>
                          </div>
                          <input readonly type="text" id="leave_date_add" class="form-control m-input form_leave_application_add_fields" placeholder="Phone Number" aria-describedby="basic-addon1">
                        </div>
                        <span class="m-form__help"></span>
                      </div>
                    </div>
                    <div class="col-lg-6">
                      <div class="form-group m-form__group">
                        <label for="leave_application_name">
                          Reason
                        </label>
                        <div class="input-group m-input-group m-input-group--pill m-input-group--air">
                          <div class="input-group-prepend">
                            <span class="input-group-text" id="basic-addon1">
                              <i class="la la-edit"></i>
                            </span>
                          </div>
                          <input readonly type="text" id="reason_add" class="form-control m-input form_leave_application_add_fields" placeholder="Email ID" aria-describedby="basic-addon1">
                        </div>
                        <span class="m-form__help"></span>
                      </div>
                    </div>
                  </div>
                  <input type="hidden" name="leave_application_id" id="update_leave_application_id">
                  <div class="row">
                    <div class="col-lg-6">
                      <div class="form-group m-form__group">
                        <label for="leave_application_name">
                          Application Status
                        </label>
                        <div class="m-radio-inline" style="padding-top: 10px;">
                          <label class="m-radio m-radio--solid m-radio--state-success">
                            <input required type="radio" class="form_fields_radio" name="leave_application_status" value="1"> Approved
                            <span></span>
                          </label>
                          <label class="m-radio m-radio--solid m-radio--state-danger">
                            <input type="radio" class="form_fields_radio" name="leave_application_status" value="2"> Rejected
                            <span></span>
                          </label>
                        </div>
                        <span class="m-form__help"></span>
                      </div>
                    </div>
                    <div class="col-lg-6">
                      <div class="form-group m-form__group">
                        <label for="leave_application_name">
                          Approval Remarks
                        </label>
                        <div class="input-group m-input-group m-input-group--pill m-input-group--air">
                          <div class="input-group-prepend">
                            <span class="input-group-text" id="basic-addon1">
                              <i class="la la-tag"></i>
                            </span>
                          </div>
                          <input type="text" name="remarks" id="approval_remarks_add" class="form-control m-input form_leave_application_add_fields" placeholder="Remarks" aria-describedby="basic-addon1">
                        </div>
                        <span class="m-form__help"></span>
                      </div>
                    </div>
                  </div>
                </div>
                <div class="modal-footer">
                  <button type="button" class="btn btn-secondary " data-dismiss="modal">
                    Close
                  </button>
                  <button type="submit" class="btn btn-primary form_submit_btn">
                    Submit
                  </button>
                </div>
              </form>
            </div>
          </div>
        </div>
        <div class="modal fade" tabindex="-1" id="leave_application_edit_modal" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
          <div class="modal-dialog " role="document" style="max-width: 800px">
            <div class="modal-content">
              <div class="modal-header" style="background-color: #36a3f7;border-radius: 4px">
                <h5 class="modal-title" id="exampleModalLabel" style="color: #ffffff">
                  Edit Leave Application
                </h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                  <span aria-hidden="true">
                    &times;
                  </span>
                </button>
              </div>
              <form autocomplete="off" data-modal-id="leave_application_edit_modal" id="form_leave_application_edit" method="post" action="<?php echo base_url() . 'user/update_leave_application' ?>" enctype="multipart/form-data" class="form m-form m-form--fit m-form--state m-form--label-align-right ">
                <div class="modal-body">
                  <div class="m-form__content">
                    <div class="m-alert m-alert--icon alert alert-warning m--hide" role="alert" id="form_leave_application_edit_msg">
                      <div class="m-alert__icon">
                        <i class="la la-warning"></i>
                      </div>
                      <div class="m-alert__text">
                        Oh snap! Change a few things up and try submitting again.
                      </div>
                      <div class="m-alert__close">
                        <button type="button" class="close" data-close="alert" aria-label="Close"></button>
                      </div>
                    </div>
                  </div>
                  <div class="row">
                    <div class="col-lg-6">
                      <div class="form-group m-form__group">
                        <label for="leave_application_name">
                          Name of User
                        </label>
                        <div class="input-group m-input-group m-input-group--pill m-input-group--air">
                          <div class="input-group-prepend">
                            <span class="input-group-text" id="basic-addon1">
                              <i class="la la-user"></i>
                            </span>
                          </div>
                          <input readonly type="text" id="user_name_edit" class="form-control m-input form_leave_application_edit_fields" placeholder="Name of User" aria-describedby="basic-addon1">
                        </div>
                        <span class="m-form__help"></span>
                      </div>
                    </div>
                    <div class="col-lg-6">
                      <div class="form-group m-form__group">
                        <label for="leave_application_name">
                          Role
                        </label>
                        <div class="input-group m-input-group m-input-group--pill m-input-group--air">
                          <div class="input-group-prepend">
                            <span class="input-group-text" id="basic-addon1">
                              <i class="la la-user"></i>
                            </span>
                          </div>
                          <input readonly type="text" id="user_role_edit" class="form-control m-input form_leave_application_edit_fields" placeholder="Name of User" aria-describedby="basic-addon1">
                        </div>
                        <span class="m-form__help"></span>
                      </div>
                    </div>
                  </div>
                  <div class="row">
                    <div class="col-lg-6">
                      <div class="form-group m-form__group">
                        <label for="leave_application_name">
                          Leave Date
                        </label>
                        <div class="input-group m-input-group m-input-group--pill m-input-group--air">
                          <div class="input-group-prepend">
                            <span class="input-group-text" id="basic-addon1">
                              <i class="la la-edit"></i>
                            </span>
                          </div>
                          <input readonly type="text" id="leave_date_edit" class="form-control m-input form_leave_application_edit_fields" placeholder="Phone Number" aria-describedby="basic-addon1">
                        </div>
                        <span class="m-form__help"></span>
                      </div>
                    </div>
                    <div class="col-lg-6">
                      <div class="form-group m-form__group">
                        <label for="leave_application_name">
                          Reason
                        </label>
                        <div class="input-group m-input-group m-input-group--pill m-input-group--air">
                          <div class="input-group-prepend">
                            <span class="input-group-text" id="basic-addon1">
                              <i class="la la-edit"></i>
                            </span>
                          </div>
                          <input readonly type="text" id="reason_edit" class="form-control m-input form_leave_application_edit_fields" placeholder="Email ID" aria-describedby="basic-addon1">
                        </div>
                        <span class="m-form__help"></span>
                      </div>
                    </div>
                  </div>
                  <input type="hidden" name="leave_application_id" id="update_leave_application_id">
                  <div class="row">
                    <div class="col-lg-6">
                      <div class="form-group m-form__group">
                        <label for="leave_application_name">
                          Application Status
                        </label>
                        <div class="m-radio-inline" style="padding-top: 10px;">
                          <label class="m-radio m-radio--solid m-radio--state-success">
                            <input required type="radio" class="form_fields_radio" name="leave_application_status" value="1"> Approved
                            <span></span>
                          </label>
                          <label class="m-radio m-radio--solid m-radio--state-danger">
                            <input type="radio" class="form_fields_radio" name="leave_application_status" value="2"> Rejected
                            <span></span>
                          </label>
                        </div>
                        <span class="m-form__help"></span>
                      </div>
                    </div>
                    <div class="col-lg-6">
                      <div class="form-group m-form__group">
                        <label for="leave_application_name">
                          Approval Remarks
                        </label>
                        <div class="input-group m-input-group m-input-group--pill m-input-group--air">
                          <div class="input-group-prepend">
                            <span class="input-group-text" id="basic-addon1">
                              <i class="la la-tag"></i>
                            </span>
                          </div>
                          <input type="text" name="remarks" id="approval_remarks_edit" class="form-control m-input form_leave_application_edit_fields" placeholder="Remarks" aria-describedby="basic-addon1">
                        </div>
                        <span class="m-form__help"></span>
                      </div>
                    </div>
                  </div>
                  <input type="hidden" id="leave_application_id_edit" name="leave_application_id" />
                </div>
                <div class="modal-footer">
                  <button type="button" class="btn btn-secondary " data-dismiss="modal">
                    Close
                  </button>
                  <button type="submit" class="btn btn-primary form_submit_btn">
                    Submit
                  </button>
                </div>
              </form>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>
</div>
<!-- end:: Body -->
<!-- begin::Footer -->

<?php $this->view("includes/Inc_footer"); ?>
<!-- end::Footer -->
</div>
<!-- end:: Page -->

<?php $this->view("includes/Inc_sidebar"); ?>
<?php $this->view("includes/Inc_scripts"); ?>
<!--begin::Page Snippets -->

<script>
  $("#table_filter_status").selectpicker();
  $("[data-switch=true]").bootstrapSwitch()
</script>

<script>
  $("#leave_applications_menu").addClass('m-menu__item--active');
</script>
<script>
  $('body').on('click', '#leave_application_edit_btn', function() {
    var no = $(this).closest('tr').children('td');
    $('#leave_application_id_edit').val(no.eq(0).text());
    $('#user_role_edit').val(no.eq(4).text());
    $('#user_name_edit').val(no.eq(3).text());
    $('#leave_date_edit').val(no.eq(5).text());
    $('#reason_edit').val(no.eq(7).text());
    $('#approval_remarks_edit').val(no.eq(9).text());
    var status = no.eq(12).text();
    $("input[name=leave_application_status][value=" + status + "]").prop('checked', true);

  })
</script>
<script>
  function get_branch_id() {
    return $('#company_branch :selected').val();
  }

  var leave_applications_view_table = $('#leave_applications_view_table').DataTable({
    "ajax": {
      url: "<?php echo base_url() . 'user/select_leave_applications' ?>", // json datasource
      type: "post", // type of method  , by default would be get
      data: function(d) {
        <?php if (!empty($this->config->item('company_branches'))) { ?>
          d.branch_id = get_branch_id();
        <?php } ?>
      }
    },
    "bProcessing": true,
    "deferRender": true,
    "bDeferRender": true,
    "scrollX": true,
    buttons: [{
        extend: 'print',
        className: 'btn dark btn-outline',
        exportOptions: {
          columns: ':visible'
        },
        title: 'Leave Applications'
      },
      {
        extend: 'csv',
        className: 'btn purple btn-outline '
      },
      {
        extend: 'colvis',
        className: 'btn dark btn-outline',
        text: 'Columns'
      }
    ],
    dom: "<'row'<'col-sm-6 text-left'B><'col-sm-6 text-right'f>>\n\t\t\t<'row'<'col-sm-12'tr>>\n\t\t\t<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 dataTables_pager'lp>>", // horizobtal scrollable datatable
    "lengthMenu": [
      [25, 50, 100, -1],
      [25, 50, 100, "All"] // change per page values here
    ],
    "columnDefs": [{
      "targets": [0, 12,13 <?php if ($this->session->userdata('user_role') == 'auditor') {
                          echo ",10";
                        } ?> <?php if (empty($this->config->item('company_branches'))) { echo ",2"; }?>
                      ],
      className: "hidden"
    }],
    'order': false
  });
  $(".table_filter").on("change", function() {
    leave_applications_view_table.ajax.reload();
  });
  $(".hide_column").hide();
</script>

<script>
  $(".form_submit_btn").click(function(e) {
    e.preventDefault();
    var a = $(this),
      l = $(this).closest("form"),
      action = l.attr('action');
    var form_id = l.attr('id');
    l.validate({
      rules: {
        email: {
          email: !0,
          required: !0
        }
      },
      invalidHandler: function(e, r) {
        var i = $("#" + form_id + "_msg");
        i.removeClass("m--hide").show(), mUtil.scrollTo(i, -200)
      },
      submitHandler: function(e) {}
    }), l.valid() && (a.addClass("m-loader m-loader--right m-loader--light").attr("disabled", !0),
      l.ajaxSubmit({
        url: action,
        beforeSend: function() {
          // Handle the beforeSend event
          // Block UI
          mApp.blockPage({
            overlayColor: "#000000",
            type: "loader",
            state: "success",
            message: "Please wait..."
          });

          mApp.block(".modal-content", {
            overlayColor: "#000000",
            type: "loader",
            state: "success",
            message: "Please wait..."
          });
        },

        success: function(e, t, r, s) {
          // UnBlock UI

          var modal_id = l.attr('data-modal-id');
          var form_type = l.attr('data-form-type');
          $("#" + form_id + "_msg").addClass("m--hide");


          var obj = $.parseJSON(e);
          if (obj.status == 1) {
            a.removeClass("m-loader m-loader--right m-loader--light").attr("disabled", !1);
            $("#" + modal_id).modal('toggle');
            $("." + form_id + "_fields").val('');
            $("." + form_id + "_select").val('').trigger("change");

            leave_applications_view_table.ajax.reload();
            toastr[obj.flashdata_type](obj.flashdata_msg, obj.flashdata_title);
          } else {
            a.removeClass("m-loader m-loader--right m-loader--light").attr("disabled", !1);
            toastr[obj.flashdata_type](obj.flashdata_msg, obj.flashdata_title);
          }
          if (obj == null) {
            setTimeout(function() {
              a.removeClass("m-loader m-loader--right m-loader--light").attr("disabled", !1);
              toastr["warning"]("Your Attempt is Timed Out. Please Try Again.", "Timed Out");
            }, 2e4)
          }
        },
        error: function() {
          a.removeClass("m-loader m-loader--right m-loader--light").attr("disabled", !1);
          toastr["error"]("Sorry. There Has Been Some Error Occurred. Please Try Again.", "Error");
        },
        ajaxComplete: function() {
          mApp.unblockPage();
          mApp.unblock(".modal-content");
        },
        complete: function() {
          mApp.unblockPage();
          mApp.unblock(".modal-content");
        },
      })
    )
  });
</script>
