<?php $this->view("includes/Inc_pagehead");?>
<!-- Page Styles Goes Here-->

<?php $this->view("includes/Inc_navigation");?>
<div class="m-grid__item m-grid__item--fluid m-wrapper">
  <!-- BEGIN: Subheader -->
  <div class="m-subheader ">
    <div class="d-flex align-items-center">
      <div class="mr-auto">
        <h3 class="m-subheader__title m-subheader__title--separator">
          Travel Allowance
        </h3>
        <ul class="m-subheader__breadcrumbs m-nav m-nav--inline">
          <li class="m-nav__item m-nav__item--home">
            <a href="#" class="m-nav__link m-nav__link--icon">
              <i class="m-nav__link-icon la la-home"></i>
            </a>
          </li>
          <li class="m-nav__separator">
            -
          </li>
          <li class="m-nav__item">
            <a href="<?php echo base_url().'dashboard'?>" class="m-nav__link">
              <span class="m-nav__link-text">
                Home
              </span>
            </a>
          </li>
          <li class="m-nav__separator">
            -
          </li>
          <li class="m-nav__item">
            <a href="<?php echo base_url().'travel_allowance' ?>" class="m-nav__link">
              <span class="m-nav__link-text">
                Travel Allowance
              </span>
            </a>
          </li>


        </ul>
      </div>
      <div>

      </div>
    </div>
  </div>
  <!-- END: Subheader -->
  <div class="m-content">
    <div class="m-portlet m-portlet--mobile m-portlet--info m-portlet--head-solid-bg m-portlet--bordered m-portlet--rounded">
      <div class="m-portlet__body">
        <div class="m-form m-form--label-align-right m--margin-bottom-10">
          <div class="row">
            <div class="col-md-3">
              <div class="form-group m-form__group">
                <label >
                  TA Date:
                </label>
                <input style="border: none" id="date_range"  type="text" class="form-control  m-input--solid m-input "  >
              </div>
            </div>
            <div class="col-md-9">
              <div class="row">
                <div class="col-md-3">
                  <div class="form-group m-form__group">
                    <label>
                      Vehicle Type:
                    </label>
                    <div class="m-select2 m-select2--air m-select2--pill">
                      <select style="width: 100%" class="form-control m-select2 table_filter" id="ta_vehicle_type_filter"  name="" data-placeholder="Select Tool Category">
                        <option selected value="all">All</option>
                        <?php foreach($ta_vehicles as $value ) { ?>
                          <option value="<?php echo $value['type'] ?>" data-fixed-rate="<?php echo $value['fixed_rate'] ?>" data-rate="<?php echo $value['rate'] ?>"><?php echo $value['type'] ?></option>
                        <?php } ?>
                      </select>
                    </div>
                    <span class="m-form__help"></span>
                  </div>
                </div>
                <div class="col-md-3">
                  <div class="form-group m-form__group">
                    <label>
                      Employee :
                    </label>
                    <div class="m-select2 m-select2--air m-select2--pill">
                      <select style="width: 100%" class="form-control m-select2 table_filter" id="employee_filter"  name="" data-placeholder="Select Tool">
                        <option selected value="all">All</option>
                        <?php foreach($employees as $row) { ?>
                          <option value="<?php echo $row->employee_id ?>"><?php echo $row->employee_name ?></option>
                        <?php } ?>
                      </select>
                    </div>
                    <span class="m-form__help"></span>
                  </div>
                </div>
                <?php if($this->config->item('app_module_vehicle_management')==1){ ?>
                  <div class="col-lg-3">
                    <div class="form-group m-form__group">
                      <label for="user_name">
                        Vehicle
                      </label>
                      <div class="m-select2 m-select2--air m-select2--pill">
                        <select style="width: 100%" class="form-control m-select2 table_filter" id="vehicle_filter"  data-placeholder="Select Vehicle">

                        </select>
                      </div>
                      <span class="m-form__help"></span>
                    </div>
                  </div>
                <?php } ?>
                <div class="col-lg-3">
                  <div class="form-group m-form__group">
                    <label for="user_name">
                      Project / Office
                    </label>
                    <div class="m-select2 m-select2--air m-select2--pill">
                      <select required style="width: 100%" class="form-control m-select2 table_filter" id="project_filter" data-placeholder="Select Project">
                        <option selected value="all">All</option>
                        <option value="0">Office Expense</option>
                        <?php
                        foreach($work_contracts as $row): ?>
                        <option data-work-status="<?php echo $row->work_status?>" value="<?php echo $row->work_id?>"><?php echo $row->work_name?></option>
                        <?php
                      endforeach;
                      ?>
                    </select>
                  </div>
                  <span class="m-form__help"></span>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
  <div class="m-portlet m-portlet--mobile m-portlet--info m-portlet--head-solid-bg m-portlet--bordered m-portlet--rounded">
    <div class="m-portlet__head">
      <div class="m-portlet__head-caption">
        <div class="m-portlet__head-title">
          <h3 class="m-portlet__head-text">
            List of Travel Allowance
          </h3>
        </div>
      </div>
      <div class="m-portlet__head-tools" >
        <?php if($this->session->userdata('user_role')!='auditor' || $this->session->userdata('user_data_permission')['adding']==1) { ?>
          <a href="#" data-toggle="modal" data-target="#ta_add_modal" class="btn btn-focus m-btn m-btn--custom m-btn--icon m-btn--air m-btn--pill">
            <span>
              <i class="la la-plus"></i>
              <span>
                Add New TA
              </span>
            </span>
          </a>
        <?php } ?>
      </div>
    </div>
    <div class="m-portlet__body">
      <?php $this->view("modules/include_tables/table_travel_allowance");?>
    </div>
  </div>
  <div class="m-portlet m-portlet--mobile m-portlet--focus m-portlet--head-solid-bg m-portlet--bordered m-portlet--rounded">
    <div class="m-portlet__head">
      <div class="m-portlet__head-caption">
        <div class="m-portlet__head-title">
          <h3 class="m-portlet__head-text">
            Travel Allowance Summary
          </h3>
        </div>
      </div>
    </div>
    <div class="m-portlet__body">
      <?php $this->view("modules/include_tables/table_travel_allowance_summary");?>
    </div>
  </div>
</div>

<div class="modal fade" tabindex="-1" id="ta_add_modal" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog " role="document" style="max-width: 800px">
    <div class="modal-content">
      <div class="modal-header" style="background-color: #36a3f7;border-radius: 4px">
        <h5 class="modal-title" id="exampleModalLabel" style="color: #ffffff" >
          Add New TA
        </h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">
            &times;
          </span>
        </button>
      </div>
      <!--                                                    ADD EXPENSE DATA start-->
      <form autocomplete="off" id="form_ta_add" data-modal-id="ta_add_modal" method="post" action="<?php echo base_url().'travel_allowance/create_ta'?>" enctype="multipart/form-data" class="m-form m-form--fit m-form--state m-form--label-align-right " >
        <div class="modal-body">
          <div class="m-form__content">
            <div class="m-alert m-alert--icon alert alert-warning m--hide" role="alert" id="form_ta_add_msg">
              <div class="m-alert__icon">
                <i class="la la-warning"></i>
              </div>
              <div class="m-alert__text">
                Oh snap! Change a few things up and try submitting again.
              </div>
              <div class="m-alert__close">
                <button type="button" class="close" data-close="alert" aria-label="Close"></button>
              </div>
            </div>
          </div>
          <div class="row">
            <?php if($this->session->userdata('user_role')=='admin' || $this->session->userdata('user_role')=='madmin' || $this->session->userdata('user_role')=='general_manager'){?>
              <div class="col-lg-4">
                <div class="form-group m-form__group">
                  <label for="user_name">
                    Employee
                  </label>
                  <div class="m-select2 m-select2--air m-select2--pill">
                    <select required style="width: 100%" class="form-control m-select2 form_ta_add_select" id="ta_employee_id"  name="employee_id" data-placeholder="Select User">
                      <option selected disabled>Select Employee</option>
                      <?php foreach($employees as $row) { ?>
                        <option value="<?php echo $row->employee_id ?>"><?php echo $row->employee_name ?></option>
                      <?php } ?>
                    </select>
                  </div>
                  <span class="m-form__help"></span>
                </div>
              </div>
            <?php } else{ ?>
              <input type="hidden" name="ta_employee_id" value="<?php echo $this->session->userdata('user_id') ?>"  />
            <?php } ?>
            <div class="col-lg-4">
              <div class="form-group m-form__group">
                <label for="user_name">
                  Vehicle Type
                </label>
                <div class="m-select2 m-select2--air m-select2--pill">
                  <select required style="width: 100%" class="form-control m-select2 form_ta_add_select" id="ta_vehicle_type"  name="vehicle_type" data-placeholder="Select Vehicle type">
                    <option selected disabled>Select Vehicle Type</option>
                    <?php foreach($ta_vehicles as $value ) { ?>
                      <option value="<?php echo $value['type'] ?>" data-fixed-rate="<?php echo $value['fixed_rate'] ?>" data-rate="<?php echo $value['rate'] ?>"><?php echo $value['type'] ?></option>
                    <?php } ?>
                  </select>
                </div>
                <span class="m-form__help"></span>
              </div>
            </div>
            <?php if($this->session->userdata('user_role')=='admin' || $this->session->userdata('user_role')=='madmin' || $this->session->userdata('user_role')=='general_manager' || $this->config->item('User_ta_date_selection_enable')==1){?>
              <div class="col-lg-4">
                <div class="form-group m-form__group" >
                  <label for="user_name">
                    TA Date
                  </label>
                  <div class="input-group m-input-group m-input-group--pill m-input-group--air">
                    <input data-date-format="dd-mm-yyyy" value="<?php echo date('d-m-Y')?>" required type="text" name="ta_date" id="ta_date_add"  class="form-control m-input form_ta_add_fields" placeholder="TA Date" aria-describedby="basic-addon1">
                  </div>
                  <span class="m-form__help"></span>
                </div>
              </div>
            <?php } ?>
          </div>
          <div class="row">
            <?php if($this->config->item('app_module_vehicle_management')==1){ ?>
              <div class="col-lg-6">
                <div class="form-group m-form__group">
                  <label for="user_name">
                    Vehicle
                  </label>
                  <div class="m-select2 m-select2--air m-select2--pill">
                    <select style="width: 100%" class="form-control m-select2 form_ta_add_select" id="ta_vehicle"  name="vehicle" data-placeholder="Select Vehicle">
                      <option selected disabled>Select Vehicle</option>
                    </select>
                  </div>
                  <span class="m-form__help"></span>
                </div>
              </div>
            <?php } ?>
            <div class="col-lg-6">
              <div class="form-group m-form__group">
                <label for="user_name">
                  Project / Office
                </label>
                <div class="m-select2 m-select2--air m-select2--pill">
                  <select required style="width: 100%" class="form-control m-select2 form_ta_add_select" id="ta_project"  name="project" data-placeholder="Select Project">
                    <option selected value="0">Office Expense</option>
                    <?php
                    foreach($work_contracts as $row): ?>
                    <option data-work-status="<?php echo $row->work_status?>" value="<?php echo $row->work_id?>"><?php echo $row->work_name?></option>
                    <?php
                  endforeach;
                  ?>
                </select>
              </div>
              <span class="m-form__help"></span>
            </div>
          </div>
        </div>
        <div class="row">
          <div class="col-lg-4">
            <div class="form-group m-form__group" >
              <label for="user_name">
                From
              </label>
              <div class="input-group m-input-group m-input-group--pill m-input-group--air">
                <input required type="text" name="ta_from"  class="form-control m-input form_ta_add_fields" placeholder="From" aria-describedby="basic-addon1">
              </div>
              <span class="m-form__help"></span>
            </div>
          </div>
          <div class="col-lg-4">
            <div class="form-group m-form__group" >
              <label for="user_name">
                To
              </label>
              <div class="input-group m-input-group m-input-group--pill m-input-group--air">
                <input required type="text" name="ta_to"   class="form-control m-input form_ta_add_fields" placeholder="To" aria-describedby="basic-addon1">
              </div>
              <span class="m-form__help"></span>
            </div>
          </div>
          <div class="col-lg-4">
            <div class="form-group m-form__group" >
              <label for="user_name">
                Distance in KMs
              </label>
              <div class="input-group m-input-group m-input-group--pill m-input-group--air">
                <input required type="text" name="ta_km" id="ta_km"  class="form-control m-input form_ta_add_fields" placeholder="Distance" aria-describedby="basic-addon1">
              </div>
              <span class="m-form__help"></span>
            </div>
          </div>

          <div class="col-lg-4">
            <div class="form-group m-form__group" >
              <label for="user_name">
                Amount
              </label>
              <div class="input-group m-input-group m-input-group--pill m-input-group--air">
                <input required type="text" value="" name="ta_amount" id="ta_amount"  class="form-control m-input form_ta_add_fields" placeholder="Amount"  aria-describedby="basic-addon1">
              </div>
              <span class="m-form__help"></span>
            </div>
          </div>
          <div class="col-lg-4">
            <div class="form-group m-form__group" >
              <label for="user_name">
                Vehicle No
              </label>
              <div class="input-group m-input-group m-input-group--pill m-input-group--air">
                <input type="text" name="vehicle_no" id="vehicle_no_add" class="form-control m-input form_ta_add_fields" placeholder="Vehicle No" aria-describedby="basic-addon1">
              </div>
              <span class="m-form__help"></span>
            </div>
          </div>
          <div class="col-lg-4">
            <div class="form-group m-form__group" >
              <label for="user_name">
                Remarks
              </label>
              <div class="input-group m-input-group m-input-group--pill m-input-group--air">
                <input type="text" name="remarks"  class="form-control m-input form_ta_add_fields" placeholder="Remarks" aria-describedby="basic-addon1">
              </div>
              <span class="m-form__help"></span>
            </div>
          </div>
          <input type="hidden" name="redirect_url" value="<?php echo base_url(uri_string())?>" >
        </div>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-dismiss="modal">
          Close
        </button>
        <button type="submit" class="btn btn-primary form_submit_btn">
          Submit
        </button>
      </div>
    </form>
  </div>
</div>
</div>

<div class="modal fade" tabindex="-1" id="ta_edit_modal" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog " role="document" style="max-width: 800px">
    <div class="modal-content">
      <div class="modal-header" style="background-color: #36a3f7;border-radius: 4px">
        <h5 class="modal-title" id="exampleModalLabel" style="color: #ffffff" >
          Edit TA Details
        </h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">
            &times;
          </span>
        </button>
      </div>
      <form autocomplete="off" id="form_ta_edit" data-modal-id="ta_edit_modal" method="post" action="<?php echo base_url().'travel_allowance/update_ta'?>" enctype="multipart/form-data" class="m-form m-form--fit m-form--state m-form--label-align-right " >
        <div class="modal-body">
          <div class="m-form__content">
            <div class="m-alert m-alert--icon alert alert-warning m--hide" role="alert" id="form_ta_edit_msg">
              <div class="m-alert__icon">
                <i class="la la-warning"></i>
              </div>
              <div class="m-alert__text">
                Oh snap! Change a few things up and try submitting again.
              </div>
              <div class="m-alert__close">
                <button type="button" class="close" data-close="alert" aria-label="Close"></button>
              </div>
            </div>
          </div>
          <div class="row">
            <?php if($this->session->userdata('user_role')=='admin' || $this->session->userdata('user_role')=='madmin' || $this->session->userdata('user_role')=='general_manager'){?>
              <div class="col-lg-4">
                <div class="form-group m-form__group">
                  <label for="user_name">
                    Employee
                  </label>
                  <div class="m-select2 m-select2--air m-select2--pill">
                    <select required style="width: 100%" class="form-control m-select2 form_ta_add_select" id="ta_employee_id_edit"  name="employee_id" data-placeholder="Select Vehicle type">
                      <option selected disabled>Select User</option>
                      <?php foreach($employees as $row) { ?>
                        <option value="<?php echo $row->employee_id ?>"><?php echo $row->employee_name ?></option>
                      <?php } ?>
                    </select>
                  </div>
                  <span class="m-form__help"></span>
                </div>
              </div>
            <?php } else{ ?>
              <input type="hidden" name="ta_employee_id" value="<?php echo $this->session->userdata('user_id') ?>"  />
            <?php } ?>
            <div class="col-lg-4">
              <div class="form-group m-form__group">
                <label for="user_name">
                  Vehicle Type
                </label>
                <div class="m-select2 m-select2--air m-select2--pill">
                  <select required style="width: 100%" class="form-control m-select2 form_ta_add_select" id="ta_vehicle_type_edit"  name="vehicle_type" data-placeholder="Select Vehicle type">
                    <option selected disabled>Select Vehicle Type</option>
                    <?php foreach($ta_vehicles as $value ) { ?>
                      <option value="<?php echo $value['type'] ?>" data-fixed-rate="<?php echo $value['fixed_rate'] ?>" data-rate="<?php echo $value['rate'] ?>"><?php echo $value['type'] ?></option>
                    <?php } ?>
                  </select>
                </div>
                <span class="m-form__help"></span>
              </div>
            </div>
            <?php if($this->session->userdata('user_role')=='admin' || $this->session->userdata('user_role')=='madmin' || $this->session->userdata('user_role')=='general_manager'){?>
              <div class="col-lg-4">
                <div class="form-group m-form__group" >
                  <label for="user_name">
                    TA Date
                  </label>
                  <div class="input-group m-input-group m-input-group--pill m-input-group--air">
                    <input data-date-format="dd-mm-yyyy" value="<?php echo date('d-m-Y')?>" required type="text" name="ta_date" id="ta_date_edit"  class="form-control m-input form_ta_edit_fields" placeholder="TA Date" aria-describedby="basic-addon1">
                  </div>
                  <span class="m-form__help"></span>
                </div>
              </div>
            <?php } ?>
          </div>
          <div class="row">
            <?php if($this->config->item('app_module_vehicle_management')==1){ ?>
              <div class="col-lg-6">
                <div class="form-group m-form__group">
                  <label for="user_name">
                    Vehicle
                  </label>
                  <div class="m-select2 m-select2--air m-select2--pill">
                    <select style="width: 100%" class="form-control m-select2 form_ta_edit_select" id="ta_vehicle_edit"  name="vehicle" data-placeholder="Select Vehicle">
                      <option selected disabled>Select Vehicle</option>
                    </select>
                  </div>
                  <span class="m-form__help"></span>
                </div>
              </div>
            <?php } ?>
            <div class="col-lg-6">
              <div class="form-group m-form__group">
                <label for="user_name">
                  Project / Office
                </label>
                <div class="m-select2 m-select2--air m-select2--pill">
                  <select required style="width: 100%" class="form-control m-select2 form_ta_edit_select" id="ta_project_edit"  name="project" data-placeholder="Select Project">
                    <option selected value="0">Office Expense</option>
                    <?php
                    foreach($work_contracts as $row): ?>
                    <option data-work-status="<?php echo $row->work_status?>" value="<?php echo $row->work_id?>"><?php echo $row->work_name?></option>
                    <?php
                  endforeach;
                  ?>
                </select>
              </div>
              <span class="m-form__help"></span>
            </div>
          </div>
        </div>
        <div class="row">
          <div class="col-lg-4">
            <div class="form-group m-form__group" >
              <label for="user_name">
                From
              </label>
              <div class="input-group m-input-group m-input-group--pill m-input-group--air">
                <input required type="text" name="ta_from_edit" id="ta_from_edit"  class="form-control m-input form_ta_edit_fields" placeholder="From" aria-describedby="basic-addon1">
              </div>
              <span class="m-form__help"></span>
            </div>
          </div>
          <div class="col-lg-4">
            <div class="form-group m-form__group" >
              <label for="user_name">
                To
              </label>
              <div class="input-group m-input-group m-input-group--pill m-input-group--air">
                <input required type="text" name="ta_to_edit" id="ta_to_edit"  class="form-control m-input form_ta_edit_fields" placeholder="To" aria-describedby="basic-addon1">
              </div>
              <span class="m-form__help"></span>
            </div>
          </div>
          <div class="col-lg-4">
            <div class="form-group m-form__group" >
              <label for="user_name">
                Distance in KMs
              </label>
              <div class="input-group m-input-group m-input-group--pill m-input-group--air">
                <input required type="text" name="ta_km_edit" id="ta_km_edit"  class="form-control m-input form_ta_edit_fields" placeholder="Distance" aria-describedby="basic-addon1">
              </div>
              <span class="m-form__help"></span>
            </div>
          </div>
          <div class="col-lg-4">
            <div class="form-group m-form__group" >
              <label for="user_name">
                Amount
              </label>
              <div class="input-group m-input-group m-input-group--pill m-input-group--air">
                <input required type="text" value="" name="ta_amount_edit" id="ta_amount_edit"  class="form-control m-input form_ta_edit_fields" placeholder="Amount"  aria-describedby="basic-addon1">
              </div>
              <span class="m-form__help"></span>
            </div>
          </div>
          <div class="col-lg-4">
            <div class="form-group m-form__group" >
              <label for="user_name">
                Vehicle No
              </label>
              <div class="input-group m-input-group m-input-group--pill m-input-group--air">
                <input type="text" name="vehicle_no" id="vehicle_no_edit" class="form-control m-input form_ta_edit_fields" placeholder="Vehicle No" aria-describedby="basic-addon1">
              </div>
              <span class="m-form__help"></span>
            </div>
          </div>
          <div class="col-lg-4">
            <div class="form-group m-form__group" >
              <label for="user_name">
                Remarks
              </label>
              <div class="input-group m-input-group m-input-group--pill m-input-group--air">
                <input type="text" name="remarks_edit" id="remarks_edit" class="form-control m-input form_ta_edit_fields" placeholder="Remarks" aria-describedby="basic-addon1">
              </div>
              <span class="m-form__help"></span>
            </div>
          </div>
          <input type="hidden" name="redirect_url" value="<?php echo base_url(uri_string())?>" >
          <input type="hidden" name="ta_id_edit" value="" id="ta_id_edit" >
        </div>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-dismiss="modal">
          Close
        </button>
        <button type="submit" class="btn btn-primary form_submit_btn">
          Update
        </button>
      </div>
    </form>
  </div>
</div>
</div>

<div class="modal fade" tabindex="-1" id="ta_delete_modal" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog " role="document" >
    <form autocomplete="off" data-modal-id="ta_delete_modal" id="form_ta_delete" method="post" action="<?php echo base_url().'travel_allowance/delete'?>" class="form-horizontal">
      <div class="modal-content">
        <div class="alert alert-danger" role="alert" style="margin-bottom: 0px">
          <button type="button" class="close" data-dismiss="modal"></button>
          <br/>
          <h4 class="alert-heading">Warning! Please Confirm Your Action</h4>
          <br/>
          <p> Are You Sure to Delete this Data ?. All the Associated Data will Lost. </p>
          <p>
            <button class="btn btn-danger form_submit_btn" type="submit" name="submit">Confirm & Delete</button>
            <button type="button" class="btn btn-primary modal-dismiss" data-dismiss="modal">Cancel</button>
          </p>
          <input type="hidden"  name="ta_id_delete" id="ta_id_delete">
          <input type="hidden" name="redirect_url" value="<?php echo base_url(uri_string())?>" >
        </div>
      </div>
    </form>
  </div>
</div>


</div>
</div>
<!-- end:: Body -->
<!-- begin::Footer -->

<?php $this->view("includes/Inc_footer");?>
<!-- end::Footer -->
</div>
<!-- end:: Page -->

<?php $this->view("includes/Inc_sidebar");?>
<?php $this->view("includes/Inc_scripts");?>

<!--begin::Page Snippets -->
<?php $this->view("modules/include_scripts/travel_allowance_scripts");?>

<script>
$("#ta_menu").addClass('m-menu__item--active');

$("#vehicle_filter").select2({
  placeholder: "Select Vehicle",
})
$("#project_filter").select2({
  placeholder: "Select Project",
})

select_vehicles("ta_vehicle");
select_vehicles("vehicle_filter",'','','','filter');
function select_vehicles(select_id,selected_value='',category='',vehicle_type='own',type=''){
  $('#'+select_id).html('');
  if(type=='filter'){
    $('#'+select_id).append("<option selected value='all' >All Vehicles</option>");
  }else{
    $('#'+select_id).append("<option disabled selected >Select Vehicle</option>");
  }
  $.post("<?php echo base_url() ?>vehicles/select_vehicles_list",{category:category,vehicle_type:vehicle_type},function(data) {
    var obj = $.parseJSON(data);
    var i=0;
    if(obj.count>0) {
      while (i < obj.data.length) {
        $('#'+select_id).append("<option data-vehicle-no='"+obj.data[i]['vehicle_no']+"'  value=" + obj.data[i]['id'] + ">" + obj.data[i]['vehicle_name'] + " : "+obj.data[i]['vehicle_no']+" [" + obj.data[i]['consignee_name'] + "]</option>");
        i++;
      }
      if(selected_value!=''){
        $("#"+select_id).val(selected_value).trigger("change");
      }
    }
  })
}
$('#ta_vehicle').on("change", function(e) {
  var vehicle_no = $('#ta_vehicle :selected').data('vehicle-no');
  $("#vehicle_no_add").val(vehicle_no);
  $("#vehicle_no_add").attr('readonly',true);
})
$("#ta_date_add,ta_date_edit").datepicker( {
  todayHighlight:!0, orientation:"bottom left", templates: {
    leftArrow: '<i class="la la-angle-left"></i>', rightArrow: '<i class="la la-angle-right"></i>'
  }
})
//add
$("#ta_vehicle_type").select2({
  placeholder: "Select Vehicle type",
  dropdownParent: $("#form_ta_add")
})
$("#ta_project").select2({
  placeholder: "Select Project",
  templateResult: format_project_dropdown,
  dropdownParent: $("#form_ta_add")
})
$("#ta_vehicle").select2({
  placeholder: "Select Tool Category",
  dropdownParent: $("#form_ta_add")
})
$("#ta_employee_id").select2({
  placeholder: "Select User",
  dropdownParent: $("#form_ta_add")
})
function ta_calculate() {
  var ta_vehicle_type = $('#ta_vehicle_type :selected').val();
  var fixed_rate = $('#ta_vehicle_type :selected').data('fixed-rate');
  var rate = $('#ta_vehicle_type :selected').data('rate');
  if(fixed_rate==1){
    $('#ta_amount').val($('#ta_km').val()*rate);
    $('#ta_amount').attr("readonly","readonly");
  }
  else{
    $('#ta_amount').removeAttr("readonly");
  }
};
$('#ta_vehicle_type').on("change", function(e) {
  ta_calculate();
});
$('body').on('change keyup', '#ta_km', function() {
  ta_calculate();
});
//


//edit
$("#ta_project_edit").select2({
  placeholder: "Select Project",
  templateResult: format_project_dropdown,
  dropdownParent: $("#form_ta_edit")
})
$("#ta_vehicle_edit").select2({
  placeholder: "Select Tool Category",
  dropdownParent: $("#form_ta_edit")
})
$("#ta_vehicle_type_edit").select2({
  placeholder: "Select Tool Category",
  dropdownParent: $("#form_ta_edit")
})
$("#ta_employee_id_edit").select2({
  placeholder: "Select User",
  dropdownParent: $("#form_ta_edit")
})
$('#ta_vehicle_edit').on("change", function(e) {
  var vehicle_no = $('#ta_vehicle_edit :selected').data('vehicle-no');
  $("#vehicle_no_edit").val(vehicle_no);
  $("#vehicle_no_edit").attr('readonly',true);
})
function ta_calculate_edit() {
  var ta_vehicle = $('#ta_vehicle_edit :selected').val();
  var fixed_rate = $('#ta_vehicle_edit :selected').data('fixed-rate');
  var rate = $('#ta_vehicle_edit :selected').data('rate');
  if(fixed_rate==1){
    $('#ta_amount_edit').val($('#ta_km_edit').val()*rate);
    $('#ta_amount_edit').attr("readonly","readonly");
  }
  else{
    $('#ta_amount_edit').removeAttr("readonly");
  }
};
$('#ta_vehicle_type_edit').on("change", function(e) {
  ta_calculate_edit();
});
$('body').on('change keyup', '#ta_km_edit', function() {
  ta_calculate_edit();
});
//

$("#ta_vehicle_type_filter,#employee_filter").select2();

$('body').on('click', '#ta_edit_btn', function() {
  var no = $(this).closest('tr').children('td');
  $('#ta_employee_id_edit').val(no.eq(17).text()).trigger('change');
  $('#ta_id_edit').val(no.eq(1).text());
  $('#ta_date_edit').datepicker("setDate",no.eq(2).text());
  $('#ta_vehicle_type_edit').val(no.eq(5).text()).trigger('change');
  $('#ta_from_edit').val(no.eq(8).text());
  $('#ta_to_edit').val(no.eq(9).text());
  $('#ta_km_edit').val(no.eq(10).text());
  var ta_vehicle = $('#ta_vehicle_type_edit :selected').val();
  var fixed_rate = $('#ta_vehicle_type_edit :selected').data('fixed-rate');
  var rate = $('#ta_vehicle_type_edit :selected').data('rate');
  if(fixed_rate==1){
    $('#ta_amount_edit').val($('#ta_km_edit').val()*rate);
    $('#ta_amount_edit').attr("readonly","readonly");
  }else{
    $('#ta_amount_edit').val(no.eq(11).text());
    $('#ta_amount_edit').removeAttr("readonly");
  }
  $('#remarks_edit').val(no.eq(12).text());
  $('#vehicle_no_edit').val(no.eq(7).text());
  select_vehicles("ta_vehicle_edit",no.eq(18).text());
  $('#ta_project_edit').val(no.eq(19).text()).trigger('change');
})

$('body').on('click', '#ta_delete_btn', function() {
  var no = $(this).closest('tr').children('td');
  $('#ta_id_delete').val(no.eq(1).text());
})


</script>
<style>
.hidden{
  display: none;
}
</style>
