<?php $this->view("includes/Inc_pagehead"); ?>
<!-- Page Styles Goes Here-->

<?php $this->view("includes/Inc_navigation"); ?>
<div class="m-grid__item m-grid__item--fluid m-wrapper">
  <!-- BEGIN: Subheader -->
  <div class="m-subheader ">
    <div class="d-flex align-items-center">
      <div class="mr-auto">
        <h3 class="m-subheader__title m-subheader__title--separator">
          Supplier Details
        </h3>
        <ul class="m-subheader__breadcrumbs m-nav m-nav--inline">
          <li class="m-nav__item m-nav__item--home">
            <a href="#" class="m-nav__link m-nav__link--icon">
              <i class="m-nav__link-icon la la-home"></i>
            </a>
          </li>
          <li class="m-nav__separator">
            -
          </li>
          <li class="m-nav__item">
            <a href="<?php echo base_url() . 'dashboard' ?>" class="m-nav__link">
              <span class="m-nav__link-text">
                Home
              </span>
            </a>
          </li>
          <li class="m-nav__separator">
            -
          </li>
          <li class="m-nav__item">
            <a href="<?php echo base_url() . 'supplier' ?>" class="m-nav__link">
              <span class="m-nav__link-text">
                Supplier Details
              </span>
            </a>
          </li>


        </ul>
      </div>
      <div>

      </div>
    </div>
  </div>
  <!-- END: Subheader -->
  <div class="m-content">
    <div class="m-portlet m-portlet--mobile m-portlet--info m-portlet--head-solid-bg m-portlet--bordered m-portlet--rounded">
      <div class="m-portlet__head">
        <div class="m-portlet__head-caption">
          <div class="m-portlet__head-title">
            <h3 class="m-portlet__head-text">
              List of Suppliers Registered
            </h3>
          </div>
        </div>
        <div class="m-portlet__head-tools">
          <?php if ($this->session->userdata('user_role') != 'auditor' || $this->session->userdata('user_data_permission')['adding'] == 1) { ?>
            <a href="#" data-toggle="modal" data-target="#supplier_add_modal" class="btn btn-focus m-btn m-btn--custom m-btn--icon m-btn--air m-btn--pill">
              <span>
                <i class="la la-plus"></i>
                <span>
                  Add New Supplier
                </span>
              </span>
            </a>
          <?php } ?>
        </div>
      </div>
      <div class="m-portlet__body">
        <!--begin: Datatable -->
        <div class="m-form m-form--label-align-right m--margin-bottom-10">
          <div class="row align-items-center">
            <div class="col-xl-12 order-2 order-xl-1">
              <div class="form-group m-form__group row ">
                <!-- <div class="col-md-4">

              </div> -->

              <?php if (!empty($this->config->item('company_branches'))) { ?>

                <div class="col-lg-4">
                  <div class="form-group m-form__group">
                    <label>
                      Company Branch
                    </label>
                    <div class="m-select2 m-select2--air m-select2--pill">
                      <select width="100%" required class="form-control m-select2 table_filter company-branch-select2" id="company_branch">
                        <option selected value="all"> All Branches</option>
                        <option value="0">NO BRANCH</option>
                        <?php foreach ($this->config->item('company_branches') as $key => $value) { ?>
                          <option value="<?php echo $value->branch_id ?>"><?php echo $value->branch_name ?></option>
                        <?php } ?>
                      </select>
                    </div>
                    <span class="m-form__help"></span>
                  </div>
                </div>

              <?php } ?>


              <?php if ($this->config->item('app_module_vehicle_management') == 1) { ?>
                <div class="col-md-4">
                  <div class="form-group m-form__group">
                    <label>
                      Type:
                    </label>
                    <div class="m-select2 m-select2--air m-select2--pill">
                      <select style="width: 100%" class="form-control m-select2 table_filter" id="table_filter_supplier_type" data-placeholder="Select Category">
                        <option selected value="all">All Types</option>
                        <option value="construction">Construction Materials</option>
                        <option value="vehicle">Vehicle Spares / Pump / Workshop</option>
                      </select>
                    </div>
                    <span class="m-form__help"></span>
                  </div>
                </div>
              <?php } ?>
              <div class="col-md-4">
                <div class="form-group m-form__group">
                  <label>
                    Category:
                  </label>
                  <div class="m-select2 m-select2--air m-select2--pill">
                    <select style="width: 100%" class="form-control m-select2 table_filter" id="table_filter_supplier_category" data-placeholder="Select Category">

                    </select>
                  </div>
                  <span class="m-form__help"></span>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
      <table width="100%" class="table m-table nowrap table-header-fixed table-striped table-bordered table-hover table-header-fixed" id="supplier_view_table">
        <thead>
          <tr class="">
            <th>Supplier Id</th>
            <th>Branch Name</th>
            <th>Supplier Type</th>
            <th>Supplier Name</th>
            <th>Supplier Address</th>
            <th>Category</th>
            <th>Phone</th>
            <th>Email</th>
            <th>Contact Person</th>
            <th><?php echo $this->config->item('Tax_tax_name') ?> No</th>
            <th><?php echo $this->config->item('Tax_tax_name') ?> Date</th>
            <th>PAN No</th>
            <th>Aadhar</th>
            <th>Bank A/C No</th>
            <th><?= $this->config->item('bank_ifsc_name')?> CODE</th>
            <th>Bank Name</th>
            <th>Branch</th>
            <th>Opening Balance<br/>(Payable on A/C Creation)</th>
            <th>Total Bill Amount</th>
            <th>Total Paid</th>
            <th>Current Balance</th>
            <th>Actions</th>
            <th>Category ID</th>
            <th>Supplier Type</th>
          </tr>
        </thead>
        <tbody>
        </tbody>
      </table>
      <!--end: Datatable -->

      <div class="modal fade" tabindex="-1" id="supplier_edit_modal" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog " role="document" style="max-width: 800px">
          <div class="modal-content">
            <div class="modal-header" style="background-color: #00c5dc;border-radius: 4px">
              <h5 class="modal-title" id="exampleModalLabel" style="color: #ffffff">
                Edit Supplier Details
              </h5>
              <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">
                  &times;
                </span>
              </button>
            </div>
            <form autocomplete="off" data-modal-id="supplier_edit_modal" id="form_supplier_edit" method="post" action="<?php echo base_url() . 'supplier/update' ?>" enctype="multipart/form-data" class="m-form m-form--fit m-form--state m-form--label-align-right ">
              <div class="modal-body">
                <div class="m-form__content">
                  <div class="m-alert m-alert--icon alert alert-warning m--hide" role="alert" id="form_supplier_edit_msg">
                    <div class="m-alert__icon">
                      <i class="la la-warning"></i>
                    </div>
                    <div class="m-alert__text">
                      Oh snap! Change a few things up and try submitting again.
                    </div>
                    <div class="m-alert__close">
                      <button type="button" class="close" data-close="alert" aria-label="Close"></button>
                    </div>
                  </div>
                </div>
                <div class="row">
                  <?php if ($this->config->item('app_module_vehicle_management') == 1) { ?>
                    <div class="col-lg-6">
                      <div class="form-group m-form__group">
                        <label>
                          Supplier Type
                        </label>
                        <div class="m-radio-inline" style="padding-top: 10px;">
                          <label class="m-radio m-radio--solid m-radio--state-danger">
                            <input required type="radio" class="form_fields_radio" name="supplier_type_edit" value="construction"> Construction Materials
                            <span></span>
                          </label>
                          <label class="m-radio m-radio--solid m-radio--state-warning">
                            <input type="radio" class="form_fields_radio" name="supplier_type_edit" value="vehicle"> Vehicle Spares / Pump / Workshop
                            <span></span>
                          </label>
                        </div>
                        <span class="m-form__help"></span>
                      </div>
                    </div>
                  <?php } ?>
                  <div class="col-lg-6">
                    <div class="form-group m-form__group">
                      <label for="user_name">
                        Category
                      </label>
                      <div class="input-group m-input-group m-input-group--pill">
                        <div class="input-group-prepend">
                          <a href="#supplier_category_add_modal" data-toggle="modal" data-target="#supplier_category_add_modal" class="btn btn-focus">
                            <i class="fa fa-plus-circle"></i>
                          </a>
                        </div>
                        <select multiple style="width: 84%" class="form-control m-select2 m-select2-general form_supplier_edit_select" id="supplier_category_edit" name="category[]">

                        </select>
                      </div>
                      <span class="m-form__help"></span>
                    </div>
                  </div>
                  <div class="col-lg-8">
                    <div class="form-group m-form__group">
                      <label for="supplier_name">
                        Supplier Name
                      </label>
                      <div class="input-group m-input-group m-input-group--pill m-input-group--air">
                        <div class="input-group-prepend">
                          <span class="input-group-text" id="basic-addon1">
                            <i class="la la-user"></i>
                          </span>
                        </div>
                        <input required type="text" name="supplier_name" id="supplier_name" class="form_supplier_edit_fields form-control m-input" placeholder="Supplier Name" aria-describedby="basic-addon1">
                      </div>
                      <span class="m-form__help"></span>
                    </div>
                  </div>
                  <div class="col-lg-4">
                    <div class="form-group m-form__group">
                      <label for="user_name">
                        Contact Person
                      </label>
                      <div class="input-group m-input-group m-input-group--pill m-input-group--air">
                        <input type="text" name="contact_person" id="contact_person_edit"  class="form-control form_supplier_edit_fields m-input" aria-describedby="basic-addon1">
                      </div>
                      <span class="m-form__help"></span>
                    </div>
                  </div>
                  <br />
                  <div class="col-lg-12">
                    <div class="form-group m-form__group">
                      <label for="user_name">
                        Supplier Address
                      </label>
                      <div class="input-group m-input-group m-input-group--pill m-input-group--air">
                        <textarea required rows="2" name="supplier_address" id="supplier_address" class="form_supplier_edit_fields form-control m-input" placeholder="Supplier Address" aria-describedby="basic-addon1"></textarea>
                      </div>
                      <span class="m-form__help"></span>
                    </div>
                  </div>

                  <div class="col-lg-6">
                    <div class="form-group m-form__group">
                      <label for="user_name">
                        Contact No
                      </label>
                      <div class="input-group m-input-group m-input-group--pill m-input-group--air">
                        <div class="input-group-prepend">
                          <span class="input-group-text" id="basic-addon1">
                            <i class="la la-phone"></i>
                          </span>
                        </div>
                        <input type="text" name="phone" id="phone_edit" class="form_supplier_edit_fields form-control m-input" placeholder="Supplier Phone" aria-describedby="basic-addon1">
                      </div>
                      <span class="m-form__help"></span>
                    </div>
                  </div>
                  <div class="col-lg-6">
                    <div class="form-group m-form__group">
                      <label for="user_name">
                        Email
                      </label>
                      <div class="input-group m-input-group m-input-group--pill m-input-group--air">
                        <div class="input-group-prepend">
                          <span class="input-group-text" id="basic-addon1">
                            <i class="la la-envelope"></i>
                          </span>
                        </div>
                        <input type="text" name="email" id="email_edit" class="form_supplier_edit_fields form-control m-input" placeholder="Supplier Phone" aria-describedby="basic-addon1">
                      </div>
                      <span class="m-form__help"></span>
                    </div>
                  </div>
                  <div class="col-lg-4">
                    <div class="form-group m-form__group">
                      <label for="user_name">
                        <?php echo $this->config->item('Tax_tax_name') ?> No
                      </label>
                      <div class="input-group m-input-group m-input-group--pill m-input-group--air">
                        <div class="input-group-prepend">
                          <span class="input-group-text" id="basic-addon1">
                            <i class="la la-edit"></i>
                          </span>
                        </div>
                        <input type="text" name="tax_no" id="tax_no_edit" class="form_supplier_edit_fields form-control m-input" placeholder="<?php echo $this->config->item('Tax_tax_name') ?> No" aria-describedby="basic-addon1">
                      </div>
                      <span class="m-form__help"></span>
                    </div>
                  </div>
                  <div class="col-lg-4">
                    <div class="form-group m-form__group">
                      <label for="user_name">
                        <?php echo $this->config->item('Tax_tax_name') ?> Date
                      </label>
                      <div class="input-group m-input-group m-input-group--pill m-input-group--air">
                        <div class="input-group-prepend">
                          <span class="input-group-text" id="basic-addon1">
                            <i class="la la-edit"></i>
                          </span>
                        </div>
                        <input type="text" data-date-format="dd-mm-yyyy" name="tax_date" id="tax_date_edit" class="form_supplier_edit_fields form-control m-input" placeholder="<?php echo $this->config->item('Tax_tax_name') ?> Date" aria-describedby="basic-addon1">
                      </div>
                      <span class="m-form__help"></span>
                    </div>
                  </div>
                  <div class="col-lg-4">
                    <div class="form-group m-form__group">
                      <label for="user_name">
                        Opening Balance (Payable on A/C Creation)
                      </label>
                      <div class="input-group m-input-group m-input-group--pill m-input-group--air">
                        <div class="input-group-prepend">
                          <span class="input-group-text" id="basic-addon1">
                            <?php echo $this->config->item('Currency_currency_format'); ?>
                          </span>
                        </div>
                        <input required type="text" name="op_balance" id="op_balance" class="form_supplier_edit_fields form-control m-input" placeholder="Supplier Opening Balance" aria-describedby="basic-addon1">
                      </div>
                      <span class="m-form__help"></span>
                    </div>
                  </div>
                  <div class="col-lg-4">
                    <div class="form-group m-form__group">
                      <label for="user_name">
                        PAN No
                      </label>
                      <div class="input-group m-input-group m-input-group--pill m-input-group--air">
                        <input type="text" name="pan_no" id="pan_no_edit" class="form_supplier_edit_fields form-control m-input" aria-describedby="basic-addon1">
                      </div>
                      <span class="m-form__help"></span>
                    </div>
                  </div>
                  <div class="col-lg-4">
                    <div class="form-group m-form__group">
                      <label for="user_name">
                        Aadhar No
                      </label>
                      <div class="input-group m-input-group m-input-group--pill m-input-group--air">
                        <input type="text" name="aadhar_no" id="aadhar_no_edit"  class="form_supplier_edit_fields form-control m-input" aria-describedby="basic-addon1">
                      </div>
                      <span class="m-form__help"></span>
                    </div>
                  </div>
                  <div class="col-lg-4">
                    <div class="form-group m-form__group">
                      <label for="user_name">
                        Bank A/C No
                      </label>
                      <div class="input-group m-input-group m-input-group--pill m-input-group--air">
                        <input type="text" name="bank_account_no" id="bank_account_no_edit"  class="form_supplier_edit_fields form-control m-input" aria-describedby="basic-addon1">
                      </div>
                      <span class="m-form__help"></span>
                    </div>
                  </div>
                  <div class="col-lg-4">
                    <div class="form-group m-form__group">
                      <label for="user_name">
                        <?= $this->config->item('bank_ifsc_name')?> Code
                      </label>
                      <div class="input-group m-input-group m-input-group--pill m-input-group--air">
                        <input type="text" name="bank_ifsc" id="bank_ifsc_edit"  class="form_supplier_edit_fields form-control m-input" aria-describedby="basic-addon1">
                      </div>
                      <span class="m-form__help"></span>
                    </div>
                  </div>
                  <div class="col-lg-4">
                    <div class="form-group m-form__group">
                      <label for="user_name">
                        Bank Name
                      </label>
                      <div class="input-group m-input-group m-input-group--pill m-input-group--air">
                        <input type="text" name="bank_name" id="bank_name_edit" class="form_supplier_edit_fields form-control m-input" aria-describedby="basic-addon1">
                      </div>
                      <span class="m-form__help"></span>
                    </div>
                  </div>
                  <div class="col-lg-4">
                    <div class="form-group m-form__group">
                      <label for="user_name">
                        Branch Name
                      </label>
                      <div class="input-group m-input-group m-input-group--pill m-input-group--air">
                        <input type="text" name="bank_branch" id="bank_branch_edit"  class="form_supplier_edit_fields form-control m-input" aria-describedby="basic-addon1">
                      </div>
                      <span class="m-form__help"></span>
                    </div>
                  </div>
                  <input type="hidden" name="supplier_id" id="supplier_id">
                </div>
              </div>
              <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">
                  Close
                </button>
                <button type="submit" class="btn btn-primary form_submit_btn">
                  Submit
                </button>
              </div>
            </form>
          </div>
        </div>
      </div>
      <div class="modal fade" tabindex="-1" id="supplier_delete_modal" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog " role="document">
          <form autocomplete="off" method="post" data-modal-id="supplier_delete_modal" id="form_supplier_delete" action="<?php echo base_url() . 'supplier/delete' ?>" class="form-horizontal">
            <div class="modal-content">
              <div class="alert alert-danger" role="alert" style="margin-bottom: 0px">
                <button type="button" class="close" data-dismiss="modal"></button>
                <br />
                <h4 class="alert-heading">Warning! Please Confirm Your Action</h4>
                <br />
                <p> Are You Sure to Delete this Data ?. All the Associated Data will Lost. </p>
                <p>
                  <button class="btn btn-danger form_submit_btn" type="submit" name="submit">Confirm & Delete</button>
                  <button type="button" class="btn btn-primary modal-dismiss" data-dismiss="modal">Cancel</button>
                </p>
                <input type="hidden" name="supplier_id" id="supplier_id_delete">
              </div>
            </div>
          </form>
        </div>
      </div>
    </div>
  </div>
</div>
</div>
</div>
<!-- end:: Body -->
<!-- begin::Footer -->
<?php $this->view("modules/include_modals/modal_supplier_add"); ?>

<?php $this->view("includes/Inc_footer"); ?>
<!-- end::Footer -->
</div>
<!-- end:: Page -->

<?php $this->view("includes/Inc_sidebar"); ?>
<?php $this->view("includes/Inc_scripts"); ?>

<!--begin::Page Snippets -->
<script>
$("#suppliers_menu").addClass('m-menu__item--active');
$("#tax_date_add,#tax_date_edit").datepicker({
  todayHighlight: !0,
  orientation: "bottom left",
  templates: {
    leftArrow: '<i class="la la-angle-left"></i>',
    rightArrow: '<i class="la la-angle-right"></i>'
  }
})
$("#supplier_category_add").select2({
  placeholder: "Select Category",
  dropdownParent: $("#form_supplier_add")
})
$("#supplier_category_edit").select2({
  placeholder: "Select Category",
  dropdownParent: $("#form_supplier_edit")
})
$("#table_filter_supplier_category").select2({
  placeholder: "Select Category"
})
$("#table_filter_supplier_type").select2({
  placeholder: "Select Type"
})

function select_supplier_category() {
  $('#supplier_category_add').html('');
  // $("#supplier_category_add").append("<option disabled selected >Select Category</option>");

  $('#supplier_category_edit').html('');
  // $("#supplier_category_edit").append("<option disabled selected >Select Category</option>");

  $('#table_filter_supplier_category').html('');
  $("#table_filter_supplier_category").append("<option value='all' selected >All Categories</option>");

  $.post("<?php echo base_url() ?>supplier/select_category", {}, function(data) {
    var obj = $.parseJSON(data);
    var i = 0;
    if (obj.count > 0) {
      while (i < obj.data.length) {
        $("#supplier_category_add").append("<option value=" + obj.data[i]['sup_category_id'] + ">" + obj.data[i]['sup_category_name'] + "</option>");
        $("#supplier_category_edit").append("<option value=" + obj.data[i]['sup_category_id'] + ">" + obj.data[i]['sup_category_name'] + "</option>");
        $("#table_filter_supplier_category").append("<option value=" + obj.data[i]['sup_category_id'] + ">" + obj.data[i]['sup_category_name'] + "</option>");
        i++;
      }
    }
  })
}

//  Supplier List Data Table
var Datatable = function() {
  var t = function() {
    function GetSearchCategory() {
      return $('#table_filter_supplier_category').val();
    }

    function GetSearchType() {
      return $('#table_filter_supplier_type').val();
    }

    function get_branch_id() {
      return $('#company_branch :selected').val();
    }

    var table = $('#supplier_view_table').DataTable({
      "ajax": {
        url: "<?php echo base_url() . 'supplier/select_supplier' ?>", // json datasource
        type: "post", // type of method  , by default would be get
        data: function(d) {
          d.category = GetSearchCategory();
          <?php if ($this->config->item('app_module_vehicle_management') == 1) { ?>
            d.type = GetSearchType();
            <?php } ?>
            <?php if (!empty($this->config->item('company_branches'))) { ?>
              d.branch_id = get_branch_id();
              <?php } ?>
            }
          },
          "bProcessing": true,
          "deferRender": true,
          "bDeferRender": true,
          "scrollX": true,
          buttons: [{
            extend: 'print',
            className: 'btn dark btn-outline',
            exportOptions: {
              columns: ':visible'
            },
            title: 'Suppliers'
          },
          {
            extend: 'csv',
            className: 'btn purple btn-outline '
          },
          {
            extend: 'colvis',
            className: 'btn dark btn-outline',
            text: 'Columns'
          }
        ],
        dom: "<'row'<'col-sm-6 text-left'B><'col-sm-6 text-right'f>>\n\t\t\t<'row'<'col-sm-12'tr>>\n\t\t\t<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 dataTables_pager'lp>>", // horizobtal scrollable datatable
        "lengthMenu": [
          [25, 50, 100, -1],
          [25, 50, 100, "All"] // change per page values here
        ],
        "columnDefs": [{
          "targets": [22, 23 <?php if ($this->config->item('app_module_vehicle_management') != 1) {
            echo ",2";
          } ?> <?php if (empty($this->config->item('company_branches'))) {
            echo ",1";
          } ?>],
          className: "hidden"
        }],
        // set the initial value
        "pageLength": 25,
        'order': [
          [0, 'desc']
        ]
      });
      $(".table_filter").on("change", function() {
        table.ajax.reload();
      });
      $(".hide_column").hide();

      $(".form_submit_btn").click(function(e) {
        e.preventDefault();
        var a = $(this),
        l = $(this).closest("form"),
        action = l.attr('action');
        var form_id = l.attr('id');
        l.validate({
          rules: {
            name: {
              required: !0
            }
          },
          invalidHandler: function(e, r) {
            var i = $("#" + form_id + "_msg");
            i.removeClass("m--hide").show(), mUtil.scrollTo(i, -200)
          },
          submitHandler: function(e) {}
        }), l.valid() && (a.addClass("m-loader m-loader--right m-loader--light").attr("disabled", !0),
        l.ajaxSubmit({
          url: action,
          success: function(e, t, r, s) {
            var modal_id = l.attr('data-modal-id');
            var form_type = l.attr('data-form-type');
            $("#" + form_id + "_msg").addClass("m--hide");
            // Block UI
            mApp.blockPage({
              overlayColor: "#000000",
              type: "loader",
              state: "success",
              message: "Please wait..."
            }), setTimeout(function() {
              mApp.unblockPage()
            }, 2e3);
            var obj = $.parseJSON(e);
            if (obj.status == 1) {
              a.removeClass("m-loader m-loader--right m-loader--light").attr("disabled", !1);
              $("#" + modal_id).modal('toggle');
              $("." + form_id + "_fields").val('');
              $("." + form_id + "_select").val('').trigger("change");
              toastr[obj.flashdata_type](obj.flashdata_msg, obj.flashdata_title);
              if (form_type == "supplier_category") {
                select_supplier_category();
              } else {
                table.ajax.reload();
              }
            } else {
              a.removeClass("m-loader m-loader--right m-loader--light").attr("disabled", !1);
              toastr[obj.flashdata_type](obj.flashdata_msg, obj.flashdata_title);
            }
            if (obj == null) {
              setTimeout(function() {
                a.removeClass("m-loader m-loader--right m-loader--light").attr("disabled", !1);
                toastr["warning"]("Your Attempt is Timed Out. Please Try Again.", "Timed Out");
              }, 2e4)
            }
          },
          error: function() {
            a.removeClass("m-loader m-loader--right m-loader--light").attr("disabled", !1);
            toastr["error"]("Sorry. There Has Been Some Error Occurred. Please Try Again.", "Error");
          }
        })
      )
    });
  };
  return {
    init: function() {
      t()
    }
  }
}

();
jQuery(document).ready(function() {
  select_supplier_category();
  Datatable.init();
  $(".hidden").hide();
  //            $('#service_view_table').wrap("");
}

);
</script>
<script>
$('body').on('click', '#suppier_edit_btn', function() {
  var no = $(this).closest('tr').children('td');
  $('#supplier_id').val(no.eq(0).text());
  $('#supplier_name').val(no.eq(3).text());
  $('#supplier_address').val(no.eq(4).text());
  $('#phone_edit').val(no.eq(6).text());
  $('#email_edit').val(no.eq(7).text());
  $('#contact_person_edit').val(no.eq(8).text());
  $('#tax_no_edit').val(no.eq(9).text());
  $('#tax_date_edit').datepicker("setDate", no.eq(10).text());
  $('#pan_no_edit').val(no.eq(11).text());
  $('#aadhar_no_edit').val(no.eq(12).text());
  $('#bank_account_no_edit').val(no.eq(13).text());
  $('#bank_ifsc_edit').val(no.eq(14).text());
  $('#bank_name_edit').val(no.eq(15).text());
  $('#bank_branch_edit').val(no.eq(16).text());
  $('#op_balance').val(no.eq(17).text());
  $('#supplier_category_edit').val(no.eq(22).text()).trigger('change');
  var supplier_type = no.eq(23).text();
  $("input[name=supplier_type_edit][value=" + supplier_type + "]").prop('checked', true);
})
$('body').on('click', '#suppier_delete_btn', function() {
  var no = $(this).closest('tr').children('td');
  $('#supplier_id_delete').val(no.eq(0).text());

})
</script>
