<?php $this->view("includes/Inc_pagehead");?>
<!-- Page Styles Goes Here-->

<?php $this->view("includes/Inc_navigation");?>
<div class="m-grid__item m-grid__item--fluid m-wrapper">
  <!-- BEGIN: Subheader -->
  <div class="m-subheader ">
    <div class="d-flex align-items-center">
      <div class="mr-auto">
        <h3 class="m-subheader__title m-subheader__title--separator">
          Work Type
        </h3>
        <ul class="m-subheader__breadcrumbs m-nav m-nav--inline">
          <li class="m-nav__item m-nav__item--home">
            <a href="#" class="m-nav__link m-nav__link--icon">
              <i class="m-nav__link-icon la la-home"></i>
            </a>
          </li>
          <li class="m-nav__separator">
            -
          </li>
          <li class="m-nav__item">
            <a href="<?php echo base_url().'dashboard'?>" class="m-nav__link">
              <span class="m-nav__link-text">
                Home
              </span>
            </a>
          </li>
          <li class="m-nav__separator">
            -
          </li>
          <li class="m-nav__item">
            <a href="<?php echo base_url().'work_types' ?>" class="m-nav__link">
              <span class="m-nav__link-text">
                Work Type
              </span>
            </a>
          </li>


        </ul>
      </div>
      <div>

      </div>
    </div>
  </div>
  <!-- END: Subheader -->
  <div class="m-content">
    <div class="m-portlet m-portlet--mobile m-portlet--info m-portlet--head-solid-bg m-portlet--bordered m-portlet--rounded">
      <div class="m-portlet__head">
        <div class="m-portlet__head-caption">
          <div class="m-portlet__head-title">
            <h3 class="m-portlet__head-text">
              List of Work Type
            </h3>
          </div>
        </div>
        <div class="m-portlet__head-tools">
          <?php if($this->session->userdata('user_role')!='auditor' || $this->session->userdata('user_data_permission')['adding']==1) { ?>
            <a href="#" data-toggle="modal" data-target="#work_type_add_modal" class="btn btn-focus m-btn m-btn--custom m-btn--icon m-btn--air m-btn--pill">
              <span>
                <i class="la la-plus"></i>
                <span>
                  Add New Work Type
                </span>
              </span>
            </a>
          <?php } ?>
        </div>
      </div>
      <div class="m-portlet__body">
        <!--begin: Datatable -->
        <table width="100%" class="table m-table nowrap table-header-fixed table-striped table-bordered table-hover table-header-fixed" id="work_type_view_table">
          <thead>
            <tr class="">
              <th>Work Type Id</th>
              <th>Work Type Name</th>
              <th>Actions</th>
            </tr>
          </thead>
          <tbody>
          </tbody>
        </table>
        <!--end: Datatable -->
        <div class="modal fade" tabindex="-1" id="work_type_add_modal" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
          <div class="modal-dialog " role="document" style="max-width: 800px">
            <div class="modal-content">
              <div class="modal-header" style="background-color: #36a3f7;border-radius: 4px">
                <h5 class="modal-title" id="exampleModalLabel" style="color: #ffffff" >
                  Create New Work Type
                </h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                  <span aria-hidden="true">
                    &times;
                  </span>
                </button>
              </div>
              <form autocomplete="off" id="form_work_type_add" data-modal-id="work_type_add_modal" method="post" action="<?php echo base_url().'work_types/create'?>" enctype="multipart/form-data" class="m-form m-form--fit m-form--state m-form--label-align-right " >
                <div class="modal-body">
                  <div class="m-form__content">
                    <div class="m-alert m-alert--icon alert alert-warning m--hide" role="alert" id="form_work_type_add_msg">
                      <div class="m-alert__icon">
                        <i class="la la-warning"></i>
                      </div>
                      <div class="m-alert__text">
                        Oh snap! Change a few things up and try submitting again.
                      </div>
                      <div class="m-alert__close">
                        <button type="button" class="close" data-close="alert" aria-label="Close"></button>
                      </div>
                    </div>
                  </div>
                  <div class="row">
                    <div class="col-lg-12">
                      <div class="form-group m-form__group">
                        <label for="user_name">
                          Work Type Name
                        </label>
                        <div class="input-group m-input-group m-input-group--pill m-input-group--air">
                          <div class="input-group-prepend">
                            <span class="input-group-text" id="basic-addon1">
                              <i class="la la-tag"></i>
                            </span>
                          </div>
                          <input required type="text" name="name"  class="form-control m-input form_work_type_add_fields" placeholder="Work Type Name" aria-describedby="basic-addon1">
                        </div>
                        <span class="m-form__help"></span>
                      </div>
                    </div>
                  </div>
                </div>
                <div class="modal-footer">
                  <button type="button" class="btn btn-secondary" data-dismiss="modal">
                    Close
                  </button>
                  <button type="submit" class="btn btn-primary form_submit_btn">
                    Submit
                  </button>
                </div>
              </form>
            </div>
          </div>
        </div>


        <div class="modal fade" tabindex="-1" id="work_type_edit_modal" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
          <div class="modal-dialog " role="document" style="max-width: 800px">
            <div class="modal-content">
              <div class="modal-header" style="background-color: #00c5dc;border-radius: 4px">
                <h5 class="modal-title" id="exampleModalLabel" style="color: #ffffff" >
                  Edit Work Type Details
                </h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                  <span aria-hidden="true">
                    &times;
                  </span>
                </button>
              </div>
              <form autocomplete="off" id="form_work_type_edit" data-modal-id="work_type_edit_modal" method="post" action="<?php echo base_url().'work_types/update'?>" enctype="multipart/form-data" class="m-form m-form--fit m-form--state m-form--label-align-right " >
                <div class="modal-body">
                  <div class="m-form__content">
                    <div class="m-alert m-alert--icon alert alert-warning m--hide" role="alert" id="form_work_type_edit_msg">
                      <div class="m-alert__icon">
                        <i class="la la-warning"></i>
                      </div>
                      <div class="m-alert__text">
                        Oh snap! Change a few things up and try submitting again.
                      </div>
                      <div class="m-alert__close">
                        <button type="button" class="close" data-close="alert" aria-label="Close"></button>
                      </div>
                    </div>
                  </div>
                  <div class="row">
                    <div class="col-lg-12">
                      <div class="form-group m-form__group">
                        <label for="work_type_name">
                          Work Type Name
                        </label>
                        <div class="input-group m-input-group m-input-group--pill m-input-group--air">
                          <div class="input-group-prepend">
                            <span class="input-group-text" id="basic-addon1">
                              <i class="la la-user"></i>
                            </span>
                          </div>
                          <input required type="text" name="work_type_name" id="work_type_name"  class="form-control m-input form_work_type_edit_fields" placeholder="Work Type Name" aria-describedby="basic-addon1">
                        </div>
                        <span class="m-form__help"></span>
                      </div>

                    </div>

                    <input type="hidden" name="work_type_id" id="work_type_id">
                  </div>
                </div>
                <div class="modal-footer">
                  <button type="button" class="btn btn-secondary" data-dismiss="modal">
                    Close
                  </button>
                  <button type="submit" class="btn btn-primary form_submit_btn">
                    Submit
                  </button>
                </div>
              </form>
            </div>
          </div>
        </div>

      </div>
    </div>
  </div>
</div>
</div>
<!-- end:: Body -->
<!-- begin::Footer -->

<?php $this->view("includes/Inc_footer");?>
<!-- end::Footer -->
</div>
<!-- end:: Page -->

<?php $this->view("includes/Inc_sidebar");?>
<?php $this->view("includes/Inc_scripts");?>

<!--begin::Page Snippets -->
<script>
  $("#work_types_menu").addClass('m-menu__item--active');
//  work_types List Data Table
var Datatable=function() {
  var t=function() {
    function GetSearchStatus(){
      return $('#table_filter_status').val();
    }
    var table = $('#work_type_view_table').DataTable({
      "ajax":{
        url :"<?php echo base_url().'work_types/select_work_types' ?>", // json datasource
        type: "post", // type of method  , by default would be get
        data: function(d){
          //                         d.status = GetSearchStatus();
        }
      },
      "bProcessing": true,
      "deferRender": true,
      "bDeferRender": true,
      "scrollX" : true,
      buttons: [
      { extend: 'print', className: 'btn dark btn-outline',exportOptions: {columns: ':visible'},title: 'Work Types' },
      { extend: 'csv', className: 'btn purple btn-outline ' },
      { extend: 'colvis', className: 'btn dark btn-outline', text: 'Columns'}
      ],
      dom:"<'row'<'col-sm-6 text-left'B><'col-sm-6 text-right'f>>\n\t\t\t<'row'<'col-sm-12'tr>>\n\t\t\t<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 dataTables_pager'lp>>", // horizobtal scrollable datatable
      "lengthMenu": [
      [25, 50, 100, -1],
        [25, 50, 100, "All"] // change per page values here
        ],
        "columnDefs": [
        {
          "targets": [ <?php if($this->session->userdata('user_role')=='auditor'){ echo ",2"; }?> ],
          className: "hidden"
        }
        ],
      // set the initial value
      "pageLength": 25,
      'order': [[0, 'desc']]
    });
    $(".table_filter").on("change", function() {
      table.ajax.reload();
    });
    $(".hide_column").hide();

    $(".form_submit_btn").click(function (e) {
      e.preventDefault();
      var a = $(this),
      l = $(this).closest("form"),
      action = l.attr('action');
      var form_id = l.attr('id');
      l.validate({
        rules: {
          email: {
            email: !0
          }
        }, invalidHandler: function (e, r) {
          var i = $("#" + form_id + "_msg");
          i.removeClass("m--hide").show(), mUtil.scrollTo(i, -200)
        }, submitHandler: function (e) {
        }
      }), l.valid() && (a.addClass("m-loader m-loader--right m-loader--light").attr("disabled", !0),
      l.ajaxSubmit({
        url: action,
        success: function (e, t, r, s) {
          var modal_id = l.attr('data-modal-id');
          var form_type = l.attr('data-form-type');
          $("#" + form_id + "_msg").addClass("m--hide");
          // Block UI
          mApp.blockPage({
            overlayColor: "#000000",
            type: "loader",
            state: "success",
            message: "Please wait..."
          }), setTimeout(function () {
            mApp.unblockPage()
          }, 2e3);
          var obj = $.parseJSON(e);
          if (obj.status == 1) {
            a.removeClass("m-loader m-loader--right m-loader--light").attr("disabled", !1);
            $("#"+modal_id).modal('toggle');
            $("."+form_id+"_fields").val('');
            $("."+form_id+"_select").val('').trigger("change");
            toastr[obj.flashdata_type](obj.flashdata_msg, obj.flashdata_title);
            table.ajax.reload();
          } else {
            a.removeClass("m-loader m-loader--right m-loader--light").attr("disabled", !1);
            toastr[obj.flashdata_type](obj.flashdata_msg, obj.flashdata_title);
          }
          if (obj == null) {
            setTimeout(function () {
              a.removeClass("m-loader m-loader--right m-loader--light").attr("disabled", !1);
              toastr["warning"]("Your Attempt is Timed Out. Please Try Again.", "Timed Out");
            }, 2e4)
          }
        },error: function() {
          a.removeClass("m-loader m-loader--right m-loader--light").attr("disabled", !1);
          toastr["error"]("Sorry. There Has Been Some Error Occurred. Please Try Again.", "Error");
        }
      })
      )
    });
  };
  return {
    init:function() {
      t()
    }
  }
}

();
jQuery(document).ready(function() {
  Datatable.init();
  $(".hidden").hide();
  //            $('#service_view_table').wrap("");
}

);
</script>
<script>
  $('body').on('click', '#work_type_edit_btn', function() {
    var no = $(this).closest('tr').children('td');

    $('#work_type_id').val(no.eq(0).text());
    $('#work_type_name').val(no.eq(1).text());

  })
</script>
