<?php $this->view("includes/Inc_pagehead"); ?>
<!-- Page Styles Goes Here-->

<?php $this->view("includes/Inc_navigation"); ?>
<div class="m-grid__item m-grid__item--fluid m-wrapper">
  <!-- BEGIN: Subheader -->
  <div class="m-subheader ">
    <div class="d-flex align-items-center">
      <div class="mr-auto">
        <h3 class="m-subheader__title m-subheader__title--separator">
          Subcontract Bills & Payments
        </h3>
        <ul class="m-subheader__breadcrumbs m-nav m-nav--inline">
          <li class="m-nav__item m-nav__item--home">
            <a href="#" class="m-nav__link m-nav__link--icon">
              <i class="m-nav__link-icon la la-home"></i>
            </a>
          </li>
          <li class="m-nav__separator">
            -
          </li>
          <li class="m-nav__item">
            <a href="<?php echo base_url() . 'dashboard' ?>" class="m-nav__link">
              <span class="m-nav__link-text">
                Home
              </span>
            </a>
          </li>
          <li class="m-nav__separator">
            -
          </li>
          <li class="m-nav__item">
            <a href="<?php echo base_url() . 'subcontracts/payments' ?>" class="m-nav__link">
              <span class="m-nav__link-text">
                Subcontract Bills & Payments
              </span>
            </a>
          </li>
        </ul>
      </div>
      <div>
      </div>
    </div>
  </div>
  <!-- END: Subheader -->
  <div class="m-content">
    <div class="m-portlet  m-portlet--rounded m-portlet--bordered">
      <div class="m-portlet__body" style="padding: 1rem 2.2rem;">
        <div class="m-form m-form--label-align-right m--margin-bottom-10">
          <div class="row align-items-center">
            <div class="col-xl-12 order-2 order-xl-1">
              <div class="form-group m-form__group row ">
                <div class="col-md-3">
                  <div class="form-group m-form__group">
                    <label> Date:</label>
                    <input id="table_filter_date_range" type="text" class="form-control m-input m-input--air m-input--pill">
                  </div>
                </div>
                <div class="col-md-3">
                  <div class="form-group m-form__group">
                    <label>
                      Work:
                    </label>
                    <div class="m-select2 m-select2--air m-select2--pill">
                      <select style="width: 100%" class="form-control m-select2 table_filter" id="table_filter_work" name="work" data-placeholder="Select Work">
                        <option value="all">All Works</option>
                        <?php
                        foreach ($work_contracts as $row) : ?>
                        <option data-work-status="<?php echo $row->work_status ?>" value="<?php echo $row->work_id ?>"><?php echo $row->work_name ?></option>
                        <?php
                      endforeach;
                      ?>
                    </select>
                  </div>
                  <span class="m-form__help"></span>
                </div>
              </div>
              <div class="col-md-3">
                <div class="form-group m-form__group">
                  <label>
                    Work Types:
                  </label>
                  <div class="m-select2 m-select2--air m-select2--pill">
                    <select style="width: 100%" class="form-control m-select2 table_filter" id="table_filter_work_type" name="work_type" data-placeholder="Select Work Type">
                      <option value="all">All Work Types</option>
                      <?php
                      foreach ($work_types as $row) : ?>
                      <option value="<?php echo $row->type_id ?>"><?php echo $row->type_name ?></option>
                      <?php
                    endforeach;
                    ?>
                  </select>
                </div>
                <span class="m-form__help"></span>
              </div>
            </div>
            <div class="col-md-3">
              <div class="form-group m-form__group">
                <label>
                  Contractor:
                </label>
                <div class="m-select2 m-select2--air m-select2--pill">
                  <select style="width: 100%" class="form-control m-select2 table_filter" id="table_filter_contractor" name="contractor" data-placeholder="Select Contractor">
                    <option value="all">All Contractors</option>
                    <?php
                    foreach ($contractors as $row) : ?>
                    <option value="<?php echo $row->contractor_id ?>"><?php echo $row->contractor_name." [".$row->phone."]" ?></option>
                    <?php
                  endforeach;
                  ?>
                </select>
              </div>
              <span class="m-form__help"></span>
            </div>
          </div>
          <div class="col-md-3">
            <div class="form-group m-form__group">
              <label>
                Payment Status:
              </label>
              <div class="m-select2 m-select2--air m-select2--pill">
                <select style="width: 100%" class="form-control m-select2 table_filter" id="table_filter_subcontract_bill_payment_status"  name="payment_status" data-placeholder="Select Status">
                  <option selected value="all">All Bills</option>
                  <option value="1">Paid</option>
                  <option value="0">Not Paid</option>
                </select>
              </div>
              <span class="m-form__help"></span>
            </div>
          </div>
          <?php if (!empty($this->config->item('company_branches'))) { ?>

            <div class="col-lg-3">
              <div class="form-group m-form__group">
                <label>
                  Company Branch
                </label>
                <div class="m-select2 m-select2--air m-select2--pill">
                  <select width="100%" required class="form-control m-select2 table_filter company-branch-select2" id="company_branch">
                    <option selected value="all"> All Branches</option>
                    <option value="0">NO BRANCH</option>
                    <?php foreach ($this->config->item('company_branches') as $key => $value) { ?>
                      <option value="<?php echo $value->branch_id ?>"><?php echo $value->branch_name ?></option>
                    <?php } ?>
                  </select>
                </div>
                <span class="m-form__help"></span>
              </div>
            </div>

          <?php } ?>

        </div>
      </div>
    </div>
  </div>
</div>
</div>
<div class="m-portlet m-portlet--mobile m-portlet--focus m-portlet--head-solid-bg m-portlet--bordered m-portlet--rounded">
  <div class="m-portlet__head">
    <div class="m-portlet__head-caption">
      <div class="m-portlet__head-title">
        <h3 class="m-portlet__head-text">
          Subcontract Bills
        </h3>
      </div>
    </div>
  </div>
  <div class="m-portlet__body">
    <?php $this->view("modules/include_tables/table_subcontract_bills"); ?>
  </div>
</div>
<div class="m-portlet m-portlet--mobile m-portlet--info m-portlet--head-solid-bg m-portlet--bordered m-portlet--rounded">
  <div class="m-portlet__head">
    <div class="m-portlet__head-caption">
      <div class="m-portlet__head-title">
        <h3 class="m-portlet__head-text">
          Subcontract Payments List
        </h3>
      </div>
    </div>
  </div>
  <div class="m-portlet__body">
    <?php $this->view("modules/include_tables/table_subcontract_payments"); ?>
  </div>
</div>
<div class="m-portlet m-portlet--mobile m-portlet--info m-portlet--head-solid-bg m-portlet--bordered m-portlet--rounded">
  <div class="m-portlet__head">
    <div class="m-portlet__head-caption">
      <div class="m-portlet__head-title">
        <h3 class="m-portlet__head-text">
          Subcontract Payments Summary - Work Type Wise
        </h3>
      </div>
    </div>
  </div>
  <div class="m-portlet__body">
    <?php $this->view("modules/include_tables/table_subcontract_payments_by_type"); ?>
  </div>
</div>
<div class="m-portlet m-portlet--mobile m-portlet--warning m-portlet--head-solid-bg m-portlet--bordered m-portlet--rounded">
  <div class="m-portlet__head">
    <div class="m-portlet__head-caption">
      <div class="m-portlet__head-title">
        <h3 class="m-portlet__head-text">
          Subcontract Labour Bill Report
        </h3>
      </div>
    </div>
  </div>
  <div class="m-portlet__body">
    <?php $this->view("modules/include_tables/table_subcontract_bill_labours"); ?>
  </div>
</div>
<?php $this->view("modules/include_modals/modal_bills"); ?>
<?php $this->view("modules/include_modals/modal_transaction_delete"); ?>
</div>
</div>
</div>
<!-- end:: Body -->
<!-- begin::Footer -->

<?php $this->view("includes/Inc_footer"); ?>
<!-- end::Footer -->
</div>
<!-- end:: Page -->

<?php $this->view("includes/Inc_sidebar"); ?>
<?php $this->view("includes/Inc_scripts"); ?>

<!--begin::Page Snippets -->
<script>
$("#subcontract_menu").addClass('m-menu__item--active m-menu__item--open');
$("#subcontract_menu_2").addClass('m-menu__item--active');

$("#table_filter_work").select2({
  placeholder: "Select  Material",
  templateResult: format_project_dropdown
})
$("#table_filter_work_type").select2({
  placeholder: "Select  Work Type"
})
$("#table_filter_subcontract_bill_payment_status").select2({
  placeholder: "Select Payment Status"
})
$("#table_filter_contractor").select2({
  placeholder: "Select  Contractor"
})
</script>

<?php $this->view("modules/include_scripts/bill_scripts"); ?>
<?php $this->view("modules/include_scripts/transaction_scripts"); ?>

<?php $this->view("modules/include_scripts/subcontract_payments_view_scripts"); ?>
<?php $this->view("modules/include_scripts/subcontract_bill_scripts"); ?>
<?php $this->view("modules/include_scripts/subcontract_bill_labours_view_scripts"); ?>
<script>
// Date Range Picker
var start = moment();
var end = moment();

function cb(start, end) {
  $('#table_filter_date_range').val(start.format('MMMM D, YYYY') + ' - ' + end.format('MMMM D, YYYY'));
  subcontract_payments_view_table.ajax.reload();
  subcontracts_payment_by_type_view_table.ajax.reload();
  subcontract_bills_view_table.ajax.reload();
  bill_labour_wage_view_table.ajax.reload();
}

$('#table_filter_date_range').daterangepicker({
  buttonClasses: "m-btn btn",
  applyClass: "btn-primary",
  cancelClass: "btn-secondary",
  startDate: start,
  endDate: end,
  locale: {
    format: 'MMMM D, YYYY'
  },
  ranges: {
    'Today': [moment(), moment()],
    'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
    'Last 7 Days': [moment().subtract(6, 'days'), moment()],
    'Last 30 Days': [moment().subtract(29, 'days'), moment()],
    'This Month': [moment().startOf('month'), moment().endOf('month')],
    'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')],
    'All time': [moment('1970-01-01'), moment().add(9999, 'days')],
  }
}, cb);

cb(start, end);
</script>
