<?php $this->view("includes/Inc_pagehead");?>
<!-- Page Styles Goes Here-->

<?php $this->view("includes/Inc_navigation");?>
<div class="m-grid__item m-grid__item--fluid m-wrapper">
  <!-- BEGIN: Subheader -->
  <div class="m-subheader ">
    <div class="d-flex align-items-center">
      <div class="mr-auto">
        <h3 class="m-subheader__title m-subheader__title--separator">
          Add New Stock Transfer
        </h3>
        <ul class="m-subheader__breadcrumbs m-nav m-nav--inline">
          <li class="m-nav__item m-nav__item--home">
            <a href="#" class="m-nav__link m-nav__link--icon">
              <i class="m-nav__link-icon la la-home"></i>
            </a>
          </li>
          <li class="m-nav__separator">
            -
          </li>
          <li class="m-nav__item">
            <a href="<?php echo base_url().'dashboard'?>" class="m-nav__link">
              <span class="m-nav__link-text">
                Home
              </span>
            </a>
          </li>
          <li class="m-nav__separator">
            -
          </li>
          <li class="m-nav__item">
            <a href="<?php echo base_url().'stock/transfer_add' ?>" class="m-nav__link">
              <span class="m-nav__link-text">
                Add New Stock Transfer
              </span>
            </a>
          </li>


        </ul>
      </div>
      <div>

      </div>
    </div>
  </div>
  <!-- END: Subheader -->
  <div class="m-content">
    <div class="m-portlet  m-portlet--rounded m-portlet--bordered">
      <div class="m-portlet__body" style="padding: 1rem 2.2rem;">
        <form autocomplete="off" id="form_transfer_add" method="post" action="javascript:;" enctype="multipart/form-data" class="m-form m-form--fit m-form--state m-form--label-align-right " >
          <div class="m-form m-form--label-align-right m--margin-bottom-10">

              <?php if($this->config->item('app_module_vehicle_management')==1){ ?>
                <div class="row ">
                <div class="col-lg-2">
                  <div class="form-group m-form__group m-select2--pill">
                    <label for="user_name">
                      Vehicle Type
                    </label>
                    <div class="m-select2 m-select2--air m-select2--pill">
                      <select style="width: 100%" class="form-control m-select2 m-select2-general" id="vehicle_type_add" name="vehicle_type" data-placeholder="Select Category">
                        <option value="all" selected>All Types</option>
                        <option value="own">Owned</option>
                        <option value="rent">Rental</option>
                      </select>
                    </div>
                    <span class="m-form__help"></span>
                  </div>
                </div>
                <div class="col-lg-4">
                  <div class="form-group m-form__group" >
                    <label for="user_name">
                      Vehicle Name
                    </label>
                    <div class="input-group m-input-group m-input-group--pill">
                      <div class="input-group-prepend">
                        <a href="#vehicle_add_modal"   data-toggle="modal" data-target="#vehicle_add_modal" class="btn btn-focus">
                          <i class="fa fa-plus-circle"></i>
                        </a>
                      </div>
                      <select style="width: 82%" class="form-control m-select2 m-select2-general"  id="vehicle_add" name="vehicle_id" data-placeholder="Select the vehicle">

                      </select>
                    </div>
                    <span class="m-form__help"></span>
                  </div>
                </div>
                </div>
              <?php } ?>
              <div class="row ">
              <div class="col-xl-12 order-2 order-xl-1">
                <div class="row">
                  <div class="col-lg-4">
                    <div class="form-group m-form__group"  >
                      <label for="user_name">
                        Select Transfer From
                      </label>
                      <div class="m-select2 m-select2--air m-select2--pill">
                        <select required id="location_from" name="location_from_1"  style="width: 100%" class="form-control m-input" aria-describedby="basic-addon1" data-placeholder="Select Location">
                          <?php if($this->config->item('app_module_stock_management')==1){?>
                            <option selected disabled>Select Location</option>
                          <?php }else{?>
                            <option selected disabled>Select Work</option>
                          <?php } ?>
                          <?php
                          foreach($stock_locations as $row):
                            $location_name = $row->location_name;
                            if($this->config->item('app_module_stock_management')==1){
                              if($row->location_type=='work_site'){
                                $location_name .= " [Work Site]";
                              }elseif($row->location_type=='ware_house'){
                                $location_name .= " [Warehouse]";
                              }
                            }
                            ?>
                            <option data-work-status="<?php echo $row->work_status?>" value="<?php echo $row->location_id?>"><?php echo $location_name?></option>
                            <?php
                          endforeach;
                          ?>
                        </select>
                      </div>
                      <span class="m-form__help"></span>
                    </div>
                  </div>
                  <div class="col-lg-4">
                    <div class="form-group m-form__group"  >
                      <label for="user_name">
                        Select Transfer To
                      </label>
                      <div class="m-select2 m-select2--air m-select2--pill">
                        <select required id="location_to" name="location_to_1" style="width: 100%" class="form-control m-input" aria-describedby="basic-addon1" data-placeholder="Select Location">
                          <?php if($this->config->item('app_module_stock_management')==1){?>
                            <option selected disabled>Select Location</option>
                          <?php }else{?>
                            <option selected disabled>Select Work</option>
                          <?php } ?>
                          <?php
                          foreach($stock_locations as $row):
                            $location_name = $row->location_name;
                            if($this->config->item('app_module_stock_management')==1){
                              if($row->location_type=='work_site'){
                                $location_name .= " [Work Site]";
                              }elseif($row->location_type=='ware_house'){
                                $location_name .= " [Warehouse]";
                              }
                            }
                            ?>
                            <option data-work-status="<?php echo $row->work_status?>" data-location-type="<?php echo $row->location_type ?>" data-work_id="<?php echo $row->work_id ?>" value="<?php echo $row->location_id?>"><?php echo $location_name?></option>
                            <?php
                          endforeach;
                          ?>
                        </select>
                      </div>
                      <span class="m-form__help"></span>
                    </div>
                  </div>
                  <div class="col-lg-2">
                    <div class="form-group m-form__group" >
                      <label> Transfer Date:</label>
                      <div class="input-group m-input-group--air m-input-group--pill date">
                        <input required data-date-format="dd-mm-yyyy" autocomplete="off" id="transfer_date" name="transfer_date_1"  type="text" class="form-control  m-input " placeholder="Transfer Date" >
                      </div>

                    </div>
                  </div>
                  <div class="col-lg-1">
                    <br/>
                    <button type="submit" style="margin-top: 7px;float:right" id="btn_go" class="btn btn-focus m-btn m-btn--custom m-btn--icon m-btn--air m-btn--pill">
                      <span>
                        <i class="la la-search"></i>
                        <span>
                          Go
                        </span>
                      </span>
                    </button>
                  </div>
                </div>

              </div>
            </div>
          </div>
        </form>
        <form autocomplete="off" id="form_items_add" method="post" action="<?php echo base_url()?>stock/create_transfer" style="display: none" enctype="multipart/form-data" class="cart_div m-form m-form--fit m-form--state m-form--label-align-right " >
          <input type="hidden" name="location_form" id="location_from_2" />
          <input type="hidden" name="location_to" id="location_to_2" />
          <input type="hidden" name="transfer_date" id="transfer_date_2" />
          <input type="hidden" name="vehicle_id" id="vehicle_id_2" />
          <div style="background: white;border: 4px solid #f7f7fa;padding: 10px;margin: 5px;padding-bottom: 0px;" >
            <div class="m-section">
              <div class="row">
                <div class="col-lg-6">
                  <h3 class="m-section__heading">Cart Items</h3>
                </div>
                <div class="col-lg-6">
                  <button style="float: right;margin-bottom: 10px" type="button" id="btn_add_item" class="btn btn-brand">
                    Add Items to Cart
                  </button>
                </div>
              </div>
              <div class="row">
                <div class="col-lg-12">
                  <table style="width: 100%;"  id="table_items" class="table m-table m-table--head-bg-success order-list table-striped table-bordered table-advance table-hover">
                    <thead>
                      <tr>
                        <th style="width:5%">Sl No</th>
                        <th style="width:30%">Material</th>
                        <th style="width:15%">Item Code</th>
                        <th style="width:12%">Unit</th>
                        <th style="width:12%">Unit Price</th>
                        <th style="width:15%">Available Qty</th>
                        <th style="width:15%">Transfer Qty</th>
                        <th style="width:20%">Transfer Amount</th>
                        <th style="width:6%">&nbsp;</th>
                      </tr>
                    </thead>
                    <tbody id="table_body">

                    </tbody>
                  </table>
                  <input type="hidden" value="0" id="current_row_count" name="current_row_count" >
                </div>
              </div>
            </div>
          </div>
          <div  style="background: white;border: 4px solid #f7f7fa;padding: 30px;margin: 20px;padding-bottom: 0px;" >
            <div class="m-section">
              <h3 class="m-section__heading">Summary</h3>
              <div class="row">
                <div class="col-lg-6">
                  <div class="form-group m-form__group" style="padding-bottom: 10px">
                    <label for="user_name">
                      Total Items
                    </label>
                    <div class="input-group m-input-group m-input-group--pill m-input-group--air">
                      <div class="input-group-prepend">
                        <span class="input-group-text" id="basic-addon1">
                          <i class="la la-edit"></i>
                        </span>
                      </div>
                      <input value="0" readonly type="text" name="total_items" id="total_items"  class="form-control  m-input" aria-describedby="basic-addon1">
                    </div>
                  </div>
                  <div class="form-group m-form__group" style="padding-top: 0px">
                    <label for="user_name">
                      Total Item Cost
                    </label>
                    <div class="input-group m-input-group m-input-group--pill m-input-group--air">
                      <div class="input-group-prepend">
                        <span class="input-group-text" id="basic-addon1">
                          <?php echo $this->config->item('Currency_currency_format'); ?>
                        </span>
                      </div>
                      <input value="0" readonly type="text" name="total_item_cost" id="total_item_cost"  class=" form-control m-input"  aria-describedby="basic-addon1">
                    </div>
                  </div>
                </div>
                <div class="col-lg-6">
                  <div class="form-group m-form__group" style="padding-top: 0px">
                    <label for="user_name">
                      Remarks
                    </label>
                    <textarea rows="3" name="remarks" id="remarks"   class="form-control  m-input  m-input--air m-input--pill" placeholder="Remarks" ></textarea>
                    <span class="m-form__help"></span>
                  </div>
                </div>

              </div>

            </div>
          </div>
          <?php if($this->config->item('app_module_vehicle_management')==1){ ?>
            <div class="m-form__content" style="display:none;margin-top:15px;padding: 0px" id="vehicle_work_slip_div">
              <div style="background: white;border: 4px solid #f7f7fa;padding: 15px;margin: 5px;padding-bottom: 0px">
                <div class="m-section" style="margin-bottom: 10px">
                  <h3 class="m-section__heading">Vehicle Work Slip Details</h3>
                  <div class="row">
                    <div class="col-lg-3" style="padding-right:5px">
                      <div class="form-group m-form__group" >
                        <label for="user_name">
                          Worked Duration
                        </label>
                        <div class="input-group m-input-group m-input-group--pill m-input-group--air">
                          <input value="0"  type="text" name="vehicle_worked_duration" id="vehicle_worked_duration_add"  class="vehicle_work_slip_calculate_fields vehicle_work_slip_required_fields form-control m-input" placeholder="Worked Duration" aria-describedby="basic-addon1" required>
                        </div>
                        <span class="m-form__help"></span>
                      </div>
                    </div>
                    <div class="col-lg-3" style="padding-right:5px;padding-left:5px">
                      <div class="form-group m-form__group m-select2--pill">
                        <label for="user_name">
                          Duration Type
                        </label>
                        <div class="m-select2 m-select2--air m-select2--pill">
                          <select style="width: 100%" class="form-control m-select2 m-select2-general vehicle_work_slip_required_fields vehicle_work_slip_calculate_fields"  id="vehicle_work_duration_type2_add" name="vehicle_work_duration_type" data-placeholder="Select Work Duration Type">
                            <option disabled="" selected="">Duration type</option>
                            <option value="Hour">Hour</option>
                            <option value="Trip">Trip</option>
                            <option value="Kilometer">Kilometer</option>
                            <option value="Day">Day</option>
                            <option value="Month">Month</option>
                          </select>
                        </div>
                        <span class="m-form__help"></span>
                      </div>
                    </div>
                    <div class="col-lg-3" style="padding-right:5px;padding-left:5px">
                      <div class="form-group m-form__group" >
                        <label for="user_name">
                          Basic Charge
                        </label>
                        <div class="input-group m-input-group m-input-group--pill m-input-group--air">
                          <input type="text" value="0"   name="vehicle_basic_charge" id="vehicle_basic_charge_add"  class="vehicle_work_slip_required_fields form-control m-input vehicle_work_slip_calculate_fields" placeholder="Basic Daily Wage" aria-describedby="basic-addon1" >
                        </div>
                        <span class="m-form__help"></span>
                      </div>
                    </div>
                    <div class="col-lg-3" style="padding-right:5px;padding-left:5px">
                      <div class="form-group m-form__group" style="padding-top:0px;padding-bottom:10px;" >
                        <label for="user_name">
                          Total Basic Charge
                        </label>
                        <div class="input-group m-input-group m-input-group--pill m-input-group--air">
                          <input type="text" value="0"  readonly  name="vehicle_basic_charge_total" id="vehicle_total_basic_charge_add"  class="form-control m-input " placeholder="Basic Daily Wage" aria-describedby="basic-addon1" >
                        </div>
                        <!-- <span class="m-form__help"></span> -->
                      </div>
                    </div>
                  </div>
                  <div class="row owned_vehicle_fields_add" style="display:none" >
                    <div class="col-lg-4" style="padding-right:5px;" >
                      <div class="form-group m-form__group m-select2--pill">
                        <label for="user_name">
                          Driver/Operator
                        </label>
                        <div class="m-select2 m-select2--air m-select2--pill">
                          <select style="width: 100%" class="form-control m-select2 m-select2-general owned_vehicle_required_fields_add"  id="vehicle_driver_add" name="vehicle_driver" data-placeholder="Select Driver">

                          </select>
                        </div>
                        <span class="m-form__help"></span>
                      </div>
                    </div>
                    <div class="col-lg-8">
                      <div class="row">
                        <div class="col-lg-5">
                          <div class="row">
                            <div class="col-lg-6" style="padding-right:5px;padding-left:5px">
                              <div class="form-group m-form__group" >
                                <label for="user_name">Start Time</label>
                                <input class="form-control m-input m-input--air m-input--pill" name="vehicle_start_time" id="vehicle_start_time_add" readonly placeholder="Select time" type="text" />
                              </div>
                            </div>
                            <div class="col-lg-6" style="padding-right:5px;padding-left:5px">
                              <div class="form-group m-form__group" >
                                <label for="user_name">End Time</label>
                                <input class="form-control m-input m-input--air m-input--pill" name="vehicle_end_time" id="vehicle_end_time_add" readonly placeholder="Select time" type="text" />
                              </div>
                            </div>
                          </div>
                        </div>
                        <div class="col-lg-7">
                          <div class="row">
                            <div class="col-lg-4" style="padding-right:5px;padding-left:5px">
                              <div class="form-group m-form__group" >
                                <label for="user_name">Starting KM</label>
                                <input class="form-control m-input m-input--air m-input--pill form_vehicle_work_slip_add_fields" name="vehicle_start_km" id="vehicle_start_km_add"  placeholder="Kilometer" type="text" />
                              </div>
                            </div>
                            <div class="col-lg-4" style="padding-left:5px;padding-left:5px">
                              <div class="form-group m-form__group" >
                                <label for="user_name">Ending KM</label>
                                <input class="form-control m-input m-input--air m-input--pill form_vehicle_work_slip_add_fields" name="vehicle_end_km" id="vehicle_end_km_add" placeholder="Kilometer" type="text" />
                              </div>
                            </div>
                            <div class="col-lg-4" style="padding-left:5px">
                              <div class="form-group m-form__group" >
                                <label for="user_name">Total KM</label>
                                <input class="form-control m-input m-input--air m-input--pill form_vehicle_work_slip_add_fields" readonly value="0" name="vehicle_total_km" id="vehicle_total_km_add" placeholder="Kilometer" type="text" />
                              </div>
                            </div>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                  <div class="row owned_vehicle_fields_add" style="display:none" >
                    <div class="col-lg-3">
                      <div class="form-group m-form__group" >
                        <label for="user_name">
                          Driver Bata
                        </label>
                        <div class="input-group m-input-group m-input-group--pill">
                          <input value="0"  type="text" name="driver_bata" id="driver_bata_add"  class=" vehicle_work_slip_calculate_fields form_vehicle_work_slip_add_fields_1 form-control m-input m-input--air m-input--pill" placeholder="Location" aria-describedby="basic-addon1">
                          <div class="input-group-append">
                            <span class="input-group-text">
                              <label class="m-checkbox m-checkbox--single m-checkbox--state m-checkbox--state-primary">
                                <input type="checkbox" class="vehicle_work_slip_calculate_fields" value="1" name="driver_bata_include" id="driver_bata_include_add" checked="checked">
                                <span></span>
                              </label>
                            </span>
                          </div>
                        </div>
                        <span class="m-form__help">Check to Include in Payable</span>
                      </div>
                    </div>
                    <div class="col-lg-6"></div>
                    <div class="col-lg-3">
                      <div class="form-group m-form__group" style="padding-top:0px;padding-bottom:10px;" >
                        <label for="user_name">
                          Total Vehicle Charge
                        </label>
                        <div class="input-group m-input-group m-input-group--pill m-input-group--air">
                          <input type="text" value="0"  readonly  name="vehicle_total_charge" id="vehicle_total_charge"  class="form-control m-input " placeholder="" aria-describedby="basic-addon1" >
                        </div>
                        <!-- <span class="m-form__help"></span> -->
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          <?php } ?>
          <div class="m-portlet__foot m-portlet__foot--fit">
            <div class="m-form__actions m-form__actions">
              <div class="row">
                <div class="col-lg-9 ml-lg-auto">
                  <button type="submit" class="btn btn-brand form_submit_btn_2">
                    Save & Submit
                  </button>
                  <button type="reset" class="btn btn-secondary">
                    Cancel
                  </button>
                </div>
              </div>
            </div>
          </div>
        </form>
      </div>
    </div>
    <div style="display: none" id="stock_list_div" class="m-portlet m-portlet--mobile m-portlet--info m-portlet--head-solid-bg m-portlet--bordered m-portlet--rounded">
      <div class="m-portlet__head">
        <div class="m-portlet__head-caption">
          <div class="m-portlet__head-title">
            <h3 class="m-portlet__head-text" id="stock_list_div_title"></h3>
          </div>
        </div>
        <div class="m-portlet__head-tools">

        </div>
      </div>
      <div class="m-portlet__body">
        <!--begin: Datatable -->
        <table width="100%" class="table m-table  table-header-fixed table-striped- table-bordered table-hover table-header-fixed" id="stock_list_table">
          <thead>
            <tr class="">
              <th rowspan="2">Sl No</th>
              <th rowspan="2">Stock ID</th>
              <th rowspan="2">Material ID</th>
              <th rowspan="2">Unit ID</th>
              <th rowspan="2">Location ID</th>
              <th rowspan="2">Material Name</th>
              <th rowspan="2">Unit</th>
              <th rowspan="2">Unit Price</th>
              <th rowspan="2">Supplier</th>
              <th colspan="2">Currently Available Stock</th>
              <th rowspan="2">Location</th>
              <th rowspan="2">Location Type</th>
              <th colspan="2" style="display: none">Total Purchased Stock</th>
              <th colspan="2" style="display: none">Total Transferred In Stock</th>
              <th colspan="2" style="display: none">Total Transferred Out Stock</th>
              <th colspan="2" style="display: none">Total Consumed Stock</th>
              <th rowspan="2">Supplier ID</th>
              <th rowspan="2"></th>
              <th rowspan="2"></th>
            </tr>
            <tr>
              <th><span class="hidden">Currently Available Stock</span> Qty</th>
              <th>Amount</th>
              <th><span class="hidden">Total Purchased Stock</span> Qty</th>
              <th>Amount</th>
              <th><span class="hidden">Total Transferred In Stock</span>Qty</th>
              <th>Amount</th>
              <th><span class="hidden">Total Transferred Out Stock</span>Qty</th>
              <th>Amount</th>
              <th><span class="hidden">Total Consumed Stock</span>Qty</th>
              <th>Amount</th>
            </tr>
          </thead>
          <tbody>
          </tbody>
        </table>
        <!--end: Datatable -->

      </div>
    </div>
  </div>
</div>
</div>
<!-- end:: Body -->
<!-- begin::Footer -->
<?php $this->view("modules/include_modals/modal_vehicle_add");?>
<?php $this->view("modules/include_modals/modal_vehicle_consignee_add");?>

<?php $this->view("includes/Inc_footer");?>
<!-- end::Footer -->
</div>
<!-- end:: Page -->

<?php $this->view("includes/Inc_sidebar");?>
<?php $this->view("includes/Inc_scripts");?>
<?php $this->view("modules/include_scripts/vehicles_scripts");?>
<!--begin::Page Snippets -->
<script>
$("#stock_menu").addClass('m-menu__item--active m-menu__item--open');
$("#stock_menu_2").addClass('m-menu__item--active');

$("#m_aside_left_minimize_toggle").addClass("m-brand__toggler--active");
$("#body").addClass("m-brand--minimize m-aside-left--minimize");

$("#transfer_date").datepicker( {
  todayHighlight:!0, orientation:"bottom left", templates: {
    leftArrow: '<i class="la la-angle-left"></i>', rightArrow: '<i class="la la-angle-right"></i>'
  },
  endDate: '+0d',
  <?php if($this->session->userdata('user_role')!='admin' && $this->config->item('User_calendar_date_restriction_enabled')==1){ ?>
    startDate: '<?php echo $this->config->item('User_calendar_date_restriction_start_days');?>d'
    <?php } ?>
  })
  $("#location_from, #location_to").select2({
    // dropdownParent: $("#form_transfer_add"),
    placeholder: "Select Location",
    templateResult: format_project_dropdown
  })
  $("#btn_add_item").click(function() {
    $('html, body').animate({
      scrollTop: $("#stock_list_div").offset().top
    }, 1000);
  });
  jQuery.validator.addMethod("notEqual", function(value, element, param) {
    return $('#location_from').val() != $('#location_to').val()
  }, "Please Select a different Location");
  $("#form_transfer_add").validate( {
    rules: {
      location_from_1: {
        required: !0
      },
      location_to_1: {
        required: !0,
        notEqual: !0
      },
      transfer_date_1: {
        required: !0
      }
    },
    invalidHandler:function(e, r) {
      var i=$("#form_work_msg");
      i.removeClass("m--hide").show(), mUtil.scrollTo(i, -200)
    }
    , submitHandler:function(e) {
      $("#stock_list_div").show();
      $(".cart_div").show();
      stock_list_table();
      item_table();
      $("#location_from_2").val($("#location_from option:selected").val())
      $("#location_to_2").val($("#location_to option:selected").val())
      $("#vehicle_id_2").val($("#vehicle_add option:selected").val())
      $("#transfer_date_2").val($("#transfer_date").val())
      $("#btn_go").hide();
      $("#location_from").attr('disabled',true);
      $("#location_to").attr('disabled',true);
      $("#transfer_date").attr('disabled',true);
      $("#vehicle_add").attr('disabled',true);
    }
  }
);

$("#vehicle_start_time_add").timepicker({
  defaultTime: "<?php echo date("h:i A",strtotime($this->config->item('HR_duty_start_time')))?>",
  minuteStep: 1,
})
$("#vehicle_end_time_add").timepicker({
  defaultTime: "<?php echo date("h:i A",strtotime($this->config->item('HR_duty_end_time')))?>",
  minuteStep: 1,
})
$("#vehicle_add").select2({
  placeholder: "Select vehicle",
  dropdownParent: $("#form_transfer_add")
})
$("#vehicle_type_add").select2({
  placeholder: "Select Type",
  dropdownParent: $("#form_transfer_add")
})
$("#vehicle_type").select2({
  placeholder: "Select vehicle type",
  dropdownParent: $("#form_vehicle_add")
})
$("#work_duration_type").select2({
  placeholder: "Select vehicle type",
  dropdownParent: $("#form_vehicle_add")
})
$("#consignee_add").select2({
  placeholder: "Select Consignee",
  dropdownParent: $("#form_vehicle_add")
})
$("#vehicle_work_duration_type2_add").select2({
  placeholder: "Duration Type",
  dropdownParent: $("#form_transfer_add")
})
$("#vehicle_driver_add").select2({
  placeholder: "Select Driver",
  dropdownParent: $("#form_transfer_add")
})
$('body').on('change keyup', '#vehicle_start_km_add,#vehicle_end_km_add', function() {
  var start_km = parseFloat($('#vehicle_start_km_add').val());
  var end_km = parseFloat($('#vehicle_end_km_add').val());
  if (isNaN(end_km)) {
    end_km=0;
  }
  if (isNaN(start_km)) {
    start_km=0;
  }
  var total_km =  end_km - start_km;
  $('#vehicle_total_km_add').val(total_km);
})
$('body').on('change keyup', '.vehicle_work_slip_calculate_fields', function() {
  calculate_vehicle_charge();
})
function calculate_vehicle_charge(){

  var worked_duration = parseFloat($("#vehicle_worked_duration_add").val());
  var basic_charge = parseFloat($("#vehicle_basic_charge_add").val());
  // var overtime_duration = parseFloat($("#overtime_duration_vehicle_add").val());
  // var overtime_rate = parseFloat($("#overtime_rate_vehicle_add").val());
  // var overtime_amount = overtime_duration*overtime_rate;
  var driver_bata = 0;
  if($("#driver_bata_include_add").is(":checked")){
    driver_bata = parseFloat($("#driver_bata_add").val());
  }
  var total_basic_wage = (worked_duration*basic_charge);
  $("#vehicle_total_basic_charge_add").val(total_basic_wage);
  var total_payable =  total_basic_wage + driver_bata;
  $("#vehicle_total_charge").val(total_payable);
}
function select_consignee(select_id,selected_value=''){
  $('#'+select_id).html('');
  $('#'+select_id).append("<option disabled selected >Select Consignee</option>");
  $.post("<?php echo base_url() ?>vehicles/select_consignees_list",{},function(data) {
    var obj = $.parseJSON(data);
    var i=0;
    if(obj.count>0) {
      while (i < obj.data.length) {
        $('#'+select_id).append("<option value=" + obj.data[i]['consignee_id'] + ">" + obj.data[i]['consignee_name'] + "</option>");
        i++;
      }
      if(selected_value!=''){
        $('#'+select_id).val(selected_value).trigger("change");
      }
    }
  })
}
select_consignee('consignee_add');
select_vehicles("vehicle_add");
$('#vehicle_category_add,#vehicle_type_add').on("change", function(e) {
  var category = $('#vehicle_category_add :selected').val();
  var vehicle_type = $('#vehicle_type_add :selected').val();
  select_vehicles("vehicle_add",'',category,vehicle_type);
});
$('#vehicle_add').on("change", function(e) {
  var vehicle_no = $('#vehicle_add :selected').data('vehicle-no');
  $("#vehicle_no_add").val(vehicle_no);
  if(vehicle_no!=''){
    $("#vehicle_work_slip_div").show();
    $(".vehicle_work_slip_required_fields").attr('required',true);
  }else{
    $("#vehicle_work_slip_div").hide();
    $(".vehicle_work_slip_required_fields").removeAttr('required',true);
  }

  var vehicle_id = $('#vehicle_add').val();
  $.post("<?php echo base_url() ?>vehicles/select_details",{vehicle_id:vehicle_id},function(data) {
    var obj = $.parseJSON(data);
    var i=0;
    if(obj.count==1) {
      $("#vehicle_basic_charge_add").val(obj.data['basic_charge']);
      $('#vehicle_work_duration_type2_add').val(obj.data['work_duration_type']).trigger('change');

      $('#vehicle_driver_add').html('');
      $("#vehicle_driver_add").append("<option selected disabled >Select Driver</option>");
      if(obj.data['vehicle_type']=='own'){
        $(".owned_vehicle_fields_add").show();
        $(".owned_vehicle_required_fields_add").attr('required',true);
        var assigned_drivers = obj.data['assigned_drivers'];
        if(assigned_drivers!=''){
          var i=0;
          while (i < assigned_drivers.length) {
            $("#vehicle_driver_add").append("<option value=" + assigned_drivers[i]['employee_id'] + ">" + assigned_drivers[i]['employee_name'] + "</option>");
            i++;
          }
        }
      }else{
        $(".owned_vehicle_fields_add").hide();
        $(".owned_vehicle_required_fields_add").removeAttr('required',true);
      }
      calculate_vehicle_charge();
    }
  })
})
function select_vehicles(select_id,selected_value='',category='',vehicle_type=''){
  $('#'+select_id).html('');
  $('#'+select_id).append("<option disabled selected >Select Vehicle</option>");

  $.post("<?php echo base_url() ?>vehicles/select_vehicles_list",{category:category,vehicle_type:vehicle_type},function(data) {
    var obj = $.parseJSON(data);
    var i=0;
    if(obj.count>0) {
      while (i < obj.data.length) {
        $('#'+select_id).append("<option data-vehicle-no='"+obj.data[i]['vehicle_no']+"'  value=" + obj.data[i]['id'] + ">" + obj.data[i]['vehicle_name'] + " : "+obj.data[i]['vehicle_no']+" [" + obj.data[i]['consignee_name'] + "]</option>");
        i++;
      }
      if(selected_value!=''){
        $("#"+select_id).val(selected_value).trigger("change");
      }
    }
  })
}

var stock_list_table=function() {
  $('#stock_list_table').dataTable().fnDestroy();
  function GetSearchLocation(){
    return $('#location_from').val();
  }
  function GetSearchMaterial(){
    return $('#material_filter').val();
  }
  var loc_name = $("#location_from option:selected").text();
  $("#stock_list_div_title").text('List of Available Stock in '+loc_name);

  var table = $('#stock_list_table').DataTable({
    "ajax":{
      url :"<?php echo base_url().'stock/select_stock_register_2/transfer_list' ?>", // json datasource
      type: "post", // type of method  , by default would be get
      data: function(d){
        d.location_id = GetSearchLocation();
        d.material_id = GetSearchMaterial();
        d.quantity = 'available';
      }
    },
    "bProcessing": true,
    "deferRender": true,
    "bDeferRender": true,
    dom:"<'row'<'col-sm-6 text-left material_filter'><'col-sm-6 text-right'f>>\n\t\t\t<'row'<'col-sm-12'tr>>\n\t\t\t<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 dataTables_pager'lp>>", // horizobtal scrollable datatable
    "lengthMenu": [
      [25, 50, 100, -1],
      [25, 50, 100, "All"] // change per page values here
    ],
    "columnDefs": [
      {
        "targets": [ 1,2,3,4,11,12,13,14,15,16,17,18,19,20,21,23 ],
        className: "hidden"
      }
    ],
    'paging': false,
    'order': false
  });
  $(".hide_column").hide();
  $(".hidden").hide();
  $('<div class="form-group m-form__group row" >'+
  '<div class="col-lg-6"><div class="m-select2 m-select2--air m-select2--pill">'+
  '<select style="width: 100%" class="form-control m-select2 table_filter" id="material_filter"  name="material_filter" >'+
  '<option value="all">All Materials</option>'+
  <?php
  foreach($materials as $row): ?>
  '<option value="<?php echo $row->material_id?>"><?php echo $row->material_name.' [ in '.$row->unit_name.']';?></option>'+
  <?php
endforeach;
?>
'</select></div></div></div>').appendTo("#stock_list_table_wrapper .material_filter");
$("#material_filter").select2({
  // dropdownParent: $("#form_transfer_add"),
  placeholder: "Select Material"
})
$(".table_filter").on("change", function() {
  table.ajax.reload();
});
}

var item_table=function() {
  var table = $('#table_items').DataTable({
    "scrollX": true,
    bFilter: false,
    "bLengthChange": false,
    "bPaginate": false,
    "dom": "<'row' <'col-md-12'>><'row'<'col-md-6 col-sm-12'l><'col-md-6 col-sm-12'f>r><'table-scrollable't><'row'<'col-md-5 col-sm-12'i><'col-md-7 col-sm-12'p>>", // horizobtal scrollable datatable
    "lengthMenu": [
      [25, 50, 100, -1],
      [25, 50, 100, "All"] // change per page values here
    ],
    'ordering': false
  });
  $(".hidden").hide();
}
$('body').on('click', '#btn_transfer_cart', function() {
  var no = $(this).closest('tr').children('td');
  var location = $('#location_to').val();
  var location_type = $('#location_to :selected').data('location-type');
  var work_id = $('#location_to :selected').data('work_id');
  var stock_id = no.eq(1).text();
  var material_id = no.eq(2).text();
  var item_code = no.eq(23).text();
  var material_name = no.eq(5).text();
  var unit_id = no.eq(3).text();
  var unit_name = no.eq(6).text();
  var unit_price = no.eq(7).text();
  var supplier = no.eq(8).text();
  var available_qty = no.eq(9).text();
  var already_added=0;
  $(".items_stock_id").each(function(){
    if($(this).val()==stock_id){
      already_added=1;
    }
  });
  if(already_added==0){

    var boq_integration = <?= $this->config->item('boq_purchase_integration');?>;
    if(location_type=='work_site' && boq_integration == 1)
    {
      $.post("<?php echo base_url() ?>purchases/select_boq_task_item_for_purchase/"+work_id+"/"+location+"/"+material_id+"/"+unit_id,function(data) {
        var obj = $.parseJSON(data);
        if(obj.boq_count>0){
          if(obj.count>0){
            var d = obj;
            if(d.qnty>0){
              // Get Material Details
              $.post("<?php echo base_url() ?>material/select",{id:material_id},function(data) {
                var obj = $.parseJSON(data);
                var i=0;
                if(obj.count==1) {
                  $('#table_items').dataTable().fnDestroy();
                  var counter = parseInt($("#current_row_count").val());
                  var newRow = $("<tr>");
                  var cols = "";
                  cols += '<td><div class="form-group m-form__group" style="padding: 0px;margin: 0px;"><div class="input-group m-input-group m-input-group--pill m-input-group--air"><input style="padding: 10px" readonly type="text" class="form-control m-input" name="item[sl_no]['+(counter)+']" value="' + (counter+1) + '"/></div></div></td>';
                  cols += '<td><div class="form-group m-form__group" style="padding: 0px;margin: 0px;"><div class="input-group m-input-group m-input-group--pill m-input-group--air"><input type="text" readonly class="form-control m-input" name="item[material_name]['+(counter)+']" value="'+material_name+'" id="material_name_' + (counter+1) + '"/></div>';
                  cols += '<input type="hidden" class="items_stock_id" name="item[stock_id]['+(counter)+']" value="'+stock_id+'" id="stock_id_' + (counter+1) + '"/>';
                  cols += '</div></td>';

                  cols += '<td><div class="form-group m-form__group" style="padding: 0px;margin: 0px;"><div class="input-group m-input-group m-input-group--pill m-input-group--air"><input type="text" readonly class="form-control m-input" name="item[item_code]['+(counter)+']" value="'+item_code+'" id="item_code_' + (counter+1) + '"/></div></div></td>';
                  cols += '<td><div class="form-group m-form__group" style="padding: 0px;margin: 0px;"><div class="input-group m-input-group m-input-group--pill m-input-group--air"><input type="text" readonly class="form-control m-input" value="'+unit_name+'" name="item[unit_name]['+(counter)+']" id="unit_name_' + (counter+1) + '"/></div></div></td>';
                  cols += '<td><div class="form-group m-form__group" style="padding: 0px;margin: 0px;"><div class="input-group m-input-group m-input-group--pill m-input-group--air"><input type="text" readonly class="form-control m-input" value="'+unit_price+'" name="item[unit_price]['+(counter)+']" id="unit_price_' + (counter+1) + '"/></div></div></td>';
                  cols += '<td><div class="form-group m-form__group" style="padding: 0px;margin: 0px;"><div class="input-group m-input-group m-input-group--pill m-input-group--air"><input type="text" readonly class="form-control m-input" value="'+available_qty+'" name="item[available_qty]['+(counter)+']" id="available_qty_' + (counter+1) + '"/></div></div></td>';
                  cols += '<td><div class="form-group m-form__group" style="padding: 0px;margin: 0px;"><div class="input-group m-input-group m-input-group--pill m-input-group--air"><input type="text" required class="form-control m-input numeric_fields quantity" max="'+available_qty+'" data-sl-no="' + (counter+1) + '" value="1" name="item[quantity]['+(counter)+']" id="quantity_' + (counter+1) + '"/></div></div></td>';
                  cols += '<td><div class="form-group m-form__group" style="padding: 0px;margin: 0px;"><div class="input-group m-input-group m-input-group--pill m-input-group--air"><input type="text" readonly class="form-control m-input total_amount" value="'+unit_price+'" name="item[total_amount]['+(counter)+']" id="total_amount_' + (counter+1) + '"/></div></div></td>';
                  cols += '<td><a href="javascript:" class="ibtnDel btn-sm btn btn-danger btn-icon-only" ><i class="fa fa-trash"></i></td>';
                  cols += '</tr>';
                  newRow.append(cols);
                  $("#table_body").append(newRow);
                  counter++;
                  $("#current_row_count").val(counter);

                  item_table();
                  calculate_summary();
                  toastr["info"]("Item Added to Cart", "Added to Cart");

                }else{
                  toastr["error"]("Some Error Associated with Selected Material", "Error Occurred");
                }
              })
            }
            else{
              toastr["warning"]("The Quantity of the Selected material reached maximum ", "More Quantity Allowed");
            }
          }else{
            toastr["warning"]("Material not listed in BOQ OR Material Unit mismatching", "Not Allowed");
          }
        }else{
          toastr["warning"]("No Approved BOQ available", "No BOQ available");
        }
      })
    }else{
      $('#table_items').dataTable().fnDestroy();
      var counter = parseInt($("#current_row_count").val());
      var newRow = $("<tr>");
      var cols = "";
      cols += '<td><div class="form-group m-form__group" style="padding: 0px;margin: 0px;"><div class="input-group m-input-group m-input-group--pill m-input-group--air"><input style="padding: 10px" readonly type="text" class="form-control m-input" name="item[sl_no]['+(counter)+']" value="' + (counter+1) + '"/></div></div></td>';
      cols += '<td><div class="form-group m-form__group" style="padding: 0px;margin: 0px;"><div class="input-group m-input-group m-input-group--pill m-input-group--air">';
      cols += '<input type="text" readonly class="form-control m-input" name="item[material_name]['+(counter)+']" value="'+material_name+'" id="material_name_' + (counter+1) + '"/></div>';
      cols += '<input type="hidden" class="items_stock_id" name="item[stock_id]['+(counter)+']" value="'+stock_id+'" id="stock_id_' + (counter+1) + '"/>';
      cols += '</div></td>';
      cols += '<td><div class="form-group m-form__group" style="padding: 0px;margin: 0px;"><div class="input-group m-input-group m-input-group--pill m-input-group--air"><input type="text" readonly class="form-control m-input" name="item[item_code]['+(counter)+']" value="'+item_code+'" id="item_code_' + (counter+1) + '"/></div></div></td>';
      cols += '<td><div class="form-group m-form__group" style="padding: 0px;margin: 0px;"><div class="input-group m-input-group m-input-group--pill m-input-group--air"><input type="text" readonly class="form-control m-input" value="'+unit_name+'" name="item[unit_name]['+(counter)+']" id="unit_name_' + (counter+1) + '"/></div></div></td>';
      cols += '<td><div class="form-group m-form__group" style="padding: 0px;margin: 0px;"><div class="input-group m-input-group m-input-group--pill m-input-group--air"><input type="text" readonly class="form-control m-input" value="'+unit_price+'" name="item[unit_price]['+(counter)+']" id="unit_price_' + (counter+1) + '"/></div></div></td>';
      cols += '<td><div class="form-group m-form__group" style="padding: 0px;margin: 0px;"><div class="input-group m-input-group m-input-group--pill m-input-group--air"><input type="text" readonly class="form-control m-input" value="'+available_qty+'" name="item[available_qty]['+(counter)+']" id="available_qty_' + (counter+1) + '"/></div></div></td>';
      cols += '<td><div class="form-group m-form__group" style="padding: 0px;margin: 0px;"><div class="input-group m-input-group m-input-group--pill m-input-group--air"><input type="text" required class="form-control m-input numeric_fields quantity" max="'+available_qty+'" data-sl-no="' + (counter+1) + '" value="1" name="item[quantity]['+(counter)+']" id="quantity_' + (counter+1) + '"/></div></div></td>';
      cols += '<td><div class="form-group m-form__group" style="padding: 0px;margin: 0px;"><div class="input-group m-input-group m-input-group--pill m-input-group--air"><input type="text" readonly class="form-control m-input total_amount" value="'+unit_price+'" name="item[total_amount]['+(counter)+']" id="total_amount_' + (counter+1) + '"/></div></div></td>';
      cols += '<td><a href="javascript:" class="ibtnDel btn btn-sm btn-danger btn-icon-only" ><i class="fa fa-trash"></i></td>';
      cols += '</tr>';
      newRow.append(cols);
      $("#table_body").append(newRow);
      counter++;
      $("#current_row_count").val(counter);

      item_table();
      calculate_summary();
      toastr["info"]("Item Added to Cart", "Added to Cart");
    }

  }else{
    toastr["warning"]("Item Already Added to Cart", "Already Added");
  }

});
$("#table_body").on("click", ".ibtnDel", function (event) {
  var counter = parseInt($("#current_row_count").val());
  $(this).closest("tr").remove();
  counter -= 1;
  $("#current_row_count").val(counter);
});
$('body').on('change keyup', '.quantity', function() {
  var sl_no = $(this).attr('data-sl-no');
  var quantity = parseFloat($("#quantity_"+sl_no).val());
  var unit_price = parseFloat($("#unit_price_"+sl_no).val());
  $("#total_amount_"+sl_no).val(quantity*unit_price);
  calculate_summary();
});
function calculate_summary(){
  var total_items = total_item_cost = 0;
  $(".total_amount").each(function(){
    total_item_cost += +$(this).val();
  });
  $("#total_item_cost").val(total_item_cost);
  $("#total_items").val($("#current_row_count").val());
}

$(".form_submit_btn_2").click(function (e) {
  e.preventDefault();
  var a = $(this),
  l = $(this).closest("form"),
  action = l.attr('action');
  var form_id = l.attr('id');
  var items_count = $("#current_row_count").val();
  if(items_count>0){
    l.validate({
      rules: {
        quantity: {
          number: !0
        }
      }, invalidHandler: function (e, r) {
        var i = $("#" + form_id + "_msg");
        i.removeClass("m--hide").show(), mUtil.scrollTo(i, -200)
      }, submitHandler: function (e) {
      }
    }),
    $(".numeric_fields").each(function () {
      $(this).rules('add', {
        number: !0
      });
    }), l.valid() && (a.addClass("m-loader m-loader--right m-loader--light").attr("disabled", !0),
    l.ajaxSubmit({
      url: action,
      success: function (e, t, r, s) {
        var modal_id = l.attr('data-modal-id');
        var form_type = l.attr('data-form-type');
        $("#" + form_id + "_msg").addClass("m--hide");
        // Block UI
        mApp.blockPage({
          overlayColor: "#000000",
          type: "loader",
          state: "success",
          message: "Please wait..."
        }), setTimeout(function () {
          mApp.unblockPage()
        }, 2e3);
        var obj = $.parseJSON(e);
        if (obj.status == 1) {
          a.removeClass("m-loader m-loader--right m-loader--light").attr("disabled", !1);
          $("#"+modal_id).modal('toggle');
          $("."+form_id+"_fields").val('');
          $("."+form_id+"_select").val('').trigger("change");
          toastr[obj.flashdata_type](obj.flashdata_msg, obj.flashdata_title);

          swal({
            width: 500,
            title: obj.flashdata_title,
            text: obj.flashdata_msg,
            type: obj.flashdata_type,
            showCancelButton: !0,
            confirmButtonText: "View Transfer History",
            cancelButtonText: "Add New Transfer",
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            reverseButtons: !0,
            closeOnClickOutside: false,
            allowOutsideClick: false
            // html: "<br>" +
            //       '<a href="<?php echo base_url()?>subcontracts/profile/'+obj.subcontract_id+'"  class="SwalBtn1  btn btn-primary m-btn m-btn--custom customSwalBtn">' + 'View Subcontract Profile' + '</button>'
          }).then(function(e) {
            e.value ? window.location.replace("<?php echo base_url()?>stock/transfer_history/") : "cancel" === e.dismiss && location.reload()
          })
        } else {
          a.removeClass("m-loader m-loader--right m-loader--light").attr("disabled", !1);
          toastr[obj.flashdata_type](obj.flashdata_msg, obj.flashdata_title);
        }
        if (obj == null) {
          setTimeout(function () {
            a.removeClass("m-loader m-loader--right m-loader--light").attr("disabled", !1);
            toastr["warning"]("Your Attempt is Timed Out. Please Try Again.", "Timed Out");
          }, 2e4)
        }
      },error: function() {
        a.removeClass("m-loader m-loader--right m-loader--light").attr("disabled", !1);
        toastr["error"]("Sorry. There Has Been Some Error Occurred. Please Try Again.", "Error");
      }
    })
  )
}else{
  toastr["warning"]("Please Add Items to Cart", "Cart Empty");
}

});
$(".form_submit_btn").click(function (e) {
  e.preventDefault();
  var a = $(this),
  l = $(this).closest("form"),
  action = l.attr('action');
  var form_id = l.attr('id');
  l.validate({
    rules: {
      worked_duration: {
        number: !0,
        min: 1
      },
      basic_charge: {
        number: !0,
        min:0
      }
    }, invalidHandler: function (e, r) {
      var i = $("#" + form_id + "_msg");
      i.removeClass("m--hide").show(), mUtil.scrollTo(i, -200)
    }, submitHandler: function (e) {
    }
  }), l.valid() && (a.addClass("m-loader m-loader--right m-loader--light").attr("disabled", !0),
  l.ajaxSubmit({
    url: action,
    success: function (e, t, r, s) {
      var modal_id = l.attr('data-modal-id');
      var form_type = l.attr('data-form-type');
      $("#" + form_id + "_msg").addClass("m--hide");
      // Block UI
      mApp.blockPage({
        overlayColor: "#000000",
        type: "loader",
        state: "success",
        message: "Please wait..."
      }), setTimeout(function () {
        mApp.unblockPage()
      }, 2e3);
      var obj = $.parseJSON(e);
      if (obj.status == 1) {
        a.removeClass("m-loader m-loader--right m-loader--light").attr("disabled", !1);
        $("#"+modal_id).modal('toggle');
        $("."+form_id+"_fields").val('');
        $("."+form_id+"_fields_1").val(0);
        $("."+form_id+"_fields_2").val(1);
        $("."+form_id+"_select").val('').trigger("change");
        toastr[obj.flashdata_type](obj.flashdata_msg, obj.flashdata_title);
        select_consignee('consignee_add');
        select_vehicles("vehicle_add");
      } else {
        a.removeClass("m-loader m-loader--right m-loader--light").attr("disabled", !1);
        toastr[obj.flashdata_type](obj.flashdata_msg, obj.flashdata_title);
      }
      if (obj == null) {
        setTimeout(function () {
          a.removeClass("m-loader m-loader--right m-loader--light").attr("disabled", !1);
          toastr["warning"]("Your Attempt is Timed Out. Please Try Again.", "Timed Out");
        }, 2e4)
      }
    },error: function() {
      a.removeClass("m-loader m-loader--right m-loader--light").attr("disabled", !1);
      toastr["error"]("Sorry. There Has Been Some Error Occurred. Please Try Again.", "Error");
    }
  })
)
});
</script>
