<?php $this->view("includes/Inc_pagehead");?>
<!-- Page Styles Goes Here-->

<?php $this->view("includes/Inc_navigation");?>
<div class="m-grid__item m-grid__item--fluid m-wrapper">
  <!-- BEGIN: Subheader -->
  <div class="m-subheader ">
    <div class="d-flex align-items-center">
      <div class="mr-auto">
        <h3 class="m-subheader__title m-subheader__title--separator">
          Stock Report - Branches
        </h3>
        <ul class="m-subheader__breadcrumbs m-nav m-nav--inline">
          <li class="m-nav__item m-nav__item--home">
            <a href="#" class="m-nav__link m-nav__link--icon">
              <i class="m-nav__link-icon la la-home"></i>
            </a>
          </li>
          <li class="m-nav__separator">
            -
          </li>
          <li class="m-nav__item">
            <a href="<?php echo base_url().'dashboard'?>" class="m-nav__link">
              <span class="m-nav__link-text">
                Home
              </span>
            </a>
          </li>
          <li class="m-nav__separator">
            -
          </li>
          <li class="m-nav__item">
            <a href="<?php echo base_url().'stock/branch_report' ?>" class="m-nav__link">
              <span class="m-nav__link-text">
                Stock Report - Branches
              </span>
            </a>
          </li>


        </ul>
      </div>
      <div>

      </div>
    </div>
  </div>
  <!-- END: Subheader -->
  <div class="m-content">
    <div class="m-portlet m-portlet--mobile m-portlet--info m-portlet--head-solid-bg m-portlet--bordered m-portlet--rounded">
      <div class="m-portlet__head">
        <div class="m-portlet__head-caption">
          <div class="m-portlet__head-title">
            <h3 class="m-portlet__head-text">
              Stock Report - Branches
            </h3>
          </div>
        </div>
        <div class="m-portlet__head-tools">

        </div>
      </div>
      <div class="m-portlet__body">
        <div class="m-form m-form--label-align-right m--margin-bottom-10">
          <div class="row">
            <div class="col-xl-12 order-2 order-xl-1">
              <div class="form-group m-form__group row ">
                <div class="col-md-3">
                  <div class="form-group m-form__group">
                    <label>
                      Branch:
                    </label>
                    <div class="m-select2 m-select2--air m-select2--pill">
                      <select width="100%" required class="form-control m-select2 table_filter company-branch-select2" id="company_branch">
                        <option selected value="all"> All Branches</option>
                        <option value="0">NO BRANCH</option>
                        <?php foreach ($this->config->item('company_branches') as $key => $value) { ?>
                          <option value="<?php echo $value->branch_id ?>"><?php echo $value->branch_name ?></option>
                        <?php } ?>
                      </select>
                    </div>
                    <span class="m-form__help"></span>
                  </div>
                </div>
                <div class="col-md-3">
                  <div class="form-group m-form__group">
                    <label>
                      Material Category
                    </label>
                    <div class="m-select2 m-select2--air m-select2--pill">
                      <select style="width: 100%" class="form-control m-select2 table_filter" id="table_filter_material_category"  name="material_category" >
                        <option value="all">All Categories</option>
                        <?php
                        foreach($material_categories as $row): ?>
                        <option value="<?php echo $row->cat_id?>"><?php echo $row->cat_name;?></option>
                        <?php
                      endforeach;
                      ?>
                    </select>
                  </div>
                  <span class="m-form__help"></span>
                </div>
              </div>
              <div class="col-md-3">
                <div class="form-group m-form__group">
                  <label>
                    Material:
                  </label>
                  <div class="m-select2 m-select2--air m-select2--pill">
                    <select style="width: 100%" class="form-control m-select2 table_filter" id="table_filter_material"  name="table_filter_material" >
                      <option value="all">All Materials</option>

                    </select>
                  </div>
                  <span class="m-form__help"></span>
                </div>
              </div>
              <div class="col-md-3">
                <div class="form-group m-form__group">
                  <label>
                    Min Qty Available:
                  </label>
                  <div class="input-group m-input-group m-input-group--pill m-input-group--air">
                    <input value="10" type="text" name="min_qty" id="table_filter_min_qty" class="form-control m-input table_filter" placeholder="Min Qty" aria-describedby="basic-addon1">
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
      <table width="100%" class="table m-table nowrap table-header-fixed table-striped table-bordered table-hover table-header-fixed" id="stock_report_vew_table">
        <thead>
          <tr class="">
            <th>Sl No</th>
            <th>Branch</th>
            <th>Material Name</th>
            <th>Unit</th>
            <th>Available Qty</th>
          </tr>
        </thead>
        <tbody>
        </tbody>
      </table>

    </div>
  </div>
</div>


</div>
</div>
<!-- end:: Body -->
<!-- begin::Footer -->

<?php $this->view("includes/Inc_footer");?>
<!-- end::Footer -->
</div>
<!-- end:: Page -->

<?php $this->view("includes/Inc_sidebar");?>
<?php $this->view("includes/Inc_scripts");?>


<!--begin::Page Snippets -->
<script>

</script>
<script>
$("#stock_menu").addClass('m-menu__item--active m-menu__item--open');
$("#stock_menu_6").addClass('m-menu__item--active');

</script>
<script>
function select_material(category=''){
  var category = $('#table_filter_material_category :selected').val();
  $('#table_filter_material').html('');
  $("#table_filter_material").append("<option  selected value='all' >All Materials</option>");
  $.post("<?php echo base_url() ?>material/select",{category:category},function(data) {
    var obj = $.parseJSON(data);
    var i=0;
    if(obj.count>0) {
      while (i < obj.id.length) {
        $("#table_filter_material").append("<option value=" + obj.id[i] + ">" + obj.name[i] + " [" + obj.unit_name[i] + "]</option>");
        i++;
      }
    }
  })
}
select_material('all');
$('body').on('change', '#table_filter_material_category', function() {
  select_material();
});

$("#table_filter_work").select2({
  placeholder: "Select  Work",
  templateResult: format_project_dropdown
})
$("#table_filter_material").select2({
  placeholder: "Select  Material"
})
$("#table_filter_material_category").select2({
  placeholder: "Select  Material"
})

function GetSearchBranch(){
  return $('#company_branch').val();
}
function GetSearchMaterial(){
  return $('#table_filter_material').val();
}
function GetSearchMaterialCategory(){
  return $('#table_filter_material_category').val();
}
function GetSearchMinQty(){
  return $('#table_filter_min_qty').val();
}

var stock_report_vew_table = $('#stock_report_vew_table').DataTable({
  "ajax":{
    url :"<?php echo base_url().'stock/select_stock_report_branches' ?>", // json datasource
    type: "post", // type of method  , by default would be get
    data: function(d){
      d.branch = GetSearchBranch();
      d.material_id = GetSearchMaterial();
      d.material_category = GetSearchMaterialCategory();
      d.min_qty = GetSearchMinQty();
    }
  },
  "bProcessing": true,
  "deferRender": true,
  "bDeferRender": true,
  "scrollX" : true,
  scrollX:!0, scrollCollapse:!0,
  buttons: [
    { extend: 'print', className: 'btn dark btn-outline',exportOptions: {columns: ':visible'},title: 'Stock consumptions' },
    { extend: 'csv', className: 'btn purple btn-outline ' },
    { extend: 'colvis', className: 'btn dark btn-outline', text: 'Columns'}
  ],
  dom:"<'row'<'col-sm-6 text-left'B><'col-sm-6 text-right'f>>\n\t\t\t<'row'<'col-sm-12'tr>>\n\t\t\t<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 dataTables_pager'lp>>", // horizobtal scrollable datatable
  "lengthMenu": [
    [25, 50, 100, -1],
    [25, 50, 100, "All"] // change per page values here
  ],
  "columnDefs": [
    {
      "targets": [ ],
      className: "hidden"
    }
  ],
  'order': [[0, 'asc']]
});
$(".table_filter").on("change keyup", function() {
  stock_report_vew_table.ajax.reload();
});
$(".hide_column").hide();

</script>
