<?php $this->view("includes/Inc_pagehead");?>
<!-- Page Styles Goes Here-->

<?php $this->view("includes/Inc_navigation");?>
<div class="m-grid__item m-grid__item--fluid m-wrapper">
  <!-- BEGIN: Subheader -->
  <div class="m-subheader ">
    <div class="d-flex align-items-center">
      <div class="mr-auto">
        <h3 class="m-subheader__title m-subheader__title--separator">
          Stock Locations
        </h3>
        <ul class="m-subheader__breadcrumbs m-nav m-nav--inline">
          <li class="m-nav__item m-nav__item--home">
            <a href="#" class="m-nav__link m-nav__link--icon">
              <i class="m-nav__link-icon la la-home"></i>
            </a>
          </li>
          <li class="m-nav__separator">
            -
          </li>
          <li class="m-nav__item">
            <a href="<?php echo base_url().'dashboard'?>" class="m-nav__link">
              <span class="m-nav__link-text">
                Home
              </span>
            </a>
          </li>
          <li class="m-nav__separator">
            -
          </li>
          <li class="m-nav__item">
            <a href="<?php echo base_url().'stock/locations' ?>" class="m-nav__link">
              <span class="m-nav__link-text">
                Stock Locations
              </span>
            </a>
          </li>


        </ul>
      </div>
      <div>

      </div>
    </div>
  </div>
  <!-- END: Subheader -->
  <div class="m-content">
    <div class="m-portlet m-portlet--mobile m-portlet--info m-portlet--head-solid-bg m-portlet--bordered m-portlet--rounded">
      <div class="m-portlet__head">
        <div class="m-portlet__head-caption">
          <div class="m-portlet__head-title">
            <h3 class="m-portlet__head-text">
              Stock Locations
            </h3>
          </div>
        </div>
        <div class="m-portlet__head-tools">
          <?php if($this->session->userdata('user_role')!='auditor' || $this->session->userdata('user_data_permission')['adding']==1) { ?>
            <a href="#stock_location_add_modal" data-toggle="modal" data-target="#stock_location_add_modal" class="btn btn-focus m-btn m-btn--custom m-btn--icon m-btn--air m-btn--pill">
              <span>
                <i class="la la-plus"></i>
                <span>
                  Add Stock Location
                </span>
              </span>
            </a>
          <?php } ?>
        </div>
        <!-- Add Daily Report modal starts from here -->

        <!-- Add Daily Report Modal ends here -->
      </div>
      <div class="m-portlet__body">

        <table width="100%" class="table m-table nowrap table-header-fixed table-striped table-bordered table-hover table-header-fixed" id="stock_location_view_table">
          <thead>
            <tr class="">
              <th>Sl No</th>
              <th>ID</th>
              <th>Location Name</th>
              <th>Location Type</th>
              <th>Work</th>
              <th>Work ID</th>
              <th>type</th>
              <th>Action</th>
            </tr>
          </thead>
          <tbody>
          </tbody>
        </table>

        <div class="modal fade" tabindex="-1" id="stock_location_add_modal" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
          <div class="modal-dialog " role="document" >
            <div class="modal-content" >
              <div class="modal-header" style="background-color: #36a3f7;border-radius: 4px">
                <h5 class="modal-title" id="exampleModalLabel" style="color: #ffffff" >
                  Add Stock Location
                </h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                  <span aria-hidden="true">
                    &times;
                  </span>
                </button>
              </div>
              <form autocomplete="off" data-modal-id="stock_location_add_modal" id="form_stock_location_add" method="post" action="<?php echo base_url().'stock/create_location'?>" enctype="multipart/form-data" class="m-form m-form--fit m-form--state m-form--label-align-right " >
                <div class="modal-body">
                  <div class="m-form__content">
                    <div class="m-alert m-alert--icon alert alert-warning m--hide" role="alert" id="form_stock_location_add_msg">
                      <div class="m-alert__icon">
                        <i class="la la-warning"></i>
                      </div>
                      <div class="m-alert__text">
                        Oh snap! Change a few things up and try submitting again.
                      </div>
                      <div class="m-alert__close">
                        <button type="button" class="close" data-close="alert" aria-label="Close"></button>
                      </div>
                    </div>
                  </div>
                  <div class="row">
                    <div class="col-lg-12">
                      <div class="m-form__group form-group">
                        <label class="col-form-label">Location Type</label>
                        <div class="col-9">
                          <div class="m-radio-inline">
                            <label class="m-radio m-radio--solid m-radio--state-brand">
                              <input required type="radio" name="location_type" value="ware_house"> Ware House
                              <span></span>
                            </label>
                            <!-- <label class="m-radio m-radio--solid m-radio--state-success">
                              <input type="radio" name="location_type" value="work_site"> Work Site
                              <span></span>
                            </label> -->
                          </div>
                          <span class="m-form__help"></span>
                        </div>
                      </div>
                    </div>
                    <div class="col-lg-12" style="display: none" id="work_div">
                      <div class="form-group m-form__group">
                        <label for="user_name">
                          Work Name
                        </label>
                        <div class="m-select2 m-select2--air m-select2--pill">
                          <select  style="width: 100%" class="form-control m-select2 form_stock_location_add_select" id="work_add"  name="work_id" data-placeholder="Select Work">
                            <option selected disabled>Select Work</option>
                            <?php
                            foreach($work_contracts as $row): ?>
                              <option data-work-status="<?php echo $row->work_status?>" value="<?php echo $row->work_id?>"><?php echo $row->work_name?></option>
                              <?php
                            endforeach;
                            ?>
                          </select>
                        </div>
                        <span class="m-form__help"></span>
                      </div>
                    </div>
                    <input type="hidden" name="redirect_url" value="<?php echo base_url(uri_string())?>" >
                  </div>
                  <div class="row">
                    <div class="col-lg-12">
                      <div class="form-group m-form__group">
                        <label for="user_name">
                          Location Name
                        </label>
                        <div class="input-group m-input-group--air date">
                          <div class="input-group-prepend">
                            <span class="input-group-text">
                              <i class="la la-tags"></i>
                            </span>
                          </div>
                          <input required  id="location_name" type="text" name="location_name" class="form-control m-input form_stock_location_add_fields" placeholder="Location Name" >
                        </div>
                      </div>
                      <span class="m-form__help"></span>
                    </div>
                  </div>
                </div>
                <div class="modal-footer">
                  <button type="button" class="btn btn-secondary" data-dismiss="modal">
                    Close
                  </button>
                  <button type="submit" class="btn btn-primary form_submit_btn">
                    Submit
                  </button>
                </div>
              </form>
            </div>
          </div>
        </div>
        <div class="modal fade" tabindex="-1" id="stock_location_edit_modal" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
          <div class="modal-dialog " role="document" >
            <div class="modal-content" >
              <div class="modal-header" style="background-color: #36a3f7;border-radius: 4px">
                <h5 class="modal-title" id="exampleModalLabel" style="color: #ffffff" >
                  Update Stock Location
                </h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                  <span aria-hidden="true">
                    &times;
                  </span>
                </button>
              </div>
              <form autocomplete="off" data-modal-id="stock_location_edit_modal" id="form_stock_location_edit" method="post" action="<?php echo base_url().'stock/update_location'?>" enctype="multipart/form-data" class="m-form m-form--fit m-form--state m-form--label-align-right " >
                <div class="modal-body">
                  <div class="m-form__content">
                    <div class="m-alert m-alert--icon alert alert-warning m--hide" role="alert" id="form_stock_location_edit_msg">
                      <div class="m-alert__icon">
                        <i class="la la-warning"></i>
                      </div>
                      <div class="m-alert__text">
                        Oh snap! Change a few things up and try submitting again.
                      </div>
                      <div class="m-alert__close">
                        <button type="button" class="close" data-close="alert" aria-label="Close"></button>
                      </div>
                    </div>
                  </div>
                  <div class="row">
                    <div class="col-lg-12">
                      <div class="m-form__group form-group">
                        <label class="col-form-label">Location Type</label>
                        <div class="col-9">
                          <div class="m-radio-inline">
                            <label class="m-radio m-radio--solid m-radio--state-brand">
                              <input required type="radio" name="location_type_2" value="ware_house"> Ware House
                              <span></span>
                            </label>
                            <!-- <label class="m-radio m-radio--solid m-radio--state-success">
                              <input type="radio" name="location_type_2" value="work_site"> Work Site
                              <span></span>
                            </label> -->
                          </div>
                          <span class="m-form__help"></span>
                        </div>
                      </div>
                    </div>
                    <div class="col-lg-12" style="display: none" id="work_div_edit">
                      <div class="form-group m-form__group">
                        <label for="user_name">
                          Work Name
                        </label>
                        <div class="m-select2 m-select2--air m-select2--pill">
                          <select  style="width: 100%" class="form-control m-select2 form_stock_location_edit_select" id="work_edit"  name="work_id" data-placeholder="Select Work">
                            <option selected disabled>Select Work</option>
                            <?php
                            foreach($work_contracts as $row): ?>
                              <option data-work-status="<?php echo $row->work_status?>" value="<?php echo $row->work_id?>"><?php echo $row->work_name?></option>
                              <?php
                            endforeach;
                            ?>
                          </select>
                        </div>
                        <span class="m-form__help"></span>
                      </div>
                    </div>
                    <input type="hidden" name="redirect_url" value="<?php echo base_url(uri_string())?>" >
                  </div>
                  <div class="row">
                    <div class="col-lg-12">
                      <div class="form-group m-form__group">
                        <label for="user_name">
                          Location Name
                        </label>
                        <div class="input-group m-input-group--air date">
                          <div class="input-group-prepend">
                            <span class="input-group-text">
                              <i class="la la-tags"></i>
                            </span>
                          </div>
                          <input required  id="location_name_edit" type="text" name="location_name" class="form-control m-input form_stock_location_edit_fields" placeholder="Location Name" >
                        </div>
                      </div>
                      <span class="m-form__help"></span>
                    </div>
                  </div>
                  <input type="hidden" name="location_id" id="location_id_edit" >
                </div>
                <div class="modal-footer">
                  <button type="button" class="btn btn-secondary" data-dismiss="modal">
                    Close
                  </button>
                  <button type="submit" class="btn btn-primary form_submit_btn">
                    Update
                  </button>
                </div>
              </form>
            </div>
          </div>
        </div>
        <div class="modal fade"  tabindex="-1" id="stock_location_delete_modal" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
          <div class="modal-dialog " role="document" >
            <form autocomplete="off" method="post" data-modal-id="stock_location_delete_modal" id="form_stock_location_delete" action="<?php echo base_url().'stock/delete_location'?>" class="form-horizontal">
              <div class="modal-content">
                <div class="alert alert-danger" role="alert" style="margin-bottom: 0px">
                  <button type="button" class="close" data-dismiss="modal"></button>
                  <br/>
                  <h4 class="alert-heading">Warning! Please Confirm Your Action</h4>
                  <br/>
                  <p> Are You Sure to Delete this Data ?. All the Associated Data will Lost. </p>
                  <p>
                    <button class="btn btn-danger form_submit_btn" id="delete_purchase_item" type="submit" name="submit">Confirm & Delete</button>
                    <button type="button" class="btn btn-primary modal-dismiss" data-dismiss="modal">Cancel</button>
                  </p>
                  <input type="hidden"  name="location_id" id="location_id_delete">
                </div>
              </div>
            </form>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>
</div>
<!-- end:: Body -->
<!-- begin::Footer -->

<?php $this->view("includes/Inc_footer");?>
<!-- end::Footer -->
</div>
<!-- end:: Page -->

<?php $this->view("includes/Inc_sidebar");?>
<?php $this->view("includes/Inc_scripts");?>


<!--begin::Page Snippets -->
<script>
  $('body').on('click', '#stock_location_edit_btn', function() {
    var no = $(this).closest('tr').children('td');
    $('#location_name_edit').val(no.eq(2).text());
    $('#location_id_edit').val(no.eq(1).text());
    $("input[name=location_type_2][value=" + no.eq(6).text() + "]").prop('checked', true);
    if(no.eq(6).text()=='work_site'){
      $('#work_edit').val(no.eq(5).text()).trigger('change');
      $("#work_div_edit").show();
      $("#work_edit").attr('required',true);
    }else{
      $("#work_div_edit").hide();
      $("#work_edit").removeAttr('required',true);
    }
  })
  $('body').on('click', '#stock_location_delete_btn', function() {
    var no = $(this).closest('tr').children('td');
    $('#location_id_delete').val(no.eq(1).text());
  })

  $('body').on('change', '#work_add', function() {
    var work_name = $('#work_add :selected').text();
    var location_name = $("#location_name").val();
    if(location_name==''){
      $("#location_name").val(work_name);
    }
  })
  $('body').on('change', '#work_edit', function() {
    var work_name = $('#work_edit :selected').text();
    var location_name = $("#location_name_edit").val();
    if(location_name==''){
      $("#location_name_edit").val(work_name);
    }
  })

  $('input[type=radio][name=location_type]').change(function() {
    if (this.value == 'work_site') {
      $("#work_div").show();
      $("#work_add").attr('required',true);
    }else{
      $("#work_div").hide();
      $("#work_add").removeAttr('required',true);
    }
  });
  $('input[type=radio][name=location_type_2]').change(function() {
    if (this.value == 'work_site') {
      $("#work_div_edit").show();
      $("#work_edit").attr('required',true);
    }else{
      $("#work_div_edit").hide();
      $("#work_edit").removeAttr('required',true);
    }
  });
</script>
<script>
  $("#stock_menu").addClass('m-menu__item--active m-menu__item--open');
  $("#stock_menu_3").addClass('m-menu__item--active');

  $("#work,#work_add,#work_edit,#work_view").select2({
    placeholder: "Select  Work",
    templateResult: format_project_dropdown
  })
  $("#report_date,#report_date_update,#report_date_view").datepicker( {
    todayHighlight:!0, orientation:"bottom left", templates: {
      leftArrow: '<i class="la la-angle-left"></i>', rightArrow: '<i class="la la-angle-right"></i>'
    }
  })
//  client List Data Table
jQuery(document).ready(function() {
  function toaster(msg_type,message,title){
    toastr.options = {
      "closeButton": false,
      "debug": false,
      "newestOnTop": false,
      "progressBar": true,
      "positionClass": "toast-top-center",
      "preventDuplicates": false,
      "onclick": null,
      "showDuration": "300",
      "hideDuration": "1000",
      "timeOut": "5000",
      "extendedTimeOut": "1000",
      "showEasing": "swing",
      "hideEasing": "linear",
      "showMethod": "fadeIn",
      "hideMethod": "fadeOut"
    };
    if(msg_type=="success"){
      toastr.success(message,title);
    }else{
      toastr.error(message,title);
    }

  }

  var table = $('#stock_location_view_table').DataTable({
    "ajax":{
      url :"<?php echo base_url().'stock/select_stock_location' ?>", // json datasource
      type: "post", // type of method  , by default would be get
      data: function(d){

      }
    },
    "bProcessing": true,
    "deferRender": true,
    "bDeferRender": true,
    "scrollX" : true,
    scrollX:!0, scrollCollapse:!0,
    buttons: [
    { extend: 'print', className: 'btn dark btn-outline',exportOptions: {columns: ':visible'},title: 'Stock Locations' },
    { extend: 'csv', className: 'btn purple btn-outline ' },
    { extend: 'colvis', className: 'btn dark btn-outline', text: 'Columns'}
    ],
    dom:"<'row'<'col-sm-6 text-left'B><'col-sm-6 text-right'f>>\n\t\t\t<'row'<'col-sm-12'tr>>\n\t\t\t<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 dataTables_pager'lp>>", // horizobtal scrollable datatable
    "lengthMenu": [
    [25, 50, 100, -1],
      [25, 50, 100, "All"] // change per page values here
      ],
      "columnDefs": [
      {
        "targets": [ 1,4,5,6<?php if($this->session->userdata('user_role')=='auditor'){ echo ",7";} ?>],
        className: "hidden"
      }
      ],
      'order': false
    });
  $(".table_filter").on("change", function() {
    table.ajax.reload();
  });
  $(".hide_column").hide();

  $(".form_submit_btn").click(function (e) {
    e.preventDefault();
    var a = $(this),
    l = $(this).closest("form"),
    action = l.attr('action');
    var form_id = l.attr('id');
    l.validate({
      rules: {
        name: {
          required: !0
        }
      }, invalidHandler: function (e, r) {
        var i = $("#" + form_id + "_msg");
        i.removeClass("m--hide").show(), mUtil.scrollTo(i, -200)
      }, submitHandler: function (e) {
      }
    }), l.valid() && (a.addClass("m-loader m-loader--right m-loader--light").attr("disabled", !0),
    l.ajaxSubmit({
      url: action,
      success: function (e, t, r, s) {

        var modal_id = l.attr('data-modal-id');
        var form_type = l.attr('data-form-type');
        $("#" + form_id + "_msg").addClass("m--hide");
        // Block UI
        mApp.blockPage({
          overlayColor: "#000000",
          type: "loader",
          state: "success",
          message: "Please wait..."
        }), setTimeout(function () {
          mApp.unblockPage()
        }, 2e3);
        var obj = $.parseJSON(e);
        if (obj.status == 1) {
          a.removeClass("m-loader m-loader--right m-loader--light").attr("disabled", !1);
          toastr[obj.flashdata_type](obj.flashdata_msg,obj.flashdata_title);
          $("#"+modal_id).modal('toggle');
          $("."+form_id+"_fields").val('');
          $("."+form_id+"_select").val('').trigger("change");
          $('input[type=radio]').prop('checked', false);
          $("#work_div").hide();
          $("#work_add").removeAttr('required',true);
          table.ajax.reload();
        } else {
          a.removeClass("m-loader m-loader--right m-loader--light").attr("disabled", !1);
          toastr[obj.flashdata_type](obj.flashdata_msg,obj.flashdata_title);
        }
        if (obj == null) {
          setTimeout(function () {
            a.removeClass("m-loader m-loader--right m-loader--light").attr("disabled", !1);
            toastr["warning"]("Your Attempt is Timed Out. Please Try Again.", "Timed Out");
          }, 2e4)
        }
      },error: function() {
        a.removeClass("m-loader m-loader--right m-loader--light").attr("disabled", !1);
        toastr["error"]("Sorry. There Has Been Some Error Occurred. Please Try Again.", "Error");
      }
    })
    )
  });
})
</script>
