<?php $this->view("includes/Inc_pagehead"); ?>
<!-- Page Styles Goes Here-->

<?php $this->view("includes/Inc_navigation"); ?>
<div class="m-grid__item m-grid__item--fluid m-wrapper">
  <!-- BEGIN: Subheader -->
  <div class="m-subheader ">
    <div class="d-flex align-items-center">
      <div class="mr-auto">
        <h3 class="m-subheader__title m-subheader__title--separator">
          Manage Bank Account Details
        </h3>
        <ul class="m-subheader__breadcrumbs m-nav m-nav--inline">
          <li class="m-nav__item m-nav__item--home">
            <a href="#" class="m-nav__link m-nav__link--icon">
              <i class="m-nav__link-icon la la-home"></i>
            </a>
          </li>
          <li class="m-nav__separator">
            -
          </li>
          <li class="m-nav__item">
            <a href="<?php echo $this->session->userdata("dashboard_link") ?>" class="m-nav__link">
              <span class="m-nav__link-text">
                Home
              </span>
            </a>
          </li>
          <li class="m-nav__separator">
            -
          </li>
          <li class="m-nav__item">
            <a href="<?php echo base_url() . 'settings/bank_accounts' ?>" class="m-nav__link">
              <span class="m-nav__link-text">
                Bank Account Details
              </span>
            </a>
          </li>


        </ul>
      </div>
      <div>

      </div>
    </div>
  </div>
  <!-- END: Subheader -->
  <div class="m-content">
    <div class="m-portlet m-portlet--mobile m-portlet--info m-portlet--head-solid-bg m-portlet--bordered m-portlet--rounded">
      <div class="m-portlet__head">
        <div class="m-portlet__head-caption">
          <div class="m-portlet__head-title">
            <h3 class="m-portlet__head-text">
              List of Bank Account Details
            </h3>
          </div>
        </div>
        <div class="m-portlet__head-tools">
          <?php if ($this->session->userdata('user_role') != 'auditor') { ?>
            <a href="#" data-toggle="modal" data-target="#bank_account_add_modal" class="btn btn-focus m-btn m-btn--custom m-btn--icon m-btn--air m-btn--pill">
              <span>
                <i class="la la-plus"></i>
                <span>
                  Create New Bank Account Details
                </span>
              </span>
            </a>
          <?php } ?>
        </div>
      </div>
      <div class="m-portlet__body">

        <?php if (!empty($this->config->item('company_branches'))) { ?>
          <!--begin: Search Form -->
          <div class="m-form m-form--label-align-right m--margin-bottom-10">
            <div class="row">
              <div class="col-xl-12 order-2 order-xl-1">
                <div class="form-group m-form__group row ">
                  <div class="col-lg-4">
                    <div class="form-group m-form__group">
                      <label>
                        Company Branch
                      </label>
                      <div class="m-select2 m-select2--air m-select2--pill">
                        <select width="100%" required class="form-control m-select2 table_filter company-branch-select2" id="company_branch">
                          <option selected value="all"> All Branches</option>
                          <option value="0">NO BRANCH</option>
                          <?php foreach ($this->config->item('company_branches') as $key => $value) { ?>
                            <option value="<?php echo $value->branch_id ?>"><?php echo $value->branch_name ?></option>
                          <?php } ?>
                        </select>
                      </div>
                      <span class="m-form__help"></span>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        <?php } ?>

        <!--begin: Datatable -->
        <table width="100%" class="table m-table nowrap table-header-fixed table-striped table-bordered table-hover table-header-fixed" id="bank_accounts_view_table">
          <thead>
            <tr class="">
              <th>ID</th>
              <th>Sl No</th>
              <th>Branch Name</th>
              <th>A/C Holder<br/>Company Name</th>
              <th>Bank Name</th>
              <th>Account No</th>
              <th><?= $this->config->item('bank_ifsc_name')?></th>
              <th>Bank Branch</th>
              <th>Swift Code</th>
              <th>Actions</th>
            </tr>
          </thead>
          <tbody>
          </tbody>
        </table>
        <div class="modal fade" tabindex="-1" id="bank_account_add_modal" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
          <div class="modal-dialog " role="document" style="max-width: 750px">
            <div class="modal-content">
              <div class="modal-header" style="background-color: #36a3f7;border-radius: 4px">
                <h5 class="modal-title" id="exampleModalLabel" style="color: #ffffff">
                  Create New Bank Account
                </h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                  <span aria-hidden="true">
                    &times;
                  </span>
                </button>
              </div>
              <form autocomplete="off" data-form-type="customer" data-modal-id="bank_account_add_modal" id="form_bank_account_add" method="post" action="<?php echo base_url() . 'settings/create_bank_account_details' ?>" enctype="multipart/form-data" class="form m-form m-form--fit m-form--state m-form--label-align-right ">
                <div class="modal-body">
                  <div class="m-form__content">
                    <div class="m-alert m-alert--icon alert alert-warning m--hide" role="alert" id="form_bank_account_add_msg">
                      <div class="m-alert__icon">
                        <i class="la la-warning"></i>
                      </div>
                      <div class="m-alert__text">
                        Oh snap! Change a few things up and try submitting again.
                      </div>
                      <div class="m-alert__close">
                        <button type="button" class="close" data-close="alert" aria-label="Close"></button>
                      </div>
                    </div>
                  </div>
                  <div class="row">
                    <div class="col-lg-6">
                      <div class="form-group m-form__group">
                        <label for="user_name">
                          A/C Holder Company Name
                        </label>
                        <input required type="text" name="company_name" class="form-control m-input m-input--pill  m-input--air form_bank_account_add_fields" aria-describedby="basic-addon1">
                        <span class="m-form__help"></span>
                      </div>
                    </div>
                    <div class="col-lg-6">
                      <div class="form-group m-form__group">
                        <label for="user_name">
                          Account No
                        </label>
                        <input required type="text" name="account_no" class="form-control m-input m-input--pill  m-input--air form_bank_account_add_fields" aria-describedby="basic-addon1">
                        <span class="m-form__help"></span>
                      </div>
                    </div>
                    <div class="col-lg-4">
                      <div class="form-group m-form__group">
                        <label for="user_name">
                          Bank Name
                        </label>
                        <input required type="text" name="bank_name" class="form-control m-input m-input--pill  m-input--air form_bank_account_add_fields" aria-describedby="basic-addon1">
                        <span class="m-form__help"></span>
                      </div>
                    </div>
                    <div class="col-lg-4">
                      <div class="form-group m-form__group">
                        <label for="user_name">
                          <?= $this->config->item('bank_ifsc_name')?> Code
                        </label>
                        <input  type="text" name="ifsc" class="form-control m-input m-input--pill  m-input--air form_bank_account_add_fields" aria-describedby="basic-addon1">
                        <span class="m-form__help"></span>
                      </div>
                    </div>
                    <div class="col-lg-4">
                      <div class="form-group m-form__group">
                        <label for="user_name">
                          Branch
                        </label>
                        <input required type="text" name="branch" class="form-control m-input m-input--pill  m-input--air form_bank_account_add_fields" aria-describedby="basic-addon1">
                        <span class="m-form__help"></span>
                      </div>
                    </div>
                    <div class="col-lg-4">
                      <div class="form-group m-form__group">
                        <label for="user_name">
                          Swift Code
                        </label>
                        <input type="text" name="swift_code" class="form-control m-input m-input--pill  m-input--air form_bank_account_add_fields" aria-describedby="basic-addon1">
                        <span class="m-form__help"></span>
                      </div>
                    </div>
                  </div>
                </div>
                <div class="modal-footer">
                  <button type="button" class="btn btn-secondary " data-dismiss="modal">
                    Close
                  </button>
                  <button type="submit" class="btn btn-primary form_submit_btn">
                    Submit
                  </button>
                </div>
              </form>
            </div>
          </div>
        </div>
        <div class="modal fade" tabindex="-1" id="bank_account_edit_modal" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
          <div class="modal-dialog " role="document" style="max-width: 750px">
            <div class="modal-content">
              <div class="modal-header" style="background-color: #36a3f7;border-radius: 4px">
                <h5 class="modal-title" id="exampleModalLabel" style="color: #ffffff">
                  Edit Bank Account
                </h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                  <span aria-hidden="true">
                    &times;
                  </span>
                </button>
              </div>
              <form autocomplete="off" data-form-type="customer" data-modal-id="bank_account_edit_modal" id="form_bank_account_edit" method="post" action="<?php echo base_url() . 'settings/update_bank_account_details' ?>" enctype="multipart/form-data" class="form m-form m-form--fit m-form--state m-form--label-align-right ">
                <div class="modal-body">
                  <div class="m-form__content">
                    <div class="m-alert m-alert--icon alert alert-warning m--hide" role="alert" id="form_bank_account_edit_msg">
                      <div class="m-alert__icon">
                        <i class="la la-warning"></i>
                      </div>
                      <div class="m-alert__text">
                        Oh snap! Change a few things up and try submitting again.
                      </div>
                      <div class="m-alert__close">
                        <button type="button" class="close" data-close="alert" aria-label="Close"></button>
                      </div>
                    </div>
                  </div>
                  <div class="row">
                    <div class="col-lg-6">
                      <div class="form-group m-form__group">
                        <label for="user_name">
                          A/C Holder Company Name
                        </label>
                        <input required type="text" name="company_name" id='company_name_edit' class="form-control m-input m-input--pill  m-input--air form_bank_account_edit_fields" aria-describedby="basic-addon1">
                        <span class="m-form__help"></span>
                      </div>
                    </div>
                    <div class="col-lg-6">
                      <div class="form-group m-form__group">
                        <label for="user_name">
                          Account No
                        </label>
                        <input required type="text" name="account_no" id="account_no_edit" class="form-control m-input m-input--pill  m-input--air form_bank_account_edit_fields" aria-describedby="basic-addon1">
                        <span class="m-form__help"></span>
                      </div>
                    </div>
                    <div class="col-lg-4">
                      <div class="form-group m-form__group">
                        <label for="user_name">
                          Bank Name
                        </label>
                        <input required type="text" name="bank_name" id="bank_name_edit" class="form-control m-input m-input--pill  m-input--air form_bank_account_edit_fields" aria-describedby="basic-addon1">
                        <span class="m-form__help"></span>
                      </div>
                    </div>
                    <div class="col-lg-4">
                      <div class="form-group m-form__group">
                        <label for="user_name">
                          <?= $this->config->item('bank_ifsc_name')?> Code
                        </label>
                        <input  type="text" name="ifsc" id="ifsc_edit" class="form-control m-input m-input--pill  m-input--air form_bank_account_edit_fields" aria-describedby="basic-addon1">
                        <span class="m-form__help"></span>
                      </div>
                    </div>
                    <div class="col-lg-4">
                      <div class="form-group m-form__group">
                        <label for="user_name">
                          Branch
                        </label>
                        <input required type="text" name="branch" id="branch_edit" class="form-control m-input m-input--pill  m-input--air form_bank_account_edit_fields" aria-describedby="basic-addon1">
                        <span class="m-form__help"></span>
                      </div>
                    </div>
                    <div class="col-lg-4">
                      <div class="form-group m-form__group">
                        <label for="user_name">
                          Swift Code
                        </label>
                        <input type="text" name="swift_code" id="swift_code_edit" class="form-control m-input m-input--pill  m-input--air form_bank_account_add_fields" aria-describedby="basic-addon1">
                        <span class="m-form__help"></span>
                      </div>
                    </div>
                    <input type="hidden" name="account_id" id="bank_account_id_edit">
                  </div>
                </div>
                <div class="modal-footer">
                  <button type="button" class="btn btn-secondary " data-dismiss="modal">
                    Close
                  </button>
                  <button type="submit" class="btn btn-primary form_submit_btn">
                    Submit
                  </button>
                </div>
              </form>
            </div>
          </div>
        </div>
        <div class="modal fade" tabindex="-1" id="bank_account_delete_modal" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
          <div class="modal-dialog " role="document">
            <form autocomplete="off" data-modal-id="bank_account_delete_modal" method="post" action="<?php echo base_url() . 'settings/delete_bank_account_details' ?>" class="form-horizontal">
              <div class="modal-content">
                <div class="alert alert-danger" role="alert" style="margin-bottom: 0px">
                  <button type="button" class="close" data-dismiss="modal"></button>
                  <br />
                  <h4 class="alert-heading">Warning! Please Confirm Your Action</h4>
                  <br />
                  <p> Are You Sure to Delete this Data ?. All the Associated Data will Lost. </p>
                  <p>
                    <button class="btn btn-danger form_submit_btn" type="submit" name="submit">Confirm & Delete</button>
                    <button type="button" class="btn btn-primary modal-dismiss" data-dismiss="modal">Cancel</button>
                  </p>
                  <input type="hidden" name="account_id" id="bank_account_id_delete">
                </div>
              </div>
            </form>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>
</div>
<!-- end:: Body -->
<!-- begin::Footer -->

<?php $this->view("includes/Inc_footer"); ?>
<!-- end::Footer -->
</div>
<!-- end:: Page -->

<?php $this->view("includes/Inc_sidebar"); ?>
<?php $this->view("includes/Inc_scripts"); ?>
<!--begin::Page Snippets -->

<script>
// $("#table_filter_status").selectpicker();
// $("[data-switch=true]").bootstrapSwitch()
</script>

<script>
$("#bank_accounts_menu").addClass('m-menu__item--active');
</script>
<script>
$('body').on('click', '#bank_account_edit_btn', function() {
  var no = $(this).closest('tr').children('td');
  $('#bank_account_id_edit').val(no.eq(0).text());
  $('#company_name_edit').val(no.eq(3).text());
  $('#bank_name_edit').val(no.eq(4).text());
  $('#account_no_edit').val(no.eq(5).text());
  $('#ifsc_edit').val(no.eq(6).text());
  $('#branch_edit').val(no.eq(7).text());
  $('#swift_code_edit').val(no.eq(8).text());
})
$('body').on('click', '#bank_account_delete_btn', function() {
  var no = $(this).closest('tr').children('td');
  $('#bank_account_id_delete').val(no.eq(0).text());
})
</script>
<script>
var Datatable_bank_accounts_view_table = function() {
  var t = function() {

    function get_branch_id() {
      return $('#company_branch :selected').val();
    }

    var bank_accounts_view_table = $('#bank_accounts_view_table').DataTable({
      "ajax": {
        url: "<?php echo base_url() . 'settings/select_bank_account_details' ?>", // json datasource
        type: "post", // type of method  , by default would be get
        data: function(d) {
          <?php if (!empty($this->config->item('company_branches'))) { ?>
            d.branch_id = get_branch_id();
            <?php } ?>
          }
        },
        "bProcessing": true,
        "deferRender": true,
        "bDeferRender": true,
        "scrollX": true,
        buttons: [{
          extend: 'print',
          className: 'btn dark btn-outline',
          title: 'Bank Accounts'
        },
        {
          extend: 'csv',
          className: 'btn purple btn-outline '
        },
        {
          extend: 'colvis',
          className: 'btn dark btn-outline',
          text: 'Columns'
        }
      ],
      dom: "<'row'<'col-sm-6 text-left'B><'col-sm-6 text-right'f>>\n\t\t\t<'row'<'col-sm-12'tr>>\n\t\t\t<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 dataTables_pager'lp>>", // horizobtal scrollable datatable
      "lengthMenu": [
        [25, 50, 100, -1],
        [25, 50, 100, "All"] // change per page values here
      ],
      "columnDefs": [{
        "targets": [0 <?php if ($this->session->userdata('user_role') == 'auditor') {
          echo ",9";
        } ?>
        <?php if (empty($this->config->item('company_branches'))) { echo ",2"; }?>
      ],
      className: "hidden"
    }],
    'order': false
  });
  $(".table_filter").on("change", function() {
    bank_accounts_view_table.ajax.reload();
  });

};
return {
  init: function() {
    t()
  }
}
}
();
jQuery(document).ready(function() {
  Datatable_bank_accounts_view_table.init();
  $(".form_submit_btn").click(function(e) {

    e.preventDefault();
    var a = $(this),
    l = $(this).closest("form"),
    action = l.attr('action');
    var form_id = l.attr('id');
    l.validate({
      rules: {
        "tax1_percent": {
          required: !0,
          number: !0
        },
        "tax2_percent": {
          required: !0,
          number: !0
        },
        "tax3_percent": {
          required: !0,
          number: !0
        },
        "total_tax_percent": {
          required: !0,
          number: !0
        }
      },
      invalidHandler: function(e, r) {
        var i = $("#" + form_id + "_msg");
        i.removeClass("m--hide").show(), mUtil.scrollTo(i, -200)
      },
      submitHandler: function(e) {}
    }), l.valid() && (a.addClass("m-loader m-loader--right m-loader--light").attr("disabled", !0),
    l.ajaxSubmit({
      url: action,
      success: function(e, t, r, s) {
        var modal_id = l.attr('data-modal-id');
        var form_type = l.attr('data-form-type');
        $("#" + form_id + "_msg").addClass("m--hide");
        // Block UI
        mApp.blockPage({
          overlayColor: "#000000",
          type: "loader",
          state: "success",
          message: "Please wait..."
        }), setTimeout(function() {
          mApp.unblockPage()
        }, 2e3);
        var obj = $.parseJSON(e);
        if (obj.status == 1) {
          a.removeClass("m-loader m-loader--right m-loader--light").attr("disabled", !1);
          toastr[obj.flashdata_type](obj.flashdata_msg, obj.flashdata_title);
          $("#" + modal_id).modal('toggle');
          $("." + form_id + "_fields").val('');
          $("." + form_id + "_select").val('').trigger("change");
          $('#bank_accounts_view_table').dataTable().fnDestroy();
          Datatable_bank_accounts_view_table.init();
        } else {
          a.removeClass("m-loader m-loader--right m-loader--light").attr("disabled", !1);
          toastr[obj.flashdata_type](obj.flashdata_msg, obj.flashdata_title);
        }
        if (obj == null) {
          setTimeout(function() {
            a.removeClass("m-loader m-loader--right m-loader--light").attr("disabled", !1);
            toastr["warning"]("Your Attempt is Timed Out. Please Try Again.", "Timed Out");
          }, 2e4)
        }
      },
      error: function() {
        a.removeClass("m-loader m-loader--right m-loader--light").attr("disabled", !1);
        toastr["error"]("Sorry. There Has Been Some Error Occurred. Please Try Again.", "Error");
      }
    })
  )
});
});
</script>
