<?php $this->view("includes/Inc_pagehead");?>
<!-- Page Styles Goes Here-->

<?php $this->view("includes/Inc_navigation");?>
<div class="m-grid__item m-grid__item--fluid m-wrapper">
  <!-- BEGIN: Subheader -->
  <div class="m-subheader ">
    <div class="d-flex align-items-center">
      <div class="mr-auto">
        <h3 class="m-subheader__title m-subheader__title--separator">
          Sales Quotation Templates
        </h3>
        <ul class="m-subheader__breadcrumbs m-nav m-nav--inline">
          <li class="m-nav__item m-nav__item--home">
            <a href="#" class="m-nav__link m-nav__link--icon">
              <i class="m-nav__link-icon la la-home"></i>
            </a>
          </li>
          <li class="m-nav__separator">
            -
          </li>
          <li class="m-nav__item">
            <a href="<?php echo $this->session->userdata("dashboard_link")?>" class="m-nav__link">
              <span class="m-nav__link-text">
                Home
              </span>
            </a>
          </li>
          <li class="m-nav__separator">
            -
          </li>
          <li class="m-nav__item">
            <a href="<?php echo base_url().'sales_quotation/templates' ?>" class="m-nav__link">
              <span class="m-nav__link-text">
                Sales Quotation Templates
              </span>
            </a>
          </li>


        </ul>
      </div>
      <div>

      </div>
    </div>
  </div>
  <!-- END: Subheader -->
  <div class="m-content">
    <div class="m-portlet m-portlet--mobile m-portlet--info m-portlet--head-solid-bg m-portlet--bordered m-portlet--rounded">
      <div class="m-portlet__head">
        <div class="m-portlet__head-caption">
          <div class="m-portlet__head-title">
            <h3 class="m-portlet__head-text">
              List of Sales Quotation Templates
            </h3>
          </div>
        </div>
        <div class="m-portlet__head-tools">
          <?php if($this->session->userdata('user_role')!='auditor') { ?>
            <a href="#" data-toggle="modal" data-target="#quotation_template_add_modal" class="btn btn-focus m-btn m-btn--custom m-btn--icon m-btn--air m-btn--pill">
              <span>
                <i class="la la-plus"></i>
                <span>
                  Create New Template
                </span>
              </span>
            </a>
          <?php } ?>
        </div>
      </div>
      <div class="m-portlet__body">
        <!--begin: Datatable -->
        <table width="100%" class="table m-table nowrap table-header-fixed table-striped table-bordered table-hover table-header-fixed" id="quotation_template_view_table">
          <thead>
            <tr class="">
              <th>Sl No</th>
              <th>ID</th>
              <th>Template No</th>
              <th>Title</th>
              <th>Sub Title</th>
              <th>Description</th>
              <th>Products</th>
              <th>Rate/Sqft</th>
              <th>Creation</th>
              <th>Actions</th>
              <th>Template No</th>
              <th>Warranty</th>
              <th>Methods</th>
              <th>Notes</th>
            </tr>
          </thead>
          <tbody>
          </tbody>
        </table>
        <div class="modal fade" tabindex="-1" id="quotation_template_add_modal" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
          <div class="modal-dialog " role="document" style="max-width: 950px">
            <div class="modal-content">
              <div class="modal-header" style="background-color: #36a3f7;border-radius: 4px">
                <h5 class="modal-title" id="exampleModalLabel" style="color: #ffffff" >
                  Create New Template
                </h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                  <span aria-hidden="true">
                    &times;
                  </span>
                </button>
              </div>
              <form autocomplete="off" data-form-type="enquiry" data-modal-id="quotation_template_add_modal" id="form_quotation_template_add" method="post" action="<?php echo base_url().'sales_quotation/create_template'?>" enctype="multipart/form-data" class="form m-form m-form--fit m-form--state m-form--label-align-right " >
                <div class="modal-body">
                  <div class="m-form__content">
                    <div class="m-alert m-alert--icon alert alert-warning m--hide" role="alert" id="form_user_add_msg">
                      <div class="m-alert__icon">
                        <i class="la la-warning"></i>
                      </div>
                      <div class="m-alert__text">
                        Oh snap! Change a few things up and try submitting again.
                      </div>
                      <div class="m-alert__close">
                        <button type="button" class="close" data-close="alert" aria-label="Close"></button>
                      </div>
                    </div>
                  </div>
                  <div class="row">
                    <div class="col-lg-3">
                      <div class="form-group m-form__group" >
                        <label for="user_name">
                          Template No
                        </label>
                        <div class="input-group m-input-group m-input-group--pill m-input-group--air">
                          <input required type="text" name="template_no" class="form-control m-input form_quotation_template_add_fields" placeholder="Template No" aria-describedby="basic-addon1">
                        </div>
                        <span class="m-form__help"></span>
                      </div>
                    </div>
                    <div class="col-lg-9">
                      <div class="form-group m-form__group" >
                        <label for="user_name">
                          Title
                        </label>
                        <div class="input-group m-input-group m-input-group--pill m-input-group--air">
                          <input required type="text" name="title" class="form-control m-input form_quotation_template_add_fields" placeholder="Title" aria-describedby="basic-addon1">
                        </div>
                        <span class="m-form__help"></span>
                      </div>
                    </div>
                    <div class="col-lg-12">
                      <div class="form-group m-form__group" >
                        <label for="user_name">
                          Sub Title
                        </label>
                        <div class="input-group m-input-group m-input-group--pill m-input-group--air">
                          <input required type="text" name="subtitle" class="form-control m-input form_quotation_template_add_fields" placeholder="Sub Title" aria-describedby="basic-addon1">
                        </div>
                        <span class="m-form__help"></span>
                      </div>
                    </div>
                    <div class="col-lg-12">
                      <div class="form-group m-form__group" >
                        <label for="user_name">
                          Description
                        </label>
                        <div class="input-group m-input-group m-input-group--pill m-input-group--air">
                          <textarea type="text" rows="3" name="description" class="form-control m-input form_quotation_template_add_fields" placeholder="Description " aria-describedby="basic-addon1"></textarea>
                        </div>
                        <span class="m-form__help"></span>
                      </div>
                    </div>
                    <div class="col-lg-12">
                      <table class="table table-bordered m-table m-table--border-brand m-table--head-bg-warning">
                        <thead>
                          <tr>
                            <th>Products</th>
                            <th>Amount/Sqft</th>
                            <th>Warranty</th>
                            <th>Method of Application</th>
                          </tr>
                        </thead>
                        <tbody>
                          <tr>
                            <td>
                              <div class="form-group m-form__group">
                                <textarea required class="form-control form_quotation_template_add_fields" placeholder="Products" name="products" id="products_add_quotation_template" aria-required="true"></textarea>
                                <span class="m-form__help"></span>
                              </div>
                            </td>
                            <td>
                              <div class="form-group m-form__group" >
                                <input required type="text" name="amount" class="form-control m-input form_quotation_template_add_fields" placeholder="Amount / Sqft" aria-describedby="basic-addon1">
                                <span class="m-form__help"></span>
                              </div>
                            </td>
                            <td>
                              <div class="form-group m-form__group">
                                <textarea required rows="12" class="form-control form_quotation_template_add_fields" placeholder="Warranty" name="warranty"  aria-required="true"></textarea>
                                <span class="m-form__help"></span>
                              </div>
                            </td>
                            <td>
                              <div class="form-group m-form__group">
                                <textarea required class="form-control form_quotation_template_add_fields" placeholder="Methods" name="methods" id="methods_add_quotation_template" aria-required="true"></textarea>
                                <span class="m-form__help"></span>
                              </div>
                            </td>
                          </tr>
                        </tbody>
                      </table>
                    </div>
                    <div class="col-lg-12">
                      <div class="form-group m-form__group" >
                        <label for="user_name">
                          Notes
                        </label>
                        <div class="input-group m-input-group m-input-group--pill m-input-group--air">
                          <textarea type="text" name="notes" class="form-control m-input form_quotation_template_add_fields" placeholder="Notes " aria-describedby="basic-addon1"></textarea>
                        </div>
                        <span class="m-form__help"></span>
                      </div>
                    </div>
                  </div>
                </div>
                <div class="modal-footer">
                  <button type="button" class="btn btn-secondary " data-dismiss="modal">
                    Close
                  </button>
                  <button type="submit" class="btn btn-primary form_submit_btn">
                    Submit
                  </button>
                </div>
              </form>
            </div>
          </div>
        </div>
        <div class="modal fade" tabindex="-1" id="quotation_template_edit_modal" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
          <div class="modal-dialog " role="document" style="max-width: 950px">
            <div class="modal-content">
              <div class="modal-header" style="background-color: #36a3f7;border-radius: 4px">
                <h5 class="modal-title" id="exampleModalLabel" style="color: #ffffff" >
                  Edit Template
                </h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                  <span aria-hidden="true">
                    &times;
                  </span>
                </button>
              </div>
              <form autocomplete="off" data-form-type="enquiry" data-modal-id="quotation_template_edit_modal" id="form_quotation_template_edit" method="post" action="<?php echo base_url().'sales_quotation/update_template'?>" enctype="multipart/form-data" class="form m-form m-form--fit m-form--state m-form--label-align-right " >
                <div class="modal-body">
                  <div class="m-form__content">
                    <div class="m-alert m-alert--icon alert alert-warning m--hide" role="alert" id="form_user_edit_msg">
                      <div class="m-alert__icon">
                        <i class="la la-warning"></i>
                      </div>
                      <div class="m-alert__text">
                        Oh snap! Change a few things up and try submitting again.
                      </div>
                      <div class="m-alert__close">
                        <button type="button" class="close" data-close="alert" aria-label="Close"></button>
                      </div>
                    </div>
                  </div>
                  <div class="row">
                    <div class="col-lg-3">
                      <div class="form-group m-form__group" >
                        <label for="user_name">
                          Template No
                        </label>
                        <div class="input-group m-input-group m-input-group--pill m-input-group--air">
                          <input required type="text" name="template_no" id="template_no_edit" class="form-control m-input form_quotation_template_edit_fields" placeholder="Template No" aria-describedby="basic-addon1">
                        </div>
                        <span class="m-form__help"></span>
                      </div>
                    </div>
                    <div class="col-lg-9">
                      <div class="form-group m-form__group" >
                        <label for="user_name">
                          Title
                        </label>
                        <div class="input-group m-input-group m-input-group--pill m-input-group--air">
                          <input required type="text" name="title" id="title_edit" class="form-control m-input form_quotation_template_edit_fields" placeholder="Title" aria-describedby="basic-addon1">
                        </div>
                        <span class="m-form__help"></span>
                      </div>
                    </div>
                    <div class="col-lg-12">
                      <div class="form-group m-form__group" >
                        <label for="user_name">
                          Sub Title
                        </label>
                        <div class="input-group m-input-group m-input-group--pill m-input-group--air">
                          <input required type="text" name="subtitle" id="subtitle_edit" class="form-control m-input form_quotation_template_edit_fields" placeholder="Sub Title" aria-describedby="basic-addon1">
                        </div>
                        <span class="m-form__help"></span>
                      </div>
                    </div>
                    <div class="col-lg-12">
                      <div class="form-group m-form__group" >
                        <label for="user_name">
                          Description
                        </label>
                        <div class="input-group m-input-group m-input-group--pill m-input-group--air">
                          <textarea type="text" rows="3" name="description" id="description_edit" class="form-control m-input form_quotation_template_edit_fields" placeholder="Description " aria-describedby="basic-addon1"></textarea>
                        </div>
                        <span class="m-form__help"></span>
                      </div>
                    </div>
                    <div class="col-lg-12">
                      <table class="table table-bordered m-table m-table--border-brand m-table--head-bg-warning">
                        <thead>
                          <tr>
                            <th>Products</th>
                            <th>Amount/Sqft</th>
                            <th>Warranty</th>
                            <th>Method of Application</th>
                          </tr>
                        </thead>
                        <tbody>
                          <tr>
                            <td>
                              <div class="form-group m-form__group">
                                <textarea required class="form-control form_quotation_template_edit_fields" placeholder="Products" name="products" id="products_edit_quotation_template" aria-required="true"></textarea>
                                <span class="m-form__help"></span>
                              </div>
                            </td>
                            <td>
                              <div class="form-group m-form__group" >
                                <input required type="text" name="amount" id="amount_edit" class="form-control m-input form_quotation_template_edit_fields" placeholder="Amount / Sqft" aria-describedby="basic-addon1">
                                <span class="m-form__help"></span>
                              </div>
                            </td>
                            <td>
                              <div class="form-group m-form__group">
                                <textarea required rows="12" class="form-control form_quotation_template_edit_fields" placeholder="Warranty" name="warranty" id="warranty_edit"  aria-required="true"></textarea>
                                <span class="m-form__help"></span>
                              </div>
                            </td>
                            <td>
                              <div class="form-group m-form__group">
                                <textarea required class="form-control form_quotation_template_edit_fields" placeholder="Methods" name="methods" id="methods_edit_quotation_template" aria-required="true"></textarea>
                                <span class="m-form__help"></span>
                              </div>
                            </td>
                          </tr>
                        </tbody>
                      </table>
                    </div>
                    <div class="col-lg-12">
                      <div class="form-group m-form__group" >
                        <label for="user_name">
                          Notes
                        </label>
                        <div class="input-group m-input-group m-input-group--pill m-input-group--air">
                          <textarea type="text" name="notes" id="notes_edit" class="form-control m-input form_quotation_template_edit_fields" placeholder="Notes " aria-describedby="basic-addon1"></textarea>
                        </div>
                        <span class="m-form__help"></span>
                      </div>
                    </div>
                    <input type="hidden" name="template_id" id="template_id_edit" />
                  </div>
                </div>
                <div class="modal-footer">
                  <button type="button" class="btn btn-secondary " data-dismiss="modal">
                    Close
                  </button>
                  <button type="submit" class="btn btn-primary form_submit_btn">
                    Submit
                  </button>
                </div>
              </form>
            </div>
          </div>
        </div>
        <div class="modal fade modals_reset" tabindex="-1" id="quotation_template_delete_modal" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
          <div class="modal-dialog " role="document">
            <form autocomplete="off" id="form_quotation_template_delete" data-modal-id="quotation_template_delete_modal" method="post" action="<?= base_url()?>sales_quotation/delete_template" class="form-horizontal">
              <div class="modal-content">
                <div class="alert alert-danger" role="alert" style="margin-bottom: 0px">
                  <button type="button" class="close" data-dismiss="modal"></button>
                  <br>
                  <h4 class="alert-heading">Warning !</h4>
                  <br>
                  <p> Are you sure to delete this Template ? </p>
                  <p>
                    <button class="btn btn-danger form_submit_btn" type="submit" >Confirm &amp; Delete</button>
                    <button type="button" class="btn btn-primary modal-dismiss" data-dismiss="modal">Cancel</button>
                  </p>
                  <input type="hidden" name="template_id" id="template_id_delete" />
                </div>
              </div>
            </form>
          </div>
        </div>

      </div>
    </div>
  </div>
</div>
</div>
<!-- end:: Body -->
<!-- begin::Footer -->
<?php $this->view("includes/Inc_footer");?>
<!-- end::Footer -->
</div>
<!-- end:: Page -->

<?php $this->view("includes/Inc_sidebar");?>
<?php $this->view("includes/Inc_scripts");?>
<!--begin::Page Snippets -->

<script>
$("#sales_quotation_menu").addClass('m-menu__item--active m-menu__item--open');
$("#sales_quotation_menu_3").addClass('m-menu__item--active');
</script>

<script>
$('#quotation_template_add_modal').on('shown.bs.modal', function() {
  $("#products_add_quotation_template").summernote({
    height:200,
    width:'100%',
    toolbar: [
      // [groupName, [list of button]]
      ['style', ['bold', 'italic']],
      ['fontsize', ['fontsize']],
      ['color', ['color']],
      ['para', ['ul', 'ol', 'paragraph']],
      ['height', ['height']]
    ]
  });
  $("#methods_add_quotation_template").summernote({
    height:200,
    width:'100%',
    toolbar: [
      // [groupName, [list of button]]
      ['style', ['bold', 'italic']],
      ['fontsize', ['fontsize']],
      ['color', ['color']],
      ['para', ['ul', 'ol', 'paragraph']],
      ['height', ['height']]
    ]
  });
})


$('body').on('click', '#quotation_template_edit_btn', function() {
  var no = $(this).closest('tr').children('td');
  $('#template_id_edit').val(no.eq(1).text());
  $('#template_no_edit').val(no.eq(10).text());
  $('#title_edit').val(no.eq(3).text());
  $('#subtitle_edit').val(no.eq(4).text());
  $('#description_edit').val(no.eq(5).text());
  $('#amount_edit').val(no.eq(7).text());
  $('#warranty_edit').val(no.eq(11).text());
  $('#notes_edit').val(no.eq(13).text());

  $("#products_edit_quotation_template").summernote({
    height:200,
    width:'100%',
    toolbar: [
      // [groupName, [list of button]]
      ['style', ['bold', 'italic']],
      ['fontsize', ['fontsize']],
      ['color', ['color']],
      ['para', ['ul', 'ol', 'paragraph']],
      ['height', ['height']],
      ['view', ['fullscreen', 'codeview', 'help']],
    ]
  });
  $("#methods_edit_quotation_template").summernote({
    height:200,
    width:'100%',
    toolbar: [
      // [groupName, [list of button]]
      ['style', ['bold', 'italic']],
      ['fontsize', ['fontsize']],
      ['color', ['color']],
      ['para', ['ul', 'ol', 'paragraph']],
      ['height', ['height']],
    ]
  });
  $('#products_edit_quotation_template').summernote('code',no.eq(6).html());
  $('#methods_edit_quotation_template').summernote('code',no.eq(12).html());
});
$('body').on('click', '#quotation_template_delete_btn', function() {
  var no = $(this).closest('tr').children('td');
  $('#template_id_delete').val(no.eq(1).text());
})
$('body').on('click', '#btn_view_template', function() {
  var template_id = $(this).data('template-id');
  window.open('<?php echo base_url().'sales_quotation/preview_template/'?>'+template_id,'newwindow','width=1200,height=700');
});

var Datatable_quotation_template_view_table=function() {
  var t=function() {
    var quotation_template_view_table = $('#quotation_template_view_table').DataTable({
      "ajax":{
        url :"<?php echo base_url().'sales_quotation/select_templates' ?>", // json datasource
        type: "post", // type of method  , by default would be get
        data: function(d){

        }
      },
      "bProcessing": true,
      "deferRender": true,
      "bDeferRender": true,
      "scrollX" : true,
      buttons: [
        { extend: 'print', className: 'btn dark btn-outline' },
        { extend: 'csv', className: 'btn purple btn-outline ' },
        { extend: 'colvis', className: 'btn dark btn-outline', text: 'Columns'}
      ],
      dom:"<'row'<'col-sm-6 text-left'B><'col-sm-6 text-right'f>>\n\t\t\t<'row'<'col-sm-12'tr>>\n\t\t\t<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 dataTables_pager'lp>>", // horizobtal scrollable datatable
      "lengthMenu": [
        [25, 50, 100, -1],
        [25, 50, 100, "All"] // change per page values here
      ],
      "columnDefs": [
        {
          "targets": [ 1,10,11,12,13 ],
          className: "hidden"
        },
        {
          render: function (data, type, full, meta) {
            return "<div class='text-wrap width-300'>" + data + "</div>";
          },
          targets: 5
        }
      ],
      'order': false
    });
    $(".table_filter").on("change", function() {
      quotation_template_view_table.ajax.reload();
    });

  };
  return {
    init:function() {
      t()
    }
  }
}
();
jQuery(document).ready(function() {
  Datatable_quotation_template_view_table.init();
  $(".form_submit_btn").click(function (e) {

    e.preventDefault();
    var a = $(this),
    l = $(this).closest("form"),
    action = l.attr('action');
    var form_id = l.attr('id');
    l.validate({
      rules: {
        "amount": {
          required: !0,
          number: !0
        }
      }, invalidHandler: function (e, r) {
        var i = $("#" + form_id + "_msg");
        i.removeClass("m--hide").show(), mUtil.scrollTo(i, -200)
      }, submitHandler: function (e) {
      }
    }), l.valid() && (a.addClass("m-loader m-loader--right m-loader--light").attr("disabled", !0),
    l.ajaxSubmit({
      url: action,
      success: function (e, t, r, s) {
        var modal_id = l.attr('data-modal-id');
        var form_type = l.attr('data-form-type');
        $("#" + form_id + "_msg").addClass("m--hide");
        // Block UI
        mApp.blockPage({
          overlayColor: "#000000",
          type: "loader",
          state: "success",
          message: "Please wait..."
        }), setTimeout(function () {
          mApp.unblockPage()
        }, 2e3);
        var obj = $.parseJSON(e);
        if (obj.status == 1) {
          a.removeClass("m-loader m-loader--right m-loader--light").attr("disabled", !1);
          toastr[obj.flashdata_type](obj.flashdata_msg, obj.flashdata_title);
          $("#"+modal_id).modal('toggle');
          $("."+form_id+"_fields").val('');
          $('#products_add_quotation_template').summernote('reset');
          $('#methods_add_quotation_template').summernote('reset');
          $('#products_edit_quotation_template').summernote('reset');
          $('#methods_edit_quotation_template').summernote('reset');
          $("."+form_id+"_select").val('').trigger("change");
          $('#quotation_template_view_table').dataTable().fnDestroy();
          Datatable_quotation_template_view_table.init();
        } else {
          a.removeClass("m-loader m-loader--right m-loader--light").attr("disabled", !1);
          toastr[obj.flashdata_type](obj.flashdata_msg, obj.flashdata_title);
        }
        if (obj == null) {
          setTimeout(function () {
            a.removeClass("m-loader m-loader--right m-loader--light").attr("disabled", !1);
            toastr["warning"]("Your Attempt is Timed Out. Please Try Again.", "Timed Out");
          }, 2e4)
        }
      },error: function() {
        a.removeClass("m-loader m-loader--right m-loader--light").attr("disabled", !1);
        toastr["error"]("Sorry. There Has Been Some Error Occurred. Please Try Again.", "Error");
      }
    })
  )
});
});


</script>
