<?php $this->view("includes/Inc_pagehead");?>
<!-- Page Styles Goes Here-->

<?php $this->view("includes/Inc_navigation");?>
<div class="m-grid__item m-grid__item--fluid m-wrapper">
  <!-- BEGIN: Subheader -->
  <div class="m-subheader ">
    <div class="d-flex align-items-center">
      <div class="mr-auto">
        <h3 class="m-subheader__title m-subheader__title--separator">
          Sales Invoices
        </h3>
        <ul class="m-subheader__breadcrumbs m-nav m-nav--inline">
          <li class="m-nav__item m-nav__item--home">
            <a href="#" class="m-nav__link m-nav__link--icon">
              <i class="m-nav__link-icon la la-home"></i>
            </a>
          </li>
          <li class="m-nav__separator">
            -
          </li>
          <li class="m-nav__item">
            <a href="<?php echo base_url().'dashboard'?>" class="m-nav__link">
              <span class="m-nav__link-text">
                Home
              </span>
            </a>
          </li>
          <li class="m-nav__separator">
            -
          </li>
          <li class="m-nav__item">
            <a href="<?php echo base_url().'stock/sales_invoice' ?>" class="m-nav__link">
              <span class="m-nav__link-text">
                Sales Invoices
              </span>
            </a>
          </li>
        </ul>
      </div>
      <div>

      </div>
    </div>
  </div>
  <!-- END: Subheader -->
  <div class="m-content">
    <div class="m-portlet m-portlet--mobile m-portlet--info m-portlet--head-solid-bg m-portlet--bordered m-portlet--rounded">
      <div class="m-portlet__head">
        <div class="m-portlet__head-caption">
          <div class="m-portlet__head-title">
            <h3 class="m-portlet__head-text">
              Sales Invoices
            </h3>
          </div>
        </div>
        <div class="m-portlet__head-tools">
          <?php if($this->session->userdata('user_role')!='auditor') { ?>
            <a href="<?php echo base_url()?>sales_invoice/add" class="btn btn-focus m-btn m-btn--custom m-btn--icon m-btn--air m-btn--pill">
              <span>
                <i class="la la-plus"></i>
                <span>
                  Add New Sale
                </span>
              </span>
            </a>
          <?php } ?>
        </div>
      </div>
      <div class="m-portlet__body">
        <div class="m-form m-form--label-align-right m--margin-bottom-10">
          <div class="row">
            <div class="col-xl-12 order-2 order-xl-1">
              <div class="form-group m-form__group row ">
                <div class="col-md-3">
                  <div class="form-group m-form__group">
                    <label >
                      Date:
                    </label>
                    <input style="border: none" id="date_range"  type="text" class="form-control  m-input--solid m-input "  >
                  </div>
                </div>
                <div class="col-md-3">
                  <div class="form-group m-form__group">
                    <label>
                      From Location :
                    </label>
                    <div class="m-select2 m-select2--air m-select2--pill">
                      <select style="width: 100%" class="form-control m-select2 table_filter" id="location_filter"   data-placeholder="Select Work">
                        <option value="all">All Locations</option>
                        <?php
                        foreach($stock_locations as $row):
                          $location_name = $row->location_name;
                          ?>
                          <option value="<?php echo $row->location_id?>"><?php echo $location_name?></option>
                          <?php
                        endforeach;
                        ?>
                      </select>
                    </div>
                    <span class="m-form__help"></span>
                  </div>
                </div>
                <div class="col-md-3">
                  <div class="form-group m-form__group">
                    <label>
                      Buyer :
                    </label>
                    <div class="m-select2 m-select2--air m-select2--pill">
                      <select style="width: 100%" class="form-control m-select2 table_filter" id="buyer"  name="buyer" data-placeholder="Select Buyer">
                        <option value="all">All Buyers</option>
                        <?php
                        foreach($customers as $row): ?>
                        <option value="customer_<?php echo $row->customer_id?>"><?php echo $row->customer_name?></option>
                        <?php
                      endforeach;
                      ?>
                      <?php
                      foreach ($this->config->item('company_branches') as $key => $value) : ?>
                      <option value="branch_<?php echo $value->branch_id?>">Branch: <?php echo $value->branch_name?></option>
                      <?php
                    endforeach;
                    ?>
                  </select>
                </div>
                <span class="m-form__help"></span>
              </div>
            </div>
            <div class="col-md-3">
              <div class="form-group m-form__group">
                <label>
                  Payment Status:
                </label>
                <div class="m-select2 m-select2--air m-select2--pill">
                  <select style="width: 100%" class="form-control m-select2 table_filter" id="payment_status"  name="payment_status" data-placeholder="Select Supplier">
                    <?php if($list_type=="payable"){?>
                      <option selected value="0">Not Paid</option>
                    <?php }else{?>
                      <option selected value="all">All Bills</option>
                      <option value="1">Received</option>
                      <option value="0">Not Received</option>
                    <?php } ?>
                  </select>
                </div>
                <span class="m-form__help"></span>
              </div>
            </div>
            <?php if ($this->config->item('app_module_company_branches') == 1 && $this->session->userdata('branch_id') == 0){?>
              <div class="col-lg-4">
                <div class="form-group m-form__group">
                  <label>
                    Branch
                  </label>
                  <div class="m-select2 m-select2--air m-select2--pill">
                    <select width="100%" required class="form-control m-select2 table_filter company-branch-select2" id="company_branch">
                      <option selected value="all"> All Branches</option>
                      <option value="0">NO BRANCH</option>
                      <?php foreach ($this->config->item('company_branches') as $key => $value) { ?>
                        <option value="<?php echo $value->branch_id ?>"><?php echo $value->branch_name ?></option>
                      <?php } ?>
                    </select>
                  </div>
                  <span class="m-form__help"></span>
                </div>
              </div>
            <?php } ?>
            <?php if ($this->config->item('app_module_company_branches') == 1){?>
            <div class="col-md-3">
              <div class="form-group m-form__group">
                <label>
                  Invoice Type:
                </label>
                <div class="m-select2 m-select2--air m-select2--pill">
                  <select style="width: 100%" class="form-control m-select2 table_filter" id="invoice_type"  name="invoice_type" data-placeholder="Select Type">
                    <option selected value="all">All Types</option>
                    <option value="B2B">B2B</option>
                    <option value="B2C">B2C</option>
                  </select>
                </div>
                <span class="m-form__help"></span>
              </div>
            </div>
          <?php } ?>
          </div>
        </div>
      </div>
    </div>
    <!--begin: Datatable -->
    <table width="100%" class="table m-table nowrap table-header-fixed table-striped table-bordered table-hover table-header-fixed" id="invoices_all">
      <thead>
        <tr class="">
          <th>Sl No</th>
          <th>Invoice No</th>
          <th>Branch</th>
          <th>Date</th>
          <th>Invoice Type</th>
          <th>From Location</th>
          <th>Buyer</th>
          <th>Total Receivable</th>
          <th>Total Received</th>
          <th>Balance Amount</th>
          <th>Payment Status</th>
          <th>Other Details</th>
          <th>Creation</th>
          <th>Actions</th>
          <th>ID</th>
        </tr>
      </thead>
      <tbody>
      </tbody>
    </table>
    <!--end: Datatable -->
    <div class="modal fade" tabindex="-1" id="sales_invoice_delete_modal" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
      <div class="modal-dialog " role="document" >
        <form autocomplete="off" data-form-type="invoices"  data-modal-id="sales_invoice_delete_modal" id="form_sales_invoice_delete" method="post" action="<?php echo base_url().'sales_invoice/delete'?>" class="form-horizontal">
          <div class="modal-content">
            <div class="alert alert-danger" role="alert" style="margin-bottom: 0px">
              <button type="button" class="close" data-dismiss="modal"></button>
              <br/>
              <h4 class="alert-heading">Warning! Please Confirm Your Action</h4>
              <br/>
              <p> Are You Sure to Delete this Invoice ? This can not be undone ! </p>
              <p>
                <button class="btn btn-danger form_submit_btn" type="submit" name="submit">Confirm & Delete</button>
                <button type="button" class="btn btn-primary modal-dismiss" data-dismiss="modal">Cancel</button>
              </p>
              <input type="hidden" name="invoice_id" id="invoice_id_delete">
            </div>
          </div>
        </form>
      </div>
    </div>
  </div>
</div>
</div>


</div>
</div>
<!-- end:: Body -->
<!-- begin::Footer -->

<?php $this->view("includes/Inc_footer");?>
<!-- end::Footer -->
</div>
<!-- end:: Page -->

<?php $this->view("includes/Inc_sidebar");?>
<?php $this->view("includes/Inc_scripts");?>


<!--begin::Page Snippets -->
<script>

</script>
<script>
$("#sales_invoice_menu").addClass('m-menu__item--active m-menu__item--open');
$("#sales_invoice_menu2").addClass('m-menu__item--active');


$('body').on('click', '#sales_invoice_delete_btn', function() {
  var no = $(this).closest('tr').children('td');
  $('#invoice_id_delete').val(no.eq(14).text());
})

$("#material").select2({
  placeholder: "Select  Material"
})
$("#invoice_type").select2({
  placeholder: "Select Type"
})
$("#work").select2({
  placeholder: "Select  Work",
  templateResult: format_project_dropdown
})
$("#location_filter").select2({
  placeholder: "Select  Location"
})
$("#buyer").select2({
  placeholder: "Select  Buyer"
})
$("#payment_status").select2({
  placeholder: "Select  Payment Status"
})
$("#company_branch").select2({
  placeholder: "Select Branch"
})
$("#debit_acc").select2({
  placeholder: "Select Debit Account",
  dropdownParent: $("#form_payment_add")
})
$("#new_paid_date").datepicker( {
  todayHighlight:!0, orientation:"bottom left", templates: {
    leftArrow: '<i class="la la-angle-left"></i>', rightArrow: '<i class="la la-angle-right"></i>'
  },
  endDate: '+0d',
  <?php if($this->session->userdata('user_role')!='admin' && $this->config->item('User_calendar_date_restriction_enabled')==1){ ?>
    startDate: '<?php echo $this->config->item('User_calendar_date_restriction_start_days');?>d'
    <?php } ?>
  })
  //  client List Data Table
  var Datatable=function() {
    var t=function() {
      function GetSearchStatus(){
        return $('#table_filter_status').val();
      }
      function GetSearchbuyer(){
        return $('#buyer').val();
      }
      function GetSearchDate(){
        return $('#date_range').val();
      }
      function GetSearchLocation(){
        return $('#location_filter').val();
      }
      function GetPayment_status(){
        return $('#payment_status').val();
      }
      function Getbranch(){
        return $('#company_branch').val();
      }
      function GetInvoiceType(){
        return $('#invoice_type').val();
      }
      var table = $('#invoices_all').DataTable({
        "ajax":{
          url :"<?php echo base_url().'sales_invoice/select_invoices' ?>", // json datasource
          type: "post", // type of method  , by default would be get
          data: function(d){
            d.branch = Getbranch();
            d.date = GetSearchDate();
            d.buyer = GetSearchbuyer();
            d.location_id = GetSearchLocation();
            d.payment_status = GetPayment_status();
            d.invoice_type = GetInvoiceType();
          }
        },
        "bProcessing": true,
        "deferRender": true,
        "bDeferRender": true,
        "scrollX" : true,
        buttons: [
          { extend: 'print', className: 'btn dark btn-outline',exportOptions: {columns: ':visible'},title: 'Sales Invoices' },
          { extend: 'csv', className: 'btn purple btn-outline ' },
          { extend: 'colvis', className: 'btn dark btn-outline', text: 'Columns'}
        ],
        dom:"<'row'<'col-sm-6 text-left'B><'col-sm-6 text-right'f>>\n\t\t\t<'row'<'col-sm-12'tr>>\n\t\t\t<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 dataTables_pager'lp>>", // horizobtal scrollable datatable
        "lengthMenu": [
          [25, 50, 100, -1],
          [25, 50, 100, "All"] // change per page values here
        ],
        "columnDefs": [
          {
            "targets": [ 14 ],
            className: "hidden"
          }
        ],
        'order': false
      });
      $(".table_filter").on("change", function() {
        table.ajax.reload();
      });
      $(".hidden").hide();
      // Date Range Picker
      var start = moment();
      var end = moment();

      function cb(start, end) {
        $('#date_range').val(start.format('MMMM D, YYYY') + ' - ' + end.format('MMMM D, YYYY'));
        table.ajax.reload();
      }

      $('#date_range').daterangepicker({
        buttonClasses: "m-btn btn",
        applyClass: "btn-primary",
        cancelClass: "btn-secondary",
        startDate: start,
        endDate: end,
        locale: {
          format: 'MMMM D, YYYY'
        },
        ranges: {
          'Today': [moment(), moment()],
          'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
          'Last 7 Days': [moment().subtract(6, 'days'), moment()],
          'Last 30 Days': [moment().subtract(29, 'days'), moment()],
          'This Month': [moment().startOf('month'), moment().endOf('month')],
          'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')],
          'All time': [moment('1970-01-01'), moment().add(9999, 'days')],
        }
      }, cb);

      cb(start, end);


      $(".form_submit_btn").click(function (e) {

        e.preventDefault();
        var a = $(this),
        l = $(this).closest("form"),
        action = l.attr('action');
        var form_id = l.attr('id');
        l.validate({
          rules: {
            "new_paid_amount": {
              required: !0,
              min: 0,
              number: !0
            }
          }, invalidHandler: function (e, r) {
            var i = $("#" + form_id + "_msg");
            i.removeClass("m--hide").show(), mUtil.scrollTo(i, -200)
          }, submitHandler: function (e) {
          }
        }), l.valid() && (a.addClass("m-loader m-loader--right m-loader--light").attr("disabled", !0),
        l.ajaxSubmit({
          url: action,
          success: function (e, t, r, s) {
            var modal_id = l.attr('data-modal-id');
            var form_type = l.attr('data-form-type');
            $("#" + form_id + "_msg").addClass("m--hide");
            // Block UI
            mApp.blockPage({
              overlayColor: "#000000",
              type: "loader",
              state: "success",
              message: "Please wait..."
            }), setTimeout(function () {
              mApp.unblockPage()
            }, 2e3);
            var obj = $.parseJSON(e);
            if (obj.status == 1) {
              a.removeClass("m-loader m-loader--right m-loader--light").attr("disabled", !1);
              toastr["success"](obj.message, "Success");
              $("#"+modal_id).modal('toggle');
              $("."+form_id+"_fields").val("");
              table.ajax.reload();
            } else {
              a.removeClass("m-loader m-loader--right m-loader--light").attr("disabled", !1);
              if (obj.status == 2) {
                toastr["warning"](obj.message, "Duplication");
              }else{
                toastr["error"](obj.message, "Error");
              }
            }
            if (obj == null) {
              setTimeout(function () {
                a.removeClass("m-loader m-loader--right m-loader--light").attr("disabled", !1);
                toastr["warning"]("Your Attempt is Timed Out. Please Try Again.", "Timed Out");
              }, 2e4)
            }
          },error: function() {
            a.removeClass("m-loader m-loader--right m-loader--light").attr("disabled", !1);
            toastr["error"]("Sorry. There Has Been Some Error Occurred. Please Try Again.", "Error");
          }
        })
      )
    });
  };
  return {
    init:function() {
      t()
    }
  }
}

();
jQuery(document).ready(function() {
  Datatable.init();
  $(".hidden").hide();
  //            $('#service_view_table').wrap("");
}

);
</script>
