<?php $this->view("includes/Inc_pagehead");?>
<!-- Page Styles Goes Here-->

<?php $this->view("includes/Inc_navigation");?>
<div class="m-grid__item m-grid__item--fluid m-wrapper">
  <!-- BEGIN: Subheader -->
  <div class="m-subheader ">
    <div class="d-flex align-items-center">
      <div class="mr-auto">
        <h3 class="m-subheader__title m-subheader__title--separator">
          Create New Invoice
        </h3>
        <ul class="m-subheader__breadcrumbs m-nav m-nav--inline">
          <li class="m-nav__item m-nav__item--home">
            <a href="#" class="m-nav__link m-nav__link--icon">
              <i class="m-nav__link-icon la la-home"></i>
            </a>
          </li>
          <li class="m-nav__separator">
            -
          </li>
          <li class="m-nav__item">
            <a href="<?php echo base_url().'dashboard'?>" class="m-nav__link">
              <span class="m-nav__link-text">
                Home
              </span>
            </a>
          </li>
          <li class="m-nav__separator">
            -
          </li>
          <li class="m-nav__item">
            <a href="<?php echo base_url().'sales_invoice/add' ?>" class="m-nav__link">
              <span class="m-nav__link-text">
                Create New Invoice
              </span>
            </a>
          </li>
        </ul>
      </div>
      <div>

      </div>
    </div>
  </div>
  <!-- END: Subheader -->
  <div class="m-content">
    <div class="m-portlet  m-portlet--rounded m-portlet--bordered">
      <?php if($estimation_data!=''){?>
        <div class="m-portlet__head">
          <div class="m-portlet__head-caption">
            <div class="m-portlet__head-title">
              <h3 class="m-portlet__head-text">
                Create Sales Quotation - From Estimation #<?php echo $estimation_data->estimation_no ?>
              </h3>
            </div>
          </div>
        </div>
      <?php } ?>
      <div class="m-portlet__body" style="padding: 1rem 2.2rem;">
        <form autocomplete="off" id="form_sale_add" method="post" action="javascript:;" enctype="multipart/form-data" class="m-form m-form--fit m-form--state m-form--label-align-right " >
          <div class="m-form m-form--label-align-right m--margin-bottom-10">
            <div class="row">
              <div class="col-lg-3">
                <div class="form-group m-form__group"  >
                  <label for="user_name">
                    Select Sale From Location
                  </label>
                  <div class="m-select2 m-select2--air m-select2--pill">
                    <select required id="location_from" name="location_from_1"  style="width: 100%" class="form-control m-input" aria-describedby="basic-addon1" data-placeholder="Select Location">
                      <option selected disabled>Select Location</option>
                      <?php
                      foreach($stock_locations as $row):
                        $location_name = $row->location_name;
                        ?>
                        <option value="<?php echo $row->location_id?>"><?php echo $location_name?></option>
                        <?php
                      endforeach;
                      ?>
                    </select>
                  </div>
                  <span class="m-form__help"></span>
                </div>
              </div>
              <div class="col-lg-2" <?php if ($this->config->item('app_module_company_branches') == 0){?> style="display:none"<?php } ?>>
                <div class="form-group m-form__group" >
                  <label for="user_name">
                    Invoice Type
                  </label>
                  <div class="m-radio-inline" style="padding-top: 10px;">
                    <label class="m-radio m-radio--solid m-radio--state-warning">
                      <input type="radio" <?php if ($this->config->item('app_module_company_branches') != 0){ echo 'checked'; } ?>  class="form_fields_radio" name="invoice_type_add"  value="B2B"> B2B
                      <span></span>
                    </label>
                    <label class="m-radio m-radio--solid m-radio--state-danger">
                      <input required type="radio" <?php if ($this->config->item('app_module_company_branches') == 0){ echo 'checked'; } ?> class="form_fields_radio"  name="invoice_type_add" value="B2C"> B2C
                      <span></span>
                    </label>
                  </div>
                  <span class="m-form__help"></span>
                </div>
              </div>
              <div class="col-lg-4">
                <?php if ($this->config->item('app_module_company_branches') == 1 && $this->session->userdata('branch_id') == 0){?>
                  <div class="form-group m-form__group">
                    <label for="user_name">
                      Invoice To
                    </label>
                    <div class="m-radio-inline" style="padding-top: 10px;">
                      <label class="m-radio m-radio--solid m-radio--state-info">
                        <input required type="radio" checked class="form_fields_radio"  name="invoice_to_add" value="Branch"> Branch
                        <span></span>
                      </label>
                      <label class="m-radio m-radio--solid m-radio--state-success">
                        <input type="radio" class="form_fields_radio" name="invoice_to_add"  value="Customer"> Customer
                        <span></span>
                      </label>
                    </div>
                  </div>
                <?php } ?>
                <div class="form-group m-form__group" style="padding-top:0px !important">
                  <label for="user_name">
                    Customer <?php if ($this->config->item('app_module_company_branches') == 1 && $this->session->userdata('branch_id') == 0){?>/ Branch <?php } ?>
                  </label>
                  <div class="input-group m-input-group m-input-group--pill" id="div_customer" style="display:none">
                    <div class="input-group-prepend">
                      <a href="#customer_add_modal"   data-toggle="modal" data-target="#customer_add_modal" class="btn btn-focus">
                        <i class="fa fa-plus-circle"></i>
                      </a>
                    </div>
                    <select style="width: 82%" class="form-control m-select2 m-select2-general" id="customer_add" name="customer" data-placeholder="Select Customer">

                    </select>
                  </div>
                  <?php if ($this->config->item('app_module_company_branches') == 1 && $this->session->userdata('branch_id') == 0){?>
                    <div class="m-select2 m-select2--air m-select2--pill" id="div_branch" >
                      <select required id="branch_add"  name="branch"  style="width: 100%" class="form-control m-input"  aria-describedby="basic-addon1" >
                        <option selected disabled>Select Branch</option>
                        <?php foreach ($branches as $key => $value) { ?>
                          <option value="<?php echo $value->branch_id ?>"><?php echo $value->branch_name ?></option>
                        <?php } ?>
                      </select>
                    </div>
                  <?php } ?>
                  <span class="m-form__help"></span>
                </div>
              </div>
              <?php if ($this->config->item('Material_sale_price_category_enable') == 1){ ?>
                <div class="col-lg-2">
                  <div class="form-group m-form__group" >
                    <label>Sale Price Category:</label>
                    <div class="m-select2 m-select2--air m-select2--pill">
                      <select required id="sale_price_category_1"  name="sale_price_category"  style="width: 100%" class="form-control m-input"  aria-describedby="basic-addon1" >
                        <option selected disabled>Select Price Category</option>
                        <option value="1"><?php echo $this->config->item('Material_sale_price1_name') ?></option>
                        <option value="2"><?php echo $this->config->item('Material_sale_price2_name') ?></option>
                        <option value="3"><?php echo $this->config->item('Material_sale_price3_name') ?></option>
                        <option value="4"><?php echo $this->config->item('Material_sale_price4_name') ?></option>
                        <option value="5"><?php echo $this->config->item('Material_sale_price5_name') ?></option>
                        <option value="6"><?php echo $this->config->item('Material_sale_price6_name') ?></option>
                      </select>
                    </div>
                    <span class="m-form__help"></span>
                  </div>
                </div>
              <?php } ?>
              <div class="col-lg-1">
                <br/>
                <button type="submit" style="margin-top: 7px" id="btn_go" class="btn btn-focus m-btn m-btn--custom m-btn--icon m-btn--air m-btn--pill">
                  <span>
                    <i class="la la-search"></i>
                    <span>
                      Go
                    </span>
                  </span>
                </button>
              </div>
            </div>

          </div>
        </form>
      </div>
    </div>
    <div class="m-portlet  m-portlet--rounded m-portlet--bordered cart_div" style="display: none">
      <div class="m-portlet__body" style="padding: 1rem 2.2rem;">
        <form autocomplete="off" id="form_items_add" method="post" action="<?php echo base_url()?>sales_invoice/create_sale"  enctype="multipart/form-data" class=" m-form m-form--fit m-form--state m-form--label-align-right " >
          <input type="hidden" name="location_id" id="location_from_2" />
          <input type="hidden" name="customer_id" id="customer_id" />
          <input type="hidden" name="branch_id" id="branch_id" />
          <input type="hidden" name="invoice_type" id="invoice_type" />
          <input type="hidden" name="invoice_to" id="invoice_to" />
          <input type="hidden" name="sale_price_category" id="sale_price_category" />
          <!-- <input type="hidden" name="buyer_name" id="buyer_name" /> -->
          <input type="hidden" name="buyer_address" id="buyer_address" />
          <input type="hidden" name="buyer_phone" id="buyer_phone" />
          <input type="hidden" name="buyer_taxno" id="buyer_taxno" />
          <input type="hidden" name="buyer_state_id" id="buyer_state_id" />
          <input type="hidden" name="estimation_id" value="<?php echo $estimation_id?>" />
          <br/><br/>

          <div class="row">
            <div class="col-lg-4">
              <div class="form-group m-form__group" >
                <label>Buyer/Customer Name:</label>
                <div class="input-group m-input-group--air m-input-group--pill date">
                  <input  autocomplete="off" name="buyer_name" id="buyer_name" type="text" class="form-control  m-input " placeholder="Buyer Name" required >
                </div>
              </div>
              <div class="form-group m-form__group" style="padding-top:0px" >
                <label>Buyer/Customer Address:</label>
                <textarea readonly class="form-control m-input m-input--air m-input--pill m-input--solid" id="buyer_address_show" name="buyer_address_show" rows="7"></textarea>
              </div>
            </div>
            <div class="col-lg-8">
              <div class="row">
                <div class="col-lg-2">
                  <div class="form-group m-form__group m-select2--pill">
                    <label for="user_name">
                      Vehicle Type
                    </label>
                    <div class="m-select2 m-select2--air m-select2--pill">
                      <select style="width: 100%" class="form-control m-select2 m-select2-general" id="vehicle_type_add" name="vehicle_type" data-placeholder="Select Category">
                        <option value="all" selected>All Types</option>
                        <option value="own">Owned</option>
                        <option value="rent">Rental</option>
                      </select>
                    </div>
                    <span class="m-form__help"></span>
                  </div>
                </div>
                <div class="col-lg-4">
                  <div class="form-group m-form__group" >
                    <label for="user_name">
                      Vehicle Name
                    </label>
                    <div class="input-group m-input-group m-input-group--pill">
                      <div class="input-group-prepend">
                        <a href="#vehicle_add_modal"   data-toggle="modal" data-target="#vehicle_add_modal" class="btn btn-focus">
                          <i class="fa fa-plus-circle"></i>
                        </a>
                      </div>
                      <select style="width: 82%" class="form-control m-select2 m-select2-general"  id="vehicle_add" name="vehicle_id" data-placeholder="Select the vehicle">

                      </select>
                    </div>
                    <span class="m-form__help"></span>
                  </div>
                </div>
              </div>
              <div class="row">
                <div class="col-lg-3">
                  <div class="form-group m-form__group" >
                    <label>Invoice Date:</label>
                    <div class="input-group m-input-group--air m-input-group--pill date">
                      <input required data-date-format="dd-mm-yyyy" autocomplete="off" id="invoice_date" name="invoice_date"  type="text" class="form-control  m-input " placeholder="Invoice Date" >
                    </div>
                  </div>
                  <div class="form-group m-form__group" >
                    <label>Delivery Date:</label>
                    <div class="input-group m-input-group--air m-input-group--pill date">
                      <input required data-date-format="dd-mm-yyyy" autocomplete="off" id="delivery_date" name="delivery_date"  type="text" class="form-control  m-input " placeholder="Delivery Date" >
                    </div>
                    <span class="m-form__help"></span>
                  </div>
                </div>
                <div class="col-lg-3">
                  <div class="form-group m-form__group" >
                    <label>Vehicle:</label>
                    <div class="input-group m-input-group--air m-input-group--pill date">
                      <input  autocomplete="off" name="vehicle" id="vehicle_no_add" type="text" class="form-control  m-input " placeholder="Vehicle" >
                    </div>
                  </div>
                  <div class="form-group m-form__group" >
                    <label>Delivery Note No:</label>
                    <div class="input-group m-input-group--air m-input-group--pill date">
                      <input  autocomplete="off" name="delivery_note_no"  type="text" class="form-control  m-input " placeholder="Delivery Note No" >
                    </div>
                    <span class="m-form__help"></span>
                  </div>
                </div>
                <div class="col-lg-3">
                  <div class="form-group m-form__group" >
                    <label>Despatched Through:</label>
                    <div class="input-group m-input-group--air m-input-group--pill date">
                      <input  autocomplete="off" name="despatched_through"  type="text" class="form-control  m-input " placeholder="Despatched Through" >
                    </div>
                  </div>
                  <div class="form-group m-form__group" >
                    <label>Destination/Route:</label>
                    <div class="input-group m-input-group--air m-input-group--pill date">
                      <input  autocomplete="off" name="destination"  type="text" class="form-control  m-input " placeholder="Destination" >
                    </div>
                    <span class="m-form__help"></span>
                  </div>
                </div>
                <div class="col-lg-3">
                  <div class="form-group m-form__group" >
                    <label>Buyers Order No:</label>
                    <div class="input-group m-input-group--air m-input-group--pill date">
                      <input  autocomplete="off" name="buyers_order_no"  type="text" class="form-control  m-input " placeholder="Buyers Order No" >
                    </div>
                  </div>
                  <div class="form-group m-form__group" >
                    <label>Buyers Order Date:</label>
                    <div class="input-group m-input-group--air m-input-group--pill date">
                      <input data-date-format="dd-mm-yyyy" autocomplete="off" id="buyers_order_date" name="buyers_order_date"  type="text" class="form-control  m-input " placeholder="Order Date" >
                    </div>
                    <span class="m-form__help"></span>
                  </div>

                </div>
              </div>
            </div>

          </div>
          <div style="background: white;border: 4px solid #f7f7fa;padding: 15px;margin: 0px;padding-bottom: 0px;" >
            <div class="m-section">
              <div class="row">
                <div class="col-lg-6">
                  <h3 class="m-section__heading">Cart Items</h3>
                </div>
                <div class="col-lg-6">
                  <button style="float: right;margin-bottom: 10px" type="button" id="btn_add_item" class="btn btn-brand">
                    Add Items to Cart
                  </button>
                </div>
              </div>
              <div class="row">
                <div class="col-lg-12">
                  <table style="width: 100%;max-width: 100%"  id="table_items" class="table m-table m-table--head-bg-success order-list table-striped table-bordered table-advance table-hover">
                    <thead>
                      <tr>
                        <th style="width:5%">Sl No</th>
                        <th style="width:22%">Item Name</th>
                        <th style="width:7%">UoM</th>
                        <th style="display:none">Unit Cost</th>
                        <th style="width:10%">Rate</th>
                        <th style="display:none">Available Qty</th>
                        <th style="width:8%">Qty</th>
                        <th style="width:8%">Disc Amt</th>
                        <th style="width:9%">Taxable Amt</th>
                        <th style="width:13%"><?php echo $this->config->item('Tax_tax_name')." %" ?></th>
                        <th style="width:9%"><?php echo $this->config->item('Tax_tax_name')." Amt" ?></th>
                        <th style="width:20%">Total Amount</th>
                        <th style="width:4%">&nbsp;</th>
                      </tr>
                    </thead>
                    <tbody id="table_body">

                    </tbody>
                  </table>
                  <input type="hidden" value="0" id="current_row_count" name="current_row_count" >
                  <input type="hidden" value="0" id="actual_row_count" name="actual_row_count" >
                </div>
              </div>
            </div>
          </div>
          <div class="row">
            <div class="col-lg-8">
              <div style="background: white;border: 4px solid #f7f7fa;padding: 15px;margin: 19px;padding-bottom: 0px">
                <div class="m-section" style="margin-bottom: 10px">
                  <h3 class="m-section__heading">Payment Details</h3>
                  <div class="row">
                    <div class="col-lg-4">
                      <div class="form-group m-form__group" >
                        <label for="user_name">
                          Received Amount
                        </label>
                        <div class="input-group m-input-group m-input-group--pill m-input-group--air">
                          <div class="input-group-prepend">
                            <span class="input-group-text" id="basic-addon1">
                              <?php echo $this->config->item('Currency_currency_format'); ?>
                            </span>
                          </div>
                          <input value="0"  required type="text" id="received_amount" name="received_amount"  class="form-control bill_inputs  m-input summary_key" placeholder="Received Amount" aria-describedby="basic-addon1">
                        </div>
                        <input type="hidden" name="payment_part" value="1" />
                        <span class="m-form__help"></span>
                      </div>
                    </div>
                    <div class="col-lg-4">
                      <div class="form-group m-form__group received_date_div" style="display: none;" >
                        <label for="user_name">
                          Received Date
                        </label>
                        <div class="input-group m-input-group--pill m-input-group--air date">
                          <div class="input-group-prepend">
                            <span class="input-group-text">
                              <i class="la la-calendar"></i>
                            </span>
                          </div>
                          <input  data-date-format="dd-mm-yyyy" id="received_date"  type="text" name="received_date" class="form-control m-input   " placeholder="Received Date" >
                        </div>
                        <span class="m-form__help"></span>
                      </div>
                    </div>
                    <div class="col-lg-4">
                      <div class="form-group m-form__group received_date_div" style="display: none;" >
                        <label for="user_name">
                          Received to Acc
                        </label>
                        <div class="m-select2 m-select2--air m-select2--pill">
                          <select required id="credit_acc" name="credit_acc" style="width: 100%" class="form-control m-input"  aria-describedby="basic-addon1" data-placeholder="Select Credit Acc">
                            <?php
                            foreach($this->config->item('account_heads') as $row):
                              $selected="";
                              if($row->acc_head_id==1){
                                $selected="selected";
                              }
                              ?>
                              <option <?php echo $selected?> value="<?php echo $row->acc_head_id?>"><?php echo $row->acc_head_name?></option>
                              <?php
                            endforeach;
                            ?>
                          </select>
                        </div>
                        <span class="m-form__help"></span>
                      </div>
                    </div>
                    <div class="col-lg-6">
                      <div class="form-group m-form__group received_date_div" style="display: none;padding-top: 0px">
                        <label for="user_name">
                          Transaction Reference
                        </label>
                        <div class="input-group m-input-group--pill m-input-group--air date">
                          <input type="text"  name="reference_no" id="reference_no"   class="form-control  m-input  m-input--air" placeholder="Transaction Reference" >
                        </div>
                        <span class="m-form__help"></span>
                      </div>
                    </div>
                    <div class="col-lg-6">
                      <div class="form-group m-form__group received_date_div" style="display: none;padding-top: 0px">
                        <label for="user_name">
                          TR Remarks
                        </label>
                        <div class="input-group m-input-group--pill m-input-group--air date">
                          <input type="text"  name="tr_remarks" id="tr_remarks"   class="form-control  m-input  m-input--air" placeholder="Remarks" >
                        </div>
                        <span class="m-form__help"></span>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
              <div class="m-form__content" style="display:none;margin-top:15px;padding: 0px" id="vehicle_work_slip_div">
                <div style="background: white;border: 4px solid #f7f7fa;padding: 15px;margin: 5px;padding-bottom: 0px">
                  <div class="m-section" style="margin-bottom: 10px">
                    <h3 class="m-section__heading">Vehicle Work Slip Details</h3>
                    <div class="row">
                      <div class="col-lg-3" style="padding-right:5px">
                        <div class="form-group m-form__group" >
                          <label for="user_name">
                            Worked Duration
                          </label>
                          <div class="input-group m-input-group m-input-group--pill m-input-group--air">
                            <input value="0"  type="text" name="vehicle_worked_duration" id="vehicle_worked_duration_add"  class="vehicle_work_slip_calculate_fields vehicle_work_slip_required_fields form-control m-input" placeholder="Worked Duration" aria-describedby="basic-addon1" required>
                          </div>
                          <span class="m-form__help"></span>
                        </div>
                      </div>
                      <div class="col-lg-3" style="padding-right:5px;padding-left:5px">
                        <div class="form-group m-form__group m-select2--pill">
                          <label for="user_name">
                            Duration Type
                          </label>
                          <div class="m-select2 m-select2--air m-select2--pill">
                            <select style="width: 100%" class="form-control m-select2 m-select2-general vehicle_work_slip_required_fields vehicle_work_slip_calculate_fields"  id="vehicle_work_duration_type2_add" name="vehicle_work_duration_type" data-placeholder="Select Work Duration Type">
                              <option disabled="" selected="">Duration type</option>
                              <option value="Hour">Hour</option>
                              <option value="Trip">Trip</option>
                              <option value="Kilometer">Kilometer</option>
                              <option value="Day">Day</option>
                              <option value="Month">Month</option>
                            </select>
                          </div>
                          <span class="m-form__help"></span>
                        </div>
                      </div>
                      <div class="col-lg-3" style="padding-right:5px;padding-left:5px">
                        <div class="form-group m-form__group" >
                          <label for="user_name">
                            Basic Charge
                          </label>
                          <div class="input-group m-input-group m-input-group--pill m-input-group--air">
                            <input type="text" value="0"   name="vehicle_basic_charge" id="vehicle_basic_charge_add"  class="vehicle_work_slip_required_fields form-control m-input vehicle_work_slip_calculate_fields" placeholder="Basic Daily Wage" aria-describedby="basic-addon1" >
                          </div>
                          <span class="m-form__help"></span>
                        </div>
                      </div>
                      <div class="col-lg-3" style="padding-right:5px;padding-left:5px">
                        <div class="form-group m-form__group" style="padding-top:0px;padding-bottom:10px;" >
                          <label for="user_name">
                            Total Basic Charge
                          </label>
                          <div class="input-group m-input-group m-input-group--pill m-input-group--air">
                            <input type="text" value="0"  readonly  name="vehicle_basic_charge_total" id="vehicle_total_basic_charge_add"  class="form-control m-input " placeholder="Basic Daily Wage" aria-describedby="basic-addon1" >
                          </div>
                          <!-- <span class="m-form__help"></span> -->
                        </div>
                      </div>
                    </div>
                    <div class="row" >
                      <div class="col-lg-3">
                        <div class="form-group m-form__group" >
                          <label for="user_name">
                            Driver Bata
                          </label>
                          <div class="input-group m-input-group m-input-group--pill">
                            <input value="0"  type="text" name="driver_bata" id="driver_bata_add"  class=" vehicle_work_slip_calculate_fields form_vehicle_work_slip_add_fields_1 form-control m-input m-input--air m-input--pill" placeholder="Location" aria-describedby="basic-addon1">
                            <div class="input-group-append">
                              <span class="input-group-text">
                                <label class="m-checkbox m-checkbox--single m-checkbox--state m-checkbox--state-primary">
                                  <input type="checkbox" class="vehicle_work_slip_calculate_fields" value="1" name="driver_bata_include" id="driver_bata_include_add" checked="checked">
                                  <span></span>
                                </label>
                              </span>
                            </div>
                          </div>
                          <span class="m-form__help">Check to Include in Payable</span>
                        </div>
                      </div>
                      <div class="col-lg-6"></div>
                      <div class="col-lg-3">
                        <div class="form-group m-form__group" style="padding-top:0px;padding-bottom:10px;" >
                          <label for="user_name">
                            Total Vehicle Charge
                          </label>
                          <div class="input-group m-input-group m-input-group--pill m-input-group--air">
                            <input type="text" value="0"  readonly  name="vehicle_total_charge" id="vehicle_total_charge"  class="form-control m-input " placeholder="" aria-describedby="basic-addon1" >
                          </div>
                          <!-- <span class="m-form__help"></span> -->
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
            <div class="col-lg-4">
              <div  style="background: white;border: 4px solid #f7f7fa;padding: 30px;margin: 20px;padding-bottom: 0px;">
                <div class="m-section">
                  <h3 class="m-section__heading">Bill Summary </h3>
                  <div class="col-lg-12">
                    <div class="form-group m-form__group">
                      <label for="user_name">
                        Bill Net Total Amount
                      </label>
                      <div class="input-group m-input-group m-input-group--pill m-input-group--air">
                        <div class="input-group-prepend">
                          <span class="input-group-text" id="basic-addon1">
                            <?php echo $this->config->item('Currency_currency_format'); ?>
                          </span>
                        </div>
                        <input value="0" readonly="" type="text" name="bill_net_total_amount" id="bill_net_total_amount" class="form-control m-input m-input--solid summary_key" placeholder="Bill Net Total Amount" aria-describedby="basic-addon1">
                      </div>
                      <span class="m-form__help"></span>
                    </div>
                  </div>
                  <div class="col-lg-12">
                    <div class="form-group m-form__group">
                      <label for="user_name">
                        <?php echo $this->config->item('Tax_tax_name')?> Amount
                      </label>
                      <div class="input-group m-input-group m-input-group--pill m-input-group--air">
                        <div class="input-group-prepend">
                          <span class="input-group-text" id="basic-addon1">
                            <?php echo $this->config->item('Currency_currency_format'); ?>
                          </span>
                        </div>
                        <input value="0" readonly type="text" id="bill_tax_amount" name="bill_tax_amount"  class="form-control m-input " placeholder="Bill GST Amount" aria-describedby="basic-addon1">
                      </div>
                      <span class="m-form__help"></span>
                    </div>
                  </div>
                  <div class="col-lg-12">
                    <div class="form-group m-form__group">
                      <label for="user_name">
                        Grand Total
                      </label>
                      <div class="input-group m-input-group m-input-group--pill m-input-group--air">
                        <div class="input-group-prepend">
                          <span class="input-group-text" id="basic-addon1">
                            <?php echo $this->config->item('Currency_currency_format'); ?>
                          </span>
                        </div>
                        <input value="0" readonly type="text" name="bill_grand_total" id="bill_grand_total" class="form-control m-input m-input--solid" placeholder="Grand Total" aria-describedby="basic-addon1">
                      </div>
                      <span class="m-form__help"></span>
                    </div>
                  </div>
                  <div class="col-lg-12">
                    <div class="form-group m-form__group">
                      <label for="user_name">
                        Round Amount
                      </label>
                      <div class="input-group m-input-group m-input-group--pill m-input-group--air">
                        <div class="input-group-prepend">
                          <span class="input-group-text" id="basic-addon1">
                            <?php echo $this->config->item('Currency_currency_format'); ?>
                          </span>
                        </div>
                        <input value="0" required type="text" name="bill_round_amount" id="bill_round_amount" class="form-control m-input bill_inputs" placeholder="Grand Total" aria-describedby="basic-addon1">
                      </div>
                      <span class="m-form__help"></span>
                    </div>
                  </div>
                  <div class="col-lg-12">
                    <div class="form-group m-form__group">
                      <label for="user_name">
                        Bill Receivable Amount
                      </label>
                      <div class="input-group m-input-group m-input-group--pill m-input-group--air">
                        <div class="input-group-prepend">
                          <span class="input-group-text" id="basic-addon1">
                            <?php echo $this->config->item('Currency_currency_format'); ?>
                          </span>
                        </div>
                        <input value="0" readonly type="text" name="bill_receivable_amount" id="bill_receivable_amount" class="form-control m-input m-input--solid" placeholder="Grand Total" aria-describedby="basic-addon1">
                      </div>
                      <span class="m-form__help"></span>
                    </div>
                  </div>
                  <div class="col-lg-12">
                    <div class="form-group m-form__group">
                      <label for="user_name">
                        Total Received
                      </label>
                      <div class="input-group m-input-group m-input-group--pill m-input-group--air">
                        <div class="input-group-prepend">
                          <span class="input-group-text" id="basic-addon1">
                            <?php echo $this->config->item('Currency_currency_format'); ?>
                          </span>
                        </div>
                        <input value="0" readonly type="text" name="total_received" id="total_received" class="form-control m-input " aria-describedby="basic-addon1">
                      </div>
                      <span class="m-form__help"></span>
                    </div>
                  </div>
                  <div class="col-lg-12">
                    <div class="form-group m-form__group">
                      <label for="user_name">
                        Balance Amount
                      </label>
                      <div class="input-group m-input-group m-input-group--pill m-input-group--air">
                        <div class="input-group-prepend">
                          <span class="input-group-text" id="basic-addon1">
                            <?php echo $this->config->item('Currency_currency_format'); ?>
                          </span>
                        </div>
                        <input value="0" readonly="" type="text" name="balance_amount" id="balance_amount" class="form-control m-input m-input--solid" placeholder="Balance Amount" aria-describedby="basic-addon1">
                      </div>
                      <span class="m-form__help"></span>
                    </div>
                  </div>
                  <div class="col-lg-12">
                    <div class="form-group m-form__group">
                      <label for="exampleTextarea">Terms of Delivery</label>
                      <textarea class="form-control m-input m-input--air m-input--pill" id="remarks" name="remarks" rows="5"></textarea>
                      <span class="m-form__help"></span>
                    </div>
                  </div>
                  <div class="col-lg-12">
                    <div class="form-group m-form__group">
                      <label>
                        Bank Account
                      </label>
                      <div class="m-select2 m-select2--air m-select2--pill">
                        <select width="100%"  class="form-control m-select2" id="bank_account_add" name="bank_account"  >
                          <option selected disabled> Select Bank Account</option>
                          <?php foreach ($bank_accounts as $key => $value) {?>
                            <option value="<?php echo $value->account_id?>"><?php echo $value->company_name?> [ <?php echo $value->bank_name."-".$value->bank_branch?> ]</option>
                          <?php } ?>
                        </select>
                      </div>
                      <span class="m-form__help"></span>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
          <div class="m-portlet__foot m-portlet__foot--fit">
            <div class="m-form__actions m-form__actions">
              <div class="row">
                <div class="col-lg-9 ml-lg-auto">
                  <button type="submit" class="btn btn-brand form_submit_btn">
                    Save & Submit
                  </button>
                  <button type="reset" class="btn btn-secondary">
                    Cancel
                  </button>
                </div>
              </div>
            </div>
          </div>
        </form>
      </div>
    </div>
    <div style="display: none" id="stock_list_div" class="m-portlet m-portlet--mobile m-portlet--info m-portlet--head-solid-bg m-portlet--bordered m-portlet--rounded">
      <div class="m-portlet__head">
        <div class="m-portlet__head-caption">
          <div class="m-portlet__head-title">
            <h3 class="m-portlet__head-text" id="stock_list_div_title"></h3>
          </div>
        </div>
        <div class="m-portlet__head-tools">

        </div>
      </div>
      <div class="m-portlet__body">
        <!--begin: Datatable -->
        <table width="100%" class="table m-table  table-header-fixed table-striped- table-bordered table-hover table-header-fixed" id="stock_list_table">
          <thead>
            <tr class="">
              <th rowspan="2">Sl No</th>
              <th rowspan="2">Stock ID</th>
              <th rowspan="2">Material ID</th>
              <th rowspan="2">Unit ID</th>
              <th rowspan="2">Location ID</th>
              <th rowspan="2">Material Name</th>
              <th rowspan="2">Unit</th>
              <th rowspan="2">Unit Cost<br/>(Purchase)</th>
              <th rowspan="2" id="sale_price_column"></th>
              <th rowspan="2">Supplier</th>
              <th colspan="2">Currently Available Stock</th>
              <th rowspan="2">Location</th>
              <th rowspan="2">Location Type</th>
              <th colspan="2" style="display: none">Total Purchased Stock</th>
              <th colspan="2" style="display: none">Total Transferred In Stock</th>
              <th colspan="2" style="display: none">Total Transferred Out Stock</th>
              <th colspan="2" style="display: none">Total Consumed Stock</th>
              <th rowspan="2">Supplier ID</th>
              <th rowspan="2"></th>
            </tr>
            <tr>
              <th><span class="hidden">Currently Available Stock</span> Qty</th>
              <th>Amount</th>
              <th><span class="hidden">Total Purchased Stock</span> Qty</th>
              <th>Amount</th>
              <th><span class="hidden">Total Transferred In Stock</span>Qty</th>
              <th>Amount</th>
              <th><span class="hidden">Total Transferred Out Stock</span>Qty</th>
              <th>Amount</th>
              <th><span class="hidden">Total Consumed Stock</span>Qty</th>
              <th>Amount</th>
            </tr>
          </thead>
          <tbody>
          </tbody>
        </table>
        <!--end: Datatable -->

      </div>
    </div>

    <?php $this->view("modules/include_modals/modal_customers");?>
    <?php $this->view("modules/include_modals/modal_vehicle_add");?>
  </div>
</div>
</div>
<!-- end:: Body -->
<!-- begin::Footer -->

<?php $this->view("includes/Inc_footer");?>
<!-- end::Footer -->
</div>
<!-- end:: Page -->

<?php $this->view("includes/Inc_sidebar");?>
<?php $this->view("includes/Inc_scripts");?>
<?php $this->view("modules/include_scripts/customers_scripts"); ?>
<!--begin::Page Snippets -->
<script>
//    Toggle Sidebar
$("#m_aside_left_minimize_toggle").addClass("m-brand__toggler--active");
$("#body").addClass("m-brand--minimize m-aside-left--minimize");
$(".m_selectpicker").selectpicker();

$("#sales_invoice_menu").addClass('m-menu__item--active m-menu__item--open');
$("#sales_invoice_menu1").addClass('m-menu__item--active');
$("#vehicle_add").select2({
  placeholder: "Select vehicle",
  dropdownParent: $("#form_items_add")
})
$("#vehicle_type_add").select2({
  placeholder: "Select Type",
  dropdownParent: $("#form_items_add")
})
$("#vehicle_type").select2({
  placeholder: "Select vehicle type",
  dropdownParent: $("#form_vehicle_add")
})
$("#work_duration_type").select2({
  placeholder: "Select vehicle type",
  dropdownParent: $("#form_vehicle_add")
})
$("#consignee_add").select2({
  placeholder: "Select Consignee",
  dropdownParent: $("#form_vehicle_add")
})
$("#vehicle_work_duration_type2_add").select2({
  placeholder: "Duration Type",
  dropdownParent: $("#form_purchase_add")
})
$("#vehicle_driver_add").select2({
  placeholder: "Select Driver",
  dropdownParent: $("#form_purchase_add")
})
select_vehicles("vehicle_add");
$('#vehicle_category_add,#vehicle_type_add').on("change", function(e) {
  var category = $('#vehicle_category_add :selected').val();
  var vehicle_type = $('#vehicle_type_add :selected').val();
  select_vehicles("vehicle_add",'',category,vehicle_type);
});
$('#vehicle_add').on("change", function(e) {
  var vehicle_no = $('#vehicle_add :selected').data('vehicle-no');
  $("#vehicle_no_add").val(vehicle_no);
  if(vehicle_no!=''){
    $("#vehicle_work_slip_div").show();
    $(".vehicle_work_slip_required_fields").attr('required',true);
  }else{
    $("#vehicle_work_slip_div").hide();
    $(".vehicle_work_slip_required_fields").removeAttr('required',true);
  }

  var vehicle_id = $('#vehicle_add').val();
  $.post("<?php echo base_url() ?>vehicles/select_details",{vehicle_id:vehicle_id},function(data) {
    var obj = $.parseJSON(data);
    var i=0;
    if(obj.count==1) {
      $("#vehicle_basic_charge_add").val(obj.data['basic_charge']);
      $('#vehicle_work_duration_type2_add').val(obj.data['work_duration_type']).trigger('change');

      $('#vehicle_driver_add').html('');
      $("#vehicle_driver_add").append("<option selected disabled >Select Driver</option>");
      if(obj.data['vehicle_type']=='own'){
        $(".owned_vehicle_fields_add").show();
        $(".owned_vehicle_required_fields_add").attr('required',true);
        var assigned_drivers = obj.data['assigned_drivers'];
        if(assigned_drivers!=''){
          var i=0;
          while (i < assigned_drivers.length) {
            $("#vehicle_driver_add").append("<option value=" + assigned_drivers[i]['employee_id'] + ">" + assigned_drivers[i]['employee_name'] + "</option>");
            i++;
          }
        }
      }else{
        $(".owned_vehicle_fields_add").hide();
        $(".owned_vehicle_required_fields_add").removeAttr('required',true);
      }
      calculate_vehicle_charge();
    }
  })
})
$('body').on('change keyup', '.vehicle_work_slip_calculate_fields', function() {
  calculate_vehicle_charge();
})
function calculate_vehicle_charge(){

  var worked_duration = parseFloat($("#vehicle_worked_duration_add").val());
  var basic_charge = parseFloat($("#vehicle_basic_charge_add").val());
  // var overtime_duration = parseFloat($("#overtime_duration_vehicle_add").val());
  // var overtime_rate = parseFloat($("#overtime_rate_vehicle_add").val());
  // var overtime_amount = overtime_duration*overtime_rate;
  var driver_bata = 0;
  if($("#driver_bata_include_add").is(":checked")){
    driver_bata = parseFloat($("#driver_bata_add").val());
  }
  var total_basic_wage = (worked_duration*basic_charge);
  $("#vehicle_total_basic_charge_add").val(total_basic_wage);
  var total_payable =  total_basic_wage + driver_bata;
  $("#vehicle_total_charge").val(total_payable);
}
$("#invoice_date").datepicker( {
  todayHighlight:!0, orientation:"bottom left", templates: {
    leftArrow: '<i class="la la-angle-left"></i>', rightArrow: '<i class="la la-angle-right"></i>'
  },
  endDate: '+0d',
  <?php if($this->session->userdata('user_role')!='admin' && $this->config->item('User_calendar_date_restriction_enabled')==1){ ?>
    startDate: '<?php echo $this->config->item('User_calendar_date_restriction_start_days');?>d'
    <?php } ?>
  })
  $("#buyers_order_date").datepicker( {
    todayHighlight:!0, orientation:"bottom left", templates: {
      leftArrow: '<i class="la la-angle-left"></i>', rightArrow: '<i class="la la-angle-right"></i>'
    },
    endDate: '+0d',
  })
  $("#delivery_date").datepicker( {
    todayHighlight:!0, orientation:"bottom left", templates: {
      leftArrow: '<i class="la la-angle-left"></i>', rightArrow: '<i class="la la-angle-right"></i>'
    },
    <?php if($this->session->userdata('user_role')!='admin' && $this->config->item('User_calendar_date_restriction_enabled')==1){ ?>
      startDate: '<?php echo $this->config->item('User_calendar_date_restriction_start_days');?>d'
      <?php } ?>
    })
    $("#credit_acc").select2({
      // dropdownParent: $("#form_sale_add"),
      placeholder: "Select Debit Acc"
    })
    $("#bank_account_add").select2({
      placeholder: "Select Bak Account"
    })
    $("#location_from, #location_to").select2({
      // dropdownParent: $("#form_sale_add"),
      placeholder: "Select Warehouse"
    })
    $("#customer_add").select2({
      // dropdownParent: $("#form_sale_add"),
      placeholder: "Select Customer"
    })
    $("#branch_add").select2({
      // dropdownParent: $("#form_sale_add"),
      placeholder: "Select Branch"
    })
    $("#sale_price_category_1").select2({
      // dropdownParent: $("#form_sale_add"),
      placeholder: "Select Price Category"
    })
    $('body').on('change', 'input[type=radio][name=invoice_type_add]', function() {
      var invoice_type = $("input[name='invoice_type_add']:checked").val();
      if(invoice_type=='B2B'){
        $('input[type=radio][name=invoice_to_add][value=Branch]').removeAttr('disabled',true);
      }else{
        $('input[type=radio][name=invoice_to_add][value=Branch]').attr('disabled',true);
        $('input[type=radio][name=invoice_to_add][value=Customer]').prop('checked',true).trigger('change');
      }
      select_customer();
    })
    function select_vehicles(select_id,selected_value='',category='',vehicle_type=''){
      $('#'+select_id).html('');
      $('#'+select_id).append("<option disabled selected >Select Vehicle</option>");

      $.post("<?php echo base_url() ?>vehicles/select_vehicles_list",{category:category,vehicle_type:vehicle_type},function(data) {
        var obj = $.parseJSON(data);
        var i=0;
        if(obj.count>0) {
          while (i < obj.data.length) {
            $('#'+select_id).append("<option data-vehicle-no='"+obj.data[i]['vehicle_no']+"'  value=" + obj.data[i]['id'] + ">" + obj.data[i]['vehicle_name'] + " : "+obj.data[i]['vehicle_no']+" [" + obj.data[i]['consignee_name'] + "]</option>");
            i++;
          }
          if(selected_value!=''){
            $("#"+select_id).val(selected_value).trigger("change");
          }
        }
      })
    }
    <?php if($this->session->userdata('branch_id')!=0){?>
      $("#div_customer").show();
      $("#customer_add").attr('required',true);
      <?php } ?>
      <?php if ($this->config->item('app_module_company_branches') == 1){?>
        $('body').on('change', 'input[type=radio][name=invoice_to_add]', function() {
          var invoice_to = $("input[name='invoice_to_add']:checked").val();
          if(invoice_to=='Branch'){
            $("#div_branch").show();
            $("#div_customer").hide();
            $("#branch_add").attr('required',true);
            $("#customer_add").removeAttr('required',true);
          }else{
            $("#div_branch").hide();
            $("#div_customer").show();
            $("#branch_add").removeAttr('required',true);
            $("#customer_add").attr('required',true);
          }
        })
        <?php }else{ ?>
          $("#div_customer").show();
          $("#customer_add").attr('required',true);
          <?php } ?>
          $('body').on('change', '#customer_add,#branch_add', function() {
            $("#sale_price_category_1").val('').trigger('change');
            var invoice_to = $("input[name='invoice_to_add']:checked").val();
            if(invoice_to=='Branch'){
              var branch_id = $('#branch_add').val();
              $.post("<?php echo base_url() ?>branches/select_details",{id:branch_id},function(data) {
                var obj = $.parseJSON(data);
                var i=0;
                if(obj.count==1) {
                  $("#sale_price_category_1").val(obj.data['sale_price_category']).trigger('change');
                  $("#buyer_name").val(obj.data['branch_name']);
                  $("#buyer_address").val(obj.data['branch_address']);
                  $("#buyer_phone").val(obj.data['branch_phone']);
                  $("#buyer_taxno").val(obj.data['branch_taxno']);
                  $("#buyer_state_id").val(obj.data['tax_state_id']);

                  var address = obj.data['branch_name'];
                  address += "\n"+obj.data['branch_address'];
                  address += "\nPhone : "+obj.data['branch_phone'];
                  address += "\nGSTIN : "+obj.data['branch_taxno'];
                  address += "\nState : "+obj.data['state_name']+"          State Code : "+obj.data['state_code'];
                  $("#buyer_address_show").val(address);
                }
              })
            }else{
              var customer_id = $('#customer_add').val();
              $.post("<?php echo base_url() ?>customers/select_details",{id:customer_id},function(data) {
                var obj = $.parseJSON(data);
                var i=0;
                if(obj.count==1) {
                  $("#sale_price_category_1").val(obj.data['sale_price_category']).trigger('change');
                  $("#buyer_name").val(obj.data['customer_name']);
                  $("#buyer_address").val(obj.data['customer_location']);
                  $("#buyer_phone").val(obj.data['customer_phone']);
                  $("#buyer_taxno").val(obj.data['customer_tax_no']);
                  $("#buyer_state_id").val(obj.data['customer_tax_state']);

                  var address = obj.data['customer_location'];
                  address += "\nPhone : "+obj.data['customer_phone'];
                  address += "\nGSTIN : "+obj.data['customer_tax_no'];
                  address += "\nState : "+obj.data['state_name']+"          State Code : "+obj.data['state_code'];
                  $("#buyer_address_show").val(address);
                }
              })
            }
          })
          select_customer();
          function select_customer(){
            <?php if ($this->config->item('app_module_company_branches') == 1){?>
              var invoice_type = $("input[name='invoice_type_add']:checked").val();
              <?php }else{?>
                var invoice_type = '';
                <?php } ?>
                $('#customer_add').html('');
                $("#customer_add").append("<option disabled selected >Select Customer</option>");
                $.post("<?php echo base_url() ?>customers/select",{tax_type:invoice_type},function(data) {
                  var obj = $.parseJSON(data);
                  var i=0;
                  if(obj.count>0) {
                    while (i < obj.id.length) {
                      $("#customer_add").append("<option value=" + obj.id[i] + ">" + obj.name[i] + " [" + obj.phone[i] + "]</option>");
                      i++;
                    }
                  }
                })
              }

              $("#btn_add_item").click(function() {
                $('html, body').animate({
                  scrollTop: $("#stock_list_div").offset().top
                }, 1000);
              });

              <?php if($estimation_data!=''){?>
                $("#location_from").val('').trigger('change');
                <?php } ?>

                jQuery.validator.addMethod("notEqual", function(value, element, param) {
                  return $('#location_from').val() != $('#location_to').val()
                }, "Please Select a different Location");
                $("#form_sale_add").validate( {
                  rules: {
                    location_from_1: {
                      required: !0
                    },
                    location_to_1: {
                      required: !0,
                      notEqual: !0
                    },
                    invoice_date_1: {
                      required: !0
                    }
                  },
                  invalidHandler:function(e, r) {
                    var i=$("#form_sale_add_msg");
                    i.removeClass("m--hide").show(), mUtil.scrollTo(i, -200)
                  }
                  , submitHandler:function(e) {
                    $("#stock_list_div").show();
                    $(".cart_div").show();

                    $("#location_from_2").val($("#location_from option:selected").val());
                    $("#customer_id").val($("#customer_add option:selected").val());
                    $("#branch_id").val($("#branch_add option:selected").val());
                    $("#invoice_type").val($("input[name='invoice_type_add']:checked").val());
                    $("#invoice_to").val($("input[name='invoice_to_add']:checked").val());
                    $("#sale_price_category").val($("#sale_price_category_1 option:selected").val());

                    $("#btn_go").hide();
                    $("#location_from").attr('disabled',true);
                    $("#customer_add").attr('disabled',true);
                    $("#location_to").attr('disabled',true);
                    $("#branch_add").attr('disabled',true);
                    $("#sale_price_category_1").attr('disabled',true);
                    $("input[type=radio][name=invoice_type_add]").attr('disabled',true);
                    $("input[type=radio][name=invoice_to_add]").attr('disabled',true);
                    $("#sale_price_column").html("Sale Price<br/>("+$("#sale_price_category_1 option:selected").text()+")");
                    stock_list_table();
                    item_table();
                  }
                }
              );

              var stock_list_table=function() {
                $('#stock_list_table').dataTable().fnDestroy();
                function GetSearchLocation(){
                  return $('#location_from').val();
                }
                function GetSearchMaterial(){
                  return $('#material_filter').val();
                }
                var loc_name = $("#location_from option:selected").text();
                $("#stock_list_div_title").text('List of Available Stock in '+loc_name);

                var table = $('#stock_list_table').DataTable({
                  "ajax":{
                    url :"<?php echo base_url().'stock/select_stock_register_2/sales_list' ?>", // json datasource
                    type: "post", // type of method  , by default would be get
                    data: function(d){
                      d.location_id = GetSearchLocation();
                      d.material_id = GetSearchMaterial();
                      d.quantity = 'available';
                      <?php if ($this->config->item('Material_sale_price_category_enable') == 1){ ?>
                        d.sale_price_category = $("#sale_price_category").val();
                        <?php } ?>
                      }
                    },
                    "bProcessing": true,
                    "deferRender": true,
                    "bDeferRender": true,
                    dom:"<'row'<'col-sm-6 text-left material_filter'><'col-sm-6 text-right'f>>\n\t\t\t<'row'<'col-sm-12'tr>>\n\t\t\t<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 dataTables_pager'lp>>", // horizobtal scrollable datatable
                    "lengthMenu": [
                      [25, 50, 100, -1],
                      [25, 50, 100, "All"] // change per page values here
                    ],
                    "columnDefs": [
                      {
                        "targets": [ 1,2,3,4,12,13,14,15,16,17,18,19,20,21,22 ],
                        className: "hidden"
                      }
                    ],
                    'paging': false,
                    'order': false
                  });
                  $(".hide_column").hide();
                  $(".hidden").hide();
                  $('<div class="form-group m-form__group row" >'+
                  '<div class="col-lg-6"><div class="m-select2 m-select2--air m-select2--pill">'+
                  '<select style="width: 100%" class="form-control m-select2 table_filter" id="material_filter"  name="material_filter" >'+
                  '<option value="all">All Materials</option>'+
                  <?php
                  foreach($materials as $row): ?>
                  '<option value="<?php echo $row->material_id?>"><?php echo $row->material_name.' [ in '.$row->unit_name.']';?></option>'+
                  <?php
                endforeach;
                ?>
                '</select></div></div></div>').appendTo("#stock_list_table_wrapper .material_filter");
                $("#material_filter").select2({
                  // dropdownParent: $("#form_purchase_add"),
                  placeholder: "Select Material"
                })

                $(".table_filter").on("change", function() {
                  table.ajax.reload();
                });
              }

              var item_table=function() {
                // var table = $('#table_items').DataTable({
                //   "scrollX": true,
                //   bFilter: false,
                //   "bLengthChange": false,
                //   "bPaginate": false,
                //   "dom": "<'row' <'col-md-12'>><'row'<'col-md-6 col-sm-12'l><'col-md-6 col-sm-12'f>r><'table-scrollable't><'row'<'col-md-5 col-sm-12'i><'col-md-7 col-sm-12'p>>", // horizobtal scrollable datatable
                //   "lengthMenu": [
                //     [25, 50, 100, -1],
                //     [25, 50, 100, "All"] // change per page values here
                //   ],
                //   'ordering': false
                // });
                // $(".hidden").hide();
              }
              $('body').on('click', '#btn_transfer_cart', function() {
                var no = $(this).closest('tr').children('td');
                var stock_id = no.eq(1).text();
                var material_name = no.eq(5).text();
                var material_id = no.eq(2).text();
                var unit_name = no.eq(6).text();
                var unit_price = no.eq(7).text();
                var supplier = no.eq(9).text();
                var available_qty = no.eq(10).text();
                //      Check Already Added to Cart
                var already_added=0;
                $(".items_stock_id").each(function(){
                  if($(this).val()==stock_id){
                    already_added=1;
                  }
                });
                var sale_price = unit_price;
                if(already_added==0){
                  $.post("<?php echo base_url() ?>material/select_details",{id:material_id},function(data) {
                    var obj = $.parseJSON(data);
                    var i=0;
                    if(obj.count==1) {
                      <?php if ($this->config->item('Material_sale_price_category_enable') == 1){ ?>
                        sale_price = obj.data['sale_price'+$("#sale_price_category").val()];
                        <?php }else{?>
                          sale_price = obj.data['material_unit_price'];
                          <?php } ?>
                          // $('#table_items').dataTable().fnDestroy();
                          var counter = parseInt($("#current_row_count").val());
                          var actual_row_count = parseInt($("#actual_row_count").val());

                          var newRow = '<tr class="row_'+counter+'">';
                          newRow += '<td><div class="form-group m-form__group" style="padding: 0px !important;margin: 0px !important;"><div class="input-group m-input-group m-input-group--pill m-input-group--air"><input style="padding: 10px" readonly type="text" class="form-control m-input item_slno" data-sl-no="' + (counter+1) + '" name="item[sl_no]['+(counter)+']" value="' + (actual_row_count+1) + '"/></div></div></td>';
                          newRow += '<td><div class="form-group m-form__group" style="padding: 0px !important;margin: 0px !important;"><div class="input-group m-input-group m-input-group--pill m-input-group--air">';
                          // newRow += '<input type="text" readonly class="form-control m-input" name="item[material_name]['+(counter)+']" value="'+obj.name[0]+'" id="material_name_' + (counter+1) + '"/></div>';
                          newRow += "<input type='text' readonly class='form-control m-input' name='item[material_name]["+(counter)+"]' value='"+obj.data['material_name']+"' id='material_name_" + (counter+1) + "'/></div>";

                          newRow += '<input type="hidden" name="item[stock_id]['+(counter)+']" value="'+stock_id+'" id="stock_id_' + (counter+1) + '" class="items_stock_id"/>';
                          newRow += '</div></td>';
                          newRow += '<td><div class="form-group m-form__group" style="padding: 0px !important;margin: 0px !important;"><div class="input-group m-input-group m-input-group--pill m-input-group--air">';
                          newRow += '<input type="text" readonly class="form-control m-input" value="'+unit_name+'" name="item[unit_name]['+(counter)+']" id="unit_name_' + (counter+1) + '"/></div>';
                          newRow += '</div></td>';
                          newRow += '<td style="display:none"><div class="form-group m-form__group" style="padding: 0px;margin: 0px;"><div class="input-group m-input-group m-input-group--pill m-input-group--air "><input type="text" readonly class="form-control m-input quantity" data-sl-no="' + (counter+1) + '" value="'+unit_price+'" name="item[unit_cost]['+(counter)+']" id="unit_cost_' + (counter+1) + '"/></div></div></td>';
                          newRow += '<td><div class="form-group m-form__group" style="padding: 0px !important;margin: 0px !important;"><div class="input-group m-input-group m-input-group--pill m-input-group--air"><input type="text" required class="form-control m-input numeric_fields  item_rate_fields unit_price_field" value="'+sale_price+'"  data-sl-no="' + (counter+1) + '" name="item[unit_price]['+(counter)+']" id="unit_price_' + (counter+1) + '"/></div></div></td>';
                          newRow += '<td style="display:none"><div class="form-group m-form__group" style="padding: 0px !important;margin: 0px !important;"><div class="input-group m-input-group m-input-group--pill m-input-group--air"><input type="text" required class="form-control m-input"  value="'+available_qty+'" data-sl-no="' + (counter+1) + '" name="item[available_qty]['+(counter)+']" id="available_qty_' + (counter+1) + '"/></div></div></td>';
                          newRow += '<td><div class="form-group m-form__group" style="padding: 0px !important;margin: 0px !important;"><div class="input-group m-input-group m-input-group--pill m-input-group--air"><input type="text" required class="form-control m-input numeric_fields item_rate_fields quantity_field" max="'+available_qty+'" value="1" data-sl-no="' + (counter+1) + '" name="item[quantity]['+(counter)+']" id="quantity_' + (counter+1) + '"/></div></div></td>';
                          newRow += '<td><div class="form-group m-form__group" style="padding: 0px !important;margin: 0px !important;"><div class="input-group m-input-group m-input-group--pill m-input-group--air"><input type="text" required class="form-control m-input item_disc_amount item_rate_fields" value="0" data-sl-no="' + (counter+1) + '" name="item[disc_amount]['+(counter)+']" id="disc_amount_' + (counter+1) + '"/></div></div></td>';
                          newRow += '<td><div class="form-group m-form__group" style="padding: 0px !important;margin: 0px !important;"><div class="input-group m-input-group m-input-group--pill m-input-group--air"><input type="text" readonly class="form-control m-input item_taxable_amount" value="'+sale_price+'" data-sl-no="' + (counter+1) + '" name="item[taxable_amount]['+(counter)+']" id="taxable_amount_' + (counter+1) + '"/></div></div></td>';

                          <?php
                          $tax_percent = $this->config->item('Tax_tax_percent'); ?>
                          newRow += '<td><div class="form-group m-form__group" style="padding: 0px !important;margin: 0px !important;"><select class="form-control m-bootstrap-select m-bootstrap-select--air m-bootstrap-select--pill m_selectpicker item_tax_percent item_rate_fields" data-sl-no="' + (counter+1) + '" name="item[tax_percent]['+(counter)+']" id="tax_percent_' + (counter+1) + '" title="Tax %">';
                          <?php
                          $tax_percent = $this->config->item('Tax_tax_percent');
                          foreach($tax_percent as $row){
                            $selected_tax='';
                            if($row->tax_percentage==0){
                              $selected_tax='selected';
                            }
                            ?>
                            newRow += '<option <?php echo $selected_tax?> data-tax-percent="<?php echo $row->tax_percentage?>" value="<?php echo $row->tax_id?>"><?php echo $row->tax_name?></option>';
                            <?php } ?>
                            newRow += '</select></div><input type="hidden" value="0" data-sl-no="' + (counter+1) + '" name="item[tax_percentage]['+(counter)+']" id="tax_percentage_' + (counter+1) + '"></td>';
                            newRow += '<td><div class="form-group m-form__group" style="padding: 0px !important;margin: 0px !important;"><div class="input-group m-input-group m-input-group--pill m-input-group--air"><input type="text" readonly class="form-control m-input item_tax_amount" value="0" data-sl-no="' + (counter+1) + '" name="item[tax_amount]['+(counter)+']" id="tax_amount_' + (counter+1) + '"/></div></div></td>';

                            newRow += '<td><div class="form-group m-form__group" style="padding: 0px;margin: 0px;"><div class="input-group m-input-group m-input-group--pill m-input-group--air"><input type="text" readonly class="form-control m-input item_total_amount" value="'+sale_price+'" name="item[total_amount]['+(counter)+']" id="total_amount_' + (counter+1) + '"/></div></div></td>';
                            newRow += '<td><a href="javascript:" data-row-sl-no='+counter+' class="ibtnDel btn btn-sm btn-danger btn-icon-only m-btn--pill" ><i class="fa fa-trash"></i></td>';
                            newRow += '</tr>';

                            newRow += '<tr class="row_'+counter+'">';
                            newRow += '<td></td>';
                            newRow += '<td><div class="form-group m-form__group" style="padding: 0px !important;margin: 0px !important;"><div class="input-group m-input-group m-input-group--pill m-input-group--air"><input placeholder="Item Code" type="text" class="form-control m-input" data-sl-no="' + (counter+1) + '" name="item[item_code]['+(counter)+']" value="'+obj.data['item_code']+'" id="item_code_' + (counter+1) + '"/></div></div></td>';
                            newRow += '<td style="display:none"></td>';
                            newRow += '<td style="display:none"></td>';
                            newRow += '<td colspan="8"><div class="form-group m-form__group" style="padding: 0px !important;margin: 0px !important;"><div class="input-group m-input-group m-input-group--pill m-input-group--air"><input placeholder="Description Here" type="text" class="form-control m-input" data-sl-no="' + (counter+1) + '" name="item[description]['+(counter)+']" id="description_' + (counter+1) + '"/></div></div></td>';
                            newRow += '<td></td>';
                            newRow += '</tr>';
                            <?php if ($this->config->item('app_module_production') == 1 ){?>
                              newRow += '<tr class="row_'+counter+'">';
                              newRow += '<td></td>';
                              newRow += '<td></td>';
                              newRow += '<td style="display:none"></td>';
                              newRow += '<td style="display:none"></td>';
                              newRow += '<td colspan="2"><div class="form-group m-form__group" style="padding: 0px !important;margin: 0px !important;"><label>Loading Charge:</label><div class="input-group m-input-group m-input-group--pill m-input-group--air"><input placeholder="Description Here" type="text" value="0" class="form-control m-input numeric_fields" data-sl-no="' + (counter+1) + '" name="item[loading_charge]['+(counter)+']" id="loading_charge_' + (counter+1) + '"/></div></div></td>';
                              newRow += '<td colspan="2"><div class="form-group m-form__group" style="padding: 0px !important;margin: 0px !important;"><label>Unloading Charge:</label><div class="input-group m-input-group m-input-group--pill m-input-group--air"><input placeholder="Description Here" type="text" value="0" class="form-control m-input numeric_fields" data-sl-no="' + (counter+1) + '" name="item[unloading_charge]['+(counter)+']" id="unloading_charge_' + (counter+1) + '"/></div></div></td>';
                              newRow += '<td colspan="4"></td>';
                              newRow += '<td></td>';
                              newRow += '</tr>';
                              <?php } ?>


                            $("#table_body").append(newRow);
                            counter++;
                            actual_row_count++;
                            $("#current_row_count").val(counter);
                            $("#actual_row_count").val(actual_row_count);
                            $(".m_selectpicker").selectpicker();
                            $('.m_selectpicker').selectpicker('refresh');

                            item_table();
                            calculate_summary();
                            toastr["info"]("Item Added to Cart", "Added to Cart");
                          }else{
                            toastr["warning"]("Item Details Not Found", "Not Found");
                          }
                        })


                      }else{
                        toastr["warning"]("Item Already Added to Cart", "Already Added");
                      }

                    });
                    $("#table_body").on("click", ".ibtnDel", function (event) {
                      var row_sl_no = $(this).data('row-sl-no');
                      var counter = parseInt($("#actual_row_count").val());
                      $('.row_'+row_sl_no).remove();
                      counter -= 1;
                      $("#actual_row_count").val(counter);

                      //rearrange higher sl no
                      var new_sl_no = 0;
                      $(".item_slno").each(function () {
                        new_sl_no++;
                        $(this).val(new_sl_no);
                      })
                    });
                    function calculate_item_total(sl_no){
                      var unit_price = ($("#unit_price_"+sl_no).val()=='') ? 0 : parseFloat($("#unit_price_"+sl_no).val());
                      var quantity = ($("#quantity_"+sl_no).val()=='') ? 0 : parseFloat($("#quantity_"+sl_no).val());
                      var discount_amount = ($("#disc_amount_"+sl_no).val()=='') ? 0 : parseFloat($("#disc_amount_"+sl_no).val());
                      var taxable_amount = parseFloat((quantity*unit_price)-discount_amount);
                      var tax_amount = 0;
                      var tax_percent = parseFloat($("#tax_percent_"+sl_no+" :selected").data('tax-percent'));
                      var tax_amount = parseFloat((taxable_amount*tax_percent)/100);
                      $("#tax_percentage_"+sl_no).val(tax_percent.toFixed(<?php echo $this->config->item('Currency_amount_decimals_2')?>));
                      $("#taxable_amount_"+sl_no).val(taxable_amount.toFixed(<?php echo $this->config->item('Currency_amount_decimals_2')?>));
                      $("#tax_amount_"+sl_no).val(tax_amount.toFixed(<?php echo $this->config->item('Currency_amount_decimals_2')?>));
                      var net_total = (parseFloat(taxable_amount)+parseFloat(tax_amount));
                      $("#total_amount_"+sl_no).val(net_total.toFixed(<?php echo $this->config->item('Currency_amount_decimals_2')?>));

                      calculate_summary();
                    }

                    $('body').on('change keyup', '.item_rate_fields', function() {
                      var sl_no = $(this).attr('data-sl-no');
                      calculate_item_total(sl_no);
                    })
                    $('body').on('change keyup', '.bill_inputs', function() {
                      calculate_summary();
                    })
                    $('body').on('change keyup', '#received_amount', function() {
                      var paid_amount = $(this).val();
                      if(paid_amount>0){
                        $(".received_date_div").show();
                        $("#received_date,#credit_acc").attr('required',true);
                      }else{
                        $(".received_date_div").hide();
                        $("#received_date,#credit_acc").removeAttr('required',true);
                      }
                      $("#purchase_date,#received_date").datepicker( {
                        todayHighlight:!0, orientation:"bottom left", templates: {
                          leftArrow: '<i class="la la-angle-left"></i>', rightArrow: '<i class="la la-angle-right"></i>'
                        }
                      })
                    })
                    function calculate_summary(){
                      var total_items = bill_item_total_amount = bill_discount_amount = bill_taxable_amount = bill_tax_amount = bill_round_amount = 0;
                      $(".item_total_amount").each(function(){
                        bill_item_total_amount += +$(this).val();
                      });
                      $(".item_disc_amount").each(function(){
                        bill_discount_amount += +parseFloat($(this).val());
                      });
                      $(".item_taxable_amount").each(function(){
                        bill_taxable_amount += +parseFloat($(this).val());
                      });
                      $(".item_tax_amount").each(function(){
                        bill_tax_amount += +parseFloat($(this).val());
                      });
                      $("#bill_tax_amount").val(bill_tax_amount.toFixed(<?php echo $this->config->item('Currency_amount_decimals_2')?>));
                      $("#bill_net_total_amount").val(bill_taxable_amount.toFixed(<?php echo $this->config->item('Currency_amount_decimals_2')?>));
                      var bill_grand_total = parseFloat(bill_taxable_amount+bill_tax_amount);
                      $("#bill_grand_total").val(bill_grand_total.toFixed(<?php echo $this->config->item('Currency_amount_decimals_2')?>));
                      bill_round_amount = ($("#bill_round_amount").val()=='') ? 0 : parseFloat($("#bill_round_amount").val());
                      var bill_receivable_amount = parseFloat(bill_grand_total-bill_round_amount);
                      $("#bill_receivable_amount").val(bill_receivable_amount.toFixed(<?php echo $this->config->item('Currency_amount_decimals_2')?>));

                      $("#received_amount").attr('max',Math.ceil(bill_receivable_amount));
                      var received_amount = ($("#received_amount").val()=='') ? 0 : parseFloat($("#received_amount").val());
                      $("#total_received").val(received_amount.toFixed(<?php echo $this->config->item('Currency_amount_decimals_2')?>));
                      var balance_amount = (bill_receivable_amount-received_amount);
                      $("#balance_amount").val(balance_amount.toFixed(<?php echo $this->config->item('Currency_amount_decimals_2')?>));

                    }

                    $(".form_submit_btn").click(function (e) {
                      e.preventDefault();
                      var a = $(this),
                      l = $(this).closest("form"),
                      action = l.attr('action');
                      var form_id = l.attr('id');
                      var items_count = $("#current_row_count").val();
                      var items_count_error =0;
                      if(form_id=='form_items_add' && items_count==0){
                        items_count_error = 1;
                      }
                      if(items_count_error==0){
                        l.validate({
                          rules: {
                            quantity: {
                              number: !0
                            },
                            mobile_number: {
                              required: !0,
                              number: !0,
                              minlength: 8,
                              maxlength: 12
                            }
                          }, invalidHandler: function (e, r) {
                            var i = $("#" + form_id + "_msg");
                            i.removeClass("m--hide").show(), mUtil.scrollTo(i, -200)
                          }, submitHandler: function (e) {
                          }
                        }),
                        $(".numeric_fields").each(function () {
                          $(this).rules('add', {
                            number: !0
                          });
                        }), l.valid() && (a.addClass("m-loader m-loader--right m-loader--light").attr("disabled", !0),
                        l.ajaxSubmit({
                          url: action,
                          success: function (e, t, r, s) {
                            var modal_id = l.attr('data-modal-id');
                            var form_type = l.attr('data-form-type');
                            $("#" + form_id + "_msg").addClass("m--hide");
                            // Block UI
                            mApp.blockPage({
                              overlayColor: "#000000",
                              type: "loader",
                              state: "success",
                              message: "Please wait..."
                            }), setTimeout(function () {
                              mApp.unblockPage()
                            }, 2e3);
                            var obj = $.parseJSON(e);
                            if (obj.status == 1) {
                              a.removeClass("m-loader m-loader--right m-loader--light").attr("disabled", !1);
                              $("#"+modal_id).modal('toggle');
                              $("."+form_id+"_fields").val('');
                              $("."+form_id+"_select").val('').trigger("change");
                              toastr[obj.flashdata_type](obj.flashdata_msg, obj.flashdata_title);
                              if(form_id=='form_items_add'){
                                swal({
                                  width: 500,
                                  title: obj.flashdata_title,
                                  text: obj.flashdata_msg,
                                  type: obj.flashdata_type,
                                  showCancelButton: !0,
                                  confirmButtonText: "View All Sales Invoices",
                                  cancelButtonText: "Add New Invoice",
                                  confirmButtonColor: '#3085d6',
                                  cancelButtonColor: '#d33',
                                  reverseButtons: !0,
                                  closeOnClickOutside: false,
                                  allowOutsideClick: false,
                                  html: "<br>" +
                                  '<a href="<?php echo base_url()?>sales_invoice/invoice/'+obj.invoice_id+'"  class="SwalBtn1  btn btn-primary m-btn m-btn--custom customSwalBtn">' + 'View Invoice' + '</button>'
                                }).then(function(e) {
                                  e.value ? window.location.replace("<?php echo base_url()?>sales_invoice/") : "cancel" === e.dismiss && location.reload()
                                })
                              }else{
                                select_customer();
                              }

                            } else {
                              a.removeClass("m-loader m-loader--right m-loader--light").attr("disabled", !1);
                              toastr[obj.flashdata_type](obj.flashdata_msg, obj.flashdata_title);
                            }
                            if (obj == null) {
                              setTimeout(function () {
                                a.removeClass("m-loader m-loader--right m-loader--light").attr("disabled", !1);
                                toastr["warning"]("Your Attempt is Timed Out. Please Try Again.", "Timed Out");
                              }, 2e4)
                            }
                          },error: function() {
                            a.removeClass("m-loader m-loader--right m-loader--light").attr("disabled", !1);
                            toastr["error"]("Sorry. There Has Been Some Error Occurred. Please Try Again.", "Error");
                          }
                        })
                      )
                    }else{
                      toastr["warning"]("Please Add Items to Cart", "Cart Empty");
                    }

                  });
                  </script>
