<?php $this->view("includes/Inc_pagehead");?>
<!-- Page Styles Goes Here-->

<?php $this->view("includes/Inc_navigation");?>
<div class="m-grid__item m-grid__item--fluid m-wrapper">
  <!-- BEGIN: Subheader -->
  <div class="m-subheader ">
    <div class="d-flex align-items-center">
      <div class="mr-auto">
        <h3 class="m-subheader__title m-subheader__title--separator">
          Trial Balance
        </h3>
        <ul class="m-subheader__breadcrumbs m-nav m-nav--inline">
          <li class="m-nav__item m-nav__item--home">
            <a href="#" class="m-nav__link m-nav__link--icon">
              <i class="m-nav__link-icon la la-home"></i>
            </a>
          </li>
          <li class="m-nav__separator">
            -
          </li>
          <li class="m-nav__item">
            <a href="<?php echo base_url().'dashboard'?>" class="m-nav__link">
              <span class="m-nav__link-text">
                Home
              </span>
            </a>
          </li>
          <li class="m-nav__separator">
            -
          </li>
          <li class="m-nav__item">
            <a href="<?php echo base_url().'reports/trial_balance' ?>" class="m-nav__link">
              <span class="m-nav__link-text">
                Trial Balance
              </span>
            </a>
          </li>


        </ul>
      </div>
      <div>

      </div>
    </div>
  </div>
  <!-- END: Subheader -->
  <div class="m-content">
    <div class="m-portlet  m-portlet--rounded m-portlet--bordered">
      <div class="m-portlet__body" style="padding: 1rem 2.2rem;">
        <div class="m-form m-form--label-align-right m--margin-bottom-10">
          <div class="row ">
            <div class="col-xl-12 order-2 order-xl-1">
              <div class="form-group m-form__group row">
                <div class="col-md-8">
                  <div class="form-group m-form__group">
                    <label> Date:</label>
                    <div class="input-group m-input-group--air m-input-group--pill date">
                      <div class="input-group-prepend">
                        <span class="input-group-text">
                          <i class="la la-calendar"></i>
                        </span>
                      </div>
                      <input value="<?php echo date('d-m-Y')?>"  data-date-format="dd-mm-yyyy" name="date" autocomplete="off" id="date" required type="text" class="form-control form_client_payment_add_fields m-input " placeholder="Date" >
                    </div>
                  </div>
                </div>
                <div class="col-md-4">
                  <br/>
                  <button style="margin-top: 7px" id="btn_go" class="btn btn-focus m-btn m-btn--custom m-btn--icon m-btn--air m-btn--pill">
                    <span>
                      <i class="la la-search"></i>
                      <span>
                        Go
                      </span>
                    </span>
                  </button>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>

    <div style="display: none" id="trial_balance_div" class="m-portlet m-portlet--mobile m-portlet--info m-portlet--head-solid-bg m-portlet--bordered m-portlet--rounded">
      <div class="m-portlet__head">
        <div class="m-portlet__head-caption">
          <div class="m-portlet__head-title">
            <h3 class="m-portlet__head-text">
              Trial Balance
            </h3>
          </div>
        </div>
        <div class="m-portlet__head-tools">

        </div>
      </div>
      <div class="m-portlet__body">
        <!--begin: Datatable -->
        <table width="100%" class="table m-table nowrap table-header-fixed table-striped table-bordered table-hover table-header-fixed" id="trial_balance_view_table">
          <thead>
            <tr class="">
              <th>Account</th>
              <th>Debit</th>
              <th>Credit</th>
            </tr>
          </thead>
          <tbody id="trial_balance_view_table_body">
          </tbody>
        </table>
        <!--end: Datatable -->

      </div>
    </div>


  </div>
</div>
</div>
<!-- end:: Body -->
<!-- begin::Footer -->

<?php $this->view("includes/Inc_footer");?>
<!-- end::Footer -->
</div>
<!-- end:: Page -->

<?php $this->view("includes/Inc_sidebar");?>
<?php $this->view("includes/Inc_scripts");?>

<!--begin::Page Snippets -->
<script>
$("#report_menu").addClass('m-menu__item--active m-menu__item--open');
$("#report_menu_4").addClass('m-menu__item--active');
$("#date").datepicker( {
  todayHighlight:!0, orientation:"bottom left", templates: {
    leftArrow: '<i class="la la-angle-left"></i>', rightArrow: '<i class="la la-angle-right"></i>'
  }
})

$('body').on('click', '#btn_go', function() {
  $("#trial_balance_div").show();
  trial_balance_table();
})

var trial_balance_table=function() {
  $('#trial_balance_view_table').dataTable().fnDestroy();
  function GetSearchDate(){
    return $('#date').val();
  }
  $('.table_caption').html("");
  $('#trial_balance_view_table').append('<caption class="table_caption" style="caption-side: top !important;text-align: center"><strong>Trial Balance '+GetSearchDate()+'</strong></caption>');

  $.post("<?php echo base_url() ?>reports/select_trial_balance_old",{date:GetSearchDate()},function(data) {
    $('#trial_balance_view_table_body').html("");
    var obj = $.parseJSON(data);
    var i=0;
    if(obj.count==1) {
      $('#trial_balance_view_table_body').append(obj.table_body);
    }
    var table = $('#trial_balance_view_table').DataTable({
      // "ajax":{
      //     url :"<?php echo base_url().'reports/select_trial_balance' ?>", // json datasource
      //     type: "post", // type of method  , by default would be get
      //     data: function(d){
      //         d.date = GetSearchDate();
      //     }
      // },
      // "bProcessing": true,
      // "deferRender": true,
      // "bDeferRender": true,
      "scrollX" : true,
      buttons: [
        { extend: 'print', className: 'btn dark btn-outline',exportOptions: {columns: ':visible'},title: 'Trial Balance' },
        { extend: 'csv', className: 'btn purple btn-outline ' },
        { extend: 'colvis', className: 'btn dark btn-outline', text: 'Columns'}
      ],
      dom:"<'row'<'col-sm-6 text-left'B><'col-sm-6 text-right'f>>\n\t\t\t<'row'<'col-sm-12'tr>>\n\t\t\t<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 dataTables_pager'lp>>", // horizobtal scrollable datatable
      "lengthMenu": [
        [25, 50, 100, -1],
        [25, 50, 100, "All"] // change per page values here
      ],
      // set the initial value
      "paginate": false,
      "columnDefs": [
        {
          "targets": [  ],
          className: "hidden"
        }
      ],
      'ordering': false
    });
    $(".hide_column").hide();
  })



}

jQuery(document).ready(function() {
  $(".hidden").hide();

});
</script>
