<?php $this->view("includes/Inc_pagehead");?>
<!-- Page Styles Goes Here-->
<style>
.m-input{
  border: 1px solid #ebedf2 !important;
  background-color: #f4f5f833 !important;
}
#payment_view_table .dataTables_scrollHeadInner {
  width:100% !important;
  padding: 0 !important;
}


</style>


<?php $this->view("includes/Inc_navigation");?>
<div class="m-grid__item m-grid__item--fluid m-wrapper">
  <!-- BEGIN: Subheader -->
  <div class="m-subheader ">
    <div class="d-flex align-items-center">
      <div class="mr-auto">
        <h3 class="m-subheader__title m-subheader__title--separator">
          <strong>Reports</strong>
        </h3>
      </div>
    </div>
  </div>
  <div class="m-content">
    <div class="row">
      <div class="col-xl-3 col-lg-4">
        <div class="m-portlet m-portlet--full-height  ">
          <div class="m-portlet__body">
            <div class="m-card-profile">
              <div class="m-card-profile__title m--hide">
                Transaction Reports
              </div>
              <div class="m-card-profile__pic">
                <div class="m-card-profile__pic-wrapper">
                  <img src="<?php echo $this->config->item('Template_template_file_url'); ?>template/assets/app/media/img/misc/transaction.png" alt=""/>
                </div>
              </div>
              <div class="m-card-profile__details">
                <span class="m-card-profile__name">
                  Transaction Reports
                </span>
              </div>
              <br/>
            </div>
            <ul class="m-nav m-nav--hover-bg m-portlet-fit--sides">
              <li class="m-nav__separator m-nav__separator--fit"></li>
              <li class="m-nav__section m--hide">
                <span class="m-nav__section-text">
                  Section
                </span>
              </li>
              <li class="m-nav__item profile_nav" id="nav_overview" data-nav="overview" data-table-no=''>
                <a href="javascript:;" class="m-nav__link">
                  <i class="m-nav__link-icon fa fa-bars"></i>
                  <span class="m-nav__link-text">
                    Overview
                  </span>
                </a>
              </li>
              <?php if($this->session->userdata('user_role')!='supervisor'){?>
                <li class="m-nav__item profile_nav" id="nav_client" data-nav="client" data-table-no='1'>
                  <a href="javascript:;" class="m-nav__link">
                    <i class="m-nav__link-icon fa fa-briefcase"></i>
                    <span class="m-nav__link-text">
                      Client Payments Received
                    </span>
                  </a>
                </li>
              <?php } ?>
              <?php if($this->config->item('app_module_user_payments')==1){?>
                <li class="m-nav__item profile_nav" id="nav_user_payments_received" data-nav="user_payments_received" data-table-no='9'>
                  <a href="javascript:;" class="m-nav__link">
                    <i class="m-nav__link-icon fa fa-money-bill-alt"></i>
                    <span class="m-nav__link-text">
                      User Payments Received
                    </span>
                  </a>
                </li>
                <li class="m-nav__item profile_nav" id="nav_user_payments_released" data-nav="user_payments_released" data-table-no='9'>
                  <a href="javascript:;" class="m-nav__link">
                    <i class="m-nav__link-icon fa fa-money-bill-alt"></i>
                    <span class="m-nav__link-text">
                      User Payments Released
                    </span>
                  </a>
                </li>
              <?php } ?>
              <?php if($this->config->item('app_module_purchase_order')==1){?>
                <li class="m-nav__item profile_nav" id="nav_purchase_order" data-nav="purchase_order" data-table-no='8'>
                  <a href="javascript:;" class="m-nav__link">
                    <i class="m-nav__link-icon fa fa-money-bill"></i>
                    <span class="m-nav__link-text">
                      Purchase Order Payments
                    </span>
                  </a>
                </li>
              <?php } ?>
              <li class="m-nav__item profile_nav" id="nav_purchase" data-nav="purchase" data-table-no='2'>
                <a href="javascript:;" class="m-nav__link">
                  <i class="m-nav__link-icon fa fa-money-bill"></i>
                  <span class="m-nav__link-text">
                    Purchase Bill Payments
                  </span>
                </a>
              </li>
              <li class="m-nav__item profile_nav" id="nav_labour_payments" data-nav="labour_payments" data-table-no='4'>
                <a href="javascript:;" class="m-nav__link">
                  <i class="m-nav__link-icon fa fa-users"></i>
                  <span class="m-nav__link-text">
                    Labour Wage Payments Made
                  </span>
                </a>
              </li>
              <li class="m-nav__item profile_nav" id="nav_expenses_work" data-nav="expenses_work" data-table-no='4'>
                <a href="javascript:;" class="m-nav__link">
                  <i class="m-nav__link-icon fa fa-clipboard-list"></i>
                  <span class="m-nav__link-text">
                    Work Expenses Made
                  </span>
                </a>
              </li>
              <?php   if($this->session->userdata('user_role')!='supervisor'){ ?>
                <li class="m-nav__item profile_nav" id="nav_expenses_office" data-nav="expenses_office" data-table-no='4'>
                  <a href="javascript:;" class="m-nav__link">
                    <i class="m-nav__link-icon fa fa-clipboard-list"></i>
                    <span class="m-nav__link-text">
                      Office Expenses Made
                    </span>
                  </a>
                </li>
              <?php } ?>
              <li class="m-nav__item profile_nav" id="nav_subcontract" data-nav="subcontract" data-table-no='5,6'>
                <a href="javascript:;" class="m-nav__link">
                  <i class="m-nav__link-icon fa fa-money-check-alt"></i>
                  <span class="m-nav__link-text">
                    Subcontract Payments Made
                  </span>
                </a>
              </li>

            </ul>
            <br/>
          </div>
        </div>
      </div>
      <div class="col-xl-9 col-lg-8" >
        <div class="m-portlet">
          <form autocomplete="off" id="payment_details_form" method="post"  enctype="multipart/form-data" class="m-form m-form--fit m-form--state m-form--label-align-right ">
            <div class="m-portlet__body">
              <div class="row">
                <div class="col-md-4" >
                  <div class="form-group m-form__group">
                    <label class="col-form-label">
                      Date :
                    </label>
                    <input style="border: none" id="table_filter_date_range"  type="text" class="form-control table_filter  m-input--solid m-input " >
                  </div>
                </div>
                <div class="col-md-3" >
                  <div class="form-group m-form__group">
                    <label class="col-form-label">
                      Work
                    </label>
                    <select style="width: 100%" class="form-control m-select2 table_filter" id="work1"  name="work1" data-placeholder="Select Work">
                      <option selected value="all">All Works</option>
                      <?php
                      foreach($work_contracts as $row): ?>
                      <option data-work-status="<?php echo $row->work_status?>" value="<?php echo $row->work_id?>"><?php echo $row->work_name?></option>
                      <?php
                    endforeach;
                    ?>
                  </select>
                  <span class="m-form__help"></span>
                </div>
              </div>
              <?php   if($this->session->userdata('user_role')=='admin'){ ?>
                <div class="col-md-3" >
                  <div class="form-group m-form__group">
                    <label class="col-form-label">
                      User
                    </label>
                    <select style="width: 100%" class="form-control m-select2 table_filter" id="user"  name="user" data-placeholder="Select Work">
                      <option selected value="all">All Users</option>
                      <?php
                      foreach($users as $row): ?>
                      <option value="<?php echo $row->user_id?>"><?php echo $row->user_alias?></option>
                      <?php
                    endforeach;
                    ?>
                  </select>
                  <span class="m-form__help"></span>
                </div>
              </div>
            <?php } ?>

          </div>
        </div>
      </form>
    </div>


    <div id="div_overview" class="m-portlet m-portlet--metal m-portlet--head-solid-bg m-portlet--bordered profile_nav_div">
      <div class="m-portlet  m-portlet--rounded m-portlet--bordered">
        <div class="m-portlet__body">
          <h3 class="m-portlet__head-text" style="text-align: center">
            Transaction Summary
          </h3>
          <table width="100%" class="table m-table nowrap table-header-fixed table-striped table-bordered table-hover table-header-fixed" id="table_summary">
            <thead>
              <tr class="">
                <th>Heads</th>
                <th>Amount</th>
              </tr>
            </thead>
            <tbody>
              <tr>
                <td>Client Payment Received</td>
                <strong><td class="total_received_from_client_info"></td></strong>
              </tr>
              <tr>
                <td></td>
                <td></td>
              </tr>
              <?php if($this->config->item('app_module_purchase_order')==1){?>
                <tr>
                  <td>Purchase Order Payments Made (Advances)</td>
                  <strong><td class="total_purchase_order_payments_info"></td></strong>
                </tr>
              <?php } ?>
              <tr>
                <td>Purchase Bill Payments Made</td>
                <strong><td class="total_purchases_bill_payment_info"></td></strong>
              </tr>
              <tr>
                <td>Total Purchase Payments Made
                  <?php if($this->config->item('app_module_purchase_order')==1){?>
                    (Purchase Bill + Purchase Order)
                  <?php } ?>
                </td>
                <strong><td class="total_purchase_payment_info"></td></strong>
              </tr>

              <tr>
                <td></td>
                <td></td>
              </tr>
              <tr>
                <td>Total Subcontract Payments Made</td>
                <strong><td class="total_subcontract_payment_info"></td></strong>
              </tr>
              <tr>
                <td>Total Labour Wage Payments Made</td>
                <strong><td class="total_labour_wage_payments_info"></td></strong>
              </tr>
              <tr>
                <td>Total Other Work Expense Made</td>
                <strong><td class="total_other_expense_info"></td></strong>
              </tr>
              <?php   if($this->session->userdata('user_role')!='supervisor'){ ?>
                <tr>
                  <td>Total Office Expense Made</td>
                  <strong><td class="total_office_expense_info"></td></strong>
                </tr>
              <?php } ?>
              <tr>
                <td></td>
                <td></td>
              </tr>
              <tr>
                <td>Total Expenses Made</td>
                <strong><td class="total_expense_info"></td></strong>
              </tr>
              <tr>
                <td>Total Income Received</td>
                <strong><td class="total_received_from_client_info"></td></strong>
              </tr>
              <tr>
                <td>Cash Balance</td>
                <strong><td class="total_balance_info"></td></strong>
              </tr>
              <tr>
                <td></td>
                <td></td>
              </tr>
              <?php if($this->config->item('app_module_user_payments')==1){?>
                <tr>
                  <td>Total User Payments Released</td>
                  <strong><td class="total_user_payments_released_info"></td></strong>
                </tr>
                <tr>
                  <td>Total User Payments Received</td>
                  <strong><td class="total_user_payments_received_info"></td></strong>
                </tr>
              <?php } ?>
            </tbody>
          </table>
        </div>
      </div>
    </div>
    <div id="div_client" class="m-portlet m-portlet--metal m-portlet--head-solid-bg m-portlet--bordered profile_nav_div">
      <div class="m-portlet__head">
        <div class="m-portlet__head-caption">
          <div class="m-portlet__head-title">
            <span class="m-portlet__head-icon">
              <i class="fa fa-briefcase"></i>
            </span>
            <h3 class="m-portlet__head-text">
              Client Payment Details
            </h3>
          </div>
        </div>
        <div class="m-portlet__head-tools" style="display: none">

        </div>
      </div>
      <div class="m-portlet__body">
        <table width="100%" class="table m-table nowrap table-header-fixed table-striped table-bordered table-hover table-header-fixed" id="client_payments_view_table">
          <thead>
            <tr class="">
              <th>Sl No</th>
              <th>ID</th>
              <th>Receipt ID</th>
              <th>Received Date</th>
              <th>Client Name</th>
              <th>Work Name</th>
              <th>Received Payment</th>
              <th>Credited to Acc</th>
              <th>Receipt No</th>
              <th>Remarks</th>
              <th>Received By</th>
              <th>Created Date</th>
              <th>Actions</th>
              <th>Last Updated By</th>
              <th>Last Updated Date</th>
              <th>work id</th>
            </tr>
          </thead>
          <tbody>
          </tbody>
        </table>
      </div>
    </div>
    <div id="div_user_payments" class="m-portlet m-portlet--metal m-portlet--head-solid-bg m-portlet--bordered profile_nav_div">
      <div class="m-portlet__head">
        <div class="m-portlet__head-caption">
          <div class="m-portlet__head-title">
            <span class="m-portlet__head-icon">
              <i class="fa fa-briefcase"></i>
            </span>
            <h3 class="m-portlet__head-text">
              User Payments
            </h3>
          </div>
        </div>
        <div class="m-portlet__head-tools" style="display: none">

        </div>
      </div>
      <div class="m-portlet__body">
        <table width="100%" class="table m-table nowrap table-header-fixed table-striped table-bordered table-hover table-header-fixed" id="user_payment_receipts_view_table">
          <thead>
            <tr class="">
              <th>Sl No</th>
              <th>ID</th>
              <th>Receipt ID</th>
              <th>Received Date</th>
              <th>Received Amt</th>
              <th>Received User</th>
              <th>Remarks</th>
              <th>Paid By</th>
              <th>Created Date</th>

            </tr>
          </thead>
          <tbody>
          </tbody>
        </table>
      </div>
    </div>
    <div id="div_purchase_order" class="m-portlet m-portlet--metal m-portlet--head-solid-bg m-portlet--bordered profile_nav_div">
      <div class="m-portlet__head">
        <div class="m-portlet__head-caption">
          <div class="m-portlet__head-title">
            <span class="m-portlet__head-icon">
              <i class="fa fa-briefcase"></i>
            </span>
            <h3 class="m-portlet__head-text">
              Purchase Order Payments (Orders Those Haven't Purchase Bill Created)
            </h3>
          </div>
        </div>
        <div class="m-portlet__head-tools" style="display: none">

        </div>
      </div>
      <div class="m-portlet__body">
        <table width="100%" class="table m-table nowrap table-header-fixed table-striped table-bordered table-hover table-header-fixed" id="purchase_order_payments_table">
          <thead>
            <tr class="">
              <th>Sl No</th>
              <th>Payment ID</th>
              <th>Order ID</th>
              <th>Paid Date</th>
              <th>Supplier Name</th>
              <th>Order to Location</th>
              <th>Paid Amount</th>
              <th>Debit From Acc</th>
              <th>Created By</th>
              <th>Created Date</th>
              <th>View Order</th>
            </tr>
          </thead>
          <tbody>
          </tbody>
        </table>
      </div>
    </div>
    <div id="div_purchase" class="m-portlet m-portlet--metal m-portlet--head-solid-bg m-portlet--bordered profile_nav_div">
      <div class="m-portlet__head">
        <div class="m-portlet__head-caption">
          <div class="m-portlet__head-title">
            <span class="m-portlet__head-icon">
              <i class="fa fa-briefcase"></i>
            </span>
            <h3 class="m-portlet__head-text">
              Purchase Payments
            </h3>
          </div>
        </div>
        <div class="m-portlet__head-tools" style="display: none">

        </div>
      </div>
      <div class="m-portlet__body">
        <table width="100%" class="table m-table nowrap table-header-fixed table-striped table-bordered table-hover table-header-fixed" id="purchase_payments_table">
          <thead>
            <tr class="">
              <th>Sl No</th>
              <th>Purchase ID</th>
              <th>Paid Date</th>
              <th>Supplier Name</th>
              <th>Purchased to Location</th>
              <th>Paid Amount</th>
              <th>Debit Acc</th>
              <th>Remarks</th>
              <th>ID</th>
              <th>Created By</th>
              <th>Created Date</th>
              <th>View Bill</th>
            </tr>
          </thead>
          <tbody>
          </tbody>
        </table>
      </div>
    </div>
    <div id="div_material" class="m-portlet m-portlet--metal m-portlet--head-solid-bg m-portlet--bordered profile_nav_div">
      <div class="m-portlet__head">
        <div class="m-portlet__head-caption">
          <div class="m-portlet__head-title">
            <span class="m-portlet__head-icon">
              <i class="fa fa-briefcase"></i>
            </span>
            <h3 class="m-portlet__head-text">
              Purchased Materials
            </h3>
          </div>
        </div>
        <div class="m-portlet__head-tools" style="display: none">

        </div>
      </div>
      <div class="m-portlet__body">
        <table width="100%" class="table m-table nowrap table-header-fixed table-striped table-bordered table-hover table-header-fixed" id="purchase_materials_view_table">
          <thead>
            <tr class="">
              <th>Sl No</th>
              <th>Purchase ID</th>
              <th>Purchase Date</th>
              <th>Material Name</th>
              <th>Quantity</th>
              <th>Unit</th>
              <th>Total Amount</th>
              <th>Item Type</th>
              <th>Created By</th>
              <th>Created Date</th>
              <th>Work</th>
              <th>View Bill</th>
            </tr>
          </thead>
          <tbody>
          </tbody>
        </table>
      </div>
    </div>
    <div id="div_expenses" class="m-portlet m-portlet--metal m-portlet--head-solid-bg m-portlet--bordered profile_nav_div">
      <div class="m-portlet__head">
        <div class="m-portlet__head-caption">
          <div class="m-portlet__head-title">
            <span class="m-portlet__head-icon">
              <i class="fa fa-briefcase"></i>
            </span>
            <h3 class="m-portlet__head-text">
              Expenses
            </h3>
          </div>
        </div>
        <div class="m-portlet__head-tools" style="display: none">

        </div>
      </div>
      <div class="m-portlet__body">
        <table width="100%" class="table m-table nowrap table-header-fixed table-striped table-bordered table-hover table-header-fixed" id="expense_view_table">
          <thead>
            <tr class="">
              <th>Sl No</th>
              <th>Date</th>
              <th>Expense Type</th>
              <th>Expense Head</th>
              <th>Expense Amount</th>
              <th>Debit From Acc</th>
              <th>Remarks</th>
              <th>Work</th>
              <th>Created By</th>
              <th>Created Date</th>
              <th>ID</th>
              <th>Type</th>
              <th>Actions</th>
            </tr>
          </thead>
          <tbody>
          </tbody>
        </table>

      </div>
    </div>
    <div id="div_daily_report" class="m-portlet m-portlet--metal m-portlet--head-solid-bg m-portlet--bordered profile_nav_div">
      <div class="m-portlet__head">
        <div class="m-portlet__head-caption">
          <div class="m-portlet__head-title">
            <span class="m-portlet__head-icon">
              <i class="fa fa-briefcase"></i>
            </span>
            <h3 class="m-portlet__head-text">
              Daily Work Reports
            </h3>
          </div>
        </div>
        <div class="m-portlet__head-tools" style="display: none">

        </div>
      </div>
      <div class="m-portlet__body">
        <table width="100%" class="table m-table nowrap table-header-fixed table-striped table-bordered table-hover table-header-fixed" id="daily_report_view_table">
          <thead>
            <tr class="">
              <th>Sl No</th>
              <th>Activity ID</th>
              <th style="display:none">Work ID</th>
              <th>Task Title</th>
              <th>Work Name</th>
              <th>Activity Date</th>
              <th>Description</th>
              <th>Created By</th>
              <th>Created Date</th>
              <th>Action</th>
            </tr>
          </thead>
          <tbody>
          </tbody>
        </table>
      </div>
    </div>
    <div id="div_subcontract" class="m-portlet m-portlet--metal m-portlet--head-solid-bg m-portlet--bordered profile_nav_div">
      <div class="m-portlet__head">
        <div class="m-portlet__head-caption">
          <div class="m-portlet__head-title">
            <span class="m-portlet__head-icon">
              <i class="fa fa-briefcase"></i>
            </span>
            <h3 class="m-portlet__head-text">
              Subcontract Payments
            </h3>
          </div>
        </div>
        <div class="m-portlet__head-tools" style="display: none">

        </div>
      </div>
      <div class="m-portlet__body">
        <div class="m-portlet  m-portlet--rounded m-portlet--bordered">
          <div class="m-portlet__body">
            <table width="100%" class="table m-table nowrap table-header-fixed table-striped table-bordered table-hover table-header-fixed" id="subcontracts_payment_view_table">
              <thead>
                <tr class="">
                  <th>Sl No</th>
                  <th>Payment ID</th>
                  <th>Work</th>
                  <th>Work type</th>
                  <th>Subcontract Name</th>
                  <th>Contractor</th>
                  <th>Paid Amount</th>
                  <th>Paid Date</th>
                  <th>Debit From Acc</th>
                  <th>Remarks</th>
                  <th>Created By</th>
                  <th>Created Date</th>
                  <th>Actions</th>
                </tr>
              </thead>
              <tbody>
              </tbody>
            </table>
          </div>
        </div>
        <div class="m-portlet  m-portlet--rounded m-portlet--bordered">
          <div class="m-portlet__body">
            <table  width="100%" class="table m-table nowrap table-header-fixed table-striped table-bordered table-hover table-header-fixed" id="subcontracts_payment_by_type_view_table">
              <thead>
                <tr class="">
                  <th>Sl No</th>
                  <th>Work</th>
                  <th>Work type</th>
                  <th>Total Budget</th>
                  <th>Total Paid Amount</th>
                </tr>
              </thead>
              <tbody>
              </tbody>
            </table>
          </div>
        </div>
      </div>
    </div>

  </div>
</div>
</div>

</div>
</div>
<!-- end:: Body -->
<!-- begin::Footer -->
<?php $this->view("includes/Inc_footer");?>
<!-- end::Footer -->
</div>
<!-- end:: Page -->
<?php $this->view("includes/Inc_sidebar");?>
<?php $this->view("includes/Inc_scripts");?>


<!--begin::Page Snippets -->

<script>
$("#work1").select2({
  placeholder: "Select  Work",
  templateResult: format_project_dropdown
})
$("#user").select2({
  placeholder: "Select  User"
})
$("#m_aside_left_minimize_toggle").addClass("m-brand__toggler--active");
$("#body").addClass("m-brand--minimize m-aside-left--minimize");

$("#report_menu").addClass('m-menu__item--active m-menu__item--open');
$("#report_menu_2").addClass('m-menu__item--active');
</script>
<script>
function hide_all(){
  $(".profile_nav").removeClass('m-nav__item--active');
  $(".profile_nav_div").hide();
}
function active(menu_name){
  hide_all();
  $("#nav_"+menu_name).addClass('m-nav__item--active');
  $("#div_"+menu_name).show();
  $("#div_"+menu_name).fadeIn("slow");
  $('html, body').animate({
    scrollTop: eval($("#div_"+menu_name).offset().top - 150)
  }, 500);
}
//  Hide All Div and In Active All Menu
hide_all();
//  Active First Menu and Its div
active('overview');
$('body').on('click', '.profile_nav', function() {
  var nav = $(this).attr('data-nav');
  active(nav);
})
</script>
<script>

var Datatable=function() {
  var t=function() {

    function GetSearchDate(){
      return $('#table_filter_date_range').val();
    }
    function GetSearchWork(){
      return $('#work1').val();
    }
    function GetSearchUser(){
      return $('#user').val();
    }
    var table1 = $('#client_payments_view_table').DataTable({
      "ajax":{
        url :"<?php echo base_url().'client_payments/select_client_payments' ?>", // json datasource
        type: "post", // type of method  , by default would be get
        data: function(d){
          d.date = GetSearchDate();
          d.work = GetSearchWork();
        }
      },
      "bProcessing": true,
      "deferRender": true,
      "bDeferRender": true,
      scrollX:!0, scrollCollapse:!0,
      buttons: [
        { extend: 'print', className: 'btn dark btn-outline',exportOptions: {columns: ':visible'} },
        { extend: 'csv', className: 'btn purple btn-outline ' },
        { extend: 'colvis', className: 'btn dark btn-outline', text: 'Columns'}
      ],
      dom:"<'row'<'col-sm-6 text-left'B><'col-sm-6 text-right'f>>\n\t\t\t<'row'<'col-sm-12'tr>>\n\t\t\t<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 dataTables_pager'lp>>", // horizobtal scrollable datatable
      "lengthMenu": [
        [25, 50, 100, -1],
        [25, 50, 100, "All"] // change per page values here
      ],
      "columnDefs": [
        {
          "targets": [ 1,12,13,14,15 ],
          className: "hidden"
        }
      ],
      'order': false
    });
    var table2 = $('#purchase_payments_table').DataTable({
      "ajax":{
        url :"<?php echo base_url().'purchases/select_purchase_payments' ?>", // json datasource
        type: "post", // type of method  , by default would be get
        data: function(d){
          d.date = GetSearchDate();
          d.work = GetSearchWork();
        }
      },
      "bProcessing": true,
      "deferRender": true,
      "bDeferRender": true,
      scrollX:!0, scrollCollapse:!0,
      buttons: [
        { extend: 'print', className: 'btn dark btn-outline',exportOptions: {columns: ':visible'} },
        { extend: 'csv', className: 'btn purple btn-outline ' },
        { extend: 'colvis', className: 'btn dark btn-outline', text: 'Columns'}
      ],
      dom:"<'row'<'col-sm-6 text-left'B><'col-sm-6 text-right'f>>\n\t\t\t<'row'<'col-sm-12'tr>>\n\t\t\t<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 dataTables_pager'lp>>", // horizobtal scrollable datatable
      "lengthMenu": [
        [25, 50, 100, -1],
        [25, 50, 100, "All"] // change per page values here
      ],
      "columnDefs": [
        {
          "targets": [ 8],
          className: "hidden"
        }
      ],
      'order': false
    });
    var table3 = $('#purchase_materials_view_table').DataTable({
      "ajax":{
        url :"<?php echo base_url().'purchases/select_purchased_items_list' ?>", // json datasource
        type: "post", // type of method  , by default would be get
        data: function(d){
          d.date = GetSearchDate();
          d.work = GetSearchWork();
        }
      },
      "bProcessing": true,
      "deferRender": true,
      "bDeferRender": true,
      scrollX:!0, scrollCollapse:!0,
      buttons: [
        { extend: 'print', className: 'btn dark btn-outline',exportOptions: {columns: ':visible'} },
        { extend: 'csv', className: 'btn purple btn-outline ' },
        { extend: 'colvis', className: 'btn dark btn-outline', text: 'Columns'}
      ],
      dom:"<'row'<'col-sm-6 text-left'B><'col-sm-6 text-right'f>>\n\t\t\t<'row'<'col-sm-12'tr>>\n\t\t\t<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 dataTables_pager'lp>>", // horizobtal scrollable datatable
      "lengthMenu": [
        [25, 50, 100, -1],
        [25, 50, 100, "All"] // change per page values here
      ],
      'order': false
    });
    var table4 = $('#expense_view_table').DataTable({
      "ajax":{
        url :"<?php echo base_url().'expense/select_expense' ?>", // json datasource
        type: "post", // type of method  , by default would be get
        data: function(d){
          //                         d.status = GetSearchStatus();
          d.date = GetSearchDate();
          d.work = GetSearchWork();
        }
      },
      "bProcessing": true,
      "deferRender": true,
      "bDeferRender": true,
      scrollX:!0, scrollCollapse:!0,
      buttons: [
        { extend: 'print', className: 'btn dark btn-outline',exportOptions: {columns: ':visible'} },
        { extend: 'csv', className: 'btn purple btn-outline ' },
        { extend: 'colvis', className: 'btn dark btn-outline', text: 'Columns'}
      ],
      dom:"<'row'<'col-sm-6 text-left'B><'col-sm-6 text-right'f>>\n\t\t\t<'row'<'col-sm-12'tr>>\n\t\t\t<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 dataTables_pager'lp>>", // horizobtal scrollable datatable
      "lengthMenu": [
        [25, 50, 100, -1],
        [25, 50, 100, "All"] // change per page values here
      ],
      "columnDefs": [
        {
          "targets": [ 10,11,12 ],
          className: "hidden"
        }
      ],
      'order': false
    });
    var table5 = $('#subcontracts_payment_view_table').DataTable({
      "ajax":{
        url :"<?php echo base_url().'subcontract_payments/select_subcontract_payments' ?>", // json datasource
        type: "post", // type of method  , by default would be get
        data: function(d){
          //                         d.status = GetSearchStatus();
          d.date = GetSearchDate();
          d.work = GetSearchWork();
        }
      },
      "bProcessing": true,
      "deferRender": true,
      "bDeferRender": true,
      scrollX:!0, scrollCollapse:!0,
      buttons: [
        { extend: 'print', className: 'btn dark btn-outline',exportOptions: {columns: ':visible'} },
        { extend: 'csv', className: 'btn purple btn-outline ' },
        { extend: 'colvis', className: 'btn dark btn-outline', text: 'Columns'}
      ],
      dom:"<'row'<'col-sm-6 text-left'B><'col-sm-6 text-right'f>>\n\t\t\t<'row'<'col-sm-12'tr>>\n\t\t\t<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 dataTables_pager'lp>>", // horizobtal scrollable datatable
      "lengthMenu": [
        [25, 50, 100, -1],
        [25, 50, 100, "All"] // change per page values here
      ],
      "columnDefs": [
        {
          "targets": [ 0,12 ],
          className: "hidden"
        }
      ],
      'order': false
    });

    var table6 = $('#subcontracts_payment_by_type_view_table').DataTable({
      "ajax":{
        url :"<?php echo base_url().'subcontract_payments/select_subcontract_payments_by_type/all' ?>", // json datasource
        type: "post", // type of method  , by default would be get
        data: function(d){
          d.date = GetSearchDate();
          d.work = GetSearchWork();
        }
      },
      "bProcessing": true,
      "deferRender": true,
      "bDeferRender": true,
      scrollX:!0, scrollCollapse:!0,
      buttons: [
        { extend: 'print', className: 'btn dark btn-outline',exportOptions: {columns: ':visible'} },
        { extend: 'csv', className: 'btn purple btn-outline ' },
        { extend: 'colvis', className: 'btn dark btn-outline', text: 'Columns'}
      ],
      dom:"<'row'<'col-sm-6 text-left'B><'col-sm-6 text-right'f>>\n\t\t\t<'row'<'col-sm-12'tr>>\n\t\t\t<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 dataTables_pager'lp>>", // horizobtal scrollable datatable
      "lengthMenu": [
        [25, 50, 100, -1],
        [25, 50, 100, "All"] // change per page values here
      ],
      'order': false
    });
    // var table7 = $('#daily_report_view_table').DataTable({
    //     "ajax":{
    //         url :"<?php echo base_url().'daily_reports/select_daily_report/3' ?>", // json datasource
    //         type: "post", // type of method  , by default would be get
    //         data: function(d){
    // //                         d.status = GetSearchStatus();
    //         d.date = GetSearchDate();
    //         d.work = GetSearchWork();
    //         }
    //     },
    //     "bProcessing": true,
    //     "deferRender": true,
    //     "bDeferRender": true,
    //     scrollX:!0, scrollCollapse:!0,
    //     buttons: [
    //         { extend: 'print', className: 'btn dark btn-outline',exportOptions: {columns: ':visible'} },
    //         { extend: 'csv', className: 'btn purple btn-outline ' },
    //         { extend: 'colvis', className: 'btn dark btn-outline', text: 'Columns'}
    //     ],
    //     dom:"<'row'<'col-sm-6 text-left'B><'col-sm-6 text-right'f>>\n\t\t\t<'row'<'col-sm-12'tr>>\n\t\t\t<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 dataTables_pager'lp>>", // horizobtal scrollable datatable
    //     "lengthMenu": [
    //         [25, 50, 100, -1],
    //         [25, 50, 100, "All"] // change per page values here
    //     ],
    //     "columnDefs": [
    //         {
    //             "targets": [ 1,2,9 ],
    //             className: "hidden"
    //         }
    //     ],
    //     'order': [0,'asc']
    // });
    var table8 = $('#purchase_order_payments_table').DataTable({
      "ajax":{
        url :"<?php echo base_url().'purchase_order/select_purchase_order_payments' ?>", // json datasource
        type: "post", // type of method  , by default would be get
        data: function(d){
          //                         d.status = GetSearchStatus();
          d.date = GetSearchDate();
          d.work = GetSearchWork();
          // d.purchase_bill_id = 0;
        }
      },
      "bProcessing": true,
      "deferRender": true,
      "bDeferRender": true,
      scrollX:!0, scrollCollapse:!0,
      buttons: [
        { extend: 'print', className: 'btn dark btn-outline',exportOptions: {columns: ':visible'} },
        { extend: 'csv', className: 'btn purple btn-outline ' },
        { extend: 'colvis', className: 'btn dark btn-outline', text: 'Columns'}
      ],
      dom:"<'row'<'col-sm-6 text-left'B><'col-sm-6 text-right'f>>\n\t\t\t<'row'<'col-sm-12'tr>>\n\t\t\t<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 dataTables_pager'lp>>", // horizobtal scrollable datatable
      "lengthMenu": [
        [25, 50, 100, -1],
        [25, 50, 100, "All"] // change per page values here
      ],
      "columnDefs": [
        {
          "targets": [ 1],
          className: "hidden"
        }
      ],
      'order': false
    });
    var table9 = $('#user_payment_receipts_view_table').DataTable({
      "ajax":{
        url :"<?php echo base_url().'user_payments/select_user_payments' ?>", // json datasource
        type: "post", // type of method  , by default would be get
        data: function(d){
          d.date = GetSearchDate();
          d.work = GetSearchWork();
        }
      },
      "bProcessing": true,
      "deferRender": true,
      "bDeferRender": true,
      scrollX:!0, scrollCollapse:!0,
      buttons: [
      { extend: 'print', className: 'btn dark btn-outline',exportOptions: {columns: ':visible'} },
      { extend: 'csv', className: 'btn purple btn-outline ' },
      { extend: 'colvis', className: 'btn dark btn-outline', text: 'Columns'}
      ],
      dom:"<'row'<'col-sm-6 text-left'B><'col-sm-6 text-right'f>>\n\t\t\t<'row'<'col-sm-12'tr>>\n\t\t\t<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 dataTables_pager'lp>>", // horizobtal scrollable datatable
      "lengthMenu": [
      [25, 50, 100, -1],
      [25, 50, 100, "All"] // change per page values here
      ],
      "columnDefs": [
      {
        "targets": [ 1 ],
        className: "hidden"
      }
      ],
      'order': false
    });
    $(".hide_column").hide();

    // Date Range Picker
    var start = moment();
    var end = moment();

    function cb(start, end) {
      $('#table_filter_date_range').val(start.format('MMMM D, YYYY') + ' - ' + end.format('MMMM D, YYYY'));
      table1.ajax.reload();
      table2.ajax.reload();
      table3.ajax.reload();
      table4.ajax.reload();
      table5.ajax.reload();
      table6.ajax.reload();
      // table7.ajax.reload();
      table8.ajax.reload();
      table9.ajax.reload();
      select_summary();
    }
    $(".table_filter").on("change", function() {
      table1.ajax.reload();
      table2.ajax.reload();
      table3.ajax.reload();
      table4.ajax.reload();
      table5.ajax.reload();
      table6.ajax.reload();
      // table7.ajax.reload();
      table8.ajax.reload();
      table9.ajax.reload();
      select_summary();
    });
    $('.profile_nav').on('click', function(e){
      var table_nos = $(this).attr('data-table-no');
      if(table_nos!=''){
        var tables = table_nos.split(',');
        $.each(tables, function( index, value ){
          var table_name = "table"+value;
          eval(table_name).ajax.reload();
        });
      }
    });
    $('#table_filter_date_range').daterangepicker({
      buttonClasses: "m-btn btn",
      applyClass: "btn-primary",
      cancelClass: "btn-secondary",
      startDate: start,
      endDate: end,
      locale: {
        format: 'MMMM D, YYYY'
      },
      ranges: {
        'Today': [moment(), moment()],
        'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
        'Last 7 Days': [moment().subtract(6, 'days'), moment()],
        'Last 30 Days': [moment().subtract(29, 'days'), moment()],
        'This Month': [moment().startOf('month'), moment().endOf('month')],
        'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')],
        'All time': [moment('1970-01-01'), moment().add(9999, 'days')],
      }
    }, cb);
    cb(start, end);
  };
  return {
    init:function() {
      t()
    }
  }
}

();
jQuery(document).ready(function() {
  Datatable.init();
  $(".hidden").hide();
  //            $('#service_view_table').wrap("");
  $($.fn.dataTable.tables(true)).DataTable()
  .columns.adjust();


}

);
select_summary();
function select_summary(){
  function GetSearchDate(){
    return $('#table_filter_date_range').val();
  }
  function GetSearchWork(){
    return $('#work1').val();
  }
  function GetSearchUser(){
    return $('#user').val();
  }
  $.post("<?php echo base_url().'reports/select_report_counts' ?>",{
    date:GetSearchDate(),work:GetSearchWork(),user:GetSearchUser()
  },function(data){
    var obj= $.parseJSON(data);
    $(".total_received_from_client_info").text(obj.total_client_payments_received);
    $(".total_purchase_order_payments_info").text(obj.total_purchase_order_payment);
    $(".total_purchases_bill_payment_info").text(obj.total_purchase_bill_payment);
    $(".total_purchase_payment_info").text(obj.total_purchase_payment);

    $(".total_subcontract_payment_info").text(obj.total_subcontract_payment);
    $(".total_labour_wage_payments_info").text(obj.total_labour_wage_payments);
    $(".total_other_expense_info").text(obj.total_other_expense);
    $(".total_office_expense_info").text(obj.total_office_expense);
    $(".total_expense_info").text(obj.total_expense_amount);
    $(".total_balance_info").text(obj.total_cash_balance);
    $(".total_user_payments_released_info").text(obj.total_user_payments_released);
    $(".total_user_payments_received_info").text(obj.total_user_payments_received);
  })
}

</script>
<script>
  $(function(){
    $('#print_all,#print_all_1').click(function(e){
      var date =  $('#table_filter_date_range').val();
      var work =  $('#work1').val();
      var date_array = date.split(' - ');
      var start_date = date_array[0].replace(',','');
      start_date = start_date.replace(' ','-');
      start_date = start_date.replace(' ','-');
      var end_date = date_array[1].replace(',','');
      end_date = end_date.replace(' ','-');
      end_date = end_date.replace(' ','-');
      window.open('<?php echo base_url().'reports/report_print/' ?>'+start_date+'/'+end_date+'/'+work,'newwindow','width=800,height=700'); return false

    });
  });
</script>
