<?php $this->view("includes/Inc_pagehead");?>
<!-- Page Styles Goes Here-->

<?php $this->view("includes/Inc_navigation");?>
<div class="m-grid__item m-grid__item--fluid m-wrapper">
  <!-- BEGIN: Subheader -->
  <div class="m-subheader ">
    <div class="d-flex align-items-center">
      <div class="mr-auto">
        <h3 class="m-subheader__title m-subheader__title--separator">
          Tax Report
        </h3>
        <ul class="m-subheader__breadcrumbs m-nav m-nav--inline">
          <li class="m-nav__item m-nav__item--home">
            <a href="#" class="m-nav__link m-nav__link--icon">
              <i class="m-nav__link-icon la la-home"></i>
            </a>
          </li>
          <li class="m-nav__separator">
            -
          </li>
          <li class="m-nav__item">
            <a href="<?php echo base_url().'dashboard'?>" class="m-nav__link">
              <span class="m-nav__link-text">
                Home
              </span>
            </a>
          </li>
          <li class="m-nav__separator">
            -
          </li>
          <li class="m-nav__item">
            <a href="<?php echo base_url().'reports/tax' ?>" class="m-nav__link">
              <span class="m-nav__link-text">
                Tax Report
              </span>
            </a>
          </li>
        </ul>
      </div>
      <div>
      </div>
    </div>
  </div>
  <!-- END: Subheader -->
  <div class="m-content">
    <div class="m-portlet  m-portlet--rounded m-portlet--bordered">
      <div class="m-portlet__body" style="padding: 1rem 2.2rem;">
        <div class="m-form m-form--label-align-right m--margin-bottom-10">
          <div class="row ">
            <div class="col-xl-12 order-2 order-xl-1">
              <div class="form-group m-form__group row">
                <div class="col-md-3">
                  <div class="form-group m-form__group">
                    <label> Date:</label>
                    <input style="border: none" id="table_filter_date"  type="text" class="form-control  m-input--solid m-input "  >
                  </div>
                </div>
                <div class="col-md-2">
                  <div class="form-group m-form__group">
                    <label>Report Types:</label>
                    <div class="m-select2 m-select2--air ">
                      <select style="width: 100%" class="form-control m-select2 table_filter" id="table_filter_report_type"  name="report_type" data-placeholder="Select Report Type">
                        <option value="all">All Types</option>
                        <option value="purchase">Material Purchase Bill</option>
                        <option value="subcontract">Subcontract</option>
                        <option value="expense">Expense Bill</option>
                        <option value="client_invoice">Client Invoice</option>
                      </select>
                    </div>
                    <span class="m-form__help"></span>
                  </div>
                </div>
                <div class="col-md-3">
                  <div class="form-group m-form__group">
                    <label>Project / Location:</label>
                    <div class="m-select2 m-select2--air ">
                      <select style="width: 100%" class="form-control m-select2 table_filter" id="table_filter_location"  name="location" data-placeholder="Select Location">
                        <option value="all">All Project / Location</option>
                        <?php
                        foreach($stock_locations as $row):
                          $location_name = $row->location_name;
                          if($this->config->item('app_module_stock_management')==1){
                            if($row->location_type=='work_site'){
                              $location_name .= " [Work Site]";
                            }elseif($row->location_type=='ware_house'){
                              $location_name .= " [Warehouse]";
                            }
                          }
                          ?>
                          <option value="<?php echo $row->location_id?>"><?php echo $location_name?></option>
                          <?php
                        endforeach;
                        ?>
                      </select>
                    </div>
                    <span class="m-form__help"></span>
                  </div>
                </div>
                <div class="col-md-3">
                  <div class="form-group m-form__group">
                    <label>Material Supplier:</label>
                    <div class="m-select2 m-select2--air ">
                      <select style="width: 100%" class="form-control m-select2 table_filter" id="table_filter_supplier"  name="supplier" data-placeholder="Select Supplier">
                        <option value="all">All Suppliers</option>
                        <?php
                        foreach($stock_locations as $row):
                          $location_name = $row->location_name;
                          if($this->config->item('app_module_stock_management')==1){
                            if($row->location_type=='work_site'){
                              $location_name .= " [Work Site]";
                            }elseif($row->location_type=='ware_house'){
                              $location_name .= " [Warehouse]";
                            }
                          }
                          ?>
                          <option value="<?php echo $row->location_id?>"><?php echo $location_name?></option>
                          <?php
                        endforeach;
                        ?>
                      </select>
                    </div>
                    <span class="m-form__help"></span>
                  </div>
                </div>
                <div class="col-md-1">
                  <br/>
                  <button style="margin-top: 7px" id="btn_go" class="btn btn-focus m-btn m-btn--custom m-btn--icon m-btn--air m-btn--pill">
                    <span>
                      <i class="la la-search"></i>
                      <span>
                        Go
                      </span>
                    </span>
                  </button>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
    <div style="display: none" id="report_div" class="m-portlet m-portlet--mobile m-portlet--info m-portlet--head-solid-bg m-portlet--bordered m-portlet--rounded">
      <div class="m-portlet__head">
        <div class="m-portlet__head-caption">
          <div class="m-portlet__head-title">
            <h3 class="m-portlet__head-text">
              Tax Report
            </h3>
          </div>
        </div>
        <div class="m-portlet__head-tools">

        </div>
      </div>
      <div class="m-portlet__body">
        <!--begin: Datatable -->
        <table width="100%" class="table m-table nowrap table-header-fixed table-striped table-bordered table-hover table-header-fixed" id="report_view_table">
          <thead>
            <tr class="">
              <th>Sl No</th>
              <th>Date</th>
              <th>Type</th>
              <th>Project/Location</th>
              <th>Supplier/Consignee/Contractor/Client</th>
              <th>Address/Remarks</th>
              <th>Tax No</th>
              <th>Description</th>
              <th>Reference</th>
              <?php
              foreach($tax_types as $row){ ?>
                <th><?php echo "Taxable Amt "."@".$row->tax_percentage ?>%</th>
                <?php
                if($row->tax1_percent==0 && $row->tax2_percent==0 && $row->tax3_percent==0){ ?>
                  <th><?php echo $this->config->item('Tax_tax_name')." @".$row->tax_percentage ?>%</th>
                <?php }else{ ?>
                  <?php if($row->tax1_percent!=0){?>
                    <th><?php echo $this->config->item('Tax_tax1_name')." @".$row->tax1_percent ?>%</th>
                  <?php } ?>
                  <?php if($row->tax2_percent!=0){?>
                    <th><?php echo $this->config->item('Tax_tax2_name')." @".$row->tax2_percent ?>%</th>
                  <?php } ?>
                  <?php if($row->tax3_percent!=0){?>
                    <th><?php echo $this->config->item('Tax_tax3_name')." @".$row->tax3_percent ?>%</th>
                  <?php } ?>
                <?php } ?>
              <?php } ?>
              <th>Discount Amt</th>
              <th>Round Amt</th>
              <th>Total Amt</th>
            </tr>
          </thead>
          <tbody id="report_view_table_body">
          </tbody>
        </table>
      </div>
    </div>
  </div>
</div>
</div>
<!-- end:: Body -->
<!-- begin::Footer -->

<?php $this->view("includes/Inc_footer");?>
<!-- end::Footer -->
</div>
<!-- end:: Page -->

<?php $this->view("includes/Inc_sidebar");?>
<?php $this->view("includes/Inc_scripts");?>

<!--begin::Page Snippets -->
<script>
$("#report_menu").addClass('m-menu__item--active m-menu__item--open');
$("#report_menu_12").addClass('m-menu__item--active');

$("#table_filter_location").select2({
  placeholder: "Select Location",
  templateResult: format_project_dropdown
})
$("#table_filter_supplier").select2({
  placeholder: "Select Suplier"
})
$("#table_filter_report_type").select2({
  placeholder: "Select Report Type"
})
function select_supplier(){
  $('#table_filter_supplier').html('');
  $("#table_filter_supplier").append("<option selected value='all'>All Suppliers</option>");
  $.post("<?php echo base_url() ?>supplier/select",{},function(data) {
    var obj = $.parseJSON(data);
    var i=0;
    if(obj.count>0) {
      while (i < obj.id.length) {
        $("#table_filter_supplier").append("<option value=" + obj.id[i] + ">" + obj.name[i] + "</option>");
        i++;
      }
    }
  })
}
select_supplier();

// Date Range Picker
var start = moment();
var end = moment();

function cb(start, end) {
  $('#table_filter_date').val(start.format('MMMM D, YYYY') + ' - ' + end.format('MMMM D, YYYY'));
}

$('#table_filter_date').daterangepicker({
  buttonClasses: "m-btn btn",
  applyClass: "btn-primary",
  cancelClass: "btn-secondary",
  startDate: start,
  endDate: end,
  locale: {
    format: 'MMMM D, YYYY'
  },
  ranges: {
    'Today': [moment(), moment()],
    'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
    'Last 7 Days': [moment().subtract(6, 'days'), moment()],
    'Last 30 Days': [moment().subtract(29, 'days'), moment()],
    'This Month': [moment().startOf('month'), moment().endOf('month')],
    'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')],
    'All time': [moment('1970-01-01'), moment().add(9999, 'days')],
  }
}, cb);

cb(start, end);

$('body').on('click', '#btn_go', function() {
  $("#report_div").show();
  report_table();
})

var report_table=function() {
  $('#report_view_table').dataTable().fnDestroy();
  function GetSearchDate(){
    return $('#table_filter_date').val();
  }
  function GetSearchlocation(){
    return $('#table_filter_location').val();
  }
  function GetSearchsupplier(){
    return $('#table_filter_supplier').val();
  }
  function GetSearchreporttype(){
    return $('#table_filter_report_type').val();
  }
  $('.table_caption').html("");
  $('#report_view_table').append('<caption class="table_caption" style="caption-side: top !important;text-align: center"><strong>Purchase Tax Report Between '+GetSearchDate()+'</strong></caption>');
  var table = $('#report_view_table').DataTable({
    "ajax":{
      url :"<?php echo base_url().'reports/select_tax_report' ?>", // json datasource
      type: "post", // type of method  , by default would be get
      data: function(d){
        d.date = GetSearchDate();
        d.location = GetSearchlocation();
        d.report_type = GetSearchreporttype();
        d.supplier = GetSearchsupplier();
      }
    },
    "bProcessing": true,
    "deferRender": true,
    "bDeferRender": true,
    "scrollX" : true,
    buttons: [
      { extend: 'print', className: 'btn dark btn-outline',exportOptions: {columns: ':visible'},title: 'Purchase Tax Report' },
      { extend: 'csv', className: 'btn purple btn-outline ' },
      { extend: 'colvis', className: 'btn dark btn-outline', text: 'Columns'}
    ],
    dom:"<'row'<'col-sm-6 text-left'B><'col-sm-6 text-right'f>>\n\t\t\t<'row'<'col-sm-12'tr>>\n\t\t\t<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 dataTables_pager'lp>>", // horizobtal scrollable datatable
    "lengthMenu": [
      [25, 50, 100, -1],
      [25, 50, 100, "All"] // change per page values here
    ],
    // set the initial value
    "pageLength": 25,
    "columnDefs": [
      {
        "targets": [  ],
        className: "hidden"
      }
    ],
    'ordering': false
  });
  $(".hide_column").hide();
}

jQuery(document).ready(function() {
  $(".hidden").hide();

});
</script>
