<?php $this->view("includes/Inc_pagehead"); ?>
<!-- Page Styles Goes Here-->

<?php $this->view("includes/Inc_navigation"); ?>
<div class="m-grid__item m-grid__item--fluid m-wrapper">
  <!-- BEGIN: Subheader -->
  <div class="m-subheader ">
    <div class="d-flex align-items-center">
      <div class="mr-auto">
        <h3 class="m-subheader__title m-subheader__title--separator">
          Income - Expense Reports
        </h3>
        <ul class="m-subheader__breadcrumbs m-nav m-nav--inline">
          <li class="m-nav__item m-nav__item--home">
            <a href="#" class="m-nav__link m-nav__link--icon">
              <i class="m-nav__link-icon la la-home"></i>
            </a>
          </li>
          <li class="m-nav__separator">
            -
          </li>
          <li class="m-nav__item">
            <a href="<?php echo base_url() . 'dashboard' ?>" class="m-nav__link">
              <span class="m-nav__link-text">
                Home
              </span>
            </a>
          </li>
          <li class="m-nav__separator">
            -
          </li>
          <li class="m-nav__item">
            <a href="<?php echo base_url() . 'reports/profit' ?>" class="m-nav__link">
              <span class="m-nav__link-text">
                Income - Expense Reports
              </span>
            </a>
          </li>
        </ul>
      </div>
      <div>
      </div>
    </div>
  </div>
  <!-- END: Subheader -->
  <div class="m-content">
    <div class="m-portlet  m-portlet--rounded m-portlet--bordered">
      <div class="m-portlet__body" style="padding: 1rem 2.2rem;">
        <div class="m-form m-form--label-align-right m--margin-bottom-10">
          <div class="row ">
            <div class="col-xl-12 order-2 order-xl-1">
              <div class="form-group m-form__group row">
                <div class="col-md-3">
                  <div class="form-group m-form__group">
                    <label> Date:</label>
                    <input style="border: none" id="table_filter_date" type="text" class="form-control  m-input--solid m-input ">
                  </div>
                </div>
                <div class="col-md-3">
                  <div class="m-form__group form-group" >
                    <label class="col-form-label">Projects</label>
                    <div class="m-radio-inline">
                      <label class="m-radio m-radio--solid m-radio--state-brand">
                        <input required type="radio" name="project_type" value="all"> Include All Projects
                        <span></span>
                      </label>
                      <label class="m-radio m-radio--solid m-radio--state-focus">
                        <input required type="radio" name="project_type" value="have_entry" checked> Only Have Entry on Selected Period
                        <span></span>
                      </label>
                    </div>
                    <span class="m-form__help"></span>
                  </div>
                </div>
                <?php if (!empty($this->config->item('company_branches'))) { ?>
                  <div class="col-lg-3">
                    <div class="form-group m-form__group">
                      <label>
                        Company Branch
                      </label>
                      <div class="m-select2 m-select2--air m-select2--pill">
                        <select width="100%" required class="form-control  m-input--solid m-input company-branch-select2" id="company_branch">
                          <option selected value="all"> All Branches</option>
                          <option value="0">NO BRANCH</option>
                          <?php foreach ($this->config->item('company_branches') as $key => $value) { ?>
                            <option value="<?php echo $value->branch_id ?>"><?php echo $value->branch_name ?></option>
                          <?php } ?>
                        </select>
                      </div>
                      <span class="m-form__help"></span>
                    </div>
                  </div>

                <?php } ?>

                  <div class="col-lg-3">
                    <div class="form-group m-form__group">
                      <label>
                        Project Section
                      </label>
                      <div class="m-select2 m-select2--air m-select2--pill">
                        <select width="100%" required class="form-control m-select2 table_filter" id="project_section">
                          <option selected value="all"> All Project Section</option>
                          <?php foreach ($this->config->item('project_sections') as $key => $value) { ?>
                            <option value="<?php echo $value->section_name ?>"><?php echo $value->section_name ?></option>
                          <?php } ?>
                        </select>
                      </div>
                      <span class="m-form__help"></span>
                    </div>
                  </div>
                  <div class="col-lg-3">
                    <div class="form-group m-form__group">
                      <label>
                        Project Category
                      </label>
                      <div class="m-select2 m-select2--air m-select2--pill">
                        <select width="100%" required class="form-control m-select2 table_filter" id="project_type">
                          <option selected value="all"> All Project Category</option>
                          <?php foreach ($project_categories as $key => $value) { ?>
                            <option value="<?php echo $value->wcat_id ?>"><?php echo $value->wcat_name ?></option>
                          <?php } ?>
                        </select>
                      </div>
                      <span class="m-form__help"></span>
                    </div>
                  </div>
                  <div class="col-lg-3">
                    <div class="form-group m-form__group">
                      <label>
                        Client
                      </label>
                      <div class="m-select2 m-select2--air m-select2--pill">
                        <select width="100%" required class="form-control m-select2 table_filter" id="client">

                        </select>
                      </div>
                      <span class="m-form__help"></span>
                    </div>
                  </div>
                  <div class="col-lg-3">
                    <div class="form-group m-form__group">
                      <label>
                        Work Status:
                      </label>
                      <div class="m-select2 m-select2--air m-select2--pill">
                        <select style="width: 100%" class="form-control m-select2 table_filter" id="work_status" name="work_status" data-placeholder="Select Work">
                          <option value="all">All Status</option>
                          <option value="2">Pending</option>
                          <option value="1">Completed</option>
                          <option value="3">Freeze</option>
                        </select>
                      </div>
                      <span class="m-form__help"></span>
                    </div>
                  </div>

                <div class="col-md-2">
                  <br />
                  <button style="margin-top: 7px" id="btn_go" class="btn btn-focus m-btn m-btn--custom m-btn--icon m-btn--air m-btn--pill">
                    <span>
                      <i class="la la-search"></i>
                      <span>
                        Go
                      </span>
                    </span>
                  </button>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
    <div id="income_expense_report_div" style="display:none">
      <div class="m-portlet m-portlet--mobile m-portlet--info m-portlet--head-solid-bg m-portlet--bordered m-portlet--rounded">
        <div class="m-portlet__head">
          <div class="m-portlet__head-caption">
            <div class="m-portlet__head-title">
              <h3 class="m-portlet__head-text">
                Projectwise Income - Expense Reports (On Selected Date Period)
              </h3>
            </div>
          </div>
          <div class="m-portlet__head-tools">

          </div>
        </div>
        <div class="m-portlet__body">


          <!--begin: Datatable -->
          <div class="m-form m-form--label-align-right m--margin-bottom-10">
            <div class="row align-items-center">
              <div class="col-xl-12 order-2 order-xl-1">
                <div class="form-group m-form__group row align-items-center">
                  <div class="col-md-6">
                    <div class="form-group m-form__group">
                      <label>
                        Project Category:
                      </label>
                      <div class="m-select2 m-select2--air m-select2--pill">
                        <select style="width: 100%" class="form-control m-select2 table_filter" id="category" name="category" data-placeholder="Select Category">
                          <option value="all">All Categories</option>
                          <?php
                          foreach ($project_categories as $row) : ?>
                            <option value="<?php echo $row->wcat_id ?>"><?php echo $row->wcat_name ?></option>
                          <?php
                          endforeach;
                          ?>
                        </select>
                      </div>
                      <span class="m-form__help"></span>
                    </div>
                  </div>

                  <div class="col-md-6">
                    <div class="form-group m-form__group">
                      <label>
                        Project Section:
                      </label>
                      <div class="m-select2 m-select2--air m-select2--pill">
                        <select style="width: 100%" class="form-control m-select2 table_filter" id="section" name="section" data-placeholder="Select Section">
                          <option value="all">All Section</option>
                          <?php
                          foreach ($project_sections as $row) : ?>
                            <option value="<?php echo $row->section_name ?>"><?php echo $row->section_name ?></option>
                          <?php
                          endforeach;
                          ?>
                        </select>
                      </div>
                      <span class="m-form__help"></span>
                    </div>
                  </div>

                </div>
              </div>
            </div>
          </div>

          <table width="100%" class="table nowrap m-table table-header-fixed table-striped table-bordered table-hover table-header-fixed" id="projectwise_report_view_table">
            <thead>
              <tr class="">
                <th>ID</th>
                <th>Project</th>
                <th>Client</th>
                <th>Status</th>
                <th>Est. Project Budget</th>
                <th>Rcvd Client Payments</th>
                <th>Purchase Bill</th>
                <th>Labour Wage Slip</th>
                <th>Salary Slip</th>
                <th>Expense Bills</th>
                <th>Subcontract Bills</th>
                <th>Purchase Order Payments</th>
                <th>Purchase Bill Payments</th>
                <th>Salary Slip Payments</th>
                <th>Expense Bill Payments</th>
                <th>Subcontract Payments</th>
                <th>User Commission Payments</th>
                <th>Stock Transfer In</th>
                <th>Stock Transfer Out</th>
                <th>Total Project Cost<br />(Include Stock Transfers)</th>
                <th>Total Project Expense<br />Payments</th>

                <th>Total Project Income</th>
                <th>Balance to Receive From Client<br/>(Overall)</th>
                <th>Project Profit<br/>(On Selected Period)</th>
                <!-- <th>Other Expense Amt</th>
                <th>Actual Profit</th> -->
                <th>Income Tax Amt</th>
                <th>Expense Tax Amt</th>
              </tr>
            </thead>
            <tbody>
            </tbody>
          </table>
        </div>
      </div>
      <!-- <div class="m-portlet m-portlet--mobile m-portlet--info m-portlet--head-solid-bg m-portlet--bordered m-portlet--rounded">
        <div class="m-portlet__head">
          <div class="m-portlet__head-caption">
            <div class="m-portlet__head-title">
              <h3 class="m-portlet__head-text">
                Office - Income - Expense Reports
              </h3>
            </div>
          </div>
          <div class="m-portlet__head-tools">

          </div>
        </div>
        <div class="m-portlet__body">
          <table width="100%" class="table nowrap m-table table-header-fixed table-striped table-bordered table-hover table-header-fixed" id="office_report_view_table">
            <thead>
              <tr class="">
                <th>SL No</th>
                <th>Description</th>
                <th>Amount</th>
              </tr>
            </thead>
            <tbody>
            </tbody>
          </table>
        </div>
      </div> -->
      <div class="m-portlet m-portlet--mobile m-portlet--info m-portlet--head-solid-bg m-portlet--bordered m-portlet--rounded">
        <div class="m-portlet__head">
          <div class="m-portlet__head-caption">
            <div class="m-portlet__head-title">
              <h3 class="m-portlet__head-text">
                Overall Reports (On Selected Date Period)
              </h3>
            </div>
          </div>
          <div class="m-portlet__head-tools">

          </div>
        </div>
        <div class="m-portlet__body">
          <table width="100%" class="table nowrap m-table table-header-fixed table-striped table-bordered table-hover table-header-fixed" id="overall_report_view_table">
            <thead>
              <tr class="">
                <th>SL No</th>
                <th>Description</th>
                <th>Amount</th>
              </tr>
            </thead>
            <tbody>
            </tbody>
          </table>
        </div>
      </div>
    </div>
  </div>
</div>
</div>
</div>
<!-- end:: Body -->
<!-- begin::Footer -->
<?php $this->view("includes/Inc_footer"); ?>
<!-- end::Footer -->
</div>
<!-- end:: Page -->
<?php $this->view("includes/Inc_sidebar"); ?>
<?php $this->view("includes/Inc_scripts"); ?>

<!--begin::Page Snippets -->
<script>
  $("#report_menu").addClass('m-menu__item--active m-menu__item--open');
  $("#report_menu_5").addClass('m-menu__item--active');

  $("#category").select2({
    placeholder: "Select  Category",
  })

  $("#section").select2({
    placeholder: "Select  Section",
  })
  $("#project_section").select2({
    placeholder: "Select Project Section"
  })
  $("#project_type").select2({
    placeholder: "Select Project Type"
  })
  $("#client").select2({
    placeholder: "Select Client"
  })
  $("#work_status").select2({
    placeholder: "Select Status"
  })
  select_client();

  function select_client() {
    $('#client').html('');
    $("#client").append("<option value='all' selected >All Clients</option>");
    $.post("<?php echo base_url() ?>clients/select", {}, function(data) {
      var obj = $.parseJSON(data);
      var i = 0;
      if (obj.count > 0) {
        while (i < obj.id.length) {
          $("#client").append("<option value=" + obj.id[i] + ">" + obj.name[i] + "</option>");
          i++;
        }
      }
    })
  }
</script>
<script>
  // Date Range Picker
  var start = moment();
  var end = moment();

  function cb(start, end) {
    $('#table_filter_date').val(start.format('MMMM D, YYYY') + ' - ' + end.format('MMMM D, YYYY'));
  }

  $('#table_filter_date').daterangepicker({
    buttonClasses: "m-btn btn",
    applyClass: "btn-primary",
    cancelClass: "btn-secondary",
    startDate: start,
    endDate: end,
    locale: {
      format: 'MMMM D, YYYY'
    },
    ranges: {
      'Today': [moment(), moment()],
      'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
      'Last 7 Days': [moment().subtract(6, 'days'), moment()],
      'Last 30 Days': [moment().subtract(29, 'days'), moment()],
      'This Month': [moment().startOf('month'), moment().endOf('month')],
      'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')],
      'All time': [moment('1970-01-01'), moment().add(9999, 'days')],
    }
  }, cb);

  cb(start, end);

  $('body').on('click', '#btn_go', function() {
    $("#income_expense_report_div").show();
    income_expense_report();
  })

  var income_expense_report = function() {
    $('#projectwise_report_view_table').dataTable().fnDestroy();
    $('#overall_report_view_table').dataTable().fnDestroy();
    $('#office_report_view_table').dataTable().fnDestroy();

    function GetSearchDate() {
      return $('#table_filter_date').val();
    }

    function GetCategory() {
      return $('#category').val();
    }

    function GetSection() {
      return $('#section').val();
    }
    function Getprojecttype() {
      return $("input[type=radio][name=project_type]:checked").val();
    }
    function get_branch_id() {
      return $('#company_branch :selected').val();
    }
    function GetSearchSection() {
      return $('#project_section').val();
    }
    function GetSearchType() {
      return $('#project_type').val();
    }
    function GetSearchClient() {
      return $('#client').val();
    }
    function GetSearchStatus() {
      return $('#work_status').val();
    }
    var projectwise_report_view_table = $('#projectwise_report_view_table').DataTable({
      "ajax": {
        url: "<?php echo base_url() . 'reports/select_projectwise_profit' ?>", // json datasource
        type: "post", // type of method  , by default would be get
        data: function(d) {
          d.date = GetSearchDate();
          d.category = GetCategory();
          d.section = GetSection();
          d.project_type = Getprojecttype();
          d.project_section = GetSearchSection();
          d.project_type = GetSearchType();
          d.client = GetSearchClient();
          d.status = GetSearchStatus();
          <?php if (!empty($this->config->item('company_branches'))) { ?>
            d.branch_id = get_branch_id();
          <?php } ?>
        }
      },
      "bProcessing": true,
      "deferRender": true,
      "bDeferRender": true,

      "scrollX": true,
      buttons: [{
          extend: 'print',
          className: 'btn dark btn-outline',
          exportOptions: {
            columns: ':visible'
          },
          title: 'Income Expense Report - Project Wise'
        },
        {
          extend: 'csv',
          className: 'btn purple btn-outline '
        },
        {
          extend: 'colvis',
          className: 'btn dark btn-outline',
          text: 'Columns'
        }
      ],
      dom: "<'row'<'col-sm-6 text-left'B><'col-sm-6 text-right'f>>\n\t\t\t<'row'<'col-sm-12'tr>>\n\t\t\t<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 dataTables_pager'lp>>", // horizobtal scrollable datatable
      "lengthMenu": [
        [25, 50, 100, -1],
        [25, 50, 100, "All"] // change per page values here
      ],

      'order': false,
      "columnDefs": [{
        "targets": [4,<?php if ($this->config->item('User_project_commission_payment') == 0) { ?>16<?php } ?>],
        className: "hidden"
      }, ],
      fixedColumns: true,
      fixedColumns: {
        leftColumns: 3
      }
    });
    // var office_report_view_table = $('#office_report_view_table').DataTable({
    //   "ajax": {
    //     url: "<?php echo base_url() . 'reports/select_office_report' ?>", // json datasource
    //     type: "post", // type of method  , by default would be get
    //     data: function(d) {
    //       d.date = GetSearchDate();
    //       <?php if (!empty($this->config->item('company_branches'))) { ?>
    //         d.branch_id = get_branch_id();
    //       <?php } ?>
    //     }
    //   },
    //   "bProcessing": true,
    //   "deferRender": true,
    //   "bDeferRender": true,
    //
    //   "scrollX": true,
    //   buttons: [{
    //       extend: 'print',
    //       className: 'btn dark btn-outline',
    //       exportOptions: {
    //         columns: ':visible'
    //       },
    //       title: 'Office Income Expense Reports'
    //     },
    //     {
    //       extend: 'csv',
    //       className: 'btn purple btn-outline '
    //     },
    //     {
    //       extend: 'colvis',
    //       className: 'btn dark btn-outline',
    //       text: 'Columns'
    //     }
    //   ],
    //   dom: "<'row'<'col-sm-6 text-left'B><'col-sm-6 text-right'f>>\n\t\t\t<'row'<'col-sm-12'tr>>\n\t\t\t<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 dataTables_pager'lp>>", // horizobtal scrollable datatable
    //   'order': false,
    //   "paging": false,
    //   "info": false,
    //   "searching": false,
    //   "columnDefs": [{
    //     "targets": [],
    //     className: "hidden"
    //   }, ]
    // });
    var overall_report_view_table = $('#overall_report_view_table').DataTable({
      "ajax": {
        url: "<?php echo base_url() . 'reports/select_overall_profit' ?>", // json datasource
        type: "post", // type of method  , by default would be get
        data: function(d) {
          d.date = GetSearchDate();
            d.project_type = Getprojecttype();
          <?php if (!empty($this->config->item('company_branches'))) { ?>
            d.branch_id = get_branch_id();
          <?php } ?>
        }
      },
      "bProcessing": true,
      "deferRender": true,
      "bDeferRender": true,

      "scrollX": true,
      buttons: [{
          extend: 'print',
          className: 'btn dark btn-outline',
          exportOptions: {
            columns: ':visible'
          },
          title: 'Overall Reports'
        },
        {
          extend: 'csv',
          className: 'btn purple btn-outline '
        },
        {
          extend: 'colvis',
          className: 'btn dark btn-outline',
          text: 'Columns'
        }
      ],
      dom: "<'row'<'col-sm-6 text-left'B><'col-sm-6 text-right'f>>\n\t\t\t<'row'<'col-sm-12'tr>>\n\t\t\t<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 dataTables_pager'lp>>", // horizobtal scrollable datatable
      'order': false,
      "paging": false,
      "info": false,
      "searching": false,
      "columnDefs": [{
        "targets": [],
        className: "hidden"
      }, ]
    });
  }


  // $(".table_filter").on("change", function() {
  //   $("#income_expense_report_div").show();
  //   income_expense_report();
  // });


  $(".hide_column").hide();
</script>
