<?php $this->view("includes/Inc_pagehead");?>
<!-- Page Styles Goes Here-->

<?php $this->view("includes/Inc_navigation");?>
<div class="m-grid__item m-grid__item--fluid m-wrapper">
  <!-- BEGIN: Subheader -->
  <div class="m-subheader ">
    <div class="d-flex align-items-center">
      <div class="mr-auto">
        <h3 class="m-subheader__title m-subheader__title--separator">
          Daily Transaction Reports
        </h3>
        <ul class="m-subheader__breadcrumbs m-nav m-nav--inline">
          <li class="m-nav__item m-nav__item--home">
            <a href="#" class="m-nav__link m-nav__link--icon">
              <i class="m-nav__link-icon la la-home"></i>
            </a>
          </li>
          <li class="m-nav__separator">
            -
          </li>
          <li class="m-nav__item">
            <a href="<?php echo base_url().'dashboard'?>" class="m-nav__link">
              <span class="m-nav__link-text">
                Home
              </span>
            </a>
          </li>
          <li class="m-nav__separator">
            -
          </li>
          <li class="m-nav__item">
            <a href="<?php echo base_url().'reports/daily_transactions' ?>" class="m-nav__link">
              <span class="m-nav__link-text">
                Daily Transaction Reports
              </span>
            </a>
          </li>
        </ul>
      </div>
      <div>
      </div>
    </div>
  </div>
  <!-- END: Subheader -->
  <div class="m-content">
    <div class="m-portlet  m-portlet--rounded m-portlet--bordered">
      <div class="m-portlet__body" style="padding: 1rem 2.2rem;">
        <div class="m-form m-form--label-align-right m--margin-bottom-10">
          <div class="row ">
            <div class="col-xl-12 order-2 order-xl-1">
              <div class="form-group m-form__group row">
                <div class="col-md-6">
                  <div class="form-group m-form__group">
                    <label> Date:</label>
                    <input style="border: none" id="table_filter_date"  type="text" class="form-control  m-input--solid m-input "  >
                  </div>
                </div>
                <div class="col-md-4">
                  <div class="form-group m-form__group">
                    <label> Project:</label>
                    <div class="m-select2 m-select2--air ">
                      <select style="width: 100%" class="form-control m-select2 table_filter" id="table_filter_work"  name="work" data-placeholder="Select Work">
                        <option value="all">All Transactions</option>
                        <?php
                        foreach($work_contracts as $row): ?>
                        <option data-work-status="<?php echo $row->work_status?>" value="<?php echo $row->work_id?>"><?php echo $row->work_name?></option>
                        <?php
                      endforeach;
                      ?>
                    </select>
                  </div>
                  <span class="m-form__help">Note: Labour Wage Transaction Will Not Include When Project is Selected</span>
                </div>
              </div>
              <div class="col-md-2">
                <br/>
                <button style="margin-top: 7px" id="btn_go" class="btn btn-focus m-btn m-btn--custom m-btn--icon m-btn--air m-btn--pill">
                  <span>
                    <i class="la la-search"></i>
                    <span>
                      Go
                    </span>
                  </span>
                </button>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
  <div style="display: none" id="transaction_div" class="m-portlet m-portlet--mobile m-portlet--info m-portlet--head-solid-bg m-portlet--bordered m-portlet--rounded">
    <div class="m-portlet__head">
      <div class="m-portlet__head-caption">
        <div class="m-portlet__head-title">
          <h3 class="m-portlet__head-text">
            Daily Transaction Reports
          </h3>
        </div>
      </div>
      <div class="m-portlet__head-tools">

      </div>
    </div>
    <div class="m-portlet__body">
      <!--begin: Datatable -->
      <table width="100%" class="table m-table nowrap table-header-fixed table-striped table-bordered table-hover table-header-fixed" id="transaction_view_table">
        <thead>
          <tr class="">
            <th>Sl No</th>
            <th>Particulars</th>
            <th>Payable</th>
            <th>Paid</th>
            <th>Balance<br/>(Payable-Paid)</th>
            <th>Receivable</th>
            <th>Received</th>
            <th>Balance<br/>(Receivable-Received)</th>
            <th>Balance<br/>(Received-Paid)</th>
          </tr>
        </thead>
        <tbody id="transaction_view_table_body">
        </tbody>
      </table>
      <!--end: Datatable -->

    </div>
  </div>


</div>
</div>
</div>
<!-- end:: Body -->
<!-- begin::Footer -->

<?php $this->view("includes/Inc_footer");?>
<!-- end::Footer -->
</div>
<!-- end:: Page -->

<?php $this->view("includes/Inc_sidebar");?>
<?php $this->view("includes/Inc_scripts");?>

<!--begin::Page Snippets -->
<script>
$("#report_menu").addClass('m-menu__item--active m-menu__item--open');
$("#report_menu_10").addClass('m-menu__item--active');

$("#table_filter_work").select2({
  placeholder: "Select  Work",
  templateResult: format_project_dropdown
})
// Date Range Picker
var start = moment();
var end = moment();

function cb(start, end) {
  $('#table_filter_date').val(start.format('MMMM D, YYYY') + ' - ' + end.format('MMMM D, YYYY'));
}

$('#table_filter_date').daterangepicker({
  buttonClasses: "m-btn btn",
  applyClass: "btn-primary",
  cancelClass: "btn-secondary",
  startDate: start,
  endDate: end,
  locale: {
    format: 'MMMM D, YYYY'
  },
  ranges: {
    'Today': [moment(), moment()],
    'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
    'Last 7 Days': [moment().subtract(6, 'days'), moment()],
    'Last 30 Days': [moment().subtract(29, 'days'), moment()],
    'This Month': [moment().startOf('month'), moment().endOf('month')],
    'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')],
    'All time': [moment('1970-01-01'), moment().add(9999, 'days')],
  }
}, cb);

cb(start, end);

$('body').on('click', '#btn_go', function() {
  $("#transaction_div").show();
  transaction_table();
})

var transaction_table=function() {
  $('#transaction_view_table').dataTable().fnDestroy();
  function GetSearchDate(){
    return $('#table_filter_date').val();
  }
  function GetSearchwork(){
    return $('#table_filter_work').val();
  }
  $('.table_caption').html("");
  $('#transaction_view_table').append('<caption class="table_caption" style="caption-side: top !important;text-align: center"><strong>Daily Transactions Between '+GetSearchDate()+'</strong></caption>');
  $.post("<?php echo base_url() ?>reports/select_daybook/daily_transactions",{date:GetSearchDate(),work:GetSearchwork()},function(data) {
    $('#transaction_view_table_body').html("");
    var obj = $.parseJSON(data);
    var i=0;
    if(obj.count==1) {
      $('#transaction_view_table_body').append(obj.table_body);
    }
    var table = $('#transaction_view_table').DataTable({
      // "ajax":{
      //     url :"<?php echo base_url().'reports/select_daybook' ?>", // json datasource
      //     type: "post", // type of method  , by default would be get
      //     data: function(d){
      //         d.date = GetSearchDate();
      //     }
      // },
      // "bProcessing": true,
      // "deferRender": true,
      // "bDeferRender": true,
      "scrollX" : true,
      buttons: [
        { extend: 'print', className: 'btn dark btn-outline',exportOptions: {columns: ':visible'},title: 'Daily Transactions' },
        { extend: 'csv', className: 'btn purple btn-outline ' },
        { extend: 'colvis', className: 'btn dark btn-outline', text: 'Columns'}
      ],
      dom:"<'row'<'col-sm-6 text-left'B><'col-sm-6 text-right'f>>\n\t\t\t<'row'<'col-sm-12'tr>>\n\t\t\t<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 dataTables_pager'lp>>", // horizobtal scrollable datatable
      "lengthMenu": [
        [25, 50, 100, -1],
        [25, 50, 100, "All"] // change per page values here
      ],
      // set the initial value
      "pageLength": 25,
      "columnDefs": [
        {
          "targets": [  ],
          className: "hidden"
        }
      ],
      'ordering': false
    });
    $(".hide_column").hide();
  })
}

jQuery(document).ready(function() {
  $(".hidden").hide();

});
</script>
