<?php $this->view("includes/Inc_pagehead");?>
<!-- Page Styles Goes Here-->
<style>
.m-input{
  border: 1px solid #ebedf2 !important;
  background-color: #f4f5f833 !important;
}
#payment_view_table .dataTables_scrollHeadInner {
  width:100% !important;
  padding: 0 !important;
}
.m-form__group{
  padding-top: 10px !important;
  padding-bottom: 10px !important;
}
</style>


<?php $this->view("includes/Inc_navigation");?>
<div class="m-grid__item m-grid__item--fluid m-wrapper">
  <!-- BEGIN: Subheader -->
  <div class="m-subheader ">
    <div class="d-flex align-items-center">
      <div class="mr-auto">
        <h3 class="m-subheader__title m-subheader__title--separator">
          Labour Profile
        </h3>
      </div>
    </div>
  </div>


  <!-- END: Subheader -->
  <div class="m-content">
    <div class="row">
      <div class="col-xl-3 col-lg-4">
        <div class="m-portlet m-portlet--full-height  ">
          <div class="m-portlet__body" style="padding-top: 0px">
            <div class="m-card-profile">
              <div class="m-card-profile__title m--hide">
                Labour Profile
              </div>
              <div class="m-card-profile__pic">
                <div class="m-card-profile__pic-wrapper">
                  <?php
                  if($labour_data->photo!=''){
                    $image =  base_url().'uploads/labours/'.$labour_data->photo;
                  }else{
                    $image =  base_url().'uploads/labours/default.png';
                  }
                  ?>
                  <img src="<?php echo $image?>" alt=""/>
                </div>
              </div>
              <div class="m-card-profile__details">
                <span class="m-card-profile__name">
                  #<?php echo $labour_data->labour_id?> - <?php echo $labour_data->labour_name?>
                </span>
              </div>
              <div class="m-card-profile__details">
                <span class="m-card-profile__name">
                  <?php if($labour_data->labour_type==0){?>
                    <span class="m-badge m-badge-lg m-badge--success m-badge--wide">Individul Labour</span>
                  <?php }else{ ?>
                    <?php if($labour_data->group_position==1){?>
                      <span class="m-badge m-badge-lg m-badge--primary m-badge--wide">Team Head</span>
                    <?php }else{
                      ?>
                      <span class="m-badge m-badge-lg m-badge--focus m-badge--wide">Team Member</span>
                      <?php
                    }
                  } ?>
                </span>
                <br/>
                <?php if($this->session->userdata('user_role')!='auditor' || $this->session->userdata('user_data_permission')['adding']==1) { ?>
                  <?php if($labour_data->labour_type==0 || ($labour_data->labour_type==1 && $labour_data->group_position==0 && $this->config->item('Labour_group_member_payment')==1) || ($labour_data->labour_type==1 && $labour_data->group_position==1)){ ?>
                    <a  data-bill-type="labour"  id="btn_add_bill_payment" href="#bill_payment_add_modal" data-toggle="modal" class="btn m-btn--gradient-from-success m-btn--gradient-to-info  m-btn  m-btn--icon m-btn--air m-btn--pill">
                      <span>
                        <i class="la la-plus"></i>
                        <span>
                          Add Payment
                        </span>
                      </span>
                    </a>
                  <?php } ?>
                <?php } ?>
                <?php if($this->session->userdata('user_role')!='auditor' || $this->session->userdata('user_data_permission')['adding']==1) { ?>
                  <a href="#" style="margin-top:10px" id="btn_add_labour_wage" data-toggle="modal" data-target="#labour_wage_add_modal" class="btn m-btn--gradient-from-warning m-btn--gradient-to-danger  m-btn m-btn--custom m-btn--icon m-btn--air m-btn--pill">
                    <span>
                      <i class="la la-plus"></i>
                      <span>
                        Add Wage Slip
                      </span>
                    </span>
                  </a>
                <?php } ?>
              </div>
              <br/>
            </div>
            <ul class="m-nav m-nav--hover-bg m-portlet-fit--sides">
              <li class="m-nav__separator m-nav__separator--fit" style="margin-top: 0px"></li>
              <li class="m-nav__section m--hide">
                <span class="m-nav__section-text">
                  Section
                </span>
              </li>
              <li class="m-nav__item profile_nav" id="nav_overview" data-nav="overview" data-table-name=''>
                <a href="javascript:;" class="m-nav__link">
                  <i class="m-nav__link-icon fa fa-industry"></i>
                  <span class="m-nav__link-title">
                    <span class="m-nav__link-wrap">
                      <span class="m-nav__link-text">
                        Overview
                      </span>
                    </span>
                  </span>
                </a>
              </li>
              <li class="m-nav__item profile_nav" id="nav_info" data-nav="info" data-table-name=''>
                <a href="javascript:;" class="m-nav__link">
                  <i class="m-nav__link-icon fa fa-info-circle"></i>
                  <span class="m-nav__link-title">
                    <span class="m-nav__link-wrap">
                      <span class="m-nav__link-text">
                        Labour Info
                      </span>
                    </span>
                  </span>
                </a>
              </li>
              <?php if($labour_data->labour_type==1 && $labour_data->group_position==1){?>
                <li class="m-nav__item profile_nav" id="nav_team_members" data-nav="team_members" data-table-name='labour_view_table'>
                  <a href="javascript:;" class="m-nav__link">
                    <i class="m-nav__link-icon fa fa-users"></i>
                    <span class="m-nav__link-title">
                      <span class="m-nav__link-wrap">
                        <span class="m-nav__link-text">
                          Team Members
                        </span>
                      </span>
                    </span>
                  </a>
                </li>
              <?php } ?>
              <li class="m-nav__item profile_nav" id="nav_wage_slips" data-nav="wage_slips" data-table-name='labour_wage_view_table<?php if($labour_data->labour_type==1 && $labour_data->group_position==1){ echo",labour_wage_team_view_table";}?>'>
                <a href="javascript:;" class="m-nav__link">
                  <i class="m-nav__link-icon fa fa-th-list"></i>
                  <span class="m-nav__link-title">
                    <span class="m-nav__link-wrap">
                      <span class="m-nav__link-text">
                        Wage Slips
                      </span>
                    </span>
                  </span>
                </a>
              </li>
              <li class="m-nav__item profile_nav" id="nav_wage_payments" data-nav="wage_payments" data-table-name='labour_wage_transaction_view_table<?php if($labour_data->labour_type==1 && $labour_data->group_position==1){ echo",labour_wage_transaction_team_view_table";}?>'>
                <a href="javascript:;" class="m-nav__link">
                  <i class="m-nav__link-icon la la-money"></i>
                  <span class="m-nav__link-title">
                    <span class="m-nav__link-wrap">
                      <span class="m-nav__link-text">
                        Wage Payments
                      </span>
                    </span>
                  </span>
                </a>
              </li>
              <li class="m-nav__item profile_nav" id="nav_work_summary" data-nav="work_summary" data-table-name='labour_wage_summary_view_table<?php if($labour_data->labour_type==1 && $labour_data->group_position==1){ echo",labour_wage_summary_team_view_table";}?>'>
                <a href="javascript:;" class="m-nav__link">
                  <i class="m-nav__link-icon fa fa-calendar"></i>
                  <span class="m-nav__link-title">
                    <span class="m-nav__link-wrap">
                      <span class="m-nav__link-text">
                        Work Summary
                      </span>
                    </span>
                  </span>
                </a>
              </li>
              <?php if($this->config->item('Labour_labour_insurance_fd')==1){ ?>
                <li class="m-nav__item profile_nav" id="nav_insurance_fd" data-nav="insurance_fd" data-table-name='labour_insurance_fd_payments_view_table'>
                  <a href="javascript:;" class="m-nav__link">
                    <i class="m-nav__link-icon fa fa-wallet"></i>
                    <span class="m-nav__link-title">
                      <span class="m-nav__link-wrap">
                        <span class="m-nav__link-text">
                          Insurance & FD Details
                        </span>
                      </span>
                    </span>
                  </a>
                </li>
              <?php } ?>
            </ul>
          </div>
        </div>
      </div>
      <div class="col-xl-9 col-lg-8">
        <div id="div_overview" class="profile_nav_div">
          <div class="m-portlet">
            <div class="m-portlet__body m-portlet__body--no-padding">
              <div class="row m-row--no-padding m-row--col-separator-xl">
                <?php if($labour_data->labour_type==1 && $labour_data->group_position==1){?>
                  <div  class="col-md-3 col-lg-3 col-xl-3">
                    <div  class="m-widget1">
                      <div class="m-widget1__item">
                        <div class="row m-row--no-padding align-items-center">
                          <div class="col">
                            <h3 class="m-widget1__title">
                              Total Team Members
                            </h3>
                          </div>
                          <div class="col m--align-right">
                            <span class="m-widget1__number m--font-success">
                              <label class="total_team_members_info"></label>
                            </span>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                <?php } ?>
                <div  class="col-md-3 col-lg-3 col-xl-3">
                  <div  class="m-widget1">
                    <div class="m-widget1__item">
                      <div class="row m-row--no-padding align-items-center">
                        <div class="col">
                          <h3 class="m-widget1__title">
                            Total <?php echo ucwords($this->config->item('Labour_wage_calculation_type')) ?>s Worked
                          </h3>
                        </div>
                        <div class="col m--align-right">
                          <span class="m-widget1__number m--font-success">
                            <?php if($labour_data->labour_type==1 && $labour_data->group_position==1){?>
                              <label class="total_days_worked_team_info"></label>
                            <?php }else{?>
                              <label class="total_days_worked_info"></label>
                            <?php } ?>
                          </span>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
                <?php if($labour_data->labour_type==1 && $labour_data->group_position==1){?>
                  <div  class="col-md-3 col-lg-3 col-xl-3">
                    <div  class="m-widget1">
                      <div class="m-widget1__item">
                        <div class="row m-row--no-padding align-items-center">
                          <div class="col">
                            <h3 class="m-widget1__title">
                              No. of Labours Worked
                            </h3>
                          </div>
                          <div class="col m--align-right">
                            <span class="m-widget1__number m--font-success">
                              <label class="total_labours_worked_team_info"></label>
                            </span>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                <?php }else{ ?>
                  <div  class="col-md-3 col-lg-3 col-xl-3"></div>
                  <div  class="col-md-3 col-lg-3 col-xl-3"></div>
                <?php } ?>
                <div  class="col-md-3 col-lg-3 col-xl-3">
                  <div  class="m-widget1">
                    <div class="m-widget1__item">
                      <div class="row m-row--no-padding align-items-center">
                        <div class="col">
                          <h3 class="m-widget1__title">
                            Total Op. Balance
                          </h3>
                        </div>
                        <div class="col m--align-right">
                          <span class="m-widget1__number m--font-success">
                            <?php if($labour_data->labour_type==1 && $labour_data->group_position==1){?>
                              <label class="total_op_balance_team_info"></label>
                            <?php }else{?>
                              <label class="total_op_balance_info"></label>
                            <?php } ?>
                          </span>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
          <div class="m-portlet">
            <div class="m-portlet__body m-portlet__body--no-padding">
              <div class="row m-row--no-padding m-row--col-separator-xl">
                <div  class="col-md-3 col-lg-3 col-xl-3">
                  <div  class="m-widget1">
                    <div class="m-widget1__item">
                      <div class="row m-row--no-padding align-items-center">
                        <div class="col">
                          <h3 class="m-widget1__title">
                            Total Wage Earned
                          </h3>
                        </div>
                        <div class="col m--align-right">
                          <span class="m-widget1__number m--font-success">
                            <?php if($labour_data->labour_type==1 && $labour_data->group_position==1){?>
                              <label class="total_wage_earned_team_info"></label>
                            <?php }else{?>
                              <label class="total_wage_earned_info"></label>
                            <?php } ?>
                          </span>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
                <div  class="col-md-3 col-lg-3 col-xl-3">
                  <div  class="m-widget1">
                    <div class="m-widget1__item">
                      <div class="row m-row--no-padding align-items-center">
                        <div class="col">
                          <h3 class="m-widget1__title">
                            Total To Pay
                          </h3>
                        </div>
                        <div class="col m--align-right">
                          <span class="m-widget1__number m--font-success">
                            <?php if($labour_data->labour_type==1 && $labour_data->group_position==1){?>
                              <label class="total_to_pay_team_info"></label>
                            <?php }else{?>
                              <label class="total_to_pay_info"></label>
                            <?php } ?>
                          </span>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
                <?php if($labour_data->labour_type==0 || ($labour_data->labour_type==1 &&  $this->config->item('Labour_group_member_payment')==1) || ($labour_data->labour_type==1 && $labour_data->group_position==1 && $this->config->item('Labour_group_member_payment')==0)){ ?>
                  <div  class="col-md-3 col-lg-3 col-xl-3">
                    <div  class="m-widget1">
                      <div class="m-widget1__item">
                        <div class="row m-row--no-padding align-items-center">
                          <div class="col">
                            <h3 class="m-widget1__title">
                              Total Paid
                            </h3>
                          </div>
                          <div class="col m--align-right">
                            <span class="m-widget1__number m--font-success">
                              <?php if($labour_data->labour_type==1 && $labour_data->group_position==1){?>
                                <label class="total_paid_team_info"></label>
                              <?php }else{?>
                                <label class="total_paid_info"></label>
                              <?php } ?>
                            </span>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                  <div  class="col-md-3 col-lg-3 col-xl-3">
                    <div  class="m-widget1">
                      <div class="m-widget1__item">
                        <div class="row m-row--no-padding align-items-center">
                          <div class="col">
                            <h3 class="m-widget1__title">
                              Balance to Pay
                            </h3>
                          </div>
                          <div class="col m--align-right">
                            <span class="m-widget1__number m--font-success">
                              <?php if($labour_data->labour_type==1 && $labour_data->group_position==1){?>
                                <label class="total_balance_to_pay_team_info"></label>
                              <?php }else{?>
                                <label class="total_balance_to_pay_info"></label>
                              <?php } ?>
                            </span>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                <?php } ?>
              </div>
            </div>
          </div>
          <?php if($labour_data->labour_type==1 && $labour_data->group_position==1){?>
            <div class="m-portlet  m-portlet--rounded m-portlet--bordered">
              <div class="m-portlet__body">
                <h3 class="m-portlet__head-text" style="text-align: center">
                  Team Summary
                </h3>
                <table width="100%" class="table m-table nowrap table-header-fixed table-striped table-bordered table-hover table-header-fixed" id="all_payments">
                  <thead>
                    <tr class="">
                      <th>Description</th>
                      <th>Details</th>
                    </tr>
                  </thead>
                  <tbody>
                    <tr>
                      <td>Total <?php echo ucwords($this->config->item('Labour_wage_calculation_type')) ?>s Worked</td>
                      <strong><td class="total_days_worked_team_info"></td></strong>
                    </tr>
                    <tr>
                      <td>Total Labours Worked</td>
                      <strong><td class="total_labours_worked_team_info"></td></strong>
                    </tr>
                    <tr>
                      <td>Total Opening Balance</td>
                      <strong><td class="total_op_balance_team_info"></td></strong>
                    </tr>
                    <tr>
                      <td>Total Wage Earned</td>
                      <strong><td class="total_wage_earned_team_info"></td></strong>
                    </tr>
                    <tr>
                      <td>Total To Pay</td>
                      <strong><td class="total_to_pay_team_info"></td></strong>
                    </tr>
                    <tr>
                      <td></td>
                      <td></td>
                    </tr>
                    <tr>
                      <td>Total Paid</td>
                      <strong><td class="total_paid_team_info"></td></strong>
                    </tr>
                    <tr>
                      <td>Balance to Pay</td>
                      <strong><td class="total_balance_to_pay_team_info"></td></strong>
                    </tr>
                  </tbody>
                </table>
              </div>
            </div>
          <?php } ?>
          <?php if($labour_data->labour_type==0 || ($labour_data->labour_type==1 && $labour_data->group_position==0) || ($labour_data->labour_type==1 && $labour_data->group_position==1 && $this->config->item('Labour_group_member_payment')==1)){ ?>
            <div class="m-portlet  m-portlet--rounded m-portlet--bordered">
              <div class="m-portlet__body">
                <h3 class="m-portlet__head-text" style="text-align: center">
                  <?php if($labour_data->labour_type==1 && $labour_data->group_position==1){ echo "Personal"; }?> Summary
                </h3>
                <table width="100%" class="table m-table nowrap table-header-fixed table-striped table-bordered table-hover table-header-fixed" id="all_payments">
                  <thead>
                    <tr class="">
                      <th>Description</th>
                      <th>Details</th>
                    </tr>
                  </thead>
                  <tbody>
                    <tr>
                      <td>Total <?php echo ucwords($this->config->item('Labour_wage_calculation_type')) ?>s Worked</td>
                      <strong><td class="total_days_worked_info"></td></strong>
                    </tr>
                    <tr>
                      <td>Total Opening Balance</td>
                      <strong><td class="total_op_balance_info"></td></strong>
                    </tr>
                    <tr>
                      <td>Total Wage Earned</td>
                      <strong><td class="total_wage_earned_info"></td></strong>
                    </tr>
                    <tr>
                      <td>Total To Pay</td>
                      <strong><td class="total_to_pay_info"></td></strong>
                    </tr>
                    <tr>
                      <td></td>
                      <td></td>
                    </tr>
                    <?php if($labour_data->labour_type==0 || ($labour_data->labour_type==1 && $labour_data->group_position==0 && $this->config->item('Labour_group_member_payment')==1) || ($labour_data->labour_type==1 && $labour_data->group_position==1 && $this->config->item('Labour_group_member_payment')==1)){ ?>
                      <tr>
                        <td>Total Paid</td>
                        <strong><td class="total_paid_info"></td></strong>
                      </tr>
                      <tr>
                        <td>Balance to Pay</td>
                        <strong><td class="total_balance_to_pay_info"></td></strong>
                      </tr>
                    <?php } ?>
                  </tbody>
                </table>
              </div>
            </div>
          <?php } ?>
        </div>
        <div id="div_info" class="profile_nav_div">
          <div class="m-portlet">
            <div class="m-portlet__head">
              <div class="m-portlet__head-caption">
                <div class="m-portlet__head-title">
                  <h3 class="m-portlet__head-text">
                    Labour Info
                  </h3>
                </div>
              </div>
            </div>
            <div class="m-portlet__body">
              <form autocomplete="off" class="m-form m-form--fit m-form--state m-form--label-align-right ">
                <div class="m-portlet__body">
                  <div class="form-group m-form__group row">
                    <div class="col-9 ml-auto">
                      <h4 class="m-form__section">
                        1. Labour Details
                      </h4>
                    </div>
                  </div>
                  <div class="row">
                    <div class="col-lg-6">
                      <div class="form-group m-form__group">
                        <label class="">
                          Labour Name
                        </label>
                        <div class="input-group m-input-group--air">
                          <div class="input-group-prepend">
                            <span class="input-group-text">
                              <i class="fa fa-briefcase "></i>
                            </span>
                          </div>
                          <input disabled type="text" name="name" class="form-control m-input m-input--solid" value="<?php echo $labour_data->labour_name?>">
                        </div>
                      </div>
                    </div>
                    <div class="col-lg-6">
                      <div class="form-group m-form__group ">
                        <label class="">
                          Contact No
                        </label>
                        <div class="input-group m-input-group--air date">
                          <div class="input-group-prepend">
                            <span class="input-group-text">
                              <i class="fa fa-envelope"></i>
                            </span>
                          </div>
                          <input disabled type="text" class="form-control m-input m-input--solid"  value="<?php echo $labour_data->labour_contact?>">
                        </div>
                      </div>
                    </div>
                  </div>
                  <div class="row">
                    <div class="col-lg-6">
                      <div class="form-group m-form__group ">
                        <label class="">
                          Labour Type
                        </label>
                        <div class="input-group m-input-group--air date">
                          <?php if($labour_data->labour_type==0){?>
                            <span class="m-badge m-badge-lg m-badge--success m-badge--wide">Individul Labour</span>
                          <?php }else{ ?>
                            <span class="m-badge m-badge-lg m-badge--info m-badge--wide">Team</span>
                            <?php if($labour_data->group_position==1){?>
                              <span class="m-badge m-badge-lg m-badge--primary m-badge--wide">Team Head</span>
                            <?php }else{
                              ?>
                              <span class="m-badge m-badge-lg m-badge--focus m-badge--wide">Team Member</span>
                              <?php
                            }
                          } ?>
                        </div>
                      </div>
                    </div>
                    <div class="col-lg-6">
                      <div class="form-group m-form__group ">
                        <label class="">
                          Work Type
                        </label>
                        <div class="input-group m-input-group--air date">
                          <div class="input-group-prepend">
                            <span class="input-group-text">
                              <i class="fa fa-envelope"></i>
                            </span>
                          </div>
                          <input  disabled type="text" class="form-control m-input m-input--solid"  value="<?php echo $labour_data->type_name?>">
                        </div>
                      </div>
                    </div>
                  </div>
                  <div class="row">
                    <div class="col-lg-3">
                      <div class="form-group m-form__group ">
                        <label class="">
                          Daily Wage Fixed
                        </label>
                        <div class="input-group m-input-group--air date">
                          <?php if($labour_data->fixed_wage==0){?>
                            <span class="m-badge m-badge-lg m-badge--danger m-badge--wide">No</span>
                          <?php }else{ ?>
                            <span class="m-badge m-badge-lg m-badge--info m-badge--wide">Yes</span>
                          <?php } ?>
                        </div>
                      </div>
                    </div>
                    <?php if($labour_data->fixed_wage==1){?>
                      <div class="col-lg-3">
                        <div class="form-group m-form__group ">
                          <label class="">
                            Basic Wage/<?php echo ucwords($this->config->item('Labour_wage_calculation_type')) ?>
                          </label>
                          <div class="input-group m-input-group--air date">
                            <div class="input-group-prepend">
                              <span class="input-group-text">
                                <?php echo $this->config->item('Currency_currency_format') ?>
                              </span>
                            </div>
                            <input  disabled type="text" class="form-control m-input m-input--solid"  value="<?php echo $this->config->item('currency_format')->formatCurrency($labour_data->daily_wage,$this->config->item('Currency_currency_shortname'))?>">
                          </div>
                        </div>
                      </div>
                      <div class="col-lg-3">
                        <div class="form-group m-form__group ">
                          <label class="">
                            Overtime Rate/hr
                          </label>
                          <div class="input-group m-input-group--air date">
                            <div class="input-group-prepend">
                              <span class="input-group-text">
                                <?php echo $this->config->item('Currency_currency_format') ?>
                              </span>
                            </div>
                            <input  disabled type="text" class="form-control m-input m-input--solid"  value="<?php echo number_format($labour_data->overtime_rate_per_hr,2)?>">
                          </div>
                        </div>
                      </div>
                      <div class="col-lg-3">
                        <div class="form-group m-form__group ">
                          <label class="">
                            TA / Day
                          </label>
                          <div class="input-group m-input-group--air date">
                            <div class="input-group-prepend">
                              <span class="input-group-text">
                                <?php echo $this->config->item('Currency_currency_format') ?>
                              </span>
                            </div>
                            <input  disabled type="text" class="form-control m-input m-input--solid"  value="<?php echo number_format($labour_data->ta_per_day,2)?>">
                          </div>
                        </div>
                      </div>
                    <?php } ?>
                    <div class="col-lg-6">
                      <div class="form-group m-form__group ">
                        <label class="">
                          Opening Balance
                        </label>
                        <div class="input-group m-input-group--air date">
                          <div class="input-group-prepend">
                            <span class="input-group-text">
                              <i class="fa fa-envelope"></i>
                            </span>
                          </div>
                          <input  disabled type="text" class="form-control m-input m-input--solid"  value="<?php echo $labour_data->opening_balance?>">
                        </div>
                      </div>
                    </div>
                    <div class="col-lg-6">
                      <div class="form-group m-form__group ">
                        <label class="">
                          Alernate Contact No
                        </label>
                        <div class="input-group m-input-group--air date">
                          <div class="input-group-prepend">
                            <span class="input-group-text">
                              <i class="fa fa-envelope"></i>
                            </span>
                          </div>
                          <input  disabled type="text" class="form-control m-input m-input--solid"  value="<?php echo $labour_data->labour_contact_2?>">
                        </div>
                      </div>
                    </div>
                    <div class="col-lg-6">
                      <div class="form-group m-form__group ">
                        <label class="">
                          Aadhar No
                        </label>
                        <div class="input-group m-input-group--air date">
                          <div class="input-group-prepend">
                            <span class="input-group-text">
                              <i class="fa fa-envelope"></i>
                            </span>
                          </div>
                          <input  disabled type="text" class="form-control m-input m-input--solid"  value="<?php echo $labour_data->aadhar_no?>">
                        </div>
                      </div>
                    </div>
                    <div class="col-lg-6">
                      <div class="form-group m-form__group ">
                        <label class="">
                          Address
                        </label>
                        <textarea disabled class="form-control  m-input m-input--air m-input--solid" name="address" rows="3"  placeholder="Address"><?php echo $labour_data->address?></textarea>
                      </div>
                    </div>
                  </div>

                  <?php if($labour_data->labour_type==1 && $labour_data->group_position==0){?>
                    <div class="form-group m-form__group row">
                      <div class="col-9 ml-auto">
                        <h4 class="m-form__section">
                          2. Team Head Details
                        </h4>
                      </div>
                    </div>
                    <div class="row">
                      <?php if($labour_head_data->num_rows()==1){?>
                        <div class="col-lg-6">
                          <div class="form-group m-form__group">
                            <label class="">
                              Team Head
                            </label>
                            <div class="input-group m-input-group--air">
                              <div class="input-group-prepend">
                                <span class="input-group-text">
                                  <i class="fa fa-briefcase "></i>
                                </span>
                              </div>
                              <input disabled type="text" name="name" class="form-control m-input m-input--solid" value="<?php echo $labour_head_data->row()->labour_name?>">
                            </div>
                          </div>
                        </div>
                        <div class="col-lg-6">
                          <div class="form-group m-form__group ">
                            <label class="">
                              Contact No
                            </label>
                            <div class="input-group m-input-group--air date">
                              <div class="input-group-prepend">
                                <span class="input-group-text">
                                  <i class="fa fa-envelope"></i>
                                </span>
                              </div>
                              <input disabled type="text"  class="form-control m-input m-input--solid"  value="<?php echo $labour_head_data->row()->labour_contact?>">
                            </div>
                          </div>
                        </div>
                      <?php } ?>
                    </div>
                  <?php } ?>
                </div>

              </form>
            </div>
          </div>
        </div>
        <?php if($labour_data->labour_type==1 && $labour_data->group_position==1){?>
          <div id="div_team_members" class="profile_nav_div">
            <div class="m-portlet m-portlet--mobile m-portlet--info m-portlet--head-solid-bg m-portlet--bordered m-portlet--rounded">
              <div class="m-portlet__head">
                <div class="m-portlet__head-caption">
                  <div class="m-portlet__head-title">
                    <h3 class="m-portlet__head-text">
                      List of Team Members
                    </h3>
                  </div>
                </div>
                <div class="m-portlet__head-tools">

                </div>
              </div>
              <div class="m-portlet__body">
                <!--begin: Datatable -->
                <table width="100%" class="table m-table nowrap table-header-fixed table-striped table-bordered table-hover table-header-fixed" id="labour_view_table">
                  <?php $this->view("modules/include_tables/table_labours");?>
                </table>
                <!--end: Datatable -->
              </div>
            </div>
          </div>
        <?php } ?>
        <div id="div_wage_slips" class="profile_nav_div">
          <div class="m-portlet m-portlet--mobile m-portlet--head-solid-bg m-portlet--bordered m-portlet--rounded">
            <div class="m-form m-form--label-align-right m--margin-bottom-10">
              <div class="row align-items-center">
                <div class="col-xl-12 order-2 order-xl-1">
                  <div class="form-group m-form__group row ">
                    <div class="col-md-4">
                      <div class="m-form__group ">
                        <label>
                          Start Date:
                        </label>
                        <input id="wage_slips_table_filter_start_date" data-date-format="dd-mm-yyyy" placeholder="Start Date" type="text" class="form-control m-input m-input--air m-input--pill table_filter"  >
                      </div>
                    </div>
                    <div class="col-md-4">
                      <div class="m-form__group ">
                        <label>
                          End Date:
                        </label>
                        <input id="wage_slips_table_filter_end_date" data-date-format="dd-mm-yyyy" placeholder="End Date" type="text" class="form-control m-input m-input--air m-input--pill table_filter"  >
                      </div>
                    </div>
                    <div class="col-md-4">
                      <div class="form-group m-form__group">
                        <label>
                          Work:
                        </label>
                        <div class="m-select2 m-select2--air m-select2--pill">
                          <select style="width: 100%" class="form-control m-select2 table_filter" id="wage_slips_table_filter_work"  name="work" data-placeholder="Select Work">
                            <option value="all">All Works</option>
                            <?php
                            foreach($work_contracts as $row): ?>
                            <option data-work-status="<?php echo $row->work_status?>" value="<?php echo $row->work_id?>"><?php echo $row->work_name?></option>
                            <?php
                          endforeach;
                          ?>
                        </select>
                      </div>
                      <span class="m-form__help"></span>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
        <?php if($labour_data->labour_type==1 && $labour_data->group_position==1){?>
          <div class="m-portlet m-portlet--mobile m-portlet--info m-portlet--head-solid-bg m-portlet--bordered m-portlet--rounded">
            <div class="m-portlet__head">
              <div class="m-portlet__head-caption">
                <div class="m-portlet__head-title">
                  <h3 class="m-portlet__head-text">
                    List of All Wage Slips
                  </h3>
                </div>
              </div>
              <div class="m-portlet__head-tools">
                <?php if($this->session->userdata('user_role')!='auditor' || $this->session->userdata('user_data_permission')['adding']==1) { ?>
                  <a href="<?php echo base_url()?>labour_wages/add_group/<?php echo $labour_data->labour_id?>" style="margin-right: 10px" class="btn btn-danger m-btn m-btn--custom m-btn--icon m-btn--air m-btn--pill">
                    <span>
                      <i class="la la-plus"></i>
                      <span>
                        Add Wage Slip (Group)
                      </span>
                    </span>
                  </a>
                  <a href="#" data-toggle="modal" id="btn_add_labour_wage" data-target="#labour_wage_add_modal" class="btn btn-focus m-btn m-btn--custom m-btn--icon m-btn--air m-btn--pill">
                    <span>
                      <i class="la la-plus"></i>
                      <span>
                        Add Wage Slip (Individual)
                      </span>
                    </span>
                  </a>
                <?php } ?>
              </div>
            </div>
            <div class="m-portlet__body">
              <!--begin: Datatable -->
              <?php $this->view("modules/include_tables/table_labour_wage_slips_team");?>
              <!--end: Datatable -->
            </div>
          </div>
        <?php } ?>
        <div class="m-portlet m-portlet--mobile m-portlet--info m-portlet--head-solid-bg m-portlet--bordered m-portlet--rounded">
          <div class="m-portlet__head">
            <div class="m-portlet__head-caption">
              <div class="m-portlet__head-title">
                <h3 class="m-portlet__head-text">
                  List of <?php if($labour_data->labour_type==1 && $labour_data->group_position==1){ echo "Personal"; }?> Wage Slips
                </h3>
              </div>
            </div>
            <div class="m-portlet__head-tools">
              <?php if($this->session->userdata('user_role')!='auditor' || $this->session->userdata('user_data_permission')['adding']==1) { ?>
                <a href="#" id="btn_add_labour_wage" data-toggle="modal" data-target="#labour_wage_add_modal" class="btn btn-focus m-btn m-btn--custom m-btn--icon m-btn--air m-btn--pill">
                  <span>
                    <i class="la la-plus"></i>
                    <span>
                      Add Wage Slip (Individual)
                    </span>
                  </span>
                </a>
              <?php } ?>
            </div>
          </div>
          <div class="m-portlet__body">
            <!--begin: Datatable -->
            <?php $this->view("modules/include_tables/table_labour_wage_slips");?>
            <!--end: Datatable -->
          </div>
        </div>
      </div>
      <div id="div_wage_payments" class="profile_nav_div">

        <div class="m-portlet m-portlet--mobile m-portlet--head-solid-bg m-portlet--bordered m-portlet--rounded">
          <div class="m-form m-form--label-align-right m--margin-bottom-10">
            <div class="row align-items-center">
              <div class="col-xl-12 order-2 order-xl-1">
                <div class="form-group m-form__group row ">
                  <div class="col-md-4">
                    <div class="m-form__group ">
                      <label>
                        Start Date:
                      </label>
                      <input id="wage_payments_table_filter_start_date" data-date-format="dd-mm-yyyy" placeholder="Start Date" type="text" class="form-control m-input m-input--air m-input--pill table_filter"  >
                    </div>
                  </div>
                  <div class="col-md-4">
                    <div class="m-form__group ">
                      <label>
                        End Date:
                      </label>
                      <input id="wage_payments_table_filter_end_date" data-date-format="dd-mm-yyyy" placeholder="End Date" type="text" class="form-control m-input m-input--air m-input--pill table_filter"  >
                    </div>
                  </div>

                </div>
              </div>
            </div>
          </div>
        </div>

        <?php if($labour_data->labour_type==1 && $labour_data->group_position==1){?>
          <div class="m-portlet m-portlet--mobile m-portlet--info m-portlet--head-solid-bg m-portlet--bordered m-portlet--rounded">
            <div class="m-portlet__head">
              <div class="m-portlet__head-caption">
                <div class="m-portlet__head-title">
                  <h3 class="m-portlet__head-text">
                    List of All Wage Payments
                  </h3>
                </div>
              </div>
              <div class="m-portlet__head-tools">
                <?php if($this->session->userdata('user_role')!='auditor' || $this->session->userdata('user_data_permission')['adding']==1) { ?>
                  <a data-bill-type="labour"  id="btn_add_bill_payment" href="#bill_payment_add_modal" data-toggle="modal" class="btn btn-focus m-btn m-btn--custom m-btn--icon m-btn--air m-btn--pill">
                    <span>
                      <i class="la la-plus"></i>
                      <span>
                        Add New Payment
                      </span>
                    </span>
                  </a>
                <?php } ?>
              </div>
            </div>
            <div class="m-portlet__body">
              <?php $this->view("modules/include_tables/table_labour_wage_transaction_team");?>
            </div>
          </div>
        <?php } ?>
        <div class="m-portlet m-portlet--mobile m-portlet--info m-portlet--head-solid-bg m-portlet--bordered m-portlet--rounded">
          <div class="m-portlet__head">
            <div class="m-portlet__head-caption">
              <div class="m-portlet__head-title">
                <h3 class="m-portlet__head-text">
                  List of <?php if($labour_data->labour_type==1 && $labour_data->group_position==1){ echo "Personal"; }?> Wage Payments
                </h3>
              </div>
            </div>
            <div class="m-portlet__head-tools">
              <?php if($this->session->userdata('user_role')!='auditor' || $this->session->userdata('user_data_permission')['adding']==1) { ?>
                <a data-bill-type="labour"  id="btn_add_bill_payment" href="#bill_payment_add_modal" data-toggle="modal" class="btn btn-focus m-btn m-btn--custom m-btn--icon m-btn--air m-btn--pill">
                  <span>
                    <i class="la la-plus"></i>
                    <span>
                      Add New Payment
                    </span>
                  </span>
                </a>
              <?php } ?>
            </div>
          </div>
          <div class="m-portlet__body">
            <?php $this->view("modules/include_tables/table_labour_wage_transaction");?>
          </div>
        </div>
      </div>
      <div id="div_work_summary" class="profile_nav_div">
        <?php if($labour_data->labour_type==1 && $labour_data->group_position==1){?>
          <div class="m-portlet m-portlet--mobile m-portlet--info m-portlet--head-solid-bg m-portlet--bordered m-portlet--rounded">
            <div class="m-portlet__head">
              <div class="m-portlet__head-caption">
                <div class="m-portlet__head-title">
                  <h3 class="m-portlet__head-text">
                    Labour Wage Summary (All)
                  </h3>
                </div>
              </div>
              <div class="m-portlet__head-tools">
              </div>
            </div>
            <div class="m-portlet__body">
              <?php $this->view("modules/include_tables/table_labour_wage_summary_team");?>
            </div>
          </div>
        <?php } ?>
        <div class="m-portlet m-portlet--mobile m-portlet--info m-portlet--head-solid-bg m-portlet--bordered m-portlet--rounded">
          <div class="m-portlet__head">
            <div class="m-portlet__head-caption">
              <div class="m-portlet__head-title">
                <h3 class="m-portlet__head-text">
                  Labour Wage Summary <?php if($labour_data->labour_type==1 && $labour_data->group_position==1){ echo "(Personal)"; }?>
                </h3>
              </div>
            </div>
            <div class="m-portlet__head-tools">
            </div>
          </div>
          <div class="m-portlet__body">
            <?php $this->view("modules/include_tables/table_labour_wage_summary");?>
          </div>
        </div>
      </div>
      <div id="div_insurance_fd" class="profile_nav_div">
        <div class="m-portlet  m-portlet--rounded m-portlet--bordered">
          <div class="m-portlet__body">
            <h3 class="m-portlet__head-text" style="text-align: center">
              Insurance & FD Summary
            </h3>
            <table width="100%" class="table m-table nowrap table-header-fixed table-striped table-bordered table-hover table-header-fixed" id="all_payments">
              <thead>
                <tr class="">
                  <th>Description</th>
                  <th>Details</th>
                </tr>
              </thead>
              <tbody>
                <tr>
                  <td>Total <?php echo ucwords($this->config->item('Labour_wage_calculation_type')) ?>s Worked</td>
                  <strong><td class="total_days_worked_insurance_fd"></td></strong>
                </tr>
                <tr>
                  <td></td>
                  <td></td>
                </tr>
                <tr>
                  <td>Total Insurance Payable (Per <?php echo ucwords($this->config->item('Labour_wage_calculation_type')) ?> - <?php echo ucwords($this->config->item('Labour_labour_insurance_amount')) ?> )</td>
                  <strong><td class="total_insurance_payable"></td></strong>
                </tr>
                <tr>
                  <td>Total Insurance Paid</td>
                  <strong><td class="total_insurance_paid"></td></strong>
                </tr>
                <tr>
                  <td style="font-weight:600">Total Insurance Balance</td>
                  <strong><td style="font-weight:600" class="total_insurance_balance"></td></strong>
                </tr>
                <tr>
                  <td></td>
                  <td></td>
                </tr>
                <tr>
                  <td>Total FD Payable (Per <?php echo ucwords($this->config->item('Labour_wage_calculation_type')) ?> - <?php echo ucwords($this->config->item('Labour_labour_fd_amount')) ?> )</td>
                  <strong><td class="total_fd_payable"></td></strong>
                </tr>
                <tr>
                  <td>Total FD Paid</td>
                  <strong><td class="total_fd_paid"></td></strong>
                </tr>
                <tr>
                  <td style="font-weight:600">Total FD Balance</td>
                  <strong><td style="font-weight:600" class="total_fd_balance"></td></strong>
                </tr>
              </tbody>
            </table>
          </div>
        </div>
        <div class="m-portlet m-portlet--mobile m-portlet--info m-portlet--head-solid-bg m-portlet--bordered m-portlet--rounded">
          <div class="m-portlet__head">
            <div class="m-portlet__head-caption">
              <div class="m-portlet__head-title">
                <h3 class="m-portlet__head-text">
                  Insurance & FD Payments
                </h3>
              </div>
            </div>
            <div class="m-portlet__head-tools">
              <?php if($this->session->userdata('user_role')!='auditor' || $this->session->userdata('user_data_permission')['adding']==1) { ?>
                <a  id="btn_add_insurance_fd_payment" href="#insurance_fd_payment_add_modal" data-toggle="modal" class="btn btn-focus m-btn m-btn--custom m-btn--icon m-btn--air m-btn--pill">
                  <span>
                    <i class="la la-plus"></i>
                    <span>
                      Add New Payment
                    </span>
                  </span>
                </a>
              <?php } ?>
            </div>
          </div>
          <div class="m-portlet__body">
            <?php $this->view("modules/include_tables/table_labour_insurance_fd");?>
          </div>
        </div>
      </div>
    </div>
    <?php $this->view("modules/include_modals/modal_bills");?>
    <?php $this->view("modules/include_modals/modal_transaction_delete");?>
  </div>
</div>
</div>
</div>
<!-- end:: Body -->
<!-- begin::Footer -->
<?php $this->view("includes/Inc_footer");?>
<!-- end::Footer -->
</div>
<!-- end:: Page -->
<?php $this->view("includes/Inc_sidebar");?>
<?php $this->view("includes/Inc_scripts");?>

<!--begin::Page Snippets -->
<script src="<?php echo $this->config->item('Template_template_file_url'); ?>template/assets/app/js/dashboard.js" type="text/javascript"></script>
<!--end::Page Snippets -->
<?php $this->view("modules/include_scripts/bill_scripts");?>
<?php $this->view("modules/include_scripts/transaction_scripts");?>
<?php $this->view("modules/include_scripts/labour_wage_scripts");?>
<?php $this->view("modules/include_scripts/labour_view_scripts");?>
<?php $this->view("modules/include_scripts/labour_insurance_fd_scripts");?>
<script>
$('#labour_wage_add_modal').on('shown.bs.modal', function() {
  $('#labour_wage_add_modal').appendTo(document.body);
});
function hide_all(){
  $(".profile_nav").removeClass('m-nav__item--active');
  $(".profile_nav_div").hide();
}
function active(menu_name){
  hide_all();
  $("#nav_"+menu_name).addClass('m-nav__item--active');
  $("#div_"+menu_name).show();
  $("#div_"+menu_name).fadeIn("slow");
  $('html, body').animate({
    scrollTop: eval($("#div_"+menu_name).offset().top - 150)
  }, 500);
}
//  Hide All Div and In Active All Menu
hide_all();
//  Active First Menu and Its div
active('overview');
$('body').on('click', '.profile_nav', function() {
  var nav = $(this).attr('data-nav');
  active(nav);
})
</script>
<script>
$('body').on('click', '#btn_add_bill_payment', function() {
  $('#labour_add_bill_payment').val("<?php echo $labour_data->labour_id?>").trigger('change');
})
$('body').on('click', '#btn_add_labour_wage', function() {
  $('#labour_wage_labour_add').val("<?php echo $labour_data->labour_id?>").trigger('change');
})

$("#wage_slips_table_filter_start_date,#wage_slips_table_filter_end_date,#wage_payments_table_filter_start_date,#wage_payments_table_filter_end_date").datepicker( {
  todayHighlight:!0,
  orientation:"bottom right",
  templates: {
    leftArrow: '<i class="la la-angle-left"></i>',
    rightArrow: '<i class="la la-angle-right"></i>',
  },
  autoclose: true,
})

$("#wage_slips_table_filter_work,#wage_payments_table_filter_work").select2({
  placeholder: "Select Work",
  templateResult: format_project_dropdown
})

$("#m_aside_left_minimize_toggle").addClass("m-brand__toggler--active");
$("#body").addClass("m-brand--minimize m-aside-left--minimize");

$("#labour_menu").addClass('m-menu__item--active m-menu__item--open');
$("#labour_menu_1").addClass('m-menu__item--active');

select_summary();
function select_summary(){
  var labour_id = "<?php echo $labour_data->labour_id?>";
  $.post("<?php echo base_url().'labours/select_details/summary' ?>",{
    labour_id:labour_id
  },function(data){
    var obj= $.parseJSON(data);
    $(".total_days_worked_info").html(obj.total_work_days);
    $(".total_op_balance_info").html(obj.opening_balance);
    $(".total_wage_earned_info").html(obj.total_wage_earned);
    $(".total_to_pay_info").html(obj.total_to_pay);
    $(".total_paid_info").html(obj.total_paid);
    $(".total_balance_to_pay_info").html(obj.current_balance);
    <?php if($this->config->item('Labour_labour_insurance_fd')==1){ ?>
      $(".total_days_worked_insurance_fd").html(obj.total_work_days_2);
      var total_days_worked = parseFloat(obj.total_work_days_2);
      var insurance_per_day = parseFloat("<?php echo $this->config->item('Labour_labour_insurance_amount') ?>");
      var fd_per_day = parseFloat("<?php echo $this->config->item('Labour_labour_fd_amount') ?>");
      var insurance_payable = insurance_per_day*total_days_worked;
      var fd_payable = fd_per_day*total_days_worked;
      var insurance_paid = parseFloat(obj.total_insurance_paid);
      var fd_paid = parseFloat(obj.total_fd_paid);
      $(".total_insurance_payable").html(insurance_payable);
      $(".total_fd_payable").html(fd_payable);
      $(".total_insurance_paid").html(insurance_paid);
      $(".total_fd_paid").html(fd_paid);
      $(".total_insurance_balance").html(insurance_payable-insurance_paid);
      $(".total_fd_balance").html(fd_payable-fd_paid);
    <?php } ?>
  })
  <?php if($labour_data->labour_type==1 && $labour_data->group_position==1){?>
    $.post("<?php echo base_url().'labours/select_group_details/summary' ?>",{
      labour_group_head:labour_id
    },function(data){
      var obj= $.parseJSON(data);
      $(".total_team_members_info").html(obj.total_labours);
      $(".total_labours_worked_info").html(obj.total_labours_worked);

      $(".total_days_worked_team_info").html(obj.total_work_days);
      $(".total_op_balance_team_info").html(obj.opening_balance);
      $(".total_wage_earned_team_info").html(obj.total_wage_earned);
      $(".total_to_pay_team_info").html(obj.total_to_pay);
      $(".total_paid_team_info").html(obj.total_paid);
      $(".total_balance_to_pay_team_info").html(obj.current_balance);

    })
    <?php } ?>
  }

</script>

<script>
var labour_id = "<?php echo $labour_data->labour_id?>";

$(".table_filter").on("change", function() {
  labour_wage_view_table.ajax.reload();
  labour_wage_summary_view_table.ajax.reload();
  labour_wage_transaction_view_table.ajax.reload();
  <?php if($labour_data->labour_type==1 && $labour_data->group_position==1){?>
    labour_view_table.ajax.reload();
    labour_wage_team_view_table.ajax.reload();
    labour_wage_summary_team_view_table.ajax.reload();
    labour_wage_transaction_team_view_table.ajax.reload();
    <?php } ?>
  });
  $(".hide_column").hide();
  $('.profile_nav').on('click', function(e){
    var table_name = $(this).attr('data-table-name');
    if(table_name!=''){
      var tables = table_name.split(',');
      $.each(tables, function( index, value ){
        var table_name = value;
        eval(table_name).ajax.reload();
      });
    }
  });
  $(".form_submit_btn").click(function (e) {
    e.preventDefault();
    var a = $(this),
    l = $(this).closest("form"),
    action = l.attr('action');
    var form_id = l.attr('id');
    l.validate({
      rules: {
        work_1: {
          required: !0
        },
        report_date: {
          required: !0
        },
        payment: {
          number: !0,
          required: !0
        },
        paid_amount: {
          number: !0,
          required: !0
        },
        expense_amount: {
          number: !0,
          required: !0
        },
        received_amount: {
          number: !0,
          required: !0
        },
        budget: {
          number: !0,
          required: !0
        },
        edit_paid_amount: {
          number: !0,
          required: !0
        }
      }, invalidHandler: function (e, r) {
        var i = $("#" + form_id + "_msg");
        i.removeClass("m--hide").show(), mUtil.scrollTo(i, -200)
      }, submitHandler: function (e) {
      }
    }), l.valid() && (a.addClass("m-loader m-loader--right m-loader--light").attr("disabled", !0),
    l.ajaxSubmit({
      url: action,
      success: function (e, t, r, s) {
        var modal_id = l.attr('data-modal-id');
        var form_type = l.attr('data-form-type');
        $("#" + form_id + "_msg").addClass("m--hide");
        // Block UI
        mApp.blockPage({
          overlayColor: "#000000",
          type: "loader",
          state: "success",
          message: "Please wait..."
        }), setTimeout(function () {
          mApp.unblockPage()
        }, 2e3);
        var obj = $.parseJSON(e);
        if (obj.status == 1) {
          a.removeClass("m-loader m-loader--right m-loader--light").attr("disabled", !1);
          toastr["success"](obj.message, "Success");
          $("#"+modal_id).modal('toggle');
          $("."+form_id+"_fields").val('');
          $("."+form_id+"_select").val('').trigger("change");
          select_summary();
          labour_wage_view_table.ajax.reload();
          labour_wage_summary_view_table.ajax.reload();
          labour_wage_transaction_view_table.ajax.reload();
          labour_insurance_fd_payments_view_table.ajax.reload();
          <?php if($labour_data->labour_type==1 && $labour_data->group_position==1){?>
            labour_view_table.ajax.reload();
            labour_wage_team_view_table.ajax.reload();
            labour_wage_summary_team_view_table.ajax.reload();
            labour_wage_transaction_team_view_table.ajax.reload();
            <?php } ?>
          } else {
            a.removeClass("m-loader m-loader--right m-loader--light").attr("disabled", !1);
            if (obj.status == 2) {
              toastr["warning"](obj.message, "Duplication");
            }else{
              toastr["error"](obj.message, "Error");
            }
          }
          if (obj == null) {
            setTimeout(function () {
              a.removeClass("m-loader m-loader--right m-loader--light").attr("disabled", !1);
              toastr["warning"]("Your Attempt is Timed Out. Please Try Again.", "Timed Out");
            }, 2e4)
          }
        },error: function() {
          a.removeClass("m-loader m-loader--right m-loader--light").attr("disabled", !1);
          toastr["error"]("Sorry. There Has Been Some Error Occurred. Please Try Again.", "Error");
        }
      })
    )
  });
  jQuery(document).ready(function() {
    $($.fn.dataTable.tables(true)).DataTable()
    .columns.adjust()
    .responsive.recalc();
  }
);
</script>
