<?php $this->view("includes/Inc_pagehead");?>
<!-- Page Styles Goes Here-->

<?php $this->view("includes/Inc_navigation");?>
<div class="m-grid__item m-grid__item--fluid m-wrapper">
  <!-- BEGIN: Subheader -->
  <div class="m-subheader ">
    <div class="d-flex align-items-center">
      <div class="mr-auto">
        <h3 class="m-subheader__title m-subheader__title--separator">
          Labour Monthly Salary Sheet
        </h3>
        <ul class="m-subheader__breadcrumbs m-nav m-nav--inline">
          <li class="m-nav__item m-nav__item--home">
            <a href="#" class="m-nav__link m-nav__link--icon">
              <i class="m-nav__link-icon la la-home"></i>
            </a>
          </li>
          <li class="m-nav__separator">
            -
          </li>
          <li class="m-nav__item">
            <a href="<?php echo base_url().'dashboard'?>" class="m-nav__link">
              <span class="m-nav__link-text">
                Home
              </span>
            </a>
          </li>
          <li class="m-nav__separator">
            -
          </li>
          <li class="m-nav__item">
            <a href="<?php echo base_url().'labour_wages/monthly_summary' ?>" class="m-nav__link">
              <span class="m-nav__link-text">
                Labour Monthly Salary Sheet
              </span>
            </a>
          </li>
        </ul>
      </div>
      <div>
      </div>
    </div>
  </div>
  <!-- END: Subheader -->
  <div class="m-content">
    <div class="m-portlet  m-portlet--rounded m-portlet--bordered">
      <div class="m-portlet__body" style="padding: 1rem 2.2rem;">
        <div class="m-form m-form--label-align-right m--margin-bottom-10">
          <div class="row ">
            <div class="col-xl-12 order-2 order-xl-1">
              <div class="form-group m-form__group row">
                <div class="col-md-3">
                  <div class="form-group m-form__group">
                    <label for="user_name">
                      Month
                    </label>
                    <div class="input-group m-input-group--air m-input-group--pill  date">
                      <input value="<?php echo date('M Y')?>"  data-date-format="mm-yyyy" id="table_filter_month"  type="text"  class="form-control  m-input table_filter" placeholder="Start Month" >
                    </div>
                  </div>
                </div>
                <div class="col-md-4">
                  <div class="form-group m-form__group">
                    <label>
                      Labour:
                    </label>
                    <div class="m-select2 m-select2--air m-select2--pill">
                      <select style="width: 100%" class="form-control m-select2 table_filter" id="table_filter_labour"  >
                        <option value="all">All Labours</option>
                        <?php
                        foreach($labours as $row): ?>
                        <option value="<?php echo $row->labour_id?>"><?php echo $row->labour_name." [".$row->type_name."]"?></option>
                        <?php
                      endforeach;
                      ?>
                    </select>
                  </div>
                  <span class="m-form__help"></span>
                </div>
              </div>
              <div class="col-md-1">
                <br/>
                <button style="margin-top: 7px" id="btn_go" class="btn btn-focus m-btn m-btn--custom m-btn--icon m-btn--air m-btn--pill">
                  <span>
                    <i class="la la-search"></i>
                    <span>
                      Go
                    </span>
                  </span>
                </button>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
  <div style="display: none" id="report_div" class="m-portlet m-portlet--mobile m-portlet--info m-portlet--head-solid-bg m-portlet--bordered m-portlet--rounded">
    <div class="m-portlet__head">
      <div class="m-portlet__head-caption">
        <div class="m-portlet__head-title">
          <h3 class="m-portlet__head-text">
            Labour Monthly Salary Sheet
          </h3>
        </div>
      </div>
      <div class="m-portlet__head-tools">

      </div>
    </div>
    <div class="m-portlet__body">
      <!--begin: Datatable -->
      <table width="100%" class="table m-table nowrap table-header-fixed table-striped table-bordered table-hover table-header-fixed" id="labour_monthly_summary_view_table">
        <thead>
          <tr class="">
            <th>Labour Id</th>
            <th>Labour Name</th>
            <th>Contact</th>
            <th>Work Type</th>
            <th>Basic Wage/<?php echo ucwords($this->config->item('Labour_wage_calculation_type')) ?></th>
            <th>Op. Balance</th>
            <th>Total Worked <?php echo ucwords($this->config->item('Labour_wage_calculation_type')) ?>s</th>
            <th>Total Overtime Hrs</th>
            <th>Total Basic Wage</th>
            <th>Total Overtime Wage</th>
            <th>Total Extra Wage</th>
            <th>Total Wage to Pay</th>
            <th>Total Paid</th>
            <th>Total Balance</th>
            <th>Actions</th>
            <th>Payment Status</th>
          </tr>
        </thead>
        <tbody id="report_view_table_body">
        </tbody>
      </table>
    </div>
  </div>
</div>
</div>
</div>
<!-- end:: Body -->
<!-- begin::Footer -->

<?php $this->view("includes/Inc_footer");?>
<!-- end::Footer -->
</div>
<!-- end:: Page -->

<?php $this->view("includes/Inc_sidebar");?>
<?php $this->view("includes/Inc_scripts");?>

<!--begin::Page Snippets -->
<script>
$("#labour_menu").addClass('m-menu__item--active m-menu__item--open');
$("#labour_menu_5").addClass('m-menu__item--active');

$("#table_filter_month").datepicker( {
  todayHighlight:!0, orientation:"bottom left",format: "M yyyy",viewMode: "months", minViewMode: "months", templates: {
    leftArrow: '<i class="la la-angle-left"></i>', rightArrow: '<i class="la la-angle-right"></i>'
  }
})
$("#table_filter_labour").select2({
  placeholder: "Select Labour"
})

$('body').on('click', '#btn_go', function() {
  $("#report_div").show();
  labour_monthly_summary_view_table();
})

var labour_monthly_summary_view_table=function() {
  $('#labour_monthly_summary_view_table').dataTable().fnDestroy();
  function GetSearchMonth(){
    return $('#table_filter_month').val();
  }
  function GetSearchLabour(){
    return $('#table_filter_labour').val();
  }
  var labour_monthly_summary_view_table = $('#labour_monthly_summary_view_table').DataTable({
    "ajax":{
      url :"<?php echo base_url().'labours/select_labour_payment_summary' ?>", // json datasource
      type: "post", // type of method  , by default would be get
      data: function(d){
        d.labour = GetSearchLabour();
        d.month = GetSearchMonth();
      }
    },
    "bProcessing": true,
    "deferRender": true,
    "bDeferRender": true,
    "scrollX" : true,
    buttons: [
      { extend: 'print', className: 'btn dark btn-outline',exportOptions: {columns: ':visible'},title: 'Labour Payment Summary' },
      { extend: 'csv', className: 'btn purple btn-outline ' },
      { extend: 'colvis', className: 'btn dark btn-outline', text: 'Columns'}
    ],
    dom:"<'row'<'col-sm-6 text-left'B><'col-sm-6 text-right'f>>\n\t\t\t<'row'<'col-sm-12'tr>>\n\t\t\t<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 dataTables_pager'lp>>", // horizobtal scrollable datatable
    "lengthMenu": [
      [25, 50, 100, -1],
      [25, 50, 100, "All"] // change per page values here
    ],
    // set the initial value
    "pageLength": 25,
    "columnDefs": [
      {
        "targets": [ 2,3,14,15 ],
        className: "hidden"
      }
    ],
    'order': [[0, 'desc']],
  });
  $(".hide_column").hide();
}

jQuery(document).ready(function() {
  $(".hidden").hide();

});
</script>
