<?php $this->view("includes/Inc_pagehead");?>
<!-- Page Styles Goes Here-->

<?php $this->view("includes/Inc_navigation");?>
<div class="m-grid__item m-grid__item--fluid m-wrapper">
  <!-- BEGIN: Subheader -->
  <div class="m-subheader ">
    <div class="d-flex align-items-center">
      <div class="mr-auto">
        <h3 class="m-subheader__title m-subheader__title--separator">
          Labour Insurance & FD
        </h3>
        <ul class="m-subheader__breadcrumbs m-nav m-nav--inline">
          <li class="m-nav__item m-nav__item--home">
            <a href="#" class="m-nav__link m-nav__link--icon">
              <i class="m-nav__link-icon la la-home"></i>
            </a>
          </li>
          <li class="m-nav__separator">
            -
          </li>
          <li class="m-nav__item">
            <a href="<?php echo $this->session->userdata("dashboard_link")?>" class="m-nav__link">
              <span class="m-nav__link-text">
                Home
              </span>
            </a>
          </li>
          <li class="m-nav__separator">
            -
          </li>
          <li class="m-nav__item">
            <a href="<?php echo base_url().'labours/insurance_fd' ?>" class="m-nav__link">
              <span class="m-nav__link-text">
              Labour Insurance & FD
              </span>
            </a>
          </li>


        </ul>
      </div>
      <div>

      </div>
    </div>
  </div>
  <!-- END: Subheader -->
  <div class="m-content">
    <div class="m-portlet m-portlet--mobile m-portlet--info m-portlet--head-solid-bg m-portlet--bordered m-portlet--rounded">
      <div class="m-portlet__head">
        <div class="m-portlet__head-caption">
          <div class="m-portlet__head-title">
            <h3 class="m-portlet__head-text">
              Labour Insurance & FD Transactions
            </h3>
          </div>
        </div>
        <div class="m-portlet__head-tools">
          <?php if($this->session->userdata('user_role')!='auditor' || $this->session->userdata('user_data_permission')['adding']==1) { ?>
            <a  id="btn_add_insurance_fd_payment" href="#insurance_fd_payment_add_modal" data-toggle="modal" class="btn btn-focus m-btn m-btn--custom m-btn--icon m-btn--air m-btn--pill">
              <span>
                <i class="la la-plus"></i>
                <span>
                  Add New Payment
                </span>
              </span>
            </a>
          <?php } ?>
        </div>
      </div>
      <div class="m-portlet__body">
        <!--begin: Datatable -->
        <?php $this->view("modules/include_tables/table_labour_insurance_fd");?>
        <!--end: Datatable -->
      </div>
    </div>
    <div class="m-portlet m-portlet--mobile m-portlet--info m-portlet--head-solid-bg m-portlet--bordered m-portlet--rounded">
      <div class="m-portlet__head">
        <div class="m-portlet__head-caption">
          <div class="m-portlet__head-title">
            <h3 class="m-portlet__head-text">
              Labour Insurance & FD Summary
            </h3>
          </div>
        </div>
        <div class="m-portlet__head-tools">
          <?php if($this->session->userdata('user_role')!='auditor' || $this->session->userdata('user_data_permission')['adding']==1) { ?>
            <a  id="btn_add_insurance_fd_payment" href="#insurance_fd_payment_add_modal" data-toggle="modal" class="btn btn-focus m-btn m-btn--custom m-btn--icon m-btn--air m-btn--pill">
              <span>
                <i class="la la-plus"></i>
                <span>
                  Add New Payment
                </span>
              </span>
            </a>
          <?php } ?>
        </div>
      </div>
      <div class="m-portlet__body">
        <table width="100%" class="table m-table nowrap table-header-fixed table-striped table-bordered table-hover table-header-fixed" id="labour_insurance_fd_summary_view_table">
          <thead>
            <tr class="">
              <th>Sl No</th>
              <th>ID</th>
              <th>Labour Name</th>
              <th>Work Type</th>
              <th>Total <?php echo ucwords($this->config->item('Labour_wage_calculation_type')) ?>s Worked</th>
              <th>Total Insurance Payable<br/> <?php echo $this->config->item('Currency_currency_format')." ".$this->config->item('Labour_labour_insurance_amount') ?>/ Day</th>
              <th>Total Insurance Paid</th>
              <th>Total Insurance Balance</th>
              <th>Total FD Payable<br/> <?php echo $this->config->item('Currency_currency_format')." ".$this->config->item('Labour_labour_fd_amount') ?>/ Day</th>
              <th>Total FD Paid</th>
              <th>Total FD Balance</th>
              <th>Actions</th>
            </tr>
          </thead>
          <tbody>
          </tbody>
        </table>
      </div>
    </div>
    <?php $this->view("modules/include_modals/modal_bills");?>
    <?php $this->view("modules/include_modals/modal_transaction_delete");?>
  </div>
</div>
</div>
<!-- end:: Body -->
<!-- begin::Footer -->

<?php $this->view("includes/Inc_footer");?>
<!-- end::Footer -->
</div>
<!-- end:: Page -->

<?php $this->view("includes/Inc_sidebar");?>
<?php $this->view("includes/Inc_scripts");?>
<!--begin::Page Snippets -->
<?php $this->view("modules/include_scripts/bill_scripts");?>
<?php $this->view("modules/include_scripts/transaction_scripts");?>
<?php $this->view("modules/include_scripts/labour_insurance_fd_scripts");?>

<script>
  $("#labour_menu").addClass('m-menu__item--active m-menu__item--open');
  $("#labour_menu_5").addClass('m-menu__item--active');
</script>
<script>
var labour_insurance_fd_summary_view_table = $('#labour_insurance_fd_summary_view_table').DataTable({
  "ajax":{
    url :"<?php echo base_url().'labours/select_labour_insurance_fd_summary' ?>", // json datasource
    type: "post", // type of method  , by default would be get
    data: function(d){
      // d.labour_type = 1;
    }
  },
  "bProcessing": true,
  "deferRender": true,
  "bDeferRender": true,
  "scrollX" : true,
  buttons: [
    { extend: 'print', className: 'btn dark btn-outline',title: 'Labour Insurance & FD Summary' },
    { extend: 'csv', className: 'btn purple btn-outline ' },
    { extend: 'colvis', className: 'btn dark btn-outline', text: 'Columns'}
  ],
  dom:"<'row'<'col-sm-6 text-left'B><'col-sm-6 text-right'f>>\n\t\t\t<'row'<'col-sm-12'tr>>\n\t\t\t<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 dataTables_pager'lp>>", // horizobtal scrollable datatable
  "lengthMenu": [
    [25, 50, 100, -1],
    [25, 50, 100, "All"] // change per page values here
  ],
  "columnDefs": [
    {
      "targets": [ 1],
      className: "hidden"
    }
  ],
  'order': false
});

$(".table_filter").on("change", function() {
  labour_insurance_fd_summary_view_table.ajax.reload();
});


$(".form_submit_btn").click(function (e) {

  e.preventDefault();
  var a = $(this),
  l = $(this).closest("form"),
  action = l.attr('action');
  var form_id = l.attr('id');
  l.validate({
    rules: {
      "mobile_number": {
        required: !0,
        number: !0,
        minlength: 8,
        maxlength: 12
      }
    }, invalidHandler: function (e, r) {
      var i = $("#" + form_id + "_msg");
      i.removeClass("m--hide").show(), mUtil.scrollTo(i, -200)
    }, submitHandler: function (e) {
    }
  }), l.valid() && (a.addClass("m-loader m-loader--right m-loader--light").attr("disabled", !0),
  l.ajaxSubmit({
    url: action,
    success: function (e, t, r, s) {
      var modal_id = l.attr('data-modal-id');
      var form_type = l.attr('data-form-type');
      $("#" + form_id + "_msg").addClass("m--hide");
      // Block UI
      mApp.blockPage({
        overlayColor: "#000000",
        type: "loader",
        state: "success",
        message: "Please wait..."
      }), setTimeout(function () {
        mApp.unblockPage()
      }, 2e3);
      var obj = $.parseJSON(e);
      if (obj.status == 1) {
        a.removeClass("m-loader m-loader--right m-loader--light").attr("disabled", !1);
        toastr[obj.flashdata_type](obj.flashdata_msg, obj.flashdata_title);
        $("#"+modal_id).modal('toggle');
        $("."+form_id+"_fields").val('');
        $("."+form_id+"_select").val('').trigger("change");
        labour_insurance_fd_payments_view_table.ajax.reload();
        labour_insurance_fd_summary_view_table.ajax.reload();
      }
      if (obj == null) {
        setTimeout(function () {
          a.removeClass("m-loader m-loader--right m-loader--light").attr("disabled", !1);
          toastr["warning"]("Your Attempt is Timed Out. Please Try Again.", "Timed Out");
        }, 2e4)
      }
    },error: function() {
      a.removeClass("m-loader m-loader--right m-loader--light").attr("disabled", !1);
      toastr["error"]("Sorry. There Has Been Some Error Occurred. Please Try Again.", "Error");
    }
  })
)
});

</script>
