<?php $this->view("includes/Inc_pagehead");?>
<!-- Page Styles Goes Here-->

<?php $this->view("includes/Inc_navigation");?>
<div class="m-grid__item m-grid__item--fluid m-wrapper">
  <!-- BEGIN: Subheader -->
  <div class="m-subheader ">
    <div class="d-flex align-items-center">
      <div class="mr-auto">
        <h3 class="m-subheader__title m-subheader__title--separator">
          Labour Attendance
        </h3>
        <ul class="m-subheader__breadcrumbs m-nav m-nav--inline">
          <li class="m-nav__item m-nav__item--home">
            <a href="#" class="m-nav__link m-nav__link--icon">
              <i class="m-nav__link-icon la la-home"></i>
            </a>
          </li>
          <li class="m-nav__separator">
            -
          </li>
          <li class="m-nav__item">
            <a href="<?php echo base_url().'dashboard'?>" class="m-nav__link">
              <span class="m-nav__link-text">
                Home
              </span>
            </a>
          </li>
          <li class="m-nav__separator">
            -
          </li>
          <li class="m-nav__item">
            <a href="<?php echo base_url().'labours/attendance' ?>" class="m-nav__link">
              <span class="m-nav__link-text">
                Labour Attendance
              </span>
            </a>
          </li>


        </ul>
      </div>
      <div>

      </div>
    </div>
  </div>
  <!-- END: Subheader -->
  <div class="m-content">
    <div class="m-portlet  m-portlet--rounded m-portlet--bordered">
      <div class="m-portlet__body" style="padding: 1rem 2.2rem;">
        <div class="m-form m-form--label-align-right m--margin-bottom-10">
          <div class="row ">
            <div class="col-xl-12 order-2 order-xl-1">
              <div class="form-group m-form__group row" style="padding-bottom: 0px">
                <div class="col-md-4">
                  <div class="form-group m-form__group" >
                    <label> Date:</label>
                    <input  id="table_filter_date"  type="text" class="form-control  m-input  m-input--air m-input--pill"  >
                  </div>
                </div>
                <div class="col-md-4">
                  <div class="form-group m-form__group">
                    <label>
                      Work:
                    </label>
                    <div class="m-select2 m-select2--air m-select2--pill">
                      <select style="width: 100%" class="form-control m-select2 table_filter" id="table_filter_work" >
                        <option value="all">All Works</option>
                        <?php
                        foreach($work_contracts as $row): ?>
                        <option data-work-status="<?php echo $row->work_status?>" value="<?php echo $row->work_id?>"><?php echo $row->work_name?></option>
                        <?php
                      endforeach;
                      ?>
                    </select>
                  </div>
                  <span class="m-form__help"></span>
                </div>
              </div>
              <div class="col-md-4">
                <div class="form-group m-form__group">
                  <label>
                    Work Type:
                  </label>
                  <div class="m-select2 m-select2--air m-select2--pill">
                    <select style="width: 100%" class="form-control m-select2 table_filter" id="table_filter_work_type" >
                      <option value="all">All Work Types</option>
                      <?php
                      foreach($work_types as $row): ?>
                      <option value="<?php echo $row->type_id?>"><?php echo $row->type_name?></option>
                      <?php
                    endforeach;
                    ?>
                  </select>
                </div>
                <span class="m-form__help"></span>
              </div>
            </div>
          </div>
          <div class="form-group m-form__group row" style="padding-top: 0px">
            <div class="col-md-4">
              <div class="form-group m-form__group">
                <label>
                  Labour Group:
                </label>
                <div class="m-select2 m-select2--air m-select2--pill">
                  <select style="width: 100%" class="form-control m-select2 table_filter" id="table_filter_labour_group_head"  >
                    <option value="all">All Group</option>
                    <?php
                    foreach($labour_groups as $row): ?>
                    <option value="<?php echo $row->labour_id?>"><?php echo $row->labour_name." [".$row->type_name."]"?></option>
                    <?php
                  endforeach;
                  ?>
                </select>
              </div>
              <span class="m-form__help"></span>
            </div>
          </div>
          <div class="col-md-4">
            <div class="form-group m-form__group">
              <label>
                Labour:
              </label>
              <div class="m-select2 m-select2--air m-select2--pill">
                <select style="width: 100%" class="form-control m-select2 table_filter" id="table_filter_labour"  >
                  <option value="all">All Labours</option>
                  <?php
                  foreach($labours as $row): ?>
                  <option value="<?php echo $row->labour_id?>"><?php echo $row->labour_name." [".$row->type_name."]"?></option>
                  <?php
                endforeach;
                ?>
              </select>
            </div>
            <span class="m-form__help"></span>
          </div>
        </div>

      </div>
    </div>
  </div>
</div>
</div>
</div>
<div class="m-portlet m-portlet--mobile m-portlet--info m-portlet--head-solid-bg m-portlet--bordered m-portlet--rounded">
  <div class="m-portlet__head">
    <div class="m-portlet__head-caption">
      <div class="m-portlet__head-title">
        <h3 class="m-portlet__head-text">
          List of Labour Attendance
        </h3>
      </div>
    </div>
    <div class="m-portlet__head-tools">
      <?php if($this->session->userdata('user_role')!='auditor' || $this->session->userdata('user_data_permission')['adding']==1) { ?>
      <a href="<?php echo base_url()?>labours/attendance/add" style="margin-right: 10px" class="btn btn-warning m-btn m-btn--custom m-btn--icon m-btn--air m-btn--pill">
        <span>
          <i class="la la-plus"></i>
          <span>
            Add Attendance
          </span>
        </span>
      </a>
    <?php } ?>
    </div>
  </div>
  <div class="m-portlet__body">
    <table width="100%" class="table m-table nowrap table-header-fixed table-striped table-bordered table-hover table-header-fixed" id="labour_attendance_view_table">
      <thead>
        <tr class="">
          <th>ID</th>
          <th>Sl No</th>
          <th>Date</th>
          <th>Project</th>
          <th>Labour Name</th>
          <th>Start Time</th>
          <th>End Time</th>
          <th>Actions</th>
          <th>LAbour ID</th>
          <th>Project ID</th>
        </tr>
      </thead>
      <tbody>
      </tbody>
    </table>
  </div>
</div>
<div class="modal fade" tabindex="-1" id="attendance_edit_modal" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog " role="document" style="max-width: 800px">
    <div class="modal-content">
      <div class="modal-header" style="background-color: #00c5dc;border-radius: 4px">
        <h5 class="modal-title" id="exampleModalLabel" style="color: #ffffff" >
          Edit Labour Attendance
        </h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">
            &times;
          </span>
        </button>
      </div>
      <form autocomplete="off" id="form_attendance_edit" data-form-type="update" data-modal-id="attendance_edit_modal" method="post" action="<?php echo base_url().'labours/update_attendance'?>" enctype="multipart/form-data" class="m-form m-form--fit m-form--state m-form--label-align-right " >
        <div class="modal-body">
          <div class="m-form__content">
            <div class="m-alert m-alert--icon alert alert-warning m--hide" role="alert" id="form_attendance_edit_msg">
              <div class="m-alert__icon">
                <i class="la la-warning"></i>
              </div>
              <div class="m-alert__text">
                Oh snap! Change a few things up and try submitting again.
              </div>
              <div class="m-alert__close">
                <button type="button" class="close" data-close="alert" aria-label="Close"></button>
              </div>
            </div>
            <div class="row">
              <div class="col-lg-7">
                <div class="form-group m-form__group" >
                  <label for="user_name">
                    Labour
                  </label>
                  <div class="m-select2 m-select2--air m-select2--pill">
                    <select required style="width: 100%" class="form-control m-select2  form_attendance_edit_select" id="labour_attendance_labour_edit" name="labour"  >
                      <option selected disabled>Select Labour</option>
                      <?php
                      foreach($labours as $row):
                        if($row->labour_type==0){
                          $labour_type = "Individual";
                        }else{
                          if($row->group_position==1){
                            $labour_type = "Group Head";
                          }else{
                            $labour_type = "Group Member";
                          }
                        }
                        ?>
                        <option value="<?php echo $row->labour_id?>"><?php echo $row->labour_name." [".$row->type_name."] - (".$labour_type.")"?></option>
                        <?php
                      endforeach;
                      ?>
                    </select>
                  </div>
                  <span class="m-form__help"></span>
                </div>
              </div>
              <div class="col-lg-5">
                <div class="form-group m-form__group" >
                  <label for="user_name">
                    Work
                  </label>
                  <div class="m-select2 m-select2--air m-select2--pill">
                    <select required style="width: 100%" class="form-control m-select2 form_attendance_edit_select" id="attendance_work_edit" name="work"  >
                      <option selected disabled>Select Work</option>
                      <?php
                      foreach($work_contracts as $row): ?>
                      <option data-work-status="<?php echo $row->work_status?>" value="<?php echo $row->work_id?>"><?php echo $row->work_name?></option>
                      <?php
                    endforeach;
                    ?>
                  </select>
                </div>
                <span class="m-form__help"></span>
              </div>
            </div>
          </div>
          <div class="row">
            <div class="col-lg-4">
              <div class="form-group m-form__group" >
                <label for="user_name">
                  Work Date
                </label>
                <div class="input-group m-input-group--air m-input-group--pill  date">
                  <input   data-date-format="dd-mm-yyyy" id="attendance_work_date_edit" required type="text" name="work_date" class="form-control  m-input " placeholder="Work Date" >
                </div>
                <span class="m-form__help"></span>
              </div>
            </div>
            <div class="col-lg-4">
              <div class="form-group m-form__group" >
                <label for="user_name">
                  Start Time
                </label>
                <div class="input-group m-input-group m-input-group--pill m-input-group--air">

                  <input required type="text" name="start_time" id="start_time_edit"  class="time_picker form_attendance_edit_fields  form-control m-input" aria-describedby="basic-addon1">
                </div>
                <span class="m-form__help"></span>
              </div>
            </div>
            <div class="col-lg-4">
              <div class="form-group m-form__group" >
                <label for="user_name">
                  End Time
                </label>
                <div class="input-group m-input-group m-input-group--pill m-input-group--air">

                  <input required type="text" name="end_time" id="end_time_edit"  class="time_picker form_attendance_edit_fields  form-control m-input" aria-describedby="basic-addon1">
                </div>
                <span class="m-form__help"></span>
              </div>
            </div>
          </div>
        </div>

        <input type="hidden" name="attendance_id" id="attendance_id_edit">

      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-dismiss="modal">
          Close
        </button>
        <button type="submit" class="form_submit_btn btn btn-primary">
          Submit
        </button>
      </div>
    </form>
  </div>
</div>
</div>
<div class="modal fade" tabindex="-1" id="attendance_delete_modal" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog " role="document" >
    <form autocomplete="off" data-modal-id="attendance_delete_modal" id="form_attendance_delete" method="post" action="<?php echo base_url().'labours/delete_attendance'?>" class="form-horizontal">
      <div class="modal-content">
        <div class="alert alert-danger" role="alert" style="margin-bottom: 0px">
          <button type="button" class="close" data-dismiss="modal"></button>
          <br/>
          <h4 class="alert-heading">Warning! Please Confirm Your Action</h4>
          <br/>
          <p> Are You Sure to Delete this Document ? This can not be undone ! </p>
          <p>
            <button class="btn btn-danger form_submit_btn" type="submit" name="submit">Confirm & Delete</button>
            <button type="button" class="btn btn-primary modal-dismiss" data-dismiss="modal">Cancel</button>
          </p>
          <input type="hidden" value name="attendance_id" id="attendance_id_delete">
        </div>
      </div>
    </form>
  </div>
</div>

</div>
</div>
</div>
<!-- end:: Body -->
<!-- begin::Footer -->

<?php $this->view("includes/Inc_footer");?>
<!-- end::Footer -->
</div>
<!-- end:: Page -->

<?php $this->view("includes/Inc_sidebar");?>
<?php $this->view("includes/Inc_scripts");?>


<script>
$("#labour_menu").addClass('m-menu__item--active m-menu__item--open');
$("#labour_menu_4").addClass('m-menu__item--active');

$('body').on('click', '#attendance_edit_btn', function() {
  var no = $(this).closest('tr').children('td');

  $('#attendance_id_edit').val(no.eq(0).text());
  $('#attendance_work_date_edit').datepicker("setDate", no.eq(2).text());
  $('#attendance_work_edit').val(no.eq(9).text()).trigger("change");
  $('#labour_attendance_labour_edit').val(no.eq(8).text()).trigger("change");
  $('#start_time_edit').val(no.eq(5).text());
  $('#end_time_edit').val(no.eq(6).text());
  $("#start_time_edit").timepicker({
    defaultTime: no.eq(5).text(),
    minuteStep: 1,
  })
  $("#end_time_edit").timepicker({
    defaultTime: no.eq(6).text(),
    minuteStep: 1,
  })

})
$('body').on('click', '#attendance_delete_btn', function() {
  var no = $(this).closest('tr').children('td');

  $('#attendance_id_delete').val(no.eq(0).text());

})
</script>
<script>
$("#labour_attendance_labour_edit").select2({
  placeholder: "Select Labour",
  dropdownParent: $("#form_attendance_edit")
})

$("#attendance_work_edit").select2({
  placeholder: "Select Work",
  dropdownParent: $("#form_attendance_edit"),
  templateResult: format_project_dropdown
})
$("#table_filter_work").select2({
  placeholder: "Select Work",
  templateResult: format_project_dropdown
})
$("#table_filter_work_type").select2({
  placeholder: "Select Work Type"
})
$("#table_filter_labour").select2({
  placeholder: "Select Labour"
})
$("#table_filter_labour_group_head").select2({
  placeholder: "Select Team Head"
})
$("#attendance_work_date_edit").datepicker( {
  todayHighlight:!0, orientation:"bottom left", templates: {
    leftArrow: '<i class="la la-angle-left"></i>', rightArrow: '<i class="la la-angle-right"></i>'
  },
  })
function GetSearchWork(){
  return $('#table_filter_work').val();
}
function GetSearchWorkType(){
  return $('#table_filter_work_type').val();
}
function GetSearchLabour(){
  return $('#table_filter_labour').val();
}
function GetSearchLabourGroupHead(){
  return $('#table_filter_labour_group_head').val();
}
function GetSearchDate(){
  return $('#table_filter_date').val();
}

var labour_attendance_view_table = $('#labour_attendance_view_table').DataTable({
  "ajax":{
    url :"<?php echo base_url().'labours/select_labour_attendance' ?>", // json datasource
    type: "post", // type of method  , by default would be get
    data: function(d){
      d.work = GetSearchWork();
      d.work_type = GetSearchWorkType();
      d.labour = GetSearchLabour();
      d.labour_group_head = GetSearchLabourGroupHead();
      d.date = GetSearchDate();
    }
  },
  "bProcessing": true,
  "deferRender": true,
  "bDeferRender": true,
  "scrollX" : true,
  buttons: [
    { extend: 'print', className: 'btn dark btn-outline',exportOptions: {columns: ':visible'},title: 'Labour Attendance' },
    { extend: 'csv', className: 'btn purple btn-outline ' },
    { extend: 'colvis', className: 'btn dark btn-outline', text: 'Columns'}
  ],
  dom:"<'row'<'col-sm-6 text-left'B><'col-sm-6 text-right'f>>\n\t\t\t<'row'<'col-sm-12'tr>>\n\t\t\t<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 dataTables_pager'lp>>", // horizobtal scrollable datatable
  "lengthMenu": [
    [25, 50, 100, -1],
    [25, 50, 100, "All"] // change per page values here
  ],
  'ordering': false,
  "columnDefs": [
    {
      "targets": [ 0,8,9 ],
      className: "hidden"
    }
  ],

});
$(".table_filter").on("change", function() {
  labour_attendance_view_table.ajax.reload();
});
$(".hide_column").hide();



// Date Range Picker
var start = moment();
var end = moment();

function cb(start, end) {
  $('#table_filter_date').val(start.format('MMMM D, YYYY') + ' - ' + end.format('MMMM D, YYYY'));
  labour_attendance_view_table.ajax.reload();
}

$('#table_filter_date').daterangepicker({
  buttonClasses: "m-btn btn",
  applyClass: "btn-primary",
  cancelClass: "btn-secondary",
  startDate: start,
  endDate: end,
  locale: {
    format: 'MMMM D, YYYY'
  },
  ranges: {
    'Today': [moment(), moment()],
    'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
    'Last 7 Days': [moment().subtract(6, 'days'), moment()],
    'Last 30 Days': [moment().subtract(29, 'days'), moment()],
    'This Month': [moment().startOf('month'), moment().endOf('month')],
    'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')],
    'All time': [moment('1970-01-01'), moment().add(9999, 'days')],
  }
}, cb);

cb(start, end);


$(".form_submit_btn").click(function (e) {
  e.preventDefault();
  var a = $(this),
  l = $(this).closest("form"),
  action = l.attr('action');
  var form_id = l.attr('id');
  l.validate({
    rules: {
      wage_per_day: {
        number: !0
      }
    }, invalidHandler: function (e, r) {
      var i = $("#" + form_id + "_msg");
      i.removeClass("m--hide").show(), mUtil.scrollTo(i, -200)
    }, submitHandler: function (e) {
    }
  }), l.valid() && (a.addClass("m-loader m-loader--right m-loader--light").attr("disabled", !0),
  l.ajaxSubmit({
    url: action,
    success: function (e, t, r, s) {
      var modal_id = l.attr('data-modal-id');
      var form_type = l.attr('data-form-type');
      $("#" + form_id + "_msg").addClass("m--hide");
      // Block UI
      mApp.blockPage({
        overlayColor: "#000000",
        type: "loader",
        state: "success",
        message: "Please wait..."
      }), setTimeout(function () {
        mApp.unblockPage()
      }, 2e3);
      var obj = $.parseJSON(e);
      if (obj.status == 1) {
        a.removeClass("m-loader m-loader--right m-loader--light").attr("disabled", !1);
        $("#"+modal_id).modal('toggle');
        $("."+form_id+"_fields").val('');
        $("."+form_id+"_fields_1").val(0);
        $("."+form_id+"_fields_2").val(1);
        $("."+form_id+"_select").val('').trigger("change");
        toastr[obj.flashdata_type](obj.flashdata_msg, obj.flashdata_title);
        labour_attendance_view_table.ajax.reload();
      } else {
        a.removeClass("m-loader m-loader--right m-loader--light").attr("disabled", !1);
        toastr[obj.flashdata_type](obj.flashdata_msg, obj.flashdata_title);
      }
      if (obj == null) {
        setTimeout(function () {
          a.removeClass("m-loader m-loader--right m-loader--light").attr("disabled", !1);
          toastr["warning"]("Your Attempt is Timed Out. Please Try Again.", "Timed Out");
        }, 2e4)
      }
    },error: function() {
      a.removeClass("m-loader m-loader--right m-loader--light").attr("disabled", !1);
      toastr["error"]("Sorry. There Has Been Some Error Occurred. Please Try Again.", "Error");
    }
  })
)
});
</script>
