<?php $this->view("includes/Inc_pagehead"); ?>
<!-- Page Styles Goes Here-->
<?php $this->view("includes/Inc_navigation"); ?>
<div class="m-grid__item m-grid__item--fluid m-wrapper">
  <!-- BEGIN: Subheader -->
  <div class="m-subheader ">
    <div class="d-flex align-items-center">
      <div class="mr-auto">
        <h3 class="m-subheader__title m-subheader__title--separator"><?php echo $invoice_title ?></h3>
        <ul class="m-subheader__breadcrumbs m-nav m-nav--inline">
          <li class="m-nav__item m-nav__item--home">
            <a href="#" class="m-nav__link m-nav__link--icon">
              <i class="m-nav__link-icon la la-home"></i>
            </a>
          </li>
          <li class="m-nav__separator">
            -
          </li>
          <li class="m-nav__item">
            <a href="<?php echo $this->session->userdata("dashboard_link") ?>" class="m-nav__link">
              <span class="m-nav__link-text">
                Home
              </span>
            </a>
          </li>
          <li class="m-nav__separator">
            -
          </li>
          <li class="m-nav__item">
            <a href="<?php echo base_url() . 'invoices/view/'.$invoice_type ?>" class="m-nav__link">
              <span class="m-nav__link-text"><?php echo $invoice_title ?></span>
            </a>
          </li>
        </ul>
      </div>
      <div>

      </div>
    </div>
  </div>
  <!-- END: Subheader -->
  <div class="m-content">
    <div class="m-portlet m--bg-warning m-portlet--bordered-semi m-portlet--full-height ">
      <div class="m-portlet__head">
        <div class="m-portlet__head-caption">
          <div class="m-portlet__head-title">
            <h3 class="m-portlet__head-text m--font-light">
              Summary
            </h3>
          </div>
        </div>

      </div>
      <div class="m-portlet__body">
        <div class="row align-items-center">
          <div class="col-lg-12">
            <!--begin::Widget 29-->
            <div class="m-widget29">
              <div class="m-widget_content">
                <h3 class="m-widget_content-title">All Invoice Details</h3>
                <div class="m-widget_content-items">
                  <div class="m-widget_content-item">
                    <span>Total Invoices</span>
                    <span class="m--font-danger"><?php echo $total_invoice_data->invoice_count ?></span>
                  </div>
                  <div class="m-widget_content-item">
                    <span>Total Invoiced Amount</span>
                    <span class="m--font-accent"><?php echo round($total_invoice_data->total_invoice_amount,$this->config->item('Currency_amount_decimals_2')) ?></span>
                  </div>
                  <div class="m-widget_content-item">
                    <span>Total Received</span>
                    <span class="m--font-brand"><?php echo round($total_invoice_data->total_invoice_received,$this->config->item('Currency_amount_decimals_2')) ?></span>
                  </div>
                  <div class="m-widget_content-item">
                    <span>Balance to Receive</span>
                    <span><?php echo round($total_invoice_data->total_invoice_balance,$this->config->item('Currency_amount_decimals_2')) ?></span>
                  </div>
                  <?php if($invoice_type=='other_income'){?>
                    <div class="m-widget_content-item">
                      <span>Balance to Receive on Completed Works</span>
                      <span><?php echo round($balance_to_receive_on_completed,$this->config->item('Currency_amount_decimals_2')) ?></span>
                    </div>
                  <?php } ?>
                </div>
              </div>
            </div>
          </div>

        </div>
        <!--end::Widget 29-->
      </div>
    </div>


    <div class="m-portlet m-portlet--mobile m-portlet--info m-portlet--head-solid-bg m-portlet--bordered m-portlet--rounded">
      <div class="m-portlet__head">
        <div class="m-portlet__head-caption">
          <div class="m-portlet__head-title">
            <h3 class="m-portlet__head-text">
              List of <?php echo $invoice_title ?>
            </h3>
          </div>
        </div>
        <div class="m-portlet__head-tools">
          <?php if (($this->config->item('User_client_payment_creation_admin_only') == 0 || ($this->config->item('User_client_payment_creation_admin_only') == 1 && ($this->session->userdata('user_role') == 'admin' || $this->session->userdata('user_role') == 'madmin'))) && ($this->session->userdata('user_role') != 'auditor' || $this->session->userdata('user_data_permission')['adding'] == 1)) { ?>
            <a href="<?= base_url() ?>invoices/add/<?= $invoice_type ?>" class="btn btn-focus m-btn m-btn--custom m-btn--icon m-btn--air m-btn--pill">
              <span>
                <i class="la la-plus"></i>
                <span>
                  Create New Invoice
                </span>
              </span>
            </a>
          <?php } ?>
        </div>
      </div>

      <div class="m-portlet__body">
        <div class="m-form m-form--label-align-right m--margin-bottom-10">
          <div class="row align-items-center">
            <div class="col-xl-12 order-2 order-xl-1">
              <div class="form-group m-form__group row ">
                <div class="col-md-4">
                  <div class="m-form__label">
                    <label class="m-label m-label--single">
                      Invoice Date:
                    </label>
                  </div>
                  <div class="row">
                    <div class="col-md-6">
                      <div class="m-form__control">
                        <input data-date-format="dd-mm-yyyy" id="table_filter_invoice_start_date" type="text"  class="form-control m-input table_filter  m-input--pill m-input--air" placeholder="Start Date" >
                      </div>
                    </div>
                    <div class="col-md-6">
                      <div class="m-form__control">
                        <input  data-date-format="dd-mm-yyyy" id="table_filter_invoice_end_date" type="text"  class="form-control m-input table_filter  m-input--pill m-input--air" placeholder="End Date" >
                      </div>
                    </div>
                  </div>
                </div>
                <?php if($invoice_type=='project_invoice'){?>
                  <div class="col-md-4">
                    <div class="form-group m-form__group">
                      <label>
                        Project:
                      </label>
                      <div class="m-select2 m-select2--air m-select2--pill">
                        <select style="width: 100%" class="form-control m-select2 table_filter" id="table_filter_invoice_work" name="work" data-placeholder="Select Work">
                          <option value="all">All Projects</option>
                          <?php
                          foreach ($work_contracts as $row) : ?>
                          <option data-work-status="<?php echo $row->work_status ?>" value="<?php echo $row->work_id ?>"><?php echo $row->work_name ?></option>
                          <?php
                        endforeach;
                        ?>
                      </select>
                    </div>
                    <span class="m-form__help"></span>
                  </div>
                </div>
              <?php } ?>
              <?php if($invoice_type=='other_income'){?>
                <div class="col-md-4">
                  <div class="form-group m-form__group">
                    <label>
                      Work Status:
                    </label>
                    <div class="m-select2 m-select2--air m-select2--pill">
                      <select style="width: 100%" class="form-control m-select2 table_filter" id="table_filter_work_status" name="work_status" data-placeholder="Select Work">
                        <option value="all">All Status</option>
                        <option value="2">Pending</option>
                        <option value="1">Completed</option>
                        <option value="3">Freeze</option>
                      </select>
                    </div>
                    <span class="m-form__help"></span>
                  </div>
                </div>
              <?php } ?>
              <div class="col-md-4">
                <div class="form-group m-form__group">
                  <label>
                    Payment Status:
                  </label>
                  <div class="m-select2 m-select2--air m-select2--pill">
                    <select style="width: 100%" class="form-control m-select2 table_filter" id="table_filter_payment_status" name="payment_status" data-placeholder="Select Status">
                      <option value="all">All Status</option>
                      <option value="2">Pending</option>
                      <option value="1">Completed</option>
                    </select>
                  </div>
                  <span class="m-form__help"></span>
                </div>
              </div>
              <?php if (!empty($this->config->item('company_branches'))) { ?>
                <div class="col-lg-4">
                  <div class="form-group m-form__group">
                    <label>
                      Company Branch
                    </label>
                    <div class="m-select2 m-select2--air m-select2--pill">
                      <select width="100%" required class="form-control m-select2 table_filter company-branch-select2" id="company_branch">
                        <option selected value="all"> All Branches</option>
                        <option value="0">NO BRANCH</option>
                        <?php foreach ($this->config->item('company_branches') as $key => $value) { ?>
                          <option value="<?php echo $value->branch_id ?>"><?php echo $value->branch_name ?></option>
                        <?php } ?>
                      </select>
                    </div>
                    <span class="m-form__help"></span>
                  </div>
                </div>
              <?php } ?>

            </div>
          </div>
        </div>
      </div>
      <?php $this->view("modules/include_tables/table_invoices"); ?>
      <!--end: Datatable -->
      <?php $this->view("modules/include_modals/modal_client_payments"); ?>
    </div>
  </div>

</div>

</div>
</div>
<?php $this->view("modules/include_modals/modal_transaction_delete"); ?>


<!-- end:: Body -->
<!-- begin::Footer -->

<?php $this->view("includes/Inc_footer"); ?>
<!-- end::Footer -->
</div>
<!-- end:: Page -->

<?php $this->view("includes/Inc_sidebar"); ?>
<?php $this->view("includes/Inc_scripts"); ?>

<script>
<?php if($invoice_type=='other_income'){?>
  $("#other_income_menu").addClass('m-menu__item--active m-menu__item--open');
  $("#other_income_menu_1").addClass('m-menu__item--active');
  <?php }elseif($invoice_type=='proforma'){ ?>
    // $("#proforma_invoices_menu").addClass('m-menu__item--active m-menu__item--open');
    $("#proforma_invoices_menu").addClass('m-menu__item--active m-menu__item--open');
    <?php }else{ ?>
    $("#client_payments_menu").addClass('m-menu__item--active m-menu__item--open');
    $("#client_payments_menu_1").addClass('m-menu__item--active');
    <?php } ?>

    $("#table_filter_invoice_start_date,#table_filter_invoice_end_date").datepicker( {
      todayHighlight:!0, orientation:"bottom left", templates: {
        leftArrow: '<i class="la la-angle-left"></i>', rightArrow: '<i class="la la-angle-right"></i>'
      }
    })
    $("#table_filter_work_status").select2({
      placeholder: "Select Work Status"
    })
    $("#table_filter_payment_status").select2({
      placeholder: "Select Payment Status"
    })
  </script>
  <?php $this->view("modules/include_scripts/invoices_scripts"); ?>
  <?php $this->view("modules/include_scripts/invoices_payments_scripts"); ?>
  <?php $this->view("modules/include_scripts/transaction_scripts"); ?>
  <?php $this->view("modules/include_scripts/client_payments_scripts"); ?>
