<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
  <?php
  $invoice_no = '';
  if($invoice->invoice_type=='proforma'){
    $invoice_no .= $this->config->item('client_invoice_proforma_prefix');
  }else{
  if($invoice->tax_invoice==1){
    if($invoice->business_type=='B2B'){
      $invoice_no .= $this->config->item('client_invoice_tax_b2b_prefix');
    }else{
      $invoice_no .= $this->config->item('client_invoice_tax_b2c_prefix');
    }
  }else{
    $invoice_no .= $this->config->item('client_invoice_prefix');
  }
}
  $invoice_no .= sprintf('%03u', $invoice->invoice_no);
  $invoice_no .= $invoice->invoice_suffix;
  ?>
  <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
  <title>TAX Invoice - <?php echo $invoice_no.' ['.$invoice->client_name.'] ['.$invoice->work_name.']'?></title>
  <style type="text/css">
  body{ padding:0px; margin:0px;  }
  .outer{ width:1024px; height:auto; float:left }
  .header{ width:1024px; height:auto; float:left; }
  .address{ width:1024px; height:auto; float:left; }
  .items_area{ width:1024px; height:auto; float:left; }
  .heading h2 { font-family:Arial, Helvetica, sans-serif; font-size:22px; font-weight:bold; padding:0px; margin:0px; text-align:center; text-decoration:underline; }
  .text_padding{ padding-left:5px; }
  .items_table { width:1024px; height:auto; float:left; margin-top:20px; }
  .bank_sign{ width:1024px; height:auto; float:left; margin-top:40px; }
  .amount{text-align:right}
  .column_head{text-align:center}
</style>
</head>
<body>
  <div class="outer">
    <div class="page-header" style="text-align: left;padding-left: 0px;">
      <?php if($this->config->item('company_letter_head')!=''){ ?>
        <img class="letter_head_img" style="width:100%" src="<?php echo base_url().'uploads/company/'.$this->config->item('company_letter_head')?>" />
      <?php } ?>
    </div>
    <div class="heading"><h2>TAX INVOICE</h2></div>
    <br />
    <label>TRNo : <?php echo $this->config->item('company_tax_no') ?></label>
    <div class="header">

      <table width="100%" border="1" bordercolor="#666666" cellspacing="0" cellpadding="0" style="font-family:Arial, Helvetica, sans-serif; font-weight:lighter;  font-style:normal; font-size:14px;">
        <tr>
          <td width="9%" class="text_padding">Customer Name</td>
          <td width="25%" class="text_padding"><?php echo $client_data->client_name?></td>
          <td width="12%" class="text_padding">Invoice No:</td>
          <td width="19%" class="text_padding"><?php echo $invoice_no?></td>
          <td width="18%" class="text_padding">Date</td>
          <td width="17%" class="text_padding"><?php echo date('d-m-Y',strtotime($invoice->invoice_date)); ?></td>
        </tr>
        <tr>
          <td height="127" rowspan="3" class="text_padding">Address: </td>
          <td rowspan="3" class="text_padding"><?php echo $client_data->client_address?></td>
          <td height="31" class="text_padding">Payment Terms:</td>
          <td colspan="3" class="text_padding"><?php echo $invoice->payment_terms; ?></td>
        </tr>
        <tr>
          <td height="33" class="text_padding">Customer PO</td>
          <td class="text_padding"><?php echo $client_data->po_box_no?></td>
          <td><span class="text_padding">Currency Code</span></td>
          <td><span class="text_padding"><?php echo $this->config->item('Currency_currency_shortname')?></span></td>
        </tr>
        <tr>
          <td height="34" class="text_padding">Delivery Ref.</td>
          <td class="text_padding"><?php echo $invoice->delivery_note; ?></td>
          <td><span class="text_padding">Delivery Date</span></td>
          <td><span class="text_padding"><?php if($invoice->delivery_date!='0000-00-00'){ echo date('d-m-Y',strtotime($invoice->delivery_date)) ;} ?></span></td>
        </tr>
        <tr>
          <td height="52" class="text_padding">Contact Person</td>
          <td class="text_padding"><?php echo $client_data->contact_person?></td>
          <td class="text_padding">Ship to Name</td>
          <td colspan="3" class="text_padding"><?php echo $invoice->shipping_name; ?></td>
        </tr>
        <tr>
          <td height="51" class="text_padding">Customer TRN No</td>
          <td class="text_padding"><?php echo $client_data->tax_no?></td>
          <td class="text_padding">Ship to Address</td>
          <td colspan="3" class="text_padding"><?php echo $invoice->shipping_address; ?></td>
        </tr>
      </table>
    </div>
    <?php
    $tax_splitting = 0;
    foreach($invoice_items as $row){
      if($row->tax1_percent!=0 || $row->tax2_percent!=0 || $row->tax3_percent!=0){
        $tax_splitting = 1;
      }
    }
    if($this->config->item('Tax_tax_enabled')==1){
      $rowspan="rowspan='2'";
    }else{
      $rowspan="";
    } ?>
    <div class="items_table">
      <table width="100%" border="1" bordercolor="#666666" cellspacing="0" cellpadding="0" style="font-family:Arial, Helvetica, sans-serif; font-weight:lighter;  font-style:normal; font-size:14px;">
        <tr>
          <td width="5%" class="text_padding column_head" height="48"><strong>S.no</strong></td>
          <td width="5%" class="text_padding column_head"><strong>Item</strong></td>
          <td width="31%" class="text_padding column_head"><strong>Item Description</strong></td>
          <td width="7%" class="text_padding column_head"><strong>Qty</strong></td>
          <td width="12%" class="text_padding column_head"><strong>Unit Price</strong></td>
          <td width="11%" class="text_padding column_head"><strong>Total</strong></td>
          <?php if($this->config->item('Tax_tax_enabled')==1){ ?>
            <td width="10%" class="column_head text_padding"><strong>VAT %</strong></td>
            <td width="8%" class="column_head text_padding"><strong>VAT Amount</strong></td>
          <?php } ?>
          <td width="11%" class="column_headtext_padding"><strong>Total Amount</strong></td>
        </tr>
        <?php
        $tax_percentage = 0;
        $n = 1;
        $description_colspan=7;
        if($this->config->item('Tax_tax_enabled')==1){
          $description_colspan=15;
        }
        if ($this->config->item('Purchase_delivery_challan') == 1) {
          $description_colspan++;
        }
        foreach($invoice_items as $row):
          $row->tax1_amount = round($row->price*$row->quantity*$row->tax1_percent/100,$this->config->item('Currency_amount_decimals_2'));
          $row->tax2_amount = round($row->price*$row->quantity*$row->tax2_percent/100,$this->config->item('Currency_amount_decimals_2'));
          $row->tax3_amount = round($row->price*$row->quantity*$row->tax3_percent/100,$this->config->item('Currency_amount_decimals_2'));
          $tax_percentage = $row->tax_percentage;
          ?>
          <tr>
            <td class="text_padding"><?php echo $n++?></td>
            <td class="text_padding"><?php echo $row->item_code?></td>
            <td class="text_padding" style="margin-top:10px;"><?php echo $row->name?></td>
            <td class="text_padding" style="text-align:center"><?php echo $row->quantity?></td>
            <td class="text_padding amount"><?php echo $this->config->item('currency_format')->formatCurrency($row->price,$this->config->item('Currency_currency_shortname'));?></td>
            <td class="text_padding amount"><?php echo $this->config->item('currency_format')->formatCurrency($row->item_taxable_amount,$this->config->item('Currency_currency_shortname'));?></td>
            <td class="text_padding" style="text-align:center"><?php echo $row->tax_percentage?>%</td>
            <td class="text_padding amount"><?php echo $this->config->item('currency_format')->formatCurrency($row->item_tax_amount,$this->config->item('Currency_currency_shortname'));?></td>
            <td class="text_padding amount"><?php echo $this->config->item('currency_format')->formatCurrency($row->total_amount,$this->config->item('Currency_currency_shortname'));?></td>
          </tr>
        <?php endforeach; ?>
        <tr>
          <td height="36">&nbsp;</td>
          <td>&nbsp;</td>
          <td class="text_padding">Total <?php echo $this->config->item('Currency_currency_shortname')?></td>
          <td>&nbsp;</td>
          <td>&nbsp;</td>
          <td class="text_padding"><?php echo $this->config->item('Currency_currency_format')." ".$this->config->item('currency_format')->formatCurrency($invoice->invoice_taxable_amount,$this->config->item('Currency_currency_shortname'));?></td>
          <td class="text_padding" style="text-align:center"><?php echo $tax_percentage?>%</td>
          <td class="text_padding"><?php echo $this->config->item('Currency_currency_format')." ".$this->config->item('currency_format')->formatCurrency($invoice->invoice_tax_amount,$this->config->item('Currency_currency_shortname'));?></td>
          <td class="text_padding"><strong><?php echo $this->config->item('Currency_currency_format')." ".$this->config->item('currency_format')->formatCurrency($invoice->invoice_total_amount,$this->config->item('Currency_currency_shortname'));?></strong></td>
        </tr>
        <tr>
          <td height="36" colspan="9" align="left" valign="middle" class="text_padding">Total in words : <?php echo $invoice->receivable_amount_in_words ?></td>
        </tr>
      </table>
    </div>
    <div class="bank_sign">
      <table width="100%" border="0" cellspacing="0" cellpadding="0" style="font-family:Arial, Helvetica, sans-serif; font-weight:lighter;  font-style:normal; font-size:14px;">
        <tr>
          <td height="20" colspan="6" class="text_padding"><strong ><?php echo $this->config->item('company_name') ?></strong></td>
        </tr>
        <tr>
          <td width="11%" height="20" class="text_padding">Bank</td>
          <td width="1%">:</td>
          <td width="22%" class="text_padding"><?php echo $invoice->bank_name?>, Branch: <?php echo $invoice->bank_branch?></td>
          <td width="48%" rowspan="4" align="right">&nbsp;</td>
          <td width="14%" rowspan="7" align="left" valign="top"><img src="<?php echo base_url()?>uploads/company/seal.jpg" height="120" /></td>
          <td width="4%" rowspan="4" align="right">&nbsp;</td>
        </tr>
        <tr>
          <td height="21" class="text_padding">Account Number</td>
          <td>:</td>
          <td class="text_padding"><?php echo $invoice->bank_account_no?></td>
        </tr>
        <tr>
          <td height="20" class="text_padding">IBAN No</td>
          <td>:</td>
          <td class="text_padding"><?php echo $invoice->bank_ifsc?></td>
        </tr>
        <tr>
          <td height="26" class="text_padding">Swift Code</td>
          <td>:</td>
          <td class="text_padding"><?php echo $invoice->bank_swift_code?></td>
        </tr>
        <tr>
          <td class="text_padding">&nbsp;</td>
          <td>&nbsp;</td>
          <td class="text_padding">&nbsp;</td>
          <td align="right">&nbsp;</td>
          <td align="right">&nbsp;</td>
        </tr>
        <tr>
          <td class="text_padding">&nbsp;</td>
          <td>&nbsp;</td>
          <td class="text_padding">&nbsp;</td>
          <td align="right">&nbsp;</td>
          <td align="right">&nbsp;</td>
        </tr>
        <tr>
          <td class="text_padding">&nbsp;</td>
          <td>&nbsp;</td>
          <td class="text_padding">&nbsp;</td>
          <td align="right">&nbsp;</td>
          <td align="right">&nbsp;</td>
        </tr>
      </table>
    </div>
    <div class="page-footer">
      <?php if($this->config->item('client_invoice_footer')!=''){ ?>
        <img class="letter_head_img" style="width: 100%;" src="<?php echo base_url().'uploads/company/'.$this->config->item('client_invoice_footer')?>" />
      <?php } ?>
    </div>
  </div>
  <script src="<?php echo $this->config->item('Template_template_file_url'); ?>template/assets/vendors/base/vendors.bundle.js" type="text/javascript"></script>
  <script src="<?php echo $this->config->item('Template_template_file_url'); ?>template/assets/demo/default/base/scripts.bundle.js" type="text/javascript"></script>

  <script>
  jQuery(document).ready(function() {
    window.print();
  });
  </script>
</body>
</html>
