<script type="text/javascript">
$("#vehicle_type").select2({
  placeholder: "Select vehicle type",
  dropdownParent: $("#form_vehicle_add")
})
$("#work_duration_type").select2({
  placeholder: "Select vehicle type",
  dropdownParent: $("#form_vehicle_add")
})
$("#consignee_add").select2({
  placeholder: "Select Consignee",
  dropdownParent: $("#form_vehicle_add")
})

var vehicles_view_table = $('#vehicles_view_table').DataTable({
  "ajax":{
    url :"<?php echo base_url().'vehicles/select_vehicle' ?>", // json datasource
    type: "post", // type of method  , by default would be get
    data: function(d){
      <?php if($this->config->item('app_module_vehicle_management')==1 && $page_name!='consignee_profile'){ ?>
        d.vehicle_type = 'rent';
        <?php } ?>
        <?php if($page_name=='consignee_profile') { ?>
          d.consignee = <?= $consignee_data->consignee_id ?>;
          <?php } ?>
      }
    },
    "bProcessing": true,
    "deferRender": true,
    "bDeferRender": true,
    "scrollX" : true,
    buttons: [
      { extend: 'print', className: 'btn dark btn-outline',exportOptions: {columns: ':visible'},title: 'List of Vehicles' },
      { extend: 'csv', className: 'btn purple btn-outline ' },
      { extend: 'colvis', className: 'btn dark btn-outline', text: 'Columns'}
    ],
    dom:"<'row'<'col-sm-6 text-left'B><'col-sm-6 text-right'f>>\n\t\t\t<'row'<'col-sm-12'tr>>\n\t\t\t<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 dataTables_pager'lp>>", // horizobtal scrollable datatable
    "lengthMenu": [
      [25, 50, 100, -1],
      [25, 50, 100, "All"] // change per page values here
    ],
    // set the initial value
    "pageLength": 25,
    "columnDefs": [
      {
        "targets": [ 0,2,3,4,15,<?php if($this->session->userdata('user_role')=='auditor'){ echo ",11"; } ?>],
        className: "hidden"
      }
    ],
    'order': [[0, 'desc']]
  });

function select_consignee(select_id,selected_value=''){
  $('#'+select_id).html('');
  $('#'+select_id).append("<option disabled selected >Select Consignee</option>");
  $.post("<?php echo base_url() ?>vehicles/select_consignees_list",{},function(data) {
    var obj = $.parseJSON(data);
    var i=0;
    if(obj.count>0) {
      while (i < obj.data.length) {
        $('#'+select_id).append("<option value=" + obj.data[i]['consignee_id'] + ">" + obj.data[i]['consignee_name'] + "</option>");
        i++;
      }
      if(selected_value!=''){
        $('#'+select_id).val(selected_value).trigger("change");
      }
    }
  })
}
select_consignee('consignee_add');
</script>
