<?php $this->view("includes/Inc_pagehead");?>
<!-- Page Styles Goes Here-->

<?php $this->view("includes/Inc_navigation");?>
<div class="m-grid__item m-grid__item--fluid m-wrapper">
  <!-- BEGIN: Subheader -->
  <div class="m-subheader ">
    <div class="d-flex align-items-center">
      <div class="mr-auto">
        <h3 class="m-subheader__title m-subheader__title--separator">
          Manage Employee Leave Applications
        </h3>
        <ul class="m-subheader__breadcrumbs m-nav m-nav--inline">
          <li class="m-nav__item m-nav__item--home">
            <a href="#" class="m-nav__link m-nav__link--icon">
              <i class="m-nav__link-icon la la-home"></i>
            </a>
          </li>
          <li class="m-nav__separator">
            -
          </li>
          <li class="m-nav__item">
            <a href="<?php echo $this->session->userdata("dashboard_link")?>" class="m-nav__link">
              <span class="m-nav__link-text">
                Users
              </span>
            </a>
          </li>
          <li class="m-nav__separator">
            -
          </li>
          <li class="m-nav__item">
            <a href="<?php echo base_url().'employees/levae_applications' ?>" class="m-nav__link">
              <span class="m-nav__link-text">
                Employee Leave Applications
              </span>
            </a>
          </li>
        </ul>
      </div>
      <div>

      </div>
    </div>
  </div>
  <!-- END: Subheader -->
  <div class="m-content">
    <div class="m-portlet m-portlet--mobile m-portlet--info m-portlet--head-solid-bg m-portlet--bordered m-portlet--rounded">
      <div class="m-portlet__head">
        <div class="m-portlet__head-caption">
          <div class="m-portlet__head-title">
            <h3 class="m-portlet__head-text">
              List of Employee Leave Applications
            </h3>
          </div>
        </div>
        <div class="m-portlet__head-tools">
          <?php if($this->session->userdata('user_role')!='auditor' || $this->session->userdata('user_data_permission')['adding']==1) { ?>
            <a href="#" data-toggle="modal" data-target="#leave_application_add_modal" class="btn btn-focus m-btn m-btn--custom m-btn--icon m-btn--air m-btn--pill">
              <span>
                <i class="la la-plus"></i>
                <span>
                  Add New Leave Application
                </span>
              </span>
            </a>
          <?php } ?>
        </div>
      </div>
      <div class="m-portlet__body">
        <div class="m-form m-form--label-align-right m--margin-bottom-10">
          <div class="row align-items-center">
            <div class="col-xl-12 order-2 order-xl-1">
              <div class="form-group m-form__group row align-items-center">
              </div>
            </div>
          </div>
        </div>
        <!--begin: Datatable -->
        <table width="100%" class="table m-table nowrap table-header-fixed table-striped table-bordered table-hover table-header-fixed" id="leave_applications_view_table">
          <thead>
            <tr class="">
              <th>ID</th>
              <th>Sl No</th>
              <th>Employee</th>
              <th>Contact No</th>
              <th>Department</th>
              <th>Civil ID</th>
              <th>Designation</th>
              <th>Leave Type</th>
              <th>Leave Date</th>
              <th>No. of days</th>
              <th>Reason</th>
              <th>Approval</th>
              <th>Approval 2</th>
              <th>Creation</th>
              <th>Actions</th>
              <th>employee id</th>
              <th>Leave Type</th>
              <th>approval status</th>
              <th>approval remarks</th>
              <th>Day Type</th>
              <th>From</th>
              <th>To</th>
            </tr>
          </thead>
          <tbody>
          </tbody>
        </table>
        <!--end: Datatable -->
        <div class="modal fade" tabindex="-1" id="leave_application_add_modal" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
          <div class="modal-dialog " role="document" style="max-width: 800px">
            <div class="modal-content">
              <div class="modal-header" style="background-color: #36a3f7;border-radius: 4px">
                <h5 class="modal-title" id="exampleModalLabel" style="color: #ffffff" >
                  Create New Leave Application
                </h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                  <span aria-hidden="true">
                    &times;
                  </span>
                </button>
              </div>
              <form autocomplete="off" id="form_leave_application_add" data-modal-id="leave_application_add_modal" method="post" action="<?php echo base_url().'employees/create_leave_application'?>" enctype="multipart/form-data" class="m-form m-form--fit m-form--state m-form--label-align-right " >
                <div class="modal-body" style="padding-left: 40px;padding-right: 40px">
                  <div class="m-form__content">
                    <div class="m-alert m-alert--icon alert alert-warning m--hide" role="alert" id="form_leave_application_add_msg">
                      <div class="m-alert__icon">
                        <i class="la la-warning"></i>
                      </div>
                      <div class="m-alert__text">
                        Oh snap! Change a few things up and try submitting again.
                      </div>
                      <div class="m-alert__close">
                        <button type="button" class="close" data-close="alert" aria-label="Close"></button>
                      </div>
                    </div>
                  </div>
                  <div class="row">
                    <div class="col-lg-6 padding-0">
                      <div class="form-group m-form__group" >
                        <label for="user_name">
                          Employee
                        </label>
                        <div class="m-select2 m-select2--air m-select2--pill">
                          <select required style="width: 100%" class="form-control m-select2  form_leave_application_add_select" id="employee_add" name="employee"  >
                            <option selected disabled>Select Employee</option>
                            <?php
                            foreach($employees as $row): ?>
                            <option value="<?php echo $row->employee_id?>"><?php echo $row->employee_name?></option>
                            <?php
                          endforeach;
                          ?>
                        </select>
                      </div>
                      <span class="m-form__help"></span>
                    </div>
                  </div>
                  <div class="col-lg-6 padding-0">
                    <div class="form-group m-form__group" >
                      <label for="user_name">
                        Civil ID
                      </label>
                      <div class="m-input-icon m-input-icon--right">
                        <input readonly type="text" id="civil_id_add" class="form-control m-input m-input--pill m-input--air form_leave_application_add_fields">
                        <span class="m-input-icon__icon m-input-icon__icon--right"><span><i class="fa fa-tag"></i></span></span>
                      </div>
                      <span class="m-form__help"></span>
                    </div>
                  </div>
                </div>
                <div class="row">
                  <div class="col-lg-6 padding-0">
                    <div class="form-group m-form__group" >
                      <label for="user_name">
                        Department
                      </label>
                      <div class="m-input-icon m-input-icon--right">
                        <input readonly type="text" id="department_add" class="form-control m-input m-input--pill m-input--air form_leave_application_add_fields" >
                        <span class="m-input-icon__icon m-input-icon__icon--right"><span><i class="fa fa-edit"></i></span></span>
                      </div>
                      <span class="m-form__help"></span>
                    </div>
                  </div>
                  <div class="col-lg-6 padding-0">
                    <div class="form-group m-form__group" >
                      <label for="user_name">
                        Designation
                      </label>
                      <div class="m-input-icon m-input-icon--right">
                        <input readonly type="text" id="designation_add" class="form-control m-input m-input--pill m-input--air form_leave_application_add_fields">
                        <span class="m-input-icon__icon m-input-icon__icon--right"><span><i class="fa fa-edit"></i></span></span>
                      </div>
                      <span class="m-form__help"></span>
                    </div>
                  </div>
                </div>
                <div class="row">
                  <div class="col-lg-6 padding-0">
                    <div class="form-group m-form__group" >
                      <label for="user_name">
                        Contact No
                      </label>
                      <div class="m-input-icon m-input-icon--right">
                        <input readonly type="text" id="contactno_add" class="form-control m-input m-input--pill m-input--air form_leave_application_add_fields">
                        <span class="m-input-icon__icon m-input-icon__icon--right"><span><i class="fa fa-edit"></i></span></span>
                      </div>
                      <span class="m-form__help"></span>
                    </div>
                  </div>
                  <div class="col-lg-6 padding-0">
                    <div class="form-group m-form__group" >
                      <label for="user_name">
                        Leave type
                      </label>
                      <div class="m-select2 m-select2--air m-select2--pill">
                        <select required style="width: 100%" class="form-control m-select2  form_leave_application_add_select" id="leave_type_add" name="leave_type"  >
                          <option selected disabled>Select Leave Type</option>
                          <?php foreach ($leave_types as $key => $value) { ?>
                            <option value="<?php echo $value->leave_type_id?>">
                              <?php echo $value->leave_type_name;
                              if($value->leave_paid==1){
                                echo " [Paid]";
                              }else{
                                echo " [UnPaid]";
                              }
                              ?></option>
                            <?php } ?>
                          </select>
                        </div>
                        <span class="m-form__help"></span>
                      </div>
                    </div>
                  </div>
                  <div class="row">
                    <div class="col-lg-3 padding-0">
                      <div class="form-group m-form__group" >
                        <label for="user_name">
                          Leave Date From
                        </label>
                        <div class="input-group m-input-group m-input-group--pill m-input-group--air">
                          <input required type="text" name="leave_date_from" id="leave_date_from_add" data-date-format="dd-mm-yyyy" placeholder="Leave Date From.." class="form-control form_leave_application_add_fields m-input"  aria-describedby="basic-addon1">
                        </div>
                        <span class="m-form__help"></span>
                      </div>
                    </div>
                    <div class="col-lg-3 padding-0">
                      <div class="form-group m-form__group" >
                        <label for="user_name">
                          Leave Date To
                        </label>
                        <div class="input-group m-input-group m-input-group--pill m-input-group--air">
                          <input required type="text" name="leave_date_to" id="leave_date_to_add" data-date-format="dd-mm-yyyy" placeholder="Leave Date To.." class="form-control form_leave_application_add_fields m-input"  aria-describedby="basic-addon1">
                        </div>
                        <span class="m-form__help"></span>
                      </div>
                    </div>
                    <div class="col-lg-4 padding-0">
                      <div class="form-group m-form__group" >
                        <label for="user_name">
                          Half Day / Full Day
                        </label>
                        <div class="m-radio-inline" style="padding-top: 10px;">
                          <label class="m-radio m-radio--solid m-radio--state-danger">
                            <input required type="radio" class="form_fields_radio"  name="day_type" value="half"> Half
                            <span></span>
                          </label>
                          <label class="m-radio m-radio--solid m-radio--state-info">
                            <input type="radio" class="form_fields_radio" name="day_type" checked  value="full"> Full
                            <span></span>
                          </label>
                        </div>
                      </div>
                    </div>
                    <div class="col-lg-2 padding-0">
                      <div class="form-group m-form__group" >
                        <label for="user_name">
                          No of Days
                        </label>
                        <div class="input-group m-input-group m-input-group--pill m-input-group--air">
                          <input readonly type="text" name="no_of_days" id="no_of_days_add" class="form-control form_leave_application_add_fields m-input"  aria-describedby="basic-addon1">
                        </div>
                        <span class="m-form__help"></span>
                      </div>
                    </div>
                  </div>
                  <div class="row">
                    <div class="col-lg-12 padding-0" id="last_leave_details_add_div">
                    </div>
                  </div>
                  <div class="row">
                    <div class="col-lg-12 padding-0">
                      <div class="form-group m-form__group" >
                        <label for="user_name">
                          Reason For Leave
                        </label>
                        <div class="input-group m-input-group--air m-input-group--pill">
                          <textarea required name="leave_reason" class="form-control form_leave_application_add_fields m-input " placeholder="Reason for Leave" ></textarea>
                        </div>
                      </div>
                      <span class="m-form__help"></span>
                    </div>
                  </div>
                </div>
                <div class="modal-footer">
                  <button type="button" class="btn btn-secondary" data-dismiss="modal">
                    Close
                  </button>
                  <button type="submit" class="btn btn-primary form_submit_btn">
                    Submit
                  </button>
                </div>
              </form>
            </div>
          </div>
        </div>
        <div class="modal fade" tabindex="-1" id="leave_application_edit_modal" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
          <div class="modal-dialog " role="document" style="max-width: 800px">
            <div class="modal-content">
              <div class="modal-header" style="background-color: #36a3f7;border-radius: 4px">
                <h5 class="modal-title" id="exampleModalLabel" style="color: #ffffff">
                  Edit Leave Application
                </h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                  <span aria-hidden="true">
                    &times;
                  </span>
                </button>
              </div>
              <form autocomplete="off" data-modal-id="leave_application_edit_modal" id="form_leave_application_edit" method="post" action="<?php echo base_url() . 'employees/update_leave_application' ?>" enctype="multipart/form-data" class="form m-form m-form--fit m-form--state m-form--label-align-right ">
                <div class="modal-body">
                  <div class="m-form__content">
                    <div class="m-alert m-alert--icon alert alert-warning m--hide" role="alert" id="form_leave_application_edit_msg">
                      <div class="m-alert__icon">
                        <i class="la la-warning"></i>
                      </div>
                      <div class="m-alert__text">
                        Oh snap! Change a few things up and try submitting again.
                      </div>
                      <div class="m-alert__close">
                        <button type="button" class="close" data-close="alert" aria-label="Close"></button>
                      </div>
                    </div>
                  </div>
                  <div class="row">
                    <div class="col-lg-6">
                      <div class="form-group m-form__group">
                        <label for="leave_application_name">
                          Employee
                        </label>
                        <div class="input-group m-input-group m-input-group--pill m-input-group--air">
                          <div class="input-group-prepend">
                            <span class="input-group-text" id="basic-addon1">
                              <i class="la la-user"></i>
                            </span>
                          </div>
                          <input readonly type="text" id="employee_name_edit" class="form-control m-input form_leave_application_edit_fields" placeholder="Name of User" aria-describedby="basic-addon1">
                        </div>
                        <span class="m-form__help"></span>
                      </div>
                    </div>
                    <div class="col-lg-6">
                      <div class="form-group m-form__group">
                        <label for="leave_application_name">
                          Designation
                        </label>
                        <div class="input-group m-input-group m-input-group--pill m-input-group--air">
                          <div class="input-group-prepend">
                            <span class="input-group-text" id="basic-addon1">
                              <i class="la la-user"></i>
                            </span>
                          </div>
                          <input readonly type="text" id="designation_edit" class="form-control m-input form_leave_application_edit_fields" aria-describedby="basic-addon1">
                        </div>
                        <span class="m-form__help"></span>
                      </div>
                    </div>
                  </div>
                  <div class="row">
                    <div class="col-lg-6">
                      <div class="form-group m-form__group">
                        <label for="leave_application_name">
                          Leave Period
                        </label>
                        <div class="input-group m-input-group m-input-group--pill m-input-group--air">
                          <div class="input-group-prepend">
                            <span class="input-group-text" id="basic-addon1">
                              <i class="la la-edit"></i>
                            </span>
                          </div>
                          <input readonly type="text" id="leave_date_period_edit" class="form-control m-input form_leave_application_edit_fields" aria-describedby="basic-addon1">
                        </div>
                        <span class="m-form__help"></span>
                      </div>
                    </div>
                    <div class="col-lg-3 padding-0">
                      <div class="form-group m-form__group" >
                        <label for="user_name">
                          Half Day / Full Day
                        </label>
                        <div class="m-radio-inline" style="padding-top: 10px;">
                          <label class="m-radio m-radio--solid m-radio--state-danger">
                            <input required type="radio" class="form_fields_radio"  name="day_type_edit" value="half"> Half
                            <span></span>
                          </label>
                          <label class="m-radio m-radio--solid m-radio--state-info">
                            <input type="radio" class="form_fields_radio" name="day_type_edit" checked  value="full"> Full
                            <span></span>
                          </label>
                        </div>
                      </div>
                    </div>
                    <div class="col-lg-3">
                      <div class="form-group m-form__group">
                        <label for="leave_application_name">
                          No of days
                        </label>
                        <div class="input-group m-input-group m-input-group--pill m-input-group--air">
                          <div class="input-group-prepend">
                            <span class="input-group-text" id="basic-addon1">
                              <i class="la la-edit"></i>
                            </span>
                          </div>
                          <input readonly type="text" name="no_of_days" id="leave_no_of_days_edit" class="form-control m-input form_leave_application_edit_fields" aria-describedby="basic-addon1">
                        </div>
                        <span class="m-form__help"></span>
                      </div>
                    </div>
                    <input type="hidden" id="leave_date_from_edit" name="leave_date_from">
                    <input type="hidden" id="leave_date_to_edit" name="leave_date_from">
                  </div>
                  <div class="row">
                    <div class="col-lg-6">
                      <div class="form-group m-form__group" >
                        <label for="user_name">
                          Leave type
                        </label>
                        <div class="m-select2 m-select2--air m-select2--pill">
                          <select required style="width: 100%" class="form-control m-select2  form_leave_application_edit_select" id="leave_type_edit" name="leave_type"  >
                            <option selected disabled>Select Leave Type</option>
                            <?php foreach ($leave_types as $key => $value) { ?>
                              <option value="<?php echo $value->leave_type_id?>">
                                <?php echo $value->leave_type_name;
                                if($value->leave_paid==1){
                                  echo " [Paid]";
                                }else{
                                  echo " [UnPaid]";
                                }
                                ?></option>
                              <?php } ?>
                            </select>
                          </div>
                          <span class="m-form__help"></span>
                        </div>
                      </div>
                      <div class="col-lg-6">
                        <div class="form-group m-form__group">
                          <label for="leave_application_name">
                            Reason
                          </label>
                          <div class="input-group m-input-group m-input-group--pill m-input-group--air">
                            <div class="input-group-prepend">
                              <span class="input-group-text" id="basic-addon1">
                                <i class="la la-edit"></i>
                              </span>
                            </div>
                            <input readonly type="text" id="reason_edit" class="form-control m-input form_leave_application_edit_fields"  aria-describedby="basic-addon1">
                          </div>
                          <span class="m-form__help"></span>
                        </div>
                      </div>
                    </div>
                    <input type="hidden" name="leave_application_id" id="update_leave_application_id">
                    <div class="row">
                      <div class="col-lg-6">
                        <div class="form-group m-form__group">
                          <label for="leave_application_name">
                            Application Status
                          </label>
                          <div class="m-radio-inline" style="padding-top: 10px;">
                            <label class="m-radio m-radio--solid m-radio--state-success">
                              <input required type="radio" class="form_fields_radio" name="leave_application_status" value="1"> Approved
                              <span></span>
                            </label>
                            <label class="m-radio m-radio--solid m-radio--state-danger">
                              <input type="radio" class="form_fields_radio" name="leave_application_status" value="2"> Rejected
                              <span></span>
                            </label>
                          </div>
                          <span class="m-form__help"></span>
                        </div>
                      </div>
                      <div class="col-lg-6">
                        <div class="form-group m-form__group">
                          <label for="leave_application_name">
                            Approval Remarks
                          </label>
                          <div class="input-group m-input-group m-input-group--pill m-input-group--air">
                            <div class="input-group-prepend">
                              <span class="input-group-text" id="basic-addon1">
                                <i class="la la-tag"></i>
                              </span>
                            </div>
                            <input type="text" name="remarks" id="approval_remarks_edit" class="form-control m-input form_leave_application_edit_fields" placeholder="Remarks" aria-describedby="basic-addon1">
                          </div>
                          <span class="m-form__help"></span>
                        </div>
                      </div>
                    </div>
                    <input type="hidden" id="leave_application_id_edit" name="application_id" />
                  </div>
                  <div class="modal-footer">
                    <button type="button" class="btn btn-secondary " data-dismiss="modal">
                      Close
                    </button>
                    <button type="submit" class="btn btn-primary form_submit_btn">
                      Submit
                    </button>
                  </div>
                </form>
              </div>
            </div>
          </div>
        </div>
      </div>
      <div class="m-portlet m-portlet--mobile m-portlet--focus m-portlet--head-solid-bg m-portlet--bordered m-portlet--rounded">
        <div class="m-portlet__head">
          <div class="m-portlet__head-caption">
            <div class="m-portlet__head-title">
              <h3 class="m-portlet__head-text">
                Annual Leave Report
              </h3>
            </div>
          </div>
          <div class="m-portlet__head-tools">

          </div>
        </div>
        <div class="m-portlet__body">
          <!--begin: Datatable -->
          <table width="100%" class="table m-table nowrap table-header-fixed table-striped table-bordered table-hover table-header-fixed" id="leave_report_view_table">
            <thead>
              <tr class="">
                <th rowspan="2">Sl No</th>
                <th rowspan="2">Employee</th>
                <th rowspan="2">Department</th>
                <th rowspan="2">Designation</th>
                <th colspan="<?php echo sizeof($leave_types)?>" style="text-align:center">Leave Taken</th>
              </tr>
              <tr>
                <?php foreach ($leave_types as $key => $value) {?>
                  <th><?php echo "<span style='border-bottom:1px solid black'>".$value->leave_type_name;
                  if($value->leave_paid==1){
                    echo " [Paid]";
                  }else{
                    echo " [UnPaid]";
                  }
                  echo "</span>";
                  if($value->total_allowed_annually!=0){
                    echo "<br/>Allowed - ".$value->total_allowed_annually;
                  }
                  ?></th>
                <?php } ?>
              </tr>
            </thead>
            <tbody>
            </tbody>
          </table>
          <!--end: Datatable -->
        </div>
      </div>
    </div>
  </div>
</div>
<!-- end:: Body -->
<!-- begin::Footer -->

<?php $this->view("includes/Inc_footer");?>
<!-- end::Footer -->
</div>
<!-- end:: Page -->

<?php $this->view("includes/Inc_sidebar");?>
<?php $this->view("includes/Inc_scripts");?>
<!--begin::Page Snippets -->

<script>
$("#table_filter_status").selectpicker();
$("[data-switch=true]").bootstrapSwitch()
</script>

<script>
$("#hr_menu").addClass('m-menu__item--active m-menu__item--open');
$("#hr_menu_5").addClass('m-menu__item--active');

</script>
<script>
$('#leave_date_from_add').datepicker({
  format: "dd-M-yy",
  todayHighlight:'TRUE',
  autoclose: true,
  minDate: 0,
  maxDate: '+1Y+6M'
}).on('changeDate', function (ev) {
  $('#leave_date_to_add').datepicker('setStartDate', $("#leave_date_from_add").val());
});
$('#leave_date_to_add').datepicker({
  format: "dd-M-yy",
  todayHighlight:'TRUE',
  autoclose: true,
  minDate: '0',
  maxDate: '+1Y+6M'
}).on('changeDate', function (ev) {
  calculate_days_add();
});

$('body').on('change', 'input[type=radio][name=day_type]', function() {
  calculate_days_add();
})
function calculate_days_add(){
  var start = $("#leave_date_from_add").val();
  var startD = new Date(start);
  var end = $("#leave_date_to_add").val();
  var endD = new Date(end);
  var diff = parseInt((endD.getTime()-startD.getTime())/(24*3600*1000))+1;
  var day_type = $("input[type=radio][name=day_type]:checked").val();
  if(day_type=='half'){
    diff = diff*0.5;
  }
  $("#no_of_days_add").val(diff);
}

$('body').on('change', 'input[type=radio][name=day_type_edit]', function() {
  calculate_days_edit();
})
function calculate_days_edit(){
  var start = $("#leave_date_from_edit").val();
  var startD = new Date(start);
  var end = $("#leave_date_to_edit").val();
  var endD = new Date(end);
  var diff = parseInt((endD.getTime()-startD.getTime())/(24*3600*1000))+1;
  var day_type = $("input[type=radio][name=day_type_edit]:checked").val();
  if(day_type=='half'){
    diff = diff*0.5;
  }
  $("#leave_no_of_days_edit").val(diff);
}
$("#employee_add").select2({
  placeholder: "Select Employee",
  dropdownParent: $("#form_leave_application_add")
})
$("#leave_type_add").select2({
  placeholder: "Select Leave type",
  dropdownParent: $("#form_leave_application_add")
})
$("#employee_edit").select2({
  placeholder: "Select Employee",
  dropdownParent: $("#form_leave_application_edit")
})
$("#leave_type_edit").select2({
  placeholder: "Select Leave type",
  dropdownParent: $("#form_leave_application_edit")
})
$('body').on('change', '#employee_add', function() {
  var employee_id=$('#employee_add :selected').val();
  $.post("<?php echo base_url() ?>employees/select_details",{employee_id:employee_id},function(data) {
    var obj = $.parseJSON(data);
    var i=0;
    if(obj.count==1) {
      $("#civil_id_add").val(obj.civil_id);
      $("#department_add").val(obj.department_name);
      $("#designation_add").val(obj.designation);
      $("#contactno_add").val(obj.phone);
      <?php if($this->config->item('HR_leave_application')==1){ ?>
        $("#last_leave_details_add_div").html("");
        var last_leave_details = obj.last_leave_data;
        var table_data = '<table class="table table-bordered m-table m-table--border-success">'+
        '<caption><strong>Last 2 Leave Details</strong></caption>'+
        '<thead>'+
        '<tr>'+
        '<th>Date</th>'+
        '<th>No of days</th>'+
        '<th>Leave Type</th>'+
        '</tr>'+
        '</thead>'+
        '<tbody>';
        if(last_leave_details.length>0){
          while (i < last_leave_details.length) {
            table_data += '<tr>'+
            '<th>'+last_leave_details[i]['leave_date_from']+' To '+last_leave_details[i]['leave_date_to']+'</th>'+
            '<td>'+last_leave_details[i]['leave_days']+'</td>'+
            '<td>'+last_leave_details[i]['leave_type']+'</td>'+
            '</tr>';
            i++;
          }
        }else{
          table_data += '<tr>'+
          '<th colspan="3">No Records Found</th>'+
          '</tr>';
        }

        table_data += '</tbody>'+
        '</table>';
        $("#last_leave_details_add_div").html(table_data);
        <?php } ?>
      }
    })
  })

  $('body').on('click', '#leave_application_edit_btn', function() {
    var no = $(this).closest('tr').children('td');
    $('#leave_application_id_edit').val(no.eq(0).text());
    $('#user_role_edit').val(no.eq(3).text());
    $('#employee_name_edit').val(no.eq(2).text());
    $('#leave_date_period_edit').val(no.eq(8).text());
    $('#leave_no_of_days_edit').val(no.eq(9).text());
    $('#leave_type_edit').val(no.eq(16).text()).trigger('change');
    $('#reason_edit').val(no.eq(10).text());
    $('#approval_remarks_edit').val(no.eq(18).text());
    var status=no.eq(17).text();
    var day_type=no.eq(19).text();
    $("input[name=leave_application_status][value=" + status + "]").prop('checked', true);
    $("input[name=day_type_edit][value=" + day_type + "]").prop('checked', true);
    $('#leave_date_from_edit').val(no.eq(20).text());
    $('#leave_date_to_edit').val(no.eq(21).text());
  })

</script>
<script>
var leave_applications_view_table = $('#leave_applications_view_table').DataTable({
  "ajax":{
    url :"<?php echo base_url().'employees/select_employee_leave_applications' ?>", // json datasource
    type: "post", // type of method  , by default would be get
    data: function(d){
    }
  },
  "bProcessing": true,
  "deferRender": true,
  "bDeferRender": true,
  "scrollX" : true,
  buttons: [
    { extend: 'print', className: 'btn dark btn-outline',exportOptions: {columns: ':visible'},title: 'Leave Applications' },
    { extend: 'csv', className: 'btn purple btn-outline ' },
    { extend: 'colvis', className: 'btn dark btn-outline', text: 'Columns'}
  ],
  dom:"<'row'<'col-sm-6 text-left'B><'col-sm-6 text-right'f>>\n\t\t\t<'row'<'col-sm-12'tr>>\n\t\t\t<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 dataTables_pager'lp>>", // horizobtal scrollable datatable
  "lengthMenu": [
    [25, 50, 100, -1],
    [25, 50, 100, "All"] // change per page values here
  ],
  "columnDefs": [
    {
      "targets": [ 0,12,15,16,17,18,19,20,21<?php if($this->session->userdata('user_role')=='auditor'){ echo ",14"; } ?> ],
      className: "hidden"
    }
  ],
  'order': false
});
var leave_report_view_table = $('#leave_report_view_table').DataTable({
  "ajax":{
    url :"<?php echo base_url().'employees/select_employee_leave_report' ?>", // json datasource
    type: "post", // type of method  , by default would be get
    data: function(d){
    }
  },
  "bProcessing": true,
  "deferRender": true,
  "bDeferRender": true,
  "scrollX" : true,
  buttons: [
    { extend: 'print', className: 'btn dark btn-outline',exportOptions: {columns: ':visible'},title: 'Leave Applications' },
    { extend: 'csv', className: 'btn purple btn-outline ' },
    { extend: 'colvis', className: 'btn dark btn-outline', text: 'Columns'}
  ],
  dom:"<'row'<'col-sm-6 text-left'B><'col-sm-6 text-right'f>>\n\t\t\t<'row'<'col-sm-12'tr>>\n\t\t\t<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 dataTables_pager'lp>>", // horizobtal scrollable datatable
  "lengthMenu": [
    [25, 50, 100, -1],
    [25, 50, 100, "All"] // change per page values here
  ],
  "columnDefs": [
    {
      "targets": [  ],
      className: "hidden"
    }
  ],
  'order': false
});
$(".table_filter").on("change", function() {
  table.ajax.reload();
});
$(".hide_column").hide();

</script>

<script>


$(".form_submit_btn").click(function (e) {
  e.preventDefault();
  var a = $(this),
  l = $(this).closest("form"),
  action = l.attr('action');
  var form_id = l.attr('id');
  l.validate({
    rules: {
      email: {
        email: !0,
        required: !0
      }
    }, invalidHandler: function (e, r) {
      var i = $("#" + form_id + "_msg");
      i.removeClass("m--hide").show(), mUtil.scrollTo(i, -200)
    }, submitHandler: function (e) {
    }
  }), l.valid() && (a.addClass("m-loader m-loader--right m-loader--light").attr("disabled", !0),
  l.ajaxSubmit({
    url: action,
    beforeSend: function(){
      // Handle the beforeSend event
      // Block UI
      mApp.blockPage({
        overlayColor: "#000000",
        type: "loader",
        state: "success",
        message: "Please wait..."
      });

      mApp.block(".modal-content", {
        overlayColor: "#000000",
        type: "loader",
        state: "success",
        message: "Please wait..."
      });
    },

    success: function (e, t, r, s) {
      // UnBlock UI

      var modal_id = l.attr('data-modal-id');
      var form_type = l.attr('data-form-type');
      $("#" + form_id + "_msg").addClass("m--hide");


      var obj = $.parseJSON(e);
      if (obj.status == 1) {
        a.removeClass("m-loader m-loader--right m-loader--light").attr("disabled", !1);
        $("#"+modal_id).modal('toggle');
        $("."+form_id+"_fields").val('');
        $("."+form_id+"_select").val('').trigger("change");

        leave_applications_view_table.ajax.reload();
        toastr[obj.flashdata_type](obj.flashdata_msg, obj.flashdata_title);
      } else {
        a.removeClass("m-loader m-loader--right m-loader--light").attr("disabled", !1);
        toastr[obj.flashdata_type](obj.flashdata_msg, obj.flashdata_title);
      }
      if (obj == null) {
        setTimeout(function () {
          a.removeClass("m-loader m-loader--right m-loader--light").attr("disabled", !1);
          toastr["warning"]("Your Attempt is Timed Out. Please Try Again.", "Timed Out");
        }, 2e4)
      }
    },error: function() {
      a.removeClass("m-loader m-loader--right m-loader--light").attr("disabled", !1);
      toastr["error"]("Sorry. There Has Been Some Error Occurred. Please Try Again.", "Error");
    },ajaxComplete : function(){
      mApp.unblockPage();
      mApp.unblock(".modal-content");
    },complete  : function(){
      mApp.unblockPage();
      mApp.unblock(".modal-content");
    },
  })
)
});

</script>
