<?php $this->view("includes/Inc_pagehead");?>
<!-- Page Styles Goes Here-->

<?php $this->view("includes/Inc_navigation");?>
<div class="m-grid__item m-grid__item--fluid m-wrapper">
  <!-- BEGIN: Subheader -->
  <div class="m-subheader ">
    <div class="d-flex align-items-center">
      <div class="mr-auto">
        <h3 class="m-subheader__title m-subheader__title--separator">
          Daily Attendance Reports - Biometric Data
        </h3>
        <ul class="m-subheader__breadcrumbs m-nav m-nav--inline">
          <li class="m-nav__item m-nav__item--home">
            <a href="#" class="m-nav__link m-nav__link--icon">
              <i class="m-nav__link-icon la la-home"></i>
            </a>
          </li>
          <li class="m-nav__separator">
            -
          </li>
          <li class="m-nav__item">
            <a href="<?php echo base_url().'dashboard'?>" class="m-nav__link">
              <span class="m-nav__link-text">
                Home
              </span>
            </a>
          </li>
          <li class="m-nav__separator">
            -
          </li>
          <li class="m-nav__item">
            <a href="<?php echo base_url().'employees/attendance' ?>" class="m-nav__link">
              <span class="m-nav__link-text">
                Daily Attendance Reports
              </span>
            </a>
          </li>


        </ul>
      </div>
      <div>

      </div>
    </div>
  </div>
  <!-- END: Subheader -->
  <div class="m-content">
    <div class="m-portlet m-portlet--mobile m-portlet--info m-portlet--head-solid-bg m-portlet--bordered m-portlet--rounded">
      <div class="m-portlet__head">
        <div class="m-portlet__head-caption">
          <div class="m-portlet__head-title">
            <h3 class="m-portlet__head-text">
              Daily Attendance Reports - Biometric Data
            </h3>
          </div>
        </div>
        <div class="m-portlet__head-tools">
          <?php if($this->session->userdata('user_role')=='admin' || $this->session->userdata('user_role')=='general_manager'){ ?>
            <a href="<?php echo base_url()?>employees/attendance/add"  class="btn btn-focus m-btn m-btn--custom m-btn--icon m-btn--air m-btn--pill">
              <span>
                <i class="la la-plus"></i>
                <span>
                  Import Attendance Data
                </span>
              </span>
            </a>
          <?php } ?>
        </div>
      </div>
      <div class="m-portlet__body">
        <div class="m-form m-form--label-align-right m--margin-bottom-10">
          <div class="row align-items-center">
            <div class="col-xl-12 order-2 order-xl-1">
              <div class="form-group m-form__group row align-items-center">

                <div class="col-md-5">
                  <div class="m-form__group ">
                    <label >
                      Date:
                    </label>
                    <input  id="table_filter_date_range"   type="text" class="form-control m-input m-input--air m-input--pill"  >
                  </div>
                </div>
                <div class="col-md-4">
                  <div class="m-form__group ">
                    <label>
                      Employee:
                    </label>
                    <div class="m-select2 m-select2--air m-select2--pill">
                      <select style="width: 100%" class="form-control m-select2 table_filter" id="table_filter_employee"  name="table_filter_employee">
                        <option value="all">All Employees</option>
                        <?php
                        foreach($employees as $row): ?>
                        <option value="<?php echo $row->employee_id?>"><?php echo $row->employee_name." [".$row->department_name."]"?></option>
                        <?php
                      endforeach;
                      ?>
                    </select>
                  </div>
                </div>
              </div>
            </div>
            <div class="m-form__seperator m-form__seperator--dashed"></div>
          </div>
        </div>
      </div>
      <table width="100%" class="table m-table nowrap table-header-fixed table-striped table-bordered table-hover table-header-fixed" id="daily_attendance_view_table">
        <thead>
          <tr class="">
            <th>Sl No</th>
            <th>Attendance ID</th>
            <th>Date</th>
            <th>Day</th>
            <th>Employee<br/>Biometric ID</th>
            <th>Department</th>
            <th>Employee</th>
            <th>Clock In</th>
            <th>Clock Out</th>
            <th>Worked Hours</th>
            <th>Action</th>
          </tr>
        </thead>
        <tbody>
        </tbody>
      </table>

    </div>
  </div>
</div>
</div>
</div>
<!-- end:: Body -->
<!-- begin::Footer -->

<?php $this->view("includes/Inc_footer");?>
<!-- end::Footer -->
</div>
<!-- end:: Page -->

<?php $this->view("includes/Inc_sidebar");?>
<?php $this->view("includes/Inc_scripts");?>


<!--begin::Page Snippets -->
<script>
$("#hr_menu").addClass('m-menu__item--active m-menu__item--open');
$("#hr_menu_4").addClass('m-menu__item--active');

$("#table_filter_time").timepicker( {
  // defaultTime: "<?php //echo date("H:i:s a",strtotime($this->config->item('User_attendance_start_due_time')))?>",
  minuteStep: 1,
})
$("#table_filter_employee").select2({
  placeholder: "Select Employee"
})

//  client List Data Table
jQuery(document).ready(function() {
  function toaster(msg_type,message,title){
    toastr.options = {
      "closeButton": false,
      "debug": false,
      "newestOnTop": false,
      "progressBar": true,
      "positionClass": "toast-top-center",
      "preventDuplicates": false,
      "onclick": null,
      "showDuration": "300",
      "hideDuration": "1000",
      "timeOut": "5000",
      "extendedTimeOut": "1000",
      "showEasing": "swing",
      "hideEasing": "linear",
      "showMethod": "fadeIn",
      "hideMethod": "fadeOut"
    };
    if(msg_type=="success"){
      toastr.success(message,title);
    }else{
      toastr.error(message,title);
    }

  }
  function GetSearchDate(){
    return $('#table_filter_date_range').val();
  }
  function GetSearchemployee(){
    return $('#table_filter_employee').val();
  }
  var table = $('#daily_attendance_view_table').DataTable({
    "ajax":{
      url :"<?php echo base_url().'employees/select_attendance' ?>", // json datasource
      type: "post", // type of method  , by default would be get
      data: function(d){
        d.date = GetSearchDate();
        d.employee = GetSearchemployee();
      }
    },
    "bProcessing": true,
    "deferRender": true,
    "bDeferRender": true,
    "scrollX" : true,
    buttons: [
      { extend: 'print', className: 'btn dark btn-outline',exportOptions: {columns: ':visible'},title: 'Daily Employee Attendance' },
      { extend: 'csv', className: 'btn purple btn-outline ' },
      { extend: 'colvis', className: 'btn dark btn-outline', text: 'Columns'}
    ],
    dom:"<'row'<'col-sm-6 text-left'B><'col-sm-6 text-right'f>>\n\t\t\t<'row'<'col-sm-12'tr>>\n\t\t\t<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 dataTables_pager'lp>>", // horizobtal scrollable datatable
    "lengthMenu": [
      [25, 50, 100, -1],
      [25, 50, 100, "All"] // change per page values here
    ],
    "columnDefs": [
      {
        "targets": [ 1 ],
        className: "hidden"
      },
    ],
    'ordering': [0,'asc']
  });
  $(".table_filter").on("change", function() {
    table.ajax.reload();
  });
  $(".hide_column").hide();
  // Date Range Picker
  var start = moment();
  var end = moment();

  function cb(start, end) {
    $('#table_filter_date_range').val(start.format('MMMM D, YYYY') + ' - ' + end.format('MMMM D, YYYY'));
    table.ajax.reload();
  }

  $('#table_filter_date_range').daterangepicker({
    buttonClasses: "m-btn btn",
    applyClass: "btn-primary",
    cancelClass: "btn-secondary",
    startDate: start,
    endDate: end,
    locale: {
      format: 'MMMM D, YYYY'
    },
    ranges: {
      'Today': [moment(), moment()],
      'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
      'Last 7 Days': [moment().subtract(6, 'days'), moment()],
      'Last 30 Days': [moment().subtract(29, 'days'), moment()],
      'This Month': [moment().startOf('month'), moment().endOf('month')],
      'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')],
      'All time': [moment('1970-01-01'), moment().add(9999, 'days')],
    }
  }, cb);
  cb(start, end);

  $(".form_submit_btn").click(function (e) {
    e.preventDefault();
    var a = $(this),
    l = $(this).closest("form"),
    action = l.attr('action');
    var form_id = l.attr('id');
    l.validate({
      rules: {
        work_id: {
          required: !0
        }
      }, invalidHandler: function (e, r) {
        var i = $("#" + form_id + "_msg");
        i.removeClass("m--hide").show(), mUtil.scrollTo(i, -200)
      }, submitHandler: function (e) {
      }
    }), l.valid() && (a.addClass("m-loader m-loader--right m-loader--light").attr("disabled", !0),
    l.ajaxSubmit({
      url: action,
      success: function (e, t, r, s) {

        var modal_id = l.attr('data-modal-id');
        var form_type = l.attr('data-form-type');
        $("#" + form_id + "_msg").addClass("m--hide");
        // Block UI
        mApp.blockPage({
          overlayColor: "#000000",
          type: "loader",
          state: "success",
          message: "Please wait..."
        }), setTimeout(function () {
          mApp.unblockPage()
        }, 2e3);
        var obj = $.parseJSON(e);
        if (obj.status == 1) {
          a.removeClass("m-loader m-loader--right m-loader--light").attr("disabled", !1);
          $("#"+modal_id).modal('toggle');
          $("."+form_id+"_fields").val('');
          $("."+form_id+"_select").val('').trigger("change");
          table.ajax.reload();
          toastr[obj.flashdata_type](obj.flashdata_msg, obj.flashdata_title);
        } else {
          a.removeClass("m-loader m-loader--right m-loader--light").attr("disabled", !1);
          toastr[obj.flashdata_type](obj.flashdata_msg, obj.flashdata_title);
        }
        if (obj == null) {
          setTimeout(function () {
            a.removeClass("m-loader m-loader--right m-loader--light").attr("disabled", !1);
            toastr["warning"]("Your Attempt is Timed Out. Please Try Again.", "Timed Out");
          }, 2e4)
        }
      },error: function() {
        a.removeClass("m-loader m-loader--right m-loader--light").attr("disabled", !1);
        toastr["error"]("Sorry. There Has Been Some Error Occurred. Please Try Again.", "Error");
      }
    })
  )
});
})
</script>
