<?php $this->view("includes/Inc_pagehead"); ?>
<!-- Page Styles Goes Here-->

<?php $this->view("includes/Inc_navigation"); ?>
<div class="m-grid__item m-grid__item--fluid m-wrapper">
  <!-- BEGIN: Subheader -->
  <div class="m-subheader ">
    <div class="d-flex align-items-center">
      <div class="mr-auto">
        <h3 class="m-subheader__title m-subheader__title--separator">
          Manage Customers
        </h3>
        <ul class="m-subheader__breadcrumbs m-nav m-nav--inline">
          <li class="m-nav__item m-nav__item--home">
            <a href="#" class="m-nav__link m-nav__link--icon">
              <i class="m-nav__link-icon la la-home"></i>
            </a>
          </li>
          <li class="m-nav__separator">
            -
          </li>
          <li class="m-nav__item">
            <a href="<?php echo $this->session->userdata("dashboard_link") ?>" class="m-nav__link">
              <span class="m-nav__link-text">
                Home
              </span>
            </a>
          </li>
          <li class="m-nav__separator">
            -
          </li>
          <li class="m-nav__item">
            <a href="<?php echo base_url() . 'customers' ?>" class="m-nav__link">
              <span class="m-nav__link-text">
                Customers
              </span>
            </a>
          </li>


        </ul>
      </div>
      <div>

      </div>
    </div>
  </div>
  <!-- END: Subheader -->
  <div class="m-content">
    <div class="m-portlet m-portlet--mobile m-portlet--info m-portlet--head-solid-bg m-portlet--bordered m-portlet--rounded">
      <div class="m-portlet__head">
        <div class="m-portlet__head-caption">
          <div class="m-portlet__head-title">
            <h3 class="m-portlet__head-text">
              List of Customers
            </h3>
          </div>
        </div>
        <div class="m-portlet__head-tools">
          <?php if ($this->session->userdata('user_role') != 'auditor') { ?>
            <a href="#" data-toggle="modal" data-target="#customer_add_modal" class="btn btn-focus m-btn m-btn--custom m-btn--icon m-btn--air m-btn--pill">
              <span>
                <i class="la la-plus"></i>
                <span>
                  Create New Customers
                </span>
              </span>
            </a>
          <?php } ?>
        </div>
      </div>
      <div class="m-portlet__body">

        <?php if (!empty($this->config->item('company_branches'))) { ?>
          <!--begin: Search Form -->
          <div class="m-form m-form--label-align-right m--margin-bottom-10">
            <div class="row">
              <div class="col-xl-12 order-2 order-xl-1">
                <div class="form-group m-form__group row ">
                  <div class="col-lg-4">
                    <div class="form-group m-form__group">
                      <label>
                        Company Branch
                      </label>
                      <div class="m-select2 m-select2--air m-select2--pill">
                        <select width="100%" required class="form-control m-select2 table_filter company-branch-select2" id="company_branch">
                          <option selected value="all"> All Branches</option>
                          <option value="0">NO BRANCH</option>
                          <?php foreach ($this->config->item('company_branches') as $key => $value) { ?>
                            <option value="<?php echo $value->branch_id ?>"><?php echo $value->branch_name ?></option>
                          <?php } ?>
                        </select>
                      </div>
                      <span class="m-form__help"></span>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        <?php } ?>

        <!--begin: Datatable -->
        <table width="100%" class="table m-table nowrap table-header-fixed table-striped table-bordered table-hover table-header-fixed" id="customers_view_table">
          <thead>
            <tr class="">
              <th>ID</th>
              <th>Sl No</th>
              <th>Branch Name</th>
              <th>Customer/Company Name</th>
              <th>Contact Person</th>
              <th>Phone</th>
              <th>Email</th>
              <th>Address</th>
              <th>Sale Price Cat</th>
              <th>Tax No</th>
              <th>State Code</th>
              <th>Created on</th>
              <th>Actions</th>
              <th>State</th>
              <th>Sale Price Cat</th>
            </tr>
          </thead>
          <tbody>
          </tbody>
        </table>
        <!--end: Datatable -->
        <?php $this->view("modules/include_modals/modal_customers"); ?>
      </div>
    </div>
  </div>
</div>
</div>
<!-- end:: Body -->
<!-- begin::Footer -->

<?php $this->view("includes/Inc_footer"); ?>
<!-- end::Footer -->
</div>
<!-- end:: Page -->

<?php $this->view("includes/Inc_sidebar"); ?>
<?php $this->view("includes/Inc_scripts"); ?>
<!--begin::Page Snippets -->

<?php $this->view("modules/include_scripts/customers_scripts"); ?>

<script>
// $("#table_filter_status").selectpicker();
// $("[data-switch=true]").bootstrapSwitch()
</script>

<script>
$("#customers_menu").addClass('m-menu__item--active');

$("#table_filter_status").select2({
  placeholder: "Select Status"
})
$("#table_filter_start_date,#table_filter_end_date").datepicker({
  todayHighlight: !0,
  orientation: "bottom right",
  templates: {
    leftArrow: '<i class="la la-angle-left"></i>',
    rightArrow: '<i class="la la-angle-right"></i>'
  }
})
</script>
<script>
$('body').on('click', '#customer_edit_btn', function() {
  var no = $(this).closest('tr').children('td');
  $('#customer_id_edit').val(no.eq(0).text());
  $('#customer_name_edit').val(no.eq(3).text());
  $('#contact_person_edit').val(no.eq(4).text());
  $('#mobile_number_edit').val(no.eq(5).text());
  $('#email_edit').val(no.eq(6).text());
  $('#address_edit').val(no.eq(7).text());
  $('#taxno_edit').val(no.eq(9).text());
  $('#state_id_edit').val(no.eq(13).text()).trigger('change');
  $('#sale_price_category_edit').val(no.eq(14).text()).trigger('change');
})
$('body').on('click', '#customer_delete_btn', function() {
  var no = $(this).closest('tr').children('td');
  $('#customer_delete_id').val(no.eq(0).text());
})
</script>
<script>
var Datatable_customers_view_table = function() {
  var t = function() {

    function get_branch_id() {
      return $('#company_branch :selected').val();
    }

    var customers_view_table = $('#customers_view_table').DataTable({
      "ajax": {
        url: "<?php echo base_url() . 'customers/select_customers' ?>", // json datasource
        type: "post", // type of method  , by default would be get
        data: function(d) {
          <?php if (!empty($this->config->item('company_branches'))) { ?>
            d.branch_id = get_branch_id();
            <?php } ?>
          }
        },
        "bProcessing": true,
        "deferRender": true,
        "bDeferRender": true,
        "scrollX": true,
        buttons: [{
          extend: 'print',
          className: 'btn dark btn-outline',
          title: 'List of Sales Customers'
        },
        {
          extend: 'csv',
          className: 'btn purple btn-outline '
        },
        {
          extend: 'colvis',
          className: 'btn dark btn-outline',
          text: 'Columns'
        }
      ],
      dom: "<'row'<'col-sm-6 text-left'B><'col-sm-6 text-right'f>>\n\t\t\t<'row'<'col-sm-12'tr>>\n\t\t\t<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 dataTables_pager'lp>>", // horizobtal scrollable datatable
      "lengthMenu": [
        [25, 50, 100, -1],
        [25, 50, 100, "All"] // change per page values here
      ],
      "columnDefs": [{
        "targets": [0,13,14 <?php if ($this->session->userdata('user_role') == 'auditor') {
          echo ",9";
        } ?> <?php if (empty($this->config->item('company_branches'))) { echo ",2"; }?><?php if ($this->config->item('app_module_sales_invoice') != 1  || $this->config->item('Material_sale_price_category_enable') ==0){ echo ",8"; }?>
      ],
      className: "hidden"
    },
    {
      render: function (data, type, full, meta) {
        return "<div class='text-wrap width-200'>" + data + "</div>";
      },
      targets: [ 7 ],
    },],
    'order': false
  });
  $(".table_filter").on("change", function() {
    customers_view_table.ajax.reload();
  });

};
return {
  init: function() {
    t()
  }
}
}
();
jQuery(document).ready(function() {
  Datatable_customers_view_table.init();
  $(".form_submit_btn").click(function(e) {

    e.preventDefault();
    var a = $(this),
    l = $(this).closest("form"),
    action = l.attr('action');
    var form_id = l.attr('id');
    l.validate({
      rules: {
        "mobile_number": {
          required: !0,
          number: !0,
          minlength: 8,
          maxlength: 12
        }
      },
      invalidHandler: function(e, r) {
        var i = $("#" + form_id + "_msg");
        i.removeClass("m--hide").show(), mUtil.scrollTo(i, -200)
      },
      submitHandler: function(e) {}
    }), l.valid() && (a.addClass("m-loader m-loader--right m-loader--light").attr("disabled", !0),
    l.ajaxSubmit({
      url: action,
      success: function(e, t, r, s) {
        var modal_id = l.attr('data-modal-id');
        var form_type = l.attr('data-form-type');
        $("#" + form_id + "_msg").addClass("m--hide");
        // Block UI
        mApp.blockPage({
          overlayColor: "#000000",
          type: "loader",
          state: "success",
          message: "Please wait..."
        }), setTimeout(function() {
          mApp.unblockPage()
        }, 2e3);
        var obj = $.parseJSON(e);
        if (obj.status == 1) {
          a.removeClass("m-loader m-loader--right m-loader--light").attr("disabled", !1);
          toastr[obj.flashdata_type](obj.flashdata_msg, obj.flashdata_title);
          $("#" + modal_id).modal('toggle');
          $('#customers_view_table').dataTable().fnDestroy();
          Datatable_customers_view_table.init();

        } else {
          a.removeClass("m-loader m-loader--right m-loader--light").attr("disabled", !1);
          toastr[obj.flashdata_type](obj.flashdata_msg, obj.flashdata_title);
        }
        if (obj == null) {
          setTimeout(function() {
            a.removeClass("m-loader m-loader--right m-loader--light").attr("disabled", !1);
            toastr["warning"]("Your Attempt is Timed Out. Please Try Again.", "Timed Out");
          }, 2e4)
        }
      },
      error: function() {
        a.removeClass("m-loader m-loader--right m-loader--light").attr("disabled", !1);
        toastr["error"]("Sorry. There Has Been Some Error Occurred. Please Try Again.", "Error");
      }
    })
  )
});
});
</script>
