<?php $this->view("includes/Inc_pagehead"); ?>
<!-- Page Styles Goes Here-->

<?php $this->view("includes/Inc_navigation"); ?>
<div class="m-grid__item m-grid__item--fluid m-wrapper">
  <!-- BEGIN: Subheader -->
  <div class="m-subheader ">
    <div class="d-flex align-items-center">
      <div class="mr-auto">
        <h3 class="m-subheader__title m-subheader__title--separator">
          Client Details
        </h3>
        <ul class="m-subheader__breadcrumbs m-nav m-nav--inline">
          <li class="m-nav__item m-nav__item--home">
            <a href="#" class="m-nav__link m-nav__link--icon">
              <i class="m-nav__link-icon la la-home"></i>
            </a>
          </li>
          <li class="m-nav__separator">
            -
          </li>
          <li class="m-nav__item">
            <a href="<?php echo base_url() . 'dashboard' ?>" class="m-nav__link">
              <span class="m-nav__link-text">
                Home
              </span>
            </a>
          </li>
          <li class="m-nav__separator">
            -
          </li>
          <li class="m-nav__item">
            <a href="<?php echo base_url() . 'clients' ?>" class="m-nav__link">
              <span class="m-nav__link-text">
                Client Details
              </span>
            </a>
          </li>


        </ul>
      </div>
      <div>

      </div>
    </div>
  </div>
  <!-- END: Subheader -->
  <div class="m-content">
    <div class="m-portlet m-portlet--mobile m-portlet--info m-portlet--head-solid-bg m-portlet--bordered m-portlet--rounded">
      <div class="m-portlet__head">
        <div class="m-portlet__head-caption">
          <div class="m-portlet__head-title">
            <h3 class="m-portlet__head-text">
              List of Clients Registered
            </h3>
          </div>
        </div>
        <div class="m-portlet__head-tools">
          <?php if ($this->session->userdata('user_role') != 'auditor' || $this->session->userdata('user_data_permission')['adding'] == 1) { ?>
            <a href="#" data-toggle="modal" data-target="#client_add_modal" class="btn btn-focus m-btn m-btn--custom m-btn--icon m-btn--air m-btn--pill">
              <span>
                <i class="la la-plus"></i>
                <span>
                  Add New Client
                </span>
              </span>
            </a>
          <?php } ?>
        </div>
      </div>
      <div class="m-portlet__body">

        <?php if (!empty($this->config->item('company_branches'))) { ?>
          <!--begin: Search Form -->
          <div class="m-form m-form--label-align-right m--margin-bottom-10">
            <div class="row">
              <div class="col-xl-12 order-2 order-xl-1">
                <div class="form-group m-form__group row ">
                  <div class="col-lg-4">
                    <div class="form-group m-form__group">
                      <label>
                        Company Branch
                      </label>
                      <div class="m-select2 m-select2--air m-select2--pill">
                        <select width="100%" required class="form-control m-select2 table_filter company-branch-select2" id="company_branch">
                          <option selected value="all"> All Branches</option>
                          <option value="0">NO BRANCH</option>
                          <?php foreach ($this->config->item('company_branches') as $key => $value) { ?>
                            <option value="<?php echo $value->branch_id ?>"><?php echo $value->branch_name ?></option>
                          <?php } ?>
                        </select>
                      </div>
                      <span class="m-form__help"></span>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        <?php } ?>
        <!--begin: Datatable -->
        <table width="100%" class="table m-table nowrap table-header-fixed table-striped table-bordered table-hover table-header-fixed" id="client_view_table">
          <thead>
            <tr class="">
              <th>Client ID</th>
              <th>Branch Name</th>
              <th>Name</th>
              <th>Contact Person</th>
              <th>Phone</th>
              <th>Whatsapp No</th>
              <th>Email</th>
              <th>PO Box</th>
              <th>Address</th>
              <th>Company Name</th>
              <th>Group Name</th>
              <th><?php echo $this->config->item('Tax_tax_name') ?>/TRN No</th>
              <th><?php echo $this->config->item('Tax_tax_name') ?> Date</th>
              <th><?php echo $this->config->item('Tax_tax_name') ?> State</th>
              <th>Civil ID</th>
              <?php if ($this->config->item('Mobile_App_client_login') == 1) { ?>
                <th>Password</th>
              <?php } ?>
              <th>Actions</th>
              <th>Tax State Id</th>
            </tr>
          </thead>
          <tbody>
          </tbody>
        </table>
        <!--end: Datatable -->
        <?php $this->view("modules/include_modals/modal_client_add"); ?>

        <div class="modal fade" tabindex="-1" id="client_edit_modal" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
          <div class="modal-dialog " role="document" style="max-width: 800px">
            <div class="modal-content">
              <div class="modal-header" style="background-color: #00c5dc;border-radius: 4px">
                <h5 class="modal-title" id="exampleModalLabel" style="color: #ffffff">
                  Edit Client Details
                </h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                  <span aria-hidden="true">
                    &times;
                  </span>
                </button>
              </div>
              <form autocomplete="off" data-modal-id="client_edit_modal" id="form_client_edit" method="post" action="<?php echo base_url() . 'clients/update' ?>" enctype="multipart/form-data" class="m-form m-form--fit m-form--state m-form--label-align-right ">
                <div class="modal-body">
                  <div class="m-form__content">
                    <div class="m-alert m-alert--icon alert alert-warning m--hide" role="alert" id="form_client_edit_msg">
                      <div class="m-alert__icon">
                        <i class="la la-warning"></i>
                      </div>
                      <div class="m-alert__text">
                        Oh snap! Change a few things up and try submitting again.
                      </div>
                      <div class="m-alert__close">
                        <button type="button" class="close" data-close="alert" aria-label="Close"></button>
                      </div>
                    </div>
                  </div>
                  <div class="row">
                    <div class="col-lg-12">
                      <div class="form-group m-form__group">
                        <label for="user_name">
                          Client Name
                        </label>
                        <div class="input-group m-input-group m-input-group--pill m-input-group--air">
                          <div class="input-group-prepend">
                            <span class="input-group-text" id="basic-addon1">
                              <i class="la la-user"></i>
                            </span>
                          </div>
                          <input required type="text" name="name" id="name" class="form-control form_client_edit_fields m-input" placeholder="Client Name" aria-describedby="basic-addon1">
                        </div>
                        <span class="m-form__help"></span>
                      </div>
                    </div>
                    <div class="col-lg-6">
                      <div class="form-group m-form__group">
                        <label for="user_name">
                          Contact Person
                        </label>
                        <div class="input-group m-input-group m-input-group--pill m-input-group--air">
                          <div class="input-group-prepend">
                            <span class="input-group-text" id="basic-addon1">
                              <i class="la la-user"></i>
                            </span>
                          </div>
                          <input type="text" name="contact_person" id="contact_person_edit" class="form-control form_client_edit_fields m-input" placeholder="Contact Person" aria-describedby="basic-addon1">
                        </div>
                        <span class="m-form__help"></span>
                      </div>
                    </div>
                    <div class="col-lg-6">
                      <div class="form-group m-form__group">
                        <label for="user_name">
                          Phone
                        </label>
                        <div class="input-group m-input-group m-input-group--pill m-input-group--air">
                          <div class="input-group-prepend">
                            <span class="input-group-text" id="basic-addon1">
                              <i class="la la-phone"></i>
                            </span>
                          </div>
                          <input required type="text" name="phone" id="phone_edit" class="form_client_edit_fields form-control m-input" placeholder="Phone No" aria-describedby="basic-addon1">
                        </div>
                        <span class="m-form__help"></span>
                      </div>
                    </div>
                    <div class="col-lg-6">
                      <div class="form-group m-form__group">
                        <label for="user_name">
                          Whatsapp No
                        </label>
                        <div class="input-group m-input-group m-input-group--pill m-input-group--air">
                          <div class="input-group-prepend">
                            <span class="input-group-text" id="basic-addon1">
                              <i class="la la-whatsapp"></i>
                            </span>
                          </div>
                          <input type="text" name="whatsapp_no" id="whatsapp_no_edit" class="form_client_edit_fields form-control m-input" placeholder="Whatsapp No" aria-describedby="basic-addon1">
                        </div>
                        <span class="m-form__help"></span>
                      </div>
                    </div>
                    <div class="col-lg-6">
                      <div class="form-group m-form__group">
                        <label for="user_name">
                          Email
                        </label>
                        <div class="input-group m-input-group m-input-group--pill m-input-group--air">
                          <div class="input-group-prepend">
                            <span class="input-group-text" id="basic-addon1">
                              <i class="la la-envelope"></i>
                            </span>
                          </div>
                          <input type="text" name="email" id="email_edit" class="form_client_edit_fields form-control m-input" placeholder="Email ID" aria-describedby="basic-addon1">
                        </div>
                        <span class="m-form__help"></span>
                      </div>
                    </div>
                    <div class="col-lg-6">
                      <div class="form-group m-form__group">
                        <label for="user_name">
                          Company Name
                        </label>
                        <div class="input-group m-input-group m-input-group--pill m-input-group--air">
                          <div class="input-group-prepend">
                            <span class="input-group-text" id="basic-addon1">
                              <i class="la la-edit"></i>
                            </span>
                          </div>
                          <input  type="text" name="company_name" id="company_name_edit"  class="form_client_edit_fields form-control m-input" placeholder="Company Name" aria-describedby="basic-addon1">
                        </div>
                        <span class="m-form__help"></span>
                      </div>
                    </div>
                    <div class="col-lg-6">
                      <div class="form-group m-form__group">
                        <label for="user_name">
                          Group Name
                        </label>
                        <div class="input-group m-input-group m-input-group--pill m-input-group--air">
                          <div class="input-group-prepend">
                            <span class="input-group-text" id="basic-addon1">
                              <i class="la la-edit"></i>
                            </span>
                          </div>
                          <input type="text" name="group_name" id="group_name_edit"  class="form_client_edit_fields form-control m-input" placeholder="Group Name" aria-describedby="basic-addon1">
                        </div>
                        <span class="m-form__help"></span>
                      </div>
                    </div>
                    <div class="col-lg-6">
                      <div class="form-group m-form__group">
                        <label for="user_name">
                          PO Box No
                        </label>
                        <div class="input-group m-input-group m-input-group--pill m-input-group--air">
                          <div class="input-group-prepend">
                            <span class="input-group-text" id="basic-addon1">
                              <i class="la la-edit"></i>
                            </span>
                          </div>
                          <input type="text" name="po_box" id="po_box_edit"  class="form_client_edit_fields form-control m-input" placeholder="PO Box No" aria-describedby="basic-addon1">
                        </div>
                        <span class="m-form__help"></span>
                      </div>
                    </div>
                    <div class="col-lg-6">
                      <div class="form-group m-form__group">
                        <label for="user_name">
                          Address
                        </label>
                        <textarea placeholder="Address" id="address_edit" name="address" class="form-control form_client_edit_fields  m-input  m-input--air m-input--pill"></textarea>
                        <span class="m-form__help"></span>
                      </div>
                    </div>
                    <div class="col-lg-4">
                      <div class="form-group m-form__group">
                        <label for="user_name">
                          Civil Id No
                        </label>
                        <div class="input-group m-input-group m-input-group--pill m-input-group--air">
                          <div class="input-group-prepend">
                            <span class="input-group-text" id="basic-addon1">
                              <i class="la la-user"></i>
                            </span>
                          </div>
                          <input type="text" name="civil_id" id="civil_id_edit" class="form_client_edit_fields form-control m-input" placeholder="Civil ID No" aria-describedby="basic-addon1">
                        </div>
                        <span class="m-form__help"></span>
                      </div>
                    </div>
                    <div class="col-lg-4">
                      <div class="form-group m-form__group">
                        <label for="user_name">
                          <?php echo $this->config->item('Tax_tax_name') ?>/TRN No
                        </label>
                        <div class="input-group m-input-group m-input-group--pill m-input-group--air">
                          <div class="input-group-prepend">
                            <span class="input-group-text" id="basic-addon1">
                              <i class="la la-edit"></i>
                            </span>
                          </div>
                          <input type="text" name="tax_no" id="tax_no_edit" class="form_client_edit_fields form-control m-input" placeholder="<?php echo $this->config->item('Tax_tax_name') ?>/TRN No" aria-describedby="basic-addon1">
                        </div>
                        <span class="m-form__help"></span>
                      </div>
                    </div>
                    <div class="col-lg-4">
                      <div class="form-group m-form__group">
                        <label for="user_name">
                          <?php echo $this->config->item('Tax_tax_name') ?> Date
                        </label>
                        <div class="input-group m-input-group m-input-group--pill m-input-group--air">
                          <div class="input-group-prepend">
                            <span class="input-group-text" id="basic-addon1">
                              <i class="la la-edit"></i>
                            </span>
                          </div>
                          <input type="text" data-date-format="dd-mm-yyyy" name="tax_date" id="tax_date_edit" class="form_client_edit_fields form-control m-input" placeholder="<?php echo $this->config->item('Tax_tax_name') ?> Date" aria-describedby="basic-addon1">
                        </div>
                        <span class="m-form__help"></span>
                      </div>
                    </div>
                    <div class="col-lg-4">
                      <div class="form-group m-form__group"  >
                        <label for="user_name">
                          State Code
                        </label>
                        <div class="m-select2 m-select2--air m-select2--pill">
                          <select required id="state_id_edit"  name="state_id"  style="width: 100%" class="form-control m-input"  aria-describedby="basic-addon1" >
                            <option selected disabled>Select State</option>
                            <option value="0">N/A</option>
                            <?php
                            foreach($tax_state_codes as $row):
                              ?>
                              <option value="<?php echo $row->state_id?>"><?php echo $row->state_name." - ".$row->state_code?></option>
                              <?php
                            endforeach;
                            ?>
                          </select>
                        </div>
                        <span class="m-form__help"></span>
                      </div>
                    </div>
                    <?php if ($this->config->item('Mobile_App_client_login') == 1) { ?>
                      <div class="col-lg-6">
                        <div class="form-group m-form__group">
                          <label for="user_name">
                            Password
                          </label>
                          <div class="input-group m-input-group m-input-group--pill m-input-group--air">
                            <div class="input-group-prepend">
                              <span class="input-group-text" id="basic-addon1">
                                <i class="la la-key"></i>
                              </span>
                            </div>
                            <input type="text" name="password" id="password_edit" class="form_client_edit_fields form-control m-input" placeholder="App Login Password" aria-describedby="basic-addon1">
                          </div>
                          <span class="m-form__help"></span>
                        </div>
                      </div>
                    <?php } ?>
                    <input type="hidden" name="client_id" id="client_edit_id">
                  </div>
                </div>
                <div class="modal-footer">
                  <button type="button" class="btn btn-secondary" data-dismiss="modal">
                    Close
                  </button>
                  <button type="submit" class="btn btn-primary form_submit_btn">
                    Submit
                  </button>
                </div>
              </form>
            </div>
          </div>
        </div>
        <div class="modal fade" tabindex="-1" id="client_delete_modal" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
          <div class="modal-dialog " role="document">
            <form autocomplete="off" method="post" data-modal-id="client_delete_modal" id="form_client_delete" action="<?php echo base_url() . 'clients/delete' ?>" class="form-horizontal">
              <div class="modal-content">
                <div class="alert alert-danger" role="alert" style="margin-bottom: 0px">
                  <button type="button" class="close" data-dismiss="modal"></button>
                  <br />
                  <h4 class="alert-heading">Warning! Please Confirm Your Action</h4>
                  <br />
                  <p> Are You Sure to Delete this Data ?. All the Associated Data will Lost. </p>
                  <p>
                    <button class="btn btn-danger form_submit_btn" id="delete_purchase_item" type="submit" name="submit">Confirm & Delete</button>
                    <button type="button" class="btn btn-primary modal-dismiss" data-dismiss="modal">Cancel</button>
                  </p>
                  <input type="hidden" name="client_id" id="client_id_delete">
                </div>
              </div>
            </form>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>
</div>
<!-- end:: Body -->
<!-- begin::Footer -->

<?php $this->view("includes/Inc_footer"); ?>
<!-- end::Footer -->
</div>
<!-- end:: Page -->

<?php $this->view("includes/Inc_sidebar"); ?>
<?php $this->view("includes/Inc_scripts"); ?>

<!--begin::Page Snippets -->
<script>
$("#clients_menu").addClass('m-menu__item--active');

$("#state_id_add").select2({
  placeholder: "Select State Code",
  dropdownParent: $("#form_client_add")
})
$("#state_id_edit").select2({
  placeholder: "Select State Code",
  dropdownParent: $("#form_client_edit")
})

$("#tax_date_add,#tax_date_edit").datepicker({
  todayHighlight: !0,
  orientation: "bottom left",
  templates: {
    leftArrow: '<i class="la la-angle-left"></i>',
    rightArrow: '<i class="la la-angle-right"></i>'
  }
})
//  client List Data Table
function GetSearchStatus() {
  return $('#table_filter_status').val();
}

function get_branch_id() {
  return $('#company_branch :selected').val();
}


var client_view_table = $('#client_view_table').DataTable({
  "ajax": {
    url: "<?php echo base_url() . 'clients/select_client' ?>", // json datasource
    type: "post", // type of method  , by default would be get
    data: function(d) {
      //                         d.status = GetSearchStatus();
      <?php if (!empty($this->config->item('company_branches'))) { ?>
        d.branch_id = get_branch_id();
        <?php } ?>
      }
    },
    "bProcessing": true,
    "deferRender": true,
    "bDeferRender": true,
    "scrollX": true,
    buttons: [{
      extend: 'print',
      className: 'btn dark btn-outline',
      exportOptions: {
        columns: ':visible'
      },
      title: 'List of Clients'
    },
    {
      extend: 'csv',
      className: 'btn purple btn-outline '
    },
    {
      extend: 'colvis',
      className: 'btn dark btn-outline',
      text: 'Columns'
    }
  ],
  dom: "<'row'<'col-sm-6 text-left'B><'col-sm-6 text-right'f>>\n\t\t\t<'row'<'col-sm-12'tr>>\n\t\t\t<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 dataTables_pager'lp>>", // horizobtal scrollable datatable
  "lengthMenu": [
    [25, 50, 100, -1],
    [25, 50, 100, "All"] // change per page values here
  ],
  "columnDefs": [{
    "targets": [<?php if ($this->session->userdata('user_role') == 'general_manager' && $this->config->item('User_general_manager_show_client_info') == 0) {
      echo "4,5,6";
    } ?> <?php if (empty($this->config->item('company_branches'))) { echo ",1"; }?><?php if ($this->config->item('Mobile_App_client_login') == 1) { echo ",17";}else{ echo ",16";}?>
  ],
  className: "hidden"
},
{
  render: function(data, type, full, meta) {
    return "<div class='text-wrap width-300'>" + data + "</div>";
  },
  targets: 8
},
],
// set the initial value
"pageLength": 25,
'order': [
  [0, 'desc']
]
});
$(".table_filter").on("change", function() {
  client_view_table.ajax.reload();
});
$(".hide_column").hide();
</script>
<script>
$('body').on('click', '#client_edit_btn', function() {
  var no = $(this).closest('tr').children('td');
  $('#client_edit_id').val(no.eq(0).text());
  $('#name').val(no.eq(2).text());
  $('#contact_person_edit').val(no.eq(3).text());
  $('#phone_edit').val(no.eq(4).text());
  $('#whatsapp_no_edit').val(no.eq(5).text());
  $('#email_edit').val(no.eq(6).text());
  $('#po_box_edit').val(no.eq(7).text());
  $('#address_edit').val(no.eq(8).text());
  $('#tax_no_edit').val(no.eq(11).text());
  $('#company_name_edit').val(no.eq(9).text());
  $('#group_name_edit').val(no.eq(10).text());
  $('#tax_date_edit').datepicker("setDate",no.eq(12).text());
  $('#civil_id_edit').val(no.eq(14).text());
  <?php if($this->config->item('Mobile_App_client_login')==1){?>
    $('#password_edit').val(no.eq(15).text());
    $('#state_id_edit').val(no.eq(17).text()).trigger('change');
    <?php }else{ ?>
      $('#state_id_edit').val(no.eq(16).text()).trigger('change');
      <?php } ?>
    })
    $('body').on('click', '#client_delete_btn', function() {
      var no = $(this).closest('tr').children('td');
      $('#client_id_delete').val(no.eq(0).text());
    })
  </script>
  <script>
  $(".form_submit_btn").click(function(e) {

    e.preventDefault();
    var a = $(this),
    l = $(this).closest("form"),
    action = l.attr('action');
    var form_id = l.attr('id');
    l.validate({
      rules: {
        "paid_amount": {
          required: !0
        }
      },
      invalidHandler: function(e, r) {
        var i = $("#" + form_id + "_msg");
        i.removeClass("m--hide").show(), mUtil.scrollTo(i, -200)
      },
      submitHandler: function(e) {}
    }), l.valid() && (a.addClass("m-loader m-loader--right m-loader--light").attr("disabled", !0),
    l.ajaxSubmit({
      url: action,
      success: function(e, t, r, s) {
        var modal_id = l.attr('data-modal-id');
        var form_type = l.attr('data-form-type');
        $("#" + form_id + "_msg").addClass("m--hide");
        // Block UI
        mApp.blockPage({
          overlayColor: "#000000",
          type: "loader",
          state: "success",
          message: "Please wait..."
        }), setTimeout(function() {
          mApp.unblockPage()
        }, 2e3);
        var obj = $.parseJSON(e);
        if (obj.status == 1) {
          a.removeClass("m-loader m-loader--right m-loader--light").attr("disabled", !1);
          toastr[obj.flashdata_type](obj.flashdata_msg, obj.flashdata_title);
          $("#" + modal_id).modal('toggle');
          $("." + form_id + "_fields").val('');
          $("." + form_id + "_select").val('').trigger("change");

          client_view_table.ajax.reload();
        } else {
          a.removeClass("m-loader m-loader--right m-loader--light").attr("disabled", !1);
          toastr[obj.flashdata_type](obj.flashdata_msg, obj.flashdata_title);
        }
        if (obj == null) {
          setTimeout(function() {
            a.removeClass("m-loader m-loader--right m-loader--light").attr("disabled", !1);
            toastr["warning"]("Your Attempt is Timed Out. Please Try Again.", "Timed Out");
          }, 2e4)
        }
      },
      error: function() {
        a.removeClass("m-loader m-loader--right m-loader--light").attr("disabled", !1);
        toastr["error"]("Sorry. There Has Been Some Error Occurred. Please Try Again.", "Error");
      }
    })
  )
});
</script>
