<?php $this->view("includes/Inc_pagehead");?>
<!-- Page Styles Goes Here-->

<?php $this->view("includes/Inc_navigation");?>
<div class="m-grid__item m-grid__item--fluid m-wrapper">
  <!-- BEGIN: Subheader -->
  <div class="m-subheader ">
    <div class="d-flex align-items-center">
      <div class="mr-auto">
        <h3 class="m-subheader__title m-subheader__title--separator">
          BOQ - Update Daily Progress
        </h3>
        <ul class="m-subheader__breadcrumbs m-nav m-nav--inline">
          <li class="m-nav__item m-nav__item--home">
            <a href="#" class="m-nav__link m-nav__link--icon">
              <i class="m-nav__link-icon la la-home"></i>
            </a>
          </li>
          <li class="m-nav__separator">
            -
          </li>
          <li class="m-nav__item">
            <a href="<?php echo base_url().'dashboard'?>" class="m-nav__link">
              <span class="m-nav__link-text">
                Home
              </span>
            </a>
          </li>
          <li class="m-nav__separator">
            -
          </li>
          <li class="m-nav__item">
            <a href="<?php echo base_url().'work' ?>" class="m-nav__link">
              <span class="m-nav__link-text">
                BOQ Details
              </span>
            </a>
          </li>
        </ul>
      </div>
      <div>
        <?php if ($this->session->flashdata('flashdata_msg') != "")
        {?>
          <div class="alert alert-<?php echo $this->session->flashdata('alert_type')?> alert-dismissible fade show   m-alert m-alert--air m-alert--outline m-alert--outline-2x" role="alert">
            <button type="button" class="close" data-dismiss="alert" aria-label="Close"></button>
            <strong>
              <?php echo $this->session->flashdata('flashdata_title')?>
            </strong>
            <?php echo $this->session->flashdata('flashdata_msg')?>
          </div>
        <?php } ?>
      </div>
    </div>
  </div>
  <!-- END: Subheader -->
  <div class="m-content">
    <div class="m-portlet m-portlet--mobile m-portlet--info m-portlet--head-solid-bg m-portlet--bordered m-portlet--rounded">
      <div class="m-portlet__head">
        <div class="m-portlet__head-caption">
          <div class="m-portlet__head-title">
            <h3 class="m-portlet__head-text">
              BOQ - Update Daily Progress
            </h3>
          </div>
        </div>
        <div class="m-portlet__head-tools">

        </div>
      </div>
      <form autocomplete="off"  id="form_boq_progress_add" method="post" action="<?php echo base_url().'boq/create_daily_progress'?>" enctype="multipart/form-data" class="m-form m-form--fit m-form--state m-form--label-align-right ">
        <div class="m-portlet__body" style="padding: 2.2rem 2.2rem !important;">
          <!--begin: Datatable -->
          <div class="m-form m-form--label-align-right m--margin-bottom-10">
            <div class="row">
              <div class="col-md-4">
                <div class="form-group m-form__group">
                  <label>Project</label>
                  <input type="text" value="<?php echo $project_data->work_name ?>" name="project_name" class="form-control m-input m-input--air m-input--pill  m-input--solid" >
                </div>
              </div>
              <div class="col-md-4">
                <div class="form-group m-form__group">
                  <label>BOQ Name</label>
                  <input type="text" value="<?php echo $boq_data->boq_name ?>" name="boq_name" class="form-control m-input m-input--air m-input--pill  m-input--solid" >
                  <input type="hidden" value="<?php echo $boq_data->boq_id ?>" name="boq_id">
                </div>
              </div>
              <div class="col-md-4">
                <div class="form-group m-form__group">
                  <label>Date</label>
                  <input required value="<?php echo date('d-m-Y')?>" data-date-format="dd-mm-yyyy" id="work_date" name="work_date" type="text"  class="form-control m-input  m-input--pill m-input--air" placeholder="Work Date" >
                </div>
              </div>
            </div>
            <br/>
            <div class="row">
              <div class="col-md-12">
                <div class="form-group m-form__group">
                  <label>Remarks</label>
                  <input  name="remarks" type="text"  class="form-control m-input  m-input--pill m-input--air" placeholder="Some Remarks Here" >
                </div>
              </div>
            </div>
          </div>
          <table class="table table-striped table-bordered table-hover table-header-fixed" id="table_boq_list">
            <thead>
              <tr class="">
                <th>Select</th>
                <th>ID</th>
                <th>#</th>
                <th>ITEM</th>
                <th style="width: 100%">DESCRIPTION</th>
                <th>QTY<br/>(BOQ)</th>
                <th>UNIT</th>
                <th>UNIT PRICE<br/>(BOQ)</th>
                <th>TOTAL PRICE<br/>(BOQ)</th>
                <th>Acheived/<br/>Consumed Qty</th>
                <th>Unit Rate<br/>(Expense)</th>
                <th>Consumption<br/>Type</th>
              </tr>
            </thead>
            <tbody id="table-body">
            </tbody>
          </table>
        </div>
        <div class="m-portlet__foot m-portlet__foot--fit">
          <div class="m-form__actions m-form__actions">
            <div class="row">
              <div class="col-lg-9 ml-lg-auto">
                <button type="submit" class="btn btn-brand form_submit_btn">
                  Submit
                </button>
                <button type="reset" class="btn btn-secondary">
                  Cancel
                </button>
              </div>
            </div>
          </div>
        </div>
      </form>
    </div>
  </div>

</div>
</div>
<!-- end:: Body -->
<!-- begin::Footer -->
<!-- end::Footer -->
<!-- end:: Page -->
<?php $this->view("includes/Inc_footer");?>
</div>

<?php $this->view("includes/Inc_sidebar");?>
<?php $this->view("includes/Inc_scripts");?>


<!--begin::Page Snippets -->
<script>
$("#table_filter_status").selectpicker();
$("[data-switch=true]").bootstrapSwitch()
</script>
<!--end::Page Snippets -->
<script>

$("#works_menu").addClass('m-menu__item--active m-menu__item--open');
$("#works_menu_2").addClass('m-menu__item--active');

//    Toggle Sidebar
$("#m_aside_left_minimize_toggle").addClass("m-brand__toggler--active");
$("#body").addClass("m-brand--minimize m-aside-left--minimize");

$("#work_date").datepicker( {
  todayHighlight:!0, orientation:"bottom left", templates: {
    leftArrow: '<i class="la la-angle-left"></i>', rightArrow: '<i class="la la-angle-right"></i>'
  }
})
</script>

<script>
function init_table() {
  $('#table_boq_list').dataTable().fnDestroy();
  var table = $('#table_boq_list').dataTable({
    "scrollX" : true,
    dom:"<'row'<'col-sm-6 text-left'><'col-sm-6 text-right'f>>\n\t\t\t<'row'<'col-sm-12'tr>>\n\t\t\t<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 dataTables_pager'lp>>", // horizobtal scrollable datatable
    "columnDefs": [
      {
        "targets": [1,2],
        className: "hidden"
      }
    ],
    'order': false,
    'ordering':false,
    "paging":false,
    "searching":false
  });
  $("body").on("change", ".checkbox_display", function (event) {
    $('#table_boq_list').DataTable()
    .columns.adjust()
    .responsive.recalc();
  })
}
</script>
<script type="text/javascript">
var project_id="<?php echo $boq_data->project_id ?>";
var boq_id="<?php echo $boq_data->boq_id ?>";
function get_tasks() {
  //          Select Work Categories
  $.post("<?php echo base_url() ?>boq/select_boq_task_list_consumption",{project_id:project_id,boq_id:boq_id},function (data) {
    var obj=$.parseJSON(data);
    $("#table-body").html('');
    if(parseInt(obj.work_count)>0){
      var content=obj.content;
      $("#table-body").html(content);
    }
    init_table();
  })

}
$(document).ready(function () {
  get_tasks();
})
</script>

<script>

$("body").on("change", ".checkbox_display", function (event) {
  var type = $(this).data("checkbox-type");
  var id = $(this).data("id");
  var child_id = $(this).data("child");
  if($(this).prop("checked") == true){
    $(".div_"+type+"_"+id).show();
    $(".input_"+type+"_"+id).show();
    $(".input_"+type+"_"+id).attr('required',true).trigger('change');
  }else{
    $(".div_"+type+"_"+id).hide();
    $(".input_"+type+"_"+id).hide();
    $(".input_"+type+"_"+id).removeAttr('required',true);
    // Close All Child
    if(child_id!=''){
      $("."+child_id).prop('checked',false).trigger('change');
    }
  }

  if(type=='task'){
    calculate_task_unit_rate(id);
  }else if(type=='item'){
    calculate_task_unit_rate($(this).data("parent"));
  }
});

$("body").on("change keyup", ".input_fields", function (event) {
  var type = $(this).data("type");
  if(type=='task'){
    calculate_task_unit_rate($(this).data("id"));
  }else if(type=='item'){
    calculate_task_unit_rate($(this).data("parent"));
  }
})

function calculate_task_unit_rate(task_id){
  // get Items
  var task_item_total_amount = 0;
  $(".checkbox_task_"+task_id).each(function () {
    if($(this).prop("checked") == true){
      var item_id = $(this).data('id');
      var item_qty = parseFloat($("#item_qty_"+item_id).val());
      var unit_rate = parseFloat($("#item_rate_"+item_id).val());
      if(isNaN(item_qty)) {
        var item_qty = 0;
      }
      if(isNaN(unit_rate)) {
        var unit_rate = 0;
      }
      if(item_qty!='' && item_qty!=null && item_qty!=0 && unit_rate!='' && unit_rate!=null && unit_rate!=0){
        var item_total = item_qty*unit_rate;
        task_item_total_amount += item_total;
      }
    }
  })
  var task_qty = parseFloat($("#task_qty_"+task_id).val());
  if(isNaN(task_qty)) {
    var task_qty = 0;
  }
  if(task_qty!='' && task_qty!=null && task_qty!=0 && task_item_total_amount!=0){
    var task_unit_price = (task_item_total_amount/task_qty).toFixed(2);
    $("#task_rate_"+task_id).val(task_unit_price);
  }
}

</script>

<script>

jQuery(document).ready(function() {
  $(".form_submit_btn").click(function (e) {
    e.preventDefault();
    var a = $(this),
    l = $(this).closest("form"),
    action = l.attr('action');
    var form_id = l.attr('id');
    if($(".task_check_box:checked").length > 0)
    {
      l.validate({
        rules: {
          "paid_amount": {
            required: !0,
            min: 1,
            number: !0
          },
          "budget": {
            number: !0,
            required: !0,
          }
        }, invalidHandler: function (e, r) {
          var i = $("#" + form_id + "_msg");
          i.removeClass("m--hide").show(), mUtil.scrollTo(i, -200)
        }, submitHandler: function (e) {
        }
      }),
      $(".numeric_fields").each(function () {
        $(this).rules('add', {
          number: !0
        });
      }),
      l.valid() && (a.addClass("m-loader m-loader--right m-loader--light").attr("disabled", !0),
      l.ajaxSubmit({
        url: action,
        success: function (e, t, r, s) {
          var modal_id = l.attr('data-modal-id');
          var form_type = l.attr('data-form-type');
          $("#" + form_id + "_msg").addClass("m--hide");
          // Block UI
          mApp.blockPage({
            overlayColor: "#000000",
            type: "loader",
            state: "success",
            message: "Please wait..."
          }), setTimeout(function () {
            mApp.unblockPage()
          }, 2e3);
          var obj = $.parseJSON(e);
          if (obj.status == 1) {
            a.removeClass("m-loader m-loader--right m-loader--light").attr("disabled", !1);
            toastr[obj.flashdata_type](obj.flashdata_msg, obj.flashdata_title);
            swal({
              width: 500,
              title: obj.flashdata_title,
              text: obj.flashdata_msg,
              type: obj.flashdata_type,
              // showCancelButton: !0,
              confirmButtonText: "OK",
              // cancelButtonText: "Add New Project",
              confirmButtonColor: '#3085d6',
              cancelButtonColor: '#d33',
              reverseButtons: !0,
              closeOnClickOutside: false,
              allowOutsideClick: false,
            }).then(function(e) {
              window.location.replace("<?php echo base_url()?>boq/profile/<?php echo $boq_data->boq_id ?>");
            })
          } else {
            a.removeClass("m-loader m-loader--right m-loader--light").attr("disabled", !1);
            toastr[obj.flashdata_type](obj.flashdata_msg, obj.flashdata_title);
          }
          if (obj == null) {
            setTimeout(function () {
              a.removeClass("m-loader m-loader--right m-loader--light").attr("disabled", !1);
              toastr["warning"]("Your Attempt is Timed Out. Please Try Again.", "Timed Out");
            }, 2e4)
          }
        },error: function() {
          a.removeClass("m-loader m-loader--right m-loader--light").attr("disabled", !1);
          toastr["error"]("Sorry. There Has Been Some Error Occurred. Please Try Again.", "Error");
        }
      })
    )
  }
  else
  {
    toastr["warning"]("Please Select a Task Atleast", "No Task Selected");
  }
});
});

</script>
