<?php $this->view("includes/Inc_pagehead");?>
<!-- Page Styles Goes Here-->

<?php $this->view("includes/Inc_navigation");?>
<div class="m-grid__item m-grid__item--fluid m-wrapper">
  <!-- BEGIN: Subheader -->
  <div class="m-subheader ">
    <div class="d-flex align-items-center">
      <div class="mr-auto">
        <h3 class="m-subheader__title m-subheader__title--separator">
          Monthly Attendance Reports
        </h3>
        <ul class="m-subheader__breadcrumbs m-nav m-nav--inline">
          <li class="m-nav__item m-nav__item--home">
            <a href="#" class="m-nav__link m-nav__link--icon">
              <i class="m-nav__link-icon la la-home"></i>
            </a>
          </li>
          <li class="m-nav__separator">
            -
          </li>
          <li class="m-nav__item">
            <a href="<?php echo base_url().'dashboard'?>" class="m-nav__link">
              <span class="m-nav__link-text">
                Home
              </span>
            </a>
          </li>
          <li class="m-nav__separator">
            -
          </li>
          <li class="m-nav__item">
            <a href="<?php echo base_url().'attendance/view/month' ?>" class="m-nav__link">
              <span class="m-nav__link-text">
                Monthly Attendance Reports
              </span>
            </a>
          </li>


        </ul>
      </div>
      <div>

      </div>
    </div>
  </div>
  <!-- END: Subheader -->
  <div class="m-content">
    <div class="m-portlet  m-portlet--rounded m-portlet--bordered">
      <div class="m-portlet__body" style="padding: 1rem 2.2rem;">
        <div class="m-form m-form--label-align-right m--margin-bottom-10">
          <div class="row ">
            <div class="col-xl-12 order-2 order-xl-1">
              <div class="form-group m-form__group row">
                <div class="col-md-3">
                  <div class="form-group m-form__group" >
                    <label for="user_name">Start Date</label>
                    <input value="<?php echo date("01-m-Y")?>" data-date-format="dd-mm-yyyy" required class="form-control m-input m-input--air m-input--pill" id="table_filter_start_date" placeholder="Start Date" type="text" />
                  </div>
                </div>
                <div class="col-md-3">
                  <div class="form-group m-form__group" >
                    <label for="user_name">End Date</label>
                    <input value="<?php echo date("t-m-Y")?>" data-date-format="dd-mm-yyyy" required class="form-control m-input m-input--air m-input--pill" id="table_filter_end_date" placeholder="End Date" type="text" />
                  </div>
                </div>
                <div class="col-md-3">
                  <div class="m-form__group ">
                    <label>
                      User:
                    </label>
                    <div class="m-select2 m-select2--air m-select2--pill">
                      <select style="width: 100%" class="form-control m-select2 table_filter" id="user"  name="user">
                        <option value="all">All Users</option>
                        <?php
                        foreach($users as $row): ?>
                        <option value="<?php echo $row->user_id?>"><?php echo $row->user_alias?></option>
                        <?php
                      endforeach;
                      ?>
                    </select>
                  </div>
                </div>
              </div>
              <div class="col-md-2">
                <div class="m-form__group ">
                  <label>
                    Salary Type:
                  </label>
                  <div class="m-select2 m-select2--air m-select2--pill">
                    <select style="width: 100%" class="form-control m-select2 table_filter" id="salary_type"  name="salary_type">
                      <option selected value="all">All Type</option>
                      <option value="Daily">Daily</option>
                      <option value="Monthly">Monthly</option>
                      <option value="Hourly">Hourly</option>
                  </select>
                </div>
              </div>
            </div>
              <div class="col-md-1">
                <br />
                <button style="margin-top: 7px" id="btn_go" class="btn btn-focus m-btn m-btn--custom m-btn--icon m-btn--air m-btn--pill">
                  <span>
                    <i class="la la-search"></i>
                    <span>
                      Go
                    </span>
                  </span>
                </button>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
  <div id="monthly_attendance_report_div" style="display:none" class="m-portlet m-portlet--mobile m-portlet--info m-portlet--head-solid-bg m-portlet--bordered m-portlet--rounded">
    <div class="m-portlet__head">
      <div class="m-portlet__head-caption">
        <div class="m-portlet__head-title">
          <h3 class="m-portlet__head-text">
            Monthly Attendance Reports
          </h3>
        </div>
      </div>
      <div class="m-portlet__head-tools">

      </div>
    </div>
    <div class="m-portlet__body">

      <table width="100%" class="table m-table nowrap table-header-fixed table-striped table-bordered table-hover table-header-fixed" id="monthly_attendance_view_table">
        <thead>
          <tr class="">
            <th>Sl No</th>
            <th>User</th>
            <th>Designation</th>
            <th>Basic Salary</th>
            <th>Type</th>
            <th>Total Days<br/>(Selected Period)</th>
            <th>Total Sundays</th>
            <th>Total Holidays</th>
            <th>Pay for A Day</th>
            <th>No of Leaves</th>
            <th>Sunday Worked</th>
            <th>Holiday Worked</th>
            <th>Leaves Adjusted</th>
            <th>No of Days<br/>Worked</th>
            <th>No of Days<br/>Eligible For Salary</th>
            <th>Total Basic Pay</th>
            <th>No of Not Marked<br/>(Sunday Excluded)</th>
          </tr>
        </thead>
        <tbody>
        </tbody>
      </table>


    </div>
  </div>

</div>
</div>
</div>
<!-- end:: Body -->
<!-- begin::Footer -->

<?php $this->view("includes/Inc_footer");?>
<!-- end::Footer -->
</div>
<!-- end:: Page -->

<?php $this->view("includes/Inc_sidebar");?>
<?php $this->view("includes/Inc_scripts");?>


<!--begin::Page Snippets -->

<script>
$("#daily_attendance_menu").addClass('m-menu__item--active m-menu__item--open');
$("#daily_attendance_menu_2").addClass('m-menu__item--active');

$("#table_filter_time").timepicker( {
  // defaultTime: "<?php //echo date("H:i:s a",strtotime($this->config->item('User_attendance_start_due_time')))?>",
  minuteStep: 1,
})
$("#user_add").select2({
  placeholder: "Select User",
  dropdownParent: $("#form_attendance_add")
})
$("#user").select2({
  placeholder: "Select User"
})
$("#user_2").select2({
  placeholder: "Select User"
})
$("#salary_type").select2({
  placeholder: "Select Salary Type"
})
$("#project").select2({
  placeholder: "Select Project",
  templateResult: format_project_dropdown
})
$("#attendance_status").select2({
  placeholder: "Select Status"
})
$("#table_filter_start_date,#table_filter_end_date,#report_date,#report_date_update,#report_date_view,#attendance_date_add").datepicker( {
  todayHighlight:!0, orientation:"bottom left", templates: {
    leftArrow: '<i class="la la-angle-left"></i>', rightArrow: '<i class="la la-angle-right"></i>'
  }
})

//  client List Data Table
jQuery(document).ready(function() {
  $('body').on('click', '#btn_go', function() {
    $("#monthly_attendance_report_div").show();
    monthly_report();
  })

  var monthly_report = function() {
    $('#monthly_attendance_view_table').dataTable().fnDestroy();
    function GetSearchStartDate(){
      return $('#table_filter_start_date').val();
    }
    function GetSearchuser(){
      return $('#user').val();
    }
    function GetSearchEndDate(){
      return $('#table_filter_end_date').val();
    }
    function GetSearchSalaryType(){
      return $('#salary_type').val();
    }
    $('#monthly_attendance_view_table').append('<caption class="table_caption" style="caption-side: top !important;text-align: center"><strong>Attendance Report Between '+GetSearchStartDate()+'  To  '+GetSearchEndDate()+'</strong></caption>');
    var table = $('#monthly_attendance_view_table').DataTable({
      "ajax":{
        url :"<?php echo base_url().'attendance/select_attendance_monthly' ?>", // json datasource
        type: "post", // type of method  , by default would be get
        data: function(d){
          d.start_date = GetSearchStartDate();
          d.end_date = GetSearchEndDate();
          d.user = GetSearchuser();
          d.salary_type = GetSearchSalaryType();
        }
      },
      "bProcessing": true,
      "deferRender": true,
      "bDeferRender": true,
      "scrollX" : true,
      buttons: [
        { extend: 'print', className: 'btn dark btn-outline',exportOptions: {columns: ':visible'},title: 'Monthly Attendance Report' },
        { extend: 'csv', className: 'btn purple btn-outline ' },
        { extend: 'colvis', className: 'btn dark btn-outline', text: 'Columns'}
      ],
      dom:"<'row'<'col-sm-6 text-left'B><'col-sm-6 text-right'f>>\n\t\t\t<'row'<'col-sm-12'tr>>\n\t\t\t<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 dataTables_pager'lp>>", // horizobtal scrollable datatable
      "lengthMenu": [
        [25, 50, 100, -1],
        [25, 50, 100, "All"] // change per page values here
      ],
      "columnDefs": [
        {
          "targets": [],
          className: "hidden"
        },

      ],
      scrollCollapse: true,

      'ordering': [0,'asc'],

    });
    $(".table_filter").on("change", function() {
      table.ajax.reload();
    });
    $(".hide_column").hide();
  }
})
</script>
<style>
.text-wrap{
  white-space:normal;
}
.width-200{
  width:400px;
}
.width-120{
  width:300px;
}
</style>
