<?php $this->view("includes/Inc_pagehead"); ?>
<!-- Page Styles Goes Here-->

<?php $this->view("includes/Inc_navigation"); ?>
<div class="m-grid__item m-grid__item--fluid m-wrapper">
  <!-- BEGIN: Subheader -->
  <div class="m-subheader ">
    <div class="d-flex align-items-center">
      <div class="mr-auto">
        <h3 class="m-subheader__title m-subheader__title--separator">
          Assets Management
        </h3>
        <ul class="m-subheader__breadcrumbs m-nav m-nav--inline">
          <li class="m-nav__item m-nav__item--home">
            <a href="#" class="m-nav__link m-nav__link--icon">
              <i class="m-nav__link-icon la la-home"></i>
            </a>
          </li>
          <li class="m-nav__separator">
            -
          </li>
          <li class="m-nav__item">
            <a href="<?php echo base_url() . 'dashboard' ?>" class="m-nav__link">
              <span class="m-nav__link-text">
                Home
              </span>
            </a>
          </li>
          <li class="m-nav__separator">
            -
          </li>
          <li class="m-nav__item">
            <a href="<?php echo base_url() . 'accounts/assets' ?>" class="m-nav__link">
              <span class="m-nav__link-text">
                Assets Management
              </span>
            </a>
          </li>
        </ul>
      </div>
      <div>
      </div>
    </div>
  </div>
  <!-- END: Subheader -->
  <div class="m-content">
    <div class="m-portlet m-portlet--mobile m-portlet--info m-portlet--head-solid-bg m-portlet--bordered m-portlet--rounded">
      <div class="m-portlet__head">
        <div class="m-portlet__head-caption">
          <div class="m-portlet__head-title">
            <h3 class="m-portlet__head-text">
              List of Assets
            </h3>
          </div>
        </div>
        <div class="m-portlet__head-tools">
          <?php if ($this->session->userdata('user_role') != 'auditor' || $this->session->userdata('user_data_permission')['adding'] == 1) { ?>
            <a href="#" data-toggle="modal" data-target="#asset_add_modal" class="btn btn-focus m-btn m-btn--custom m-btn--icon m-btn--air m-btn--pill">
              <span>
                <i class="la la-plus"></i>
                <span>
                  Add New Asset
                </span>
              </span>
            </a>
          <?php } ?>
        </div>
      </div>
      <div class="m-portlet__body">
        <?php if (!empty($this->config->item('company_branches'))) { ?>
          <!--begin: Search Form -->
          <div class="m-form m-form--label-align-right m--margin-bottom-10">
            <div class="row">
              <div class="col-xl-12 order-2 order-xl-1">
                <div class="form-group m-form__group row ">
                  <div class="col-lg-3">
                    <div class="form-group m-form__group">
                      <label>
                        Company Branch
                      </label>
                      <div class="m-select2 m-select2--air m-select2--pill">
                        <select width="100%" required class="form-control m-select2 table_filter company-branch-select2" id="company_branch">
                          <option selected value="all"> All Branches</option>
                          <option value="0">NO BRANCH</option>
                          <?php foreach ($this->config->item('company_branches') as $key => $value) { ?>
                            <option value="<?php echo $value->branch_id ?>"><?php echo $value->branch_name ?></option>
                          <?php } ?>
                        </select>
                      </div>
                      <span class="m-form__help"></span>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        <?php } ?>
        <table width="100%" class="table m-table nowrap table-header-fixed table-striped table-bordered table-hover table-header-fixed" id="asset_view_table">
          <thead>
            <tr class="">
              <th>Sl No</th>
              <th>Branch</th>
              <th>ID</th>
              <th>Asset Name</th>
              <th>Description</th>
              <th>Quantity</th>
              <th>Unit Cost</th>
              <th>Total Cost</th>
              <th>Purchased On</th>
              <th>Creation</th>
              <th>Action</th>
            </tr>
          </thead>
          <tbody>
          </tbody>
        </table>

        <div class="modal fade" tabindex="-1" id="asset_add_modal" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
          <div class="modal-dialog " role="document" style="max-width: 800px">
            <div class="modal-content">
              <div class="modal-header" style="background-color: #36a3f7;border-radius: 4px">
                <h5 class="modal-title" id="exampleModalLabel" style="color: #ffffff">
                  Add Asset
                </h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                  <span aria-hidden="true">
                    &times;
                  </span>
                </button>
              </div>
              <form autocomplete="off" id="form_asset_add" data-modal-id="asset_add_modal" method="post" action="<?php echo base_url() . 'accounts/create_asset' ?>" enctype="multipart/form-data" class="m-form m-form--fit m-form--state m-form--label-align-right ">
                <div class="modal-body">
                  <div class="m-form__content">
                    <div class="m-alert m-alert--icon alert alert-warning m--hide" role="alert" id="form_asset_add_msg">
                      <div class="m-alert__icon">
                        <i class="la la-warning"></i>
                      </div>
                      <div class="m-alert__text">
                        Oh snap! Change a few things up and try submitting again.
                      </div>
                      <div class="m-alert__close">
                        <button type="button" class="close" data-close="alert" aria-label="Close"></button>
                      </div>
                    </div>
                  </div>
                  <div class="row">
                    <div class="col-lg-6">
                      <div class="form-group m-form__group">
                        <label for="user_name">
                          Asset Name
                        </label>
                        <div class="input-group m-input-group m-input-group--pill m-input-group--air">
                          <input required type="text" name="name" class="form-control form_asset_add_fields m-input" placeholder="  Asset Name" aria-describedby="basic-addon1">
                        </div>
                        <span class="m-form__help"></span>
                      </div>
                    </div>
                    <div class="col-lg-6">
                      <div class="form-group m-form__group">
                        <label for="user_name">
                          Description
                        </label>
                        <div class="input-group m-input-group m-input-group--pill m-input-group--air">
                          <input type="text" name="description" class="form-control form_asset_add_fields m-input" placeholder="Description" aria-describedby="basic-addon1">
                        </div>
                        <span class="m-form__help"></span>
                      </div>
                    </div>
                    <div class="col-lg-4">
                      <div class="form-group m-form__group">
                        <label for="user_name">
                          Quantity
                        </label>
                        <div class="input-group m-input-group m-input-group--pill m-input-group--air">
                          <input type="text" name="quantity" required class="form-control form_asset_add_fields m-input asset_amount_add_fields" id="asset_quantity_add" placeholder="Quantity" aria-describedby="basic-addon1">
                        </div>
                        <span class="m-form__help"></span>
                      </div>
                    </div>
                    <div class="col-lg-4">
                      <div class="form-group m-form__group">
                        <label for="user_name">
                          Unit Cost
                        </label>
                        <div class="input-group m-input-group m-input-group--pill m-input-group--air">
                          <input type="text" name="unit_rate" required class="form-control form_asset_add_fields m-input asset_amount_add_fields" id="asset_unit_rate_add" placeholder="Unit Cost" aria-describedby="basic-addon1">
                        </div>
                        <span class="m-form__help"></span>
                      </div>
                    </div>
                    <div class="col-lg-4">
                      <div class="form-group m-form__group">
                        <label for="user_name">
                          Total Cost
                        </label>
                        <div class="input-group m-input-group m-input-group--pill m-input-group--air">
                          <input readonly type="text" name="total_amount" required class="form-control form_asset_add_fields m-input" id="asset_total_amount_add" placeholder="Total Cost" aria-describedby="basic-addon1">
                        </div>
                        <span class="m-form__help"></span>
                      </div>
                    </div>
                    <div class="col-lg-4">
                      <div class="form-group m-form__group">
                        <label for="user_name">
                          Purchased Date
                        </label>
                        <div class="input-group m-input-group--air m-input-group--pill date">
                          <div class="input-group-prepend">
                            <span class="input-group-text">
                              <i class="la la-calendar"></i>
                            </span>
                          </div>
                          <input data-date-format="dd-mm-yyyy" id="asset_date_add" type="text" name="purchase_date" class="form-control form_asset_add_fields m-input " placeholder="Purchased Date">
                        </div>
                      </div>
                      <span class="m-form__help"></span>
                    </div>
                    <input type="hidden" name="redirect_url" value="<?php echo base_url(uri_string()) ?>">
                  </div>
                </div>
                <div class="modal-footer">
                  <button type="button" class="btn btn-secondary" data-dismiss="modal">
                    Close
                  </button>
                  <button type="submit" class="btn form_submit_btn btn-primary">
                    Submit
                  </button>
                </div>
              </form>
            </div>
          </div>
        </div>
        <div class="modal fade" tabindex="-1" id="asset_edit_modal" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
          <div class="modal-dialog " role="document" style="max-width: 800px">
            <div class="modal-content">
              <div class="modal-header" style="background-color: #36a3f7;border-radius: 4px">
                <h5 class="modal-title" id="exampleModalLabel" style="color: #ffffff">
                  Edit Asset Details
                </h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                  <span aria-hidden="true">
                    &times;
                  </span>
                </button>
              </div>
              <form autocomplete="off" id="form_asset_edit" data-modal-id="asset_edit_modal" method="post" action="<?php echo base_url() . 'accounts/update_asset' ?>" enctype="multipart/form-data" class="m-form m-form--fit m-form--state m-form--label-align-right ">
                <div class="modal-body">
                  <div class="m-form__content">
                    <div class="m-alert m-alert--icon alert alert-warning m--hide" role="alert" id="form_asset_edit_msg">
                      <div class="m-alert__icon">
                        <i class="la la-warning"></i>
                      </div>
                      <div class="m-alert__text">
                        Oh snap! Change a few things up and try submitting again.
                      </div>
                      <div class="m-alert__close">
                        <button type="button" class="close" data-close="alert" aria-label="Close"></button>
                      </div>
                    </div>
                  </div>
                  <div class="row">
                    <div class="col-lg-6">
                      <div class="form-group m-form__group">
                        <label for="user_name">
                          Asset Name
                        </label>
                        <div class="input-group m-input-group m-input-group--pill m-input-group--air">
                          <input required type="text" name="name" id="asset_name_edit" class="form-control form_asset_edit_fields m-input" placeholder="Asset Name" aria-describedby="basic-addon1">
                        </div>
                        <span class="m-form__help"></span>
                      </div>
                    </div>
                    <div class="col-lg-6">
                      <div class="form-group m-form__group">
                        <label for="user_name">
                          Description
                        </label>
                        <div class="input-group m-input-group m-input-group--pill m-input-group--air">
                          <input type="text" name="description" id="asset_description_edit" class="form-control form_asset_edit_fields m-input" placeholder="Description" aria-describedby="basic-addon1">
                        </div>
                        <span class="m-form__help"></span>
                      </div>
                    </div>
                    <div class="col-lg-4">
                      <div class="form-group m-form__group">
                        <label for="user_name">
                          Quantity
                        </label>
                        <div class="input-group m-input-group m-input-group--pill m-input-group--air">
                          <input type="text" name="quantity" required class="form-control form_asset_edit_fields m-input asset_amount_edit_fields" id="asset_quantity_edit" placeholder="Quantity" aria-describedby="basic-addon1">
                        </div>
                        <span class="m-form__help"></span>
                      </div>
                    </div>
                    <div class="col-lg-4">
                      <div class="form-group m-form__group">
                        <label for="user_name">
                          Unit Cost
                        </label>
                        <div class="input-group m-input-group m-input-group--pill m-input-group--air">
                          <input type="text" name="unit_rate" required class="form-control form_asset_edit_fields m-input asset_amount_edit_fields" id="asset_unit_rate_edit" placeholder="Unit Cost" aria-describedby="basic-addon1">
                        </div>
                        <span class="m-form__help"></span>
                      </div>
                    </div>
                    <div class="col-lg-4">
                      <div class="form-group m-form__group">
                        <label for="user_name">
                          Total Cost
                        </label>
                        <div class="input-group m-input-group m-input-group--pill m-input-group--air">
                          <input readonly type="text" name="total_amount" required class="form-control form_asset_edit_fields m-input" id="asset_total_amount_edit" placeholder="Total Cost" aria-describedby="basic-addon1">
                        </div>
                        <span class="m-form__help"></span>
                      </div>
                    </div>
                    <div class="col-lg-4">
                      <div class="form-group m-form__group">
                        <label for="user_name">
                          Purchased Date
                        </label>
                        <div class="input-group m-input-group--air m-input-group--pill date">
                          <div class="input-group-prepend">
                            <span class="input-group-text">
                              <i class="la la-calendar"></i>
                            </span>
                          </div>
                          <input data-date-format="dd-mm-yyyy" id="asset_date_edit" type="text" name="purchase_date" class="form-control form_asset_edit_fields m-input " placeholder="Purchased Date">
                        </div>
                      </div>
                      <span class="m-form__help"></span>
                    </div>
                    <input type="hidden" name="redirect_url" value="<?php echo base_url(uri_string()) ?>">
                    <input type="hidden" name="asset_id" id="asset_id_edit">
                  </div>
                </div>
                <div class="modal-footer">
                  <button type="button" class="btn btn-secondary" data-dismiss="modal">
                    Close
                  </button>
                  <button type="submit" class="btn form_submit_btn btn-primary">
                    Submit
                  </button>
                </div>
              </form>
            </div>
          </div>
        </div>
        <div class="modal fade" tabindex="-1" id="asset_delete_modal" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
          <div class="modal-dialog " role="document">
            <form autocomplete="off" id="form_asset_delete" data-modal-id="asset_delete_modal" method="post" action="<?php echo base_url() . 'accounts/delete_asset' ?>" class="form-horizontal">
              <div class="modal-content">
                <div class="alert alert-danger" role="alert" style="margin-bottom: 0px">
                  <button type="button" class="close" data-dismiss="modal"></button>
                  <br />
                  <h4 class="alert-heading">Warning! Please Confirm Your Action</h4>
                  <br />
                  <p> Are You Sure to Delete this Data ?. All the Associated Data will Lost. </p>
                  <p>
                    <button class="btn btn-danger form_submit_btn" type="submit" name="submit">Confirm & Delete</button>
                    <button type="button" class="btn btn-primary modal-dismiss" data-dismiss="modal">Cancel</button>
                  </p>
                  <input type="hidden" name="asset_id" id="asset_id_delete">
                  <input type="hidden" name="redirect_url" value="<?php echo base_url(uri_string()) ?>">
                </div>
              </div>
            </form>
          </div>
        </div>

      </div>
    </div>
  </div>
</div>
</div>
<!-- end:: Body -->
<!-- begin::Footer -->
<?php $this->view("includes/Inc_footer"); ?>
<!-- end::Footer -->
</div>
<!-- end:: Page -->

<?php $this->view("includes/Inc_sidebar"); ?>
<?php $this->view("includes/Inc_scripts"); ?>

<script>
  $("#assets_menu").addClass('m-menu__item--open m-menu__item--active');
  $("#assets_menu_1").addClass('m-menu__item--active');
</script>
<script>
  $("#asset_date_add,#asset_date_edit").datepicker({
    todayHighlight: !0,
    orientation: "bottom left",
    templates: {
      leftArrow: '<i class="la la-angle-left"></i>',
      rightArrow: '<i class="la la-angle-right"></i>'
    },
  })

  $('body').on('change keyup', '.asset_amount_add_fields', function() {
    var qty = parseFloat($('#asset_quantity_add').val());
    var unit_rate = parseFloat($('#asset_unit_rate_add').val());
    if (isNaN(qty)) {
      qty = 0;
    }
    if (isNaN(unit_rate)) {
      unit_rate = 0;
    }
    var total_cost = qty * unit_rate;
    $('#asset_total_amount_add').val(total_cost.toFixed(2));
  })
  $('body').on('change keyup', '.asset_amount_edit_fields', function() {
    var qty = parseFloat($('#asset_quantity_edit').val());
    var unit_rate = parseFloat($('#asset_unit_rate_edit').val());
    if (isNaN(qty)) {
      qty = 0;
    }
    if (isNaN(unit_rate)) {
      unit_rate = 0;
    }
    var total_cost = qty * unit_rate;
    $('#asset_total_amount_edit').val(total_cost.toFixed(2));
  })

  $('body').on('click', '#asset_edit_btn', function() {
    var no = $(this).closest('tr').children('td');
    $('#asset_id_edit').val(no.eq(2).text());
    $("#asset_date_edit").datepicker("setDate", no.eq(8).text());
    $('#asset_name_edit').val(no.eq(3).text());
    $('#asset_description_edit').val(no.eq(4).text());
    $('#asset_quantity_edit').val(no.eq(5).text());
    $('#asset_unit_rate_edit').val(no.eq(6).text());
    $('#asset_total_amount_edit').val(no.eq(7).text());
  })
  $('body').on('click', '#asset_delete_btn', function() {
    var no = $(this).closest('tr').children('td');
    $('#asset_id_delete').val(no.eq(2).text());
  })

  function get_branch_id() {
    return $('#company_branch :selected').val();
  }
  var asset_view_table = $('#asset_view_table').DataTable({
    "ajax": {
      url: "<?php echo base_url() . 'accounts/select_assets' ?>", // json datasource
      type: "post", // type of method  , by default would be get
      data: function(d) {
        <?php if (!empty($this->config->item('company_branches'))) { ?>
          d.branch_id = get_branch_id();
        <?php } ?>
      }
    },
    "bProcessing": true,
    "deferRender": true,
    "bDeferRender": true,
    "scrollX": true,
    buttons: [{
        extend: 'print',
        className: 'btn dark btn-outline',
        title: 'Assets'
      },
      {
        extend: 'csv',
        className: 'btn purple btn-outline '
      },
      {
        extend: 'colvis',
        className: 'btn dark btn-outline',
        text: 'Columns'
      }
    ],
    dom: "<'row'<'col-sm-6 text-left'B><'col-sm-6 text-right'f>>\n\t\t\t<'row'<'col-sm-12'tr>>\n\t\t\t<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 dataTables_pager'lp>>",
    "lengthMenu": [
      [10, 15, 20, -1],
      [10, 15, 20, "All"] // change per page values here
    ],
    "columnDefs": [{
      "targets": [2 <?php if (empty($this->config->item('company_branches'))) {
                      echo ",1";
                    } ?>],
      className: "hidden"
    }],
    'order': false
  });
  $(".table_filter").on("change", function() {
    asset_view_table.ajax.reload();
  });
</script>

<script>
  jQuery(document).ready(function() {
    $(".form_submit_btn").click(function(e) {
      e.preventDefault();
      var a = $(this),
        l = $(this).closest("form"),
        action = l.attr('action');
      var form_id = l.attr('id');
      l.validate({
        rules: {
          quantity: {
            number: !0,
            required: !0
          },
          unit_rate: {
            number: !0,
            required: !0
          }
        },
        invalidHandler: function(e, r) {
          var i = $("#" + form_id + "_msg");
          i.removeClass("m--hide").show(), mUtil.scrollTo(i, -200)
        },
        submitHandler: function(e) {}
      }), l.valid() && (a.addClass("m-loader m-loader--right m-loader--light").attr("disabled", !0),
        l.ajaxSubmit({
          url: action,
          success: function(e, t, r, s) {
            var modal_id = l.attr('data-modal-id');
            var form_type = l.attr('data-form-type');
            $("#" + form_id + "_msg").addClass("m--hide");
            // Block UI
            mApp.blockPage({
              overlayColor: "#000000",
              type: "loader",
              state: "success",
              message: "Please wait..."
            }), setTimeout(function() {
              mApp.unblockPage()
            }, 2e3);
            var obj = $.parseJSON(e);
            if (obj.status == 1) {
              a.removeClass("m-loader m-loader--right m-loader--light").attr("disabled", !1);
              toastr[obj.flashdata_type](obj.flashdata_msg, obj.flashdata_title);
              $("#" + modal_id).modal('toggle');
              $("." + form_id + "_fields").val('');
              $("." + form_id + "_select").val('').trigger("change");
              asset_view_table.ajax.reload();
            } else {
              a.removeClass("m-loader m-loader--right m-loader--light").attr("disabled", !1);
              toastr[obj.flashdata_type](obj.flashdata_msg, obj.flashdata_title);
            }
            if (obj == null) {
              setTimeout(function() {
                a.removeClass("m-loader m-loader--right m-loader--light").attr("disabled", !1);
                toastr["warning"]("Your Attempt is Timed Out. Please Try Again.", "Timed Out");
              }, 2e4)
            }
          },
          error: function() {
            a.removeClass("m-loader m-loader--right m-loader--light").attr("disabled", !1);
            toastr["error"]("Sorry. There Has Been Some Error Occurred. Please Try Again.", "Error");
          }
        })
      )
    });
    $($.fn.dataTable.tables(true)).DataTable()
      .columns.adjust()
      .responsive.recalc();

  });
</script>
