<?php $this->view("includes/Inc_pagehead");?>
<!-- Page Styles Goes Here-->
<style>

@media print {

  .no-print{
    display: none !important;
  }
  .m-subheader,.m-portlet__head{
    display: none !important;
    height: 0px !important;
    padding: 0px !important;
  }
  .m-header{
    display: none !important;
    height: 0px !important;
  }
  .m-header--fixed .m-body {
    padding-top: 0px !important;
  }
  body * {
    visibility: hidden;
  }
  .m-portlet__body * {
    visibility: visible;
    overflow: visible !important;
  }
  .m-body .m-content {
    padding: 0px !important;
  }
  .m-content--skin-light2 .m-body {
    background-color: white !important;
  }
  body.m-content--skin-light2 {
    background-color: white !important;
  }
  .m-wrapper {
    margin-bottom: 0px !important;
  }
  .m-portlet__body {
    padding: 0px !important;
  }
}
</style>
<?php $this->view("includes/Inc_navigation");?>
<div class="m-grid__item m-grid__item--fluid m-wrapper">
  <!-- BEGIN: Subheader -->
  <div class="m-subheader ">
    <div class="d-flex align-items-center">
      <div class="mr-auto">
        <h3 class="m-subheader__title m-subheader__title--separator">
          Account Ledger
        </h3>
        <ul class="m-subheader__breadcrumbs m-nav m-nav--inline">
          <li class="m-nav__item m-nav__item--home">
            <a href="#" class="m-nav__link m-nav__link--icon">
              <i class="m-nav__link-icon la la-home"></i>
            </a>
          </li>
          <li class="m-nav__separator">
            -
          </li>
          <li class="m-nav__item">
            <a href="<?php echo base_url().'dashboard'?>" class="m-nav__link">
              <span class="m-nav__link-text">
                Home
              </span>
            </a>
          </li>
          <li class="m-nav__separator">
            -
          </li>
          <li class="m-nav__item">
            <a href="<?php echo base_url().'accounts' ?>" class="m-nav__link">
              <span class="m-nav__link-text">
                Account Ledger
              </span>
            </a>
          </li>


        </ul>
      </div>
      <div>

      </div>
    </div>
  </div>
  <!-- END: Subheader -->
  <div class="m-content">
    <div class="m-portlet  m-portlet--rounded m-portlet--bordered no-print">
      <div class="m-portlet__body" style="padding: 1rem 2.2rem;">
        <form autocomplete="off" id="form_account_ledger" method="post" action="<?php echo base_url()?>accounts/ledger_report" enctype="multipart/form-data" class="m-form m-form--fit m-form--state m-form--label-align-right " >
          <div class="m-form m-form--label-align-right m--margin-bottom-10">
            <div class="row ">
              <div class="col-xl-12 order-2 order-xl-1">
                <div class="form-group m-form__group row">
                  <div class="col-lg-5">
                    <?php if($selected_account_type=='vehicle_consignee'){
                      $account_name = $selected_account_data->consignee_name." [Vehicle Consignee]";
                    }?>
                    <div class="form-group m-form__group" >
                      <label>Account:</label>
                      <div class="input-group m-input-group--air m-input-group--pill date">
                        <input value="<?php echo $account_name ?>" readonly  type="text" class="form-control m-input " >
                      </div>
                    </div>
                  </div>
                  <div class="col-lg-5" >
                    <div class="row ">
                      <div class="col-lg-6">
                        <div class="form-group m-form__group" >
                          <label> Start Date:</label>
                          <div class="input-group m-input-group--air m-input-group--pill date">
                            <div class="input-group-prepend">
                              <span class="input-group-text">
                                <i class="la la-calendar"></i>
                              </span>
                            </div>
                            <input value="<?php echo $selected_start_date ?>"  data-date-format="dd-mm-yyyy" name="start_date" autocomplete="off" id="start_date"   type="text" class="form-control form_client_payment_add_fields m-input " placeholder="Starting Date" >
                          </div>
                        </div>
                      </div>
                      <div class="col-lg-6">
                        <div class="form-group m-form__group" >
                          <label> End Date:</label>
                          <div class="input-group m-input-group--air m-input-group--pill date">
                            <div class="input-group-prepend">
                              <span class="input-group-text">
                                <i class="la la-calendar"></i>
                              </span>
                            </div>
                            <input value="<?php echo $selected_end_date ?>" data-date-format="dd-mm-yyyy" name="end_date" autocomplete="off" id="end_date"  type="text" class="form-control form_client_payment_add_fields m-input " placeholder="Ending Date" >
                          </div>
                        </div>
                      </div>
                      <div class="col-lg-12" >
                        <span class="m-form__help">* Leave Start Date and End Date Empty to Get All Transactions</span>
                      </div>
                    </div>
                  </div>
                  <div class="col-lg-2">
                    <br/>
                    <button type="submit" style="margin-top: 7px" id="btn_go" class="btn btn-focus m-btn m-btn--custom m-btn--icon m-btn--air m-btn--pill">
                      <span>
                        <i class="la la-search"></i>
                        <span>
                          Go
                        </span>
                      </span>
                    </button>
                  </div>
                </div>
              </div>
            </div>
          </div>
          <input type="hidden" name="account_type" value="<?php echo $selected_account_type ?>" />
          <input type="hidden" name="account_id" value="<?php echo $selected_account_id ?>" />
        </form>
      </div>
    </div>

    <div class="m-portlet m-portlet--mobile m-portlet--info m-portlet--head-solid-bg m-portlet--bordered m-portlet--rounded">
      <div class="m-portlet__head">
        <div class="m-portlet__head-caption">
          <div class="m-portlet__head-title">
            <h3 class="m-portlet__head-text">
              Account Ledger
            </h3>
          </div>
        </div>
        <div class="m-portlet__head-tools">
          <a id="btn_print" href="javascript:;" onclick="window.print()" class="btn btn-warning m-btn m-btn--custom m-btn--icon m-btn--air m-btn--pill">
            <span>
              <i class="la la-print"></i>
              <span>
                Print Ledger
              </span>
            </span>
          </a>
        </div>
      </div>
      <div class="m-portlet__body">
        <!--begin: Datatable -->
        <?php
        $ledger_caption = $account_name;
        if($selected_start_date!='' || $selected_end_date!=''){
          if($selected_start_date=='' && $selected_end_date!=''){
            $ledger_caption.=" To ".$selected_end_date;
          }else if($selected_start_date!='' && $selected_end_date==''){
            $ledger_caption.=" From ".$selected_start_date;
          }else{
            $ledger_caption.=" From ".$selected_start_date." To ".$selected_end_date;
          }
        }
        ?>
        <table width="100%" class="table m-table nowrap table-header-fixed table-striped table-bordered table-hover table-header-fixed" id="ledger_view_table">
          <caption class="table_caption" style="caption-side: top !important;text-align: center"><strong>Account Ledger - <?php echo $ledger_caption ?></strong></caption>
          <thead>
            <tr class="">
              <th>Date</th>
              <?php if($selected_account_type=='vehicle_consignee'){?>
                <th>Vehicle</th>
                <th>For</th>
                <th>Work Qty</th>
                <th></th>
                <th>Load Qty</th>
                <th></th>
                <th>Total Load Qty</th>
                <th>Payable</th>
                <th>Paid</th>
              <?php } ?>
              <th>Balance</th>
            </tr>
          </thead>
          <tbody>
            <?php
            $total_balance = 0;
            if($selected_account_type=='vehicle_consignee'){
              if($selected_start_date!='' && !empty($op_balance)){
                $total_balance += $op_balance['amount']
                ?>
                <tr>
                  <td><?php echo date('d-m-Y',strtotime($op_balance['date'])) ?></td>
                  <td>Opening Balance</td>
                  <td colspan="5">Opening Balance</td>
                  <td><?php echo $op_balance['amount'] ?></td>
                  <td></td>
                  <td><?php echo $total_balance ?></td>
                </tr>
              <?php }

              foreach ($ledger_data as $key => $value) {
                if($value['data_type']=='op_balance'){
                  $total_balance += $value['data']->vehicle_op_balance;
                  ?>
                  <tr>
                    <td><?php echo date('d-m-Y',strtotime($value['date'])) ?></td>
                    <td><?php echo $value['data']->vehicle_no ?></td>
                    <td><?php echo 'Opening Balance'; ?></td>
                    <td colspan="5"></td>
                    <td><?php echo $value['data']->vehicle_op_balance ?></td>
                    <td></td>
                    <td><?php echo $total_balance ?></td>
                  </tr>
                <?php }
                if($value['data_type']=='work_slip'){
                  $total_balance += $value['data']->total_payable_amount;
                  ?>
                  <tr>
                    <td><?php echo date('d-m-Y',strtotime($value['date'])) ?></td>
                    <td><?php echo $value['data']->vehicle_no ?></td>
                    <td>Work Slip #<?php echo $value['data']->work_slip_id ?></td>
                    <td><?php echo $value['data']->worked_duration ?>
                      <?php
                      if($value['data']->worked_duration_2!=0){
                        echo "<br/>".$value['data']->worked_duration_2;
                      }
                      if($value['data']->worked_duration_3!=0){
                        echo "<br/>".$value['data']->worked_duration_3;
                      }
                      ?>
                    </td>
                    <td><?php echo $value['data']->duration_type ?>
                      <?php
                      if($value['data']->duration_type_2!=0){
                        echo "<br/>".$value['data']->duration_type_2;
                      }
                      if($value['data']->duration_type_3!=0){
                        echo "<br/>".$value['data']->duration_type_3;
                      }
                      ?></td>
                    <td><?php echo $value['data']->load_qty ?></td>
                    <td><?php echo $value['data']->load_qty_in ?></td>
                    <td><?php echo $value['data']->total_load_qty ?></td>
                    <td><?php echo $value['data']->total_payable_amount ?></td>
                    <td></td>
                    <td><?php echo $total_balance ?></td>
                  </tr>
                <?php } ?>
                <?php if($value['data_type']=='payment'){
                  $total_balance -= $value['data']->tr_amount;
                  ?>
                  <tr>
                    <td><?php echo date('d-m-Y',strtotime($value['date'])) ?></td>
                    <td><?php echo $value['data']->vehicle_no ?></td>
                    <td>Towards
                    <?php if($value['data_type_2']=='op_balance_payment')
                    {
                      echo "Opening Balance";
                    }else{
                      echo "Work Slip #".$value['data']->reference_id;
                    }?></td>
                    <td colspan="6">Debited From: <?php echo $value['data']->debit_account ?>, Mode:  <?php echo $value['data']->tr_mode ?>, <?php echo $value['data']->tr_reference_no ?>,<?php if($value['data']->tr_reference_date!='0000-00-00'){ echo date('d-m-Y',strtotime($value['data']->tr_reference_date));} ?> <?php echo $value['data']->tr_remarks ?>,</td>
                    <td><?php echo $value['data']->tr_amount ?></td>
                    <td><?php echo $total_balance ?></td>
                  </tr>
                <?php } ?>
              <?php } ?>

            <?php } ?>
          </tbody>
        </table>
        <!--end: Datatable -->

      </div>
    </div>


  </div>
</div>
</div>
<!-- end:: Body -->
<!-- begin::Footer -->

<?php $this->view("includes/Inc_footer");?>
<!-- end::Footer -->
</div>
<!-- end:: Page -->

<?php $this->view("includes/Inc_sidebar");?>
<?php $this->view("includes/Inc_scripts");?>

<!--begin::Page Snippets -->
<script>
$("#accounts_menu").addClass('m-menu__item--open m-menu__item--active');
$("#accounts_menu_1").addClass('m-menu__item--active');

$("#start_date,#end_date").datepicker( {
  todayHighlight:!0, orientation:"bottom left", templates: {
    leftArrow: '<i class="la la-angle-left"></i>', rightArrow: '<i class="la la-angle-right"></i>'
  }
})

$("#form_account_ledger").validate( {
  rules: {
    account: {
      required: !0
    }
  },
  invalidHandler:function(e, r) {
    var i=$("#form_work_msg");
    i.removeClass("m--hide").show(), mUtil.scrollTo(i, -200)
  }
  , submitHandler:function(e) {
    this.submit();
  }
}
);


jQuery(document).ready(function() {
  $(".hidden").hide();

});
</script>
