<?php $this->view("includes/Inc_pagehead");?>
<!-- Page Styles Goes Here-->
<style>
<?php $caption='Account Ledger'; ?>
@media print {

  .no-print{
    display: none !important;
  }
  .m-subheader,.m-portlet__head{
    display: none !important;
    height: 0px !important;
    padding: 0px !important;
  }
  .m-header{
    display: none !important;
    height: 0px !important;
  }
  /* .m-header--fixed .m-body {
  padding-top: 0px !important;
}
body * {
visibility: hidden;
} */
.m-portlet__body * {
  visibility: visible;
  overflow: visible !important;
}
.m-body .m-content {
  padding: 0px !important;
}
.m-content--skin-light2 .m-body {
  background-color: white !important;
}
body.m-content--skin-light2 {
  background-color: white !important;
}
.m-wrapper {
  margin-bottom: 0px !important;
}
.m-portlet__body {
  padding: 0px !important;
}
}
</style>
<?php $this->view("includes/Inc_navigation");?>
<div class="m-grid__item m-grid__item--fluid m-wrapper">
  <!-- BEGIN: Subheader -->
  <div class="m-subheader ">
    <div class="d-flex align-items-center">
      <div class="mr-auto">
        <h3 class="m-subheader__title m-subheader__title--separator">
          Account Ledger
        </h3>
        <ul class="m-subheader__breadcrumbs m-nav m-nav--inline">
          <li class="m-nav__item m-nav__item--home">
            <a href="#" class="m-nav__link m-nav__link--icon">
              <i class="m-nav__link-icon la la-home"></i>
            </a>
          </li>
          <li class="m-nav__separator">
            -
          </li>
          <li class="m-nav__item">
            <a href="<?php echo base_url().'dashboard'?>" class="m-nav__link">
              <span class="m-nav__link-text">
                Home
              </span>
            </a>
          </li>
          <li class="m-nav__separator">
            -
          </li>
          <li class="m-nav__item">
            <a href="<?php echo base_url().'accounts' ?>" class="m-nav__link">
              <span class="m-nav__link-text">
                Account Ledger
              </span>
            </a>
          </li>


        </ul>
      </div>
      <div>

      </div>
    </div>
  </div>
  <!-- END: Subheader -->
  <div class="m-content">
    <div class="m-portlet  m-portlet--rounded m-portlet--bordered no-print">
      <div class="m-portlet__body" style="padding: 1rem 2.2rem;">
        <form autocomplete="off" id="form_account_ledger" method="post" action="<?php echo base_url()?>accounts/ledger" enctype="multipart/form-data" class="m-form m-form--fit m-form--state m-form--label-align-right " >
          <div class="m-form m-form--label-align-right m--margin-bottom-10 ">
            <div class="row ">
              <div class="col-xl-12 order-2 order-xl-1">
                <div class="form-group m-form__group row">
                  <div class="col-lg-3">
                    <div class="form-group m-form__group" style="padding-bottom:0px" >
                      <label for="user_name">
                        Account Category
                      </label>
                      <div class="m-select2 m-select2--air m-select2--pill">
                        <select required id="account_category" name="account_category" style="width: 100%" class="form-control m-input"  aria-describedby="basic-addon1" data-placeholder="Select Account Type">
                          <option selected disabled value="">Select Account Category</option>
                          <?php if($this->session->userdata('user_role')=='admin' || $this->session->userdata('user_role')=='general_manager' || $this->session->userdata('user_role')=='accounts_manager') { ?>
                            <option value="Cash">Cash</option>
                            <option value="Bank">Bank</option>
                          <?php } ?>
                          <option value="Employee">Employee</option>
                          <?php if($this->session->userdata('user_role')=='admin' || $this->session->userdata('user_role')=='general_manager' || $this->session->userdata('user_role')=='accounts_manager') { ?>
                            <option value="Client">Project Clients</option>
                            <!-- <option value="Customer">Sales Customers</option> -->
                            <option value="Supplier">Supplier</option>
                          <?php } ?>
                          <option value="Labour">Labour</option>
                          <option value="Contractor">Contractor</option>
                          <?php if($this->session->userdata('user_role')=='admin' || $this->session->userdata('user_role')=='general_manager' || $this->session->userdata('user_role')=='accounts_manager') { ?>
                            <option value="Vehicle Owner">Vehicle Owner</option>
                            <option value="Vehicle">Vehicle</option>
                            <option value="Expense Head">Expense Head</option>
                            <option value="Expense Type">Income/Expense Type</option>
                            <option value="Payment Mode">Payment Mode</option>
                            <!-- <option value="Project">Project</option> -->
                          <?php } ?>
                        </select>
                      </div>
                      <span class="m-form__help"></span>
                    </div>
                    <div class="form-group m-form__group" style="display:none;padding-top:0px" id="employee_account_type_div" >
                      <label for="user_name">
                        Select Account Type
                      </label>
                      <div class="m-select2 m-select2--air m-select2--pill">
                        <select id="employee_account_type" name="employee_account_type" style="width: 100%" class="form-control m-input"  aria-describedby="basic-addon1" data-placeholder="Select Account Type">

                        </select>
                      </div>
                      <span class="m-form__help"></span>
                    </div>
                  </div>
                  <div class="col-lg-4">
                    <div class="form-group m-form__group"  style="padding-bottom:0px">
                      <label for="user_name">
                        Select Account
                      </label>
                      <div class="m-select2 m-select2--air m-select2--pill">
                        <select required id="account" name="account" style="width: 100%" class="form-control m-input"  aria-describedby="basic-addon1" data-placeholder="Select Account">

                        </select>
                      </div>
                      <span class="m-form__help"></span>
                    </div>
                    <div class="form-group m-form__group" id="financial_year_opbalance_div" style="display:none;padding-top:0px">
                      <label style="text-align:left">
                        Keep Previous Financial Year Closing Balance as Selected Year's Opening Balance
                      </label>
                      <div class="m-radio-inline" style="padding-top: 10px;">
                        <label class="m-radio m-radio--solid m-radio--state-danger">
                          <input type="radio" class="form_fields_radio"  name="financial_year_opbalance" value="1"> Yes
                          <span></span>
                        </label>
                        <label class="m-radio m-radio--solid m-radio--state-warning">
                          <input type="radio" class="form_fields_radio" name="financial_year_opbalance"  value="0"> No
                          <span></span>
                        </label>
                      </div>
                      <span class="m-form__help"></span>
                    </div>
                  </div>
                  <div class="col-lg-4" >
                    <div class="row ">
                      <div class="col-lg-12">
                        <div class="form-group m-form__group"  >
                          <label for="user_name">
                            Select Financial Year
                          </label>
                          <div class="m-select2 m-select2--air m-select2--pill">
                            <select id="financial_year" name="financial_year" style="width: 100%" class="form-control m-input"  aria-describedby="basic-addon1" data-placeholder="Select Financial Year">
                              <option selected value="all">All Financial Year</option>
                              <?php foreach ($financial_year as $key => $value) {?>
                                <option value="<?php echo $value->finyear_id ?>"><?php echo $value->fin_year ?></option>
                              <?php } ?>
                            </select>
                          </div>
                          <span class="m-form__help"></span>
                        </div>
                      </div>
                    </div>
                    <div class="row ">
                      <div class="col-lg-6">
                        <div class="form-group m-form__group" >
                          <label> Start Date:</label>
                          <div class="input-group m-input-group--air m-input-group--pill date">
                            <input value="<?php if($selected_start_date!=''){echo date('d-m-Y',strtotime($selected_start_date));}?>"  data-date-format="dd-mm-yyyy" name="start_date" autocomplete="off" id="start_date"  type="text" class="form-control form_client_payment_add_fields m-input " placeholder="Starting Date" >
                          </div>
                        </div>
                      </div>
                      <div class="col-lg-6">
                        <div class="form-group m-form__group" >
                          <label> End Date:</label>
                          <div class="input-group m-input-group--air m-input-group--pill date">
                            <input value="<?php if($selected_end_date!=''){echo date('d-m-Y',strtotime($selected_end_date));}?>" data-date-format="dd-mm-yyyy" name="end_date" autocomplete="off" id="end_date"  type="text" class="form-control form_client_payment_add_fields m-input " placeholder="Ending Date" >
                          </div>
                        </div>
                      </div>
                      <div class="col-lg-12" >
                        <span class="m-form__help">* Leave Start Date and End Date Empty to Get All Transactions</span>
                      </div>
                    </div>
                  </div>
                  <div class="col-lg-1">
                    <br/>
                    <button type="submit" style="margin-top: 7px" id="btn_go" class="btn btn-focus m-btn m-btn--custom m-btn--icon m-btn--air m-btn--pill">
                      <span>
                        <i class="la la-search"></i>
                        <span>
                          Go
                        </span>
                      </span>
                    </button>
                  </div>
                </div>
                <div class="row ">

                </div>

              </div>
            </div>
          </div>
        </form>
      </div>
    </div>
    <?php if($selected_account!=''){  ?>
      <div class="m-portlet m-portlet--mobile m-portlet--info m-portlet--head-solid-bg m-portlet--bordered m-portlet--rounded">
        <div class="m-portlet__head">
          <div class="m-portlet__head-caption">
            <div class="m-portlet__head-title">
              <h3 class="m-portlet__head-text">
                Account Ledger
              </h3>
            </div>
          </div>
          <div class="m-portlet__head-tools">
            <a id="btn_print" href="javascript:;" class="btn btn-warning m-btn m-btn--custom m-btn--icon m-btn--air m-btn--pill">
              <span>
                <i class="la la-print"></i>
                <span>
                  Print Ledger
                </span>
              </span>
            </a>
          </div>
        </div>
        <div class="m-portlet__body">
          <!--begin: Datatable -->
          <table width="100%" class="table m-table nowrap table-header-fixed table-striped table-bordered table-hover table-header-fixed" id="ledger_view_table">
            <?php if($selected_account_prefix=='acchead' || $selected_account_prefix=='employee' || $selected_account_prefix=='labour' || $selected_account_prefix=='client' || $selected_account_prefix=='contractor' || $selected_account_prefix=='expensetype' || $selected_account_prefix=='paymentmode'){
              $caption="Account Ledger of [".$selected_account_data->acc_head_name."] - [".$selected_account_category."]";
              if($selected_start_date!='' || $selected_end_date!=''){
                if($selected_start_date=='' && $selected_end_date!=''){
                  $caption.=" To ".$selected_end_date;
                }else if($selected_start_date!='' && $selected_end_date==''){
                  $caption.=" From ".$selected_start_date;
                }else{
                  $caption.=" From ".$selected_start_date." To ".$selected_end_date;
                }
              }
              ?>
              <caption class="table_caption" style="caption-side: top !important;text-align: center"><strong><?php echo $caption ?></strong></caption>
              <thead>
                <tr class="">
                  <th>Date</th>
                  <th>Account</th>
                  <th>Description</th>
                  <th>Debit</th>
                  <th>Credit</th>
                  <th>Balance</th>
                </tr>
              </thead>
              <tbody >
                <?php
                $j=$i=0;$sl_no=1;
                $op_balance = $total_debit = $total_credit = $total_balance = 0;
                ?>
                <?php
                foreach ($transactions as $key => $value) {
                  if($value['type']=='debit'){
                    if($selected_account_prefix=='client'){
                      $total_balance+=$value['debit'];
                    }else{
                      $total_balance-=$value['debit'];
                    }
                    $total_debit+=$value['debit'];
                    $value['debit'] = $this->config->item('Currency_currency_format')." ".$this->config->item('currency_format')->formatCurrency($value['debit'],$this->config->item('Currency_currency_shortname'));
                    ?>
                    <tr>
                      <td><?php echo date('d-m-Y',strtotime($value['date'])) ?></td>
                      <td><?php echo $value['account'] ?></td>
                      <td><?php echo $value['description'] ?></td>
                      <td><?php echo $value['debit'] ?></td>
                      <td></td>
                      <td><?php echo $this->config->item('Currency_currency_format')." ".$this->config->item('currency_format')->formatCurrency($total_balance,$this->config->item('Currency_currency_shortname')) ?></td>
                    </tr>
                  <?php }elseif($value['type']=='credit'){
                    if($selected_account_prefix=='client'){
                      $total_balance-=$value['credit'];
                    }else{
                      $total_balance+=$value['credit'];
                    }
                    $total_credit+=$value['credit'];
                    $value['credit'] = $this->config->item('Currency_currency_format')." ".$this->config->item('currency_format')->formatCurrency($value['credit'],$this->config->item('Currency_currency_shortname'));
                    ?>
                    <tr>
                      <td><?php echo date('d-m-Y',strtotime($value['date'])) ?></td>
                      <td><?php echo $value['account'] ?></td>
                      <td><?php echo $value['description'] ?></td>
                      <td></td>
                      <td><?php echo $value['credit'] ?></td>
                      <td><?php echo $this->config->item('Currency_currency_format')." ".$this->config->item('currency_format')->formatCurrency($total_balance,$this->config->item('Currency_currency_shortname')) ?></td>
                    </tr>
                    <?php
                  }
                }
                ?>
                <tr>
                  <td></td>
                  <td></td>
                  <td><strong>Total</strong></td>
                  <td><strong><?php echo $this->config->item('Currency_currency_format')." ".$this->config->item('currency_format')->formatCurrency($total_debit,$this->config->item('Currency_currency_shortname')) ?></strong></td>
                  <td><strong><?php echo $this->config->item('Currency_currency_format')." ".$this->config->item('currency_format')->formatCurrency($total_credit,$this->config->item('Currency_currency_shortname')) ?></strong></td>
                  <td><strong><?php echo $this->config->item('Currency_currency_format')." ".$this->config->item('currency_format')->formatCurrency($total_balance,$this->config->item('Currency_currency_shortname')) ?></strong></td>
                </tr>
              </tbody>
            <?php }elseif($selected_account_prefix=='vehicleconsignee' || $selected_account_prefix=='vehicle'){
              if($selected_account_prefix=='vehicleconsignee'){
                $ledger_caption = $selected_account_data->consignee_name." [Vehicle Consignee]";
              }else{
                $ledger_caption = $selected_account_data->vehicle_no."  -- ".$selected_account_data->vehicle_name." (".$selected_account_data->consignee_name.") [Vehicle]";
              }
              if($selected_start_date!='' || $selected_end_date!=''){
                if($selected_start_date=='' && $selected_end_date!=''){
                  $ledger_caption.=" To ".$selected_end_date;
                }else if($selected_start_date!='' && $selected_end_date==''){
                  $ledger_caption.=" From ".$selected_start_date;
                }else{
                  $ledger_caption.=" From ".$selected_start_date." To ".$selected_end_date;
                }
              }
              ?>
              <table width="100%" class="table m-table nowrap table-header-fixed table-striped table-bordered table-hover table-header-fixed" id="ledger_view_table">
                <caption class="table_caption" style="caption-side: top !important;text-align: center"><strong>Account Ledger - <?php echo $ledger_caption ?></strong></caption>
                <thead>
                  <tr class="">
                    <th>Date</th>
                    <?php if($selected_account_prefix=='vehicleconsignee' || $selected_account_prefix=='vehicle'){?>
                      <th>Vehicle</th>
                      <th>For</th>
                      <th>Work Qty</th>
                      <th></th>
                      <th>Load Qty</th>
                      <th></th>
                      <th>Total Load Qty</th>
                      <th>Payable</th>
                      <th>Paid</th>
                    <?php } ?>
                    <th>Balance</th>
                  </tr>
                </thead>
                <tbody>
                  <?php
                  $total_payable = $total_paid = $total_balance = 0;
                  if($selected_account_prefix=='vehicleconsignee' || $selected_account_prefix=='vehicle'){
                    if($selected_start_date!='' && !empty($op_balance)){
                      $total_balance += $op_balance['amount']
                      ?>
                      <tr>
                        <td><?php echo date('d-m-Y',strtotime($op_balance['date'])) ?></td>
                        <td></td>
                        <td>Opening Balance</td>
                        <td colspan="5">Opening Balance on <?php echo date('d-m-Y',strtotime($op_balance['date'])) ?></td>
                        <td><?php echo $this->config->item('Currency_currency_format') . " " . $this->config->item('currency_format')->formatCurrency($op_balance['amount'], $this->config->item('Currency_currency_shortname')) ?></td>
                        <td></td>
                        <td><?php echo $this->config->item('Currency_currency_format') . " " . $this->config->item('currency_format')->formatCurrency($total_balance, $this->config->item('Currency_currency_shortname')) ?></td>
                      </tr>
                    <?php }
                    foreach ($transactions as $key => $value) {
                      if(isset($value['data_type']) && $value['data_type']=='op_balance'){
                        $total_balance += $value['data']->vehicle_op_balance;
                        $total_payable += $value['data']->vehicle_op_balance;
                        ?>
                        <tr>
                          <td><?php echo date('d-m-Y',strtotime($value['date'])) ?></td>
                          <td><?php echo $value['data']->vehicle_no ?></td>
                          <td><?php echo 'Opening Balance'; ?></td>
                          <td colspan="5"></td>
                          <td><?php echo $this->config->item('Currency_currency_format') . " " . $this->config->item('currency_format')->formatCurrency($value['data']->vehicle_op_balance, $this->config->item('Currency_currency_shortname')) ?></td>
                          <td></td>
                          <td><?php echo $this->config->item('Currency_currency_format') . " " . $this->config->item('currency_format')->formatCurrency($total_balance, $this->config->item('Currency_currency_shortname')) ?></td>
                        </tr>
                      <?php }
                      if(isset($value['data_type']) && $value['data_type']=='work_slip'){
                        $total_balance += $value['data']->total_payable_amount;
                        $total_payable += $value['data']->total_payable_amount;
                        ?>
                        <tr>
                          <td><?php echo date('d-m-Y',strtotime($value['date'])) ?></td>
                          <td><?php echo $value['data']->vehicle_no ?></td>
                          <td>Work Slip #<?php echo $value['data']->work_slip_id ?></td>
                          <td><?php echo $value['data']->worked_duration ?>
                            <?php
                            if($value['data']->worked_duration_2!=0){
                              echo "<br/>".$value['data']->worked_duration_2;
                            }
                            if($value['data']->worked_duration_3!=0){
                              echo "<br/>".$value['data']->worked_duration_3;
                            }
                            ?>
                          </td>
                          <td><?php echo $value['data']->duration_type ?>
                            <?php
                            if($value['data']->duration_type_2!=0){
                              echo "<br/>".$value['data']->duration_type_2;
                            }
                            if($value['data']->duration_type_3!=0){
                              echo "<br/>".$value['data']->duration_type_3;
                            }
                            ?></td>
                            <td><?php echo $value['data']->load_qty ?></td>
                            <td><?php echo $value['data']->load_qty_in ?></td>
                            <td><?php echo $value['data']->total_load_qty ?></td>
                            <td><?php echo $this->config->item('Currency_currency_format') . " " . $this->config->item('currency_format')->formatCurrency($value['data']->total_payable_amount, $this->config->item('Currency_currency_shortname')) ?></td>
                            <td></td>
                            <td><?php echo $this->config->item('Currency_currency_format') . " " . $this->config->item('currency_format')->formatCurrency($total_balance, $this->config->item('Currency_currency_shortname')) ?></td>
                          </tr>
                        <?php } ?>
                        <?php if(isset($value['data_type']) && $value['data_type']=='payment'){
                          $total_balance -= $value['data']->tr_amount;
                          $total_paid += $value['data']->tr_amount;
                          ?>
                          <tr>
                            <td><?php echo date('d-m-Y',strtotime($value['date'])) ?></td>
                            <td><?php echo $value['data']->vehicle_no ?></td>
                            <td>Towards
                              <?php if($value['data_type_2']=='op_balance_payment')
                              {
                                echo "Opening Balance";
                              }else{
                                echo "Work Slip #".$value['data']->reference_id;
                              }?></td>
                              <td colspan="6">Debited From: <?php echo $value['data']->debit_account ?>, Mode:  <?php echo $value['data']->tr_mode ?>, <?php echo $value['data']->tr_reference_no ?>,<?php if($value['data']->tr_reference_date!='0000-00-00'){ echo date('d-m-Y',strtotime($value['data']->tr_reference_date));} ?> <?php echo $value['data']->tr_remarks ?>,</td>
                              <td><?php echo $this->config->item('Currency_currency_format') . " " . $this->config->item('currency_format')->formatCurrency($value['data']->tr_amount, $this->config->item('Currency_currency_shortname')) ?></td>
                              <td><?php echo $this->config->item('Currency_currency_format') . " " . $this->config->item('currency_format')->formatCurrency($total_balance, $this->config->item('Currency_currency_shortname')) ?></td>
                            </tr>
                          <?php } ?>
                        <?php } ?>

                      <?php } ?>
                      <tr>
                        <td></td>
                        <td></td>
                        <td colspan="5"><strong>Total</strong></td>
                        <td></td>
                        <td><strong><?php echo $this->config->item('Currency_currency_format') . " " . $this->config->item('currency_format')->formatCurrency($total_payable, $this->config->item('Currency_currency_shortname')) ?></strong></td>
                        <td><strong><?php echo $this->config->item('Currency_currency_format') . " " . $this->config->item('currency_format')->formatCurrency($total_paid, $this->config->item('Currency_currency_shortname')) ?></strong></td>
                        <td><strong><?php echo $this->config->item('Currency_currency_format') . " " . $this->config->item('currency_format')->formatCurrency($total_balance, $this->config->item('Currency_currency_shortname')) ?></strong></td>
                      </tr>
                    </tbody>
                  <?php } ?>
                </table>
                <!--end: Datatable -->

              </div>
            </div>
          <?php } ?>


        </div>
      </div>
    </div>
    <!-- end:: Body -->
    <!-- begin::Footer -->

    <?php $this->view("includes/Inc_footer");?>
    <!-- end::Footer -->
  </div>
  <!-- end:: Page -->

  <?php $this->view("includes/Inc_sidebar");?>
  <?php $this->view("includes/Inc_scripts");?>

  <!--begin::Page Snippets -->
  <script>
  $("#accounts_menu").addClass('m-menu__item--open m-menu__item--active');
  $("#accounts_menu_4").addClass('m-menu__item--active');

  $(document).on('click', '#btn_print', function(){
    $(".buttons-print")[0].click(); //trigger the click event
  });

  $("#start_date,#end_date").datepicker( {
    todayHighlight:!0, orientation:"bottom left", templates: {
      leftArrow: '<i class="la la-angle-left"></i>', rightArrow: '<i class="la la-angle-right"></i>'
    }
  })
  <?php if($selected_start_date!=''){?>
    $('#start_date').datepicker("setDate",'<?php echo date('d-m-Y',strtotime($selected_start_date))?>');
    $('#end_date').datepicker("setDate",'<?php echo date('d-m-Y',strtotime($selected_end_date))?>');
    <?php } ?>
    $('body').on('change', '#financial_year', function(e, data) {
      var refresh = true;
      if (data != null){
        refresh = data.refresh;
      }
      if(refresh==true){
        var financial_year_id=$('#financial_year :selected').val();
        $("#financial_year_opbalance_div").hide();
        $('input[type=radio][name=financial_year_opbalance][value=0]').prop('checked',true);
        if(financial_year_id!='all'){
          // $("#financial_year_opbalance_div").show();
          var fin_year = $('#financial_year :selected').text();
          const year = fin_year.split('-');
          var start_date = "01-04-"+year[0];
          var end_date = "31-03-"+year[1];
          var start_date1 = year[0]+", 04 - 1, 01";
          var end_date1 = year[1]+", 03 - 1, 31";
          $('#start_date').datepicker('destroy');
          $('#end_date').datepicker('destroy');
          $("#start_date").datepicker( {
            todayHighlight:!0, orientation:"bottom left", templates: {
              leftArrow: '<i class="la la-angle-left"></i>', rightArrow: '<i class="la la-angle-right"></i>'
            },
            minDate: new Date(start_date1),
            maxDate: new Date(end_date1),
          })
          $("#end_date").datepicker( {
            todayHighlight:!0, orientation:"bottom left", templates: {
              leftArrow: '<i class="la la-angle-left"></i>', rightArrow: '<i class="la la-angle-right"></i>'
            },
            minDate: new Date(start_date1),
            maxDate: new Date(end_date1),
          })
          $('#start_date').datepicker("setDate",start_date);
          $('#end_date').datepicker("setDate",end_date);
        }else{
          $('#start_date').datepicker('destroy');
          $('#end_date').datepicker('destroy');
          $("#start_date").datepicker( {
            todayHighlight:!0, orientation:"bottom left", templates: {
              leftArrow: '<i class="la la-angle-left"></i>', rightArrow: '<i class="la la-angle-right"></i>'
            },
          })
          $("#end_date").datepicker( {
            todayHighlight:!0, orientation:"bottom left", templates: {
              leftArrow: '<i class="la la-angle-left"></i>', rightArrow: '<i class="la la-angle-right"></i>'
            },
          })
          $('#start_date').val('');
          $('#end_date').val('');
        }
      }
    })
    $("#account").select2({
      // dropdownParent: $("#form_purchase_add"),
      placeholder: "Select Account"
    })
    $("#account_category").select2({
      // dropdownParent: $("#form_purchase_add"),
      placeholder: "Select Account Category"
    })
    $("#financial_year").select2({
      // dropdownParent: $("#form_purchase_add"),
      placeholder: "Select Financial Year"
    })
    $("#employee_account_type").select2({
      // dropdownParent: $("#form_purchase_add"),
      placeholder: "Select Account Type"
    })

    $("#form_account_ledger").validate( {
      rules: {
        account: {
          required: !0
        }
      },
      invalidHandler:function(e, r) {
        var i=$("#form_work_msg");
        i.removeClass("m--hide").show(), mUtil.scrollTo(i, -200)
      }
      , submitHandler:function(e) {
        this.submit();
      }
    }
  );

  var ledger_table=function() {
    $('#ledger_view_table').dataTable().fnDestroy();
    var table = $('#ledger_view_table').DataTable({
      "scrollX" : true,
      buttons: [
        { extend: 'print', className: 'btn dark btn-outline',exportOptions: {columns: ':visible'},title: 'Account Ledger' },
        { extend: 'csv', className: 'btn purple btn-outline ' },
        { extend: 'colvis', className: 'btn dark btn-outline', text: 'Columns'}
      ],
      dom:"<'row'<'col-sm-6 text-left'B><'col-sm-6 text-right'f>>\n\t\t\t<'row'<'col-sm-12'tr>>\n\t\t\t<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 dataTables_pager'lp>>", // horizobtal scrollable datatable
      "lengthMenu": [
        [25, 50, 100, -1],
        [25, 50, 100, "All"] // change per page values here
      ],
      // set the initial value
      "pageLength": 25,
      "autoWidth": false,
      "columnDefs": [
        {
          "targets": [ <?php if(isset($selected_account_data->acc_head_name) && $selected_account_data->acc_head_name!='All Account Heads'){ echo 1;}?> ],
          className: "hidden"
        },
        {
          render: function (data, type, full, meta) {
            return "<div class='text-wrap width-500'>" + data + "</div>";
          },
          targets: [ 2 ],
        },
      ],
      'ordering': false
    });
    $(".hide_column").hide();

  }

  jQuery(document).ready(function() {
    $(".hidden").hide();
    <?php if($selected_account!=''){  ?>
      ledger_table();
      <?php } ?>
    });

    function select_ledger_account_heads(select_id,selected_value='',account_category){
      $('#'+select_id).html('');
      $("#"+select_id).append("<option disabled selected >Select Account</option>");
      $.post("<?php echo base_url() ?>accounts/select_ledger_account_heads",{account_category:account_category}
      ,function(data) {
        var obj = $.parseJSON(data);
        var i=0;
        if(obj.count>0) {
          while (i < obj.data.length) {
            var account_type = '';
            if(obj.data[i]['department']!='' && obj.data[i]['department']!=undefined){
              account_type = ' ['+obj.data[i]['department']+']';
              if(obj.data[i]['designation']!='' && obj.data[i]['designation']!=null && obj.data[i]['designation']!=undefined){
                account_type += '['+obj.data[i]['designation']+']';
              }
            }else if(obj.data[i]['account_type_display']!=''){
              account_type = ' ['+obj.data[i]['account_type_display']+']';
            }
            $("#"+select_id).append("<option value=" + obj.data[i]['acc_head_id'] + ">" + obj.data[i]['acc_head_name'] +account_type+ "</option>");
            i++;
          }
          if(selected_value!=''){
            $("#"+select_id).val(selected_value).trigger("change");
          }
        }
      })
    }
    $('body').on('change', '#account_category', function() {
      var account_category=$('#account_category :selected').val();
      $("#employee_account_type").html("");
      if(account_category=='Employee'){
        $("#employee_account_type_div").show();
        $("#employee_account_type").attr('required',true);

        $("#employee_account_type").append("<option selected disabled value=''>Select Account Type</option>");
        $("#employee_account_type").append("<option value='Salary'>Salary</option>");
        $("#employee_account_type").append("<option value='Petty Cash'>Petty Cash</option>");
        <?php if($this->config->item('HR_salary_slip_template')==5){ ?>
          $("#employee_account_type").append("<option value='Bata'>Bata</option>");
          $("#employee_account_type").append("<option value='Bonus'>Bonus</option>");
          $("#employee_account_type").append("<option value='Deposit'>Deposit</option>");
          $("#employee_account_type").append("<option value='Loan'>Loan</option>");
          $("#employee_account_type").append("<option value='Others'>Others</option>");
          <?php } ?>
        }else{
          $("#employee_account_type_div").hide();
          $("#employee_account_type").removeAttr('required',true);
        }
        select_ledger_account_heads('account','<?php if($selected_account!=''){echo $selected_account;}elseif($dropdown_selected_account!=''){ echo $dropdown_selected_account;}  ?>',account_category);
        <?php if($selected_employee_account_type!=''){?>
          $('#employee_account_type').val('<?php echo $selected_employee_account_type?>').change();
          <?php } ?>
        })
        <?php if($selected_account_category!=''){?>
          $('#account_category').val('<?php echo $selected_account_category?>').change();
          <?php } ?>
          <?php if($selected_financial_year!='' && $selected_financial_year!='all'){?>
            $('#financial_year').val('<?php echo $selected_financial_year?>').trigger('change', [{refresh:false}]);
            <?php } ?>
            </script>
