<?php $this->view("includes/Inc_pagehead"); ?>
<!-- Page Styles Goes Here-->

<?php $this->view("includes/Inc_navigation"); ?>
<div class="m-grid__item m-grid__item--fluid m-wrapper">
  <!-- BEGIN: Subheader -->
  <div class="m-subheader ">
    <div class="d-flex align-items-center">
      <div class="mr-auto">
        <h3 class="m-subheader__title m-subheader__title--separator">
          Account Heads
        </h3>
        <ul class="m-subheader__breadcrumbs m-nav m-nav--inline">
          <li class="m-nav__item m-nav__item--home">
            <a href="#" class="m-nav__link m-nav__link--icon">
              <i class="m-nav__link-icon la la-home"></i>
            </a>
          </li>
          <li class="m-nav__separator">
            -
          </li>
          <li class="m-nav__item">
            <a href="<?php echo base_url() . 'dashboard' ?>" class="m-nav__link">
              <span class="m-nav__link-text">
                Home
              </span>
            </a>
          </li>
          <li class="m-nav__separator">
            -
          </li>
          <li class="m-nav__item">
            <a href="<?php echo base_url() . 'expenses/types' ?>" class="m-nav__link">
              <span class="m-nav__link-text">
                Account Heads
              </span>
            </a>
          </li>
        </ul>
      </div>
      <div>
      </div>
    </div>
  </div>
  <!-- END: Subheader -->
  <div class="m-content">
    <div class="m-portlet m-portlet--mobile m-portlet--info m-portlet--head-solid-bg m-portlet--bordered m-portlet--rounded">
      <div class="m-portlet__head">
        <div class="m-portlet__head-caption">
          <div class="m-portlet__head-title">
            <h3 class="m-portlet__head-text">
              List of Account Heads
            </h3>
          </div>
        </div>
        <div class="m-portlet__head-tools">
          <?php if ($this->session->userdata('user_role') != 'auditor' || $this->session->userdata('user_data_permission')['adding'] == 1) { ?>
            <a href="#" data-toggle="modal" data-target="#account_head_add_modal" class="btn btn-focus m-btn m-btn--custom m-btn--icon m-btn--air m-btn--pill">
              <span>
                <i class="la la-plus"></i>
                <span>
                  Add New Account Head
                </span>
              </span>
            </a>
          <?php } ?>

        </div>
      </div>
      <div class="m-portlet__body">

        <?php if (!empty($this->config->item('company_branches'))) { ?>
          <!--begin: Search Form -->
          <div class="m-form m-form--label-align-right m--margin-bottom-10">
            <div class="row">
              <div class="col-xl-12 order-2 order-xl-1">
                <div class="form-group m-form__group row ">
                  <div class="col-lg-4">
                    <div class="form-group m-form__group">
                      <label>
                        Company Branch
                      </label>
                      <div class="m-select2 m-select2--air m-select2--pill">
                        <select width="100%" required class="form-control m-select2 table_filter company-branch-select2" id="company_branch">
                          <option selected value="all"> All Branches</option>
                          <option value="0">NO BRANCH</option>
                          <?php foreach ($this->config->item('company_branches') as $key => $value) { ?>
                            <option value="<?php echo $value->branch_id ?>"><?php echo $value->branch_name ?></option>
                          <?php } ?>
                        </select>
                      </div>
                      <span class="m-form__help"></span>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        <?php } ?>

        <!--begin: Datatable -->
        <table width="100%" class="table m-table nowrap table-header-fixed table-striped table-bordered table-hover table-header-fixed" id="acc_head_view_table">
          <thead>
            <tr class="">
              <th>Sl No</th>
              <th>Branch</th>
              <th>Account Head Id</th>
              <th>Account Head Name</th>
              <th>Account Type</th>
              <th>Account Type</th>
              <th>Op Balance</th>
              <th>Op Balance Date</th>
              <th>Current Balance</th>
              <th>Head Editable</th>
              <th>Created On</th>
              <th>Actions</th>
            </tr>
          </thead>
          <tbody>
          </tbody>
        </table>
        <!--end: Datatable -->
        <div class="modal fade" tabindex="-1" id="account_head_add_modal" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
          <div class="modal-dialog " role="document" style="max-width: 800px">
            <div class="modal-content">
              <div class="modal-header" style="background-color: #36a3f7;border-radius: 4px">
                <h5 class="modal-title" id="exampleModalLabel" style="color: #ffffff">
                  Create Account Head
                </h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                  <span aria-hidden="true">
                    &times;
                  </span>
                </button>
              </div>
              <form id="form_account_head_add" data-modal-id="account_head_add_modal" method="post" action="<?php echo base_url() . 'accounts/create_head' ?>" enctype="multipart/form-data" class="m-form m-form--fit m-form--state m-form--label-align-right ">
                <div class="modal-body">
                  <div class="m-form__content">
                    <div class="m-alert m-alert--icon alert alert-warning m--hide" role="alert" id="form_account_head_add_msg">
                      <div class="m-alert__icon">
                        <i class="la la-warning"></i>
                      </div>
                      <div class="m-alert__text">
                        Oh snap! Change a few things up and try submitting again.
                      </div>
                      <div class="m-alert__close">
                        <button type="button" class="close" data-close="alert" aria-label="Close"></button>
                      </div>
                    </div>
                  </div>
                  <div class="row">
                    <div class="col-lg-12">
                      <div class="form-group m-form__group">
                        <label for="user_name">
                          Account Type
                        </label>
                        <div class="m-select2 m-select2--air m-select2--pill ">
                          <select required style="width: 100%" class="form-control m-select2" id="acc_type" name="acc_type" data-placeholder="Select User Type">
                            <option selected disabled>Select Account Type</option>
                            <option value="36">Bank Account</option>
                            <option value="11">Expense Account</option>
                          </select>
                        </div>
                        <span class="m-form__help"></span>
                      </div>
                    </div>
                    <div class="col-lg-12">
                      <div class="form-group m-form__group">
                        <label for="user_name">
                          Account Head Name </label>
                          <div class="input-group m-input-group m-input-group--pill m-input-group--air">
                            <div class="input-group-prepend">
                              <span class="input-group-text" id="basic-addon1">
                                <i class="la la-tag"></i>
                              </span>
                            </div>
                            <input required type="text" name="acc_head" id="acc_head" class="form-control m-input" placeholder="Account Head Name" aria-describedby="basic-addon1">
                          </div>
                          <span class="m-form__help"></span>
                        </div>
                      </div>
                      <div class="col-lg-6">
                        <div class="form-group m-form__group">
                          <label for="user_name">
                            Opening Balance
                          </label>
                          <div class="input-group m-input-group m-input-group--pill m-input-group--air">
                            <div class="input-group-prepend">
                              <span class="input-group-text" id="basic-addon1">
                                <?php echo $this->config->item('Currency_currency_format'); ?>
                              </span>
                            </div>
                            <input required value="0" type="text" name="op_balance" class="form-control m-input" placeholder="Opening Balance" aria-describedby="basic-addon1">
                          </div>
                          <span class="m-form__help"></span>
                        </div>
                      </div>
                      <div class="col-lg-6">
                        <div class="form-group m-form__group transaction_details_div" >
                          <label for="user_name">
                            OP Balance Date
                          </label>
                          <div class="input-group m-input-group--pill m-input-group--air date">
                            <div class="input-group-prepend">
                              <span class="input-group-text">
                                <i class="la la-calendar"></i>
                              </span>
                            </div>
                            <input  data-date-format="dd-mm-yyyy" id="op_balance_date_add" required  type="text" name="op_balance_date" class="form-control m-input transaction_required_fields  " placeholder="OP Balance Date" >
                          </div>
                          <span class="m-form__help"></span>
                        </div>
                      </div>
                    </div>
                  </div>
                  <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">
                      Close
                    </button>
                    <button type="submit" class="btn btn-primary form_submit_btn">
                      Submit
                    </button>
                  </div>
                </form>
              </div>
            </div>
          </div>

          <div class="modal fade" tabindex="-1" id="acc_head_edit_modal" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
            <div class="modal-dialog " role="document" style="max-width: 800px">
              <div class="modal-content">
                <div class="modal-header" style="background-color: #00c5dc;border-radius: 4px">
                  <h5 class="modal-title" id="exampleModalLabel" style="color: #ffffff">
                    Edit Account Head
                  </h5>
                  <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">
                      &times;
                    </span>
                  </button>
                </div>
                <form id="form_account_head_edit" data-modal-id="acc_head_edit_modal" method="post" action="<?php echo base_url() . 'accounts/update_head' ?>" enctype="multipart/form-data" class="m-form m-form--fit m-form--state m-form--label-align-right ">
                  <div class="modal-body">
                    <div class="m-form__content">
                      <div class="m-alert m-alert--icon alert alert-warning m--hide" role="alert" id="form_account_head_edit_msg">
                        <div class="m-alert__icon">
                          <i class="la la-warning"></i>
                        </div>
                        <div class="m-alert__text">
                          Oh snap! Change a few things up and try submitting again.
                        </div>
                        <div class="m-alert__close">
                          <button type="button" class="close" data-close="alert" aria-label="Close"></button>
                        </div>
                      </div>
                    </div>
                    <div class="row">
                      <div class="col-lg-12">
                        <div class="form-group m-form__group" id="account_type_edit_div">
                          <label for="user_name">
                            Account Type
                          </label>
                          <div class="m-select2 m-select2--air m-select2--pill ">
                            <select required style="width: 100%" class="form-control m-select2" id="acc_type_edit" name="acc_type" data-placeholder="Select User Type">
                              <option selected disabled>Select Account Type</option>
                              <option value="36">Bank Account</option>
                              <option value="11">Expense Account</option>
                            </select>
                          </div>
                          <span class="m-form__help"></span>
                        </div>
                        <div class="form-group m-form__group" id="account_type_edit_info_div" style="display: none">
                          <label for="material_name">
                            Account Type
                          </label>
                          <div class="input-group m-input-group m-input-group--pill m-input-group--air">
                            <input readonly type="text" id="account_type_edit_info" class="form-control m-input" aria-describedby="basic-addon1">
                          </div>
                          <span class="m-form__help"></span>
                        </div>
                      </div>
                      <div class="col-lg-12">
                        <div class="form-group m-form__group">
                          <label for="material_name">
                            Account Head
                          </label>
                          <div class="input-group m-input-group m-input-group--pill m-input-group--air">
                            <input required type="text" name="acc_head" id="edit_acc_head_name" class="form-control m-input" placeholder="Account Head Name" aria-describedby="basic-addon1">
                          </div>
                          <span class="m-form__help"></span>
                        </div>
                      </div>
                      <div class="col-lg-6">
                        <div class="form-group m-form__group">
                          <label for="user_name">
                            Opening Balance
                          </label>
                          <div class="input-group m-input-group m-input-group--pill m-input-group--air">
                            <div class="input-group-prepend">
                              <span class="input-group-text" id="basic-addon1">
                                <?php echo $this->config->item('Currency_currency_format'); ?>
                              </span>
                            </div>
                            <input required value="0" type="text" name="op_balance" id="op_balance" class="form-control m-input" placeholder="Opening Balance" aria-describedby="basic-addon1">
                          </div>
                          <span class="m-form__help"></span>
                        </div>
                      </div>
                      <div class="col-lg-6">
                        <div class="form-group m-form__group transaction_details_div" >
                          <label for="user_name">
                            OP Balance Date
                          </label>
                          <div class="input-group m-input-group--pill m-input-group--air date">
                            <div class="input-group-prepend">
                              <span class="input-group-text">
                                <i class="la la-calendar"></i>
                              </span>
                            </div>
                            <input  data-date-format="dd-mm-yyyy" id="op_balance_date_edit" required  type="text" name="op_balance_date" class="form-control m-input transaction_required_fields  " placeholder="OP Balance Date" >
                          </div>
                          <span class="m-form__help"></span>
                        </div>
                      </div>
                      <input type="hidden" name="acc_head_id" id="edit_acc_head_id">
                      <input type="hidden" name="redirect_url" value="<?php echo base_url(uri_string()) ?>">
                    </div>
                  </div>
                  <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">
                      Close
                    </button>
                    <button type="submit" class="btn btn-primary form_submit_btn">
                      Submit
                    </button>
                  </div>
                </form>
              </div>
            </div>
          </div>
          <div class="modal fade" tabindex="-1" id="acc_head_delete_modal" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
            <div class="modal-dialog " role="document">
              <form autocomplete="off" method="post" data-modal-id="acc_head_delete_modal" id="form_acc_head_delete" action="<?php echo base_url() . 'accounts/delete_head' ?>" class="form-horizontal">
                <div class="modal-content">
                  <div class="alert alert-danger" role="alert" style="margin-bottom: 0px">
                    <button type="button" class="close" data-dismiss="modal"></button>
                    <br />
                    <h4 class="alert-heading">Warning! Please Confirm Your Action</h4>
                    <br />
                    <p> Are You Sure to Delete this Data ?. All the Associated Data will Lost. </p>
                    <p>
                      <button class="btn btn-danger form_submit_btn" type="submit" name="submit">Confirm & Delete</button>
                      <button type="button" class="btn btn-primary modal-dismiss" data-dismiss="modal">Cancel</button>
                    </p>
                    <input type="hidden" name="redirect_url" value="<?php echo base_url(uri_string()) ?>">
                    <input type="hidden" name="acc_head_id" id="acc_head_id_delete">
                  </div>
                </div>
              </form>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>
<!-- end:: Body -->
<!-- begin::Footer -->

<?php $this->view("includes/Inc_footer"); ?>
<!-- end::Footer -->
</div>
<!-- end:: Page -->

<?php $this->view("includes/Inc_sidebar"); ?>
<?php $this->view("includes/Inc_scripts"); ?>

<!--begin::Page Snippets -->
<script>
$("#accounts_menu").addClass('m-menu__item--open m-menu__item--active');
$("#accounts_menu_1").addClass('m-menu__item--active');

$('body').on('click', '#acc_head_delete_btn', function() {
  var no = $(this).closest('tr').children('td');
  $('#acc_head_id_delete').val(no.eq(2).text());
})
$("#acc_type").select2({
  placeholder: "Select Account Type",
  dropdownParent: $("#form_account_head_add")
})

$("#acc_type_edit").select2({
  placeholder: "Select Account Type",
  dropdownParent: $("#form_account_head_edit")
})

$("#op_balance_date_add,#op_balance_date_edit").datepicker( {
  todayHighlight:!0, orientation:"bottom left", templates: {
    leftArrow: '<i class="la la-angle-left"></i>', rightArrow: '<i class="la la-angle-right"></i>'
  },
  endDate: '+0d',
  })
//   List Data Table
var Datatable = function() {
  var t = function() {
    function GetSearchStatus() {
      return $('#table_filter_status').val();
    }

    function get_branch_id() {
      return $('#company_branch :selected').val();
    }
    var table = $('#acc_head_view_table').DataTable({
      "ajax": {
        url: "<?php echo base_url() . 'accounts/select_heads' ?>", // json datasource
        type: "post", // type of method  , by default would be get
        data: function(d) {
          //                         d.status = GetSearchStatus();
          <?php if (!empty($this->config->item('company_branches'))) { ?>
            d.branch_id = get_branch_id();
            <?php } ?>
          }
        },
        "bProcessing": true,
        "deferRender": true,
        "bDeferRender": true,
        "scrollX": true,
        buttons: [{
          extend: 'print',
          className: 'btn dark btn-outline',
          exportOptions: {
            columns: ':visible'
          },
          title: 'Accout Heads'
        },
        {
          extend: 'csv',
          className: 'btn purple btn-outline '
        },
        {
          extend: 'colvis',
          className: 'btn dark btn-outline',
          text: 'Columns'
        }
      ],
      dom: "<'row'<'col-sm-6 text-left'B><'col-sm-6 text-right'f>>\n\t\t\t<'row'<'col-sm-12'tr>>\n\t\t\t<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 dataTables_pager'lp>>",
      "lengthMenu": [
        [25, 50, 100, -1],
        [25, 50, 100, "All"] // change per page values here
      ],
      // set the initial value
      "pageLength": 25,
      "columnDefs": [{
        "targets": [2, 5, 8, 9 <?php if (empty($this->config->item('company_branches'))) {
          echo ",1";
        } ?>],
        className: "hidden"
      }],
      'order': []
    });
    $(".table_filter").on("change", function() {
      table.ajax.reload();
    });
    $(".hide_column").hide();
  };
  return {
    init: function() {
      t()
    }
  }
}

();
jQuery(document).ready(function() {
  Datatable.init();
  $(".hidden").hide();
  //            $('#service_view_table').wrap("");
}

);
</script>
<script>
$('body').on('click', '#acc_head_edit_btn', function() {
  var no = $(this).closest('tr').children('td');
  var head_editable = no.eq(9).text();
  $('#edit_acc_head_id').val(no.eq(2).text());
  $('#edit_acc_head_name').val(no.eq(3).text());
  $('#op_balance').val(no.eq(6).text());
  $('#op_balance_date_edit').datepicker("setDate",no.eq(7).text());
  if (head_editable == 1) {
    $('#acc_type_edit').val(no.eq(5).text()).trigger('change');
    $("#account_type_edit_div").show();
    $('#acc_type_edit').attr('required', true);
    $("#account_type_edit_info_div").hide();
    $('#edit_acc_head_name').removeAttr('readonly', true);
  } else {
    $('#account_type_edit_info').val(no.eq(4).text());
    $("#account_type_edit_info_div").show();
    $('#acc_type_edit').removeAttr('required', true);
    $("#account_type_edit_div").hide();
    $('#edit_acc_head_name').attr('readonly', true);
  }
})
</script>
<script>
$("#form_account_head_add").validate({
  rules: {
    acc_head: {
      required: !0
    },
    op_balance: {
      required: !0,
      number: !0
    }
  },
  invalidHandler: function(e, r) {
    var i = $("#form_account_head_add_msg");
    i.removeClass("m--hide").show(), mUtil.scrollTo(i, -200)
  },
  submitHandler: function(e) {

    this.submit();
  }
});
$("#form_account_head_edit").validate({
  rules: {
    acc_head: {
      required: !0
    },
    op_balance: {
      required: !0,
      number: !0
    }
  },
  invalidHandler: function(e, r) {
    var i = $("#form_account_head_edit_msg");
    i.removeClass("m--hide").show(), mUtil.scrollTo(i, -200)
  },
  submitHandler: function(e) {

    this.submit();
  }
});


</script>
