<?php
class Work_order_model extends CI_Model
{
  function __construct()
  {
    parent::__construct();
  }

  public function select_work_orders($columns='*',$data='')
  {
    $this->db->select($columns)->from('work_order wo');
    $this->db->join('customers c','c.customer_id=wo.customer_id','left');
    $this->db->join('tax_state_codes tsc','tsc.state_id=c.customer_tax_state','left');
    $this->db->join('tax_types tt','wo.tax_percent=tt.tax_id','left');
    $this->db->join('users u','wo.created_by=u.user_id','left');
    $this->db->join('users u2','wo.site_coordinator=u2.user_id','left');
    $this->db->join('users u3','wo.prepared_by=u3.user_id','left');
    $this->db->join('bank_account_details ba','ba.account_id=wo.bank_account','left');
    $this->db->join('sales_quotations sq','sq.quotation_id=wo.quotation_id','left');
    $this->db->join('branches b','b.branch_id=sq.branch_id','left');
    if(!empty($data)){
      $this->db->where($data);
    }
    $this->db->where('wo.delete_status',0);
    if ($this->session->userdata('branch_id') != 0) {
      $this->db->where('wo.branch_id', $this->session->userdata('branch_id'));
    }
    $this->db->order_by("wo.order_id",'desc');
    $query = $this->db->get();
    return $query;
  }
  public function insert_work_order($data){
    if ($this->session->userdata('branch_id') != 0) {
      $data['branch_id'] = $this->session->userdata('branch_id');
    }
    $query = $this->db->insert('work_order', $data);
    $result=array();
    $result['insert_id']=$this->db->insert_id();
    $result['status']=$query;
    return $result;
  }
  public function update_work_order($data)
  {
    $this->db->where('order_id', $data['order_id']);
    if ($this->session->userdata('branch_id') != 0) {
      $this->db->where('branch_id',$this->session->userdata('branch_id'));
    }
    $query=$this->db->update('work_order', $data);
    return $query;
  }

  public function select_work_order_items($columns='*',$data='')
  {
    $this->db->select($columns)->from('work_order_items woi');
    $this->db->join('work_order wo','wo.order_id=woi.order_id','left');
    $this->db->join('measure_units mu','woi.unit=mu.unit_id','left');
    $this->db->join('work_types wt','woi.work_type_id=wt.type_id','left');
    if(!empty($data)){
      $this->db->where($data);
    }
    $this->db->where('woi.delete_status',0);
    $this->db->where('wo.delete_status',0);
    $query = $this->db->get();
    return $query;
  }
  public function insert_work_order_item($data){
    $query = $this->db->insert('work_order_items', $data);
    $result=array();
    $result['insert_id']=$this->db->insert_id();
    $result['status']=$query;
    return $result;
  }
  public function update_work_order_item($data)
  {
    $this->db->where('item_id', $data['item_id']);
    $query=$this->db->update('work_order_items', $data);
    return $query;
  }

}
?>
